// third_party/blink/public/mojom/widget/visual_properties.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_WIDGET_VISUAL_PROPERTIES_MOJOM_DATA_VIEW_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_WIDGET_VISUAL_PROPERTIES_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/blink/public/mojom/widget/visual_properties.mojom-shared-internal.h"
#include "cc/mojom/browser_controls_params.mojom-shared.h"
#include "services/viz/public/mojom/compositing/local_surface_id.mojom-shared.h"
#include "third_party/blink/public/mojom/manifest/display_mode.mojom-shared.h"
#include "ui/display/mojom/screen_infos.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "ui/base/mojom/window_show_state.mojom-shared.h"


namespace blink::mojom {
class VisualPropertiesDataView;



}  // blink::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::VisualPropertiesDataView> {
  using Data = ::blink::mojom::internal::VisualProperties_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace blink::mojom {


class VisualPropertiesDataView {
 public:
  VisualPropertiesDataView() = default;

  VisualPropertiesDataView(
      internal::VisualProperties_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetScreenInfosDataView(
      ::display::mojom::ScreenInfosDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadScreenInfos(UserType* output) {
    
    auto* pointer = data_->screen_infos.Get();
    return mojo::internal::Deserialize<::display::mojom::ScreenInfosDataView>(
        pointer, output, message_);
  }
  bool auto_resize_enabled() const {
    return data_->auto_resize_enabled;
  }
  bool resizable() const {
    return data_->resizable;
  }
  inline void GetMinSizeForAutoResizeDataView(
      ::gfx::mojom::SizeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMinSizeForAutoResize(UserType* output) {
    
    auto* pointer = data_->min_size_for_auto_resize.Get();
    return mojo::internal::Deserialize<::gfx::mojom::SizeDataView>(
        pointer, output, message_);
  }
  inline void GetMaxSizeForAutoResizeDataView(
      ::gfx::mojom::SizeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMaxSizeForAutoResize(UserType* output) {
    
    auto* pointer = data_->max_size_for_auto_resize.Get();
    return mojo::internal::Deserialize<::gfx::mojom::SizeDataView>(
        pointer, output, message_);
  }
  inline void GetNewSizeDevicePxDataView(
      ::gfx::mojom::SizeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadNewSizeDevicePx(UserType* output) {
    
    auto* pointer = data_->new_size_device_px.Get();
    return mojo::internal::Deserialize<::gfx::mojom::SizeDataView>(
        pointer, output, message_);
  }
  inline void GetVisibleViewportSizeDevicePxDataView(
      ::gfx::mojom::SizeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadVisibleViewportSizeDevicePx(UserType* output) {
    
    auto* pointer = data_->visible_viewport_size_device_px.Get();
    return mojo::internal::Deserialize<::gfx::mojom::SizeDataView>(
        pointer, output, message_);
  }
  inline void GetCompositorViewportPixelRectDataView(
      ::gfx::mojom::RectDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCompositorViewportPixelRect(UserType* output) {
    
    auto* pointer = data_->compositor_viewport_pixel_rect.Get();
    return mojo::internal::Deserialize<::gfx::mojom::RectDataView>(
        pointer, output, message_);
  }
  inline void GetBrowserControlsParamsDataView(
      ::cc::mojom::BrowserControlsParamsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBrowserControlsParams(UserType* output) {
    
    auto* pointer = data_->browser_controls_params.Get();
    return mojo::internal::Deserialize<::cc::mojom::BrowserControlsParamsDataView>(
        pointer, output, message_);
  }
  bool scroll_focused_node_into_view() const {
    return data_->scroll_focused_node_into_view;
  }
  inline void GetLocalSurfaceIdDataView(
      ::viz::mojom::LocalSurfaceIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLocalSurfaceId(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::viz::mojom::LocalSurfaceIdDataView, UserType>(),
    "Attempting to read the optional `local_surface_id` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadLocalSurfaceId` instead "
    "of `ReadLocalSurfaceId if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->local_surface_id.Get();
    return mojo::internal::Deserialize<::viz::mojom::LocalSurfaceIdDataView>(
        pointer, output, message_);
  }
  bool is_fullscreen_granted() const {
    return data_->is_fullscreen_granted;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadDisplayMode(UserType* output) const {
    auto data_value = data_->display_mode;
    return mojo::internal::Deserialize<::blink::mojom::DisplayMode>(
        data_value, output);
  }
  ::blink::mojom::DisplayMode display_mode() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::DisplayMode>(data_->display_mode));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadWindowShowState(UserType* output) const {
    auto data_value = data_->window_show_state;
    return mojo::internal::Deserialize<::ui::mojom::WindowShowState>(
        data_value, output);
  }
  ::ui::mojom::WindowShowState window_show_state() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::ui::mojom::WindowShowState>(data_->window_show_state));
  }
  uint32_t capture_sequence_number() const {
    return data_->capture_sequence_number;
  }
  double zoom_level() const {
    return data_->zoom_level;
  }
  double css_zoom_factor() const {
    return data_->css_zoom_factor;
  }
  float page_scale_factor() const {
    return data_->page_scale_factor;
  }
  float compositing_scale_factor() const {
    return data_->compositing_scale_factor;
  }
  float cursor_accessibility_scale_factor() const {
    return data_->cursor_accessibility_scale_factor;
  }
  inline void GetRootWidgetViewportSegmentsDataView(
      mojo::ArrayDataView<::gfx::mojom::RectDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRootWidgetViewportSegments(UserType* output) {
    
    auto* pointer = data_->root_widget_viewport_segments.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::gfx::mojom::RectDataView>>(
        pointer, output, message_);
  }
  bool is_pinch_gesture_active() const {
    return data_->is_pinch_gesture_active;
  }
  inline void GetWindowControlsOverlayRectDataView(
      ::gfx::mojom::RectDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadWindowControlsOverlayRect(UserType* output) {
    
    auto* pointer = data_->window_controls_overlay_rect.Get();
    return mojo::internal::Deserialize<::gfx::mojom::RectDataView>(
        pointer, output, message_);
  }
  uint32_t virtual_keyboard_resize_height_device_px() const {
    return data_->virtual_keyboard_resize_height_device_px;
  }
 private:
  internal::VisualProperties_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // blink::mojom

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_WIDGET_VISUAL_PROPERTIES_MOJOM_DATA_VIEW_H_