// third_party/blink/public/mojom/widget/platform_widget.mojom-lite-for-compile.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';

goog.require('mojo.internal');
goog.require('mojo.internal.interfaceSupport');

goog.require('ui.mojom.MenuSourceType');
goog.require('mojoBase.mojom.TextDirection');
goog.require('viz.mojom.CompositorFrameSink');
goog.require('viz.mojom.CompositorFrameSinkClient');
goog.require('viz.mojom.InputTargetClient');
goog.require('cc.mojom.RenderFrameMetadataObserver');
goog.require('cc.mojom.RenderFrameMetadataObserverClient');
goog.require('blink.mojom.WidgetInputHandler');
goog.require('blink.mojom.WidgetInputHandlerHost');
goog.require('ui.mojom.Cursor');
goog.require('gfx.mojom.Point');
goog.require('blink.mojom.RecordContentToVisibleTimeRequest');
goog.require('gfx.mojom.Rect');
goog.require('mojoBase.mojom.String16');
goog.require('ui.mojom.TextInputState');
goog.require('blink.mojom.VisualProperties');






goog.provide('blink.mojom.WidgetCompositor');
goog.provide('blink.mojom.WidgetCompositorReceiver');
goog.provide('blink.mojom.WidgetCompositorCallbackRouter');
goog.provide('blink.mojom.WidgetCompositorInterface');
goog.provide('blink.mojom.WidgetCompositorRemote');
goog.provide('blink.mojom.WidgetCompositorPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.WidgetCompositorPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.WidgetCompositor.$interfaceName,
        scope);
  }
};

/** @interface */
blink.mojom.WidgetCompositorInterface = class {
  
  /**
   * @return {!Promise}
   */

  visualStateRequest() {}
};

/**
 * @export
 * @implements { blink.mojom.WidgetCompositorInterface }
 */
blink.mojom.WidgetCompositorRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.WidgetCompositorPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.WidgetCompositorPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.WidgetCompositorPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @return {!Promise}
   */

  visualStateRequest() {
    return this.proxy.sendMessage(
        0,
        blink.mojom.WidgetCompositor_VisualStateRequest_ParamsSpec.$,
        blink.mojom.WidgetCompositor_VisualStateRequest_ResponseParamsSpec.$,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the WidgetCompositor
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.WidgetCompositorReceiver = class {
  /**
   * @param {!blink.mojom.WidgetCompositorInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.WidgetCompositorRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.WidgetCompositorRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.WidgetCompositorRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.WidgetCompositor_VisualStateRequest_ParamsSpec.$,
        blink.mojom.WidgetCompositor_VisualStateRequest_ResponseParamsSpec.$,
        impl.visualStateRequest.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.WidgetCompositor = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.WidgetCompositor";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.WidgetCompositorRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.WidgetCompositorRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the WidgetCompositor
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.WidgetCompositorCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.WidgetCompositorRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.WidgetCompositorRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.visualStateRequest =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.WidgetCompositor_VisualStateRequest_ParamsSpec.$,
        blink.mojom.WidgetCompositor_VisualStateRequest_ResponseParamsSpec.$,
        this.visualStateRequest.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('blink.mojom.WidgetHost');
goog.provide('blink.mojom.WidgetHostReceiver');
goog.provide('blink.mojom.WidgetHostCallbackRouter');
goog.provide('blink.mojom.WidgetHostInterface');
goog.provide('blink.mojom.WidgetHostRemote');
goog.provide('blink.mojom.WidgetHostPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.WidgetHostPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.WidgetHost.$interfaceName,
        scope);
  }
};

/** @interface */
blink.mojom.WidgetHostInterface = class {
  
  /**
   * @param { !ui.mojom.Cursor } cursor
   */

  setCursor(cursor) {}
  
  /**
   * @param { !mojoBase.mojom.String16 } tooltipText
   * @param { !mojoBase.mojom.TextDirection } textDirectionHint
   */

  updateTooltipUnderCursor(tooltipText, textDirectionHint) {}
  
  /**
   * @param { !mojoBase.mojom.String16 } tooltipText
   * @param { !mojoBase.mojom.TextDirection } textDirectionHint
   * @param { !gfx.mojom.Rect } bounds
   */

  updateTooltipFromKeyboard(tooltipText, textDirectionHint, bounds) {}
  
  /**
   */

  clearKeyboardTriggeredTooltip() {}
  
  /**
   * @param { !ui.mojom.TextInputState } state
   */

  textInputStateChanged(state) {}
  
  /**
   * @param { !gfx.mojom.Rect } anchorRect
   * @param { !mojoBase.mojom.TextDirection } anchorDir
   * @param { !gfx.mojom.Rect } focusRect
   * @param { !mojoBase.mojom.TextDirection } focusDir
   * @param { !gfx.mojom.Rect } boundingBoxRect
   * @param { !boolean } isAnchorFirst
   */

  selectionBoundsChanged(anchorRect, anchorDir, focusRect, focusDir, boundingBoxRect, isAnchorFirst) {}
  
  /**
   * @param { !viz.mojom.CompositorFrameSinkPendingReceiver } compositorFrameSinkReceiver
   * @param { !viz.mojom.CompositorFrameSinkClientRemote } compositorFrameSinkClient
   * @param { !blink.mojom.RenderInputRouterClientRemote } renderInputRouterClient
   */

  createFrameSink(compositorFrameSinkReceiver, compositorFrameSinkClient, renderInputRouterClient) {}
  
  /**
   * @param { !cc.mojom.RenderFrameMetadataObserverClientPendingReceiver } renderFrameMetadataObserverClientReceiver
   * @param { !cc.mojom.RenderFrameMetadataObserverRemote } renderFrameMetadataObserver
   */

  registerRenderFrameMetadataObserver(renderFrameMetadataObserverClientReceiver, renderFrameMetadataObserver) {}
};

/**
 * @export
 * @implements { blink.mojom.WidgetHostInterface }
 */
blink.mojom.WidgetHostRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.WidgetHostPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.WidgetHostPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.WidgetHostPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !ui.mojom.Cursor } cursor
   */

  setCursor(
      cursor) {
    this.proxy.sendMessage(
        0,
        blink.mojom.WidgetHost_SetCursor_ParamsSpec.$,
        null,
        [
          cursor
        ],
        false);
  }

  
  /**
   * @param { !mojoBase.mojom.String16 } tooltipText
   * @param { !mojoBase.mojom.TextDirection } textDirectionHint
   */

  updateTooltipUnderCursor(
      tooltipText,
      textDirectionHint) {
    this.proxy.sendMessage(
        1,
        blink.mojom.WidgetHost_UpdateTooltipUnderCursor_ParamsSpec.$,
        null,
        [
          tooltipText,
          textDirectionHint
        ],
        false);
  }

  
  /**
   * @param { !mojoBase.mojom.String16 } tooltipText
   * @param { !mojoBase.mojom.TextDirection } textDirectionHint
   * @param { !gfx.mojom.Rect } bounds
   */

  updateTooltipFromKeyboard(
      tooltipText,
      textDirectionHint,
      bounds) {
    this.proxy.sendMessage(
        2,
        blink.mojom.WidgetHost_UpdateTooltipFromKeyboard_ParamsSpec.$,
        null,
        [
          tooltipText,
          textDirectionHint,
          bounds
        ],
        false);
  }

  
  /**
   */

  clearKeyboardTriggeredTooltip() {
    this.proxy.sendMessage(
        3,
        blink.mojom.WidgetHost_ClearKeyboardTriggeredTooltip_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !ui.mojom.TextInputState } state
   */

  textInputStateChanged(
      state) {
    this.proxy.sendMessage(
        4,
        blink.mojom.WidgetHost_TextInputStateChanged_ParamsSpec.$,
        null,
        [
          state
        ],
        false);
  }

  
  /**
   * @param { !gfx.mojom.Rect } anchorRect
   * @param { !mojoBase.mojom.TextDirection } anchorDir
   * @param { !gfx.mojom.Rect } focusRect
   * @param { !mojoBase.mojom.TextDirection } focusDir
   * @param { !gfx.mojom.Rect } boundingBoxRect
   * @param { !boolean } isAnchorFirst
   */

  selectionBoundsChanged(
      anchorRect,
      anchorDir,
      focusRect,
      focusDir,
      boundingBoxRect,
      isAnchorFirst) {
    this.proxy.sendMessage(
        5,
        blink.mojom.WidgetHost_SelectionBoundsChanged_ParamsSpec.$,
        null,
        [
          anchorRect,
          anchorDir,
          focusRect,
          focusDir,
          boundingBoxRect,
          isAnchorFirst
        ],
        false);
  }

  
  /**
   * @param { !viz.mojom.CompositorFrameSinkPendingReceiver } compositorFrameSinkReceiver
   * @param { !viz.mojom.CompositorFrameSinkClientRemote } compositorFrameSinkClient
   * @param { !blink.mojom.RenderInputRouterClientRemote } renderInputRouterClient
   */

  createFrameSink(
      compositorFrameSinkReceiver,
      compositorFrameSinkClient,
      renderInputRouterClient) {
    this.proxy.sendMessage(
        6,
        blink.mojom.WidgetHost_CreateFrameSink_ParamsSpec.$,
        null,
        [
          compositorFrameSinkReceiver,
          compositorFrameSinkClient,
          renderInputRouterClient
        ],
        false);
  }

  
  /**
   * @param { !cc.mojom.RenderFrameMetadataObserverClientPendingReceiver } renderFrameMetadataObserverClientReceiver
   * @param { !cc.mojom.RenderFrameMetadataObserverRemote } renderFrameMetadataObserver
   */

  registerRenderFrameMetadataObserver(
      renderFrameMetadataObserverClientReceiver,
      renderFrameMetadataObserver) {
    this.proxy.sendMessage(
        7,
        blink.mojom.WidgetHost_RegisterRenderFrameMetadataObserver_ParamsSpec.$,
        null,
        [
          renderFrameMetadataObserverClientReceiver,
          renderFrameMetadataObserver
        ],
        false);
  }
};

/**
 * An object which receives request messages for the WidgetHost
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.WidgetHostReceiver = class {
  /**
   * @param {!blink.mojom.WidgetHostInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.WidgetHostRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.WidgetHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.WidgetHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.WidgetHost_SetCursor_ParamsSpec.$,
        null,
        impl.setCursor.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        blink.mojom.WidgetHost_UpdateTooltipUnderCursor_ParamsSpec.$,
        null,
        impl.updateTooltipUnderCursor.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        blink.mojom.WidgetHost_UpdateTooltipFromKeyboard_ParamsSpec.$,
        null,
        impl.updateTooltipFromKeyboard.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        blink.mojom.WidgetHost_ClearKeyboardTriggeredTooltip_ParamsSpec.$,
        null,
        impl.clearKeyboardTriggeredTooltip.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        blink.mojom.WidgetHost_TextInputStateChanged_ParamsSpec.$,
        null,
        impl.textInputStateChanged.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        blink.mojom.WidgetHost_SelectionBoundsChanged_ParamsSpec.$,
        null,
        impl.selectionBoundsChanged.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        blink.mojom.WidgetHost_CreateFrameSink_ParamsSpec.$,
        null,
        impl.createFrameSink.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        blink.mojom.WidgetHost_RegisterRenderFrameMetadataObserver_ParamsSpec.$,
        null,
        impl.registerRenderFrameMetadataObserver.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.WidgetHost = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.WidgetHost";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.WidgetHostRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.WidgetHostRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the WidgetHost
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.WidgetHostCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.WidgetHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.WidgetHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setCursor =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.WidgetHost_SetCursor_ParamsSpec.$,
        null,
        this.setCursor.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.updateTooltipUnderCursor =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        blink.mojom.WidgetHost_UpdateTooltipUnderCursor_ParamsSpec.$,
        null,
        this.updateTooltipUnderCursor.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.updateTooltipFromKeyboard =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        blink.mojom.WidgetHost_UpdateTooltipFromKeyboard_ParamsSpec.$,
        null,
        this.updateTooltipFromKeyboard.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.clearKeyboardTriggeredTooltip =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        blink.mojom.WidgetHost_ClearKeyboardTriggeredTooltip_ParamsSpec.$,
        null,
        this.clearKeyboardTriggeredTooltip.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.textInputStateChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        blink.mojom.WidgetHost_TextInputStateChanged_ParamsSpec.$,
        null,
        this.textInputStateChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.selectionBoundsChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        blink.mojom.WidgetHost_SelectionBoundsChanged_ParamsSpec.$,
        null,
        this.selectionBoundsChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.createFrameSink =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        blink.mojom.WidgetHost_CreateFrameSink_ParamsSpec.$,
        null,
        this.createFrameSink.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.registerRenderFrameMetadataObserver =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        blink.mojom.WidgetHost_RegisterRenderFrameMetadataObserver_ParamsSpec.$,
        null,
        this.registerRenderFrameMetadataObserver.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('blink.mojom.Widget');
goog.provide('blink.mojom.WidgetReceiver');
goog.provide('blink.mojom.WidgetCallbackRouter');
goog.provide('blink.mojom.WidgetInterface');
goog.provide('blink.mojom.WidgetRemote');
goog.provide('blink.mojom.WidgetPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.WidgetPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.Widget.$interfaceName,
        scope);
  }
};

/** @interface */
blink.mojom.WidgetInterface = class {
  
  /**
   * @return {!Promise}
   */

  forceRedraw() {}
  
  /**
   * @param { !blink.mojom.VisualProperties } visualProperties
   */

  updateVisualProperties(visualProperties) {}
  
  /**
   * @param { !gfx.mojom.Rect } widgetScreenRect
   * @param { !gfx.mojom.Rect } windowScreenRect
   * @return {!Promise}
   */

  updateScreenRects(widgetScreenRect, windowScreenRect) {}
  
  /**
   */

  wasHidden() {}
  
  /**
   * @param { !boolean } wasEvicted
   * @param { ?blink.mojom.RecordContentToVisibleTimeRequest } recordTabSwitchTimeRequest
   */

  wasShown(wasEvicted, recordTabSwitchTimeRequest) {}
  
  /**
   * @param { !blink.mojom.RecordContentToVisibleTimeRequest } visibleTimeRequest
   */

  requestSuccessfulPresentationTimeForNextFrame(visibleTimeRequest) {}
  
  /**
   */

  cancelSuccessfulPresentationTimeRequest() {}
  
  /**
   * @param { !blink.mojom.RenderInputRouterClientPendingReceiver } browserClient
   */

  setupBrowserRenderInputRouterConnections(browserClient) {}
};

/**
 * @export
 * @implements { blink.mojom.WidgetInterface }
 */
blink.mojom.WidgetRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.WidgetPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.WidgetPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.WidgetPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @return {!Promise}
   */

  forceRedraw() {
    return this.proxy.sendMessage(
        0,
        blink.mojom.Widget_ForceRedraw_ParamsSpec.$,
        blink.mojom.Widget_ForceRedraw_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.VisualProperties } visualProperties
   */

  updateVisualProperties(
      visualProperties) {
    this.proxy.sendMessage(
        1,
        blink.mojom.Widget_UpdateVisualProperties_ParamsSpec.$,
        null,
        [
          visualProperties
        ],
        false);
  }

  
  /**
   * @param { !gfx.mojom.Rect } widgetScreenRect
   * @param { !gfx.mojom.Rect } windowScreenRect
   * @return {!Promise}
   */

  updateScreenRects(
      widgetScreenRect,
      windowScreenRect) {
    return this.proxy.sendMessage(
        2,
        blink.mojom.Widget_UpdateScreenRects_ParamsSpec.$,
        blink.mojom.Widget_UpdateScreenRects_ResponseParamsSpec.$,
        [
          widgetScreenRect,
          windowScreenRect
        ],
        false);
  }

  
  /**
   */

  wasHidden() {
    this.proxy.sendMessage(
        3,
        blink.mojom.Widget_WasHidden_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !boolean } wasEvicted
   * @param { ?blink.mojom.RecordContentToVisibleTimeRequest } recordTabSwitchTimeRequest
   */

  wasShown(
      wasEvicted,
      recordTabSwitchTimeRequest) {
    this.proxy.sendMessage(
        4,
        blink.mojom.Widget_WasShown_ParamsSpec.$,
        null,
        [
          wasEvicted,
          recordTabSwitchTimeRequest
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.RecordContentToVisibleTimeRequest } visibleTimeRequest
   */

  requestSuccessfulPresentationTimeForNextFrame(
      visibleTimeRequest) {
    this.proxy.sendMessage(
        5,
        blink.mojom.Widget_RequestSuccessfulPresentationTimeForNextFrame_ParamsSpec.$,
        null,
        [
          visibleTimeRequest
        ],
        false);
  }

  
  /**
   */

  cancelSuccessfulPresentationTimeRequest() {
    this.proxy.sendMessage(
        6,
        blink.mojom.Widget_CancelSuccessfulPresentationTimeRequest_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.RenderInputRouterClientPendingReceiver } browserClient
   */

  setupBrowserRenderInputRouterConnections(
      browserClient) {
    this.proxy.sendMessage(
        7,
        blink.mojom.Widget_SetupBrowserRenderInputRouterConnections_ParamsSpec.$,
        null,
        [
          browserClient
        ],
        false);
  }
};

/**
 * An object which receives request messages for the Widget
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.WidgetReceiver = class {
  /**
   * @param {!blink.mojom.WidgetInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.WidgetRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.WidgetRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.WidgetRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.Widget_ForceRedraw_ParamsSpec.$,
        blink.mojom.Widget_ForceRedraw_ResponseParamsSpec.$,
        impl.forceRedraw.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        blink.mojom.Widget_UpdateVisualProperties_ParamsSpec.$,
        null,
        impl.updateVisualProperties.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        blink.mojom.Widget_UpdateScreenRects_ParamsSpec.$,
        blink.mojom.Widget_UpdateScreenRects_ResponseParamsSpec.$,
        impl.updateScreenRects.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        blink.mojom.Widget_WasHidden_ParamsSpec.$,
        null,
        impl.wasHidden.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        blink.mojom.Widget_WasShown_ParamsSpec.$,
        null,
        impl.wasShown.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        blink.mojom.Widget_RequestSuccessfulPresentationTimeForNextFrame_ParamsSpec.$,
        null,
        impl.requestSuccessfulPresentationTimeForNextFrame.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        blink.mojom.Widget_CancelSuccessfulPresentationTimeRequest_ParamsSpec.$,
        null,
        impl.cancelSuccessfulPresentationTimeRequest.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        blink.mojom.Widget_SetupBrowserRenderInputRouterConnections_ParamsSpec.$,
        null,
        impl.setupBrowserRenderInputRouterConnections.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.Widget = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.Widget";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.WidgetRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.WidgetRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the Widget
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.WidgetCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.WidgetRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.WidgetRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.forceRedraw =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.Widget_ForceRedraw_ParamsSpec.$,
        blink.mojom.Widget_ForceRedraw_ResponseParamsSpec.$,
        this.forceRedraw.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.updateVisualProperties =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        blink.mojom.Widget_UpdateVisualProperties_ParamsSpec.$,
        null,
        this.updateVisualProperties.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.updateScreenRects =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        blink.mojom.Widget_UpdateScreenRects_ParamsSpec.$,
        blink.mojom.Widget_UpdateScreenRects_ResponseParamsSpec.$,
        this.updateScreenRects.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.wasHidden =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        blink.mojom.Widget_WasHidden_ParamsSpec.$,
        null,
        this.wasHidden.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.wasShown =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        blink.mojom.Widget_WasShown_ParamsSpec.$,
        null,
        this.wasShown.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.requestSuccessfulPresentationTimeForNextFrame =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        blink.mojom.Widget_RequestSuccessfulPresentationTimeForNextFrame_ParamsSpec.$,
        null,
        this.requestSuccessfulPresentationTimeForNextFrame.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.cancelSuccessfulPresentationTimeRequest =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        blink.mojom.Widget_CancelSuccessfulPresentationTimeRequest_ParamsSpec.$,
        null,
        this.cancelSuccessfulPresentationTimeRequest.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setupBrowserRenderInputRouterConnections =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        blink.mojom.Widget_SetupBrowserRenderInputRouterConnections_ParamsSpec.$,
        null,
        this.setupBrowserRenderInputRouterConnections.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('blink.mojom.RenderInputRouterClient');
goog.provide('blink.mojom.RenderInputRouterClientReceiver');
goog.provide('blink.mojom.RenderInputRouterClientCallbackRouter');
goog.provide('blink.mojom.RenderInputRouterClientInterface');
goog.provide('blink.mojom.RenderInputRouterClientRemote');
goog.provide('blink.mojom.RenderInputRouterClientPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.RenderInputRouterClientPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.RenderInputRouterClient.$interfaceName,
        scope);
  }
};

/** @interface */
blink.mojom.RenderInputRouterClientInterface = class {
  
  /**
   * @param { !blink.mojom.WidgetInputHandlerPendingReceiver } request
   * @param { !blink.mojom.WidgetInputHandlerHostRemote } host
   * @param { !boolean } fromViz
   */

  getWidgetInputHandler(request, host, fromViz) {}
  
  /**
   * @param { !ui.mojom.MenuSourceType } sourceType
   * @param { !gfx.mojom.Point } location
   */

  showContextMenu(sourceType, location) {}
  
  /**
   * @param { !viz.mojom.InputTargetClientPendingReceiver } host
   */

  bindInputTargetClient(host) {}
};

/**
 * @export
 * @implements { blink.mojom.RenderInputRouterClientInterface }
 */
blink.mojom.RenderInputRouterClientRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.RenderInputRouterClientPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.RenderInputRouterClientPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.RenderInputRouterClientPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !blink.mojom.WidgetInputHandlerPendingReceiver } request
   * @param { !blink.mojom.WidgetInputHandlerHostRemote } host
   * @param { !boolean } fromViz
   */

  getWidgetInputHandler(
      request,
      host,
      fromViz) {
    this.proxy.sendMessage(
        0,
        blink.mojom.RenderInputRouterClient_GetWidgetInputHandler_ParamsSpec.$,
        null,
        [
          request,
          host,
          fromViz
        ],
        false);
  }

  
  /**
   * @param { !ui.mojom.MenuSourceType } sourceType
   * @param { !gfx.mojom.Point } location
   */

  showContextMenu(
      sourceType,
      location) {
    this.proxy.sendMessage(
        1,
        blink.mojom.RenderInputRouterClient_ShowContextMenu_ParamsSpec.$,
        null,
        [
          sourceType,
          location
        ],
        false);
  }

  
  /**
   * @param { !viz.mojom.InputTargetClientPendingReceiver } host
   */

  bindInputTargetClient(
      host) {
    this.proxy.sendMessage(
        2,
        blink.mojom.RenderInputRouterClient_BindInputTargetClient_ParamsSpec.$,
        null,
        [
          host
        ],
        false);
  }
};

/**
 * An object which receives request messages for the RenderInputRouterClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.RenderInputRouterClientReceiver = class {
  /**
   * @param {!blink.mojom.RenderInputRouterClientInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.RenderInputRouterClientRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.RenderInputRouterClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.RenderInputRouterClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.RenderInputRouterClient_GetWidgetInputHandler_ParamsSpec.$,
        null,
        impl.getWidgetInputHandler.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        blink.mojom.RenderInputRouterClient_ShowContextMenu_ParamsSpec.$,
        null,
        impl.showContextMenu.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        blink.mojom.RenderInputRouterClient_BindInputTargetClient_ParamsSpec.$,
        null,
        impl.bindInputTargetClient.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.RenderInputRouterClient = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.RenderInputRouterClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.RenderInputRouterClientRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.RenderInputRouterClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the RenderInputRouterClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.RenderInputRouterClientCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.RenderInputRouterClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.RenderInputRouterClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getWidgetInputHandler =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.RenderInputRouterClient_GetWidgetInputHandler_ParamsSpec.$,
        null,
        this.getWidgetInputHandler.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.showContextMenu =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        blink.mojom.RenderInputRouterClient_ShowContextMenu_ParamsSpec.$,
        null,
        this.showContextMenu.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.bindInputTargetClient =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        blink.mojom.RenderInputRouterClient_BindInputTargetClient_ParamsSpec.$,
        null,
        this.bindInputTargetClient.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('blink.mojom.WidgetCompositor_VisualStateRequest_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.WidgetCompositor_VisualStateRequest_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.WidgetCompositor_VisualStateRequest_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.WidgetCompositor_VisualStateRequest_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.WidgetHost_SetCursor_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.WidgetHost_SetCursor_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.WidgetHost_UpdateTooltipUnderCursor_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.WidgetHost_UpdateTooltipUnderCursor_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.WidgetHost_UpdateTooltipFromKeyboard_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.WidgetHost_UpdateTooltipFromKeyboard_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.WidgetHost_ClearKeyboardTriggeredTooltip_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.WidgetHost_ClearKeyboardTriggeredTooltip_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.WidgetHost_TextInputStateChanged_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.WidgetHost_TextInputStateChanged_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.WidgetHost_SelectionBoundsChanged_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.WidgetHost_SelectionBoundsChanged_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.WidgetHost_CreateFrameSink_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.WidgetHost_CreateFrameSink_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.WidgetHost_RegisterRenderFrameMetadataObserver_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.WidgetHost_RegisterRenderFrameMetadataObserver_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.Widget_ForceRedraw_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.Widget_ForceRedraw_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.Widget_ForceRedraw_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.Widget_ForceRedraw_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.Widget_UpdateVisualProperties_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.Widget_UpdateVisualProperties_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.Widget_UpdateScreenRects_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.Widget_UpdateScreenRects_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.Widget_UpdateScreenRects_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.Widget_UpdateScreenRects_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.Widget_WasHidden_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.Widget_WasHidden_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.Widget_WasShown_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.Widget_WasShown_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.Widget_RequestSuccessfulPresentationTimeForNextFrame_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.Widget_RequestSuccessfulPresentationTimeForNextFrame_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.Widget_CancelSuccessfulPresentationTimeRequest_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.Widget_CancelSuccessfulPresentationTimeRequest_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.Widget_SetupBrowserRenderInputRouterConnections_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.Widget_SetupBrowserRenderInputRouterConnections_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.RenderInputRouterClient_GetWidgetInputHandler_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.RenderInputRouterClient_GetWidgetInputHandler_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.RenderInputRouterClient_ShowContextMenu_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.RenderInputRouterClient_ShowContextMenu_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.RenderInputRouterClient_BindInputTargetClient_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.RenderInputRouterClient_BindInputTargetClient_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    blink.mojom.WidgetCompositor_VisualStateRequest_ParamsSpec.$,
    'WidgetCompositor_VisualStateRequest_Params',
    [
    ],
    [[0, 8],]);



goog.provide('blink.mojom.WidgetCompositor_VisualStateRequest_Params');

/** @record */
blink.mojom.WidgetCompositor_VisualStateRequest_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.WidgetCompositor_VisualStateRequest_ResponseParamsSpec.$,
    'WidgetCompositor_VisualStateRequest_ResponseParams',
    [
    ],
    [[0, 8],]);



goog.provide('blink.mojom.WidgetCompositor_VisualStateRequest_ResponseParams');

/** @record */
blink.mojom.WidgetCompositor_VisualStateRequest_ResponseParams = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.WidgetHost_SetCursor_ParamsSpec.$,
    'WidgetHost_SetCursor_Params',
    [
      mojo.internal.StructField(
        'cursor', 0,
        0,
        ui.mojom.CursorSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.WidgetHost_SetCursor_Params');

/** @record */
blink.mojom.WidgetHost_SetCursor_Params = class {
  constructor() {
    /** @export { !ui.mojom.Cursor } */
    this.cursor;
  }
};



mojo.internal.Struct(
    blink.mojom.WidgetHost_UpdateTooltipUnderCursor_ParamsSpec.$,
    'WidgetHost_UpdateTooltipUnderCursor_Params',
    [
      mojo.internal.StructField(
        'tooltipText', 0,
        0,
        mojoBase.mojom.String16Spec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'textDirectionHint', 8,
        0,
        mojoBase.mojom.TextDirectionSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.WidgetHost_UpdateTooltipUnderCursor_Params');

/** @record */
blink.mojom.WidgetHost_UpdateTooltipUnderCursor_Params = class {
  constructor() {
    /** @export { !mojoBase.mojom.String16 } */
    this.tooltipText;
    /** @export { !mojoBase.mojom.TextDirection } */
    this.textDirectionHint;
  }
};



mojo.internal.Struct(
    blink.mojom.WidgetHost_UpdateTooltipFromKeyboard_ParamsSpec.$,
    'WidgetHost_UpdateTooltipFromKeyboard_Params',
    [
      mojo.internal.StructField(
        'tooltipText', 0,
        0,
        mojoBase.mojom.String16Spec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'textDirectionHint', 8,
        0,
        mojoBase.mojom.TextDirectionSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'bounds', 16,
        0,
        gfx.mojom.RectSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);



goog.provide('blink.mojom.WidgetHost_UpdateTooltipFromKeyboard_Params');

/** @record */
blink.mojom.WidgetHost_UpdateTooltipFromKeyboard_Params = class {
  constructor() {
    /** @export { !mojoBase.mojom.String16 } */
    this.tooltipText;
    /** @export { !mojoBase.mojom.TextDirection } */
    this.textDirectionHint;
    /** @export { !gfx.mojom.Rect } */
    this.bounds;
  }
};



mojo.internal.Struct(
    blink.mojom.WidgetHost_ClearKeyboardTriggeredTooltip_ParamsSpec.$,
    'WidgetHost_ClearKeyboardTriggeredTooltip_Params',
    [
    ],
    [[0, 8],]);



goog.provide('blink.mojom.WidgetHost_ClearKeyboardTriggeredTooltip_Params');

/** @record */
blink.mojom.WidgetHost_ClearKeyboardTriggeredTooltip_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.WidgetHost_TextInputStateChanged_ParamsSpec.$,
    'WidgetHost_TextInputStateChanged_Params',
    [
      mojo.internal.StructField(
        'state', 0,
        0,
        ui.mojom.TextInputStateSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.WidgetHost_TextInputStateChanged_Params');

/** @record */
blink.mojom.WidgetHost_TextInputStateChanged_Params = class {
  constructor() {
    /** @export { !ui.mojom.TextInputState } */
    this.state;
  }
};



mojo.internal.Struct(
    blink.mojom.WidgetHost_SelectionBoundsChanged_ParamsSpec.$,
    'WidgetHost_SelectionBoundsChanged_Params',
    [
      mojo.internal.StructField(
        'anchorRect', 0,
        0,
        gfx.mojom.RectSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'anchorDir', 8,
        0,
        mojoBase.mojom.TextDirectionSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'focusRect', 16,
        0,
        gfx.mojom.RectSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'focusDir', 12,
        0,
        mojoBase.mojom.TextDirectionSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'boundingBoxRect', 24,
        0,
        gfx.mojom.RectSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'isAnchorFirst', 32,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 48],]);



goog.provide('blink.mojom.WidgetHost_SelectionBoundsChanged_Params');

/** @record */
blink.mojom.WidgetHost_SelectionBoundsChanged_Params = class {
  constructor() {
    /** @export { !gfx.mojom.Rect } */
    this.anchorRect;
    /** @export { !mojoBase.mojom.TextDirection } */
    this.anchorDir;
    /** @export { !gfx.mojom.Rect } */
    this.focusRect;
    /** @export { !mojoBase.mojom.TextDirection } */
    this.focusDir;
    /** @export { !gfx.mojom.Rect } */
    this.boundingBoxRect;
    /** @export { !boolean } */
    this.isAnchorFirst;
  }
};



mojo.internal.Struct(
    blink.mojom.WidgetHost_CreateFrameSink_ParamsSpec.$,
    'WidgetHost_CreateFrameSink_Params',
    [
      mojo.internal.StructField(
        'compositorFrameSinkReceiver', 0,
        0,
        mojo.internal.InterfaceRequest(viz.mojom.CompositorFrameSinkPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'compositorFrameSinkClient', 4,
        0,
        mojo.internal.InterfaceProxy(viz.mojom.CompositorFrameSinkClientRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'renderInputRouterClient', 12,
        0,
        mojo.internal.InterfaceProxy(blink.mojom.RenderInputRouterClientRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);



goog.provide('blink.mojom.WidgetHost_CreateFrameSink_Params');

/** @record */
blink.mojom.WidgetHost_CreateFrameSink_Params = class {
  constructor() {
    /** @export { !viz.mojom.CompositorFrameSinkPendingReceiver } */
    this.compositorFrameSinkReceiver;
    /** @export { !viz.mojom.CompositorFrameSinkClientRemote } */
    this.compositorFrameSinkClient;
    /** @export { !blink.mojom.RenderInputRouterClientRemote } */
    this.renderInputRouterClient;
  }
};



mojo.internal.Struct(
    blink.mojom.WidgetHost_RegisterRenderFrameMetadataObserver_ParamsSpec.$,
    'WidgetHost_RegisterRenderFrameMetadataObserver_Params',
    [
      mojo.internal.StructField(
        'renderFrameMetadataObserverClientReceiver', 0,
        0,
        mojo.internal.InterfaceRequest(cc.mojom.RenderFrameMetadataObserverClientPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'renderFrameMetadataObserver', 4,
        0,
        mojo.internal.InterfaceProxy(cc.mojom.RenderFrameMetadataObserverRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.WidgetHost_RegisterRenderFrameMetadataObserver_Params');

/** @record */
blink.mojom.WidgetHost_RegisterRenderFrameMetadataObserver_Params = class {
  constructor() {
    /** @export { !cc.mojom.RenderFrameMetadataObserverClientPendingReceiver } */
    this.renderFrameMetadataObserverClientReceiver;
    /** @export { !cc.mojom.RenderFrameMetadataObserverRemote } */
    this.renderFrameMetadataObserver;
  }
};



mojo.internal.Struct(
    blink.mojom.Widget_ForceRedraw_ParamsSpec.$,
    'Widget_ForceRedraw_Params',
    [
    ],
    [[0, 8],]);



goog.provide('blink.mojom.Widget_ForceRedraw_Params');

/** @record */
blink.mojom.Widget_ForceRedraw_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.Widget_ForceRedraw_ResponseParamsSpec.$,
    'Widget_ForceRedraw_ResponseParams',
    [
    ],
    [[0, 8],]);



goog.provide('blink.mojom.Widget_ForceRedraw_ResponseParams');

/** @record */
blink.mojom.Widget_ForceRedraw_ResponseParams = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.Widget_UpdateVisualProperties_ParamsSpec.$,
    'Widget_UpdateVisualProperties_Params',
    [
      mojo.internal.StructField(
        'visualProperties', 0,
        0,
        blink.mojom.VisualPropertiesSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.Widget_UpdateVisualProperties_Params');

/** @record */
blink.mojom.Widget_UpdateVisualProperties_Params = class {
  constructor() {
    /** @export { !blink.mojom.VisualProperties } */
    this.visualProperties;
  }
};



mojo.internal.Struct(
    blink.mojom.Widget_UpdateScreenRects_ParamsSpec.$,
    'Widget_UpdateScreenRects_Params',
    [
      mojo.internal.StructField(
        'widgetScreenRect', 0,
        0,
        gfx.mojom.RectSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'windowScreenRect', 8,
        0,
        gfx.mojom.RectSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.Widget_UpdateScreenRects_Params');

/** @record */
blink.mojom.Widget_UpdateScreenRects_Params = class {
  constructor() {
    /** @export { !gfx.mojom.Rect } */
    this.widgetScreenRect;
    /** @export { !gfx.mojom.Rect } */
    this.windowScreenRect;
  }
};



mojo.internal.Struct(
    blink.mojom.Widget_UpdateScreenRects_ResponseParamsSpec.$,
    'Widget_UpdateScreenRects_ResponseParams',
    [
    ],
    [[0, 8],]);



goog.provide('blink.mojom.Widget_UpdateScreenRects_ResponseParams');

/** @record */
blink.mojom.Widget_UpdateScreenRects_ResponseParams = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.Widget_WasHidden_ParamsSpec.$,
    'Widget_WasHidden_Params',
    [
    ],
    [[0, 8],]);



goog.provide('blink.mojom.Widget_WasHidden_Params');

/** @record */
blink.mojom.Widget_WasHidden_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.Widget_WasShown_ParamsSpec.$,
    'Widget_WasShown_Params',
    [
      mojo.internal.StructField(
        'wasEvicted', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'recordTabSwitchTimeRequest', 8,
        0,
        blink.mojom.RecordContentToVisibleTimeRequestSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.Widget_WasShown_Params');

/** @record */
blink.mojom.Widget_WasShown_Params = class {
  constructor() {
    /** @export { !boolean } */
    this.wasEvicted;
    /** @export { (blink.mojom.RecordContentToVisibleTimeRequest|undefined) } */
    this.recordTabSwitchTimeRequest;
  }
};



mojo.internal.Struct(
    blink.mojom.Widget_RequestSuccessfulPresentationTimeForNextFrame_ParamsSpec.$,
    'Widget_RequestSuccessfulPresentationTimeForNextFrame_Params',
    [
      mojo.internal.StructField(
        'visibleTimeRequest', 0,
        0,
        blink.mojom.RecordContentToVisibleTimeRequestSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.Widget_RequestSuccessfulPresentationTimeForNextFrame_Params');

/** @record */
blink.mojom.Widget_RequestSuccessfulPresentationTimeForNextFrame_Params = class {
  constructor() {
    /** @export { !blink.mojom.RecordContentToVisibleTimeRequest } */
    this.visibleTimeRequest;
  }
};



mojo.internal.Struct(
    blink.mojom.Widget_CancelSuccessfulPresentationTimeRequest_ParamsSpec.$,
    'Widget_CancelSuccessfulPresentationTimeRequest_Params',
    [
    ],
    [[0, 8],]);



goog.provide('blink.mojom.Widget_CancelSuccessfulPresentationTimeRequest_Params');

/** @record */
blink.mojom.Widget_CancelSuccessfulPresentationTimeRequest_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.Widget_SetupBrowserRenderInputRouterConnections_ParamsSpec.$,
    'Widget_SetupBrowserRenderInputRouterConnections_Params',
    [
      mojo.internal.StructField(
        'browserClient', 0,
        0,
        mojo.internal.InterfaceRequest(blink.mojom.RenderInputRouterClientPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.Widget_SetupBrowserRenderInputRouterConnections_Params');

/** @record */
blink.mojom.Widget_SetupBrowserRenderInputRouterConnections_Params = class {
  constructor() {
    /** @export { !blink.mojom.RenderInputRouterClientPendingReceiver } */
    this.browserClient;
  }
};



mojo.internal.Struct(
    blink.mojom.RenderInputRouterClient_GetWidgetInputHandler_ParamsSpec.$,
    'RenderInputRouterClient_GetWidgetInputHandler_Params',
    [
      mojo.internal.StructField(
        'request', 0,
        0,
        mojo.internal.InterfaceRequest(blink.mojom.WidgetInputHandlerPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'host', 4,
        0,
        mojo.internal.InterfaceProxy(blink.mojom.WidgetInputHandlerHostRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'fromViz', 12,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.RenderInputRouterClient_GetWidgetInputHandler_Params');

/** @record */
blink.mojom.RenderInputRouterClient_GetWidgetInputHandler_Params = class {
  constructor() {
    /** @export { !blink.mojom.WidgetInputHandlerPendingReceiver } */
    this.request;
    /** @export { !blink.mojom.WidgetInputHandlerHostRemote } */
    this.host;
    /** @export { !boolean } */
    this.fromViz;
  }
};



mojo.internal.Struct(
    blink.mojom.RenderInputRouterClient_ShowContextMenu_ParamsSpec.$,
    'RenderInputRouterClient_ShowContextMenu_Params',
    [
      mojo.internal.StructField(
        'sourceType', 0,
        0,
        ui.mojom.MenuSourceTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'location', 8,
        0,
        gfx.mojom.PointSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.RenderInputRouterClient_ShowContextMenu_Params');

/** @record */
blink.mojom.RenderInputRouterClient_ShowContextMenu_Params = class {
  constructor() {
    /** @export { !ui.mojom.MenuSourceType } */
    this.sourceType;
    /** @export { !gfx.mojom.Point } */
    this.location;
  }
};



mojo.internal.Struct(
    blink.mojom.RenderInputRouterClient_BindInputTargetClient_ParamsSpec.$,
    'RenderInputRouterClient_BindInputTargetClient_Params',
    [
      mojo.internal.StructField(
        'host', 0,
        0,
        mojo.internal.InterfaceRequest(viz.mojom.InputTargetClientPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.RenderInputRouterClient_BindInputTargetClient_Params');

/** @record */
blink.mojom.RenderInputRouterClient_BindInputTargetClient_Params = class {
  constructor() {
    /** @export { !viz.mojom.InputTargetClientPendingReceiver } */
    this.host;
  }
};

