// third_party/blink/public/mojom/widget/device_emulation_params.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'third_party/blink/public/mojom/widget/device_emulation_params.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('blink.mojom');
  var device_posture_provider$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/device_posture/device_posture_provider.mojom', '../device_posture/device_posture_provider.mojom.js');
  }
  var geometry$ =
      mojo.internal.exposeNamespace('gfx.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'ui/gfx/geometry/mojom/geometry.mojom', '../../../../../ui/gfx/geometry/mojom/geometry.mojom.js');
  }
  var screen_orientation$ =
      mojo.internal.exposeNamespace('display.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'ui/display/mojom/screen_orientation.mojom', '../../../../../ui/display/mojom/screen_orientation.mojom.js');
  }


  var EmulatedScreenType = {};
  EmulatedScreenType.kDesktop = 0;
  EmulatedScreenType.kMobile = 1;
  EmulatedScreenType.MIN_VALUE = 0;
  EmulatedScreenType.MAX_VALUE = 1;

  EmulatedScreenType.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
      return true;
    }
    return false;
  };

  EmulatedScreenType.toKnownEnumValue = function(value) {
    return value;
  };

  EmulatedScreenType.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  function DeviceEmulationParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  DeviceEmulationParams.prototype.initDefaults_ = function() {
    this.screenType = 0;
    this.deviceScaleFactor = 0;
    this.screenSize = null;
    this.viewPosition = null;
    this.viewSize = null;
    this.scale = 0;
    this.viewportScale = 0;
    this.viewportOffset = null;
    this.screenOrientationType = 0;
    this.screenOrientationAngle = 0;
    this.viewportSegments = null;
    this.devicePosture = 0;
  };
  DeviceEmulationParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  DeviceEmulationParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 80}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DeviceEmulationParams.screenType
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, EmulatedScreenType);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DeviceEmulationParams.screenSize
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, geometry$.Size, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DeviceEmulationParams.viewPosition
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, geometry$.Point, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DeviceEmulationParams.viewSize
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 24, geometry$.Size, false);
    if (err !== validator.validationError.NONE)
        return err;




    // validate DeviceEmulationParams.viewportOffset
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 40, geometry$.PointF, false);
    if (err !== validator.validationError.NONE)
        return err;



    // validate DeviceEmulationParams.screenOrientationType
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 48, screen_orientation$.ScreenOrientation);
    if (err !== validator.validationError.NONE)
        return err;



    // validate DeviceEmulationParams.viewportSegments
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 56, 8, new codec.PointerTo(geometry$.Rect), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DeviceEmulationParams.devicePosture
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 64, device_posture_provider$.DevicePostureType);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  DeviceEmulationParams.encodedSize = codec.kStructHeaderSize + 72;

  DeviceEmulationParams.decode = function(decoder) {
    var packed;
    var val = new DeviceEmulationParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.screenType =
        decoder.decodeStruct(new codec.Enum(EmulatedScreenType));
    val.deviceScaleFactor =
        decoder.decodeStruct(codec.Float);
    val.screenSize =
        decoder.decodeStructPointer(geometry$.Size);
    val.viewPosition =
        decoder.decodeStructPointer(geometry$.Point);
    val.viewSize =
        decoder.decodeStructPointer(geometry$.Size);
    val.scale =
        decoder.decodeStruct(codec.Float);
    val.viewportScale =
        decoder.decodeStruct(codec.Float);
    val.viewportOffset =
        decoder.decodeStructPointer(geometry$.PointF);
    val.screenOrientationType =
        decoder.decodeStruct(new codec.Enum(screen_orientation$.ScreenOrientation));
    val.screenOrientationAngle =
        decoder.decodeStruct(codec.Uint32);
    val.viewportSegments =
        decoder.decodeArrayPointer(new codec.PointerTo(geometry$.Rect));
    val.devicePosture =
        decoder.decodeStruct(new codec.Enum(device_posture_provider$.DevicePostureType));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  DeviceEmulationParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(DeviceEmulationParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.screenType);
    encoder.encodeStruct(codec.Float, val.deviceScaleFactor);
    encoder.encodeStructPointer(geometry$.Size, val.screenSize);
    encoder.encodeStructPointer(geometry$.Point, val.viewPosition);
    encoder.encodeStructPointer(geometry$.Size, val.viewSize);
    encoder.encodeStruct(codec.Float, val.scale);
    encoder.encodeStruct(codec.Float, val.viewportScale);
    encoder.encodeStructPointer(geometry$.PointF, val.viewportOffset);
    encoder.encodeStruct(codec.Int32, val.screenOrientationType);
    encoder.encodeStruct(codec.Uint32, val.screenOrientationAngle);
    encoder.encodeArrayPointer(new codec.PointerTo(geometry$.Rect), val.viewportSegments);
    encoder.encodeStruct(codec.Int32, val.devicePosture);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  exports.EmulatedScreenType = EmulatedScreenType;
  exports.DeviceEmulationParams = DeviceEmulationParams;
})();