// third_party/blink/public/mojom/widget/device_emulation_params.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_WIDGET_DEVICE_EMULATION_PARAMS_MOJOM_SEND_VALIDATION_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_WIDGET_DEVICE_EMULATION_PARAMS_MOJOM_SEND_VALIDATION_H_

#include "third_party/blink/public/mojom/widget/device_emulation_params.mojom-shared-internal.h"
#include "third_party/blink/public/mojom/device_posture/device_posture_provider.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "ui/display/mojom/screen_orientation.mojom-shared.h"

#include "third_party/blink/public/mojom/widget/device_emulation_params.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/has_send_validation_helper.h"

namespace mojo::internal {
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::blink::mojom::EmulatedScreenType, MaybeConstUserType>
    : std::false_type {};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::blink::mojom::DeviceEmulationParamsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::DeviceEmulationParamsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::DeviceEmulationParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      
      mojo::internal::Serialize<::blink::mojom::EmulatedScreenType>(
        Traits::screen_type(input),
        &fragment->screen_type);

      decltype(Traits::screen_size(input)) in_screen_size = Traits::screen_size(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->screen_size)::BaseType> screen_size_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::SizeDataView, send_validation>(
        in_screen_size,
        screen_size_fragment);

      fragment->screen_size.Set(
          screen_size_fragment.is_null() ? nullptr : screen_size_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->screen_size.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null screen_size in DeviceEmulationParams struct");

      decltype(Traits::view_position(input)) in_view_position = Traits::view_position(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->view_position)::BaseType> view_position_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::PointDataView, send_validation>(
        in_view_position,
        view_position_fragment);

      fragment->view_position.Set(
          view_position_fragment.is_null() ? nullptr : view_position_fragment.data());

      decltype(Traits::view_size(input)) in_view_size = Traits::view_size(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->view_size)::BaseType> view_size_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::SizeDataView, send_validation>(
        in_view_size,
        view_size_fragment);

      fragment->view_size.Set(
          view_size_fragment.is_null() ? nullptr : view_size_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->view_size.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null view_size in DeviceEmulationParams struct");

      fragment->device_scale_factor = Traits::device_scale_factor(input);

      fragment->scale = Traits::scale(input);

      decltype(Traits::viewport_offset(input)) in_viewport_offset = Traits::viewport_offset(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->viewport_offset)::BaseType> viewport_offset_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::PointFDataView, send_validation>(
        in_viewport_offset,
        viewport_offset_fragment);

      fragment->viewport_offset.Set(
          viewport_offset_fragment.is_null() ? nullptr : viewport_offset_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->viewport_offset.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null viewport_offset in DeviceEmulationParams struct");

      fragment->viewport_scale = Traits::viewport_scale(input);

      
      mojo::internal::Serialize<::display::mojom::ScreenOrientation>(
        Traits::screen_orientation_type(input),
        &fragment->screen_orientation_type);

      fragment->screen_orientation_angle = Traits::screen_orientation_angle(input);

      decltype(Traits::viewport_segments(input)) in_viewport_segments = Traits::viewport_segments(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->viewport_segments)::BaseType>
          viewport_segments_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& viewport_segments_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::gfx::mojom::RectDataView>, send_validation>(
        in_viewport_segments,
        viewport_segments_fragment,
        &viewport_segments_validate_params);

      fragment->viewport_segments.Set(
          viewport_segments_fragment.is_null() ? nullptr : viewport_segments_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->viewport_segments.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null viewport_segments in DeviceEmulationParams struct");

      
      mojo::internal::Serialize<::blink::mojom::DevicePostureType>(
        Traits::device_posture(input),
        &fragment->device_posture);
  }
};

}  // namespace mojo::internal

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_WIDGET_DEVICE_EMULATION_PARAMS_MOJOM_SEND_VALIDATION_H_