// third_party/blink/public/mojom/widget/device_emulation_params.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_WIDGET_DEVICE_EMULATION_PARAMS_MOJOM_DATA_VIEW_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_WIDGET_DEVICE_EMULATION_PARAMS_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/blink/public/mojom/widget/device_emulation_params.mojom-shared-internal.h"
#include "third_party/blink/public/mojom/device_posture/device_posture_provider.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "ui/display/mojom/screen_orientation.mojom-shared.h"


namespace blink::mojom {
class DeviceEmulationParamsDataView;



}  // blink::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::DeviceEmulationParamsDataView> {
  using Data = ::blink::mojom::internal::DeviceEmulationParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace blink::mojom {


enum class EmulatedScreenType : int32_t {
  
  kDesktop = 0,
  
  kMobile = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, EmulatedScreenType value);
inline bool IsKnownEnumValue(EmulatedScreenType value) {
  return internal::EmulatedScreenType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class DeviceEmulationParamsDataView {
 public:
  DeviceEmulationParamsDataView() = default;

  DeviceEmulationParamsDataView(
      internal::DeviceEmulationParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadScreenType(UserType* output) const {
    auto data_value = data_->screen_type;
    return mojo::internal::Deserialize<::blink::mojom::EmulatedScreenType>(
        data_value, output);
  }
  EmulatedScreenType screen_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::EmulatedScreenType>(data_->screen_type));
  }
  inline void GetScreenSizeDataView(
      ::gfx::mojom::SizeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadScreenSize(UserType* output) {
    
    auto* pointer = data_->screen_size.Get();
    return mojo::internal::Deserialize<::gfx::mojom::SizeDataView>(
        pointer, output, message_);
  }
  inline void GetViewPositionDataView(
      ::gfx::mojom::PointDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadViewPosition(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::gfx::mojom::PointDataView, UserType>(),
    "Attempting to read the optional `view_position` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadViewPosition` instead "
    "of `ReadViewPosition if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->view_position.Get();
    return mojo::internal::Deserialize<::gfx::mojom::PointDataView>(
        pointer, output, message_);
  }
  inline void GetViewSizeDataView(
      ::gfx::mojom::SizeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadViewSize(UserType* output) {
    
    auto* pointer = data_->view_size.Get();
    return mojo::internal::Deserialize<::gfx::mojom::SizeDataView>(
        pointer, output, message_);
  }
  float device_scale_factor() const {
    return data_->device_scale_factor;
  }
  float scale() const {
    return data_->scale;
  }
  inline void GetViewportOffsetDataView(
      ::gfx::mojom::PointFDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadViewportOffset(UserType* output) {
    
    auto* pointer = data_->viewport_offset.Get();
    return mojo::internal::Deserialize<::gfx::mojom::PointFDataView>(
        pointer, output, message_);
  }
  float viewport_scale() const {
    return data_->viewport_scale;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadScreenOrientationType(UserType* output) const {
    auto data_value = data_->screen_orientation_type;
    return mojo::internal::Deserialize<::display::mojom::ScreenOrientation>(
        data_value, output);
  }
  ::display::mojom::ScreenOrientation screen_orientation_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::display::mojom::ScreenOrientation>(data_->screen_orientation_type));
  }
  uint32_t screen_orientation_angle() const {
    return data_->screen_orientation_angle;
  }
  inline void GetViewportSegmentsDataView(
      mojo::ArrayDataView<::gfx::mojom::RectDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadViewportSegments(UserType* output) {
    
    auto* pointer = data_->viewport_segments.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::gfx::mojom::RectDataView>>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadDevicePosture(UserType* output) const {
    auto data_value = data_->device_posture;
    return mojo::internal::Deserialize<::blink::mojom::DevicePostureType>(
        data_value, output);
  }
  ::blink::mojom::DevicePostureType device_posture() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::DevicePostureType>(data_->device_posture));
  }
 private:
  internal::DeviceEmulationParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // blink::mojom

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_WIDGET_DEVICE_EMULATION_PARAMS_MOJOM_DATA_VIEW_H_