// third_party/blink/public/mojom/webshare/webshare.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';

import {
  SafeBaseName as mojoBase_mojom_SafeBaseName,
  SafeBaseNameSpec as mojoBase_mojom_SafeBaseNameSpec
} from '../../../../../mojo/public/mojom/base/safe_base_name.mojom.m.js';

import {
  Url as url_mojom_Url,
  UrlSpec as url_mojom_UrlSpec
} from '../../../../../url/mojom/url.mojom.m.js';

import {
  SerializedBlob as blink_mojom_SerializedBlob,
  SerializedBlobSpec as blink_mojom_SerializedBlobSpec
} from '../blob/serialized_blob.mojom.m.js';

import {
  ShareError as blink_mojom_ShareError,
  ShareErrorSpec as blink_mojom_ShareErrorSpec
} from './share_error.mojom.m.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class ShareServicePendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.ShareService', scope);
  }
}

/** @interface */
export class ShareServiceInterface {
  
  /**
   * @param { !string } title
   * @param { !string } text
   * @param { !url_mojom_Url } url
   * @param { !Array<!SharedFile> } files
   * @return {!Promise<{
        error: !blink_mojom_ShareError,
   *  }>}
   */

  share(title, text, url, files) {}
}

/**
 * @implements { ShareServiceInterface }
 */
export class ShareServiceRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!ShareServicePendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          ShareServicePendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!ShareServicePendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !string } title
   * @param { !string } text
   * @param { !url_mojom_Url } url
   * @param { !Array<!SharedFile> } files
   * @return {!Promise<{
        error: !blink_mojom_ShareError,
   *  }>}
   */

  share(
      title,
      text,
      url,
      files) {
    return this.proxy.sendMessage(
        0,
        ShareService_Share_ParamsSpec.$,
        ShareService_Share_ResponseParamsSpec.$,
        [
          title,
          text,
          url,
          files
        ],
        false);
  }
}

/**
 * An object which receives request messages for the ShareService
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class ShareServiceReceiver {
  /**
   * @param {!ShareServiceInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!ShareServiceRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        ShareServiceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ShareServiceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        ShareService_Share_ParamsSpec.$,
        ShareService_Share_ResponseParamsSpec.$,
        impl.share.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class ShareService {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.ShareService";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!ShareServiceRemote}
   */
  static getRemote() {
    let remote = new ShareServiceRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the ShareService
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class ShareServiceCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      ShareServiceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ShareServiceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.share =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        ShareService_Share_ParamsSpec.$,
        ShareService_Share_ResponseParamsSpec.$,
        this.share.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SharedFileSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ShareService_Share_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ShareService_Share_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    SharedFileSpec.$,
    'SharedFile',
    [
      mojo.internal.StructField(
        'name', 0,
        0,
        mojoBase_mojom_SafeBaseNameSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'blob', 8,
        0,
        blink_mojom_SerializedBlobSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class SharedFile {
  constructor() {
    /** @type { !mojoBase_mojom_SafeBaseName } */
    this.name;
    /** @type { !blink_mojom_SerializedBlob } */
    this.blob;
  }
}



mojo.internal.Struct(
    ShareService_Share_ParamsSpec.$,
    'ShareService_Share_Params',
    [
      mojo.internal.StructField(
        'title', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'text', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'url', 16,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'files', 24,
        0,
        mojo.internal.Array(SharedFileSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class ShareService_Share_Params {
  constructor() {
    /** @type { !string } */
    this.title;
    /** @type { !string } */
    this.text;
    /** @type { !url_mojom_Url } */
    this.url;
    /** @type { !Array<!SharedFile> } */
    this.files;
  }
}



mojo.internal.Struct(
    ShareService_Share_ResponseParamsSpec.$,
    'ShareService_Share_ResponseParams',
    [
      mojo.internal.StructField(
        'error', 0,
        0,
        blink_mojom_ShareErrorSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class ShareService_Share_ResponseParams {
  constructor() {
    /** @type { !blink_mojom_ShareError } */
    this.error;
  }
}

