// third_party/blink/public/mojom/webshare/webshare.mojom-lite-for-compile.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';

goog.require('mojo.internal');
goog.require('mojo.internal.interfaceSupport');

goog.require('blink.mojom.ShareError');
goog.require('mojoBase.mojom.SafeBaseName');
goog.require('blink.mojom.SerializedBlob');
goog.require('url.mojom.Url');






goog.provide('blink.mojom.ShareService');
goog.provide('blink.mojom.ShareServiceReceiver');
goog.provide('blink.mojom.ShareServiceCallbackRouter');
goog.provide('blink.mojom.ShareServiceInterface');
goog.provide('blink.mojom.ShareServiceRemote');
goog.provide('blink.mojom.ShareServicePendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.ShareServicePendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.ShareService.$interfaceName,
        scope);
  }
};

/** @interface */
blink.mojom.ShareServiceInterface = class {
  
  /**
   * @param { !string } title
   * @param { !string } text
   * @param { !url.mojom.Url } url
   * @param { !Array<!blink.mojom.SharedFile> } files
   * @return {!Promise<{
        error: !blink.mojom.ShareError,
   *  }>}
   */

  share(title, text, url, files) {}
};

/**
 * @export
 * @implements { blink.mojom.ShareServiceInterface }
 */
blink.mojom.ShareServiceRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.ShareServicePendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.ShareServicePendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.ShareServicePendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !string } title
   * @param { !string } text
   * @param { !url.mojom.Url } url
   * @param { !Array<!blink.mojom.SharedFile> } files
   * @return {!Promise<{
        error: !blink.mojom.ShareError,
   *  }>}
   */

  share(
      title,
      text,
      url,
      files) {
    return this.proxy.sendMessage(
        0,
        blink.mojom.ShareService_Share_ParamsSpec.$,
        blink.mojom.ShareService_Share_ResponseParamsSpec.$,
        [
          title,
          text,
          url,
          files
        ],
        false);
  }
};

/**
 * An object which receives request messages for the ShareService
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.ShareServiceReceiver = class {
  /**
   * @param {!blink.mojom.ShareServiceInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.ShareServiceRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.ShareServiceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.ShareServiceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.ShareService_Share_ParamsSpec.$,
        blink.mojom.ShareService_Share_ResponseParamsSpec.$,
        impl.share.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.ShareService = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.ShareService";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.ShareServiceRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.ShareServiceRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the ShareService
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.ShareServiceCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.ShareServiceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.ShareServiceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.share =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.ShareService_Share_ParamsSpec.$,
        blink.mojom.ShareService_Share_ResponseParamsSpec.$,
        this.share.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('blink.mojom.SharedFileSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.SharedFileSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ShareService_Share_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ShareService_Share_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ShareService_Share_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ShareService_Share_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    blink.mojom.SharedFileSpec.$,
    'SharedFile',
    [
      mojo.internal.StructField(
        'name', 0,
        0,
        mojoBase.mojom.SafeBaseNameSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'blob', 8,
        0,
        blink.mojom.SerializedBlobSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.SharedFile');

/** @record */
blink.mojom.SharedFile = class {
  constructor() {
    /** @export { !mojoBase.mojom.SafeBaseName } */
    this.name;
    /** @export { !blink.mojom.SerializedBlob } */
    this.blob;
  }
};



mojo.internal.Struct(
    blink.mojom.ShareService_Share_ParamsSpec.$,
    'ShareService_Share_Params',
    [
      mojo.internal.StructField(
        'title', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'text', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'url', 16,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'files', 24,
        0,
        mojo.internal.Array(blink.mojom.SharedFileSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);



goog.provide('blink.mojom.ShareService_Share_Params');

/** @record */
blink.mojom.ShareService_Share_Params = class {
  constructor() {
    /** @export { !string } */
    this.title;
    /** @export { !string } */
    this.text;
    /** @export { !url.mojom.Url } */
    this.url;
    /** @export { !Array<!blink.mojom.SharedFile> } */
    this.files;
  }
};



mojo.internal.Struct(
    blink.mojom.ShareService_Share_ResponseParamsSpec.$,
    'ShareService_Share_ResponseParams',
    [
      mojo.internal.StructField(
        'error', 0,
        0,
        blink.mojom.ShareErrorSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.ShareService_Share_ResponseParams');

/** @record */
blink.mojom.ShareService_Share_ResponseParams = class {
  constructor() {
    /** @export { !blink.mojom.ShareError } */
    this.error;
  }
};

