// third_party/blink/public/mojom/webpreferences/web_preferences.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_WEBPREFERENCES_WEB_PREFERENCES_MOJOM_BLINK_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_WEBPREFERENCES_WEB_PREFERENCES_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/webpreferences/web_preferences.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/webpreferences/web_preferences.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/webpreferences/web_preferences.mojom-blink-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/string16.mojom-blink.h"
#include "skia/public/mojom/skcolor.mojom-blink.h"
#include "third_party/blink/public/mojom/css/preferred_color_scheme.mojom-blink-forward.h"
#include "third_party/blink/public/mojom/css/preferred_contrast.mojom-blink-forward.h"
#include "third_party/blink/public/mojom/v8_cache_options.mojom-blink-forward.h"
#include "url/mojom/url.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"




#include "third_party/blink/public/common/web_preferences/web_preferences_mojom_traits.h"
#include "third_party/blink/renderer/platform/platform_export.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace blink::mojom::blink {








class PLATFORM_EXPORT WebPreferences {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<WebPreferences, T>::value>;
  using DataView = WebPreferencesDataView;
  using Data_ = internal::WebPreferences_Data;

  template <typename... Args>
  static WebPreferencesPtr New(Args&&... args) {
    return WebPreferencesPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static WebPreferencesPtr From(const U& u) {
    return mojo::TypeConverter<WebPreferencesPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, WebPreferences>::Convert(*this);
  }


  WebPreferences();

  WebPreferences(
      const ::blink::HashMap<::blink::String, ::blink::String>& standard_font_family_map,
      const ::blink::HashMap<::blink::String, ::blink::String>& fixed_font_family_map,
      const ::blink::HashMap<::blink::String, ::blink::String>& serif_font_family_map,
      const ::blink::HashMap<::blink::String, ::blink::String>& sans_serif_font_family_map,
      const ::blink::HashMap<::blink::String, ::blink::String>& cursive_font_family_map,
      const ::blink::HashMap<::blink::String, ::blink::String>& fantasy_font_family_map,
      const ::blink::HashMap<::blink::String, ::blink::String>& math_font_family_map,
      int32_t default_font_size,
      int32_t default_fixed_font_size,
      int32_t minimum_font_size,
      int32_t minimum_logical_font_size,
      const ::blink::String& default_encoding,
      bool always_show_context_menu_on_touch,
      bool context_menu_on_mouse_up,
      bool javascript_enabled,
      bool web_security_enabled,
      bool loads_images_automatically,
      bool images_enabled,
      bool plugins_enabled,
      bool dom_paste_enabled,
      bool shrinks_standalone_images_to_fit,
      bool text_areas_are_resizable,
      bool allow_scripts_to_close_windows,
      bool allow_window_focus_without_user_gesture,
      bool remote_fonts_enabled,
      bool javascript_can_access_clipboard,
      bool dns_prefetching_enabled,
      bool data_saver_enabled,
      bool local_storage_enabled,
      bool tabs_to_links,
      bool disable_ipc_flooding_protection,
      bool hyperlink_auditing_enabled,
      bool allow_universal_access_from_file_urls,
      bool allow_file_access_from_file_urls,
      bool webgl1_enabled,
      bool webgl2_enabled,
      bool privileged_webgl_extensions_enabled,
      bool webgl_errors_to_console_enabled,
      bool hide_scrollbars,
      bool prefers_default_scrollbar_styles,
      bool accelerated_2d_canvas_enabled,
      bool canvas_2d_layers_enabled,
      bool antialiased_2d_canvas_disabled,
      bool antialiased_clips_2d_canvas_enabled,
      bool accelerated_filters_enabled,
      bool deferred_filters_enabled,
      bool container_culling_enabled,
      bool allow_running_insecure_content,
      bool disable_reading_from_canvas,
      bool strict_mixed_content_checking,
      bool strict_powerful_feature_restrictions,
      bool allow_geolocation_on_insecure_origins,
      bool strictly_block_blockable_mixed_content,
      bool block_mixed_plugin_content,
      bool password_echo_enabled_physical,
      bool password_echo_enabled_touch,
      bool should_clear_document_background,
      bool enable_scroll_animator,
      bool prefers_reduced_motion,
      bool prefers_reduced_transparency,
      bool inverted_colors,
      bool touch_event_feature_detection_enabled,
      int32_t pointer_events_max_touch_points,
      int32_t available_pointer_types,
      PointerType primary_pointer_type,
      OutputDeviceUpdateAbilityType output_device_update_ability_type,
      int32_t available_hover_types,
      HoverType primary_hover_type,
      bool dont_send_key_events_to_javascript,
      bool barrel_button_for_drag_enabled,
      bool sync_xhr_in_documents_enabled,
      bool target_blank_implies_no_opener_enabled_will_be_removed,
      bool ignore_permission_for_device_changed_event,
      int32_t number_of_cpu_cores,
      EditingBehavior editing_behavior,
      bool supports_multiple_windows,
      bool viewport_enabled,
      bool viewport_meta_enabled,
      bool auto_zoom_focused_editable_to_legible_scale,
      bool shrinks_viewport_contents_to_fit,
      ViewportStyle viewport_style,
      bool smooth_scroll_for_find_enabled,
      bool main_frame_resizes_are_orientation_changes,
      bool initialize_at_minimum_page_scale,
      bool smart_insert_delete_enabled,
      bool spatial_navigation_enabled,
      ::blink::mojom::blink::V8CacheOptions v8_cache_options,
      bool record_whole_document,
      bool stylus_handwriting_enabled,
      bool cookie_enabled,
      bool accelerated_video_decode_enabled,
      ImageAnimationPolicy animation_policy,
      bool user_gesture_required_for_presentation,
      bool text_tracks_enabled,
      const ::blink::String& text_track_background_color,
      const ::blink::String& text_track_text_color,
      const ::blink::String& text_track_text_size,
      const ::blink::String& text_track_text_shadow,
      const ::blink::String& text_track_font_family,
      const ::blink::String& text_track_font_style,
      const ::blink::String& text_track_font_variant,
      const ::blink::String& text_track_window_color,
      const ::blink::String& text_track_window_radius,
      float text_track_margin_percentage,
      bool immersive_mode_enabled,
      bool double_tap_to_zoom_enabled,
      bool fullscreen_supported,
      bool text_autosizing_enabled,
      const ::blink::KURL& web_app_scope,
      bool force_dark_mode_enabled,
      float default_minimum_page_scale_factor,
      float default_maximum_page_scale_factor,
      bool hide_download_ui,
      bool presentation_receiver,
      bool media_controls_enabled,
      bool do_not_update_selection_on_mutating_selection_range,
      AutoplayPolicy autoplay_policy,
      bool require_transient_activation_for_get_display_media,
      bool require_transient_activation_for_show_file_or_directory_picker,
      bool require_transient_activation_and_user_confirmation_for_subapps_api,
      bool in_forced_colors,
      bool is_forced_colors_disabled,
      std::optional<::SkColor> root_scrollbar_theme_color,
      ::blink::mojom::blink::PreferredColorScheme preferred_root_scrollbar_color_scheme,
      ::blink::mojom::blink::PreferredColorScheme preferred_color_scheme,
      ::blink::mojom::blink::PreferredContrast preferred_contrast,
      EffectiveConnectionType low_priority_iframes_threshold,
      bool picture_in_picture_enabled,
      bool translate_service_available,
      EffectiveConnectionType network_quality_estimator_web_holdback,
      bool lazy_load_enabled,
      bool allow_mixed_content_upgrades,
      bool always_show_focus,
      bool touch_drag_drop_enabled,
      bool touch_dragend_context_menu,
      bool webxr_immersive_ar_allowed,
      bool renderer_wide_named_frame_lookup,
      bool strict_mime_type_check_for_worker_scripts_enabled,
      bool modal_context_menu,
      bool payment_request_enabled,
      bool ai_prompt_api_enabled,
      bool should_disable_external_popups);


  ~WebPreferences();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = WebPreferencesPtr>
  WebPreferencesPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, WebPreferences::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, WebPreferences::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, WebPreferences::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        WebPreferences::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        WebPreferences::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        WebPreferences::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::WebPreferences_UnserializedMessageContext<
            UserType, WebPreferences::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<WebPreferences::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return WebPreferences::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::WebPreferences_UnserializedMessageContext<
            UserType, WebPreferences::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<WebPreferences::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::HashMap<::blink::String, ::blink::String> standard_font_family_map;
  
  ::blink::HashMap<::blink::String, ::blink::String> fixed_font_family_map;
  
  ::blink::HashMap<::blink::String, ::blink::String> serif_font_family_map;
  
  ::blink::HashMap<::blink::String, ::blink::String> sans_serif_font_family_map;
  
  ::blink::HashMap<::blink::String, ::blink::String> cursive_font_family_map;
  
  ::blink::HashMap<::blink::String, ::blink::String> fantasy_font_family_map;
  
  ::blink::HashMap<::blink::String, ::blink::String> math_font_family_map;
  
  int32_t default_font_size;
  
  int32_t default_fixed_font_size;
  
  int32_t minimum_font_size;
  
  int32_t minimum_logical_font_size;
  
  ::blink::String default_encoding;
  
  bool always_show_context_menu_on_touch;
  
  bool context_menu_on_mouse_up;
  
  bool javascript_enabled;
  
  bool web_security_enabled;
  
  bool loads_images_automatically;
  
  bool images_enabled;
  
  bool plugins_enabled;
  
  bool dom_paste_enabled;
  
  bool shrinks_standalone_images_to_fit;
  
  bool text_areas_are_resizable;
  
  bool allow_scripts_to_close_windows;
  
  bool allow_window_focus_without_user_gesture;
  
  bool remote_fonts_enabled;
  
  bool javascript_can_access_clipboard;
  
  bool dns_prefetching_enabled;
  
  bool data_saver_enabled;
  
  bool local_storage_enabled;
  
  bool tabs_to_links;
  
  bool disable_ipc_flooding_protection;
  
  bool hyperlink_auditing_enabled;
  
  bool allow_universal_access_from_file_urls;
  
  bool allow_file_access_from_file_urls;
  
  bool webgl1_enabled;
  
  bool webgl2_enabled;
  
  bool privileged_webgl_extensions_enabled;
  
  bool webgl_errors_to_console_enabled;
  
  bool hide_scrollbars;
  
  bool prefers_default_scrollbar_styles;
  
  bool accelerated_2d_canvas_enabled;
  
  bool canvas_2d_layers_enabled;
  
  bool antialiased_2d_canvas_disabled;
  
  bool antialiased_clips_2d_canvas_enabled;
  
  bool accelerated_filters_enabled;
  
  bool deferred_filters_enabled;
  
  bool container_culling_enabled;
  
  bool allow_running_insecure_content;
  
  bool disable_reading_from_canvas;
  
  bool strict_mixed_content_checking;
  
  bool strict_powerful_feature_restrictions;
  
  bool allow_geolocation_on_insecure_origins;
  
  bool strictly_block_blockable_mixed_content;
  
  bool block_mixed_plugin_content;
  
  bool password_echo_enabled_physical;
  
  bool password_echo_enabled_touch;
  
  bool should_clear_document_background;
  
  bool enable_scroll_animator;
  
  bool prefers_reduced_motion;
  
  bool prefers_reduced_transparency;
  
  bool inverted_colors;
  
  bool touch_event_feature_detection_enabled;
  
  int32_t pointer_events_max_touch_points;
  
  int32_t available_pointer_types;
  
  PointerType primary_pointer_type;
  
  OutputDeviceUpdateAbilityType output_device_update_ability_type;
  
  int32_t available_hover_types;
  
  HoverType primary_hover_type;
  
  bool dont_send_key_events_to_javascript;
  
  bool barrel_button_for_drag_enabled;
  
  bool sync_xhr_in_documents_enabled;
  
  bool target_blank_implies_no_opener_enabled_will_be_removed;
  
  bool ignore_permission_for_device_changed_event;
  
  int32_t number_of_cpu_cores;
  
  EditingBehavior editing_behavior;
  
  bool supports_multiple_windows;
  
  bool viewport_enabled;
  
  bool viewport_meta_enabled;
  
  bool auto_zoom_focused_editable_to_legible_scale;
  
  bool shrinks_viewport_contents_to_fit;
  
  ViewportStyle viewport_style;
  
  bool smooth_scroll_for_find_enabled;
  
  bool main_frame_resizes_are_orientation_changes;
  
  bool initialize_at_minimum_page_scale;
  
  bool smart_insert_delete_enabled;
  
  bool spatial_navigation_enabled;
  
  ::blink::mojom::blink::V8CacheOptions v8_cache_options;
  
  bool record_whole_document;
  
  bool stylus_handwriting_enabled;
  
  bool cookie_enabled;
  
  bool accelerated_video_decode_enabled;
  
  ImageAnimationPolicy animation_policy;
  
  bool user_gesture_required_for_presentation;
  
  bool text_tracks_enabled;
  
  ::blink::String text_track_background_color;
  
  ::blink::String text_track_text_color;
  
  ::blink::String text_track_text_size;
  
  ::blink::String text_track_text_shadow;
  
  ::blink::String text_track_font_family;
  
  ::blink::String text_track_font_style;
  
  ::blink::String text_track_font_variant;
  
  ::blink::String text_track_window_color;
  
  ::blink::String text_track_window_radius;
  
  float text_track_margin_percentage;
  
  bool immersive_mode_enabled;
  
  bool double_tap_to_zoom_enabled;
  
  bool fullscreen_supported;
  
  bool text_autosizing_enabled;
  
  ::blink::KURL web_app_scope;
  
  bool force_dark_mode_enabled;
  
  float default_minimum_page_scale_factor;
  
  float default_maximum_page_scale_factor;
  
  bool hide_download_ui;
  
  bool presentation_receiver;
  
  bool media_controls_enabled;
  
  bool do_not_update_selection_on_mutating_selection_range;
  
  AutoplayPolicy autoplay_policy;
  
  bool require_transient_activation_for_get_display_media;
  
  bool require_transient_activation_for_show_file_or_directory_picker;
  
  bool require_transient_activation_and_user_confirmation_for_subapps_api;
  
  bool in_forced_colors;
  
  bool is_forced_colors_disabled;
  
  std::optional<::SkColor> root_scrollbar_theme_color;
  
  ::blink::mojom::blink::PreferredColorScheme preferred_root_scrollbar_color_scheme;
  
  ::blink::mojom::blink::PreferredColorScheme preferred_color_scheme;
  
  ::blink::mojom::blink::PreferredContrast preferred_contrast;
  
  EffectiveConnectionType low_priority_iframes_threshold;
  
  bool picture_in_picture_enabled;
  
  bool translate_service_available;
  
  EffectiveConnectionType network_quality_estimator_web_holdback;
  
  bool lazy_load_enabled;
  
  bool allow_mixed_content_upgrades;
  
  bool always_show_focus;
  
  bool touch_drag_drop_enabled;
  
  bool touch_dragend_context_menu;
  
  bool webxr_immersive_ar_allowed;
  
  bool renderer_wide_named_frame_lookup;
  
  bool strict_mime_type_check_for_worker_scripts_enabled;
  
  bool modal_context_menu;
  
  bool payment_request_enabled;
  
  bool ai_prompt_api_enabled;
  
  bool should_disable_external_popups;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, WebPreferences::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, WebPreferences::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, WebPreferences::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, WebPreferences::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
WebPreferencesPtr WebPreferences::Clone() const {
  return New(
      mojo::Clone(standard_font_family_map),
      mojo::Clone(fixed_font_family_map),
      mojo::Clone(serif_font_family_map),
      mojo::Clone(sans_serif_font_family_map),
      mojo::Clone(cursive_font_family_map),
      mojo::Clone(fantasy_font_family_map),
      mojo::Clone(math_font_family_map),
      mojo::Clone(default_font_size),
      mojo::Clone(default_fixed_font_size),
      mojo::Clone(minimum_font_size),
      mojo::Clone(minimum_logical_font_size),
      mojo::Clone(default_encoding),
      mojo::Clone(always_show_context_menu_on_touch),
      mojo::Clone(context_menu_on_mouse_up),
      mojo::Clone(javascript_enabled),
      mojo::Clone(web_security_enabled),
      mojo::Clone(loads_images_automatically),
      mojo::Clone(images_enabled),
      mojo::Clone(plugins_enabled),
      mojo::Clone(dom_paste_enabled),
      mojo::Clone(shrinks_standalone_images_to_fit),
      mojo::Clone(text_areas_are_resizable),
      mojo::Clone(allow_scripts_to_close_windows),
      mojo::Clone(allow_window_focus_without_user_gesture),
      mojo::Clone(remote_fonts_enabled),
      mojo::Clone(javascript_can_access_clipboard),
      mojo::Clone(dns_prefetching_enabled),
      mojo::Clone(data_saver_enabled),
      mojo::Clone(local_storage_enabled),
      mojo::Clone(tabs_to_links),
      mojo::Clone(disable_ipc_flooding_protection),
      mojo::Clone(hyperlink_auditing_enabled),
      mojo::Clone(allow_universal_access_from_file_urls),
      mojo::Clone(allow_file_access_from_file_urls),
      mojo::Clone(webgl1_enabled),
      mojo::Clone(webgl2_enabled),
      mojo::Clone(privileged_webgl_extensions_enabled),
      mojo::Clone(webgl_errors_to_console_enabled),
      mojo::Clone(hide_scrollbars),
      mojo::Clone(prefers_default_scrollbar_styles),
      mojo::Clone(accelerated_2d_canvas_enabled),
      mojo::Clone(canvas_2d_layers_enabled),
      mojo::Clone(antialiased_2d_canvas_disabled),
      mojo::Clone(antialiased_clips_2d_canvas_enabled),
      mojo::Clone(accelerated_filters_enabled),
      mojo::Clone(deferred_filters_enabled),
      mojo::Clone(container_culling_enabled),
      mojo::Clone(allow_running_insecure_content),
      mojo::Clone(disable_reading_from_canvas),
      mojo::Clone(strict_mixed_content_checking),
      mojo::Clone(strict_powerful_feature_restrictions),
      mojo::Clone(allow_geolocation_on_insecure_origins),
      mojo::Clone(strictly_block_blockable_mixed_content),
      mojo::Clone(block_mixed_plugin_content),
      mojo::Clone(password_echo_enabled_physical),
      mojo::Clone(password_echo_enabled_touch),
      mojo::Clone(should_clear_document_background),
      mojo::Clone(enable_scroll_animator),
      mojo::Clone(prefers_reduced_motion),
      mojo::Clone(prefers_reduced_transparency),
      mojo::Clone(inverted_colors),
      mojo::Clone(touch_event_feature_detection_enabled),
      mojo::Clone(pointer_events_max_touch_points),
      mojo::Clone(available_pointer_types),
      mojo::Clone(primary_pointer_type),
      mojo::Clone(output_device_update_ability_type),
      mojo::Clone(available_hover_types),
      mojo::Clone(primary_hover_type),
      mojo::Clone(dont_send_key_events_to_javascript),
      mojo::Clone(barrel_button_for_drag_enabled),
      mojo::Clone(sync_xhr_in_documents_enabled),
      mojo::Clone(target_blank_implies_no_opener_enabled_will_be_removed),
      mojo::Clone(ignore_permission_for_device_changed_event),
      mojo::Clone(number_of_cpu_cores),
      mojo::Clone(editing_behavior),
      mojo::Clone(supports_multiple_windows),
      mojo::Clone(viewport_enabled),
      mojo::Clone(viewport_meta_enabled),
      mojo::Clone(auto_zoom_focused_editable_to_legible_scale),
      mojo::Clone(shrinks_viewport_contents_to_fit),
      mojo::Clone(viewport_style),
      mojo::Clone(smooth_scroll_for_find_enabled),
      mojo::Clone(main_frame_resizes_are_orientation_changes),
      mojo::Clone(initialize_at_minimum_page_scale),
      mojo::Clone(smart_insert_delete_enabled),
      mojo::Clone(spatial_navigation_enabled),
      mojo::Clone(v8_cache_options),
      mojo::Clone(record_whole_document),
      mojo::Clone(stylus_handwriting_enabled),
      mojo::Clone(cookie_enabled),
      mojo::Clone(accelerated_video_decode_enabled),
      mojo::Clone(animation_policy),
      mojo::Clone(user_gesture_required_for_presentation),
      mojo::Clone(text_tracks_enabled),
      mojo::Clone(text_track_background_color),
      mojo::Clone(text_track_text_color),
      mojo::Clone(text_track_text_size),
      mojo::Clone(text_track_text_shadow),
      mojo::Clone(text_track_font_family),
      mojo::Clone(text_track_font_style),
      mojo::Clone(text_track_font_variant),
      mojo::Clone(text_track_window_color),
      mojo::Clone(text_track_window_radius),
      mojo::Clone(text_track_margin_percentage),
      mojo::Clone(immersive_mode_enabled),
      mojo::Clone(double_tap_to_zoom_enabled),
      mojo::Clone(fullscreen_supported),
      mojo::Clone(text_autosizing_enabled),
      mojo::Clone(web_app_scope),
      mojo::Clone(force_dark_mode_enabled),
      mojo::Clone(default_minimum_page_scale_factor),
      mojo::Clone(default_maximum_page_scale_factor),
      mojo::Clone(hide_download_ui),
      mojo::Clone(presentation_receiver),
      mojo::Clone(media_controls_enabled),
      mojo::Clone(do_not_update_selection_on_mutating_selection_range),
      mojo::Clone(autoplay_policy),
      mojo::Clone(require_transient_activation_for_get_display_media),
      mojo::Clone(require_transient_activation_for_show_file_or_directory_picker),
      mojo::Clone(require_transient_activation_and_user_confirmation_for_subapps_api),
      mojo::Clone(in_forced_colors),
      mojo::Clone(is_forced_colors_disabled),
      mojo::Clone(root_scrollbar_theme_color),
      mojo::Clone(preferred_root_scrollbar_color_scheme),
      mojo::Clone(preferred_color_scheme),
      mojo::Clone(preferred_contrast),
      mojo::Clone(low_priority_iframes_threshold),
      mojo::Clone(picture_in_picture_enabled),
      mojo::Clone(translate_service_available),
      mojo::Clone(network_quality_estimator_web_holdback),
      mojo::Clone(lazy_load_enabled),
      mojo::Clone(allow_mixed_content_upgrades),
      mojo::Clone(always_show_focus),
      mojo::Clone(touch_drag_drop_enabled),
      mojo::Clone(touch_dragend_context_menu),
      mojo::Clone(webxr_immersive_ar_allowed),
      mojo::Clone(renderer_wide_named_frame_lookup),
      mojo::Clone(strict_mime_type_check_for_worker_scripts_enabled),
      mojo::Clone(modal_context_menu),
      mojo::Clone(payment_request_enabled),
      mojo::Clone(ai_prompt_api_enabled),
      mojo::Clone(should_disable_external_popups)
  );
}

template <typename T, WebPreferences::EnableIfSame<T>*>
bool WebPreferences::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->standard_font_family_map, other_struct.standard_font_family_map))
    return false;
  if (!mojo::Equals(this->fixed_font_family_map, other_struct.fixed_font_family_map))
    return false;
  if (!mojo::Equals(this->serif_font_family_map, other_struct.serif_font_family_map))
    return false;
  if (!mojo::Equals(this->sans_serif_font_family_map, other_struct.sans_serif_font_family_map))
    return false;
  if (!mojo::Equals(this->cursive_font_family_map, other_struct.cursive_font_family_map))
    return false;
  if (!mojo::Equals(this->fantasy_font_family_map, other_struct.fantasy_font_family_map))
    return false;
  if (!mojo::Equals(this->math_font_family_map, other_struct.math_font_family_map))
    return false;
  if (!mojo::Equals(this->default_font_size, other_struct.default_font_size))
    return false;
  if (!mojo::Equals(this->default_fixed_font_size, other_struct.default_fixed_font_size))
    return false;
  if (!mojo::Equals(this->minimum_font_size, other_struct.minimum_font_size))
    return false;
  if (!mojo::Equals(this->minimum_logical_font_size, other_struct.minimum_logical_font_size))
    return false;
  if (!mojo::Equals(this->default_encoding, other_struct.default_encoding))
    return false;
  if (!mojo::Equals(this->always_show_context_menu_on_touch, other_struct.always_show_context_menu_on_touch))
    return false;
  if (!mojo::Equals(this->context_menu_on_mouse_up, other_struct.context_menu_on_mouse_up))
    return false;
  if (!mojo::Equals(this->javascript_enabled, other_struct.javascript_enabled))
    return false;
  if (!mojo::Equals(this->web_security_enabled, other_struct.web_security_enabled))
    return false;
  if (!mojo::Equals(this->loads_images_automatically, other_struct.loads_images_automatically))
    return false;
  if (!mojo::Equals(this->images_enabled, other_struct.images_enabled))
    return false;
  if (!mojo::Equals(this->plugins_enabled, other_struct.plugins_enabled))
    return false;
  if (!mojo::Equals(this->dom_paste_enabled, other_struct.dom_paste_enabled))
    return false;
  if (!mojo::Equals(this->shrinks_standalone_images_to_fit, other_struct.shrinks_standalone_images_to_fit))
    return false;
  if (!mojo::Equals(this->text_areas_are_resizable, other_struct.text_areas_are_resizable))
    return false;
  if (!mojo::Equals(this->allow_scripts_to_close_windows, other_struct.allow_scripts_to_close_windows))
    return false;
  if (!mojo::Equals(this->allow_window_focus_without_user_gesture, other_struct.allow_window_focus_without_user_gesture))
    return false;
  if (!mojo::Equals(this->remote_fonts_enabled, other_struct.remote_fonts_enabled))
    return false;
  if (!mojo::Equals(this->javascript_can_access_clipboard, other_struct.javascript_can_access_clipboard))
    return false;
  if (!mojo::Equals(this->dns_prefetching_enabled, other_struct.dns_prefetching_enabled))
    return false;
  if (!mojo::Equals(this->data_saver_enabled, other_struct.data_saver_enabled))
    return false;
  if (!mojo::Equals(this->local_storage_enabled, other_struct.local_storage_enabled))
    return false;
  if (!mojo::Equals(this->tabs_to_links, other_struct.tabs_to_links))
    return false;
  if (!mojo::Equals(this->disable_ipc_flooding_protection, other_struct.disable_ipc_flooding_protection))
    return false;
  if (!mojo::Equals(this->hyperlink_auditing_enabled, other_struct.hyperlink_auditing_enabled))
    return false;
  if (!mojo::Equals(this->allow_universal_access_from_file_urls, other_struct.allow_universal_access_from_file_urls))
    return false;
  if (!mojo::Equals(this->allow_file_access_from_file_urls, other_struct.allow_file_access_from_file_urls))
    return false;
  if (!mojo::Equals(this->webgl1_enabled, other_struct.webgl1_enabled))
    return false;
  if (!mojo::Equals(this->webgl2_enabled, other_struct.webgl2_enabled))
    return false;
  if (!mojo::Equals(this->privileged_webgl_extensions_enabled, other_struct.privileged_webgl_extensions_enabled))
    return false;
  if (!mojo::Equals(this->webgl_errors_to_console_enabled, other_struct.webgl_errors_to_console_enabled))
    return false;
  if (!mojo::Equals(this->hide_scrollbars, other_struct.hide_scrollbars))
    return false;
  if (!mojo::Equals(this->prefers_default_scrollbar_styles, other_struct.prefers_default_scrollbar_styles))
    return false;
  if (!mojo::Equals(this->accelerated_2d_canvas_enabled, other_struct.accelerated_2d_canvas_enabled))
    return false;
  if (!mojo::Equals(this->canvas_2d_layers_enabled, other_struct.canvas_2d_layers_enabled))
    return false;
  if (!mojo::Equals(this->antialiased_2d_canvas_disabled, other_struct.antialiased_2d_canvas_disabled))
    return false;
  if (!mojo::Equals(this->antialiased_clips_2d_canvas_enabled, other_struct.antialiased_clips_2d_canvas_enabled))
    return false;
  if (!mojo::Equals(this->accelerated_filters_enabled, other_struct.accelerated_filters_enabled))
    return false;
  if (!mojo::Equals(this->deferred_filters_enabled, other_struct.deferred_filters_enabled))
    return false;
  if (!mojo::Equals(this->container_culling_enabled, other_struct.container_culling_enabled))
    return false;
  if (!mojo::Equals(this->allow_running_insecure_content, other_struct.allow_running_insecure_content))
    return false;
  if (!mojo::Equals(this->disable_reading_from_canvas, other_struct.disable_reading_from_canvas))
    return false;
  if (!mojo::Equals(this->strict_mixed_content_checking, other_struct.strict_mixed_content_checking))
    return false;
  if (!mojo::Equals(this->strict_powerful_feature_restrictions, other_struct.strict_powerful_feature_restrictions))
    return false;
  if (!mojo::Equals(this->allow_geolocation_on_insecure_origins, other_struct.allow_geolocation_on_insecure_origins))
    return false;
  if (!mojo::Equals(this->strictly_block_blockable_mixed_content, other_struct.strictly_block_blockable_mixed_content))
    return false;
  if (!mojo::Equals(this->block_mixed_plugin_content, other_struct.block_mixed_plugin_content))
    return false;
  if (!mojo::Equals(this->password_echo_enabled_physical, other_struct.password_echo_enabled_physical))
    return false;
  if (!mojo::Equals(this->password_echo_enabled_touch, other_struct.password_echo_enabled_touch))
    return false;
  if (!mojo::Equals(this->should_clear_document_background, other_struct.should_clear_document_background))
    return false;
  if (!mojo::Equals(this->enable_scroll_animator, other_struct.enable_scroll_animator))
    return false;
  if (!mojo::Equals(this->prefers_reduced_motion, other_struct.prefers_reduced_motion))
    return false;
  if (!mojo::Equals(this->prefers_reduced_transparency, other_struct.prefers_reduced_transparency))
    return false;
  if (!mojo::Equals(this->inverted_colors, other_struct.inverted_colors))
    return false;
  if (!mojo::Equals(this->touch_event_feature_detection_enabled, other_struct.touch_event_feature_detection_enabled))
    return false;
  if (!mojo::Equals(this->pointer_events_max_touch_points, other_struct.pointer_events_max_touch_points))
    return false;
  if (!mojo::Equals(this->available_pointer_types, other_struct.available_pointer_types))
    return false;
  if (!mojo::Equals(this->primary_pointer_type, other_struct.primary_pointer_type))
    return false;
  if (!mojo::Equals(this->output_device_update_ability_type, other_struct.output_device_update_ability_type))
    return false;
  if (!mojo::Equals(this->available_hover_types, other_struct.available_hover_types))
    return false;
  if (!mojo::Equals(this->primary_hover_type, other_struct.primary_hover_type))
    return false;
  if (!mojo::Equals(this->dont_send_key_events_to_javascript, other_struct.dont_send_key_events_to_javascript))
    return false;
  if (!mojo::Equals(this->barrel_button_for_drag_enabled, other_struct.barrel_button_for_drag_enabled))
    return false;
  if (!mojo::Equals(this->sync_xhr_in_documents_enabled, other_struct.sync_xhr_in_documents_enabled))
    return false;
  if (!mojo::Equals(this->target_blank_implies_no_opener_enabled_will_be_removed, other_struct.target_blank_implies_no_opener_enabled_will_be_removed))
    return false;
  if (!mojo::Equals(this->ignore_permission_for_device_changed_event, other_struct.ignore_permission_for_device_changed_event))
    return false;
  if (!mojo::Equals(this->number_of_cpu_cores, other_struct.number_of_cpu_cores))
    return false;
  if (!mojo::Equals(this->editing_behavior, other_struct.editing_behavior))
    return false;
  if (!mojo::Equals(this->supports_multiple_windows, other_struct.supports_multiple_windows))
    return false;
  if (!mojo::Equals(this->viewport_enabled, other_struct.viewport_enabled))
    return false;
  if (!mojo::Equals(this->viewport_meta_enabled, other_struct.viewport_meta_enabled))
    return false;
  if (!mojo::Equals(this->auto_zoom_focused_editable_to_legible_scale, other_struct.auto_zoom_focused_editable_to_legible_scale))
    return false;
  if (!mojo::Equals(this->shrinks_viewport_contents_to_fit, other_struct.shrinks_viewport_contents_to_fit))
    return false;
  if (!mojo::Equals(this->viewport_style, other_struct.viewport_style))
    return false;
  if (!mojo::Equals(this->smooth_scroll_for_find_enabled, other_struct.smooth_scroll_for_find_enabled))
    return false;
  if (!mojo::Equals(this->main_frame_resizes_are_orientation_changes, other_struct.main_frame_resizes_are_orientation_changes))
    return false;
  if (!mojo::Equals(this->initialize_at_minimum_page_scale, other_struct.initialize_at_minimum_page_scale))
    return false;
  if (!mojo::Equals(this->smart_insert_delete_enabled, other_struct.smart_insert_delete_enabled))
    return false;
  if (!mojo::Equals(this->spatial_navigation_enabled, other_struct.spatial_navigation_enabled))
    return false;
  if (!mojo::Equals(this->v8_cache_options, other_struct.v8_cache_options))
    return false;
  if (!mojo::Equals(this->record_whole_document, other_struct.record_whole_document))
    return false;
  if (!mojo::Equals(this->stylus_handwriting_enabled, other_struct.stylus_handwriting_enabled))
    return false;
  if (!mojo::Equals(this->cookie_enabled, other_struct.cookie_enabled))
    return false;
  if (!mojo::Equals(this->accelerated_video_decode_enabled, other_struct.accelerated_video_decode_enabled))
    return false;
  if (!mojo::Equals(this->animation_policy, other_struct.animation_policy))
    return false;
  if (!mojo::Equals(this->user_gesture_required_for_presentation, other_struct.user_gesture_required_for_presentation))
    return false;
  if (!mojo::Equals(this->text_tracks_enabled, other_struct.text_tracks_enabled))
    return false;
  if (!mojo::Equals(this->text_track_background_color, other_struct.text_track_background_color))
    return false;
  if (!mojo::Equals(this->text_track_text_color, other_struct.text_track_text_color))
    return false;
  if (!mojo::Equals(this->text_track_text_size, other_struct.text_track_text_size))
    return false;
  if (!mojo::Equals(this->text_track_text_shadow, other_struct.text_track_text_shadow))
    return false;
  if (!mojo::Equals(this->text_track_font_family, other_struct.text_track_font_family))
    return false;
  if (!mojo::Equals(this->text_track_font_style, other_struct.text_track_font_style))
    return false;
  if (!mojo::Equals(this->text_track_font_variant, other_struct.text_track_font_variant))
    return false;
  if (!mojo::Equals(this->text_track_window_color, other_struct.text_track_window_color))
    return false;
  if (!mojo::Equals(this->text_track_window_radius, other_struct.text_track_window_radius))
    return false;
  if (!mojo::Equals(this->text_track_margin_percentage, other_struct.text_track_margin_percentage))
    return false;
  if (!mojo::Equals(this->immersive_mode_enabled, other_struct.immersive_mode_enabled))
    return false;
  if (!mojo::Equals(this->double_tap_to_zoom_enabled, other_struct.double_tap_to_zoom_enabled))
    return false;
  if (!mojo::Equals(this->fullscreen_supported, other_struct.fullscreen_supported))
    return false;
  if (!mojo::Equals(this->text_autosizing_enabled, other_struct.text_autosizing_enabled))
    return false;
  if (!mojo::Equals(this->web_app_scope, other_struct.web_app_scope))
    return false;
  if (!mojo::Equals(this->force_dark_mode_enabled, other_struct.force_dark_mode_enabled))
    return false;
  if (!mojo::Equals(this->default_minimum_page_scale_factor, other_struct.default_minimum_page_scale_factor))
    return false;
  if (!mojo::Equals(this->default_maximum_page_scale_factor, other_struct.default_maximum_page_scale_factor))
    return false;
  if (!mojo::Equals(this->hide_download_ui, other_struct.hide_download_ui))
    return false;
  if (!mojo::Equals(this->presentation_receiver, other_struct.presentation_receiver))
    return false;
  if (!mojo::Equals(this->media_controls_enabled, other_struct.media_controls_enabled))
    return false;
  if (!mojo::Equals(this->do_not_update_selection_on_mutating_selection_range, other_struct.do_not_update_selection_on_mutating_selection_range))
    return false;
  if (!mojo::Equals(this->autoplay_policy, other_struct.autoplay_policy))
    return false;
  if (!mojo::Equals(this->require_transient_activation_for_get_display_media, other_struct.require_transient_activation_for_get_display_media))
    return false;
  if (!mojo::Equals(this->require_transient_activation_for_show_file_or_directory_picker, other_struct.require_transient_activation_for_show_file_or_directory_picker))
    return false;
  if (!mojo::Equals(this->require_transient_activation_and_user_confirmation_for_subapps_api, other_struct.require_transient_activation_and_user_confirmation_for_subapps_api))
    return false;
  if (!mojo::Equals(this->in_forced_colors, other_struct.in_forced_colors))
    return false;
  if (!mojo::Equals(this->is_forced_colors_disabled, other_struct.is_forced_colors_disabled))
    return false;
  if (!mojo::Equals(this->root_scrollbar_theme_color, other_struct.root_scrollbar_theme_color))
    return false;
  if (!mojo::Equals(this->preferred_root_scrollbar_color_scheme, other_struct.preferred_root_scrollbar_color_scheme))
    return false;
  if (!mojo::Equals(this->preferred_color_scheme, other_struct.preferred_color_scheme))
    return false;
  if (!mojo::Equals(this->preferred_contrast, other_struct.preferred_contrast))
    return false;
  if (!mojo::Equals(this->low_priority_iframes_threshold, other_struct.low_priority_iframes_threshold))
    return false;
  if (!mojo::Equals(this->picture_in_picture_enabled, other_struct.picture_in_picture_enabled))
    return false;
  if (!mojo::Equals(this->translate_service_available, other_struct.translate_service_available))
    return false;
  if (!mojo::Equals(this->network_quality_estimator_web_holdback, other_struct.network_quality_estimator_web_holdback))
    return false;
  if (!mojo::Equals(this->lazy_load_enabled, other_struct.lazy_load_enabled))
    return false;
  if (!mojo::Equals(this->allow_mixed_content_upgrades, other_struct.allow_mixed_content_upgrades))
    return false;
  if (!mojo::Equals(this->always_show_focus, other_struct.always_show_focus))
    return false;
  if (!mojo::Equals(this->touch_drag_drop_enabled, other_struct.touch_drag_drop_enabled))
    return false;
  if (!mojo::Equals(this->touch_dragend_context_menu, other_struct.touch_dragend_context_menu))
    return false;
  if (!mojo::Equals(this->webxr_immersive_ar_allowed, other_struct.webxr_immersive_ar_allowed))
    return false;
  if (!mojo::Equals(this->renderer_wide_named_frame_lookup, other_struct.renderer_wide_named_frame_lookup))
    return false;
  if (!mojo::Equals(this->strict_mime_type_check_for_worker_scripts_enabled, other_struct.strict_mime_type_check_for_worker_scripts_enabled))
    return false;
  if (!mojo::Equals(this->modal_context_menu, other_struct.modal_context_menu))
    return false;
  if (!mojo::Equals(this->payment_request_enabled, other_struct.payment_request_enabled))
    return false;
  if (!mojo::Equals(this->ai_prompt_api_enabled, other_struct.ai_prompt_api_enabled))
    return false;
  if (!mojo::Equals(this->should_disable_external_popups, other_struct.should_disable_external_popups))
    return false;
  return true;
}

template <typename T, WebPreferences::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.standard_font_family_map < rhs.standard_font_family_map)
    return true;
  if (rhs.standard_font_family_map < lhs.standard_font_family_map)
    return false;
  if (lhs.fixed_font_family_map < rhs.fixed_font_family_map)
    return true;
  if (rhs.fixed_font_family_map < lhs.fixed_font_family_map)
    return false;
  if (lhs.serif_font_family_map < rhs.serif_font_family_map)
    return true;
  if (rhs.serif_font_family_map < lhs.serif_font_family_map)
    return false;
  if (lhs.sans_serif_font_family_map < rhs.sans_serif_font_family_map)
    return true;
  if (rhs.sans_serif_font_family_map < lhs.sans_serif_font_family_map)
    return false;
  if (lhs.cursive_font_family_map < rhs.cursive_font_family_map)
    return true;
  if (rhs.cursive_font_family_map < lhs.cursive_font_family_map)
    return false;
  if (lhs.fantasy_font_family_map < rhs.fantasy_font_family_map)
    return true;
  if (rhs.fantasy_font_family_map < lhs.fantasy_font_family_map)
    return false;
  if (lhs.math_font_family_map < rhs.math_font_family_map)
    return true;
  if (rhs.math_font_family_map < lhs.math_font_family_map)
    return false;
  if (lhs.default_font_size < rhs.default_font_size)
    return true;
  if (rhs.default_font_size < lhs.default_font_size)
    return false;
  if (lhs.default_fixed_font_size < rhs.default_fixed_font_size)
    return true;
  if (rhs.default_fixed_font_size < lhs.default_fixed_font_size)
    return false;
  if (lhs.minimum_font_size < rhs.minimum_font_size)
    return true;
  if (rhs.minimum_font_size < lhs.minimum_font_size)
    return false;
  if (lhs.minimum_logical_font_size < rhs.minimum_logical_font_size)
    return true;
  if (rhs.minimum_logical_font_size < lhs.minimum_logical_font_size)
    return false;
  if (lhs.default_encoding < rhs.default_encoding)
    return true;
  if (rhs.default_encoding < lhs.default_encoding)
    return false;
  if (lhs.always_show_context_menu_on_touch < rhs.always_show_context_menu_on_touch)
    return true;
  if (rhs.always_show_context_menu_on_touch < lhs.always_show_context_menu_on_touch)
    return false;
  if (lhs.context_menu_on_mouse_up < rhs.context_menu_on_mouse_up)
    return true;
  if (rhs.context_menu_on_mouse_up < lhs.context_menu_on_mouse_up)
    return false;
  if (lhs.javascript_enabled < rhs.javascript_enabled)
    return true;
  if (rhs.javascript_enabled < lhs.javascript_enabled)
    return false;
  if (lhs.web_security_enabled < rhs.web_security_enabled)
    return true;
  if (rhs.web_security_enabled < lhs.web_security_enabled)
    return false;
  if (lhs.loads_images_automatically < rhs.loads_images_automatically)
    return true;
  if (rhs.loads_images_automatically < lhs.loads_images_automatically)
    return false;
  if (lhs.images_enabled < rhs.images_enabled)
    return true;
  if (rhs.images_enabled < lhs.images_enabled)
    return false;
  if (lhs.plugins_enabled < rhs.plugins_enabled)
    return true;
  if (rhs.plugins_enabled < lhs.plugins_enabled)
    return false;
  if (lhs.dom_paste_enabled < rhs.dom_paste_enabled)
    return true;
  if (rhs.dom_paste_enabled < lhs.dom_paste_enabled)
    return false;
  if (lhs.shrinks_standalone_images_to_fit < rhs.shrinks_standalone_images_to_fit)
    return true;
  if (rhs.shrinks_standalone_images_to_fit < lhs.shrinks_standalone_images_to_fit)
    return false;
  if (lhs.text_areas_are_resizable < rhs.text_areas_are_resizable)
    return true;
  if (rhs.text_areas_are_resizable < lhs.text_areas_are_resizable)
    return false;
  if (lhs.allow_scripts_to_close_windows < rhs.allow_scripts_to_close_windows)
    return true;
  if (rhs.allow_scripts_to_close_windows < lhs.allow_scripts_to_close_windows)
    return false;
  if (lhs.allow_window_focus_without_user_gesture < rhs.allow_window_focus_without_user_gesture)
    return true;
  if (rhs.allow_window_focus_without_user_gesture < lhs.allow_window_focus_without_user_gesture)
    return false;
  if (lhs.remote_fonts_enabled < rhs.remote_fonts_enabled)
    return true;
  if (rhs.remote_fonts_enabled < lhs.remote_fonts_enabled)
    return false;
  if (lhs.javascript_can_access_clipboard < rhs.javascript_can_access_clipboard)
    return true;
  if (rhs.javascript_can_access_clipboard < lhs.javascript_can_access_clipboard)
    return false;
  if (lhs.dns_prefetching_enabled < rhs.dns_prefetching_enabled)
    return true;
  if (rhs.dns_prefetching_enabled < lhs.dns_prefetching_enabled)
    return false;
  if (lhs.data_saver_enabled < rhs.data_saver_enabled)
    return true;
  if (rhs.data_saver_enabled < lhs.data_saver_enabled)
    return false;
  if (lhs.local_storage_enabled < rhs.local_storage_enabled)
    return true;
  if (rhs.local_storage_enabled < lhs.local_storage_enabled)
    return false;
  if (lhs.tabs_to_links < rhs.tabs_to_links)
    return true;
  if (rhs.tabs_to_links < lhs.tabs_to_links)
    return false;
  if (lhs.disable_ipc_flooding_protection < rhs.disable_ipc_flooding_protection)
    return true;
  if (rhs.disable_ipc_flooding_protection < lhs.disable_ipc_flooding_protection)
    return false;
  if (lhs.hyperlink_auditing_enabled < rhs.hyperlink_auditing_enabled)
    return true;
  if (rhs.hyperlink_auditing_enabled < lhs.hyperlink_auditing_enabled)
    return false;
  if (lhs.allow_universal_access_from_file_urls < rhs.allow_universal_access_from_file_urls)
    return true;
  if (rhs.allow_universal_access_from_file_urls < lhs.allow_universal_access_from_file_urls)
    return false;
  if (lhs.allow_file_access_from_file_urls < rhs.allow_file_access_from_file_urls)
    return true;
  if (rhs.allow_file_access_from_file_urls < lhs.allow_file_access_from_file_urls)
    return false;
  if (lhs.webgl1_enabled < rhs.webgl1_enabled)
    return true;
  if (rhs.webgl1_enabled < lhs.webgl1_enabled)
    return false;
  if (lhs.webgl2_enabled < rhs.webgl2_enabled)
    return true;
  if (rhs.webgl2_enabled < lhs.webgl2_enabled)
    return false;
  if (lhs.privileged_webgl_extensions_enabled < rhs.privileged_webgl_extensions_enabled)
    return true;
  if (rhs.privileged_webgl_extensions_enabled < lhs.privileged_webgl_extensions_enabled)
    return false;
  if (lhs.webgl_errors_to_console_enabled < rhs.webgl_errors_to_console_enabled)
    return true;
  if (rhs.webgl_errors_to_console_enabled < lhs.webgl_errors_to_console_enabled)
    return false;
  if (lhs.hide_scrollbars < rhs.hide_scrollbars)
    return true;
  if (rhs.hide_scrollbars < lhs.hide_scrollbars)
    return false;
  if (lhs.prefers_default_scrollbar_styles < rhs.prefers_default_scrollbar_styles)
    return true;
  if (rhs.prefers_default_scrollbar_styles < lhs.prefers_default_scrollbar_styles)
    return false;
  if (lhs.accelerated_2d_canvas_enabled < rhs.accelerated_2d_canvas_enabled)
    return true;
  if (rhs.accelerated_2d_canvas_enabled < lhs.accelerated_2d_canvas_enabled)
    return false;
  if (lhs.canvas_2d_layers_enabled < rhs.canvas_2d_layers_enabled)
    return true;
  if (rhs.canvas_2d_layers_enabled < lhs.canvas_2d_layers_enabled)
    return false;
  if (lhs.antialiased_2d_canvas_disabled < rhs.antialiased_2d_canvas_disabled)
    return true;
  if (rhs.antialiased_2d_canvas_disabled < lhs.antialiased_2d_canvas_disabled)
    return false;
  if (lhs.antialiased_clips_2d_canvas_enabled < rhs.antialiased_clips_2d_canvas_enabled)
    return true;
  if (rhs.antialiased_clips_2d_canvas_enabled < lhs.antialiased_clips_2d_canvas_enabled)
    return false;
  if (lhs.accelerated_filters_enabled < rhs.accelerated_filters_enabled)
    return true;
  if (rhs.accelerated_filters_enabled < lhs.accelerated_filters_enabled)
    return false;
  if (lhs.deferred_filters_enabled < rhs.deferred_filters_enabled)
    return true;
  if (rhs.deferred_filters_enabled < lhs.deferred_filters_enabled)
    return false;
  if (lhs.container_culling_enabled < rhs.container_culling_enabled)
    return true;
  if (rhs.container_culling_enabled < lhs.container_culling_enabled)
    return false;
  if (lhs.allow_running_insecure_content < rhs.allow_running_insecure_content)
    return true;
  if (rhs.allow_running_insecure_content < lhs.allow_running_insecure_content)
    return false;
  if (lhs.disable_reading_from_canvas < rhs.disable_reading_from_canvas)
    return true;
  if (rhs.disable_reading_from_canvas < lhs.disable_reading_from_canvas)
    return false;
  if (lhs.strict_mixed_content_checking < rhs.strict_mixed_content_checking)
    return true;
  if (rhs.strict_mixed_content_checking < lhs.strict_mixed_content_checking)
    return false;
  if (lhs.strict_powerful_feature_restrictions < rhs.strict_powerful_feature_restrictions)
    return true;
  if (rhs.strict_powerful_feature_restrictions < lhs.strict_powerful_feature_restrictions)
    return false;
  if (lhs.allow_geolocation_on_insecure_origins < rhs.allow_geolocation_on_insecure_origins)
    return true;
  if (rhs.allow_geolocation_on_insecure_origins < lhs.allow_geolocation_on_insecure_origins)
    return false;
  if (lhs.strictly_block_blockable_mixed_content < rhs.strictly_block_blockable_mixed_content)
    return true;
  if (rhs.strictly_block_blockable_mixed_content < lhs.strictly_block_blockable_mixed_content)
    return false;
  if (lhs.block_mixed_plugin_content < rhs.block_mixed_plugin_content)
    return true;
  if (rhs.block_mixed_plugin_content < lhs.block_mixed_plugin_content)
    return false;
  if (lhs.password_echo_enabled_physical < rhs.password_echo_enabled_physical)
    return true;
  if (rhs.password_echo_enabled_physical < lhs.password_echo_enabled_physical)
    return false;
  if (lhs.password_echo_enabled_touch < rhs.password_echo_enabled_touch)
    return true;
  if (rhs.password_echo_enabled_touch < lhs.password_echo_enabled_touch)
    return false;
  if (lhs.should_clear_document_background < rhs.should_clear_document_background)
    return true;
  if (rhs.should_clear_document_background < lhs.should_clear_document_background)
    return false;
  if (lhs.enable_scroll_animator < rhs.enable_scroll_animator)
    return true;
  if (rhs.enable_scroll_animator < lhs.enable_scroll_animator)
    return false;
  if (lhs.prefers_reduced_motion < rhs.prefers_reduced_motion)
    return true;
  if (rhs.prefers_reduced_motion < lhs.prefers_reduced_motion)
    return false;
  if (lhs.prefers_reduced_transparency < rhs.prefers_reduced_transparency)
    return true;
  if (rhs.prefers_reduced_transparency < lhs.prefers_reduced_transparency)
    return false;
  if (lhs.inverted_colors < rhs.inverted_colors)
    return true;
  if (rhs.inverted_colors < lhs.inverted_colors)
    return false;
  if (lhs.touch_event_feature_detection_enabled < rhs.touch_event_feature_detection_enabled)
    return true;
  if (rhs.touch_event_feature_detection_enabled < lhs.touch_event_feature_detection_enabled)
    return false;
  if (lhs.pointer_events_max_touch_points < rhs.pointer_events_max_touch_points)
    return true;
  if (rhs.pointer_events_max_touch_points < lhs.pointer_events_max_touch_points)
    return false;
  if (lhs.available_pointer_types < rhs.available_pointer_types)
    return true;
  if (rhs.available_pointer_types < lhs.available_pointer_types)
    return false;
  if (lhs.primary_pointer_type < rhs.primary_pointer_type)
    return true;
  if (rhs.primary_pointer_type < lhs.primary_pointer_type)
    return false;
  if (lhs.output_device_update_ability_type < rhs.output_device_update_ability_type)
    return true;
  if (rhs.output_device_update_ability_type < lhs.output_device_update_ability_type)
    return false;
  if (lhs.available_hover_types < rhs.available_hover_types)
    return true;
  if (rhs.available_hover_types < lhs.available_hover_types)
    return false;
  if (lhs.primary_hover_type < rhs.primary_hover_type)
    return true;
  if (rhs.primary_hover_type < lhs.primary_hover_type)
    return false;
  if (lhs.dont_send_key_events_to_javascript < rhs.dont_send_key_events_to_javascript)
    return true;
  if (rhs.dont_send_key_events_to_javascript < lhs.dont_send_key_events_to_javascript)
    return false;
  if (lhs.barrel_button_for_drag_enabled < rhs.barrel_button_for_drag_enabled)
    return true;
  if (rhs.barrel_button_for_drag_enabled < lhs.barrel_button_for_drag_enabled)
    return false;
  if (lhs.sync_xhr_in_documents_enabled < rhs.sync_xhr_in_documents_enabled)
    return true;
  if (rhs.sync_xhr_in_documents_enabled < lhs.sync_xhr_in_documents_enabled)
    return false;
  if (lhs.target_blank_implies_no_opener_enabled_will_be_removed < rhs.target_blank_implies_no_opener_enabled_will_be_removed)
    return true;
  if (rhs.target_blank_implies_no_opener_enabled_will_be_removed < lhs.target_blank_implies_no_opener_enabled_will_be_removed)
    return false;
  if (lhs.ignore_permission_for_device_changed_event < rhs.ignore_permission_for_device_changed_event)
    return true;
  if (rhs.ignore_permission_for_device_changed_event < lhs.ignore_permission_for_device_changed_event)
    return false;
  if (lhs.number_of_cpu_cores < rhs.number_of_cpu_cores)
    return true;
  if (rhs.number_of_cpu_cores < lhs.number_of_cpu_cores)
    return false;
  if (lhs.editing_behavior < rhs.editing_behavior)
    return true;
  if (rhs.editing_behavior < lhs.editing_behavior)
    return false;
  if (lhs.supports_multiple_windows < rhs.supports_multiple_windows)
    return true;
  if (rhs.supports_multiple_windows < lhs.supports_multiple_windows)
    return false;
  if (lhs.viewport_enabled < rhs.viewport_enabled)
    return true;
  if (rhs.viewport_enabled < lhs.viewport_enabled)
    return false;
  if (lhs.viewport_meta_enabled < rhs.viewport_meta_enabled)
    return true;
  if (rhs.viewport_meta_enabled < lhs.viewport_meta_enabled)
    return false;
  if (lhs.auto_zoom_focused_editable_to_legible_scale < rhs.auto_zoom_focused_editable_to_legible_scale)
    return true;
  if (rhs.auto_zoom_focused_editable_to_legible_scale < lhs.auto_zoom_focused_editable_to_legible_scale)
    return false;
  if (lhs.shrinks_viewport_contents_to_fit < rhs.shrinks_viewport_contents_to_fit)
    return true;
  if (rhs.shrinks_viewport_contents_to_fit < lhs.shrinks_viewport_contents_to_fit)
    return false;
  if (lhs.viewport_style < rhs.viewport_style)
    return true;
  if (rhs.viewport_style < lhs.viewport_style)
    return false;
  if (lhs.smooth_scroll_for_find_enabled < rhs.smooth_scroll_for_find_enabled)
    return true;
  if (rhs.smooth_scroll_for_find_enabled < lhs.smooth_scroll_for_find_enabled)
    return false;
  if (lhs.main_frame_resizes_are_orientation_changes < rhs.main_frame_resizes_are_orientation_changes)
    return true;
  if (rhs.main_frame_resizes_are_orientation_changes < lhs.main_frame_resizes_are_orientation_changes)
    return false;
  if (lhs.initialize_at_minimum_page_scale < rhs.initialize_at_minimum_page_scale)
    return true;
  if (rhs.initialize_at_minimum_page_scale < lhs.initialize_at_minimum_page_scale)
    return false;
  if (lhs.smart_insert_delete_enabled < rhs.smart_insert_delete_enabled)
    return true;
  if (rhs.smart_insert_delete_enabled < lhs.smart_insert_delete_enabled)
    return false;
  if (lhs.spatial_navigation_enabled < rhs.spatial_navigation_enabled)
    return true;
  if (rhs.spatial_navigation_enabled < lhs.spatial_navigation_enabled)
    return false;
  if (lhs.v8_cache_options < rhs.v8_cache_options)
    return true;
  if (rhs.v8_cache_options < lhs.v8_cache_options)
    return false;
  if (lhs.record_whole_document < rhs.record_whole_document)
    return true;
  if (rhs.record_whole_document < lhs.record_whole_document)
    return false;
  if (lhs.stylus_handwriting_enabled < rhs.stylus_handwriting_enabled)
    return true;
  if (rhs.stylus_handwriting_enabled < lhs.stylus_handwriting_enabled)
    return false;
  if (lhs.cookie_enabled < rhs.cookie_enabled)
    return true;
  if (rhs.cookie_enabled < lhs.cookie_enabled)
    return false;
  if (lhs.accelerated_video_decode_enabled < rhs.accelerated_video_decode_enabled)
    return true;
  if (rhs.accelerated_video_decode_enabled < lhs.accelerated_video_decode_enabled)
    return false;
  if (lhs.animation_policy < rhs.animation_policy)
    return true;
  if (rhs.animation_policy < lhs.animation_policy)
    return false;
  if (lhs.user_gesture_required_for_presentation < rhs.user_gesture_required_for_presentation)
    return true;
  if (rhs.user_gesture_required_for_presentation < lhs.user_gesture_required_for_presentation)
    return false;
  if (lhs.text_tracks_enabled < rhs.text_tracks_enabled)
    return true;
  if (rhs.text_tracks_enabled < lhs.text_tracks_enabled)
    return false;
  if (lhs.text_track_background_color < rhs.text_track_background_color)
    return true;
  if (rhs.text_track_background_color < lhs.text_track_background_color)
    return false;
  if (lhs.text_track_text_color < rhs.text_track_text_color)
    return true;
  if (rhs.text_track_text_color < lhs.text_track_text_color)
    return false;
  if (lhs.text_track_text_size < rhs.text_track_text_size)
    return true;
  if (rhs.text_track_text_size < lhs.text_track_text_size)
    return false;
  if (lhs.text_track_text_shadow < rhs.text_track_text_shadow)
    return true;
  if (rhs.text_track_text_shadow < lhs.text_track_text_shadow)
    return false;
  if (lhs.text_track_font_family < rhs.text_track_font_family)
    return true;
  if (rhs.text_track_font_family < lhs.text_track_font_family)
    return false;
  if (lhs.text_track_font_style < rhs.text_track_font_style)
    return true;
  if (rhs.text_track_font_style < lhs.text_track_font_style)
    return false;
  if (lhs.text_track_font_variant < rhs.text_track_font_variant)
    return true;
  if (rhs.text_track_font_variant < lhs.text_track_font_variant)
    return false;
  if (lhs.text_track_window_color < rhs.text_track_window_color)
    return true;
  if (rhs.text_track_window_color < lhs.text_track_window_color)
    return false;
  if (lhs.text_track_window_radius < rhs.text_track_window_radius)
    return true;
  if (rhs.text_track_window_radius < lhs.text_track_window_radius)
    return false;
  if (lhs.text_track_margin_percentage < rhs.text_track_margin_percentage)
    return true;
  if (rhs.text_track_margin_percentage < lhs.text_track_margin_percentage)
    return false;
  if (lhs.immersive_mode_enabled < rhs.immersive_mode_enabled)
    return true;
  if (rhs.immersive_mode_enabled < lhs.immersive_mode_enabled)
    return false;
  if (lhs.double_tap_to_zoom_enabled < rhs.double_tap_to_zoom_enabled)
    return true;
  if (rhs.double_tap_to_zoom_enabled < lhs.double_tap_to_zoom_enabled)
    return false;
  if (lhs.fullscreen_supported < rhs.fullscreen_supported)
    return true;
  if (rhs.fullscreen_supported < lhs.fullscreen_supported)
    return false;
  if (lhs.text_autosizing_enabled < rhs.text_autosizing_enabled)
    return true;
  if (rhs.text_autosizing_enabled < lhs.text_autosizing_enabled)
    return false;
  if (lhs.web_app_scope < rhs.web_app_scope)
    return true;
  if (rhs.web_app_scope < lhs.web_app_scope)
    return false;
  if (lhs.force_dark_mode_enabled < rhs.force_dark_mode_enabled)
    return true;
  if (rhs.force_dark_mode_enabled < lhs.force_dark_mode_enabled)
    return false;
  if (lhs.default_minimum_page_scale_factor < rhs.default_minimum_page_scale_factor)
    return true;
  if (rhs.default_minimum_page_scale_factor < lhs.default_minimum_page_scale_factor)
    return false;
  if (lhs.default_maximum_page_scale_factor < rhs.default_maximum_page_scale_factor)
    return true;
  if (rhs.default_maximum_page_scale_factor < lhs.default_maximum_page_scale_factor)
    return false;
  if (lhs.hide_download_ui < rhs.hide_download_ui)
    return true;
  if (rhs.hide_download_ui < lhs.hide_download_ui)
    return false;
  if (lhs.presentation_receiver < rhs.presentation_receiver)
    return true;
  if (rhs.presentation_receiver < lhs.presentation_receiver)
    return false;
  if (lhs.media_controls_enabled < rhs.media_controls_enabled)
    return true;
  if (rhs.media_controls_enabled < lhs.media_controls_enabled)
    return false;
  if (lhs.do_not_update_selection_on_mutating_selection_range < rhs.do_not_update_selection_on_mutating_selection_range)
    return true;
  if (rhs.do_not_update_selection_on_mutating_selection_range < lhs.do_not_update_selection_on_mutating_selection_range)
    return false;
  if (lhs.autoplay_policy < rhs.autoplay_policy)
    return true;
  if (rhs.autoplay_policy < lhs.autoplay_policy)
    return false;
  if (lhs.require_transient_activation_for_get_display_media < rhs.require_transient_activation_for_get_display_media)
    return true;
  if (rhs.require_transient_activation_for_get_display_media < lhs.require_transient_activation_for_get_display_media)
    return false;
  if (lhs.require_transient_activation_for_show_file_or_directory_picker < rhs.require_transient_activation_for_show_file_or_directory_picker)
    return true;
  if (rhs.require_transient_activation_for_show_file_or_directory_picker < lhs.require_transient_activation_for_show_file_or_directory_picker)
    return false;
  if (lhs.require_transient_activation_and_user_confirmation_for_subapps_api < rhs.require_transient_activation_and_user_confirmation_for_subapps_api)
    return true;
  if (rhs.require_transient_activation_and_user_confirmation_for_subapps_api < lhs.require_transient_activation_and_user_confirmation_for_subapps_api)
    return false;
  if (lhs.in_forced_colors < rhs.in_forced_colors)
    return true;
  if (rhs.in_forced_colors < lhs.in_forced_colors)
    return false;
  if (lhs.is_forced_colors_disabled < rhs.is_forced_colors_disabled)
    return true;
  if (rhs.is_forced_colors_disabled < lhs.is_forced_colors_disabled)
    return false;
  if (lhs.root_scrollbar_theme_color < rhs.root_scrollbar_theme_color)
    return true;
  if (rhs.root_scrollbar_theme_color < lhs.root_scrollbar_theme_color)
    return false;
  if (lhs.preferred_root_scrollbar_color_scheme < rhs.preferred_root_scrollbar_color_scheme)
    return true;
  if (rhs.preferred_root_scrollbar_color_scheme < lhs.preferred_root_scrollbar_color_scheme)
    return false;
  if (lhs.preferred_color_scheme < rhs.preferred_color_scheme)
    return true;
  if (rhs.preferred_color_scheme < lhs.preferred_color_scheme)
    return false;
  if (lhs.preferred_contrast < rhs.preferred_contrast)
    return true;
  if (rhs.preferred_contrast < lhs.preferred_contrast)
    return false;
  if (lhs.low_priority_iframes_threshold < rhs.low_priority_iframes_threshold)
    return true;
  if (rhs.low_priority_iframes_threshold < lhs.low_priority_iframes_threshold)
    return false;
  if (lhs.picture_in_picture_enabled < rhs.picture_in_picture_enabled)
    return true;
  if (rhs.picture_in_picture_enabled < lhs.picture_in_picture_enabled)
    return false;
  if (lhs.translate_service_available < rhs.translate_service_available)
    return true;
  if (rhs.translate_service_available < lhs.translate_service_available)
    return false;
  if (lhs.network_quality_estimator_web_holdback < rhs.network_quality_estimator_web_holdback)
    return true;
  if (rhs.network_quality_estimator_web_holdback < lhs.network_quality_estimator_web_holdback)
    return false;
  if (lhs.lazy_load_enabled < rhs.lazy_load_enabled)
    return true;
  if (rhs.lazy_load_enabled < lhs.lazy_load_enabled)
    return false;
  if (lhs.allow_mixed_content_upgrades < rhs.allow_mixed_content_upgrades)
    return true;
  if (rhs.allow_mixed_content_upgrades < lhs.allow_mixed_content_upgrades)
    return false;
  if (lhs.always_show_focus < rhs.always_show_focus)
    return true;
  if (rhs.always_show_focus < lhs.always_show_focus)
    return false;
  if (lhs.touch_drag_drop_enabled < rhs.touch_drag_drop_enabled)
    return true;
  if (rhs.touch_drag_drop_enabled < lhs.touch_drag_drop_enabled)
    return false;
  if (lhs.touch_dragend_context_menu < rhs.touch_dragend_context_menu)
    return true;
  if (rhs.touch_dragend_context_menu < lhs.touch_dragend_context_menu)
    return false;
  if (lhs.webxr_immersive_ar_allowed < rhs.webxr_immersive_ar_allowed)
    return true;
  if (rhs.webxr_immersive_ar_allowed < lhs.webxr_immersive_ar_allowed)
    return false;
  if (lhs.renderer_wide_named_frame_lookup < rhs.renderer_wide_named_frame_lookup)
    return true;
  if (rhs.renderer_wide_named_frame_lookup < lhs.renderer_wide_named_frame_lookup)
    return false;
  if (lhs.strict_mime_type_check_for_worker_scripts_enabled < rhs.strict_mime_type_check_for_worker_scripts_enabled)
    return true;
  if (rhs.strict_mime_type_check_for_worker_scripts_enabled < lhs.strict_mime_type_check_for_worker_scripts_enabled)
    return false;
  if (lhs.modal_context_menu < rhs.modal_context_menu)
    return true;
  if (rhs.modal_context_menu < lhs.modal_context_menu)
    return false;
  if (lhs.payment_request_enabled < rhs.payment_request_enabled)
    return true;
  if (rhs.payment_request_enabled < lhs.payment_request_enabled)
    return false;
  if (lhs.ai_prompt_api_enabled < rhs.ai_prompt_api_enabled)
    return true;
  if (rhs.ai_prompt_api_enabled < lhs.ai_prompt_api_enabled)
    return false;
  if (lhs.should_disable_external_popups < rhs.should_disable_external_popups)
    return true;
  if (rhs.should_disable_external_popups < lhs.should_disable_external_popups)
    return false;
  return false;
}


}  // blink::mojom::blink

namespace mojo {


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::WebPreferences::DataView,
                                         ::blink::mojom::blink::WebPreferencesPtr> {
  static bool IsNull(const ::blink::mojom::blink::WebPreferencesPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::WebPreferencesPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::WebPreferences::standard_font_family_map)& standard_font_family_map(
      const ::blink::mojom::blink::WebPreferencesPtr& input) {
    return input->standard_font_family_map;
  }

  static const decltype(::blink::mojom::blink::WebPreferences::fixed_font_family_map)& fixed_font_family_map(
      const ::blink::mojom::blink::WebPreferencesPtr& input) {
    return input->fixed_font_family_map;
  }

  static const decltype(::blink::mojom::blink::WebPreferences::serif_font_family_map)& serif_font_family_map(
      const ::blink::mojom::blink::WebPreferencesPtr& input) {
    return input->serif_font_family_map;
  }

  static const decltype(::blink::mojom::blink::WebPreferences::sans_serif_font_family_map)& sans_serif_font_family_map(
      const ::blink::mojom::blink::WebPreferencesPtr& input) {
    return input->sans_serif_font_family_map;
  }

  static const decltype(::blink::mojom::blink::WebPreferences::cursive_font_family_map)& cursive_font_family_map(
      const ::blink::mojom::blink::WebPreferencesPtr& input) {
    return input->cursive_font_family_map;
  }

  static const decltype(::blink::mojom::blink::WebPreferences::fantasy_font_family_map)& fantasy_font_family_map(
      const ::blink::mojom::blink::WebPreferencesPtr& input) {
    return input->fantasy_font_family_map;
  }

  static const decltype(::blink::mojom::blink::WebPreferences::math_font_family_map)& math_font_family_map(
      const ::blink::mojom::blink::WebPreferencesPtr& input) {
    return input->math_font_family_map;
  }

  static decltype(::blink::mojom::blink::WebPreferences::default_font_size) default_font_size(
      const ::blink::mojom::blink::WebPreferencesPtr& input) {
    return input->default_font_size;
  }

  static decltype(::blink::mojom::blink::WebPreferences::default_fixed_font_size) default_fixed_font_size(
      const ::blink::mojom::blink::WebPreferencesPtr& input) {
    return input->default_fixed_font_size;
  }

  static decltype(::blink::mojom::blink::WebPreferences::minimum_font_size) minimum_font_size(
      const ::blink::mojom::blink::WebPreferencesPtr& input) {
    return input->minimum_font_size;
  }

  static decltype(::blink::mojom::blink::WebPreferences::minimum_logical_font_size) minimum_logical_font_size(
      const ::blink::mojom::blink::WebPreferencesPtr& input) {
    return input->minimum_logical_font_size;
  }

  static const decltype(::blink::mojom::blink::WebPreferences::default_encoding)& default_encoding(
      const ::blink::mojom::blink::WebPreferencesPtr& input) {
    return input->default_encoding;
  }

  static decltype(::blink::mojom::blink::WebPreferences::always_show_context_menu_on_touch) always_show_context_menu_on_touch(
      const ::blink::mojom::blink::WebPreferencesPtr& input) {
    return input->always_show_context_menu_on_touch;
  }

  static decltype(::blink::mojom::blink::WebPreferences::context_menu_on_mouse_up) context_menu_on_mouse_up(
      const ::blink::mojom::blink::WebPreferencesPtr& input) {
    return input->context_menu_on_mouse_up;
  }

  static decltype(::blink::mojom::blink::WebPreferences::javascript_enabled) javascript_enabled(
      const ::blink::mojom::blink::WebPreferencesPtr& input) {
    return input->javascript_enabled;
  }

  static decltype(::blink::mojom::blink::WebPreferences::web_security_enabled) web_security_enabled(
      const ::blink::mojom::blink::WebPreferencesPtr& input) {
    return input->web_security_enabled;
  }

  static decltype(::blink::mojom::blink::WebPreferences::loads_images_automatically) loads_images_automatically(
      const ::blink::mojom::blink::WebPreferencesPtr& input) {
    return input->loads_images_automatically;
  }

  static decltype(::blink::mojom::blink::WebPreferences::images_enabled) images_enabled(
      const ::blink::mojom::blink::WebPreferencesPtr& input) {
    return input->images_enabled;
  }

  static decltype(::blink::mojom::blink::WebPreferences::plugins_enabled) plugins_enabled(
      const ::blink::mojom::blink::WebPreferencesPtr& input) {
    return input->plugins_enabled;
  }

  static decltype(::blink::mojom::blink::WebPreferences::dom_paste_enabled) dom_paste_enabled(
      const ::blink::mojom::blink::WebPreferencesPtr& input) {
    return input->dom_paste_enabled;
  }

  static decltype(::blink::mojom::blink::WebPreferences::shrinks_standalone_images_to_fit) shrinks_standalone_images_to_fit(
      const ::blink::mojom::blink::WebPreferencesPtr& input) {
    return input->shrinks_standalone_images_to_fit;
  }

  static decltype(::blink::mojom::blink::WebPreferences::text_areas_are_resizable) text_areas_are_resizable(
      const ::blink::mojom::blink::WebPreferencesPtr& input) {
    return input->text_areas_are_resizable;
  }

  static decltype(::blink::mojom::blink::WebPreferences::allow_scripts_to_close_windows) allow_scripts_to_close_windows(
      const ::blink::mojom::blink::WebPreferencesPtr& input) {
    return input->allow_scripts_to_close_windows;
  }

  static decltype(::blink::mojom::blink::WebPreferences::allow_window_focus_without_user_gesture) allow_window_focus_without_user_gesture(
      const ::blink::mojom::blink::WebPreferencesPtr& input) {
    return input->allow_window_focus_without_user_gesture;
  }

  static decltype(::blink::mojom::blink::WebPreferences::remote_fonts_enabled) remote_fonts_enabled(
      const ::blink::mojom::blink::WebPreferencesPtr& input) {
    return input->remote_fonts_enabled;
  }

  static decltype(::blink::mojom::blink::WebPreferences::javascript_can_access_clipboard) javascript_can_access_clipboard(
      const ::blink::mojom::blink::WebPreferencesPtr& input) {
    return input->javascript_can_access_clipboard;
  }

  static decltype(::blink::mojom::blink::WebPreferences::dns_prefetching_enabled) dns_prefetching_enabled(
      const ::blink::mojom::blink::WebPreferencesPtr& input) {
    return input->dns_prefetching_enabled;
  }

  static decltype(::blink::mojom::blink::WebPreferences::data_saver_enabled) data_saver_enabled(
      const ::blink::mojom::blink::WebPreferencesPtr& input) {
    return input->data_saver_enabled;
  }

  static decltype(::blink::mojom::blink::WebPreferences::local_storage_enabled) local_storage_enabled(
      const ::blink::mojom::blink::WebPreferencesPtr& input) {
    return input->local_storage_enabled;
  }

  static decltype(::blink::mojom::blink::WebPreferences::tabs_to_links) tabs_to_links(
      const ::blink::mojom::blink::WebPreferencesPtr& input) {
    return input->tabs_to_links;
  }

  static decltype(::blink::mojom::blink::WebPreferences::disable_ipc_flooding_protection) disable_ipc_flooding_protection(
      const ::blink::mojom::blink::WebPreferencesPtr& input) {
    return input->disable_ipc_flooding_protection;
  }

  static decltype(::blink::mojom::blink::WebPreferences::hyperlink_auditing_enabled) hyperlink_auditing_enabled(
      const ::blink::mojom::blink::WebPreferencesPtr& input) {
    return input->hyperlink_auditing_enabled;
  }

  static decltype(::blink::mojom::blink::WebPreferences::allow_universal_access_from_file_urls) allow_universal_access_from_file_urls(
      const ::blink::mojom::blink::WebPreferencesPtr& input) {
    return input->allow_universal_access_from_file_urls;
  }

  static decltype(::blink::mojom::blink::WebPreferences::allow_file_access_from_file_urls) allow_file_access_from_file_urls(
      const ::blink::mojom::blink::WebPreferencesPtr& input) {
    return input->allow_file_access_from_file_urls;
  }

  static decltype(::blink::mojom::blink::WebPreferences::webgl1_enabled) webgl1_enabled(
      const ::blink::mojom::blink::WebPreferencesPtr& input) {
    return input->webgl1_enabled;
  }

  static decltype(::blink::mojom::blink::WebPreferences::webgl2_enabled) webgl2_enabled(
      const ::blink::mojom::blink::WebPreferencesPtr& input) {
    return input->webgl2_enabled;
  }

  static decltype(::blink::mojom::blink::WebPreferences::privileged_webgl_extensions_enabled) privileged_webgl_extensions_enabled(
      const ::blink::mojom::blink::WebPreferencesPtr& input) {
    return input->privileged_webgl_extensions_enabled;
  }

  static decltype(::blink::mojom::blink::WebPreferences::webgl_errors_to_console_enabled) webgl_errors_to_console_enabled(
      const ::blink::mojom::blink::WebPreferencesPtr& input) {
    return input->webgl_errors_to_console_enabled;
  }

  static decltype(::blink::mojom::blink::WebPreferences::hide_scrollbars) hide_scrollbars(
      const ::blink::mojom::blink::WebPreferencesPtr& input) {
    return input->hide_scrollbars;
  }

  static decltype(::blink::mojom::blink::WebPreferences::prefers_default_scrollbar_styles) prefers_default_scrollbar_styles(
      const ::blink::mojom::blink::WebPreferencesPtr& input) {
    return input->prefers_default_scrollbar_styles;
  }

  static decltype(::blink::mojom::blink::WebPreferences::accelerated_2d_canvas_enabled) accelerated_2d_canvas_enabled(
      const ::blink::mojom::blink::WebPreferencesPtr& input) {
    return input->accelerated_2d_canvas_enabled;
  }

  static decltype(::blink::mojom::blink::WebPreferences::canvas_2d_layers_enabled) canvas_2d_layers_enabled(
      const ::blink::mojom::blink::WebPreferencesPtr& input) {
    return input->canvas_2d_layers_enabled;
  }

  static decltype(::blink::mojom::blink::WebPreferences::antialiased_2d_canvas_disabled) antialiased_2d_canvas_disabled(
      const ::blink::mojom::blink::WebPreferencesPtr& input) {
    return input->antialiased_2d_canvas_disabled;
  }

  static decltype(::blink::mojom::blink::WebPreferences::antialiased_clips_2d_canvas_enabled) antialiased_clips_2d_canvas_enabled(
      const ::blink::mojom::blink::WebPreferencesPtr& input) {
    return input->antialiased_clips_2d_canvas_enabled;
  }

  static decltype(::blink::mojom::blink::WebPreferences::accelerated_filters_enabled) accelerated_filters_enabled(
      const ::blink::mojom::blink::WebPreferencesPtr& input) {
    return input->accelerated_filters_enabled;
  }

  static decltype(::blink::mojom::blink::WebPreferences::deferred_filters_enabled) deferred_filters_enabled(
      const ::blink::mojom::blink::WebPreferencesPtr& input) {
    return input->deferred_filters_enabled;
  }

  static decltype(::blink::mojom::blink::WebPreferences::container_culling_enabled) container_culling_enabled(
      const ::blink::mojom::blink::WebPreferencesPtr& input) {
    return input->container_culling_enabled;
  }

  static decltype(::blink::mojom::blink::WebPreferences::allow_running_insecure_content) allow_running_insecure_content(
      const ::blink::mojom::blink::WebPreferencesPtr& input) {
    return input->allow_running_insecure_content;
  }

  static decltype(::blink::mojom::blink::WebPreferences::disable_reading_from_canvas) disable_reading_from_canvas(
      const ::blink::mojom::blink::WebPreferencesPtr& input) {
    return input->disable_reading_from_canvas;
  }

  static decltype(::blink::mojom::blink::WebPreferences::strict_mixed_content_checking) strict_mixed_content_checking(
      const ::blink::mojom::blink::WebPreferencesPtr& input) {
    return input->strict_mixed_content_checking;
  }

  static decltype(::blink::mojom::blink::WebPreferences::strict_powerful_feature_restrictions) strict_powerful_feature_restrictions(
      const ::blink::mojom::blink::WebPreferencesPtr& input) {
    return input->strict_powerful_feature_restrictions;
  }

  static decltype(::blink::mojom::blink::WebPreferences::allow_geolocation_on_insecure_origins) allow_geolocation_on_insecure_origins(
      const ::blink::mojom::blink::WebPreferencesPtr& input) {
    return input->allow_geolocation_on_insecure_origins;
  }

  static decltype(::blink::mojom::blink::WebPreferences::strictly_block_blockable_mixed_content) strictly_block_blockable_mixed_content(
      const ::blink::mojom::blink::WebPreferencesPtr& input) {
    return input->strictly_block_blockable_mixed_content;
  }

  static decltype(::blink::mojom::blink::WebPreferences::block_mixed_plugin_content) block_mixed_plugin_content(
      const ::blink::mojom::blink::WebPreferencesPtr& input) {
    return input->block_mixed_plugin_content;
  }

  static decltype(::blink::mojom::blink::WebPreferences::password_echo_enabled_physical) password_echo_enabled_physical(
      const ::blink::mojom::blink::WebPreferencesPtr& input) {
    return input->password_echo_enabled_physical;
  }

  static decltype(::blink::mojom::blink::WebPreferences::password_echo_enabled_touch) password_echo_enabled_touch(
      const ::blink::mojom::blink::WebPreferencesPtr& input) {
    return input->password_echo_enabled_touch;
  }

  static decltype(::blink::mojom::blink::WebPreferences::should_clear_document_background) should_clear_document_background(
      const ::blink::mojom::blink::WebPreferencesPtr& input) {
    return input->should_clear_document_background;
  }

  static decltype(::blink::mojom::blink::WebPreferences::enable_scroll_animator) enable_scroll_animator(
      const ::blink::mojom::blink::WebPreferencesPtr& input) {
    return input->enable_scroll_animator;
  }

  static decltype(::blink::mojom::blink::WebPreferences::prefers_reduced_motion) prefers_reduced_motion(
      const ::blink::mojom::blink::WebPreferencesPtr& input) {
    return input->prefers_reduced_motion;
  }

  static decltype(::blink::mojom::blink::WebPreferences::prefers_reduced_transparency) prefers_reduced_transparency(
      const ::blink::mojom::blink::WebPreferencesPtr& input) {
    return input->prefers_reduced_transparency;
  }

  static decltype(::blink::mojom::blink::WebPreferences::inverted_colors) inverted_colors(
      const ::blink::mojom::blink::WebPreferencesPtr& input) {
    return input->inverted_colors;
  }

  static decltype(::blink::mojom::blink::WebPreferences::touch_event_feature_detection_enabled) touch_event_feature_detection_enabled(
      const ::blink::mojom::blink::WebPreferencesPtr& input) {
    return input->touch_event_feature_detection_enabled;
  }

  static decltype(::blink::mojom::blink::WebPreferences::pointer_events_max_touch_points) pointer_events_max_touch_points(
      const ::blink::mojom::blink::WebPreferencesPtr& input) {
    return input->pointer_events_max_touch_points;
  }

  static decltype(::blink::mojom::blink::WebPreferences::available_pointer_types) available_pointer_types(
      const ::blink::mojom::blink::WebPreferencesPtr& input) {
    return input->available_pointer_types;
  }

  static decltype(::blink::mojom::blink::WebPreferences::primary_pointer_type) primary_pointer_type(
      const ::blink::mojom::blink::WebPreferencesPtr& input) {
    return input->primary_pointer_type;
  }

  static decltype(::blink::mojom::blink::WebPreferences::output_device_update_ability_type) output_device_update_ability_type(
      const ::blink::mojom::blink::WebPreferencesPtr& input) {
    return input->output_device_update_ability_type;
  }

  static decltype(::blink::mojom::blink::WebPreferences::available_hover_types) available_hover_types(
      const ::blink::mojom::blink::WebPreferencesPtr& input) {
    return input->available_hover_types;
  }

  static decltype(::blink::mojom::blink::WebPreferences::primary_hover_type) primary_hover_type(
      const ::blink::mojom::blink::WebPreferencesPtr& input) {
    return input->primary_hover_type;
  }

  static decltype(::blink::mojom::blink::WebPreferences::dont_send_key_events_to_javascript) dont_send_key_events_to_javascript(
      const ::blink::mojom::blink::WebPreferencesPtr& input) {
    return input->dont_send_key_events_to_javascript;
  }

  static decltype(::blink::mojom::blink::WebPreferences::barrel_button_for_drag_enabled) barrel_button_for_drag_enabled(
      const ::blink::mojom::blink::WebPreferencesPtr& input) {
    return input->barrel_button_for_drag_enabled;
  }

  static decltype(::blink::mojom::blink::WebPreferences::sync_xhr_in_documents_enabled) sync_xhr_in_documents_enabled(
      const ::blink::mojom::blink::WebPreferencesPtr& input) {
    return input->sync_xhr_in_documents_enabled;
  }

  static decltype(::blink::mojom::blink::WebPreferences::target_blank_implies_no_opener_enabled_will_be_removed) target_blank_implies_no_opener_enabled_will_be_removed(
      const ::blink::mojom::blink::WebPreferencesPtr& input) {
    return input->target_blank_implies_no_opener_enabled_will_be_removed;
  }

  static decltype(::blink::mojom::blink::WebPreferences::ignore_permission_for_device_changed_event) ignore_permission_for_device_changed_event(
      const ::blink::mojom::blink::WebPreferencesPtr& input) {
    return input->ignore_permission_for_device_changed_event;
  }

  static decltype(::blink::mojom::blink::WebPreferences::number_of_cpu_cores) number_of_cpu_cores(
      const ::blink::mojom::blink::WebPreferencesPtr& input) {
    return input->number_of_cpu_cores;
  }

  static decltype(::blink::mojom::blink::WebPreferences::editing_behavior) editing_behavior(
      const ::blink::mojom::blink::WebPreferencesPtr& input) {
    return input->editing_behavior;
  }

  static decltype(::blink::mojom::blink::WebPreferences::supports_multiple_windows) supports_multiple_windows(
      const ::blink::mojom::blink::WebPreferencesPtr& input) {
    return input->supports_multiple_windows;
  }

  static decltype(::blink::mojom::blink::WebPreferences::viewport_enabled) viewport_enabled(
      const ::blink::mojom::blink::WebPreferencesPtr& input) {
    return input->viewport_enabled;
  }

  static decltype(::blink::mojom::blink::WebPreferences::viewport_meta_enabled) viewport_meta_enabled(
      const ::blink::mojom::blink::WebPreferencesPtr& input) {
    return input->viewport_meta_enabled;
  }

  static decltype(::blink::mojom::blink::WebPreferences::auto_zoom_focused_editable_to_legible_scale) auto_zoom_focused_editable_to_legible_scale(
      const ::blink::mojom::blink::WebPreferencesPtr& input) {
    return input->auto_zoom_focused_editable_to_legible_scale;
  }

  static decltype(::blink::mojom::blink::WebPreferences::shrinks_viewport_contents_to_fit) shrinks_viewport_contents_to_fit(
      const ::blink::mojom::blink::WebPreferencesPtr& input) {
    return input->shrinks_viewport_contents_to_fit;
  }

  static decltype(::blink::mojom::blink::WebPreferences::viewport_style) viewport_style(
      const ::blink::mojom::blink::WebPreferencesPtr& input) {
    return input->viewport_style;
  }

  static decltype(::blink::mojom::blink::WebPreferences::smooth_scroll_for_find_enabled) smooth_scroll_for_find_enabled(
      const ::blink::mojom::blink::WebPreferencesPtr& input) {
    return input->smooth_scroll_for_find_enabled;
  }

  static decltype(::blink::mojom::blink::WebPreferences::main_frame_resizes_are_orientation_changes) main_frame_resizes_are_orientation_changes(
      const ::blink::mojom::blink::WebPreferencesPtr& input) {
    return input->main_frame_resizes_are_orientation_changes;
  }

  static decltype(::blink::mojom::blink::WebPreferences::initialize_at_minimum_page_scale) initialize_at_minimum_page_scale(
      const ::blink::mojom::blink::WebPreferencesPtr& input) {
    return input->initialize_at_minimum_page_scale;
  }

  static decltype(::blink::mojom::blink::WebPreferences::smart_insert_delete_enabled) smart_insert_delete_enabled(
      const ::blink::mojom::blink::WebPreferencesPtr& input) {
    return input->smart_insert_delete_enabled;
  }

  static decltype(::blink::mojom::blink::WebPreferences::spatial_navigation_enabled) spatial_navigation_enabled(
      const ::blink::mojom::blink::WebPreferencesPtr& input) {
    return input->spatial_navigation_enabled;
  }

  static decltype(::blink::mojom::blink::WebPreferences::v8_cache_options) v8_cache_options(
      const ::blink::mojom::blink::WebPreferencesPtr& input) {
    return input->v8_cache_options;
  }

  static decltype(::blink::mojom::blink::WebPreferences::record_whole_document) record_whole_document(
      const ::blink::mojom::blink::WebPreferencesPtr& input) {
    return input->record_whole_document;
  }

  static decltype(::blink::mojom::blink::WebPreferences::stylus_handwriting_enabled) stylus_handwriting_enabled(
      const ::blink::mojom::blink::WebPreferencesPtr& input) {
    return input->stylus_handwriting_enabled;
  }

  static decltype(::blink::mojom::blink::WebPreferences::cookie_enabled) cookie_enabled(
      const ::blink::mojom::blink::WebPreferencesPtr& input) {
    return input->cookie_enabled;
  }

  static decltype(::blink::mojom::blink::WebPreferences::accelerated_video_decode_enabled) accelerated_video_decode_enabled(
      const ::blink::mojom::blink::WebPreferencesPtr& input) {
    return input->accelerated_video_decode_enabled;
  }

  static decltype(::blink::mojom::blink::WebPreferences::animation_policy) animation_policy(
      const ::blink::mojom::blink::WebPreferencesPtr& input) {
    return input->animation_policy;
  }

  static decltype(::blink::mojom::blink::WebPreferences::user_gesture_required_for_presentation) user_gesture_required_for_presentation(
      const ::blink::mojom::blink::WebPreferencesPtr& input) {
    return input->user_gesture_required_for_presentation;
  }

  static decltype(::blink::mojom::blink::WebPreferences::text_tracks_enabled) text_tracks_enabled(
      const ::blink::mojom::blink::WebPreferencesPtr& input) {
    return input->text_tracks_enabled;
  }

  static const decltype(::blink::mojom::blink::WebPreferences::text_track_background_color)& text_track_background_color(
      const ::blink::mojom::blink::WebPreferencesPtr& input) {
    return input->text_track_background_color;
  }

  static const decltype(::blink::mojom::blink::WebPreferences::text_track_text_color)& text_track_text_color(
      const ::blink::mojom::blink::WebPreferencesPtr& input) {
    return input->text_track_text_color;
  }

  static const decltype(::blink::mojom::blink::WebPreferences::text_track_text_size)& text_track_text_size(
      const ::blink::mojom::blink::WebPreferencesPtr& input) {
    return input->text_track_text_size;
  }

  static const decltype(::blink::mojom::blink::WebPreferences::text_track_text_shadow)& text_track_text_shadow(
      const ::blink::mojom::blink::WebPreferencesPtr& input) {
    return input->text_track_text_shadow;
  }

  static const decltype(::blink::mojom::blink::WebPreferences::text_track_font_family)& text_track_font_family(
      const ::blink::mojom::blink::WebPreferencesPtr& input) {
    return input->text_track_font_family;
  }

  static const decltype(::blink::mojom::blink::WebPreferences::text_track_font_style)& text_track_font_style(
      const ::blink::mojom::blink::WebPreferencesPtr& input) {
    return input->text_track_font_style;
  }

  static const decltype(::blink::mojom::blink::WebPreferences::text_track_font_variant)& text_track_font_variant(
      const ::blink::mojom::blink::WebPreferencesPtr& input) {
    return input->text_track_font_variant;
  }

  static const decltype(::blink::mojom::blink::WebPreferences::text_track_window_color)& text_track_window_color(
      const ::blink::mojom::blink::WebPreferencesPtr& input) {
    return input->text_track_window_color;
  }

  static const decltype(::blink::mojom::blink::WebPreferences::text_track_window_radius)& text_track_window_radius(
      const ::blink::mojom::blink::WebPreferencesPtr& input) {
    return input->text_track_window_radius;
  }

  static decltype(::blink::mojom::blink::WebPreferences::text_track_margin_percentage) text_track_margin_percentage(
      const ::blink::mojom::blink::WebPreferencesPtr& input) {
    return input->text_track_margin_percentage;
  }

  static decltype(::blink::mojom::blink::WebPreferences::immersive_mode_enabled) immersive_mode_enabled(
      const ::blink::mojom::blink::WebPreferencesPtr& input) {
    return input->immersive_mode_enabled;
  }

  static decltype(::blink::mojom::blink::WebPreferences::double_tap_to_zoom_enabled) double_tap_to_zoom_enabled(
      const ::blink::mojom::blink::WebPreferencesPtr& input) {
    return input->double_tap_to_zoom_enabled;
  }

  static decltype(::blink::mojom::blink::WebPreferences::fullscreen_supported) fullscreen_supported(
      const ::blink::mojom::blink::WebPreferencesPtr& input) {
    return input->fullscreen_supported;
  }

  static decltype(::blink::mojom::blink::WebPreferences::text_autosizing_enabled) text_autosizing_enabled(
      const ::blink::mojom::blink::WebPreferencesPtr& input) {
    return input->text_autosizing_enabled;
  }

  static const decltype(::blink::mojom::blink::WebPreferences::web_app_scope)& web_app_scope(
      const ::blink::mojom::blink::WebPreferencesPtr& input) {
    return input->web_app_scope;
  }

  static decltype(::blink::mojom::blink::WebPreferences::force_dark_mode_enabled) force_dark_mode_enabled(
      const ::blink::mojom::blink::WebPreferencesPtr& input) {
    return input->force_dark_mode_enabled;
  }

  static decltype(::blink::mojom::blink::WebPreferences::default_minimum_page_scale_factor) default_minimum_page_scale_factor(
      const ::blink::mojom::blink::WebPreferencesPtr& input) {
    return input->default_minimum_page_scale_factor;
  }

  static decltype(::blink::mojom::blink::WebPreferences::default_maximum_page_scale_factor) default_maximum_page_scale_factor(
      const ::blink::mojom::blink::WebPreferencesPtr& input) {
    return input->default_maximum_page_scale_factor;
  }

  static decltype(::blink::mojom::blink::WebPreferences::hide_download_ui) hide_download_ui(
      const ::blink::mojom::blink::WebPreferencesPtr& input) {
    return input->hide_download_ui;
  }

  static decltype(::blink::mojom::blink::WebPreferences::presentation_receiver) presentation_receiver(
      const ::blink::mojom::blink::WebPreferencesPtr& input) {
    return input->presentation_receiver;
  }

  static decltype(::blink::mojom::blink::WebPreferences::media_controls_enabled) media_controls_enabled(
      const ::blink::mojom::blink::WebPreferencesPtr& input) {
    return input->media_controls_enabled;
  }

  static decltype(::blink::mojom::blink::WebPreferences::do_not_update_selection_on_mutating_selection_range) do_not_update_selection_on_mutating_selection_range(
      const ::blink::mojom::blink::WebPreferencesPtr& input) {
    return input->do_not_update_selection_on_mutating_selection_range;
  }

  static decltype(::blink::mojom::blink::WebPreferences::autoplay_policy) autoplay_policy(
      const ::blink::mojom::blink::WebPreferencesPtr& input) {
    return input->autoplay_policy;
  }

  static decltype(::blink::mojom::blink::WebPreferences::require_transient_activation_for_get_display_media) require_transient_activation_for_get_display_media(
      const ::blink::mojom::blink::WebPreferencesPtr& input) {
    return input->require_transient_activation_for_get_display_media;
  }

  static decltype(::blink::mojom::blink::WebPreferences::require_transient_activation_for_show_file_or_directory_picker) require_transient_activation_for_show_file_or_directory_picker(
      const ::blink::mojom::blink::WebPreferencesPtr& input) {
    return input->require_transient_activation_for_show_file_or_directory_picker;
  }

  static decltype(::blink::mojom::blink::WebPreferences::require_transient_activation_and_user_confirmation_for_subapps_api) require_transient_activation_and_user_confirmation_for_subapps_api(
      const ::blink::mojom::blink::WebPreferencesPtr& input) {
    return input->require_transient_activation_and_user_confirmation_for_subapps_api;
  }

  static decltype(::blink::mojom::blink::WebPreferences::in_forced_colors) in_forced_colors(
      const ::blink::mojom::blink::WebPreferencesPtr& input) {
    return input->in_forced_colors;
  }

  static decltype(::blink::mojom::blink::WebPreferences::is_forced_colors_disabled) is_forced_colors_disabled(
      const ::blink::mojom::blink::WebPreferencesPtr& input) {
    return input->is_forced_colors_disabled;
  }

  static const decltype(::blink::mojom::blink::WebPreferences::root_scrollbar_theme_color)& root_scrollbar_theme_color(
      const ::blink::mojom::blink::WebPreferencesPtr& input) {
    return input->root_scrollbar_theme_color;
  }

  static decltype(::blink::mojom::blink::WebPreferences::preferred_root_scrollbar_color_scheme) preferred_root_scrollbar_color_scheme(
      const ::blink::mojom::blink::WebPreferencesPtr& input) {
    return input->preferred_root_scrollbar_color_scheme;
  }

  static decltype(::blink::mojom::blink::WebPreferences::preferred_color_scheme) preferred_color_scheme(
      const ::blink::mojom::blink::WebPreferencesPtr& input) {
    return input->preferred_color_scheme;
  }

  static decltype(::blink::mojom::blink::WebPreferences::preferred_contrast) preferred_contrast(
      const ::blink::mojom::blink::WebPreferencesPtr& input) {
    return input->preferred_contrast;
  }

  static decltype(::blink::mojom::blink::WebPreferences::low_priority_iframes_threshold) low_priority_iframes_threshold(
      const ::blink::mojom::blink::WebPreferencesPtr& input) {
    return input->low_priority_iframes_threshold;
  }

  static decltype(::blink::mojom::blink::WebPreferences::picture_in_picture_enabled) picture_in_picture_enabled(
      const ::blink::mojom::blink::WebPreferencesPtr& input) {
    return input->picture_in_picture_enabled;
  }

  static decltype(::blink::mojom::blink::WebPreferences::translate_service_available) translate_service_available(
      const ::blink::mojom::blink::WebPreferencesPtr& input) {
    return input->translate_service_available;
  }

  static decltype(::blink::mojom::blink::WebPreferences::network_quality_estimator_web_holdback) network_quality_estimator_web_holdback(
      const ::blink::mojom::blink::WebPreferencesPtr& input) {
    return input->network_quality_estimator_web_holdback;
  }

  static decltype(::blink::mojom::blink::WebPreferences::lazy_load_enabled) lazy_load_enabled(
      const ::blink::mojom::blink::WebPreferencesPtr& input) {
    return input->lazy_load_enabled;
  }

  static decltype(::blink::mojom::blink::WebPreferences::allow_mixed_content_upgrades) allow_mixed_content_upgrades(
      const ::blink::mojom::blink::WebPreferencesPtr& input) {
    return input->allow_mixed_content_upgrades;
  }

  static decltype(::blink::mojom::blink::WebPreferences::always_show_focus) always_show_focus(
      const ::blink::mojom::blink::WebPreferencesPtr& input) {
    return input->always_show_focus;
  }

  static decltype(::blink::mojom::blink::WebPreferences::touch_drag_drop_enabled) touch_drag_drop_enabled(
      const ::blink::mojom::blink::WebPreferencesPtr& input) {
    return input->touch_drag_drop_enabled;
  }

  static decltype(::blink::mojom::blink::WebPreferences::touch_dragend_context_menu) touch_dragend_context_menu(
      const ::blink::mojom::blink::WebPreferencesPtr& input) {
    return input->touch_dragend_context_menu;
  }

  static decltype(::blink::mojom::blink::WebPreferences::webxr_immersive_ar_allowed) webxr_immersive_ar_allowed(
      const ::blink::mojom::blink::WebPreferencesPtr& input) {
    return input->webxr_immersive_ar_allowed;
  }

  static decltype(::blink::mojom::blink::WebPreferences::renderer_wide_named_frame_lookup) renderer_wide_named_frame_lookup(
      const ::blink::mojom::blink::WebPreferencesPtr& input) {
    return input->renderer_wide_named_frame_lookup;
  }

  static decltype(::blink::mojom::blink::WebPreferences::strict_mime_type_check_for_worker_scripts_enabled) strict_mime_type_check_for_worker_scripts_enabled(
      const ::blink::mojom::blink::WebPreferencesPtr& input) {
    return input->strict_mime_type_check_for_worker_scripts_enabled;
  }

  static decltype(::blink::mojom::blink::WebPreferences::modal_context_menu) modal_context_menu(
      const ::blink::mojom::blink::WebPreferencesPtr& input) {
    return input->modal_context_menu;
  }

  static decltype(::blink::mojom::blink::WebPreferences::payment_request_enabled) payment_request_enabled(
      const ::blink::mojom::blink::WebPreferencesPtr& input) {
    return input->payment_request_enabled;
  }

  static decltype(::blink::mojom::blink::WebPreferences::ai_prompt_api_enabled) ai_prompt_api_enabled(
      const ::blink::mojom::blink::WebPreferencesPtr& input) {
    return input->ai_prompt_api_enabled;
  }

  static decltype(::blink::mojom::blink::WebPreferences::should_disable_external_popups) should_disable_external_popups(
      const ::blink::mojom::blink::WebPreferencesPtr& input) {
    return input->should_disable_external_popups;
  }

  static bool Read(::blink::mojom::blink::WebPreferences::DataView input, ::blink::mojom::blink::WebPreferencesPtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_WEBPREFERENCES_WEB_PREFERENCES_MOJOM_BLINK_H_