// third_party/blink/public/mojom/webid/federated_auth_request.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_WEBID_FEDERATED_AUTH_REQUEST_MOJOM_SHARED_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_WEBID_FEDERATED_AUTH_REQUEST_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/webid/federated_auth_request.mojom-shared-internal.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "mojo/public/mojom/base/values.mojom-shared.h"
#include "third_party/blink/public/mojom/credentialmanagement/credential_manager.mojom-shared.h"
#include "url/mojom/origin.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "third_party/blink/public/mojom/webid/federated_auth_request.mojom-data-view.h"
#include "base/component_export.h"




namespace std {

template <>
struct hash<::blink::mojom::RequestTokenStatus>
    : public mojo::internal::EnumHashImpl<::blink::mojom::RequestTokenStatus> {};

template <>
struct hash<::blink::mojom::RequestUserInfoStatus>
    : public mojo::internal::EnumHashImpl<::blink::mojom::RequestUserInfoStatus> {};

template <>
struct hash<::blink::mojom::DisconnectStatus>
    : public mojo::internal::EnumHashImpl<::blink::mojom::DisconnectStatus> {};

template <>
struct hash<::blink::mojom::IdpSigninStatus>
    : public mojo::internal::EnumHashImpl<::blink::mojom::IdpSigninStatus> {};

template <>
struct hash<::blink::mojom::RpContext>
    : public mojo::internal::EnumHashImpl<::blink::mojom::RpContext> {};

template <>
struct hash<::blink::mojom::RpMode>
    : public mojo::internal::EnumHashImpl<::blink::mojom::RpMode> {};

template <>
struct hash<::blink::mojom::RegisterIdpStatus>
    : public mojo::internal::EnumHashImpl<::blink::mojom::RegisterIdpStatus> {};

template <>
struct hash<::blink::mojom::Format>
    : public mojo::internal::EnumHashImpl<::blink::mojom::Format> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::RequestTokenStatus, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::RequestTokenStatus, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::RequestTokenStatus>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::RequestUserInfoStatus, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::RequestUserInfoStatus, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::RequestUserInfoStatus>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::DisconnectStatus, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::DisconnectStatus, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::DisconnectStatus>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::IdpSigninStatus, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::IdpSigninStatus, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::IdpSigninStatus>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::RpContext, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::RpContext, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::RpContext>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::RpMode, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::RpMode, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::RpMode>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::RegisterIdpStatus, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::RegisterIdpStatus, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::RegisterIdpStatus>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::Format, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::Format, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::Format>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::IdentityProviderConfigDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::IdentityProviderConfigDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::IdentityProviderConfig_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::config_url(input)) in_config_url = Traits::config_url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->config_url)::BaseType> config_url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_config_url,
      config_url_fragment);

    fragment->config_url.Set(
        config_url_fragment.is_null() ? nullptr : config_url_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->config_url.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null config_url in IdentityProviderConfig struct");

    fragment->from_idp_registration_api = Traits::from_idp_registration_api(input);

    decltype(Traits::type(input)) in_type = Traits::type(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->type)::BaseType> type_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_type,
      type_fragment);

    fragment->type.Set(
        type_fragment.is_null() ? nullptr : type_fragment.data());

    decltype(Traits::client_id(input)) in_client_id = Traits::client_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->client_id)::BaseType> client_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_client_id,
      client_id_fragment);

    fragment->client_id.Set(
        client_id_fragment.is_null() ? nullptr : client_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->client_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null client_id in IdentityProviderConfig struct");
  }

  static bool Deserialize(::blink::mojom::internal::IdentityProviderConfig_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::IdentityProviderConfigDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::IdentityProviderRequestOptionsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::IdentityProviderRequestOptionsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::IdentityProviderRequestOptions_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::config(input)) in_config = Traits::config(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->config)::BaseType> config_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::IdentityProviderConfigDataView>(
      in_config,
      config_fragment);

    fragment->config.Set(
        config_fragment.is_null() ? nullptr : config_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->config.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null config in IdentityProviderRequestOptions struct");

    decltype(Traits::nonce(input)) in_nonce = Traits::nonce(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->nonce)::BaseType> nonce_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_nonce,
      nonce_fragment);

    fragment->nonce.Set(
        nonce_fragment.is_null() ? nullptr : nonce_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->nonce.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null nonce in IdentityProviderRequestOptions struct");

    decltype(Traits::login_hint(input)) in_login_hint = Traits::login_hint(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->login_hint)::BaseType> login_hint_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_login_hint,
      login_hint_fragment);

    fragment->login_hint.Set(
        login_hint_fragment.is_null() ? nullptr : login_hint_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->login_hint.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null login_hint in IdentityProviderRequestOptions struct");

    decltype(Traits::domain_hint(input)) in_domain_hint = Traits::domain_hint(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->domain_hint)::BaseType> domain_hint_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_domain_hint,
      domain_hint_fragment);

    fragment->domain_hint.Set(
        domain_hint_fragment.is_null() ? nullptr : domain_hint_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->domain_hint.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null domain_hint in IdentityProviderRequestOptions struct");

    decltype(Traits::fields(input)) in_fields = Traits::fields(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->fields)::BaseType>
        fields_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& fields_validate_params =
        mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
      in_fields,
      fields_fragment,
      &fields_validate_params);

    fragment->fields.Set(
        fields_fragment.is_null() ? nullptr : fields_fragment.data());

    decltype(Traits::params_json(input)) in_params_json = Traits::params_json(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->params_json)::BaseType> params_json_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_params_json,
      params_json_fragment);

    fragment->params_json.Set(
        params_json_fragment.is_null() ? nullptr : params_json_fragment.data());
    fragment->format_$flag = Traits::format(input).has_value();
    if (Traits::format(input).has_value()) {
      
      mojo::internal::Serialize<::blink::mojom::Format>(
        Traits::format(input).value(),
        &fragment->format_$value);
    } else {
      fragment->format_$value =
          static_cast<int32_t>(::blink::mojom::Format::kMinValue);
    }
  }

  static bool Deserialize(::blink::mojom::internal::IdentityProviderRequestOptions_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::IdentityProviderRequestOptionsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::IdentityCredentialDisconnectOptionsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::IdentityCredentialDisconnectOptionsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::IdentityCredentialDisconnectOptions_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::config(input)) in_config = Traits::config(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->config)::BaseType> config_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::IdentityProviderConfigDataView>(
      in_config,
      config_fragment);

    fragment->config.Set(
        config_fragment.is_null() ? nullptr : config_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->config.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null config in IdentityCredentialDisconnectOptions struct");

    decltype(Traits::account_hint(input)) in_account_hint = Traits::account_hint(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->account_hint)::BaseType> account_hint_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_account_hint,
      account_hint_fragment);

    fragment->account_hint.Set(
        account_hint_fragment.is_null() ? nullptr : account_hint_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->account_hint.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null account_hint in IdentityCredentialDisconnectOptions struct");
  }

  static bool Deserialize(::blink::mojom::internal::IdentityCredentialDisconnectOptions_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::IdentityCredentialDisconnectOptionsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::IdentityUserInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::IdentityUserInfoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::IdentityUserInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::email(input)) in_email = Traits::email(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->email)::BaseType> email_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_email,
      email_fragment);

    fragment->email.Set(
        email_fragment.is_null() ? nullptr : email_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->email.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null email in IdentityUserInfo struct");

    decltype(Traits::given_name(input)) in_given_name = Traits::given_name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->given_name)::BaseType> given_name_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_given_name,
      given_name_fragment);

    fragment->given_name.Set(
        given_name_fragment.is_null() ? nullptr : given_name_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->given_name.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null given_name in IdentityUserInfo struct");

    decltype(Traits::name(input)) in_name = Traits::name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->name)::BaseType> name_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_name,
      name_fragment);

    fragment->name.Set(
        name_fragment.is_null() ? nullptr : name_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->name.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null name in IdentityUserInfo struct");

    decltype(Traits::picture(input)) in_picture = Traits::picture(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->picture)::BaseType> picture_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_picture,
      picture_fragment);

    fragment->picture.Set(
        picture_fragment.is_null() ? nullptr : picture_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->picture.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null picture in IdentityUserInfo struct");
  }

  static bool Deserialize(::blink::mojom::internal::IdentityUserInfo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::IdentityUserInfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::LoginStatusAccountDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::LoginStatusAccountDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::LoginStatusAccount_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::id(input)) in_id = Traits::id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->id)::BaseType> id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_id,
      id_fragment);

    fragment->id.Set(
        id_fragment.is_null() ? nullptr : id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null id in LoginStatusAccount struct");

    decltype(Traits::email(input)) in_email = Traits::email(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->email)::BaseType> email_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_email,
      email_fragment);

    fragment->email.Set(
        email_fragment.is_null() ? nullptr : email_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->email.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null email in LoginStatusAccount struct");

    decltype(Traits::name(input)) in_name = Traits::name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->name)::BaseType> name_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_name,
      name_fragment);

    fragment->name.Set(
        name_fragment.is_null() ? nullptr : name_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->name.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null name in LoginStatusAccount struct");

    decltype(Traits::given_name(input)) in_given_name = Traits::given_name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->given_name)::BaseType> given_name_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_given_name,
      given_name_fragment);

    fragment->given_name.Set(
        given_name_fragment.is_null() ? nullptr : given_name_fragment.data());

    decltype(Traits::picture(input)) in_picture = Traits::picture(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->picture)::BaseType> picture_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_picture,
      picture_fragment);

    fragment->picture.Set(
        picture_fragment.is_null() ? nullptr : picture_fragment.data());
  }

  static bool Deserialize(::blink::mojom::internal::LoginStatusAccount_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::LoginStatusAccountDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::LoginStatusOptionsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::LoginStatusOptionsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::LoginStatusOptions_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::accounts(input)) in_accounts = Traits::accounts(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->accounts)::BaseType>
        accounts_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& accounts_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::LoginStatusAccountDataView>>(
      in_accounts,
      accounts_fragment,
      &accounts_validate_params);

    fragment->accounts.Set(
        accounts_fragment.is_null() ? nullptr : accounts_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->accounts.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null accounts in LoginStatusOptions struct");

    decltype(Traits::expiration(input)) in_expiration = Traits::expiration(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->expiration)::BaseType> expiration_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
      in_expiration,
      expiration_fragment);

    fragment->expiration.Set(
        expiration_fragment.is_null() ? nullptr : expiration_fragment.data());
  }

  static bool Deserialize(::blink::mojom::internal::LoginStatusOptions_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::LoginStatusOptionsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::IdentityProviderGetParametersDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::IdentityProviderGetParametersDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::IdentityProviderGetParameters_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::providers(input)) in_providers = Traits::providers(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->providers)::BaseType>
        providers_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& providers_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::IdentityProviderRequestOptionsDataView>>(
      in_providers,
      providers_fragment,
      &providers_validate_params);

    fragment->providers.Set(
        providers_fragment.is_null() ? nullptr : providers_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->providers.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null providers in IdentityProviderGetParameters struct");

    
    mojo::internal::Serialize<::blink::mojom::RpContext>(
      Traits::context(input),
      &fragment->context);

    
    mojo::internal::Serialize<::blink::mojom::RpMode>(
      Traits::mode(input),
      &fragment->mode);
  }

  static bool Deserialize(::blink::mojom::internal::IdentityProviderGetParameters_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::IdentityProviderGetParametersDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::TokenErrorDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::TokenErrorDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::TokenError_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::code(input)) in_code = Traits::code(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->code)::BaseType> code_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_code,
      code_fragment);

    fragment->code.Set(
        code_fragment.is_null() ? nullptr : code_fragment.data());

    decltype(Traits::url(input)) in_url = Traits::url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->url)::BaseType> url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_url,
      url_fragment);

    fragment->url.Set(
        url_fragment.is_null() ? nullptr : url_fragment.data());
  }

  static bool Deserialize(::blink::mojom::internal::TokenError_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::TokenErrorDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace blink::mojom {

inline void IdentityProviderConfigDataView::GetConfigUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->config_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void IdentityProviderConfigDataView::GetTypeDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->type.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void IdentityProviderConfigDataView::GetClientIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->client_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void IdentityProviderRequestOptionsDataView::GetConfigDataView(
    IdentityProviderConfigDataView* output) {
  auto pointer = data_->config.Get();
  *output = IdentityProviderConfigDataView(pointer, message_);
}
inline void IdentityProviderRequestOptionsDataView::GetNonceDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->nonce.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void IdentityProviderRequestOptionsDataView::GetLoginHintDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->login_hint.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void IdentityProviderRequestOptionsDataView::GetDomainHintDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->domain_hint.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void IdentityProviderRequestOptionsDataView::GetFieldsDataView(
    mojo::ArrayDataView<mojo::StringDataView>* output) {
  auto pointer = data_->fields.Get();
  *output = mojo::ArrayDataView<mojo::StringDataView>(pointer, message_);
}
inline void IdentityProviderRequestOptionsDataView::GetParamsJsonDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->params_json.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void IdentityCredentialDisconnectOptionsDataView::GetConfigDataView(
    IdentityProviderConfigDataView* output) {
  auto pointer = data_->config.Get();
  *output = IdentityProviderConfigDataView(pointer, message_);
}
inline void IdentityCredentialDisconnectOptionsDataView::GetAccountHintDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->account_hint.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void IdentityUserInfoDataView::GetEmailDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->email.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void IdentityUserInfoDataView::GetGivenNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->given_name.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void IdentityUserInfoDataView::GetNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->name.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void IdentityUserInfoDataView::GetPictureDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->picture.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void LoginStatusAccountDataView::GetIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->id.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void LoginStatusAccountDataView::GetEmailDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->email.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void LoginStatusAccountDataView::GetNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->name.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void LoginStatusAccountDataView::GetGivenNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->given_name.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void LoginStatusAccountDataView::GetPictureDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->picture.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}


inline void LoginStatusOptionsDataView::GetAccountsDataView(
    mojo::ArrayDataView<LoginStatusAccountDataView>* output) {
  auto pointer = data_->accounts.Get();
  *output = mojo::ArrayDataView<LoginStatusAccountDataView>(pointer, message_);
}
inline void LoginStatusOptionsDataView::GetExpirationDataView(
    ::mojo_base::mojom::TimeDeltaDataView* output) {
  auto pointer = data_->expiration.Get();
  *output = ::mojo_base::mojom::TimeDeltaDataView(pointer, message_);
}


inline void IdentityProviderGetParametersDataView::GetProvidersDataView(
    mojo::ArrayDataView<IdentityProviderRequestOptionsDataView>* output) {
  auto pointer = data_->providers.Get();
  *output = mojo::ArrayDataView<IdentityProviderRequestOptionsDataView>(pointer, message_);
}


inline void TokenErrorDataView::GetCodeDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->code.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void TokenErrorDataView::GetUrlDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->url.Get();
  *output = mojo::StringDataView(pointer, message_);
}



}  // blink::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::RequestTokenStatus> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::RequestTokenStatus value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::RequestUserInfoStatus> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::RequestUserInfoStatus value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::DisconnectStatus> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::DisconnectStatus value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::IdpSigninStatus> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::IdpSigninStatus value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::RpContext> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::RpContext value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::RpMode> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::RpMode value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::RegisterIdpStatus> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::RegisterIdpStatus value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::Format> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::Format value);
};

} // namespace perfetto

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_WEBID_FEDERATED_AUTH_REQUEST_MOJOM_SHARED_H_