// third_party/blink/public/mojom/webid/federated_auth_request.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/public/mojom/webid/federated_auth_request.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/webid/federated_auth_request.mojom-params-data.h"
namespace blink {
namespace mojom {

NOINLINE static const char* RequestTokenStatusToStringHelper(RequestTokenStatus value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case RequestTokenStatus::kSuccess:
      return "kSuccess";
    case RequestTokenStatus::kErrorTooManyRequests:
      return "kErrorTooManyRequests";
    case RequestTokenStatus::kErrorCanceled:
      return "kErrorCanceled";
    case RequestTokenStatus::kError:
      return "kError";
    default:
      return nullptr;
  }
}

std::string RequestTokenStatusToString(RequestTokenStatus value) {
  const char *str = RequestTokenStatusToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown RequestTokenStatus value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, RequestTokenStatus value) {
  return os << RequestTokenStatusToString(value);
}

NOINLINE static const char* RequestUserInfoStatusToStringHelper(RequestUserInfoStatus value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case RequestUserInfoStatus::kSuccess:
      return "kSuccess";
    case RequestUserInfoStatus::kError:
      return "kError";
    default:
      return nullptr;
  }
}

std::string RequestUserInfoStatusToString(RequestUserInfoStatus value) {
  const char *str = RequestUserInfoStatusToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown RequestUserInfoStatus value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, RequestUserInfoStatus value) {
  return os << RequestUserInfoStatusToString(value);
}

NOINLINE static const char* DisconnectStatusToStringHelper(DisconnectStatus value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case DisconnectStatus::kSuccess:
      return "kSuccess";
    case DisconnectStatus::kErrorTooManyRequests:
      return "kErrorTooManyRequests";
    case DisconnectStatus::kError:
      return "kError";
    default:
      return nullptr;
  }
}

std::string DisconnectStatusToString(DisconnectStatus value) {
  const char *str = DisconnectStatusToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown DisconnectStatus value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, DisconnectStatus value) {
  return os << DisconnectStatusToString(value);
}

NOINLINE static const char* IdpSigninStatusToStringHelper(IdpSigninStatus value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case IdpSigninStatus::kSignedIn:
      return "kSignedIn";
    case IdpSigninStatus::kSignedOut:
      return "kSignedOut";
    default:
      return nullptr;
  }
}

std::string IdpSigninStatusToString(IdpSigninStatus value) {
  const char *str = IdpSigninStatusToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown IdpSigninStatus value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, IdpSigninStatus value) {
  return os << IdpSigninStatusToString(value);
}

NOINLINE static const char* RpContextToStringHelper(RpContext value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case RpContext::kSignIn:
      return "kSignIn";
    case RpContext::kSignUp:
      return "kSignUp";
    case RpContext::kUse:
      return "kUse";
    case RpContext::kContinue:
      return "kContinue";
    default:
      return nullptr;
  }
}

std::string RpContextToString(RpContext value) {
  const char *str = RpContextToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown RpContext value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, RpContext value) {
  return os << RpContextToString(value);
}

NOINLINE static const char* RpModeToStringHelper(RpMode value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case RpMode::kActive:
      return "kActive";
    case RpMode::kPassive:
      return "kPassive";
    default:
      return nullptr;
  }
}

std::string RpModeToString(RpMode value) {
  const char *str = RpModeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown RpMode value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, RpMode value) {
  return os << RpModeToString(value);
}

NOINLINE static const char* RegisterIdpStatusToStringHelper(RegisterIdpStatus value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case RegisterIdpStatus::kSuccess:
      return "kSuccess";
    case RegisterIdpStatus::kErrorFeatureDisabled:
      return "kErrorFeatureDisabled";
    case RegisterIdpStatus::kErrorCrossOriginConfig:
      return "kErrorCrossOriginConfig";
    case RegisterIdpStatus::kErrorNoTransientActivation:
      return "kErrorNoTransientActivation";
    case RegisterIdpStatus::kErrorDeclined:
      return "kErrorDeclined";
    case RegisterIdpStatus::kErrorInvalidConfig:
      return "kErrorInvalidConfig";
    default:
      return nullptr;
  }
}

std::string RegisterIdpStatusToString(RegisterIdpStatus value) {
  const char *str = RegisterIdpStatusToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown RegisterIdpStatus value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, RegisterIdpStatus value) {
  return os << RegisterIdpStatusToString(value);
}

NOINLINE static const char* FormatToStringHelper(Format value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case Format::kSdJwt:
      return "kSdJwt";
    default:
      return nullptr;
  }
}

std::string FormatToString(Format value) {
  const char *str = FormatToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown Format value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, Format value) {
  return os << FormatToString(value);
}

namespace internal {


// static
bool IdentityProviderConfig_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const IdentityProviderConfig_Data* object =
      static_cast<const IdentityProviderConfig_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->config_url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->config_url, validation_context))
    return false;

  constexpr const mojo::internal::ContainerValidateParams& type_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->type, validation_context,
                                         &type_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->client_id, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& client_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->client_id, validation_context,
                                         &client_id_validate_params)) {
    return false;
  }

  return true;
}

IdentityProviderConfig_Data::IdentityProviderConfig_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IdentityProviderRequestOptions_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 64, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const IdentityProviderRequestOptions_Data* object =
      static_cast<const IdentityProviderRequestOptions_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->config, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->config, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->nonce, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& nonce_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->nonce, validation_context,
                                         &nonce_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->login_hint, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& login_hint_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->login_hint, validation_context,
                                         &login_hint_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->domain_hint, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& domain_hint_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->domain_hint, validation_context,
                                         &domain_hint_validate_params)) {
    return false;
  }

  constexpr const mojo::internal::ContainerValidateParams& fields_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->fields, validation_context,
                                         &fields_validate_params)) {
    return false;
  }

  constexpr const mojo::internal::ContainerValidateParams& params_json_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->params_json, validation_context,
                                         &params_json_validate_params)) {
    return false;
  }


  if (!::blink::mojom::internal::Format_Data
        ::Validate(object->format_$value, validation_context))
    return false;

  return true;
}

IdentityProviderRequestOptions_Data::IdentityProviderRequestOptions_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IdentityCredentialDisconnectOptions_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const IdentityCredentialDisconnectOptions_Data* object =
      static_cast<const IdentityCredentialDisconnectOptions_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->config, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->config, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->account_hint, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& account_hint_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->account_hint, validation_context,
                                         &account_hint_validate_params)) {
    return false;
  }

  return true;
}

IdentityCredentialDisconnectOptions_Data::IdentityCredentialDisconnectOptions_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IdentityUserInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const IdentityUserInfo_Data* object =
      static_cast<const IdentityUserInfo_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->email, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& email_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->email, validation_context,
                                         &email_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->given_name, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& given_name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->given_name, validation_context,
                                         &given_name_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->name, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->name, validation_context,
                                         &name_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->picture, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& picture_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->picture, validation_context,
                                         &picture_validate_params)) {
    return false;
  }

  return true;
}

IdentityUserInfo_Data::IdentityUserInfo_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LoginStatusAccount_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LoginStatusAccount_Data* object =
      static_cast<const LoginStatusAccount_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->id, validation_context,
                                         &id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->email, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& email_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->email, validation_context,
                                         &email_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->name, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->name, validation_context,
                                         &name_validate_params)) {
    return false;
  }

  constexpr const mojo::internal::ContainerValidateParams& given_name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->given_name, validation_context,
                                         &given_name_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->picture, validation_context))
    return false;

  return true;
}

LoginStatusAccount_Data::LoginStatusAccount_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LoginStatusOptions_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LoginStatusOptions_Data* object =
      static_cast<const LoginStatusOptions_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->accounts, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& accounts_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->accounts, validation_context,
                                         &accounts_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->expiration, validation_context))
    return false;

  return true;
}

LoginStatusOptions_Data::LoginStatusOptions_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IdentityProviderGetParameters_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const IdentityProviderGetParameters_Data* object =
      static_cast<const IdentityProviderGetParameters_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->providers, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& providers_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->providers, validation_context,
                                         &providers_validate_params)) {
    return false;
  }


  if (!::blink::mojom::internal::RpContext_Data
        ::Validate(object->context, validation_context))
    return false;


  if (!::blink::mojom::internal::RpMode_Data
        ::Validate(object->mode, validation_context))
    return false;

  return true;
}

IdentityProviderGetParameters_Data::IdentityProviderGetParameters_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool TokenError_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const TokenError_Data* object =
      static_cast<const TokenError_Data*>(data);

  constexpr const mojo::internal::ContainerValidateParams& code_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->code, validation_context,
                                         &code_validate_params)) {
    return false;
  }

  constexpr const mojo::internal::ContainerValidateParams& url_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->url, validation_context,
                                         &url_validate_params)) {
    return false;
  }

  return true;
}

TokenError_Data::TokenError_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FederatedAuthRequest_RequestToken_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FederatedAuthRequest_RequestToken_Params_Data* object =
      static_cast<const FederatedAuthRequest_RequestToken_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->idp_get_params, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& idp_get_params_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->idp_get_params, validation_context,
                                         &idp_get_params_validate_params)) {
    return false;
  }


  if (!::blink::mojom::internal::CredentialMediationRequirement_Data
        ::Validate(object->requirement, validation_context))
    return false;

  return true;
}

FederatedAuthRequest_RequestToken_Params_Data::FederatedAuthRequest_RequestToken_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FederatedAuthRequest_RequestToken_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FederatedAuthRequest_RequestToken_ResponseParams_Data* object =
      static_cast<const FederatedAuthRequest_RequestToken_ResponseParams_Data*>(data);


  if (!::blink::mojom::internal::RequestTokenStatus_Data
        ::Validate(object->status, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->selected_identity_provider_config_url, validation_context))
    return false;

  if (!mojo::internal::ValidateInlinedUnion(object->token, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->error, validation_context))
    return false;

  return true;
}

FederatedAuthRequest_RequestToken_ResponseParams_Data::FederatedAuthRequest_RequestToken_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FederatedAuthRequest_RequestUserInfo_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FederatedAuthRequest_RequestUserInfo_Params_Data* object =
      static_cast<const FederatedAuthRequest_RequestUserInfo_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->provider, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->provider, validation_context))
    return false;

  return true;
}

FederatedAuthRequest_RequestUserInfo_Params_Data::FederatedAuthRequest_RequestUserInfo_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FederatedAuthRequest_RequestUserInfo_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FederatedAuthRequest_RequestUserInfo_ResponseParams_Data* object =
      static_cast<const FederatedAuthRequest_RequestUserInfo_ResponseParams_Data*>(data);


  if (!::blink::mojom::internal::RequestUserInfoStatus_Data
        ::Validate(object->status, validation_context))
    return false;

  constexpr const mojo::internal::ContainerValidateParams& user_info_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->user_info, validation_context,
                                         &user_info_validate_params)) {
    return false;
  }

  return true;
}

FederatedAuthRequest_RequestUserInfo_ResponseParams_Data::FederatedAuthRequest_RequestUserInfo_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FederatedAuthRequest_CancelTokenRequest_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FederatedAuthRequest_CancelTokenRequest_Params_Data* object =
      static_cast<const FederatedAuthRequest_CancelTokenRequest_Params_Data*>(data);

  return true;
}

FederatedAuthRequest_CancelTokenRequest_Params_Data::FederatedAuthRequest_CancelTokenRequest_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FederatedAuthRequest_ResolveTokenRequest_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FederatedAuthRequest_ResolveTokenRequest_Params_Data* object =
      static_cast<const FederatedAuthRequest_ResolveTokenRequest_Params_Data*>(data);

  constexpr const mojo::internal::ContainerValidateParams& account_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->account_id, validation_context,
                                         &account_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->token, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->token, validation_context))
    return false;

  return true;
}

FederatedAuthRequest_ResolveTokenRequest_Params_Data::FederatedAuthRequest_ResolveTokenRequest_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FederatedAuthRequest_ResolveTokenRequest_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FederatedAuthRequest_ResolveTokenRequest_ResponseParams_Data* object =
      static_cast<const FederatedAuthRequest_ResolveTokenRequest_ResponseParams_Data*>(data);

  return true;
}

FederatedAuthRequest_ResolveTokenRequest_ResponseParams_Data::FederatedAuthRequest_ResolveTokenRequest_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FederatedAuthRequest_SetIdpSigninStatus_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FederatedAuthRequest_SetIdpSigninStatus_Params_Data* object =
      static_cast<const FederatedAuthRequest_SetIdpSigninStatus_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->origin, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->origin, validation_context))
    return false;


  if (!::blink::mojom::internal::IdpSigninStatus_Data
        ::Validate(object->status, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->options, validation_context))
    return false;

  return true;
}

FederatedAuthRequest_SetIdpSigninStatus_Params_Data::FederatedAuthRequest_SetIdpSigninStatus_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FederatedAuthRequest_SetIdpSigninStatus_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FederatedAuthRequest_SetIdpSigninStatus_ResponseParams_Data* object =
      static_cast<const FederatedAuthRequest_SetIdpSigninStatus_ResponseParams_Data*>(data);

  return true;
}

FederatedAuthRequest_SetIdpSigninStatus_ResponseParams_Data::FederatedAuthRequest_SetIdpSigninStatus_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FederatedAuthRequest_RegisterIdP_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FederatedAuthRequest_RegisterIdP_Params_Data* object =
      static_cast<const FederatedAuthRequest_RegisterIdP_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  return true;
}

FederatedAuthRequest_RegisterIdP_Params_Data::FederatedAuthRequest_RegisterIdP_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FederatedAuthRequest_RegisterIdP_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FederatedAuthRequest_RegisterIdP_ResponseParams_Data* object =
      static_cast<const FederatedAuthRequest_RegisterIdP_ResponseParams_Data*>(data);


  if (!::blink::mojom::internal::RegisterIdpStatus_Data
        ::Validate(object->status, validation_context))
    return false;

  return true;
}

FederatedAuthRequest_RegisterIdP_ResponseParams_Data::FederatedAuthRequest_RegisterIdP_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FederatedAuthRequest_UnregisterIdP_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FederatedAuthRequest_UnregisterIdP_Params_Data* object =
      static_cast<const FederatedAuthRequest_UnregisterIdP_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  return true;
}

FederatedAuthRequest_UnregisterIdP_Params_Data::FederatedAuthRequest_UnregisterIdP_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FederatedAuthRequest_UnregisterIdP_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FederatedAuthRequest_UnregisterIdP_ResponseParams_Data* object =
      static_cast<const FederatedAuthRequest_UnregisterIdP_ResponseParams_Data*>(data);

  return true;
}

FederatedAuthRequest_UnregisterIdP_ResponseParams_Data::FederatedAuthRequest_UnregisterIdP_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FederatedAuthRequest_CloseModalDialogView_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FederatedAuthRequest_CloseModalDialogView_Params_Data* object =
      static_cast<const FederatedAuthRequest_CloseModalDialogView_Params_Data*>(data);

  return true;
}

FederatedAuthRequest_CloseModalDialogView_Params_Data::FederatedAuthRequest_CloseModalDialogView_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FederatedAuthRequest_PreventSilentAccess_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FederatedAuthRequest_PreventSilentAccess_Params_Data* object =
      static_cast<const FederatedAuthRequest_PreventSilentAccess_Params_Data*>(data);

  return true;
}

FederatedAuthRequest_PreventSilentAccess_Params_Data::FederatedAuthRequest_PreventSilentAccess_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FederatedAuthRequest_PreventSilentAccess_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FederatedAuthRequest_PreventSilentAccess_ResponseParams_Data* object =
      static_cast<const FederatedAuthRequest_PreventSilentAccess_ResponseParams_Data*>(data);

  return true;
}

FederatedAuthRequest_PreventSilentAccess_ResponseParams_Data::FederatedAuthRequest_PreventSilentAccess_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FederatedAuthRequest_Disconnect_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FederatedAuthRequest_Disconnect_Params_Data* object =
      static_cast<const FederatedAuthRequest_Disconnect_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->options, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->options, validation_context))
    return false;

  return true;
}

FederatedAuthRequest_Disconnect_Params_Data::FederatedAuthRequest_Disconnect_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FederatedAuthRequest_Disconnect_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FederatedAuthRequest_Disconnect_ResponseParams_Data* object =
      static_cast<const FederatedAuthRequest_Disconnect_ResponseParams_Data*>(data);


  if (!::blink::mojom::internal::DisconnectStatus_Data
        ::Validate(object->status, validation_context))
    return false;

  return true;
}

FederatedAuthRequest_Disconnect_ResponseParams_Data::FederatedAuthRequest_Disconnect_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace blink

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::RequestTokenStatus>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::RequestTokenStatus value) {
  return std::move(context).WriteString(::blink::mojom::RequestTokenStatusToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::RequestUserInfoStatus>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::RequestUserInfoStatus value) {
  return std::move(context).WriteString(::blink::mojom::RequestUserInfoStatusToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::DisconnectStatus>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::DisconnectStatus value) {
  return std::move(context).WriteString(::blink::mojom::DisconnectStatusToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::IdpSigninStatus>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::IdpSigninStatus value) {
  return std::move(context).WriteString(::blink::mojom::IdpSigninStatusToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::RpContext>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::RpContext value) {
  return std::move(context).WriteString(::blink::mojom::RpContextToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::RpMode>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::RpMode value) {
  return std::move(context).WriteString(::blink::mojom::RpModeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::RegisterIdpStatus>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::RegisterIdpStatus value) {
  return std::move(context).WriteString(::blink::mojom::RegisterIdpStatusToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::Format>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::Format value) {
  return std::move(context).WriteString(::blink::mojom::FormatToString(value));
}

} // namespace perfetto