// third_party/blink/public/mojom/webid/federated_auth_request.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_WEBID_FEDERATED_AUTH_REQUEST_MOJOM_SEND_VALIDATION_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_WEBID_FEDERATED_AUTH_REQUEST_MOJOM_SEND_VALIDATION_H_

#include "third_party/blink/public/mojom/webid/federated_auth_request.mojom-shared-internal.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "mojo/public/mojom/base/values.mojom-shared.h"
#include "third_party/blink/public/mojom/credentialmanagement/credential_manager.mojom-shared.h"
#include "url/mojom/origin.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"

#include "third_party/blink/public/mojom/webid/federated_auth_request.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization_send_validation.h"
#include "mojo/public/cpp/bindings/lib/has_send_validation_helper.h"

namespace mojo::internal {
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::blink::mojom::RequestTokenStatus, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::blink::mojom::RequestUserInfoStatus, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::blink::mojom::DisconnectStatus, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::blink::mojom::IdpSigninStatus, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::blink::mojom::RpContext, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::blink::mojom::RpMode, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::blink::mojom::RegisterIdpStatus, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::blink::mojom::Format, MaybeConstUserType>
    : std::false_type {};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::blink::mojom::IdentityProviderConfigDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::IdentityProviderConfigDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::IdentityProviderConfig_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::config_url(input)) in_config_url = Traits::config_url(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->config_url)::BaseType> config_url_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::url::mojom::UrlDataView, send_validation>(
        in_config_url,
        config_url_fragment);

      fragment->config_url.Set(
          config_url_fragment.is_null() ? nullptr : config_url_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->config_url.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null config_url in IdentityProviderConfig struct");

      fragment->from_idp_registration_api = Traits::from_idp_registration_api(input);

      decltype(Traits::type(input)) in_type = Traits::type(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->type)::BaseType> type_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_type,
        type_fragment);

      fragment->type.Set(
          type_fragment.is_null() ? nullptr : type_fragment.data());

      decltype(Traits::client_id(input)) in_client_id = Traits::client_id(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->client_id)::BaseType> client_id_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_client_id,
        client_id_fragment);

      fragment->client_id.Set(
          client_id_fragment.is_null() ? nullptr : client_id_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->client_id.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null client_id in IdentityProviderConfig struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::blink::mojom::IdentityProviderRequestOptionsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::IdentityProviderRequestOptionsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::IdentityProviderRequestOptions_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::config(input)) in_config = Traits::config(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->config)::BaseType> config_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::blink::mojom::IdentityProviderConfigDataView, send_validation>(
        in_config,
        config_fragment);

      fragment->config.Set(
          config_fragment.is_null() ? nullptr : config_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->config.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null config in IdentityProviderRequestOptions struct");

      decltype(Traits::nonce(input)) in_nonce = Traits::nonce(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->nonce)::BaseType> nonce_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_nonce,
        nonce_fragment);

      fragment->nonce.Set(
          nonce_fragment.is_null() ? nullptr : nonce_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->nonce.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null nonce in IdentityProviderRequestOptions struct");

      decltype(Traits::login_hint(input)) in_login_hint = Traits::login_hint(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->login_hint)::BaseType> login_hint_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_login_hint,
        login_hint_fragment);

      fragment->login_hint.Set(
          login_hint_fragment.is_null() ? nullptr : login_hint_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->login_hint.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null login_hint in IdentityProviderRequestOptions struct");

      decltype(Traits::domain_hint(input)) in_domain_hint = Traits::domain_hint(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->domain_hint)::BaseType> domain_hint_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_domain_hint,
        domain_hint_fragment);

      fragment->domain_hint.Set(
          domain_hint_fragment.is_null() ? nullptr : domain_hint_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->domain_hint.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null domain_hint in IdentityProviderRequestOptions struct");

      decltype(Traits::fields(input)) in_fields = Traits::fields(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->fields)::BaseType>
          fields_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& fields_validate_params =
          mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>, send_validation>(
        in_fields,
        fields_fragment,
        &fields_validate_params);

      fragment->fields.Set(
          fields_fragment.is_null() ? nullptr : fields_fragment.data());

      decltype(Traits::params_json(input)) in_params_json = Traits::params_json(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->params_json)::BaseType> params_json_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_params_json,
        params_json_fragment);

      fragment->params_json.Set(
          params_json_fragment.is_null() ? nullptr : params_json_fragment.data());
      fragment->format_$flag = Traits::format(input).has_value();
      if (Traits::format(input).has_value()) {
        
        mojo::internal::Serialize<::blink::mojom::Format>(
          Traits::format(input).value(),
          &fragment->format_$value);
      } else {
        fragment->format_$value =
            static_cast<int32_t>(::blink::mojom::Format::kMinValue);
      }
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::blink::mojom::IdentityCredentialDisconnectOptionsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::IdentityCredentialDisconnectOptionsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::IdentityCredentialDisconnectOptions_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::config(input)) in_config = Traits::config(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->config)::BaseType> config_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::blink::mojom::IdentityProviderConfigDataView, send_validation>(
        in_config,
        config_fragment);

      fragment->config.Set(
          config_fragment.is_null() ? nullptr : config_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->config.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null config in IdentityCredentialDisconnectOptions struct");

      decltype(Traits::account_hint(input)) in_account_hint = Traits::account_hint(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->account_hint)::BaseType> account_hint_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_account_hint,
        account_hint_fragment);

      fragment->account_hint.Set(
          account_hint_fragment.is_null() ? nullptr : account_hint_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->account_hint.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null account_hint in IdentityCredentialDisconnectOptions struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::blink::mojom::IdentityUserInfoDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::IdentityUserInfoDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::IdentityUserInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::email(input)) in_email = Traits::email(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->email)::BaseType> email_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_email,
        email_fragment);

      fragment->email.Set(
          email_fragment.is_null() ? nullptr : email_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->email.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null email in IdentityUserInfo struct");

      decltype(Traits::given_name(input)) in_given_name = Traits::given_name(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->given_name)::BaseType> given_name_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_given_name,
        given_name_fragment);

      fragment->given_name.Set(
          given_name_fragment.is_null() ? nullptr : given_name_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->given_name.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null given_name in IdentityUserInfo struct");

      decltype(Traits::name(input)) in_name = Traits::name(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->name)::BaseType> name_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_name,
        name_fragment);

      fragment->name.Set(
          name_fragment.is_null() ? nullptr : name_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->name.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null name in IdentityUserInfo struct");

      decltype(Traits::picture(input)) in_picture = Traits::picture(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->picture)::BaseType> picture_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_picture,
        picture_fragment);

      fragment->picture.Set(
          picture_fragment.is_null() ? nullptr : picture_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->picture.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null picture in IdentityUserInfo struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::blink::mojom::LoginStatusAccountDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::LoginStatusAccountDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::LoginStatusAccount_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::id(input)) in_id = Traits::id(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->id)::BaseType> id_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_id,
        id_fragment);

      fragment->id.Set(
          id_fragment.is_null() ? nullptr : id_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->id.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null id in LoginStatusAccount struct");

      decltype(Traits::email(input)) in_email = Traits::email(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->email)::BaseType> email_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_email,
        email_fragment);

      fragment->email.Set(
          email_fragment.is_null() ? nullptr : email_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->email.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null email in LoginStatusAccount struct");

      decltype(Traits::name(input)) in_name = Traits::name(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->name)::BaseType> name_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_name,
        name_fragment);

      fragment->name.Set(
          name_fragment.is_null() ? nullptr : name_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->name.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null name in LoginStatusAccount struct");

      decltype(Traits::given_name(input)) in_given_name = Traits::given_name(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->given_name)::BaseType> given_name_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_given_name,
        given_name_fragment);

      fragment->given_name.Set(
          given_name_fragment.is_null() ? nullptr : given_name_fragment.data());

      decltype(Traits::picture(input)) in_picture = Traits::picture(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->picture)::BaseType> picture_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::url::mojom::UrlDataView, send_validation>(
        in_picture,
        picture_fragment);

      fragment->picture.Set(
          picture_fragment.is_null() ? nullptr : picture_fragment.data());
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::blink::mojom::LoginStatusOptionsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::LoginStatusOptionsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::LoginStatusOptions_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::accounts(input)) in_accounts = Traits::accounts(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->accounts)::BaseType>
          accounts_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& accounts_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::LoginStatusAccountDataView>, send_validation>(
        in_accounts,
        accounts_fragment,
        &accounts_validate_params);

      fragment->accounts.Set(
          accounts_fragment.is_null() ? nullptr : accounts_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->accounts.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null accounts in LoginStatusOptions struct");

      decltype(Traits::expiration(input)) in_expiration = Traits::expiration(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->expiration)::BaseType> expiration_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView, send_validation>(
        in_expiration,
        expiration_fragment);

      fragment->expiration.Set(
          expiration_fragment.is_null() ? nullptr : expiration_fragment.data());
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::blink::mojom::IdentityProviderGetParametersDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::IdentityProviderGetParametersDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::IdentityProviderGetParameters_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::providers(input)) in_providers = Traits::providers(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->providers)::BaseType>
          providers_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& providers_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::IdentityProviderRequestOptionsDataView>, send_validation>(
        in_providers,
        providers_fragment,
        &providers_validate_params);

      fragment->providers.Set(
          providers_fragment.is_null() ? nullptr : providers_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->providers.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null providers in IdentityProviderGetParameters struct");

      
      mojo::internal::Serialize<::blink::mojom::RpContext>(
        Traits::context(input),
        &fragment->context);

      
      mojo::internal::Serialize<::blink::mojom::RpMode>(
        Traits::mode(input),
        &fragment->mode);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::blink::mojom::TokenErrorDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::TokenErrorDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::TokenError_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::code(input)) in_code = Traits::code(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->code)::BaseType> code_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_code,
        code_fragment);

      fragment->code.Set(
          code_fragment.is_null() ? nullptr : code_fragment.data());

      decltype(Traits::url(input)) in_url = Traits::url(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->url)::BaseType> url_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_url,
        url_fragment);

      fragment->url.Set(
          url_fragment.is_null() ? nullptr : url_fragment.data());
  }
};

}  // namespace mojo::internal

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_WEBID_FEDERATED_AUTH_REQUEST_MOJOM_SEND_VALIDATION_H_