// third_party/blink/public/mojom/webid/federated_auth_request.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_WEBID_FEDERATED_AUTH_REQUEST_MOJOM_DATA_VIEW_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_WEBID_FEDERATED_AUTH_REQUEST_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/blink/public/mojom/webid/federated_auth_request.mojom-shared-internal.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "mojo/public/mojom/base/values.mojom-shared.h"
#include "third_party/blink/public/mojom/credentialmanagement/credential_manager.mojom-shared.h"
#include "url/mojom/origin.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"


namespace blink::mojom {
class IdentityProviderConfigDataView;

class IdentityProviderRequestOptionsDataView;

class IdentityCredentialDisconnectOptionsDataView;

class IdentityUserInfoDataView;

class LoginStatusAccountDataView;

class LoginStatusOptionsDataView;

class IdentityProviderGetParametersDataView;

class TokenErrorDataView;



}  // blink::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::IdentityProviderConfigDataView> {
  using Data = ::blink::mojom::internal::IdentityProviderConfig_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::IdentityProviderRequestOptionsDataView> {
  using Data = ::blink::mojom::internal::IdentityProviderRequestOptions_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::IdentityCredentialDisconnectOptionsDataView> {
  using Data = ::blink::mojom::internal::IdentityCredentialDisconnectOptions_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::IdentityUserInfoDataView> {
  using Data = ::blink::mojom::internal::IdentityUserInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::LoginStatusAccountDataView> {
  using Data = ::blink::mojom::internal::LoginStatusAccount_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::LoginStatusOptionsDataView> {
  using Data = ::blink::mojom::internal::LoginStatusOptions_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::IdentityProviderGetParametersDataView> {
  using Data = ::blink::mojom::internal::IdentityProviderGetParameters_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::TokenErrorDataView> {
  using Data = ::blink::mojom::internal::TokenError_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace blink::mojom {


enum class RequestTokenStatus : int32_t {
  
  kSuccess = 0,
  
  kErrorTooManyRequests = 1,
  
  kErrorCanceled = 2,
  
  kError = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, RequestTokenStatus value);
inline bool IsKnownEnumValue(RequestTokenStatus value) {
  return internal::RequestTokenStatus_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class RequestUserInfoStatus : int32_t {
  
  kSuccess = 0,
  
  kError = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, RequestUserInfoStatus value);
inline bool IsKnownEnumValue(RequestUserInfoStatus value) {
  return internal::RequestUserInfoStatus_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class DisconnectStatus : int32_t {
  
  kSuccess = 0,
  
  kErrorTooManyRequests = 1,
  
  kError = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, DisconnectStatus value);
inline bool IsKnownEnumValue(DisconnectStatus value) {
  return internal::DisconnectStatus_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class IdpSigninStatus : int32_t {
  
  kSignedIn = 0,
  
  kSignedOut = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, IdpSigninStatus value);
inline bool IsKnownEnumValue(IdpSigninStatus value) {
  return internal::IdpSigninStatus_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class RpContext : int32_t {
  
  kSignIn = 0,
  
  kSignUp = 1,
  
  kUse = 2,
  
  kContinue = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, RpContext value);
inline bool IsKnownEnumValue(RpContext value) {
  return internal::RpContext_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class RpMode : int32_t {
  
  kActive = 0,
  
  kPassive = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, RpMode value);
inline bool IsKnownEnumValue(RpMode value) {
  return internal::RpMode_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class RegisterIdpStatus : int32_t {
  
  kSuccess = 0,
  
  kErrorFeatureDisabled = 1,
  
  kErrorCrossOriginConfig = 2,
  
  kErrorNoTransientActivation = 3,
  
  kErrorDeclined = 4,
  
  kErrorInvalidConfig = 5,
  kMinValue = 0,
  kMaxValue = 5,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, RegisterIdpStatus value);
inline bool IsKnownEnumValue(RegisterIdpStatus value) {
  return internal::RegisterIdpStatus_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class Format : int32_t {
  
  kSdJwt = 0,
  kMinValue = 0,
  kMaxValue = 0,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, Format value);
inline bool IsKnownEnumValue(Format value) {
  return internal::Format_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class FederatedAuthRequestInterfaceBase {};

using FederatedAuthRequestPtrDataView =
    mojo::InterfacePtrDataView<FederatedAuthRequestInterfaceBase>;
using FederatedAuthRequestRequestDataView =
    mojo::InterfaceRequestDataView<FederatedAuthRequestInterfaceBase>;
using FederatedAuthRequestAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<FederatedAuthRequestInterfaceBase>;
using FederatedAuthRequestAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<FederatedAuthRequestInterfaceBase>;


class IdentityProviderConfigDataView {
 public:
  IdentityProviderConfigDataView() = default;

  IdentityProviderConfigDataView(
      internal::IdentityProviderConfig_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetConfigUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadConfigUrl(UserType* output) {
    
    auto* pointer = data_->config_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  bool from_idp_registration_api() const {
    return data_->from_idp_registration_api;
  }
  inline void GetTypeDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadType(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `type` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadType` instead "
    "of `ReadType if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->type.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetClientIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadClientId(UserType* output) {
    
    auto* pointer = data_->client_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::IdentityProviderConfig_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class IdentityProviderRequestOptionsDataView {
 public:
  IdentityProviderRequestOptionsDataView() = default;

  IdentityProviderRequestOptionsDataView(
      internal::IdentityProviderRequestOptions_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetConfigDataView(
      IdentityProviderConfigDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadConfig(UserType* output) {
    
    auto* pointer = data_->config.Get();
    return mojo::internal::Deserialize<::blink::mojom::IdentityProviderConfigDataView>(
        pointer, output, message_);
  }
  inline void GetNonceDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadNonce(UserType* output) {
    
    auto* pointer = data_->nonce.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetLoginHintDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLoginHint(UserType* output) {
    
    auto* pointer = data_->login_hint.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetDomainHintDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDomainHint(UserType* output) {
    
    auto* pointer = data_->domain_hint.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetFieldsDataView(
      mojo::ArrayDataView<mojo::StringDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFields(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<mojo::StringDataView>, UserType>(),
    "Attempting to read the optional `fields` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadFields` instead "
    "of `ReadFields if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->fields.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::StringDataView>>(
        pointer, output, message_);
  }
  inline void GetParamsJsonDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadParamsJson(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `params_json` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadParamsJson` instead "
    "of `ReadParamsJson if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->params_json.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadFormat(UserType* output) const {
    if (!data_->format_$flag) {
      *output = std::nullopt;
      return true;
    }

    return mojo::internal::Deserialize<::blink::mojom::Format>(
        data_->format_$value, &output->emplace());
  }
  std::optional<Format> format() const {
    if (!data_->format_$flag) {
      return std::nullopt;
    }
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::Format>(data_->format_$value));
  }
 private:
  internal::IdentityProviderRequestOptions_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class IdentityCredentialDisconnectOptionsDataView {
 public:
  IdentityCredentialDisconnectOptionsDataView() = default;

  IdentityCredentialDisconnectOptionsDataView(
      internal::IdentityCredentialDisconnectOptions_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetConfigDataView(
      IdentityProviderConfigDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadConfig(UserType* output) {
    
    auto* pointer = data_->config.Get();
    return mojo::internal::Deserialize<::blink::mojom::IdentityProviderConfigDataView>(
        pointer, output, message_);
  }
  inline void GetAccountHintDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAccountHint(UserType* output) {
    
    auto* pointer = data_->account_hint.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::IdentityCredentialDisconnectOptions_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class IdentityUserInfoDataView {
 public:
  IdentityUserInfoDataView() = default;

  IdentityUserInfoDataView(
      internal::IdentityUserInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetEmailDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadEmail(UserType* output) {
    
    auto* pointer = data_->email.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetGivenNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadGivenName(UserType* output) {
    
    auto* pointer = data_->given_name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadName(UserType* output) {
    
    auto* pointer = data_->name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetPictureDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPicture(UserType* output) {
    
    auto* pointer = data_->picture.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::IdentityUserInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class LoginStatusAccountDataView {
 public:
  LoginStatusAccountDataView() = default;

  LoginStatusAccountDataView(
      internal::LoginStatusAccount_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadId(UserType* output) {
    
    auto* pointer = data_->id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetEmailDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadEmail(UserType* output) {
    
    auto* pointer = data_->email.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadName(UserType* output) {
    
    auto* pointer = data_->name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetGivenNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadGivenName(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `given_name` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadGivenName` instead "
    "of `ReadGivenName if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->given_name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetPictureDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPicture(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::url::mojom::UrlDataView, UserType>(),
    "Attempting to read the optional `picture` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadPicture` instead "
    "of `ReadPicture if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->picture.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
 private:
  internal::LoginStatusAccount_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class LoginStatusOptionsDataView {
 public:
  LoginStatusOptionsDataView() = default;

  LoginStatusOptionsDataView(
      internal::LoginStatusOptions_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetAccountsDataView(
      mojo::ArrayDataView<LoginStatusAccountDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAccounts(UserType* output) {
    
    auto* pointer = data_->accounts.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::LoginStatusAccountDataView>>(
        pointer, output, message_);
  }
  inline void GetExpirationDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadExpiration(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::TimeDeltaDataView, UserType>(),
    "Attempting to read the optional `expiration` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadExpiration` instead "
    "of `ReadExpiration if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->expiration.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
 private:
  internal::LoginStatusOptions_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class IdentityProviderGetParametersDataView {
 public:
  IdentityProviderGetParametersDataView() = default;

  IdentityProviderGetParametersDataView(
      internal::IdentityProviderGetParameters_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetProvidersDataView(
      mojo::ArrayDataView<IdentityProviderRequestOptionsDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadProviders(UserType* output) {
    
    auto* pointer = data_->providers.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::IdentityProviderRequestOptionsDataView>>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadContext(UserType* output) const {
    auto data_value = data_->context;
    return mojo::internal::Deserialize<::blink::mojom::RpContext>(
        data_value, output);
  }
  RpContext context() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::RpContext>(data_->context));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadMode(UserType* output) const {
    auto data_value = data_->mode;
    return mojo::internal::Deserialize<::blink::mojom::RpMode>(
        data_value, output);
  }
  RpMode mode() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::RpMode>(data_->mode));
  }
 private:
  internal::IdentityProviderGetParameters_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class TokenErrorDataView {
 public:
  TokenErrorDataView() = default;

  TokenErrorDataView(
      internal::TokenError_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetCodeDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCode(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `code` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadCode` instead "
    "of `ReadCode if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->code.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetUrlDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrl(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `url` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadUrl` instead "
    "of `ReadUrl if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::TokenError_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // blink::mojom

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_WEBID_FEDERATED_AUTH_REQUEST_MOJOM_DATA_VIEW_H_