// third_party/blink/public/mojom/webid/federated_auth_request.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/webid/federated_auth_request.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/webid/federated_auth_request.mojom-params-data.h"
#include "third_party/blink/public/mojom/webid/federated_auth_request.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/webid/federated_auth_request.mojom-blink-import-headers.h"
#include "third_party/blink/public/mojom/webid/federated_auth_request.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace blink::mojom::blink {
IdentityProviderConfig::IdentityProviderConfig()
    : config_url(),
      from_idp_registration_api(),
      type(),
      client_id() {}

IdentityProviderConfig::IdentityProviderConfig(
    const ::blink::KURL& config_url_in,
    bool from_idp_registration_api_in,
    const ::blink::String& type_in,
    const ::blink::String& client_id_in)
    : config_url(std::move(config_url_in)),
      from_idp_registration_api(std::move(from_idp_registration_api_in)),
      type(std::move(type_in)),
      client_id(std::move(client_id_in)) {}

IdentityProviderConfig::~IdentityProviderConfig() = default;

void IdentityProviderConfig::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "config_url"), this->config_url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::KURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "from_idp_registration_api"), this->from_idp_registration_api,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "type"), this->type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "client_id"), this->client_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool IdentityProviderConfig::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
IdentityProviderRequestOptions::IdentityProviderRequestOptions()
    : config(),
      nonce(),
      login_hint(),
      domain_hint(),
      fields(),
      params_json(),
      format() {}

IdentityProviderRequestOptions::IdentityProviderRequestOptions(
    IdentityProviderConfigPtr config_in,
    const ::blink::String& nonce_in,
    const ::blink::String& login_hint_in,
    const ::blink::String& domain_hint_in,
    std::optional<::blink::Vector<::blink::String>> fields_in,
    const ::blink::String& params_json_in,
    std::optional<Format> format_in)
    : config(std::move(config_in)),
      nonce(std::move(nonce_in)),
      login_hint(std::move(login_hint_in)),
      domain_hint(std::move(domain_hint_in)),
      fields(std::move(fields_in)),
      params_json(std::move(params_json_in)),
      format(std::move(format_in)) {}

IdentityProviderRequestOptions::~IdentityProviderRequestOptions() = default;

void IdentityProviderRequestOptions::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "config"), this->config,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type IdentityProviderConfigPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "nonce"), this->nonce,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "login_hint"), this->login_hint,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "domain_hint"), this->domain_hint,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "fields"), this->fields,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::blink::Vector<::blink::String>>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "params_json"), this->params_json,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "format"), this->format,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<Format>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool IdentityProviderRequestOptions::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
IdentityCredentialDisconnectOptions::IdentityCredentialDisconnectOptions()
    : config(),
      account_hint() {}

IdentityCredentialDisconnectOptions::IdentityCredentialDisconnectOptions(
    IdentityProviderConfigPtr config_in,
    const ::blink::String& account_hint_in)
    : config(std::move(config_in)),
      account_hint(std::move(account_hint_in)) {}

IdentityCredentialDisconnectOptions::~IdentityCredentialDisconnectOptions() = default;

void IdentityCredentialDisconnectOptions::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "config"), this->config,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type IdentityProviderConfigPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "account_hint"), this->account_hint,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool IdentityCredentialDisconnectOptions::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
IdentityUserInfo::IdentityUserInfo()
    : email(),
      given_name(),
      name(),
      picture() {}

IdentityUserInfo::IdentityUserInfo(
    const ::blink::String& email_in,
    const ::blink::String& given_name_in,
    const ::blink::String& name_in,
    const ::blink::String& picture_in)
    : email(std::move(email_in)),
      given_name(std::move(given_name_in)),
      name(std::move(name_in)),
      picture(std::move(picture_in)) {}

IdentityUserInfo::~IdentityUserInfo() = default;
size_t IdentityUserInfo::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->email);
  seed = mojo::internal::WTFHash(seed, this->given_name);
  seed = mojo::internal::WTFHash(seed, this->name);
  seed = mojo::internal::WTFHash(seed, this->picture);
  return seed;
}

void IdentityUserInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "email"), this->email,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "given_name"), this->given_name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "name"), this->name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "picture"), this->picture,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool IdentityUserInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
LoginStatusAccount::LoginStatusAccount()
    : id(),
      email(),
      name(),
      given_name(),
      picture() {}

LoginStatusAccount::LoginStatusAccount(
    const ::blink::String& id_in,
    const ::blink::String& email_in,
    const ::blink::String& name_in,
    const ::blink::String& given_name_in,
    const std::optional<::blink::KURL>& picture_in)
    : id(std::move(id_in)),
      email(std::move(email_in)),
      name(std::move(name_in)),
      given_name(std::move(given_name_in)),
      picture(std::move(picture_in)) {}

LoginStatusAccount::~LoginStatusAccount() = default;

void LoginStatusAccount::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "id"), this->id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "email"), this->email,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "name"), this->name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "given_name"), this->given_name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "picture"), this->picture,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::blink::KURL>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool LoginStatusAccount::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
LoginStatusOptions::LoginStatusOptions()
    : accounts(),
      expiration() {}

LoginStatusOptions::LoginStatusOptions(
    ::blink::Vector<LoginStatusAccountPtr> accounts_in,
    std::optional<::base::TimeDelta> expiration_in)
    : accounts(std::move(accounts_in)),
      expiration(std::move(expiration_in)) {}

LoginStatusOptions::~LoginStatusOptions() = default;

void LoginStatusOptions::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "accounts"), this->accounts,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::Vector<LoginStatusAccountPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "expiration"), this->expiration,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<::base::TimeDelta>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool LoginStatusOptions::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
IdentityProviderGetParameters::IdentityProviderGetParameters()
    : providers(),
      context(),
      mode() {}

IdentityProviderGetParameters::IdentityProviderGetParameters(
    ::blink::Vector<IdentityProviderRequestOptionsPtr> providers_in,
    RpContext context_in,
    RpMode mode_in)
    : providers(std::move(providers_in)),
      context(std::move(context_in)),
      mode(std::move(mode_in)) {}

IdentityProviderGetParameters::~IdentityProviderGetParameters() = default;

void IdentityProviderGetParameters::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "providers"), this->providers,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::Vector<IdentityProviderRequestOptionsPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "context"), this->context,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type RpContext>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "mode"), this->mode,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type RpMode>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool IdentityProviderGetParameters::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
TokenError::TokenError()
    : code(),
      url() {}

TokenError::TokenError(
    const ::blink::String& code_in,
    const ::blink::String& url_in)
    : code(std::move(code_in)),
      url(std::move(url_in)) {}

TokenError::~TokenError() = default;

void TokenError::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "code"), this->code,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "url"), this->url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool TokenError::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

FederatedAuthRequest::IPCStableHashFunction FederatedAuthRequest::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::FederatedAuthRequest>(message.name())) {
    case messages::FederatedAuthRequest::kRequestToken: {
      return &FederatedAuthRequest::RequestToken_Sym::IPCStableHash;
    }
    case messages::FederatedAuthRequest::kRequestUserInfo: {
      return &FederatedAuthRequest::RequestUserInfo_Sym::IPCStableHash;
    }
    case messages::FederatedAuthRequest::kCancelTokenRequest: {
      return &FederatedAuthRequest::CancelTokenRequest_Sym::IPCStableHash;
    }
    case messages::FederatedAuthRequest::kResolveTokenRequest: {
      return &FederatedAuthRequest::ResolveTokenRequest_Sym::IPCStableHash;
    }
    case messages::FederatedAuthRequest::kSetIdpSigninStatus: {
      return &FederatedAuthRequest::SetIdpSigninStatus_Sym::IPCStableHash;
    }
    case messages::FederatedAuthRequest::kRegisterIdP: {
      return &FederatedAuthRequest::RegisterIdP_Sym::IPCStableHash;
    }
    case messages::FederatedAuthRequest::kUnregisterIdP: {
      return &FederatedAuthRequest::UnregisterIdP_Sym::IPCStableHash;
    }
    case messages::FederatedAuthRequest::kCloseModalDialogView: {
      return &FederatedAuthRequest::CloseModalDialogView_Sym::IPCStableHash;
    }
    case messages::FederatedAuthRequest::kPreventSilentAccess: {
      return &FederatedAuthRequest::PreventSilentAccess_Sym::IPCStableHash;
    }
    case messages::FederatedAuthRequest::kDisconnect: {
      return &FederatedAuthRequest::Disconnect_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* FederatedAuthRequest::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::FederatedAuthRequest>(message.name())) {
      case messages::FederatedAuthRequest::kRequestToken:
            return "Receive blink::mojom::FederatedAuthRequest::RequestToken";
      case messages::FederatedAuthRequest::kRequestUserInfo:
            return "Receive blink::mojom::FederatedAuthRequest::RequestUserInfo";
      case messages::FederatedAuthRequest::kCancelTokenRequest:
            return "Receive blink::mojom::FederatedAuthRequest::CancelTokenRequest";
      case messages::FederatedAuthRequest::kResolveTokenRequest:
            return "Receive blink::mojom::FederatedAuthRequest::ResolveTokenRequest";
      case messages::FederatedAuthRequest::kSetIdpSigninStatus:
            return "Receive blink::mojom::FederatedAuthRequest::SetIdpSigninStatus";
      case messages::FederatedAuthRequest::kRegisterIdP:
            return "Receive blink::mojom::FederatedAuthRequest::RegisterIdP";
      case messages::FederatedAuthRequest::kUnregisterIdP:
            return "Receive blink::mojom::FederatedAuthRequest::UnregisterIdP";
      case messages::FederatedAuthRequest::kCloseModalDialogView:
            return "Receive blink::mojom::FederatedAuthRequest::CloseModalDialogView";
      case messages::FederatedAuthRequest::kPreventSilentAccess:
            return "Receive blink::mojom::FederatedAuthRequest::PreventSilentAccess";
      case messages::FederatedAuthRequest::kDisconnect:
            return "Receive blink::mojom::FederatedAuthRequest::Disconnect";
    }
  } else {
    switch (static_cast<messages::FederatedAuthRequest>(message.name())) {
      case messages::FederatedAuthRequest::kRequestToken:
            return "Receive reply blink::mojom::FederatedAuthRequest::RequestToken";
      case messages::FederatedAuthRequest::kRequestUserInfo:
            return "Receive reply blink::mojom::FederatedAuthRequest::RequestUserInfo";
      case messages::FederatedAuthRequest::kCancelTokenRequest:
            return "Receive reply blink::mojom::FederatedAuthRequest::CancelTokenRequest";
      case messages::FederatedAuthRequest::kResolveTokenRequest:
            return "Receive reply blink::mojom::FederatedAuthRequest::ResolveTokenRequest";
      case messages::FederatedAuthRequest::kSetIdpSigninStatus:
            return "Receive reply blink::mojom::FederatedAuthRequest::SetIdpSigninStatus";
      case messages::FederatedAuthRequest::kRegisterIdP:
            return "Receive reply blink::mojom::FederatedAuthRequest::RegisterIdP";
      case messages::FederatedAuthRequest::kUnregisterIdP:
            return "Receive reply blink::mojom::FederatedAuthRequest::UnregisterIdP";
      case messages::FederatedAuthRequest::kCloseModalDialogView:
            return "Receive reply blink::mojom::FederatedAuthRequest::CloseModalDialogView";
      case messages::FederatedAuthRequest::kPreventSilentAccess:
            return "Receive reply blink::mojom::FederatedAuthRequest::PreventSilentAccess";
      case messages::FederatedAuthRequest::kDisconnect:
            return "Receive reply blink::mojom::FederatedAuthRequest::Disconnect";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t FederatedAuthRequest::RequestToken_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x65c9efb9;  // IPCStableHash for blink::mojom::FederatedAuthRequest::RequestToken
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FederatedAuthRequest::RequestUserInfo_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x289a584e;  // IPCStableHash for blink::mojom::FederatedAuthRequest::RequestUserInfo
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FederatedAuthRequest::CancelTokenRequest_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x66c9eaf8;  // IPCStableHash for blink::mojom::FederatedAuthRequest::CancelTokenRequest
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FederatedAuthRequest::ResolveTokenRequest_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x2fd920ef;  // IPCStableHash for blink::mojom::FederatedAuthRequest::ResolveTokenRequest
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FederatedAuthRequest::SetIdpSigninStatus_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x292ba301;  // IPCStableHash for blink::mojom::FederatedAuthRequest::SetIdpSigninStatus
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FederatedAuthRequest::RegisterIdP_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x3de23acf;  // IPCStableHash for blink::mojom::FederatedAuthRequest::RegisterIdP
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FederatedAuthRequest::UnregisterIdP_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x988908b7;  // IPCStableHash for blink::mojom::FederatedAuthRequest::UnregisterIdP
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FederatedAuthRequest::CloseModalDialogView_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x1a1aef96;  // IPCStableHash for blink::mojom::FederatedAuthRequest::CloseModalDialogView
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FederatedAuthRequest::PreventSilentAccess_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x00d99ae4;  // IPCStableHash for blink::mojom::FederatedAuthRequest::PreventSilentAccess
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FederatedAuthRequest::Disconnect_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x01a1e034;  // IPCStableHash for blink::mojom::FederatedAuthRequest::Disconnect
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class FederatedAuthRequest_RequestToken_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FederatedAuthRequest_RequestToken_ForwardToCallback(
      FederatedAuthRequest::RequestTokenCallback callback
      ) : callback_(std::move(callback)) {
  }

  FederatedAuthRequest_RequestToken_ForwardToCallback(const FederatedAuthRequest_RequestToken_ForwardToCallback&) = delete;
  FederatedAuthRequest_RequestToken_ForwardToCallback& operator=(const FederatedAuthRequest_RequestToken_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  FederatedAuthRequest::RequestTokenCallback callback_;
};

class FederatedAuthRequest_RequestUserInfo_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FederatedAuthRequest_RequestUserInfo_ForwardToCallback(
      FederatedAuthRequest::RequestUserInfoCallback callback
      ) : callback_(std::move(callback)) {
  }

  FederatedAuthRequest_RequestUserInfo_ForwardToCallback(const FederatedAuthRequest_RequestUserInfo_ForwardToCallback&) = delete;
  FederatedAuthRequest_RequestUserInfo_ForwardToCallback& operator=(const FederatedAuthRequest_RequestUserInfo_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  FederatedAuthRequest::RequestUserInfoCallback callback_;
};

class FederatedAuthRequest_ResolveTokenRequest_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FederatedAuthRequest_ResolveTokenRequest_ForwardToCallback(
      FederatedAuthRequest::ResolveTokenRequestCallback callback
      ) : callback_(std::move(callback)) {
  }

  FederatedAuthRequest_ResolveTokenRequest_ForwardToCallback(const FederatedAuthRequest_ResolveTokenRequest_ForwardToCallback&) = delete;
  FederatedAuthRequest_ResolveTokenRequest_ForwardToCallback& operator=(const FederatedAuthRequest_ResolveTokenRequest_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  FederatedAuthRequest::ResolveTokenRequestCallback callback_;
};

class FederatedAuthRequest_SetIdpSigninStatus_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FederatedAuthRequest_SetIdpSigninStatus_ForwardToCallback(
      FederatedAuthRequest::SetIdpSigninStatusCallback callback
      ) : callback_(std::move(callback)) {
  }

  FederatedAuthRequest_SetIdpSigninStatus_ForwardToCallback(const FederatedAuthRequest_SetIdpSigninStatus_ForwardToCallback&) = delete;
  FederatedAuthRequest_SetIdpSigninStatus_ForwardToCallback& operator=(const FederatedAuthRequest_SetIdpSigninStatus_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  FederatedAuthRequest::SetIdpSigninStatusCallback callback_;
};

class FederatedAuthRequest_RegisterIdP_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FederatedAuthRequest_RegisterIdP_ForwardToCallback(
      FederatedAuthRequest::RegisterIdPCallback callback
      ) : callback_(std::move(callback)) {
  }

  FederatedAuthRequest_RegisterIdP_ForwardToCallback(const FederatedAuthRequest_RegisterIdP_ForwardToCallback&) = delete;
  FederatedAuthRequest_RegisterIdP_ForwardToCallback& operator=(const FederatedAuthRequest_RegisterIdP_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  FederatedAuthRequest::RegisterIdPCallback callback_;
};

class FederatedAuthRequest_UnregisterIdP_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FederatedAuthRequest_UnregisterIdP_ForwardToCallback(
      FederatedAuthRequest::UnregisterIdPCallback callback
      ) : callback_(std::move(callback)) {
  }

  FederatedAuthRequest_UnregisterIdP_ForwardToCallback(const FederatedAuthRequest_UnregisterIdP_ForwardToCallback&) = delete;
  FederatedAuthRequest_UnregisterIdP_ForwardToCallback& operator=(const FederatedAuthRequest_UnregisterIdP_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  FederatedAuthRequest::UnregisterIdPCallback callback_;
};

class FederatedAuthRequest_PreventSilentAccess_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FederatedAuthRequest_PreventSilentAccess_ForwardToCallback(
      FederatedAuthRequest::PreventSilentAccessCallback callback
      ) : callback_(std::move(callback)) {
  }

  FederatedAuthRequest_PreventSilentAccess_ForwardToCallback(const FederatedAuthRequest_PreventSilentAccess_ForwardToCallback&) = delete;
  FederatedAuthRequest_PreventSilentAccess_ForwardToCallback& operator=(const FederatedAuthRequest_PreventSilentAccess_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  FederatedAuthRequest::PreventSilentAccessCallback callback_;
};

class FederatedAuthRequest_Disconnect_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FederatedAuthRequest_Disconnect_ForwardToCallback(
      FederatedAuthRequest::DisconnectCallback callback
      ) : callback_(std::move(callback)) {
  }

  FederatedAuthRequest_Disconnect_ForwardToCallback(const FederatedAuthRequest_Disconnect_ForwardToCallback&) = delete;
  FederatedAuthRequest_Disconnect_ForwardToCallback& operator=(const FederatedAuthRequest_Disconnect_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  FederatedAuthRequest::DisconnectCallback callback_;
};

FederatedAuthRequestProxy::FederatedAuthRequestProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void FederatedAuthRequestProxy::RequestToken(
    ::blink::Vector<IdentityProviderGetParametersPtr> in_idp_get_params, ::blink::mojom::blink::CredentialMediationRequirement in_requirement, RequestTokenCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::FederatedAuthRequest::RequestToken", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("idp_get_params"), in_idp_get_params,
                        "<value of type ::blink::Vector<IdentityProviderGetParametersPtr>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("requirement"), in_requirement,
                        "<value of type ::blink::mojom::blink::CredentialMediationRequirement>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FederatedAuthRequest::kRequestToken), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FederatedAuthRequest_RequestToken_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->idp_get_params)::BaseType>
      idp_get_params_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& idp_get_params_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::IdentityProviderGetParametersDataView>>(
    in_idp_get_params,
    idp_get_params_fragment,
    &idp_get_params_validate_params);

  params->idp_get_params.Set(
      idp_get_params_fragment.is_null() ? nullptr : idp_get_params_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->idp_get_params.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null idp_get_params in FederatedAuthRequest.RequestToken request");

  
  mojo::internal::Serialize<::blink::mojom::CredentialMediationRequirement>(
    in_requirement,
    &params->requirement);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FederatedAuthRequest::Name_);
  message.set_method_name("RequestToken");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FederatedAuthRequest_RequestToken_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void FederatedAuthRequestProxy::RequestUserInfo(
    IdentityProviderConfigPtr in_provider, RequestUserInfoCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::FederatedAuthRequest::RequestUserInfo", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("provider"), in_provider,
                        "<value of type IdentityProviderConfigPtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FederatedAuthRequest::kRequestUserInfo), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FederatedAuthRequest_RequestUserInfo_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->provider)::BaseType> provider_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::IdentityProviderConfigDataView>(
    in_provider,
    provider_fragment);

  params->provider.Set(
      provider_fragment.is_null() ? nullptr : provider_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->provider.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null provider in FederatedAuthRequest.RequestUserInfo request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FederatedAuthRequest::Name_);
  message.set_method_name("RequestUserInfo");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FederatedAuthRequest_RequestUserInfo_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void FederatedAuthRequestProxy::CancelTokenRequest(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::FederatedAuthRequest::CancelTokenRequest");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FederatedAuthRequest::kCancelTokenRequest), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FederatedAuthRequest_CancelTokenRequest_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FederatedAuthRequest::Name_);
  message.set_method_name("CancelTokenRequest");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void FederatedAuthRequestProxy::ResolveTokenRequest(
    const ::blink::String& in_account_id, ::base::Value in_token, ResolveTokenRequestCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::FederatedAuthRequest::ResolveTokenRequest", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("account_id"), in_account_id,
                        "<value of type const ::blink::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("token"), in_token,
                        "<value of type ::base::Value>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FederatedAuthRequest::kResolveTokenRequest), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FederatedAuthRequest_ResolveTokenRequest_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->account_id)::BaseType> account_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_account_id,
    account_id_fragment);

  params->account_id.Set(
      account_id_fragment.is_null() ? nullptr : account_id_fragment.data());
  mojo::internal::MessageFragment<decltype(params->token)>
      token_fragment(params.message());
  token_fragment.Claim(&params->token);
  
  mojo::internal::Serialize<::mojo_base::mojom::ValueDataView>(
    in_token,
    token_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->token.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null token in FederatedAuthRequest.ResolveTokenRequest request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FederatedAuthRequest::Name_);
  message.set_method_name("ResolveTokenRequest");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FederatedAuthRequest_ResolveTokenRequest_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void FederatedAuthRequestProxy::SetIdpSigninStatus(
    const ::scoped_refptr<const ::blink::SecurityOrigin>& in_origin, IdpSigninStatus in_status, LoginStatusOptionsPtr in_options, SetIdpSigninStatusCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::FederatedAuthRequest::SetIdpSigninStatus", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("origin"), in_origin,
                        "<value of type const ::scoped_refptr<const ::blink::SecurityOrigin>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type IdpSigninStatus>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("options"), in_options,
                        "<value of type LoginStatusOptionsPtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FederatedAuthRequest::kSetIdpSigninStatus), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FederatedAuthRequest_SetIdpSigninStatus_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->origin)::BaseType> origin_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::OriginDataView>(
    in_origin,
    origin_fragment);

  params->origin.Set(
      origin_fragment.is_null() ? nullptr : origin_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->origin.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null origin in FederatedAuthRequest.SetIdpSigninStatus request");

  
  mojo::internal::Serialize<::blink::mojom::IdpSigninStatus>(
    in_status,
    &params->status);
  mojo::internal::MessageFragment<
      typename decltype(params->options)::BaseType> options_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::LoginStatusOptionsDataView>(
    in_options,
    options_fragment);

  params->options.Set(
      options_fragment.is_null() ? nullptr : options_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FederatedAuthRequest::Name_);
  message.set_method_name("SetIdpSigninStatus");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FederatedAuthRequest_SetIdpSigninStatus_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void FederatedAuthRequestProxy::RegisterIdP(
    const ::blink::KURL& in_url, RegisterIdPCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::FederatedAuthRequest::RegisterIdP", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::blink::KURL&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FederatedAuthRequest::kRegisterIdP), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FederatedAuthRequest_RegisterIdP_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_url,
    url_fragment);

  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null url in FederatedAuthRequest.RegisterIdP request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FederatedAuthRequest::Name_);
  message.set_method_name("RegisterIdP");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FederatedAuthRequest_RegisterIdP_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void FederatedAuthRequestProxy::UnregisterIdP(
    const ::blink::KURL& in_url, UnregisterIdPCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::FederatedAuthRequest::UnregisterIdP", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::blink::KURL&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FederatedAuthRequest::kUnregisterIdP), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FederatedAuthRequest_UnregisterIdP_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_url,
    url_fragment);

  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null url in FederatedAuthRequest.UnregisterIdP request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FederatedAuthRequest::Name_);
  message.set_method_name("UnregisterIdP");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FederatedAuthRequest_UnregisterIdP_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void FederatedAuthRequestProxy::CloseModalDialogView(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::FederatedAuthRequest::CloseModalDialogView");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FederatedAuthRequest::kCloseModalDialogView), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FederatedAuthRequest_CloseModalDialogView_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FederatedAuthRequest::Name_);
  message.set_method_name("CloseModalDialogView");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void FederatedAuthRequestProxy::PreventSilentAccess(
    PreventSilentAccessCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::FederatedAuthRequest::PreventSilentAccess");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FederatedAuthRequest::kPreventSilentAccess), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FederatedAuthRequest_PreventSilentAccess_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FederatedAuthRequest::Name_);
  message.set_method_name("PreventSilentAccess");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FederatedAuthRequest_PreventSilentAccess_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void FederatedAuthRequestProxy::Disconnect(
    IdentityCredentialDisconnectOptionsPtr in_options, DisconnectCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::FederatedAuthRequest::Disconnect", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("options"), in_options,
                        "<value of type IdentityCredentialDisconnectOptionsPtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FederatedAuthRequest::kDisconnect), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FederatedAuthRequest_Disconnect_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->options)::BaseType> options_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::IdentityCredentialDisconnectOptionsDataView>(
    in_options,
    options_fragment);

  params->options.Set(
      options_fragment.is_null() ? nullptr : options_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->options.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null options in FederatedAuthRequest.Disconnect request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FederatedAuthRequest::Name_);
  message.set_method_name("Disconnect");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FederatedAuthRequest_Disconnect_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class FederatedAuthRequest_RequestToken_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static FederatedAuthRequest::RequestTokenCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<FederatedAuthRequest_RequestToken_ProxyToResponder> proxy(
        new FederatedAuthRequest_RequestToken_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&FederatedAuthRequest_RequestToken_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FederatedAuthRequest_RequestToken_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  FederatedAuthRequest_RequestToken_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "FederatedAuthRequest::RequestTokenCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      RequestTokenStatus in_status, const std::optional<::blink::KURL>& in_selected_identity_provider_config_url, std::optional<::base::Value> in_token, TokenErrorPtr in_error, bool in_is_auto_selected);
};

bool FederatedAuthRequest_RequestToken_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::FederatedAuthRequest_RequestToken_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FederatedAuthRequest_RequestToken_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for FederatedAuthRequest.0
  bool success = true;
  RequestTokenStatus p_status{};
  std::optional<::blink::KURL> p_selected_identity_provider_config_url{};
  std::optional<::base::Value> p_token{};
  TokenErrorPtr p_error{};
  bool p_is_auto_selected{};
  FederatedAuthRequest_RequestToken_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (success && !input_data_view.ReadSelectedIdentityProviderConfigUrl(&p_selected_identity_provider_config_url))
    success = false;
  if (success && !input_data_view.ReadToken(&p_token))
    success = false;
  if (success && !input_data_view.ReadError(&p_error))
    success = false;
  if (success)
    p_is_auto_selected = input_data_view.is_auto_selected();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FederatedAuthRequest::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_status), 
std::move(p_selected_identity_provider_config_url), 
std::move(p_token), 
std::move(p_error), 
std::move(p_is_auto_selected));
  }
  return true;
}

void FederatedAuthRequest_RequestToken_ProxyToResponder::Run(
    RequestTokenStatus in_status, const std::optional<::blink::KURL>& in_selected_identity_provider_config_url, std::optional<::base::Value> in_token, TokenErrorPtr in_error, bool in_is_auto_selected) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::FederatedAuthRequest::RequestToken", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type RequestTokenStatus>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("selected_identity_provider_config_url"), in_selected_identity_provider_config_url,
                        "<value of type const std::optional<::blink::KURL>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("token"), in_token,
                        "<value of type std::optional<::base::Value>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), in_error,
                        "<value of type TokenErrorPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_auto_selected"), in_is_auto_selected,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FederatedAuthRequest::kRequestToken), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FederatedAuthRequest_RequestToken_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::RequestTokenStatus>(
    in_status,
    &params->status);
  mojo::internal::MessageFragment<
      typename decltype(params->selected_identity_provider_config_url)::BaseType> selected_identity_provider_config_url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_selected_identity_provider_config_url,
    selected_identity_provider_config_url_fragment);

  params->selected_identity_provider_config_url.Set(
      selected_identity_provider_config_url_fragment.is_null() ? nullptr : selected_identity_provider_config_url_fragment.data());
  mojo::internal::MessageFragment<decltype(params->token)>
      token_fragment(params.message());
  token_fragment.Claim(&params->token);
  
  mojo::internal::Serialize<::mojo_base::mojom::ValueDataView>(
    in_token,
    token_fragment,
    true);
  mojo::internal::MessageFragment<
      typename decltype(params->error)::BaseType> error_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::TokenErrorDataView>(
    in_error,
    error_fragment);

  params->error.Set(
      error_fragment.is_null() ? nullptr : error_fragment.data());

  params->is_auto_selected = in_is_auto_selected;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FederatedAuthRequest::Name_);
  message.set_method_name("RequestToken");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class FederatedAuthRequest_RequestUserInfo_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static FederatedAuthRequest::RequestUserInfoCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<FederatedAuthRequest_RequestUserInfo_ProxyToResponder> proxy(
        new FederatedAuthRequest_RequestUserInfo_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&FederatedAuthRequest_RequestUserInfo_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FederatedAuthRequest_RequestUserInfo_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  FederatedAuthRequest_RequestUserInfo_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "FederatedAuthRequest::RequestUserInfoCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      RequestUserInfoStatus in_status, std::optional<::blink::Vector<IdentityUserInfoPtr>> in_user_info);
};

bool FederatedAuthRequest_RequestUserInfo_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::FederatedAuthRequest_RequestUserInfo_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FederatedAuthRequest_RequestUserInfo_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for FederatedAuthRequest.1
  bool success = true;
  RequestUserInfoStatus p_status{};
  std::optional<::blink::Vector<IdentityUserInfoPtr>> p_user_info{};
  FederatedAuthRequest_RequestUserInfo_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (success && !input_data_view.ReadUserInfo(&p_user_info))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FederatedAuthRequest::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_status), 
std::move(p_user_info));
  }
  return true;
}

void FederatedAuthRequest_RequestUserInfo_ProxyToResponder::Run(
    RequestUserInfoStatus in_status, std::optional<::blink::Vector<IdentityUserInfoPtr>> in_user_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::FederatedAuthRequest::RequestUserInfo", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type RequestUserInfoStatus>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("user_info"), in_user_info,
                        "<value of type std::optional<::blink::Vector<IdentityUserInfoPtr>>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FederatedAuthRequest::kRequestUserInfo), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FederatedAuthRequest_RequestUserInfo_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::RequestUserInfoStatus>(
    in_status,
    &params->status);
  mojo::internal::MessageFragment<
      typename decltype(params->user_info)::BaseType>
      user_info_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& user_info_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::IdentityUserInfoDataView>>(
    in_user_info,
    user_info_fragment,
    &user_info_validate_params);

  params->user_info.Set(
      user_info_fragment.is_null() ? nullptr : user_info_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FederatedAuthRequest::Name_);
  message.set_method_name("RequestUserInfo");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class FederatedAuthRequest_ResolveTokenRequest_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static FederatedAuthRequest::ResolveTokenRequestCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<FederatedAuthRequest_ResolveTokenRequest_ProxyToResponder> proxy(
        new FederatedAuthRequest_ResolveTokenRequest_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&FederatedAuthRequest_ResolveTokenRequest_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FederatedAuthRequest_ResolveTokenRequest_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  FederatedAuthRequest_ResolveTokenRequest_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "FederatedAuthRequest::ResolveTokenRequestCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success);
};

bool FederatedAuthRequest_ResolveTokenRequest_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::FederatedAuthRequest_ResolveTokenRequest_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FederatedAuthRequest_ResolveTokenRequest_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for FederatedAuthRequest.3
  bool success = true;
  bool p_success{};
  FederatedAuthRequest_ResolveTokenRequest_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FederatedAuthRequest::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_success));
  }
  return true;
}

void FederatedAuthRequest_ResolveTokenRequest_ProxyToResponder::Run(
    bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::FederatedAuthRequest::ResolveTokenRequest", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FederatedAuthRequest::kResolveTokenRequest), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FederatedAuthRequest_ResolveTokenRequest_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->success = in_success;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FederatedAuthRequest::Name_);
  message.set_method_name("ResolveTokenRequest");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class FederatedAuthRequest_SetIdpSigninStatus_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static FederatedAuthRequest::SetIdpSigninStatusCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<FederatedAuthRequest_SetIdpSigninStatus_ProxyToResponder> proxy(
        new FederatedAuthRequest_SetIdpSigninStatus_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&FederatedAuthRequest_SetIdpSigninStatus_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FederatedAuthRequest_SetIdpSigninStatus_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  FederatedAuthRequest_SetIdpSigninStatus_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "FederatedAuthRequest::SetIdpSigninStatusCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool FederatedAuthRequest_SetIdpSigninStatus_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::FederatedAuthRequest_SetIdpSigninStatus_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FederatedAuthRequest_SetIdpSigninStatus_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for FederatedAuthRequest.4
  bool success = true;
  FederatedAuthRequest_SetIdpSigninStatus_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FederatedAuthRequest::Name_, 4, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void FederatedAuthRequest_SetIdpSigninStatus_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply blink::mojom::FederatedAuthRequest::SetIdpSigninStatus");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FederatedAuthRequest::kSetIdpSigninStatus), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FederatedAuthRequest_SetIdpSigninStatus_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FederatedAuthRequest::Name_);
  message.set_method_name("SetIdpSigninStatus");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class FederatedAuthRequest_RegisterIdP_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static FederatedAuthRequest::RegisterIdPCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<FederatedAuthRequest_RegisterIdP_ProxyToResponder> proxy(
        new FederatedAuthRequest_RegisterIdP_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&FederatedAuthRequest_RegisterIdP_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FederatedAuthRequest_RegisterIdP_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  FederatedAuthRequest_RegisterIdP_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "FederatedAuthRequest::RegisterIdPCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      RegisterIdpStatus in_status);
};

bool FederatedAuthRequest_RegisterIdP_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::FederatedAuthRequest_RegisterIdP_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FederatedAuthRequest_RegisterIdP_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for FederatedAuthRequest.5
  bool success = true;
  RegisterIdpStatus p_status{};
  FederatedAuthRequest_RegisterIdP_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FederatedAuthRequest::Name_, 5, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_status));
  }
  return true;
}

void FederatedAuthRequest_RegisterIdP_ProxyToResponder::Run(
    RegisterIdpStatus in_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::FederatedAuthRequest::RegisterIdP", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type RegisterIdpStatus>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FederatedAuthRequest::kRegisterIdP), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FederatedAuthRequest_RegisterIdP_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::RegisterIdpStatus>(
    in_status,
    &params->status);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FederatedAuthRequest::Name_);
  message.set_method_name("RegisterIdP");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class FederatedAuthRequest_UnregisterIdP_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static FederatedAuthRequest::UnregisterIdPCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<FederatedAuthRequest_UnregisterIdP_ProxyToResponder> proxy(
        new FederatedAuthRequest_UnregisterIdP_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&FederatedAuthRequest_UnregisterIdP_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FederatedAuthRequest_UnregisterIdP_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  FederatedAuthRequest_UnregisterIdP_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "FederatedAuthRequest::UnregisterIdPCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success);
};

bool FederatedAuthRequest_UnregisterIdP_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::FederatedAuthRequest_UnregisterIdP_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FederatedAuthRequest_UnregisterIdP_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for FederatedAuthRequest.6
  bool success = true;
  bool p_success{};
  FederatedAuthRequest_UnregisterIdP_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FederatedAuthRequest::Name_, 6, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_success));
  }
  return true;
}

void FederatedAuthRequest_UnregisterIdP_ProxyToResponder::Run(
    bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::FederatedAuthRequest::UnregisterIdP", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FederatedAuthRequest::kUnregisterIdP), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FederatedAuthRequest_UnregisterIdP_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->success = in_success;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FederatedAuthRequest::Name_);
  message.set_method_name("UnregisterIdP");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class FederatedAuthRequest_PreventSilentAccess_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static FederatedAuthRequest::PreventSilentAccessCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<FederatedAuthRequest_PreventSilentAccess_ProxyToResponder> proxy(
        new FederatedAuthRequest_PreventSilentAccess_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&FederatedAuthRequest_PreventSilentAccess_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FederatedAuthRequest_PreventSilentAccess_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  FederatedAuthRequest_PreventSilentAccess_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "FederatedAuthRequest::PreventSilentAccessCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool FederatedAuthRequest_PreventSilentAccess_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::FederatedAuthRequest_PreventSilentAccess_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FederatedAuthRequest_PreventSilentAccess_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for FederatedAuthRequest.8
  bool success = true;
  FederatedAuthRequest_PreventSilentAccess_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FederatedAuthRequest::Name_, 8, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void FederatedAuthRequest_PreventSilentAccess_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply blink::mojom::FederatedAuthRequest::PreventSilentAccess");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FederatedAuthRequest::kPreventSilentAccess), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FederatedAuthRequest_PreventSilentAccess_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FederatedAuthRequest::Name_);
  message.set_method_name("PreventSilentAccess");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class FederatedAuthRequest_Disconnect_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static FederatedAuthRequest::DisconnectCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<FederatedAuthRequest_Disconnect_ProxyToResponder> proxy(
        new FederatedAuthRequest_Disconnect_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&FederatedAuthRequest_Disconnect_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FederatedAuthRequest_Disconnect_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  FederatedAuthRequest_Disconnect_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "FederatedAuthRequest::DisconnectCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      DisconnectStatus in_status);
};

bool FederatedAuthRequest_Disconnect_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::FederatedAuthRequest_Disconnect_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FederatedAuthRequest_Disconnect_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for FederatedAuthRequest.9
  bool success = true;
  DisconnectStatus p_status{};
  FederatedAuthRequest_Disconnect_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FederatedAuthRequest::Name_, 9, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_status));
  }
  return true;
}

void FederatedAuthRequest_Disconnect_ProxyToResponder::Run(
    DisconnectStatus in_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::FederatedAuthRequest::Disconnect", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type DisconnectStatus>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FederatedAuthRequest::kDisconnect), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FederatedAuthRequest_Disconnect_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::DisconnectStatus>(
    in_status,
    &params->status);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FederatedAuthRequest::Name_);
  message.set_method_name("Disconnect");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool FederatedAuthRequestStubDispatch::Accept(
    FederatedAuthRequest* impl,
    mojo::Message* message) {
  switch (static_cast<messages::FederatedAuthRequest>(message->header()->name)) {
    case messages::FederatedAuthRequest::kRequestToken: {
      break;
    }
    case messages::FederatedAuthRequest::kRequestUserInfo: {
      break;
    }
    case messages::FederatedAuthRequest::kCancelTokenRequest: {
      DCHECK(message->is_serialized());
      internal::FederatedAuthRequest_CancelTokenRequest_Params_Data* params =
          reinterpret_cast<internal::FederatedAuthRequest_CancelTokenRequest_Params_Data*>(
              message->mutable_payload());
      

      // Validation for FederatedAuthRequest.2
      bool success = true;
      FederatedAuthRequest_CancelTokenRequest_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FederatedAuthRequest::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CancelTokenRequest(        );
      return true;
    }
    case messages::FederatedAuthRequest::kResolveTokenRequest: {
      break;
    }
    case messages::FederatedAuthRequest::kSetIdpSigninStatus: {
      break;
    }
    case messages::FederatedAuthRequest::kRegisterIdP: {
      break;
    }
    case messages::FederatedAuthRequest::kUnregisterIdP: {
      break;
    }
    case messages::FederatedAuthRequest::kCloseModalDialogView: {
      DCHECK(message->is_serialized());
      internal::FederatedAuthRequest_CloseModalDialogView_Params_Data* params =
          reinterpret_cast<internal::FederatedAuthRequest_CloseModalDialogView_Params_Data*>(
              message->mutable_payload());
      

      // Validation for FederatedAuthRequest.7
      bool success = true;
      FederatedAuthRequest_CloseModalDialogView_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FederatedAuthRequest::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CloseModalDialogView(        );
      return true;
    }
    case messages::FederatedAuthRequest::kPreventSilentAccess: {
      break;
    }
    case messages::FederatedAuthRequest::kDisconnect: {
      break;
    }
  }
  return false;
}

// static
bool FederatedAuthRequestStubDispatch::AcceptWithResponder(
    FederatedAuthRequest* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::FederatedAuthRequest>(message->header()->name)) {
    case messages::FederatedAuthRequest::kRequestToken: {
      internal::FederatedAuthRequest_RequestToken_Params_Data* params =
          reinterpret_cast<
              internal::FederatedAuthRequest_RequestToken_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for FederatedAuthRequest.0
      bool success = true;
      ::blink::Vector<IdentityProviderGetParametersPtr> p_idp_get_params{};
      ::blink::mojom::blink::CredentialMediationRequirement p_requirement{};
      FederatedAuthRequest_RequestToken_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadIdpGetParams(&p_idp_get_params))
        success = false;
      if (success && !input_data_view.ReadRequirement(&p_requirement))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FederatedAuthRequest::Name_, 0, false);
        return false;
      }
      auto callback =
          FederatedAuthRequest_RequestToken_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RequestToken(        
        std::move(p_idp_get_params), 
        std::move(p_requirement), std::move(callback));
      return true;
    }
    case messages::FederatedAuthRequest::kRequestUserInfo: {
      internal::FederatedAuthRequest_RequestUserInfo_Params_Data* params =
          reinterpret_cast<
              internal::FederatedAuthRequest_RequestUserInfo_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for FederatedAuthRequest.1
      bool success = true;
      IdentityProviderConfigPtr p_provider{};
      FederatedAuthRequest_RequestUserInfo_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadProvider(&p_provider))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FederatedAuthRequest::Name_, 1, false);
        return false;
      }
      auto callback =
          FederatedAuthRequest_RequestUserInfo_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RequestUserInfo(        
        std::move(p_provider), std::move(callback));
      return true;
    }
    case messages::FederatedAuthRequest::kCancelTokenRequest: {
      break;
    }
    case messages::FederatedAuthRequest::kResolveTokenRequest: {
      internal::FederatedAuthRequest_ResolveTokenRequest_Params_Data* params =
          reinterpret_cast<
              internal::FederatedAuthRequest_ResolveTokenRequest_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for FederatedAuthRequest.3
      bool success = true;
      ::blink::String p_account_id{};
      ::base::Value p_token{};
      FederatedAuthRequest_ResolveTokenRequest_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadAccountId(&p_account_id))
        success = false;
      if (success && !input_data_view.ReadToken(&p_token))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FederatedAuthRequest::Name_, 3, false);
        return false;
      }
      auto callback =
          FederatedAuthRequest_ResolveTokenRequest_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ResolveTokenRequest(        
        std::move(p_account_id), 
        std::move(p_token), std::move(callback));
      return true;
    }
    case messages::FederatedAuthRequest::kSetIdpSigninStatus: {
      internal::FederatedAuthRequest_SetIdpSigninStatus_Params_Data* params =
          reinterpret_cast<
              internal::FederatedAuthRequest_SetIdpSigninStatus_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for FederatedAuthRequest.4
      bool success = true;
      ::scoped_refptr<const ::blink::SecurityOrigin> p_origin{};
      IdpSigninStatus p_status{};
      LoginStatusOptionsPtr p_options{};
      FederatedAuthRequest_SetIdpSigninStatus_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadOrigin(&p_origin))
        success = false;
      if (success && !input_data_view.ReadStatus(&p_status))
        success = false;
      if (success && !input_data_view.ReadOptions(&p_options))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FederatedAuthRequest::Name_, 4, false);
        return false;
      }
      auto callback =
          FederatedAuthRequest_SetIdpSigninStatus_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetIdpSigninStatus(        
        std::move(p_origin), 
        std::move(p_status), 
        std::move(p_options), std::move(callback));
      return true;
    }
    case messages::FederatedAuthRequest::kRegisterIdP: {
      internal::FederatedAuthRequest_RegisterIdP_Params_Data* params =
          reinterpret_cast<
              internal::FederatedAuthRequest_RegisterIdP_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for FederatedAuthRequest.5
      bool success = true;
      ::blink::KURL p_url{};
      FederatedAuthRequest_RegisterIdP_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FederatedAuthRequest::Name_, 5, false);
        return false;
      }
      auto callback =
          FederatedAuthRequest_RegisterIdP_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RegisterIdP(        
        std::move(p_url), std::move(callback));
      return true;
    }
    case messages::FederatedAuthRequest::kUnregisterIdP: {
      internal::FederatedAuthRequest_UnregisterIdP_Params_Data* params =
          reinterpret_cast<
              internal::FederatedAuthRequest_UnregisterIdP_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for FederatedAuthRequest.6
      bool success = true;
      ::blink::KURL p_url{};
      FederatedAuthRequest_UnregisterIdP_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FederatedAuthRequest::Name_, 6, false);
        return false;
      }
      auto callback =
          FederatedAuthRequest_UnregisterIdP_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UnregisterIdP(        
        std::move(p_url), std::move(callback));
      return true;
    }
    case messages::FederatedAuthRequest::kCloseModalDialogView: {
      break;
    }
    case messages::FederatedAuthRequest::kPreventSilentAccess: {
      internal::FederatedAuthRequest_PreventSilentAccess_Params_Data* params =
          reinterpret_cast<
              internal::FederatedAuthRequest_PreventSilentAccess_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for FederatedAuthRequest.8
      bool success = true;
      FederatedAuthRequest_PreventSilentAccess_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FederatedAuthRequest::Name_, 8, false);
        return false;
      }
      auto callback =
          FederatedAuthRequest_PreventSilentAccess_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->PreventSilentAccess(std::move(callback));
      return true;
    }
    case messages::FederatedAuthRequest::kDisconnect: {
      internal::FederatedAuthRequest_Disconnect_Params_Data* params =
          reinterpret_cast<
              internal::FederatedAuthRequest_Disconnect_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for FederatedAuthRequest.9
      bool success = true;
      IdentityCredentialDisconnectOptionsPtr p_options{};
      FederatedAuthRequest_Disconnect_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadOptions(&p_options))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FederatedAuthRequest::Name_, 9, false);
        return false;
      }
      auto callback =
          FederatedAuthRequest_Disconnect_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Disconnect(        
        std::move(p_options), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kFederatedAuthRequestValidationInfo[] = {
    { &internal::FederatedAuthRequest_RequestToken_Params_Data::Validate,
     &internal::FederatedAuthRequest_RequestToken_ResponseParams_Data::Validate},
    { &internal::FederatedAuthRequest_RequestUserInfo_Params_Data::Validate,
     &internal::FederatedAuthRequest_RequestUserInfo_ResponseParams_Data::Validate},
    { &internal::FederatedAuthRequest_CancelTokenRequest_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::FederatedAuthRequest_ResolveTokenRequest_Params_Data::Validate,
     &internal::FederatedAuthRequest_ResolveTokenRequest_ResponseParams_Data::Validate},
    { &internal::FederatedAuthRequest_SetIdpSigninStatus_Params_Data::Validate,
     &internal::FederatedAuthRequest_SetIdpSigninStatus_ResponseParams_Data::Validate},
    { &internal::FederatedAuthRequest_RegisterIdP_Params_Data::Validate,
     &internal::FederatedAuthRequest_RegisterIdP_ResponseParams_Data::Validate},
    { &internal::FederatedAuthRequest_UnregisterIdP_Params_Data::Validate,
     &internal::FederatedAuthRequest_UnregisterIdP_ResponseParams_Data::Validate},
    { &internal::FederatedAuthRequest_CloseModalDialogView_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::FederatedAuthRequest_PreventSilentAccess_Params_Data::Validate,
     &internal::FederatedAuthRequest_PreventSilentAccess_ResponseParams_Data::Validate},
    { &internal::FederatedAuthRequest_Disconnect_Params_Data::Validate,
     &internal::FederatedAuthRequest_Disconnect_ResponseParams_Data::Validate},
};

bool FederatedAuthRequestRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::blink::FederatedAuthRequest::Name_,
    kFederatedAuthRequestValidationInfo);
}

bool FederatedAuthRequestResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::blink::mojom::blink::FederatedAuthRequest::Name_,
    kFederatedAuthRequestValidationInfo);
}


}  // blink::mojom::blink


namespace mojo {


// static
bool StructTraits<::blink::mojom::blink::IdentityProviderConfig::DataView, ::blink::mojom::blink::IdentityProviderConfigPtr>::Read(
    ::blink::mojom::blink::IdentityProviderConfig::DataView input,
    ::blink::mojom::blink::IdentityProviderConfigPtr* output) {
  bool success = true;
  ::blink::mojom::blink::IdentityProviderConfigPtr result(::blink::mojom::blink::IdentityProviderConfig::New());
  
      if (success && !input.ReadConfigUrl(&result->config_url))
        success = false;
      if (success)
        result->from_idp_registration_api = input.from_idp_registration_api();
      if (success && !input.ReadType(&result->type))
        success = false;
      if (success && !input.ReadClientId(&result->client_id))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::IdentityProviderRequestOptions::DataView, ::blink::mojom::blink::IdentityProviderRequestOptionsPtr>::Read(
    ::blink::mojom::blink::IdentityProviderRequestOptions::DataView input,
    ::blink::mojom::blink::IdentityProviderRequestOptionsPtr* output) {
  bool success = true;
  ::blink::mojom::blink::IdentityProviderRequestOptionsPtr result(::blink::mojom::blink::IdentityProviderRequestOptions::New());
  
      if (success && !input.ReadConfig(&result->config))
        success = false;
      if (success && !input.ReadNonce(&result->nonce))
        success = false;
      if (success && !input.ReadLoginHint(&result->login_hint))
        success = false;
      if (success && !input.ReadDomainHint(&result->domain_hint))
        success = false;
      if (success && !input.ReadFields(&result->fields))
        success = false;
      if (success && !input.ReadParamsJson(&result->params_json))
        success = false;
      if (success && !input.ReadFormat(&result->format)) {
        success = false;
      }
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::IdentityCredentialDisconnectOptions::DataView, ::blink::mojom::blink::IdentityCredentialDisconnectOptionsPtr>::Read(
    ::blink::mojom::blink::IdentityCredentialDisconnectOptions::DataView input,
    ::blink::mojom::blink::IdentityCredentialDisconnectOptionsPtr* output) {
  bool success = true;
  ::blink::mojom::blink::IdentityCredentialDisconnectOptionsPtr result(::blink::mojom::blink::IdentityCredentialDisconnectOptions::New());
  
      if (success && !input.ReadConfig(&result->config))
        success = false;
      if (success && !input.ReadAccountHint(&result->account_hint))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::IdentityUserInfo::DataView, ::blink::mojom::blink::IdentityUserInfoPtr>::Read(
    ::blink::mojom::blink::IdentityUserInfo::DataView input,
    ::blink::mojom::blink::IdentityUserInfoPtr* output) {
  bool success = true;
  ::blink::mojom::blink::IdentityUserInfoPtr result(::blink::mojom::blink::IdentityUserInfo::New());
  
      if (success && !input.ReadEmail(&result->email))
        success = false;
      if (success && !input.ReadGivenName(&result->given_name))
        success = false;
      if (success && !input.ReadName(&result->name))
        success = false;
      if (success && !input.ReadPicture(&result->picture))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::LoginStatusAccount::DataView, ::blink::mojom::blink::LoginStatusAccountPtr>::Read(
    ::blink::mojom::blink::LoginStatusAccount::DataView input,
    ::blink::mojom::blink::LoginStatusAccountPtr* output) {
  bool success = true;
  ::blink::mojom::blink::LoginStatusAccountPtr result(::blink::mojom::blink::LoginStatusAccount::New());
  
      if (success && !input.ReadId(&result->id))
        success = false;
      if (success && !input.ReadEmail(&result->email))
        success = false;
      if (success && !input.ReadName(&result->name))
        success = false;
      if (success && !input.ReadGivenName(&result->given_name))
        success = false;
      if (success && !input.ReadPicture(&result->picture))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::LoginStatusOptions::DataView, ::blink::mojom::blink::LoginStatusOptionsPtr>::Read(
    ::blink::mojom::blink::LoginStatusOptions::DataView input,
    ::blink::mojom::blink::LoginStatusOptionsPtr* output) {
  bool success = true;
  ::blink::mojom::blink::LoginStatusOptionsPtr result(::blink::mojom::blink::LoginStatusOptions::New());
  
      if (success && !input.ReadAccounts(&result->accounts))
        success = false;
      if (success && !input.ReadExpiration(&result->expiration))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::IdentityProviderGetParameters::DataView, ::blink::mojom::blink::IdentityProviderGetParametersPtr>::Read(
    ::blink::mojom::blink::IdentityProviderGetParameters::DataView input,
    ::blink::mojom::blink::IdentityProviderGetParametersPtr* output) {
  bool success = true;
  ::blink::mojom::blink::IdentityProviderGetParametersPtr result(::blink::mojom::blink::IdentityProviderGetParameters::New());
  
      if (success && !input.ReadProviders(&result->providers))
        success = false;
      if (success && !input.ReadContext(&result->context))
        success = false;
      if (success && !input.ReadMode(&result->mode))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::TokenError::DataView, ::blink::mojom::blink::TokenErrorPtr>::Read(
    ::blink::mojom::blink::TokenError::DataView input,
    ::blink::mojom::blink::TokenErrorPtr* output) {
  bool success = true;
  ::blink::mojom::blink::TokenErrorPtr result(::blink::mojom::blink::TokenError::New());
  
      if (success && !input.ReadCode(&result->code))
        success = false;
      if (success && !input.ReadUrl(&result->url))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace blink::mojom::blink {


void FederatedAuthRequestInterceptorForTesting::RequestToken(::blink::Vector<IdentityProviderGetParametersPtr> idp_get_params, ::blink::mojom::blink::CredentialMediationRequirement requirement, RequestTokenCallback callback) {
  GetForwardingInterface()->RequestToken(
    std::move(idp_get_params)
    , 
    std::move(requirement)
    , std::move(callback));
}
void FederatedAuthRequestInterceptorForTesting::RequestUserInfo(IdentityProviderConfigPtr provider, RequestUserInfoCallback callback) {
  GetForwardingInterface()->RequestUserInfo(
    std::move(provider)
    , std::move(callback));
}
void FederatedAuthRequestInterceptorForTesting::CancelTokenRequest() {
  GetForwardingInterface()->CancelTokenRequest();
}
void FederatedAuthRequestInterceptorForTesting::ResolveTokenRequest(const ::blink::String& account_id, ::base::Value token, ResolveTokenRequestCallback callback) {
  GetForwardingInterface()->ResolveTokenRequest(
    std::move(account_id)
    , 
    std::move(token)
    , std::move(callback));
}
void FederatedAuthRequestInterceptorForTesting::SetIdpSigninStatus(const ::scoped_refptr<const ::blink::SecurityOrigin>& origin, IdpSigninStatus status, LoginStatusOptionsPtr options, SetIdpSigninStatusCallback callback) {
  GetForwardingInterface()->SetIdpSigninStatus(
    std::move(origin)
    , 
    std::move(status)
    , 
    std::move(options)
    , std::move(callback));
}
void FederatedAuthRequestInterceptorForTesting::RegisterIdP(const ::blink::KURL& url, RegisterIdPCallback callback) {
  GetForwardingInterface()->RegisterIdP(
    std::move(url)
    , std::move(callback));
}
void FederatedAuthRequestInterceptorForTesting::UnregisterIdP(const ::blink::KURL& url, UnregisterIdPCallback callback) {
  GetForwardingInterface()->UnregisterIdP(
    std::move(url)
    , std::move(callback));
}
void FederatedAuthRequestInterceptorForTesting::CloseModalDialogView() {
  GetForwardingInterface()->CloseModalDialogView();
}
void FederatedAuthRequestInterceptorForTesting::PreventSilentAccess(PreventSilentAccessCallback callback) {
  GetForwardingInterface()->PreventSilentAccess(std::move(callback));
}
void FederatedAuthRequestInterceptorForTesting::Disconnect(IdentityCredentialDisconnectOptionsPtr options, DisconnectCallback callback) {
  GetForwardingInterface()->Disconnect(
    std::move(options)
    , std::move(callback));
}
FederatedAuthRequestAsyncWaiter::FederatedAuthRequestAsyncWaiter(
    FederatedAuthRequest* proxy) : proxy_(proxy) {}

FederatedAuthRequestAsyncWaiter::~FederatedAuthRequestAsyncWaiter() = default;


void FederatedAuthRequestAsyncWaiter::RequestToken(
    ::blink::Vector<IdentityProviderGetParametersPtr> idp_get_params, ::blink::mojom::blink::CredentialMediationRequirement requirement, RequestTokenStatus* out_status, std::optional<::blink::KURL>* out_selected_identity_provider_config_url, std::optional<::base::Value>* out_token, TokenErrorPtr* out_error, bool* out_is_auto_selected) {
  base::RunLoop loop;
  proxy_->RequestToken(
      std::move(idp_get_params),
      std::move(requirement),
      base::BindOnce(
          [](base::RunLoop* loop,
             RequestTokenStatus* out_status
,
             std::optional<::blink::KURL>* out_selected_identity_provider_config_url
,
             std::optional<::base::Value>* out_token
,
             TokenErrorPtr* out_error
,
             bool* out_is_auto_selected
,
             RequestTokenStatus status,
             const std::optional<::blink::KURL>& selected_identity_provider_config_url,
             std::optional<::base::Value> token,
             TokenErrorPtr error,
             bool is_auto_selected) {*out_status = std::move(status);*out_selected_identity_provider_config_url = std::move(selected_identity_provider_config_url);*out_token = std::move(token);*out_error = std::move(error);*out_is_auto_selected = std::move(is_auto_selected);
            loop->Quit();
          },
          &loop,
          out_status,
          out_selected_identity_provider_config_url,
          out_token,
          out_error,
          out_is_auto_selected));
  loop.Run();
}



void FederatedAuthRequestAsyncWaiter::RequestUserInfo(
    IdentityProviderConfigPtr provider, RequestUserInfoStatus* out_status, std::optional<::blink::Vector<IdentityUserInfoPtr>>* out_user_info) {
  base::RunLoop loop;
  proxy_->RequestUserInfo(
      std::move(provider),
      base::BindOnce(
          [](base::RunLoop* loop,
             RequestUserInfoStatus* out_status
,
             std::optional<::blink::Vector<IdentityUserInfoPtr>>* out_user_info
,
             RequestUserInfoStatus status,
             std::optional<::blink::Vector<IdentityUserInfoPtr>> user_info) {*out_status = std::move(status);*out_user_info = std::move(user_info);
            loop->Quit();
          },
          &loop,
          out_status,
          out_user_info));
  loop.Run();
}



void FederatedAuthRequestAsyncWaiter::ResolveTokenRequest(
    const ::blink::String& account_id, ::base::Value token, bool* out_success) {
  base::RunLoop loop;
  proxy_->ResolveTokenRequest(
      std::move(account_id),
      std::move(token),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             bool success) {*out_success = std::move(success);
            loop->Quit();
          },
          &loop,
          out_success));
  loop.Run();
}

bool FederatedAuthRequestAsyncWaiter::ResolveTokenRequest(
    const ::blink::String& account_id, ::base::Value token) {
  bool async_wait_result;
  ResolveTokenRequest(std::move(account_id),std::move(token),&async_wait_result);
  return async_wait_result;
}

void FederatedAuthRequestAsyncWaiter::SetIdpSigninStatus(
    const ::scoped_refptr<const ::blink::SecurityOrigin>& origin, IdpSigninStatus status, LoginStatusOptionsPtr options) {
  base::RunLoop loop;
  proxy_->SetIdpSigninStatus(
      std::move(origin),
      std::move(status),
      std::move(options),
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}



void FederatedAuthRequestAsyncWaiter::RegisterIdP(
    const ::blink::KURL& url, RegisterIdpStatus* out_status) {
  base::RunLoop loop;
  proxy_->RegisterIdP(
      std::move(url),
      base::BindOnce(
          [](base::RunLoop* loop,
             RegisterIdpStatus* out_status
,
             RegisterIdpStatus status) {*out_status = std::move(status);
            loop->Quit();
          },
          &loop,
          out_status));
  loop.Run();
}

RegisterIdpStatus FederatedAuthRequestAsyncWaiter::RegisterIdP(
    const ::blink::KURL& url) {
  RegisterIdpStatus async_wait_result;
  RegisterIdP(std::move(url),&async_wait_result);
  return async_wait_result;
}

void FederatedAuthRequestAsyncWaiter::UnregisterIdP(
    const ::blink::KURL& url, bool* out_success) {
  base::RunLoop loop;
  proxy_->UnregisterIdP(
      std::move(url),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             bool success) {*out_success = std::move(success);
            loop->Quit();
          },
          &loop,
          out_success));
  loop.Run();
}

bool FederatedAuthRequestAsyncWaiter::UnregisterIdP(
    const ::blink::KURL& url) {
  bool async_wait_result;
  UnregisterIdP(std::move(url),&async_wait_result);
  return async_wait_result;
}

void FederatedAuthRequestAsyncWaiter::PreventSilentAccess(
    ) {
  base::RunLoop loop;
  proxy_->PreventSilentAccess(
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}



void FederatedAuthRequestAsyncWaiter::Disconnect(
    IdentityCredentialDisconnectOptionsPtr options, DisconnectStatus* out_status) {
  base::RunLoop loop;
  proxy_->Disconnect(
      std::move(options),
      base::BindOnce(
          [](base::RunLoop* loop,
             DisconnectStatus* out_status
,
             DisconnectStatus status) {*out_status = std::move(status);
            loop->Quit();
          },
          &loop,
          out_status));
  loop.Run();
}

DisconnectStatus FederatedAuthRequestAsyncWaiter::Disconnect(
    IdentityCredentialDisconnectOptionsPtr options) {
  DisconnectStatus async_wait_result;
  Disconnect(std::move(options),&async_wait_result);
  return async_wait_result;
}






}  // blink::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif