// third_party/blink/public/mojom/webid/digital_identity_request.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'third_party/blink/public/mojom/webid/digital_identity_request.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('blink.mojom');
  var values$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/values.mojom', '../../../../../mojo/public/mojom/base/values.mojom.js');
  }


  var RequestDigitalIdentityStatus = {};
  RequestDigitalIdentityStatus.kSuccess = 0;
  RequestDigitalIdentityStatus.kError = 1;
  RequestDigitalIdentityStatus.kErrorTooManyRequests = 2;
  RequestDigitalIdentityStatus.kErrorCanceled = 3;
  RequestDigitalIdentityStatus.kErrorNoRequests = 4;
  RequestDigitalIdentityStatus.kErrorNoTransientUserActivation = 5;
  RequestDigitalIdentityStatus.kErrorInvalidJson = 6;
  RequestDigitalIdentityStatus.MIN_VALUE = 0;
  RequestDigitalIdentityStatus.MAX_VALUE = 6;

  RequestDigitalIdentityStatus.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
    case 6:
      return true;
    }
    return false;
  };

  RequestDigitalIdentityStatus.toKnownEnumValue = function(value) {
    return value;
  };

  RequestDigitalIdentityStatus.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  function DigitalCredentialGetRequest(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  DigitalCredentialGetRequest.prototype.initDefaults_ = function() {
    this.protocol = null;
    this.data = null;
  };
  DigitalCredentialGetRequest.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  DigitalCredentialGetRequest.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DigitalCredentialGetRequest.protocol
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate DigitalCredentialGetRequest.data
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 8, values$.Value, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  DigitalCredentialGetRequest.encodedSize = codec.kStructHeaderSize + 24;

  DigitalCredentialGetRequest.decode = function(decoder) {
    var packed;
    var val = new DigitalCredentialGetRequest();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.protocol =
        decoder.decodeStruct(codec.String);
    val.data =
        decoder.decodeStruct(values$.Value);
    return val;
  };

  DigitalCredentialGetRequest.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(DigitalCredentialGetRequest.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.protocol);
    encoder.encodeStruct(values$.Value, val.data);
  };
  function DigitalCredentialCreateRequest(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  DigitalCredentialCreateRequest.prototype.initDefaults_ = function() {
    this.protocol = null;
    this.data = null;
  };
  DigitalCredentialCreateRequest.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  DigitalCredentialCreateRequest.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DigitalCredentialCreateRequest.protocol
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate DigitalCredentialCreateRequest.data
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 8, values$.Value, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  DigitalCredentialCreateRequest.encodedSize = codec.kStructHeaderSize + 24;

  DigitalCredentialCreateRequest.decode = function(decoder) {
    var packed;
    var val = new DigitalCredentialCreateRequest();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.protocol =
        decoder.decodeStruct(codec.String);
    val.data =
        decoder.decodeStruct(values$.Value);
    return val;
  };

  DigitalCredentialCreateRequest.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(DigitalCredentialCreateRequest.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.protocol);
    encoder.encodeStruct(values$.Value, val.data);
  };
  function DigitalIdentityRequest_Get_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  DigitalIdentityRequest_Get_Params.prototype.initDefaults_ = function() {
    this.digitalCredentialRequests = null;
  };
  DigitalIdentityRequest_Get_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  DigitalIdentityRequest_Get_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DigitalIdentityRequest_Get_Params.digitalCredentialRequests
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, new codec.PointerTo(DigitalCredentialGetRequest), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  DigitalIdentityRequest_Get_Params.encodedSize = codec.kStructHeaderSize + 8;

  DigitalIdentityRequest_Get_Params.decode = function(decoder) {
    var packed;
    var val = new DigitalIdentityRequest_Get_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.digitalCredentialRequests =
        decoder.decodeArrayPointer(new codec.PointerTo(DigitalCredentialGetRequest));
    return val;
  };

  DigitalIdentityRequest_Get_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(DigitalIdentityRequest_Get_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(new codec.PointerTo(DigitalCredentialGetRequest), val.digitalCredentialRequests);
  };
  function DigitalIdentityRequest_Get_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  DigitalIdentityRequest_Get_ResponseParams.prototype.initDefaults_ = function() {
    this.status = 0;
    this.protocol = null;
    this.token = null;
  };
  DigitalIdentityRequest_Get_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  DigitalIdentityRequest_Get_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 40}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DigitalIdentityRequest_Get_ResponseParams.status
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, RequestDigitalIdentityStatus);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DigitalIdentityRequest_Get_ResponseParams.protocol
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, true)
    if (err !== validator.validationError.NONE)
        return err;


    // validate DigitalIdentityRequest_Get_ResponseParams.token
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 16, values$.Value, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  DigitalIdentityRequest_Get_ResponseParams.encodedSize = codec.kStructHeaderSize + 32;

  DigitalIdentityRequest_Get_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new DigitalIdentityRequest_Get_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.status =
        decoder.decodeStruct(new codec.Enum(RequestDigitalIdentityStatus));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.protocol =
        decoder.decodeStruct(codec.String);
    val.token =
        decoder.decodeStruct(values$.Value);
    return val;
  };

  DigitalIdentityRequest_Get_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(DigitalIdentityRequest_Get_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.status);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.String, val.protocol);
    encoder.encodeStruct(values$.Value, val.token);
  };
  function DigitalIdentityRequest_Create_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  DigitalIdentityRequest_Create_Params.prototype.initDefaults_ = function() {
    this.digitalCredentialRequests = null;
  };
  DigitalIdentityRequest_Create_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  DigitalIdentityRequest_Create_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DigitalIdentityRequest_Create_Params.digitalCredentialRequests
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, new codec.PointerTo(DigitalCredentialCreateRequest), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  DigitalIdentityRequest_Create_Params.encodedSize = codec.kStructHeaderSize + 8;

  DigitalIdentityRequest_Create_Params.decode = function(decoder) {
    var packed;
    var val = new DigitalIdentityRequest_Create_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.digitalCredentialRequests =
        decoder.decodeArrayPointer(new codec.PointerTo(DigitalCredentialCreateRequest));
    return val;
  };

  DigitalIdentityRequest_Create_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(DigitalIdentityRequest_Create_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(new codec.PointerTo(DigitalCredentialCreateRequest), val.digitalCredentialRequests);
  };
  function DigitalIdentityRequest_Create_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  DigitalIdentityRequest_Create_ResponseParams.prototype.initDefaults_ = function() {
    this.status = 0;
    this.protocol = null;
    this.token = null;
  };
  DigitalIdentityRequest_Create_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  DigitalIdentityRequest_Create_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 40}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DigitalIdentityRequest_Create_ResponseParams.status
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, RequestDigitalIdentityStatus);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DigitalIdentityRequest_Create_ResponseParams.protocol
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, true)
    if (err !== validator.validationError.NONE)
        return err;


    // validate DigitalIdentityRequest_Create_ResponseParams.token
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 16, values$.Value, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  DigitalIdentityRequest_Create_ResponseParams.encodedSize = codec.kStructHeaderSize + 32;

  DigitalIdentityRequest_Create_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new DigitalIdentityRequest_Create_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.status =
        decoder.decodeStruct(new codec.Enum(RequestDigitalIdentityStatus));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.protocol =
        decoder.decodeStruct(codec.String);
    val.token =
        decoder.decodeStruct(values$.Value);
    return val;
  };

  DigitalIdentityRequest_Create_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(DigitalIdentityRequest_Create_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.status);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.String, val.protocol);
    encoder.encodeStruct(values$.Value, val.token);
  };
  function DigitalIdentityRequest_Abort_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  DigitalIdentityRequest_Abort_Params.prototype.initDefaults_ = function() {
  };
  DigitalIdentityRequest_Abort_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  DigitalIdentityRequest_Abort_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  DigitalIdentityRequest_Abort_Params.encodedSize = codec.kStructHeaderSize + 0;

  DigitalIdentityRequest_Abort_Params.decode = function(decoder) {
    var packed;
    var val = new DigitalIdentityRequest_Abort_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  DigitalIdentityRequest_Abort_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(DigitalIdentityRequest_Abort_Params.encodedSize);
    encoder.writeUint32(0);
  };
  var kDigitalIdentityRequest_Get_Name = 0;
  var kDigitalIdentityRequest_Create_Name = 1;
  var kDigitalIdentityRequest_Abort_Name = 2;

  function DigitalIdentityRequestPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(DigitalIdentityRequest,
                                                   handleOrPtrInfo);
  }

  function DigitalIdentityRequestAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        DigitalIdentityRequest, associatedInterfacePtrInfo);
  }

  DigitalIdentityRequestAssociatedPtr.prototype =
      Object.create(DigitalIdentityRequestPtr.prototype);
  DigitalIdentityRequestAssociatedPtr.prototype.constructor =
      DigitalIdentityRequestAssociatedPtr;

  function DigitalIdentityRequestProxy(receiver) {
    this.receiver_ = receiver;
  }
  DigitalIdentityRequestPtr.prototype.get = function() {
    return DigitalIdentityRequestProxy.prototype.get
        .apply(this.ptr.getProxy(), arguments);
  };

  DigitalIdentityRequestProxy.prototype.get = function(digitalCredentialRequests) {
    var params_ = new DigitalIdentityRequest_Get_Params();
    params_.digitalCredentialRequests = digitalCredentialRequests;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kDigitalIdentityRequest_Get_Name,
          codec.align(DigitalIdentityRequest_Get_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(DigitalIdentityRequest_Get_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(DigitalIdentityRequest_Get_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  DigitalIdentityRequestPtr.prototype.create = function() {
    return DigitalIdentityRequestProxy.prototype.create
        .apply(this.ptr.getProxy(), arguments);
  };

  DigitalIdentityRequestProxy.prototype.create = function(digitalCredentialRequests) {
    var params_ = new DigitalIdentityRequest_Create_Params();
    params_.digitalCredentialRequests = digitalCredentialRequests;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kDigitalIdentityRequest_Create_Name,
          codec.align(DigitalIdentityRequest_Create_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(DigitalIdentityRequest_Create_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(DigitalIdentityRequest_Create_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  DigitalIdentityRequestPtr.prototype.abort = function() {
    return DigitalIdentityRequestProxy.prototype.abort
        .apply(this.ptr.getProxy(), arguments);
  };

  DigitalIdentityRequestProxy.prototype.abort = function() {
    var params_ = new DigitalIdentityRequest_Abort_Params();
    var builder = new codec.MessageV0Builder(
        kDigitalIdentityRequest_Abort_Name,
        codec.align(DigitalIdentityRequest_Abort_Params.encodedSize));
    builder.encodeStruct(DigitalIdentityRequest_Abort_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function DigitalIdentityRequestStub(delegate) {
    this.delegate_ = delegate;
  }
  DigitalIdentityRequestStub.prototype.get = function(digitalCredentialRequests) {
    return this.delegate_ && this.delegate_.get && this.delegate_.get(digitalCredentialRequests);
  }
  DigitalIdentityRequestStub.prototype.create = function(digitalCredentialRequests) {
    return this.delegate_ && this.delegate_.create && this.delegate_.create(digitalCredentialRequests);
  }
  DigitalIdentityRequestStub.prototype.abort = function() {
    return this.delegate_ && this.delegate_.abort && this.delegate_.abort();
  }

  DigitalIdentityRequestStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kDigitalIdentityRequest_Abort_Name:
      var params = reader.decodeStruct(DigitalIdentityRequest_Abort_Params);
      this.abort();
      return true;
    default:
      return false;
    }
  };

  DigitalIdentityRequestStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kDigitalIdentityRequest_Get_Name:
      var params = reader.decodeStruct(DigitalIdentityRequest_Get_Params);
      this.get(params.digitalCredentialRequests).then(function(response) {
        var responseParams =
            new DigitalIdentityRequest_Get_ResponseParams();
        responseParams.status = response.status;
        responseParams.protocol = response.protocol;
        responseParams.token = response.token;
        var builder = new codec.MessageV1Builder(
            kDigitalIdentityRequest_Get_Name,
            codec.align(DigitalIdentityRequest_Get_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(DigitalIdentityRequest_Get_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kDigitalIdentityRequest_Create_Name:
      var params = reader.decodeStruct(DigitalIdentityRequest_Create_Params);
      this.create(params.digitalCredentialRequests).then(function(response) {
        var responseParams =
            new DigitalIdentityRequest_Create_ResponseParams();
        responseParams.status = response.status;
        responseParams.protocol = response.protocol;
        responseParams.token = response.token;
        var builder = new codec.MessageV1Builder(
            kDigitalIdentityRequest_Create_Name,
            codec.align(DigitalIdentityRequest_Create_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(DigitalIdentityRequest_Create_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateDigitalIdentityRequestRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kDigitalIdentityRequest_Get_Name:
        if (message.expectsResponse())
          paramsClass = DigitalIdentityRequest_Get_Params;
      break;
      case kDigitalIdentityRequest_Create_Name:
        if (message.expectsResponse())
          paramsClass = DigitalIdentityRequest_Create_Params;
      break;
      case kDigitalIdentityRequest_Abort_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = DigitalIdentityRequest_Abort_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateDigitalIdentityRequestResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kDigitalIdentityRequest_Get_Name:
        if (message.isResponse())
          paramsClass = DigitalIdentityRequest_Get_ResponseParams;
        break;
      case kDigitalIdentityRequest_Create_Name:
        if (message.isResponse())
          paramsClass = DigitalIdentityRequest_Create_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var DigitalIdentityRequest = {
    name: 'blink.mojom.DigitalIdentityRequest',
    kVersion: 0,
    ptrClass: DigitalIdentityRequestPtr,
    proxyClass: DigitalIdentityRequestProxy,
    stubClass: DigitalIdentityRequestStub,
    validateRequest: validateDigitalIdentityRequestRequest,
    validateResponse: validateDigitalIdentityRequestResponse,
  };
  DigitalIdentityRequestStub.prototype.validator = validateDigitalIdentityRequestRequest;
  DigitalIdentityRequestProxy.prototype.validator = validateDigitalIdentityRequestResponse;
  exports.RequestDigitalIdentityStatus = RequestDigitalIdentityStatus;
  exports.DigitalCredentialGetRequest = DigitalCredentialGetRequest;
  exports.DigitalCredentialCreateRequest = DigitalCredentialCreateRequest;
  exports.DigitalIdentityRequest = DigitalIdentityRequest;
  exports.DigitalIdentityRequestPtr = DigitalIdentityRequestPtr;
  exports.DigitalIdentityRequestAssociatedPtr = DigitalIdentityRequestAssociatedPtr;
})();