// third_party/blink/public/mojom/webauthn/authenticator.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_WEBAUTHN_AUTHENTICATOR_MOJOM_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_WEBAUTHN_AUTHENTICATOR_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/webauthn/authenticator.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/webauthn/authenticator.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/webauthn/authenticator.mojom-forward.h"  // IWYU pragma: export
#include "components/payments/mojom/payment_request_data.mojom.h"
#include "mojo/public/mojom/base/time.mojom.h"
#include "third_party/blink/public/mojom/credentialmanagement/credential_manager.mojom.h"
#include "url/mojom/origin.mojom.h"
#include "url/mojom/url.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "third_party/blink/public/mojom/authenticator_mojom_traits.h"
#include "third_party/blink/public/common/common_export.h"




namespace blink::mojom {

class AuthenticatorProxy;

template <typename ImplRefTraits>
class AuthenticatorStub;

class AuthenticatorRequestValidator;
class AuthenticatorResponseValidator;


class BLINK_COMMON_EXPORT Authenticator
    : public AuthenticatorInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "blink.mojom.Authenticator";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = AuthenticatorInterfaceBase;
  using Proxy_ = AuthenticatorProxy;

  template <typename ImplRefTraits>
  using Stub_ = AuthenticatorStub<ImplRefTraits>;

  using RequestValidator_ = AuthenticatorRequestValidator;
  using ResponseValidator_ = AuthenticatorResponseValidator;
  enum MethodMinVersions : uint32_t {
    kMakeCredentialMinVersion = 0,
    kGetCredentialMinVersion = 0,
    kIsUserVerifyingPlatformAuthenticatorAvailableMinVersion = 0,
    kIsConditionalMediationAvailableMinVersion = 0,
    kReportMinVersion = 0,
    kGetClientCapabilitiesMinVersion = 0,
    kCancelMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct MakeCredential_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetCredential_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct IsUserVerifyingPlatformAuthenticatorAvailable_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct IsConditionalMediationAvailable_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Report_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetClientCapabilities_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Cancel_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~Authenticator() = default;

  using MakeCredentialCallback = base::OnceCallback<void(AuthenticatorStatus, MakeCredentialAuthenticatorResponsePtr, WebAuthnDOMExceptionDetailsPtr)>;
  using MakeCredentialMojoCallback = base::OnceCallback<void(AuthenticatorStatus, MakeCredentialAuthenticatorResponsePtr, WebAuthnDOMExceptionDetailsPtr)>;

  virtual void MakeCredential(PublicKeyCredentialCreationOptionsPtr options, MakeCredentialCallback callback) = 0;

  using GetCredentialCallback = base::OnceCallback<void(GetCredentialResponsePtr)>;
  using GetCredentialMojoCallback = base::OnceCallback<void(GetCredentialResponsePtr)>;

  virtual void GetCredential(GetCredentialOptionsPtr options, GetCredentialCallback callback) = 0;

  using IsUserVerifyingPlatformAuthenticatorAvailableCallback = base::OnceCallback<void(bool)>;
  using IsUserVerifyingPlatformAuthenticatorAvailableMojoCallback = base::OnceCallback<void(bool)>;

  virtual void IsUserVerifyingPlatformAuthenticatorAvailable(IsUserVerifyingPlatformAuthenticatorAvailableCallback callback) = 0;

  using IsConditionalMediationAvailableCallback = base::OnceCallback<void(bool)>;
  using IsConditionalMediationAvailableMojoCallback = base::OnceCallback<void(bool)>;

  virtual void IsConditionalMediationAvailable(IsConditionalMediationAvailableCallback callback) = 0;

  using ReportCallback = base::OnceCallback<void(AuthenticatorStatus, WebAuthnDOMExceptionDetailsPtr)>;
  using ReportMojoCallback = base::OnceCallback<void(AuthenticatorStatus, WebAuthnDOMExceptionDetailsPtr)>;

  virtual void Report(PublicKeyCredentialReportOptionsPtr options, ReportCallback callback) = 0;

  using GetClientCapabilitiesCallback = base::OnceCallback<void(std::vector<WebAuthnClientCapabilityPtr>)>;
  using GetClientCapabilitiesMojoCallback = base::OnceCallback<void(std::vector<WebAuthnClientCapabilityPtr>)>;

  virtual void GetClientCapabilities(GetClientCapabilitiesCallback callback) = 0;

  virtual void Cancel() = 0;
};



class BLINK_COMMON_EXPORT AuthenticatorProxy
    : public Authenticator {
 public:
  using InterfaceType = Authenticator;

  explicit AuthenticatorProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void MakeCredential(PublicKeyCredentialCreationOptionsPtr options, MakeCredentialCallback callback) final;
  
  void GetCredential(GetCredentialOptionsPtr options, GetCredentialCallback callback) final;
  
  void IsUserVerifyingPlatformAuthenticatorAvailable(IsUserVerifyingPlatformAuthenticatorAvailableCallback callback) final;
  
  void IsConditionalMediationAvailable(IsConditionalMediationAvailableCallback callback) final;
  
  void Report(PublicKeyCredentialReportOptionsPtr options, ReportCallback callback) final;
  
  void GetClientCapabilities(GetClientCapabilitiesCallback callback) final;
  
  void Cancel() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class BLINK_COMMON_EXPORT AuthenticatorStubDispatch {
 public:
  static bool Accept(Authenticator* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      Authenticator* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<Authenticator>>
class AuthenticatorStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  AuthenticatorStub() = default;
  ~AuthenticatorStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return AuthenticatorStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return AuthenticatorStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_COMMON_EXPORT AuthenticatorRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_COMMON_EXPORT AuthenticatorResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};











class BLINK_COMMON_EXPORT PublicKeyCredentialRpEntity {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PublicKeyCredentialRpEntity, T>::value>;
  using DataView = PublicKeyCredentialRpEntityDataView;
  using Data_ = internal::PublicKeyCredentialRpEntity_Data;

  template <typename... Args>
  static PublicKeyCredentialRpEntityPtr New(Args&&... args) {
    return PublicKeyCredentialRpEntityPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PublicKeyCredentialRpEntityPtr From(const U& u) {
    return mojo::TypeConverter<PublicKeyCredentialRpEntityPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PublicKeyCredentialRpEntity>::Convert(*this);
  }


  PublicKeyCredentialRpEntity();

  PublicKeyCredentialRpEntity(
      const std::string& id,
      const std::string& name);


  ~PublicKeyCredentialRpEntity();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PublicKeyCredentialRpEntityPtr>
  PublicKeyCredentialRpEntityPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PublicKeyCredentialRpEntity::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, PublicKeyCredentialRpEntity::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, PublicKeyCredentialRpEntity::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PublicKeyCredentialRpEntity::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PublicKeyCredentialRpEntity::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PublicKeyCredentialRpEntity::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PublicKeyCredentialRpEntity_UnserializedMessageContext<
            UserType, PublicKeyCredentialRpEntity::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<PublicKeyCredentialRpEntity::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return PublicKeyCredentialRpEntity::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PublicKeyCredentialRpEntity_UnserializedMessageContext<
            UserType, PublicKeyCredentialRpEntity::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PublicKeyCredentialRpEntity::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string id;
  
  std::string name;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PublicKeyCredentialRpEntity::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PublicKeyCredentialRpEntity::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PublicKeyCredentialRpEntity::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PublicKeyCredentialRpEntity::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class BLINK_COMMON_EXPORT PublicKeyCredentialParameters {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PublicKeyCredentialParameters, T>::value>;
  using DataView = PublicKeyCredentialParametersDataView;
  using Data_ = internal::PublicKeyCredentialParameters_Data;

  template <typename... Args>
  static PublicKeyCredentialParametersPtr New(Args&&... args) {
    return PublicKeyCredentialParametersPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PublicKeyCredentialParametersPtr From(const U& u) {
    return mojo::TypeConverter<PublicKeyCredentialParametersPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PublicKeyCredentialParameters>::Convert(*this);
  }


  PublicKeyCredentialParameters();

  PublicKeyCredentialParameters(
      ::device::CredentialType type,
      int32_t algorithm_identifier);


  ~PublicKeyCredentialParameters();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PublicKeyCredentialParametersPtr>
  PublicKeyCredentialParametersPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PublicKeyCredentialParameters::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, PublicKeyCredentialParameters::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, PublicKeyCredentialParameters::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PublicKeyCredentialParameters::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PublicKeyCredentialParameters::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PublicKeyCredentialParameters::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PublicKeyCredentialParameters_UnserializedMessageContext<
            UserType, PublicKeyCredentialParameters::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<PublicKeyCredentialParameters::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return PublicKeyCredentialParameters::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PublicKeyCredentialParameters_UnserializedMessageContext<
            UserType, PublicKeyCredentialParameters::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PublicKeyCredentialParameters::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::device::CredentialType type;
  
  int32_t algorithm_identifier;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PublicKeyCredentialParameters::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PublicKeyCredentialParameters::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PublicKeyCredentialParameters::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PublicKeyCredentialParameters::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}















class BLINK_COMMON_EXPORT AuthenticatorSelectionCriteria {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AuthenticatorSelectionCriteria, T>::value>;
  using DataView = AuthenticatorSelectionCriteriaDataView;
  using Data_ = internal::AuthenticatorSelectionCriteria_Data;

  template <typename... Args>
  static AuthenticatorSelectionCriteriaPtr New(Args&&... args) {
    return AuthenticatorSelectionCriteriaPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AuthenticatorSelectionCriteriaPtr From(const U& u) {
    return mojo::TypeConverter<AuthenticatorSelectionCriteriaPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AuthenticatorSelectionCriteria>::Convert(*this);
  }


  AuthenticatorSelectionCriteria();

  AuthenticatorSelectionCriteria(
      ::device::AuthenticatorAttachment authenticator_attachment,
      ResidentKeyRequirement resident_key,
      ::device::UserVerificationRequirement user_verification);


  ~AuthenticatorSelectionCriteria();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AuthenticatorSelectionCriteriaPtr>
  AuthenticatorSelectionCriteriaPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AuthenticatorSelectionCriteria::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AuthenticatorSelectionCriteria::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AuthenticatorSelectionCriteria::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AuthenticatorSelectionCriteria::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AuthenticatorSelectionCriteria::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AuthenticatorSelectionCriteria::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AuthenticatorSelectionCriteria_UnserializedMessageContext<
            UserType, AuthenticatorSelectionCriteria::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AuthenticatorSelectionCriteria::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AuthenticatorSelectionCriteria::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AuthenticatorSelectionCriteria_UnserializedMessageContext<
            UserType, AuthenticatorSelectionCriteria::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AuthenticatorSelectionCriteria::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::device::AuthenticatorAttachment authenticator_attachment;
  
  ResidentKeyRequirement resident_key;
  
  ::device::UserVerificationRequirement user_verification;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AuthenticatorSelectionCriteria::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AuthenticatorSelectionCriteria::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AuthenticatorSelectionCriteria::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AuthenticatorSelectionCriteria::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}







class BLINK_COMMON_EXPORT WebAuthnDOMExceptionDetails {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<WebAuthnDOMExceptionDetails, T>::value>;
  using DataView = WebAuthnDOMExceptionDetailsDataView;
  using Data_ = internal::WebAuthnDOMExceptionDetails_Data;

  template <typename... Args>
  static WebAuthnDOMExceptionDetailsPtr New(Args&&... args) {
    return WebAuthnDOMExceptionDetailsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static WebAuthnDOMExceptionDetailsPtr From(const U& u) {
    return mojo::TypeConverter<WebAuthnDOMExceptionDetailsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, WebAuthnDOMExceptionDetails>::Convert(*this);
  }


  WebAuthnDOMExceptionDetails();

  WebAuthnDOMExceptionDetails(
      const std::string& name,
      const std::string& message);


  ~WebAuthnDOMExceptionDetails();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = WebAuthnDOMExceptionDetailsPtr>
  WebAuthnDOMExceptionDetailsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, WebAuthnDOMExceptionDetails::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, WebAuthnDOMExceptionDetails::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, WebAuthnDOMExceptionDetails::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        WebAuthnDOMExceptionDetails::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        WebAuthnDOMExceptionDetails::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        WebAuthnDOMExceptionDetails::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::WebAuthnDOMExceptionDetails_UnserializedMessageContext<
            UserType, WebAuthnDOMExceptionDetails::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<WebAuthnDOMExceptionDetails::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return WebAuthnDOMExceptionDetails::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::WebAuthnDOMExceptionDetails_UnserializedMessageContext<
            UserType, WebAuthnDOMExceptionDetails::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<WebAuthnDOMExceptionDetails::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string name;
  
  std::string message;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, WebAuthnDOMExceptionDetails::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, WebAuthnDOMExceptionDetails::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, WebAuthnDOMExceptionDetails::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, WebAuthnDOMExceptionDetails::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}








class BLINK_COMMON_EXPORT WebAuthnClientCapability {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<WebAuthnClientCapability, T>::value>;
  using DataView = WebAuthnClientCapabilityDataView;
  using Data_ = internal::WebAuthnClientCapability_Data;

  template <typename... Args>
  static WebAuthnClientCapabilityPtr New(Args&&... args) {
    return WebAuthnClientCapabilityPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static WebAuthnClientCapabilityPtr From(const U& u) {
    return mojo::TypeConverter<WebAuthnClientCapabilityPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, WebAuthnClientCapability>::Convert(*this);
  }


  WebAuthnClientCapability();

  WebAuthnClientCapability(
      const std::string& name,
      bool supported);


  ~WebAuthnClientCapability();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = WebAuthnClientCapabilityPtr>
  WebAuthnClientCapabilityPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, WebAuthnClientCapability::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, WebAuthnClientCapability::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, WebAuthnClientCapability::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        WebAuthnClientCapability::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        WebAuthnClientCapability::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        WebAuthnClientCapability::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::WebAuthnClientCapability_UnserializedMessageContext<
            UserType, WebAuthnClientCapability::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<WebAuthnClientCapability::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return WebAuthnClientCapability::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::WebAuthnClientCapability_UnserializedMessageContext<
            UserType, WebAuthnClientCapability::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<WebAuthnClientCapability::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string name;
  
  bool supported;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, WebAuthnClientCapability::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, WebAuthnClientCapability::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, WebAuthnClientCapability::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, WebAuthnClientCapability::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class BLINK_COMMON_EXPORT GetCredentialResponse {
 public:
  using DataView = GetCredentialResponseDataView;
  using Data_ = internal::GetCredentialResponse_Data;
  using Tag = Data_::GetCredentialResponse_Tag;

  template <typename... Args>
  static GetCredentialResponsePtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |get_assertion_response|.
  static GetCredentialResponsePtr NewGetAssertionResponse(
      GetAssertionResponsePtr value);
  // Construct an instance holding |password_response|.
  static GetCredentialResponsePtr NewPasswordResponse(
      const ::password_manager::CredentialInfo& value);

  template <typename U>
  static GetCredentialResponsePtr From(const U& u) {
    return mojo::TypeConverter<GetCredentialResponsePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, GetCredentialResponse>::Convert(*this);
  }
  ~GetCredentialResponse();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  GetCredentialResponse(const GetCredentialResponse& other) = delete;
  GetCredentialResponse& operator=(const GetCredentialResponse& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = GetCredentialResponsePtr>
  GetCredentialResponsePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, GetCredentialResponse>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, GetCredentialResponse>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }

  bool is_get_assertion_response() const { return tag_ == Tag::kGetAssertionResponse; }
  const GetAssertionResponsePtr& get_get_assertion_response() const {
    CHECK(tag_ == Tag::kGetAssertionResponse);
    return data_.get_assertion_response;
  }
  GetAssertionResponsePtr& get_get_assertion_response() {
    CHECK(tag_ == Tag::kGetAssertionResponse);
    return data_.get_assertion_response;
  }
  void set_get_assertion_response(GetAssertionResponsePtr get_assertion_response);

  bool is_password_response() const { return tag_ == Tag::kPasswordResponse; }
  const ::password_manager::CredentialInfo& get_password_response() const {
    CHECK(tag_ == Tag::kPasswordResponse);
    return data_.password_response;
  }
  ::password_manager::CredentialInfo& get_password_response() {
    CHECK(tag_ == Tag::kPasswordResponse);
    return data_.password_response;
  }
  void set_password_response(const ::password_manager::CredentialInfo& password_response);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        GetCredentialResponse::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<GetCredentialResponse::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kGetAssertionResponse)>,
        GetAssertionResponsePtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kPasswordResponse)>,
        const ::password_manager::CredentialInfo& value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    GetAssertionResponsePtr get_assertion_response;
    ::password_manager::CredentialInfo password_response;
  };

  GetCredentialResponse(
      std::in_place_index_t<static_cast<size_t>(Tag::kGetAssertionResponse)>,
      GetAssertionResponsePtr value);
  GetCredentialResponse(
      std::in_place_index_t<static_cast<size_t>(Tag::kPasswordResponse)>,
      const ::password_manager::CredentialInfo& value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};





class BLINK_COMMON_EXPORT CommonCredentialInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<CommonCredentialInfo, T>::value>;
  using DataView = CommonCredentialInfoDataView;
  using Data_ = internal::CommonCredentialInfo_Data;

  template <typename... Args>
  static CommonCredentialInfoPtr New(Args&&... args) {
    return CommonCredentialInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static CommonCredentialInfoPtr From(const U& u) {
    return mojo::TypeConverter<CommonCredentialInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CommonCredentialInfo>::Convert(*this);
  }


  CommonCredentialInfo();

  CommonCredentialInfo(
      const std::string& id,
      std::vector<uint8_t> raw_id,
      std::vector<uint8_t> client_data_json,
      std::vector<uint8_t> authenticator_data);


  ~CommonCredentialInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = CommonCredentialInfoPtr>
  CommonCredentialInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, CommonCredentialInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, CommonCredentialInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, CommonCredentialInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CommonCredentialInfo::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CommonCredentialInfo::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CommonCredentialInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::CommonCredentialInfo_UnserializedMessageContext<
            UserType, CommonCredentialInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<CommonCredentialInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return CommonCredentialInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::CommonCredentialInfo_UnserializedMessageContext<
            UserType, CommonCredentialInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<CommonCredentialInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string id;
  
  std::vector<uint8_t> raw_id;
  
  std::vector<uint8_t> client_data_json;
  
  std::vector<uint8_t> authenticator_data;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, CommonCredentialInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, CommonCredentialInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, CommonCredentialInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, CommonCredentialInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_COMMON_EXPORT SupplementalPubKeysResponse {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SupplementalPubKeysResponse, T>::value>;
  using DataView = SupplementalPubKeysResponseDataView;
  using Data_ = internal::SupplementalPubKeysResponse_Data;

  template <typename... Args>
  static SupplementalPubKeysResponsePtr New(Args&&... args) {
    return SupplementalPubKeysResponsePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SupplementalPubKeysResponsePtr From(const U& u) {
    return mojo::TypeConverter<SupplementalPubKeysResponsePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SupplementalPubKeysResponse>::Convert(*this);
  }


  SupplementalPubKeysResponse();

  explicit SupplementalPubKeysResponse(
      std::vector<std::vector<uint8_t>> signatures);


  ~SupplementalPubKeysResponse();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SupplementalPubKeysResponsePtr>
  SupplementalPubKeysResponsePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SupplementalPubKeysResponse::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SupplementalPubKeysResponse::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SupplementalPubKeysResponse::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SupplementalPubKeysResponse::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SupplementalPubKeysResponse::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SupplementalPubKeysResponse::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SupplementalPubKeysResponse_UnserializedMessageContext<
            UserType, SupplementalPubKeysResponse::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SupplementalPubKeysResponse::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SupplementalPubKeysResponse::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SupplementalPubKeysResponse_UnserializedMessageContext<
            UserType, SupplementalPubKeysResponse::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SupplementalPubKeysResponse::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::vector<std::vector<uint8_t>> signatures;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SupplementalPubKeysResponse::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SupplementalPubKeysResponse::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SupplementalPubKeysResponse::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SupplementalPubKeysResponse::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_COMMON_EXPORT AuthenticationExtensionsPaymentResponse {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AuthenticationExtensionsPaymentResponse, T>::value>;
  using DataView = AuthenticationExtensionsPaymentResponseDataView;
  using Data_ = internal::AuthenticationExtensionsPaymentResponse_Data;

  template <typename... Args>
  static AuthenticationExtensionsPaymentResponsePtr New(Args&&... args) {
    return AuthenticationExtensionsPaymentResponsePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AuthenticationExtensionsPaymentResponsePtr From(const U& u) {
    return mojo::TypeConverter<AuthenticationExtensionsPaymentResponsePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AuthenticationExtensionsPaymentResponse>::Convert(*this);
  }


  AuthenticationExtensionsPaymentResponse();

  explicit AuthenticationExtensionsPaymentResponse(
      std::vector<uint8_t> browser_bound_signature);


  ~AuthenticationExtensionsPaymentResponse();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AuthenticationExtensionsPaymentResponsePtr>
  AuthenticationExtensionsPaymentResponsePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AuthenticationExtensionsPaymentResponse::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AuthenticationExtensionsPaymentResponse::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AuthenticationExtensionsPaymentResponse::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AuthenticationExtensionsPaymentResponse::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AuthenticationExtensionsPaymentResponse::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AuthenticationExtensionsPaymentResponse::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AuthenticationExtensionsPaymentResponse_UnserializedMessageContext<
            UserType, AuthenticationExtensionsPaymentResponse::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AuthenticationExtensionsPaymentResponse::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AuthenticationExtensionsPaymentResponse::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AuthenticationExtensionsPaymentResponse_UnserializedMessageContext<
            UserType, AuthenticationExtensionsPaymentResponse::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AuthenticationExtensionsPaymentResponse::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::vector<uint8_t> browser_bound_signature;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AuthenticationExtensionsPaymentResponse::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AuthenticationExtensionsPaymentResponse::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AuthenticationExtensionsPaymentResponse::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AuthenticationExtensionsPaymentResponse::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_COMMON_EXPORT MakeCredentialAuthenticatorResponse {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<MakeCredentialAuthenticatorResponse, T>::value>;
  using DataView = MakeCredentialAuthenticatorResponseDataView;
  using Data_ = internal::MakeCredentialAuthenticatorResponse_Data;

  template <typename... Args>
  static MakeCredentialAuthenticatorResponsePtr New(Args&&... args) {
    return MakeCredentialAuthenticatorResponsePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static MakeCredentialAuthenticatorResponsePtr From(const U& u) {
    return mojo::TypeConverter<MakeCredentialAuthenticatorResponsePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, MakeCredentialAuthenticatorResponse>::Convert(*this);
  }


  MakeCredentialAuthenticatorResponse();

  MakeCredentialAuthenticatorResponse(
      CommonCredentialInfoPtr info,
      ::device::AuthenticatorAttachment authenticator_attachment,
      std::vector<uint8_t> attestation_object,
      std::vector<::device::FidoTransportProtocol> transports,
      bool echo_hmac_create_secret,
      bool hmac_create_secret,
      bool echo_prf,
      bool prf,
      PRFValuesPtr prf_results,
      bool echo_cred_blob,
      bool cred_blob,
      std::optional<std::vector<uint8_t>> public_key_der,
      int32_t public_key_algo,
      bool echo_cred_props,
      bool has_cred_props_rk,
      bool cred_props_rk,
      bool echo_large_blob,
      bool supports_large_blob,
      SupplementalPubKeysResponsePtr supplemental_pub_keys,
      AuthenticationExtensionsPaymentResponsePtr payment);

MakeCredentialAuthenticatorResponse(const MakeCredentialAuthenticatorResponse&) = delete;
MakeCredentialAuthenticatorResponse& operator=(const MakeCredentialAuthenticatorResponse&) = delete;

  ~MakeCredentialAuthenticatorResponse();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = MakeCredentialAuthenticatorResponsePtr>
  MakeCredentialAuthenticatorResponsePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, MakeCredentialAuthenticatorResponse::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, MakeCredentialAuthenticatorResponse::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, MakeCredentialAuthenticatorResponse::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        MakeCredentialAuthenticatorResponse::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        MakeCredentialAuthenticatorResponse::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        MakeCredentialAuthenticatorResponse::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::MakeCredentialAuthenticatorResponse_UnserializedMessageContext<
            UserType, MakeCredentialAuthenticatorResponse::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<MakeCredentialAuthenticatorResponse::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return MakeCredentialAuthenticatorResponse::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::MakeCredentialAuthenticatorResponse_UnserializedMessageContext<
            UserType, MakeCredentialAuthenticatorResponse::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<MakeCredentialAuthenticatorResponse::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  CommonCredentialInfoPtr info;
  
  ::device::AuthenticatorAttachment authenticator_attachment;
  
  std::vector<uint8_t> attestation_object;
  
  std::vector<::device::FidoTransportProtocol> transports;
  
  bool echo_hmac_create_secret;
  
  bool hmac_create_secret;
  
  bool echo_prf;
  
  bool prf;
  
  PRFValuesPtr prf_results;
  
  bool echo_cred_blob;
  
  bool cred_blob;
  
  std::optional<std::vector<uint8_t>> public_key_der;
  
  int32_t public_key_algo;
  
  bool echo_cred_props;
  
  bool has_cred_props_rk;
  
  bool cred_props_rk;
  
  bool echo_large_blob;
  
  bool supports_large_blob;
  
  SupplementalPubKeysResponsePtr supplemental_pub_keys;
  
  AuthenticationExtensionsPaymentResponsePtr payment;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, MakeCredentialAuthenticatorResponse::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, MakeCredentialAuthenticatorResponse::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, MakeCredentialAuthenticatorResponse::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, MakeCredentialAuthenticatorResponse::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_COMMON_EXPORT GetAssertionAuthenticatorResponse {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<GetAssertionAuthenticatorResponse, T>::value>;
  using DataView = GetAssertionAuthenticatorResponseDataView;
  using Data_ = internal::GetAssertionAuthenticatorResponse_Data;

  template <typename... Args>
  static GetAssertionAuthenticatorResponsePtr New(Args&&... args) {
    return GetAssertionAuthenticatorResponsePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static GetAssertionAuthenticatorResponsePtr From(const U& u) {
    return mojo::TypeConverter<GetAssertionAuthenticatorResponsePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, GetAssertionAuthenticatorResponse>::Convert(*this);
  }


  GetAssertionAuthenticatorResponse();

  GetAssertionAuthenticatorResponse(
      CommonCredentialInfoPtr info,
      ::device::AuthenticatorAttachment authenticator_attachment,
      std::vector<uint8_t> signature,
      std::optional<std::vector<uint8_t>> user_handle,
      AuthenticationExtensionsClientOutputsPtr extensions);

GetAssertionAuthenticatorResponse(const GetAssertionAuthenticatorResponse&) = delete;
GetAssertionAuthenticatorResponse& operator=(const GetAssertionAuthenticatorResponse&) = delete;

  ~GetAssertionAuthenticatorResponse();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = GetAssertionAuthenticatorResponsePtr>
  GetAssertionAuthenticatorResponsePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, GetAssertionAuthenticatorResponse::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, GetAssertionAuthenticatorResponse::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, GetAssertionAuthenticatorResponse::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        GetAssertionAuthenticatorResponse::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        GetAssertionAuthenticatorResponse::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        GetAssertionAuthenticatorResponse::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::GetAssertionAuthenticatorResponse_UnserializedMessageContext<
            UserType, GetAssertionAuthenticatorResponse::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<GetAssertionAuthenticatorResponse::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return GetAssertionAuthenticatorResponse::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::GetAssertionAuthenticatorResponse_UnserializedMessageContext<
            UserType, GetAssertionAuthenticatorResponse::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<GetAssertionAuthenticatorResponse::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  CommonCredentialInfoPtr info;
  
  ::device::AuthenticatorAttachment authenticator_attachment;
  
  std::vector<uint8_t> signature;
  
  std::optional<std::vector<uint8_t>> user_handle;
  
  AuthenticationExtensionsClientOutputsPtr extensions;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, GetAssertionAuthenticatorResponse::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, GetAssertionAuthenticatorResponse::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, GetAssertionAuthenticatorResponse::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, GetAssertionAuthenticatorResponse::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_COMMON_EXPORT AuthenticationExtensionsClientOutputs {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AuthenticationExtensionsClientOutputs, T>::value>;
  using DataView = AuthenticationExtensionsClientOutputsDataView;
  using Data_ = internal::AuthenticationExtensionsClientOutputs_Data;

  template <typename... Args>
  static AuthenticationExtensionsClientOutputsPtr New(Args&&... args) {
    return AuthenticationExtensionsClientOutputsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AuthenticationExtensionsClientOutputsPtr From(const U& u) {
    return mojo::TypeConverter<AuthenticationExtensionsClientOutputsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AuthenticationExtensionsClientOutputs>::Convert(*this);
  }


  AuthenticationExtensionsClientOutputs();

  AuthenticationExtensionsClientOutputs(
      bool echo_appid_extension,
      bool appid_extension,
      bool echo_prf,
      PRFValuesPtr prf_results,
      bool prf_not_evaluated,
      bool echo_large_blob,
      std::optional<std::vector<uint8_t>> large_blob,
      bool echo_large_blob_written,
      bool large_blob_written,
      std::optional<std::vector<uint8_t>> get_cred_blob,
      SupplementalPubKeysResponsePtr supplemental_pub_keys,
      AuthenticationExtensionsPaymentResponsePtr payment);

AuthenticationExtensionsClientOutputs(const AuthenticationExtensionsClientOutputs&) = delete;
AuthenticationExtensionsClientOutputs& operator=(const AuthenticationExtensionsClientOutputs&) = delete;

  ~AuthenticationExtensionsClientOutputs();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AuthenticationExtensionsClientOutputsPtr>
  AuthenticationExtensionsClientOutputsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AuthenticationExtensionsClientOutputs::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AuthenticationExtensionsClientOutputs::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AuthenticationExtensionsClientOutputs::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AuthenticationExtensionsClientOutputs::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AuthenticationExtensionsClientOutputs::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AuthenticationExtensionsClientOutputs::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AuthenticationExtensionsClientOutputs_UnserializedMessageContext<
            UserType, AuthenticationExtensionsClientOutputs::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AuthenticationExtensionsClientOutputs::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AuthenticationExtensionsClientOutputs::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AuthenticationExtensionsClientOutputs_UnserializedMessageContext<
            UserType, AuthenticationExtensionsClientOutputs::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AuthenticationExtensionsClientOutputs::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  bool echo_appid_extension;
  
  bool appid_extension;
  
  bool echo_prf;
  
  PRFValuesPtr prf_results;
  
  bool prf_not_evaluated;
  
  bool echo_large_blob;
  
  std::optional<std::vector<uint8_t>> large_blob;
  
  bool echo_large_blob_written;
  
  bool large_blob_written;
  
  std::optional<std::vector<uint8_t>> get_cred_blob;
  
  SupplementalPubKeysResponsePtr supplemental_pub_keys;
  
  AuthenticationExtensionsPaymentResponsePtr payment;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AuthenticationExtensionsClientOutputs::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AuthenticationExtensionsClientOutputs::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AuthenticationExtensionsClientOutputs::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AuthenticationExtensionsClientOutputs::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class BLINK_COMMON_EXPORT PublicKeyCredentialUserEntity {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PublicKeyCredentialUserEntity, T>::value>;
  using DataView = PublicKeyCredentialUserEntityDataView;
  using Data_ = internal::PublicKeyCredentialUserEntity_Data;

  template <typename... Args>
  static PublicKeyCredentialUserEntityPtr New(Args&&... args) {
    return PublicKeyCredentialUserEntityPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PublicKeyCredentialUserEntityPtr From(const U& u) {
    return mojo::TypeConverter<PublicKeyCredentialUserEntityPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PublicKeyCredentialUserEntity>::Convert(*this);
  }


  PublicKeyCredentialUserEntity();

  PublicKeyCredentialUserEntity(
      std::vector<uint8_t> id,
      const std::string& name,
      const std::string& display_name);


  ~PublicKeyCredentialUserEntity();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PublicKeyCredentialUserEntityPtr>
  PublicKeyCredentialUserEntityPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PublicKeyCredentialUserEntity::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, PublicKeyCredentialUserEntity::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, PublicKeyCredentialUserEntity::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PublicKeyCredentialUserEntity::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PublicKeyCredentialUserEntity::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PublicKeyCredentialUserEntity::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PublicKeyCredentialUserEntity_UnserializedMessageContext<
            UserType, PublicKeyCredentialUserEntity::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<PublicKeyCredentialUserEntity::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return PublicKeyCredentialUserEntity::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PublicKeyCredentialUserEntity_UnserializedMessageContext<
            UserType, PublicKeyCredentialUserEntity::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PublicKeyCredentialUserEntity::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::vector<uint8_t> id;
  
  std::string name;
  
  std::string display_name;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PublicKeyCredentialUserEntity::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PublicKeyCredentialUserEntity::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PublicKeyCredentialUserEntity::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PublicKeyCredentialUserEntity::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class BLINK_COMMON_EXPORT CableAuthentication {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<CableAuthentication, T>::value>;
  using DataView = CableAuthenticationDataView;
  using Data_ = internal::CableAuthentication_Data;

  template <typename... Args>
  static CableAuthenticationPtr New(Args&&... args) {
    return CableAuthenticationPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static CableAuthenticationPtr From(const U& u) {
    return mojo::TypeConverter<CableAuthenticationPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CableAuthentication>::Convert(*this);
  }


  CableAuthentication();

  CableAuthentication(
      uint8_t version,
      std::optional<std::vector<uint8_t>> client_eid,
      std::optional<std::vector<uint8_t>> authenticator_eid,
      std::optional<std::vector<uint8_t>> session_pre_key,
      std::optional<std::vector<uint8_t>> server_link_data,
      std::optional<std::vector<uint8_t>> experiments);


  ~CableAuthentication();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = CableAuthenticationPtr>
  CableAuthenticationPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, CableAuthentication::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, CableAuthentication::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, CableAuthentication::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CableAuthentication::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CableAuthentication::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CableAuthentication::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::CableAuthentication_UnserializedMessageContext<
            UserType, CableAuthentication::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<CableAuthentication::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return CableAuthentication::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::CableAuthentication_UnserializedMessageContext<
            UserType, CableAuthentication::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<CableAuthentication::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  uint8_t version;
  
  std::optional<std::vector<uint8_t>> client_eid;
  
  std::optional<std::vector<uint8_t>> authenticator_eid;
  
  std::optional<std::vector<uint8_t>> session_pre_key;
  
  std::optional<std::vector<uint8_t>> server_link_data;
  
  std::optional<std::vector<uint8_t>> experiments;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, CableAuthentication::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, CableAuthentication::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, CableAuthentication::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, CableAuthentication::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_COMMON_EXPORT PRFValues {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PRFValues, T>::value>;
  using DataView = PRFValuesDataView;
  using Data_ = internal::PRFValues_Data;

  template <typename... Args>
  static PRFValuesPtr New(Args&&... args) {
    return PRFValuesPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PRFValuesPtr From(const U& u) {
    return mojo::TypeConverter<PRFValuesPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PRFValues>::Convert(*this);
  }


  PRFValues();

  PRFValues(
      std::optional<std::vector<uint8_t>> id,
      std::vector<uint8_t> first,
      std::optional<std::vector<uint8_t>> second);


  ~PRFValues();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PRFValuesPtr>
  PRFValuesPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PRFValues::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, PRFValues::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, PRFValues::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PRFValues::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PRFValues::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PRFValues::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PRFValues_UnserializedMessageContext<
            UserType, PRFValues::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<PRFValues::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return PRFValues::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PRFValues_UnserializedMessageContext<
            UserType, PRFValues::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PRFValues::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::optional<std::vector<uint8_t>> id;
  
  std::vector<uint8_t> first;
  
  std::optional<std::vector<uint8_t>> second;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PRFValues::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PRFValues::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PRFValues::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PRFValues::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_COMMON_EXPORT PaymentOptions {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PaymentOptions, T>::value>;
  using DataView = PaymentOptionsDataView;
  using Data_ = internal::PaymentOptions_Data;

  template <typename... Args>
  static PaymentOptionsPtr New(Args&&... args) {
    return PaymentOptionsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PaymentOptionsPtr From(const U& u) {
    return mojo::TypeConverter<PaymentOptionsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PaymentOptions>::Convert(*this);
  }


  PaymentOptions();

  PaymentOptions(
      ::payments::mojom::PaymentCurrencyAmountPtr total,
      PaymentCredentialInstrumentPtr instrument,
      const std::optional<std::string>& payee_name,
      const std::optional<::url::Origin>& payee_origin,
      std::optional<std::vector<ShownPaymentEntityLogoPtr>> payment_entities_logos,
      std::optional<std::vector<uint8_t>> browser_bound_public_key);

PaymentOptions(const PaymentOptions&) = delete;
PaymentOptions& operator=(const PaymentOptions&) = delete;

  ~PaymentOptions();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PaymentOptionsPtr>
  PaymentOptionsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PaymentOptions::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, PaymentOptions::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, PaymentOptions::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PaymentOptions::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PaymentOptions::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PaymentOptions::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PaymentOptions_UnserializedMessageContext<
            UserType, PaymentOptions::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<PaymentOptions::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return PaymentOptions::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PaymentOptions_UnserializedMessageContext<
            UserType, PaymentOptions::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PaymentOptions::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::payments::mojom::PaymentCurrencyAmountPtr total;
  
  PaymentCredentialInstrumentPtr instrument;
  
  std::optional<std::string> payee_name;
  
  std::optional<::url::Origin> payee_origin;
  
  std::optional<std::vector<ShownPaymentEntityLogoPtr>> payment_entities_logos;
  
  std::optional<std::vector<uint8_t>> browser_bound_public_key;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PaymentOptions::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PaymentOptions::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PaymentOptions::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PaymentOptions::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_COMMON_EXPORT PaymentCredentialInstrument {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PaymentCredentialInstrument, T>::value>;
  using DataView = PaymentCredentialInstrumentDataView;
  using Data_ = internal::PaymentCredentialInstrument_Data;

  template <typename... Args>
  static PaymentCredentialInstrumentPtr New(Args&&... args) {
    return PaymentCredentialInstrumentPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PaymentCredentialInstrumentPtr From(const U& u) {
    return mojo::TypeConverter<PaymentCredentialInstrumentPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PaymentCredentialInstrument>::Convert(*this);
  }


  PaymentCredentialInstrument();

  PaymentCredentialInstrument(
      const std::string& display_name,
      const ::GURL& icon,
      bool iconMustBeShown,
      const std::optional<std::string>& details);


  ~PaymentCredentialInstrument();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PaymentCredentialInstrumentPtr>
  PaymentCredentialInstrumentPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PaymentCredentialInstrument::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, PaymentCredentialInstrument::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, PaymentCredentialInstrument::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PaymentCredentialInstrument::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PaymentCredentialInstrument::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PaymentCredentialInstrument::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PaymentCredentialInstrument_UnserializedMessageContext<
            UserType, PaymentCredentialInstrument::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<PaymentCredentialInstrument::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return PaymentCredentialInstrument::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PaymentCredentialInstrument_UnserializedMessageContext<
            UserType, PaymentCredentialInstrument::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PaymentCredentialInstrument::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string display_name;
  
  ::GURL icon;
  
  bool iconMustBeShown;
  
  std::optional<std::string> details;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PaymentCredentialInstrument::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PaymentCredentialInstrument::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PaymentCredentialInstrument::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PaymentCredentialInstrument::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_COMMON_EXPORT ShownPaymentEntityLogo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ShownPaymentEntityLogo, T>::value>;
  using DataView = ShownPaymentEntityLogoDataView;
  using Data_ = internal::ShownPaymentEntityLogo_Data;

  template <typename... Args>
  static ShownPaymentEntityLogoPtr New(Args&&... args) {
    return ShownPaymentEntityLogoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ShownPaymentEntityLogoPtr From(const U& u) {
    return mojo::TypeConverter<ShownPaymentEntityLogoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ShownPaymentEntityLogo>::Convert(*this);
  }


  ShownPaymentEntityLogo();

  ShownPaymentEntityLogo(
      const ::GURL& url,
      const std::string& label);


  ~ShownPaymentEntityLogo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ShownPaymentEntityLogoPtr>
  ShownPaymentEntityLogoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ShownPaymentEntityLogo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ShownPaymentEntityLogo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ShownPaymentEntityLogo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ShownPaymentEntityLogo::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ShownPaymentEntityLogo::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ShownPaymentEntityLogo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ShownPaymentEntityLogo_UnserializedMessageContext<
            UserType, ShownPaymentEntityLogo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ShownPaymentEntityLogo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ShownPaymentEntityLogo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ShownPaymentEntityLogo_UnserializedMessageContext<
            UserType, ShownPaymentEntityLogo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ShownPaymentEntityLogo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::GURL url;
  
  std::string label;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ShownPaymentEntityLogo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ShownPaymentEntityLogo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ShownPaymentEntityLogo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ShownPaymentEntityLogo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_COMMON_EXPORT RemoteDesktopClientOverride {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<RemoteDesktopClientOverride, T>::value>;
  using DataView = RemoteDesktopClientOverrideDataView;
  using Data_ = internal::RemoteDesktopClientOverride_Data;

  template <typename... Args>
  static RemoteDesktopClientOverridePtr New(Args&&... args) {
    return RemoteDesktopClientOverridePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static RemoteDesktopClientOverridePtr From(const U& u) {
    return mojo::TypeConverter<RemoteDesktopClientOverridePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, RemoteDesktopClientOverride>::Convert(*this);
  }


  RemoteDesktopClientOverride();

  RemoteDesktopClientOverride(
      const ::url::Origin& origin,
      bool same_origin_with_ancestors);


  ~RemoteDesktopClientOverride();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = RemoteDesktopClientOverridePtr>
  RemoteDesktopClientOverridePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, RemoteDesktopClientOverride::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, RemoteDesktopClientOverride::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, RemoteDesktopClientOverride::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        RemoteDesktopClientOverride::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        RemoteDesktopClientOverride::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        RemoteDesktopClientOverride::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::RemoteDesktopClientOverride_UnserializedMessageContext<
            UserType, RemoteDesktopClientOverride::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<RemoteDesktopClientOverride::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return RemoteDesktopClientOverride::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::RemoteDesktopClientOverride_UnserializedMessageContext<
            UserType, RemoteDesktopClientOverride::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<RemoteDesktopClientOverride::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::url::Origin origin;
  
  bool same_origin_with_ancestors;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, RemoteDesktopClientOverride::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, RemoteDesktopClientOverride::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, RemoteDesktopClientOverride::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, RemoteDesktopClientOverride::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_COMMON_EXPORT SupplementalPubKeysRequest {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SupplementalPubKeysRequest, T>::value>;
  using DataView = SupplementalPubKeysRequestDataView;
  using Data_ = internal::SupplementalPubKeysRequest_Data;

  template <typename... Args>
  static SupplementalPubKeysRequestPtr New(Args&&... args) {
    return SupplementalPubKeysRequestPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SupplementalPubKeysRequestPtr From(const U& u) {
    return mojo::TypeConverter<SupplementalPubKeysRequestPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SupplementalPubKeysRequest>::Convert(*this);
  }


  SupplementalPubKeysRequest();

  SupplementalPubKeysRequest(
      bool device_scope_requested,
      bool provider_scope_requested,
      ::device::AttestationConveyancePreference attestation,
      std::vector<std::string> attestation_formats);


  ~SupplementalPubKeysRequest();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SupplementalPubKeysRequestPtr>
  SupplementalPubKeysRequestPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SupplementalPubKeysRequest::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SupplementalPubKeysRequest::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SupplementalPubKeysRequest::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SupplementalPubKeysRequest::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SupplementalPubKeysRequest::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SupplementalPubKeysRequest::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SupplementalPubKeysRequest_UnserializedMessageContext<
            UserType, SupplementalPubKeysRequest::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SupplementalPubKeysRequest::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SupplementalPubKeysRequest::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SupplementalPubKeysRequest_UnserializedMessageContext<
            UserType, SupplementalPubKeysRequest::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SupplementalPubKeysRequest::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  bool device_scope_requested;
  
  bool provider_scope_requested;
  
  ::device::AttestationConveyancePreference attestation;
  
  std::vector<std::string> attestation_formats;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SupplementalPubKeysRequest::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SupplementalPubKeysRequest::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SupplementalPubKeysRequest::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SupplementalPubKeysRequest::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_COMMON_EXPORT PublicKeyCredentialRequestOptions {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PublicKeyCredentialRequestOptions, T>::value>;
  using DataView = PublicKeyCredentialRequestOptionsDataView;
  using Data_ = internal::PublicKeyCredentialRequestOptions_Data;

  template <typename... Args>
  static PublicKeyCredentialRequestOptionsPtr New(Args&&... args) {
    return PublicKeyCredentialRequestOptionsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PublicKeyCredentialRequestOptionsPtr From(const U& u) {
    return mojo::TypeConverter<PublicKeyCredentialRequestOptionsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PublicKeyCredentialRequestOptions>::Convert(*this);
  }


  PublicKeyCredentialRequestOptions();

  PublicKeyCredentialRequestOptions(
      std::optional<std::vector<uint8_t>> challenge,
      const std::optional<::GURL>& challenge_url,
      std::optional<::base::TimeDelta> timeout,
      const std::string& relying_party_id,
      std::vector<::device::PublicKeyCredentialDescriptor> allow_credentials,
      std::vector<Hint> hints,
      ::device::UserVerificationRequirement user_verification,
      AuthenticationExtensionsClientInputsPtr extensions);

PublicKeyCredentialRequestOptions(const PublicKeyCredentialRequestOptions&) = delete;
PublicKeyCredentialRequestOptions& operator=(const PublicKeyCredentialRequestOptions&) = delete;

  ~PublicKeyCredentialRequestOptions();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PublicKeyCredentialRequestOptionsPtr>
  PublicKeyCredentialRequestOptionsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PublicKeyCredentialRequestOptions::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, PublicKeyCredentialRequestOptions::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, PublicKeyCredentialRequestOptions::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PublicKeyCredentialRequestOptions::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PublicKeyCredentialRequestOptions::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PublicKeyCredentialRequestOptions::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PublicKeyCredentialRequestOptions_UnserializedMessageContext<
            UserType, PublicKeyCredentialRequestOptions::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<PublicKeyCredentialRequestOptions::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return PublicKeyCredentialRequestOptions::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PublicKeyCredentialRequestOptions_UnserializedMessageContext<
            UserType, PublicKeyCredentialRequestOptions::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PublicKeyCredentialRequestOptions::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::optional<std::vector<uint8_t>> challenge;
  
  std::optional<::GURL> challenge_url;
  
  std::optional<::base::TimeDelta> timeout;
  
  std::string relying_party_id;
  
  std::vector<::device::PublicKeyCredentialDescriptor> allow_credentials;
  
  std::vector<Hint> hints;
  
  ::device::UserVerificationRequirement user_verification;
  
  AuthenticationExtensionsClientInputsPtr extensions;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PublicKeyCredentialRequestOptions::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PublicKeyCredentialRequestOptions::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PublicKeyCredentialRequestOptions::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PublicKeyCredentialRequestOptions::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_COMMON_EXPORT AuthenticationExtensionsClientInputs {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AuthenticationExtensionsClientInputs, T>::value>;
  using DataView = AuthenticationExtensionsClientInputsDataView;
  using Data_ = internal::AuthenticationExtensionsClientInputs_Data;

  template <typename... Args>
  static AuthenticationExtensionsClientInputsPtr New(Args&&... args) {
    return AuthenticationExtensionsClientInputsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AuthenticationExtensionsClientInputsPtr From(const U& u) {
    return mojo::TypeConverter<AuthenticationExtensionsClientInputsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AuthenticationExtensionsClientInputs>::Convert(*this);
  }


  AuthenticationExtensionsClientInputs();

  AuthenticationExtensionsClientInputs(
      const std::optional<std::string>& appid,
      std::vector<::device::CableDiscoveryData> cable_authentication_data,
      bool prf,
      std::vector<PRFValuesPtr> prf_inputs,
      bool large_blob_read,
      std::optional<std::vector<uint8_t>> large_blob_write,
      bool get_cred_blob,
      RemoteDesktopClientOverridePtr remote_desktop_client_override,
      SupplementalPubKeysRequestPtr supplemental_pub_keys,
      std::optional<std::vector<::device::PublicKeyCredentialParams::CredentialInfo>> payment_browser_bound_key_parameters);

AuthenticationExtensionsClientInputs(const AuthenticationExtensionsClientInputs&) = delete;
AuthenticationExtensionsClientInputs& operator=(const AuthenticationExtensionsClientInputs&) = delete;

  ~AuthenticationExtensionsClientInputs();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AuthenticationExtensionsClientInputsPtr>
  AuthenticationExtensionsClientInputsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AuthenticationExtensionsClientInputs::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AuthenticationExtensionsClientInputs::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AuthenticationExtensionsClientInputs::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AuthenticationExtensionsClientInputs::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AuthenticationExtensionsClientInputs::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AuthenticationExtensionsClientInputs::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AuthenticationExtensionsClientInputs_UnserializedMessageContext<
            UserType, AuthenticationExtensionsClientInputs::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AuthenticationExtensionsClientInputs::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AuthenticationExtensionsClientInputs::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AuthenticationExtensionsClientInputs_UnserializedMessageContext<
            UserType, AuthenticationExtensionsClientInputs::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AuthenticationExtensionsClientInputs::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::optional<std::string> appid;
  
  std::vector<::device::CableDiscoveryData> cable_authentication_data;
  
  bool prf;
  
  std::vector<PRFValuesPtr> prf_inputs;
  
  bool large_blob_read;
  
  std::optional<std::vector<uint8_t>> large_blob_write;
  
  bool get_cred_blob;
  
  RemoteDesktopClientOverridePtr remote_desktop_client_override;
  
  SupplementalPubKeysRequestPtr supplemental_pub_keys;
  
  std::optional<std::vector<::device::PublicKeyCredentialParams::CredentialInfo>> payment_browser_bound_key_parameters;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AuthenticationExtensionsClientInputs::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AuthenticationExtensionsClientInputs::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AuthenticationExtensionsClientInputs::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AuthenticationExtensionsClientInputs::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_COMMON_EXPORT GetCredentialOptions {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<GetCredentialOptions, T>::value>;
  using DataView = GetCredentialOptionsDataView;
  using Data_ = internal::GetCredentialOptions_Data;

  template <typename... Args>
  static GetCredentialOptionsPtr New(Args&&... args) {
    return GetCredentialOptionsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static GetCredentialOptionsPtr From(const U& u) {
    return mojo::TypeConverter<GetCredentialOptionsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, GetCredentialOptions>::Convert(*this);
  }


  GetCredentialOptions();

  GetCredentialOptions(
      Mediation mediation,
      PublicKeyCredentialRequestOptionsPtr public_key,
      bool password);

GetCredentialOptions(const GetCredentialOptions&) = delete;
GetCredentialOptions& operator=(const GetCredentialOptions&) = delete;

  ~GetCredentialOptions();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = GetCredentialOptionsPtr>
  GetCredentialOptionsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, GetCredentialOptions::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, GetCredentialOptions::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, GetCredentialOptions::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        GetCredentialOptions::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        GetCredentialOptions::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        GetCredentialOptions::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::GetCredentialOptions_UnserializedMessageContext<
            UserType, GetCredentialOptions::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<GetCredentialOptions::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return GetCredentialOptions::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::GetCredentialOptions_UnserializedMessageContext<
            UserType, GetCredentialOptions::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<GetCredentialOptions::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  Mediation mediation;
  
  PublicKeyCredentialRequestOptionsPtr public_key;
  
  bool password;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, GetCredentialOptions::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, GetCredentialOptions::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, GetCredentialOptions::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, GetCredentialOptions::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class BLINK_COMMON_EXPORT PublicKeyCredentialCreationOptions {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PublicKeyCredentialCreationOptions, T>::value>;
  using DataView = PublicKeyCredentialCreationOptionsDataView;
  using Data_ = internal::PublicKeyCredentialCreationOptions_Data;

  template <typename... Args>
  static PublicKeyCredentialCreationOptionsPtr New(Args&&... args) {
    return PublicKeyCredentialCreationOptionsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PublicKeyCredentialCreationOptionsPtr From(const U& u) {
    return mojo::TypeConverter<PublicKeyCredentialCreationOptionsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PublicKeyCredentialCreationOptions>::Convert(*this);
  }


  PublicKeyCredentialCreationOptions();

  PublicKeyCredentialCreationOptions(
      const ::device::PublicKeyCredentialRpEntity& relying_party,
      const ::device::PublicKeyCredentialUserEntity& user,
      std::vector<uint8_t> challenge,
      std::vector<::device::PublicKeyCredentialParams::CredentialInfo> public_key_parameters,
      std::optional<::base::TimeDelta> timeout,
      std::vector<::device::PublicKeyCredentialDescriptor> exclude_credentials,
      const std::optional<::device::AuthenticatorSelectionCriteria>& authenticator_selection,
      std::vector<Hint> hints,
      ::device::AttestationConveyancePreference attestation,
      bool hmac_create_secret,
      bool prf_enable,
      PRFValuesPtr prf_input,
      ProtectionPolicy protection_policy,
      bool enforce_protection_policy,
      const std::optional<std::string>& appid_exclude,
      bool cred_props,
      ::device::LargeBlobSupport large_blob_enable,
      bool is_payment_credential_creation,
      std::optional<std::vector<uint8_t>> cred_blob,
      bool min_pin_length_requested,
      RemoteDesktopClientOverridePtr remote_desktop_client_override,
      SupplementalPubKeysRequestPtr supplemental_pub_keys,
      std::optional<std::vector<::device::PublicKeyCredentialParams::CredentialInfo>> payment_browser_bound_key_parameters,
      std::vector<std::string> attestation_formats,
      bool is_conditional);

PublicKeyCredentialCreationOptions(const PublicKeyCredentialCreationOptions&) = delete;
PublicKeyCredentialCreationOptions& operator=(const PublicKeyCredentialCreationOptions&) = delete;

  ~PublicKeyCredentialCreationOptions();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PublicKeyCredentialCreationOptionsPtr>
  PublicKeyCredentialCreationOptionsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PublicKeyCredentialCreationOptions::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, PublicKeyCredentialCreationOptions::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, PublicKeyCredentialCreationOptions::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PublicKeyCredentialCreationOptions::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PublicKeyCredentialCreationOptions::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PublicKeyCredentialCreationOptions::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PublicKeyCredentialCreationOptions_UnserializedMessageContext<
            UserType, PublicKeyCredentialCreationOptions::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<PublicKeyCredentialCreationOptions::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return PublicKeyCredentialCreationOptions::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PublicKeyCredentialCreationOptions_UnserializedMessageContext<
            UserType, PublicKeyCredentialCreationOptions::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PublicKeyCredentialCreationOptions::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::device::PublicKeyCredentialRpEntity relying_party;
  
  ::device::PublicKeyCredentialUserEntity user;
  
  std::vector<uint8_t> challenge;
  
  std::vector<::device::PublicKeyCredentialParams::CredentialInfo> public_key_parameters;
  
  std::optional<::base::TimeDelta> timeout;
  
  std::vector<::device::PublicKeyCredentialDescriptor> exclude_credentials;
  
  std::optional<::device::AuthenticatorSelectionCriteria> authenticator_selection;
  
  std::vector<Hint> hints;
  
  ::device::AttestationConveyancePreference attestation;
  
  bool hmac_create_secret;
  
  bool prf_enable;
  
  PRFValuesPtr prf_input;
  
  ProtectionPolicy protection_policy;
  
  bool enforce_protection_policy;
  
  std::optional<std::string> appid_exclude;
  
  bool cred_props;
  
  ::device::LargeBlobSupport large_blob_enable;
  
  bool is_payment_credential_creation;
  
  std::optional<std::vector<uint8_t>> cred_blob;
  
  bool min_pin_length_requested;
  
  RemoteDesktopClientOverridePtr remote_desktop_client_override;
  
  SupplementalPubKeysRequestPtr supplemental_pub_keys;
  
  std::optional<std::vector<::device::PublicKeyCredentialParams::CredentialInfo>> payment_browser_bound_key_parameters;
  
  std::vector<std::string> attestation_formats;
  
  bool is_conditional;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PublicKeyCredentialCreationOptions::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PublicKeyCredentialCreationOptions::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PublicKeyCredentialCreationOptions::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PublicKeyCredentialCreationOptions::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_COMMON_EXPORT PublicKeyCredentialDescriptor {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PublicKeyCredentialDescriptor, T>::value>;
  using DataView = PublicKeyCredentialDescriptorDataView;
  using Data_ = internal::PublicKeyCredentialDescriptor_Data;

  template <typename... Args>
  static PublicKeyCredentialDescriptorPtr New(Args&&... args) {
    return PublicKeyCredentialDescriptorPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PublicKeyCredentialDescriptorPtr From(const U& u) {
    return mojo::TypeConverter<PublicKeyCredentialDescriptorPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PublicKeyCredentialDescriptor>::Convert(*this);
  }


  PublicKeyCredentialDescriptor();

  PublicKeyCredentialDescriptor(
      ::device::CredentialType type,
      std::vector<uint8_t> id,
      std::vector<::device::FidoTransportProtocol> transports);


  ~PublicKeyCredentialDescriptor();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PublicKeyCredentialDescriptorPtr>
  PublicKeyCredentialDescriptorPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PublicKeyCredentialDescriptor::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, PublicKeyCredentialDescriptor::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, PublicKeyCredentialDescriptor::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PublicKeyCredentialDescriptor::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PublicKeyCredentialDescriptor::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PublicKeyCredentialDescriptor::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PublicKeyCredentialDescriptor_UnserializedMessageContext<
            UserType, PublicKeyCredentialDescriptor::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<PublicKeyCredentialDescriptor::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return PublicKeyCredentialDescriptor::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PublicKeyCredentialDescriptor_UnserializedMessageContext<
            UserType, PublicKeyCredentialDescriptor::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PublicKeyCredentialDescriptor::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::device::CredentialType type;
  
  std::vector<uint8_t> id;
  
  std::vector<::device::FidoTransportProtocol> transports;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PublicKeyCredentialDescriptor::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PublicKeyCredentialDescriptor::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PublicKeyCredentialDescriptor::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PublicKeyCredentialDescriptor::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class BLINK_COMMON_EXPORT PublicKeyCredentialReportOptions {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PublicKeyCredentialReportOptions, T>::value>;
  using DataView = PublicKeyCredentialReportOptionsDataView;
  using Data_ = internal::PublicKeyCredentialReportOptions_Data;

  template <typename... Args>
  static PublicKeyCredentialReportOptionsPtr New(Args&&... args) {
    return PublicKeyCredentialReportOptionsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PublicKeyCredentialReportOptionsPtr From(const U& u) {
    return mojo::TypeConverter<PublicKeyCredentialReportOptionsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PublicKeyCredentialReportOptions>::Convert(*this);
  }


  PublicKeyCredentialReportOptions();

  PublicKeyCredentialReportOptions(
      const std::string& relying_party_id,
      std::optional<std::vector<uint8_t>> unknown_credential_id,
      AllAcceptedCredentialsOptionsPtr all_accepted_credentials,
      CurrentUserDetailsOptionsPtr current_user_details);

PublicKeyCredentialReportOptions(const PublicKeyCredentialReportOptions&) = delete;
PublicKeyCredentialReportOptions& operator=(const PublicKeyCredentialReportOptions&) = delete;

  ~PublicKeyCredentialReportOptions();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PublicKeyCredentialReportOptionsPtr>
  PublicKeyCredentialReportOptionsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PublicKeyCredentialReportOptions::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, PublicKeyCredentialReportOptions::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, PublicKeyCredentialReportOptions::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PublicKeyCredentialReportOptions::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PublicKeyCredentialReportOptions::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PublicKeyCredentialReportOptions::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PublicKeyCredentialReportOptions_UnserializedMessageContext<
            UserType, PublicKeyCredentialReportOptions::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<PublicKeyCredentialReportOptions::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return PublicKeyCredentialReportOptions::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PublicKeyCredentialReportOptions_UnserializedMessageContext<
            UserType, PublicKeyCredentialReportOptions::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PublicKeyCredentialReportOptions::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string relying_party_id;
  
  std::optional<std::vector<uint8_t>> unknown_credential_id;
  
  AllAcceptedCredentialsOptionsPtr all_accepted_credentials;
  
  CurrentUserDetailsOptionsPtr current_user_details;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PublicKeyCredentialReportOptions::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PublicKeyCredentialReportOptions::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PublicKeyCredentialReportOptions::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PublicKeyCredentialReportOptions::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_COMMON_EXPORT AllAcceptedCredentialsOptions {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AllAcceptedCredentialsOptions, T>::value>;
  using DataView = AllAcceptedCredentialsOptionsDataView;
  using Data_ = internal::AllAcceptedCredentialsOptions_Data;

  template <typename... Args>
  static AllAcceptedCredentialsOptionsPtr New(Args&&... args) {
    return AllAcceptedCredentialsOptionsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AllAcceptedCredentialsOptionsPtr From(const U& u) {
    return mojo::TypeConverter<AllAcceptedCredentialsOptionsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AllAcceptedCredentialsOptions>::Convert(*this);
  }


  AllAcceptedCredentialsOptions();

  AllAcceptedCredentialsOptions(
      std::vector<uint8_t> user_id,
      std::vector<std::vector<uint8_t>> all_accepted_credentials_ids);


  ~AllAcceptedCredentialsOptions();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AllAcceptedCredentialsOptionsPtr>
  AllAcceptedCredentialsOptionsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AllAcceptedCredentialsOptions::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AllAcceptedCredentialsOptions::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AllAcceptedCredentialsOptions::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AllAcceptedCredentialsOptions::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AllAcceptedCredentialsOptions::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AllAcceptedCredentialsOptions::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AllAcceptedCredentialsOptions_UnserializedMessageContext<
            UserType, AllAcceptedCredentialsOptions::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AllAcceptedCredentialsOptions::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AllAcceptedCredentialsOptions::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AllAcceptedCredentialsOptions_UnserializedMessageContext<
            UserType, AllAcceptedCredentialsOptions::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AllAcceptedCredentialsOptions::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::vector<uint8_t> user_id;
  
  std::vector<std::vector<uint8_t>> all_accepted_credentials_ids;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AllAcceptedCredentialsOptions::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AllAcceptedCredentialsOptions::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AllAcceptedCredentialsOptions::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AllAcceptedCredentialsOptions::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_COMMON_EXPORT CurrentUserDetailsOptions {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<CurrentUserDetailsOptions, T>::value>;
  using DataView = CurrentUserDetailsOptionsDataView;
  using Data_ = internal::CurrentUserDetailsOptions_Data;

  template <typename... Args>
  static CurrentUserDetailsOptionsPtr New(Args&&... args) {
    return CurrentUserDetailsOptionsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static CurrentUserDetailsOptionsPtr From(const U& u) {
    return mojo::TypeConverter<CurrentUserDetailsOptionsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CurrentUserDetailsOptions>::Convert(*this);
  }


  CurrentUserDetailsOptions();

  CurrentUserDetailsOptions(
      std::vector<uint8_t> user_id,
      const std::string& name,
      const std::string& display_name);


  ~CurrentUserDetailsOptions();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = CurrentUserDetailsOptionsPtr>
  CurrentUserDetailsOptionsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, CurrentUserDetailsOptions::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, CurrentUserDetailsOptions::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, CurrentUserDetailsOptions::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CurrentUserDetailsOptions::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CurrentUserDetailsOptions::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CurrentUserDetailsOptions::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::CurrentUserDetailsOptions_UnserializedMessageContext<
            UserType, CurrentUserDetailsOptions::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<CurrentUserDetailsOptions::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return CurrentUserDetailsOptions::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::CurrentUserDetailsOptions_UnserializedMessageContext<
            UserType, CurrentUserDetailsOptions::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<CurrentUserDetailsOptions::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::vector<uint8_t> user_id;
  
  std::string name;
  
  std::string display_name;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, CurrentUserDetailsOptions::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, CurrentUserDetailsOptions::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, CurrentUserDetailsOptions::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, CurrentUserDetailsOptions::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class BLINK_COMMON_EXPORT GetAssertionResponse {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<GetAssertionResponse, T>::value>;
  using DataView = GetAssertionResponseDataView;
  using Data_ = internal::GetAssertionResponse_Data;

  template <typename... Args>
  static GetAssertionResponsePtr New(Args&&... args) {
    return GetAssertionResponsePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static GetAssertionResponsePtr From(const U& u) {
    return mojo::TypeConverter<GetAssertionResponsePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, GetAssertionResponse>::Convert(*this);
  }


  GetAssertionResponse();

  GetAssertionResponse(
      AuthenticatorStatus status,
      GetAssertionAuthenticatorResponsePtr credential,
      WebAuthnDOMExceptionDetailsPtr dom_exception_details);

GetAssertionResponse(const GetAssertionResponse&) = delete;
GetAssertionResponse& operator=(const GetAssertionResponse&) = delete;

  ~GetAssertionResponse();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = GetAssertionResponsePtr>
  GetAssertionResponsePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, GetAssertionResponse::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, GetAssertionResponse::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, GetAssertionResponse::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        GetAssertionResponse::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        GetAssertionResponse::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        GetAssertionResponse::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::GetAssertionResponse_UnserializedMessageContext<
            UserType, GetAssertionResponse::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<GetAssertionResponse::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return GetAssertionResponse::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::GetAssertionResponse_UnserializedMessageContext<
            UserType, GetAssertionResponse::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<GetAssertionResponse::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  AuthenticatorStatus status;
  
  GetAssertionAuthenticatorResponsePtr credential;
  
  WebAuthnDOMExceptionDetailsPtr dom_exception_details;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, GetAssertionResponse::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, GetAssertionResponse::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, GetAssertionResponse::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, GetAssertionResponse::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename UnionPtrType>
GetCredentialResponsePtr GetCredentialResponse::Clone() const {
  switch (tag_) {
    case Tag::kGetAssertionResponse:
      return NewGetAssertionResponse(
          mojo::Clone(data_.get_assertion_response));
    case Tag::kPasswordResponse:
      return NewPasswordResponse(
          mojo::Clone(data_.password_response));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, GetCredentialResponse>::value>::type*>
bool GetCredentialResponse::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kGetAssertionResponse:
      return mojo::Equals(data_.get_assertion_response, other.data_.get_assertion_response);
    case Tag::kPasswordResponse:
      return mojo::Equals(data_.password_response, other.data_.password_response);
  }

  return false;
}
template <typename StructPtrType>
CommonCredentialInfoPtr CommonCredentialInfo::Clone() const {
  return New(
      mojo::Clone(id),
      mojo::Clone(raw_id),
      mojo::Clone(client_data_json),
      mojo::Clone(authenticator_data)
  );
}

template <typename T, CommonCredentialInfo::EnableIfSame<T>*>
bool CommonCredentialInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->id, other_struct.id))
    return false;
  if (!mojo::Equals(this->raw_id, other_struct.raw_id))
    return false;
  if (!mojo::Equals(this->client_data_json, other_struct.client_data_json))
    return false;
  if (!mojo::Equals(this->authenticator_data, other_struct.authenticator_data))
    return false;
  return true;
}

template <typename T, CommonCredentialInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.id < rhs.id)
    return true;
  if (rhs.id < lhs.id)
    return false;
  if (lhs.raw_id < rhs.raw_id)
    return true;
  if (rhs.raw_id < lhs.raw_id)
    return false;
  if (lhs.client_data_json < rhs.client_data_json)
    return true;
  if (rhs.client_data_json < lhs.client_data_json)
    return false;
  if (lhs.authenticator_data < rhs.authenticator_data)
    return true;
  if (rhs.authenticator_data < lhs.authenticator_data)
    return false;
  return false;
}
template <typename StructPtrType>
SupplementalPubKeysResponsePtr SupplementalPubKeysResponse::Clone() const {
  return New(
      mojo::Clone(signatures)
  );
}

template <typename T, SupplementalPubKeysResponse::EnableIfSame<T>*>
bool SupplementalPubKeysResponse::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->signatures, other_struct.signatures))
    return false;
  return true;
}

template <typename T, SupplementalPubKeysResponse::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.signatures < rhs.signatures)
    return true;
  if (rhs.signatures < lhs.signatures)
    return false;
  return false;
}
template <typename StructPtrType>
AuthenticationExtensionsPaymentResponsePtr AuthenticationExtensionsPaymentResponse::Clone() const {
  return New(
      mojo::Clone(browser_bound_signature)
  );
}

template <typename T, AuthenticationExtensionsPaymentResponse::EnableIfSame<T>*>
bool AuthenticationExtensionsPaymentResponse::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->browser_bound_signature, other_struct.browser_bound_signature))
    return false;
  return true;
}

template <typename T, AuthenticationExtensionsPaymentResponse::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.browser_bound_signature < rhs.browser_bound_signature)
    return true;
  if (rhs.browser_bound_signature < lhs.browser_bound_signature)
    return false;
  return false;
}
template <typename StructPtrType>
MakeCredentialAuthenticatorResponsePtr MakeCredentialAuthenticatorResponse::Clone() const {
  return New(
      mojo::Clone(info),
      mojo::Clone(authenticator_attachment),
      mojo::Clone(attestation_object),
      mojo::Clone(transports),
      mojo::Clone(echo_hmac_create_secret),
      mojo::Clone(hmac_create_secret),
      mojo::Clone(echo_prf),
      mojo::Clone(prf),
      mojo::Clone(prf_results),
      mojo::Clone(echo_cred_blob),
      mojo::Clone(cred_blob),
      mojo::Clone(public_key_der),
      mojo::Clone(public_key_algo),
      mojo::Clone(echo_cred_props),
      mojo::Clone(has_cred_props_rk),
      mojo::Clone(cred_props_rk),
      mojo::Clone(echo_large_blob),
      mojo::Clone(supports_large_blob),
      mojo::Clone(supplemental_pub_keys),
      mojo::Clone(payment)
  );
}

template <typename T, MakeCredentialAuthenticatorResponse::EnableIfSame<T>*>
bool MakeCredentialAuthenticatorResponse::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->info, other_struct.info))
    return false;
  if (!mojo::Equals(this->authenticator_attachment, other_struct.authenticator_attachment))
    return false;
  if (!mojo::Equals(this->attestation_object, other_struct.attestation_object))
    return false;
  if (!mojo::Equals(this->transports, other_struct.transports))
    return false;
  if (!mojo::Equals(this->echo_hmac_create_secret, other_struct.echo_hmac_create_secret))
    return false;
  if (!mojo::Equals(this->hmac_create_secret, other_struct.hmac_create_secret))
    return false;
  if (!mojo::Equals(this->echo_prf, other_struct.echo_prf))
    return false;
  if (!mojo::Equals(this->prf, other_struct.prf))
    return false;
  if (!mojo::Equals(this->prf_results, other_struct.prf_results))
    return false;
  if (!mojo::Equals(this->echo_cred_blob, other_struct.echo_cred_blob))
    return false;
  if (!mojo::Equals(this->cred_blob, other_struct.cred_blob))
    return false;
  if (!mojo::Equals(this->public_key_der, other_struct.public_key_der))
    return false;
  if (!mojo::Equals(this->public_key_algo, other_struct.public_key_algo))
    return false;
  if (!mojo::Equals(this->echo_cred_props, other_struct.echo_cred_props))
    return false;
  if (!mojo::Equals(this->has_cred_props_rk, other_struct.has_cred_props_rk))
    return false;
  if (!mojo::Equals(this->cred_props_rk, other_struct.cred_props_rk))
    return false;
  if (!mojo::Equals(this->echo_large_blob, other_struct.echo_large_blob))
    return false;
  if (!mojo::Equals(this->supports_large_blob, other_struct.supports_large_blob))
    return false;
  if (!mojo::Equals(this->supplemental_pub_keys, other_struct.supplemental_pub_keys))
    return false;
  if (!mojo::Equals(this->payment, other_struct.payment))
    return false;
  return true;
}

template <typename T, MakeCredentialAuthenticatorResponse::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.info < rhs.info)
    return true;
  if (rhs.info < lhs.info)
    return false;
  if (lhs.authenticator_attachment < rhs.authenticator_attachment)
    return true;
  if (rhs.authenticator_attachment < lhs.authenticator_attachment)
    return false;
  if (lhs.attestation_object < rhs.attestation_object)
    return true;
  if (rhs.attestation_object < lhs.attestation_object)
    return false;
  if (lhs.transports < rhs.transports)
    return true;
  if (rhs.transports < lhs.transports)
    return false;
  if (lhs.echo_hmac_create_secret < rhs.echo_hmac_create_secret)
    return true;
  if (rhs.echo_hmac_create_secret < lhs.echo_hmac_create_secret)
    return false;
  if (lhs.hmac_create_secret < rhs.hmac_create_secret)
    return true;
  if (rhs.hmac_create_secret < lhs.hmac_create_secret)
    return false;
  if (lhs.echo_prf < rhs.echo_prf)
    return true;
  if (rhs.echo_prf < lhs.echo_prf)
    return false;
  if (lhs.prf < rhs.prf)
    return true;
  if (rhs.prf < lhs.prf)
    return false;
  if (lhs.prf_results < rhs.prf_results)
    return true;
  if (rhs.prf_results < lhs.prf_results)
    return false;
  if (lhs.echo_cred_blob < rhs.echo_cred_blob)
    return true;
  if (rhs.echo_cred_blob < lhs.echo_cred_blob)
    return false;
  if (lhs.cred_blob < rhs.cred_blob)
    return true;
  if (rhs.cred_blob < lhs.cred_blob)
    return false;
  if (lhs.public_key_der < rhs.public_key_der)
    return true;
  if (rhs.public_key_der < lhs.public_key_der)
    return false;
  if (lhs.public_key_algo < rhs.public_key_algo)
    return true;
  if (rhs.public_key_algo < lhs.public_key_algo)
    return false;
  if (lhs.echo_cred_props < rhs.echo_cred_props)
    return true;
  if (rhs.echo_cred_props < lhs.echo_cred_props)
    return false;
  if (lhs.has_cred_props_rk < rhs.has_cred_props_rk)
    return true;
  if (rhs.has_cred_props_rk < lhs.has_cred_props_rk)
    return false;
  if (lhs.cred_props_rk < rhs.cred_props_rk)
    return true;
  if (rhs.cred_props_rk < lhs.cred_props_rk)
    return false;
  if (lhs.echo_large_blob < rhs.echo_large_blob)
    return true;
  if (rhs.echo_large_blob < lhs.echo_large_blob)
    return false;
  if (lhs.supports_large_blob < rhs.supports_large_blob)
    return true;
  if (rhs.supports_large_blob < lhs.supports_large_blob)
    return false;
  if (lhs.supplemental_pub_keys < rhs.supplemental_pub_keys)
    return true;
  if (rhs.supplemental_pub_keys < lhs.supplemental_pub_keys)
    return false;
  if (lhs.payment < rhs.payment)
    return true;
  if (rhs.payment < lhs.payment)
    return false;
  return false;
}
template <typename StructPtrType>
GetAssertionAuthenticatorResponsePtr GetAssertionAuthenticatorResponse::Clone() const {
  return New(
      mojo::Clone(info),
      mojo::Clone(authenticator_attachment),
      mojo::Clone(signature),
      mojo::Clone(user_handle),
      mojo::Clone(extensions)
  );
}

template <typename T, GetAssertionAuthenticatorResponse::EnableIfSame<T>*>
bool GetAssertionAuthenticatorResponse::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->info, other_struct.info))
    return false;
  if (!mojo::Equals(this->authenticator_attachment, other_struct.authenticator_attachment))
    return false;
  if (!mojo::Equals(this->signature, other_struct.signature))
    return false;
  if (!mojo::Equals(this->user_handle, other_struct.user_handle))
    return false;
  if (!mojo::Equals(this->extensions, other_struct.extensions))
    return false;
  return true;
}

template <typename T, GetAssertionAuthenticatorResponse::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.info < rhs.info)
    return true;
  if (rhs.info < lhs.info)
    return false;
  if (lhs.authenticator_attachment < rhs.authenticator_attachment)
    return true;
  if (rhs.authenticator_attachment < lhs.authenticator_attachment)
    return false;
  if (lhs.signature < rhs.signature)
    return true;
  if (rhs.signature < lhs.signature)
    return false;
  if (lhs.user_handle < rhs.user_handle)
    return true;
  if (rhs.user_handle < lhs.user_handle)
    return false;
  if (lhs.extensions < rhs.extensions)
    return true;
  if (rhs.extensions < lhs.extensions)
    return false;
  return false;
}
template <typename StructPtrType>
AuthenticationExtensionsClientOutputsPtr AuthenticationExtensionsClientOutputs::Clone() const {
  return New(
      mojo::Clone(echo_appid_extension),
      mojo::Clone(appid_extension),
      mojo::Clone(echo_prf),
      mojo::Clone(prf_results),
      mojo::Clone(prf_not_evaluated),
      mojo::Clone(echo_large_blob),
      mojo::Clone(large_blob),
      mojo::Clone(echo_large_blob_written),
      mojo::Clone(large_blob_written),
      mojo::Clone(get_cred_blob),
      mojo::Clone(supplemental_pub_keys),
      mojo::Clone(payment)
  );
}

template <typename T, AuthenticationExtensionsClientOutputs::EnableIfSame<T>*>
bool AuthenticationExtensionsClientOutputs::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->echo_appid_extension, other_struct.echo_appid_extension))
    return false;
  if (!mojo::Equals(this->appid_extension, other_struct.appid_extension))
    return false;
  if (!mojo::Equals(this->echo_prf, other_struct.echo_prf))
    return false;
  if (!mojo::Equals(this->prf_results, other_struct.prf_results))
    return false;
  if (!mojo::Equals(this->prf_not_evaluated, other_struct.prf_not_evaluated))
    return false;
  if (!mojo::Equals(this->echo_large_blob, other_struct.echo_large_blob))
    return false;
  if (!mojo::Equals(this->large_blob, other_struct.large_blob))
    return false;
  if (!mojo::Equals(this->echo_large_blob_written, other_struct.echo_large_blob_written))
    return false;
  if (!mojo::Equals(this->large_blob_written, other_struct.large_blob_written))
    return false;
  if (!mojo::Equals(this->get_cred_blob, other_struct.get_cred_blob))
    return false;
  if (!mojo::Equals(this->supplemental_pub_keys, other_struct.supplemental_pub_keys))
    return false;
  if (!mojo::Equals(this->payment, other_struct.payment))
    return false;
  return true;
}

template <typename T, AuthenticationExtensionsClientOutputs::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.echo_appid_extension < rhs.echo_appid_extension)
    return true;
  if (rhs.echo_appid_extension < lhs.echo_appid_extension)
    return false;
  if (lhs.appid_extension < rhs.appid_extension)
    return true;
  if (rhs.appid_extension < lhs.appid_extension)
    return false;
  if (lhs.echo_prf < rhs.echo_prf)
    return true;
  if (rhs.echo_prf < lhs.echo_prf)
    return false;
  if (lhs.prf_results < rhs.prf_results)
    return true;
  if (rhs.prf_results < lhs.prf_results)
    return false;
  if (lhs.prf_not_evaluated < rhs.prf_not_evaluated)
    return true;
  if (rhs.prf_not_evaluated < lhs.prf_not_evaluated)
    return false;
  if (lhs.echo_large_blob < rhs.echo_large_blob)
    return true;
  if (rhs.echo_large_blob < lhs.echo_large_blob)
    return false;
  if (lhs.large_blob < rhs.large_blob)
    return true;
  if (rhs.large_blob < lhs.large_blob)
    return false;
  if (lhs.echo_large_blob_written < rhs.echo_large_blob_written)
    return true;
  if (rhs.echo_large_blob_written < lhs.echo_large_blob_written)
    return false;
  if (lhs.large_blob_written < rhs.large_blob_written)
    return true;
  if (rhs.large_blob_written < lhs.large_blob_written)
    return false;
  if (lhs.get_cred_blob < rhs.get_cred_blob)
    return true;
  if (rhs.get_cred_blob < lhs.get_cred_blob)
    return false;
  if (lhs.supplemental_pub_keys < rhs.supplemental_pub_keys)
    return true;
  if (rhs.supplemental_pub_keys < lhs.supplemental_pub_keys)
    return false;
  if (lhs.payment < rhs.payment)
    return true;
  if (rhs.payment < lhs.payment)
    return false;
  return false;
}
template <typename StructPtrType>
PublicKeyCredentialRpEntityPtr PublicKeyCredentialRpEntity::Clone() const {
  return New(
      mojo::Clone(id),
      mojo::Clone(name)
  );
}

template <typename T, PublicKeyCredentialRpEntity::EnableIfSame<T>*>
bool PublicKeyCredentialRpEntity::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->id, other_struct.id))
    return false;
  if (!mojo::Equals(this->name, other_struct.name))
    return false;
  return true;
}

template <typename T, PublicKeyCredentialRpEntity::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.id < rhs.id)
    return true;
  if (rhs.id < lhs.id)
    return false;
  if (lhs.name < rhs.name)
    return true;
  if (rhs.name < lhs.name)
    return false;
  return false;
}
template <typename StructPtrType>
PublicKeyCredentialUserEntityPtr PublicKeyCredentialUserEntity::Clone() const {
  return New(
      mojo::Clone(id),
      mojo::Clone(name),
      mojo::Clone(display_name)
  );
}

template <typename T, PublicKeyCredentialUserEntity::EnableIfSame<T>*>
bool PublicKeyCredentialUserEntity::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->id, other_struct.id))
    return false;
  if (!mojo::Equals(this->name, other_struct.name))
    return false;
  if (!mojo::Equals(this->display_name, other_struct.display_name))
    return false;
  return true;
}

template <typename T, PublicKeyCredentialUserEntity::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.id < rhs.id)
    return true;
  if (rhs.id < lhs.id)
    return false;
  if (lhs.name < rhs.name)
    return true;
  if (rhs.name < lhs.name)
    return false;
  if (lhs.display_name < rhs.display_name)
    return true;
  if (rhs.display_name < lhs.display_name)
    return false;
  return false;
}
template <typename StructPtrType>
PublicKeyCredentialParametersPtr PublicKeyCredentialParameters::Clone() const {
  return New(
      mojo::Clone(type),
      mojo::Clone(algorithm_identifier)
  );
}

template <typename T, PublicKeyCredentialParameters::EnableIfSame<T>*>
bool PublicKeyCredentialParameters::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->type, other_struct.type))
    return false;
  if (!mojo::Equals(this->algorithm_identifier, other_struct.algorithm_identifier))
    return false;
  return true;
}

template <typename T, PublicKeyCredentialParameters::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.type < rhs.type)
    return true;
  if (rhs.type < lhs.type)
    return false;
  if (lhs.algorithm_identifier < rhs.algorithm_identifier)
    return true;
  if (rhs.algorithm_identifier < lhs.algorithm_identifier)
    return false;
  return false;
}
template <typename StructPtrType>
CableAuthenticationPtr CableAuthentication::Clone() const {
  return New(
      mojo::Clone(version),
      mojo::Clone(client_eid),
      mojo::Clone(authenticator_eid),
      mojo::Clone(session_pre_key),
      mojo::Clone(server_link_data),
      mojo::Clone(experiments)
  );
}

template <typename T, CableAuthentication::EnableIfSame<T>*>
bool CableAuthentication::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->version, other_struct.version))
    return false;
  if (!mojo::Equals(this->client_eid, other_struct.client_eid))
    return false;
  if (!mojo::Equals(this->authenticator_eid, other_struct.authenticator_eid))
    return false;
  if (!mojo::Equals(this->session_pre_key, other_struct.session_pre_key))
    return false;
  if (!mojo::Equals(this->server_link_data, other_struct.server_link_data))
    return false;
  if (!mojo::Equals(this->experiments, other_struct.experiments))
    return false;
  return true;
}

template <typename T, CableAuthentication::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.version < rhs.version)
    return true;
  if (rhs.version < lhs.version)
    return false;
  if (lhs.client_eid < rhs.client_eid)
    return true;
  if (rhs.client_eid < lhs.client_eid)
    return false;
  if (lhs.authenticator_eid < rhs.authenticator_eid)
    return true;
  if (rhs.authenticator_eid < lhs.authenticator_eid)
    return false;
  if (lhs.session_pre_key < rhs.session_pre_key)
    return true;
  if (rhs.session_pre_key < lhs.session_pre_key)
    return false;
  if (lhs.server_link_data < rhs.server_link_data)
    return true;
  if (rhs.server_link_data < lhs.server_link_data)
    return false;
  if (lhs.experiments < rhs.experiments)
    return true;
  if (rhs.experiments < lhs.experiments)
    return false;
  return false;
}
template <typename StructPtrType>
PRFValuesPtr PRFValues::Clone() const {
  return New(
      mojo::Clone(id),
      mojo::Clone(first),
      mojo::Clone(second)
  );
}

template <typename T, PRFValues::EnableIfSame<T>*>
bool PRFValues::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->id, other_struct.id))
    return false;
  if (!mojo::Equals(this->first, other_struct.first))
    return false;
  if (!mojo::Equals(this->second, other_struct.second))
    return false;
  return true;
}

template <typename T, PRFValues::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.id < rhs.id)
    return true;
  if (rhs.id < lhs.id)
    return false;
  if (lhs.first < rhs.first)
    return true;
  if (rhs.first < lhs.first)
    return false;
  if (lhs.second < rhs.second)
    return true;
  if (rhs.second < lhs.second)
    return false;
  return false;
}
template <typename StructPtrType>
PaymentOptionsPtr PaymentOptions::Clone() const {
  return New(
      mojo::Clone(total),
      mojo::Clone(instrument),
      mojo::Clone(payee_name),
      mojo::Clone(payee_origin),
      mojo::Clone(payment_entities_logos),
      mojo::Clone(browser_bound_public_key)
  );
}

template <typename T, PaymentOptions::EnableIfSame<T>*>
bool PaymentOptions::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->total, other_struct.total))
    return false;
  if (!mojo::Equals(this->instrument, other_struct.instrument))
    return false;
  if (!mojo::Equals(this->payee_name, other_struct.payee_name))
    return false;
  if (!mojo::Equals(this->payee_origin, other_struct.payee_origin))
    return false;
  if (!mojo::Equals(this->payment_entities_logos, other_struct.payment_entities_logos))
    return false;
  if (!mojo::Equals(this->browser_bound_public_key, other_struct.browser_bound_public_key))
    return false;
  return true;
}

template <typename T, PaymentOptions::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.total < rhs.total)
    return true;
  if (rhs.total < lhs.total)
    return false;
  if (lhs.instrument < rhs.instrument)
    return true;
  if (rhs.instrument < lhs.instrument)
    return false;
  if (lhs.payee_name < rhs.payee_name)
    return true;
  if (rhs.payee_name < lhs.payee_name)
    return false;
  if (lhs.payee_origin < rhs.payee_origin)
    return true;
  if (rhs.payee_origin < lhs.payee_origin)
    return false;
  if (lhs.payment_entities_logos < rhs.payment_entities_logos)
    return true;
  if (rhs.payment_entities_logos < lhs.payment_entities_logos)
    return false;
  if (lhs.browser_bound_public_key < rhs.browser_bound_public_key)
    return true;
  if (rhs.browser_bound_public_key < lhs.browser_bound_public_key)
    return false;
  return false;
}
template <typename StructPtrType>
PaymentCredentialInstrumentPtr PaymentCredentialInstrument::Clone() const {
  return New(
      mojo::Clone(display_name),
      mojo::Clone(icon),
      mojo::Clone(iconMustBeShown),
      mojo::Clone(details)
  );
}

template <typename T, PaymentCredentialInstrument::EnableIfSame<T>*>
bool PaymentCredentialInstrument::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->display_name, other_struct.display_name))
    return false;
  if (!mojo::Equals(this->icon, other_struct.icon))
    return false;
  if (!mojo::Equals(this->iconMustBeShown, other_struct.iconMustBeShown))
    return false;
  if (!mojo::Equals(this->details, other_struct.details))
    return false;
  return true;
}

template <typename T, PaymentCredentialInstrument::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.display_name < rhs.display_name)
    return true;
  if (rhs.display_name < lhs.display_name)
    return false;
  if (lhs.icon < rhs.icon)
    return true;
  if (rhs.icon < lhs.icon)
    return false;
  if (lhs.iconMustBeShown < rhs.iconMustBeShown)
    return true;
  if (rhs.iconMustBeShown < lhs.iconMustBeShown)
    return false;
  if (lhs.details < rhs.details)
    return true;
  if (rhs.details < lhs.details)
    return false;
  return false;
}
template <typename StructPtrType>
ShownPaymentEntityLogoPtr ShownPaymentEntityLogo::Clone() const {
  return New(
      mojo::Clone(url),
      mojo::Clone(label)
  );
}

template <typename T, ShownPaymentEntityLogo::EnableIfSame<T>*>
bool ShownPaymentEntityLogo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->url, other_struct.url))
    return false;
  if (!mojo::Equals(this->label, other_struct.label))
    return false;
  return true;
}

template <typename T, ShownPaymentEntityLogo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.url < rhs.url)
    return true;
  if (rhs.url < lhs.url)
    return false;
  if (lhs.label < rhs.label)
    return true;
  if (rhs.label < lhs.label)
    return false;
  return false;
}
template <typename StructPtrType>
RemoteDesktopClientOverridePtr RemoteDesktopClientOverride::Clone() const {
  return New(
      mojo::Clone(origin),
      mojo::Clone(same_origin_with_ancestors)
  );
}

template <typename T, RemoteDesktopClientOverride::EnableIfSame<T>*>
bool RemoteDesktopClientOverride::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->origin, other_struct.origin))
    return false;
  if (!mojo::Equals(this->same_origin_with_ancestors, other_struct.same_origin_with_ancestors))
    return false;
  return true;
}

template <typename T, RemoteDesktopClientOverride::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.origin < rhs.origin)
    return true;
  if (rhs.origin < lhs.origin)
    return false;
  if (lhs.same_origin_with_ancestors < rhs.same_origin_with_ancestors)
    return true;
  if (rhs.same_origin_with_ancestors < lhs.same_origin_with_ancestors)
    return false;
  return false;
}
template <typename StructPtrType>
SupplementalPubKeysRequestPtr SupplementalPubKeysRequest::Clone() const {
  return New(
      mojo::Clone(device_scope_requested),
      mojo::Clone(provider_scope_requested),
      mojo::Clone(attestation),
      mojo::Clone(attestation_formats)
  );
}

template <typename T, SupplementalPubKeysRequest::EnableIfSame<T>*>
bool SupplementalPubKeysRequest::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->device_scope_requested, other_struct.device_scope_requested))
    return false;
  if (!mojo::Equals(this->provider_scope_requested, other_struct.provider_scope_requested))
    return false;
  if (!mojo::Equals(this->attestation, other_struct.attestation))
    return false;
  if (!mojo::Equals(this->attestation_formats, other_struct.attestation_formats))
    return false;
  return true;
}

template <typename T, SupplementalPubKeysRequest::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.device_scope_requested < rhs.device_scope_requested)
    return true;
  if (rhs.device_scope_requested < lhs.device_scope_requested)
    return false;
  if (lhs.provider_scope_requested < rhs.provider_scope_requested)
    return true;
  if (rhs.provider_scope_requested < lhs.provider_scope_requested)
    return false;
  if (lhs.attestation < rhs.attestation)
    return true;
  if (rhs.attestation < lhs.attestation)
    return false;
  if (lhs.attestation_formats < rhs.attestation_formats)
    return true;
  if (rhs.attestation_formats < lhs.attestation_formats)
    return false;
  return false;
}
template <typename StructPtrType>
PublicKeyCredentialRequestOptionsPtr PublicKeyCredentialRequestOptions::Clone() const {
  return New(
      mojo::Clone(challenge),
      mojo::Clone(challenge_url),
      mojo::Clone(timeout),
      mojo::Clone(relying_party_id),
      mojo::Clone(allow_credentials),
      mojo::Clone(hints),
      mojo::Clone(user_verification),
      mojo::Clone(extensions)
  );
}

template <typename T, PublicKeyCredentialRequestOptions::EnableIfSame<T>*>
bool PublicKeyCredentialRequestOptions::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->challenge, other_struct.challenge))
    return false;
  if (!mojo::Equals(this->challenge_url, other_struct.challenge_url))
    return false;
  if (!mojo::Equals(this->timeout, other_struct.timeout))
    return false;
  if (!mojo::Equals(this->relying_party_id, other_struct.relying_party_id))
    return false;
  if (!mojo::Equals(this->allow_credentials, other_struct.allow_credentials))
    return false;
  if (!mojo::Equals(this->hints, other_struct.hints))
    return false;
  if (!mojo::Equals(this->user_verification, other_struct.user_verification))
    return false;
  if (!mojo::Equals(this->extensions, other_struct.extensions))
    return false;
  return true;
}

template <typename T, PublicKeyCredentialRequestOptions::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.challenge < rhs.challenge)
    return true;
  if (rhs.challenge < lhs.challenge)
    return false;
  if (lhs.challenge_url < rhs.challenge_url)
    return true;
  if (rhs.challenge_url < lhs.challenge_url)
    return false;
  if (lhs.timeout < rhs.timeout)
    return true;
  if (rhs.timeout < lhs.timeout)
    return false;
  if (lhs.relying_party_id < rhs.relying_party_id)
    return true;
  if (rhs.relying_party_id < lhs.relying_party_id)
    return false;
  if (lhs.allow_credentials < rhs.allow_credentials)
    return true;
  if (rhs.allow_credentials < lhs.allow_credentials)
    return false;
  if (lhs.hints < rhs.hints)
    return true;
  if (rhs.hints < lhs.hints)
    return false;
  if (lhs.user_verification < rhs.user_verification)
    return true;
  if (rhs.user_verification < lhs.user_verification)
    return false;
  if (lhs.extensions < rhs.extensions)
    return true;
  if (rhs.extensions < lhs.extensions)
    return false;
  return false;
}
template <typename StructPtrType>
AuthenticationExtensionsClientInputsPtr AuthenticationExtensionsClientInputs::Clone() const {
  return New(
      mojo::Clone(appid),
      mojo::Clone(cable_authentication_data),
      mojo::Clone(prf),
      mojo::Clone(prf_inputs),
      mojo::Clone(large_blob_read),
      mojo::Clone(large_blob_write),
      mojo::Clone(get_cred_blob),
      mojo::Clone(remote_desktop_client_override),
      mojo::Clone(supplemental_pub_keys),
      mojo::Clone(payment_browser_bound_key_parameters)
  );
}

template <typename T, AuthenticationExtensionsClientInputs::EnableIfSame<T>*>
bool AuthenticationExtensionsClientInputs::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->appid, other_struct.appid))
    return false;
  if (!mojo::Equals(this->cable_authentication_data, other_struct.cable_authentication_data))
    return false;
  if (!mojo::Equals(this->prf, other_struct.prf))
    return false;
  if (!mojo::Equals(this->prf_inputs, other_struct.prf_inputs))
    return false;
  if (!mojo::Equals(this->large_blob_read, other_struct.large_blob_read))
    return false;
  if (!mojo::Equals(this->large_blob_write, other_struct.large_blob_write))
    return false;
  if (!mojo::Equals(this->get_cred_blob, other_struct.get_cred_blob))
    return false;
  if (!mojo::Equals(this->remote_desktop_client_override, other_struct.remote_desktop_client_override))
    return false;
  if (!mojo::Equals(this->supplemental_pub_keys, other_struct.supplemental_pub_keys))
    return false;
  if (!mojo::Equals(this->payment_browser_bound_key_parameters, other_struct.payment_browser_bound_key_parameters))
    return false;
  return true;
}

template <typename T, AuthenticationExtensionsClientInputs::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.appid < rhs.appid)
    return true;
  if (rhs.appid < lhs.appid)
    return false;
  if (lhs.cable_authentication_data < rhs.cable_authentication_data)
    return true;
  if (rhs.cable_authentication_data < lhs.cable_authentication_data)
    return false;
  if (lhs.prf < rhs.prf)
    return true;
  if (rhs.prf < lhs.prf)
    return false;
  if (lhs.prf_inputs < rhs.prf_inputs)
    return true;
  if (rhs.prf_inputs < lhs.prf_inputs)
    return false;
  if (lhs.large_blob_read < rhs.large_blob_read)
    return true;
  if (rhs.large_blob_read < lhs.large_blob_read)
    return false;
  if (lhs.large_blob_write < rhs.large_blob_write)
    return true;
  if (rhs.large_blob_write < lhs.large_blob_write)
    return false;
  if (lhs.get_cred_blob < rhs.get_cred_blob)
    return true;
  if (rhs.get_cred_blob < lhs.get_cred_blob)
    return false;
  if (lhs.remote_desktop_client_override < rhs.remote_desktop_client_override)
    return true;
  if (rhs.remote_desktop_client_override < lhs.remote_desktop_client_override)
    return false;
  if (lhs.supplemental_pub_keys < rhs.supplemental_pub_keys)
    return true;
  if (rhs.supplemental_pub_keys < lhs.supplemental_pub_keys)
    return false;
  if (lhs.payment_browser_bound_key_parameters < rhs.payment_browser_bound_key_parameters)
    return true;
  if (rhs.payment_browser_bound_key_parameters < lhs.payment_browser_bound_key_parameters)
    return false;
  return false;
}
template <typename StructPtrType>
GetCredentialOptionsPtr GetCredentialOptions::Clone() const {
  return New(
      mojo::Clone(mediation),
      mojo::Clone(public_key),
      mojo::Clone(password)
  );
}

template <typename T, GetCredentialOptions::EnableIfSame<T>*>
bool GetCredentialOptions::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->mediation, other_struct.mediation))
    return false;
  if (!mojo::Equals(this->public_key, other_struct.public_key))
    return false;
  if (!mojo::Equals(this->password, other_struct.password))
    return false;
  return true;
}

template <typename T, GetCredentialOptions::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.mediation < rhs.mediation)
    return true;
  if (rhs.mediation < lhs.mediation)
    return false;
  if (lhs.public_key < rhs.public_key)
    return true;
  if (rhs.public_key < lhs.public_key)
    return false;
  if (lhs.password < rhs.password)
    return true;
  if (rhs.password < lhs.password)
    return false;
  return false;
}
template <typename StructPtrType>
AuthenticatorSelectionCriteriaPtr AuthenticatorSelectionCriteria::Clone() const {
  return New(
      mojo::Clone(authenticator_attachment),
      mojo::Clone(resident_key),
      mojo::Clone(user_verification)
  );
}

template <typename T, AuthenticatorSelectionCriteria::EnableIfSame<T>*>
bool AuthenticatorSelectionCriteria::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->authenticator_attachment, other_struct.authenticator_attachment))
    return false;
  if (!mojo::Equals(this->resident_key, other_struct.resident_key))
    return false;
  if (!mojo::Equals(this->user_verification, other_struct.user_verification))
    return false;
  return true;
}

template <typename T, AuthenticatorSelectionCriteria::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.authenticator_attachment < rhs.authenticator_attachment)
    return true;
  if (rhs.authenticator_attachment < lhs.authenticator_attachment)
    return false;
  if (lhs.resident_key < rhs.resident_key)
    return true;
  if (rhs.resident_key < lhs.resident_key)
    return false;
  if (lhs.user_verification < rhs.user_verification)
    return true;
  if (rhs.user_verification < lhs.user_verification)
    return false;
  return false;
}
template <typename StructPtrType>
PublicKeyCredentialCreationOptionsPtr PublicKeyCredentialCreationOptions::Clone() const {
  return New(
      mojo::Clone(relying_party),
      mojo::Clone(user),
      mojo::Clone(challenge),
      mojo::Clone(public_key_parameters),
      mojo::Clone(timeout),
      mojo::Clone(exclude_credentials),
      mojo::Clone(authenticator_selection),
      mojo::Clone(hints),
      mojo::Clone(attestation),
      mojo::Clone(hmac_create_secret),
      mojo::Clone(prf_enable),
      mojo::Clone(prf_input),
      mojo::Clone(protection_policy),
      mojo::Clone(enforce_protection_policy),
      mojo::Clone(appid_exclude),
      mojo::Clone(cred_props),
      mojo::Clone(large_blob_enable),
      mojo::Clone(is_payment_credential_creation),
      mojo::Clone(cred_blob),
      mojo::Clone(min_pin_length_requested),
      mojo::Clone(remote_desktop_client_override),
      mojo::Clone(supplemental_pub_keys),
      mojo::Clone(payment_browser_bound_key_parameters),
      mojo::Clone(attestation_formats),
      mojo::Clone(is_conditional)
  );
}

template <typename T, PublicKeyCredentialCreationOptions::EnableIfSame<T>*>
bool PublicKeyCredentialCreationOptions::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->relying_party, other_struct.relying_party))
    return false;
  if (!mojo::Equals(this->user, other_struct.user))
    return false;
  if (!mojo::Equals(this->challenge, other_struct.challenge))
    return false;
  if (!mojo::Equals(this->public_key_parameters, other_struct.public_key_parameters))
    return false;
  if (!mojo::Equals(this->timeout, other_struct.timeout))
    return false;
  if (!mojo::Equals(this->exclude_credentials, other_struct.exclude_credentials))
    return false;
  if (!mojo::Equals(this->authenticator_selection, other_struct.authenticator_selection))
    return false;
  if (!mojo::Equals(this->hints, other_struct.hints))
    return false;
  if (!mojo::Equals(this->attestation, other_struct.attestation))
    return false;
  if (!mojo::Equals(this->hmac_create_secret, other_struct.hmac_create_secret))
    return false;
  if (!mojo::Equals(this->prf_enable, other_struct.prf_enable))
    return false;
  if (!mojo::Equals(this->prf_input, other_struct.prf_input))
    return false;
  if (!mojo::Equals(this->protection_policy, other_struct.protection_policy))
    return false;
  if (!mojo::Equals(this->enforce_protection_policy, other_struct.enforce_protection_policy))
    return false;
  if (!mojo::Equals(this->appid_exclude, other_struct.appid_exclude))
    return false;
  if (!mojo::Equals(this->cred_props, other_struct.cred_props))
    return false;
  if (!mojo::Equals(this->large_blob_enable, other_struct.large_blob_enable))
    return false;
  if (!mojo::Equals(this->is_payment_credential_creation, other_struct.is_payment_credential_creation))
    return false;
  if (!mojo::Equals(this->cred_blob, other_struct.cred_blob))
    return false;
  if (!mojo::Equals(this->min_pin_length_requested, other_struct.min_pin_length_requested))
    return false;
  if (!mojo::Equals(this->remote_desktop_client_override, other_struct.remote_desktop_client_override))
    return false;
  if (!mojo::Equals(this->supplemental_pub_keys, other_struct.supplemental_pub_keys))
    return false;
  if (!mojo::Equals(this->payment_browser_bound_key_parameters, other_struct.payment_browser_bound_key_parameters))
    return false;
  if (!mojo::Equals(this->attestation_formats, other_struct.attestation_formats))
    return false;
  if (!mojo::Equals(this->is_conditional, other_struct.is_conditional))
    return false;
  return true;
}

template <typename T, PublicKeyCredentialCreationOptions::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.relying_party < rhs.relying_party)
    return true;
  if (rhs.relying_party < lhs.relying_party)
    return false;
  if (lhs.user < rhs.user)
    return true;
  if (rhs.user < lhs.user)
    return false;
  if (lhs.challenge < rhs.challenge)
    return true;
  if (rhs.challenge < lhs.challenge)
    return false;
  if (lhs.public_key_parameters < rhs.public_key_parameters)
    return true;
  if (rhs.public_key_parameters < lhs.public_key_parameters)
    return false;
  if (lhs.timeout < rhs.timeout)
    return true;
  if (rhs.timeout < lhs.timeout)
    return false;
  if (lhs.exclude_credentials < rhs.exclude_credentials)
    return true;
  if (rhs.exclude_credentials < lhs.exclude_credentials)
    return false;
  if (lhs.authenticator_selection < rhs.authenticator_selection)
    return true;
  if (rhs.authenticator_selection < lhs.authenticator_selection)
    return false;
  if (lhs.hints < rhs.hints)
    return true;
  if (rhs.hints < lhs.hints)
    return false;
  if (lhs.attestation < rhs.attestation)
    return true;
  if (rhs.attestation < lhs.attestation)
    return false;
  if (lhs.hmac_create_secret < rhs.hmac_create_secret)
    return true;
  if (rhs.hmac_create_secret < lhs.hmac_create_secret)
    return false;
  if (lhs.prf_enable < rhs.prf_enable)
    return true;
  if (rhs.prf_enable < lhs.prf_enable)
    return false;
  if (lhs.prf_input < rhs.prf_input)
    return true;
  if (rhs.prf_input < lhs.prf_input)
    return false;
  if (lhs.protection_policy < rhs.protection_policy)
    return true;
  if (rhs.protection_policy < lhs.protection_policy)
    return false;
  if (lhs.enforce_protection_policy < rhs.enforce_protection_policy)
    return true;
  if (rhs.enforce_protection_policy < lhs.enforce_protection_policy)
    return false;
  if (lhs.appid_exclude < rhs.appid_exclude)
    return true;
  if (rhs.appid_exclude < lhs.appid_exclude)
    return false;
  if (lhs.cred_props < rhs.cred_props)
    return true;
  if (rhs.cred_props < lhs.cred_props)
    return false;
  if (lhs.large_blob_enable < rhs.large_blob_enable)
    return true;
  if (rhs.large_blob_enable < lhs.large_blob_enable)
    return false;
  if (lhs.is_payment_credential_creation < rhs.is_payment_credential_creation)
    return true;
  if (rhs.is_payment_credential_creation < lhs.is_payment_credential_creation)
    return false;
  if (lhs.cred_blob < rhs.cred_blob)
    return true;
  if (rhs.cred_blob < lhs.cred_blob)
    return false;
  if (lhs.min_pin_length_requested < rhs.min_pin_length_requested)
    return true;
  if (rhs.min_pin_length_requested < lhs.min_pin_length_requested)
    return false;
  if (lhs.remote_desktop_client_override < rhs.remote_desktop_client_override)
    return true;
  if (rhs.remote_desktop_client_override < lhs.remote_desktop_client_override)
    return false;
  if (lhs.supplemental_pub_keys < rhs.supplemental_pub_keys)
    return true;
  if (rhs.supplemental_pub_keys < lhs.supplemental_pub_keys)
    return false;
  if (lhs.payment_browser_bound_key_parameters < rhs.payment_browser_bound_key_parameters)
    return true;
  if (rhs.payment_browser_bound_key_parameters < lhs.payment_browser_bound_key_parameters)
    return false;
  if (lhs.attestation_formats < rhs.attestation_formats)
    return true;
  if (rhs.attestation_formats < lhs.attestation_formats)
    return false;
  if (lhs.is_conditional < rhs.is_conditional)
    return true;
  if (rhs.is_conditional < lhs.is_conditional)
    return false;
  return false;
}
template <typename StructPtrType>
PublicKeyCredentialDescriptorPtr PublicKeyCredentialDescriptor::Clone() const {
  return New(
      mojo::Clone(type),
      mojo::Clone(id),
      mojo::Clone(transports)
  );
}

template <typename T, PublicKeyCredentialDescriptor::EnableIfSame<T>*>
bool PublicKeyCredentialDescriptor::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->type, other_struct.type))
    return false;
  if (!mojo::Equals(this->id, other_struct.id))
    return false;
  if (!mojo::Equals(this->transports, other_struct.transports))
    return false;
  return true;
}

template <typename T, PublicKeyCredentialDescriptor::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.type < rhs.type)
    return true;
  if (rhs.type < lhs.type)
    return false;
  if (lhs.id < rhs.id)
    return true;
  if (rhs.id < lhs.id)
    return false;
  if (lhs.transports < rhs.transports)
    return true;
  if (rhs.transports < lhs.transports)
    return false;
  return false;
}
template <typename StructPtrType>
WebAuthnDOMExceptionDetailsPtr WebAuthnDOMExceptionDetails::Clone() const {
  return New(
      mojo::Clone(name),
      mojo::Clone(message)
  );
}

template <typename T, WebAuthnDOMExceptionDetails::EnableIfSame<T>*>
bool WebAuthnDOMExceptionDetails::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->name, other_struct.name))
    return false;
  if (!mojo::Equals(this->message, other_struct.message))
    return false;
  return true;
}

template <typename T, WebAuthnDOMExceptionDetails::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.name < rhs.name)
    return true;
  if (rhs.name < lhs.name)
    return false;
  if (lhs.message < rhs.message)
    return true;
  if (rhs.message < lhs.message)
    return false;
  return false;
}
template <typename StructPtrType>
PublicKeyCredentialReportOptionsPtr PublicKeyCredentialReportOptions::Clone() const {
  return New(
      mojo::Clone(relying_party_id),
      mojo::Clone(unknown_credential_id),
      mojo::Clone(all_accepted_credentials),
      mojo::Clone(current_user_details)
  );
}

template <typename T, PublicKeyCredentialReportOptions::EnableIfSame<T>*>
bool PublicKeyCredentialReportOptions::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->relying_party_id, other_struct.relying_party_id))
    return false;
  if (!mojo::Equals(this->unknown_credential_id, other_struct.unknown_credential_id))
    return false;
  if (!mojo::Equals(this->all_accepted_credentials, other_struct.all_accepted_credentials))
    return false;
  if (!mojo::Equals(this->current_user_details, other_struct.current_user_details))
    return false;
  return true;
}

template <typename T, PublicKeyCredentialReportOptions::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.relying_party_id < rhs.relying_party_id)
    return true;
  if (rhs.relying_party_id < lhs.relying_party_id)
    return false;
  if (lhs.unknown_credential_id < rhs.unknown_credential_id)
    return true;
  if (rhs.unknown_credential_id < lhs.unknown_credential_id)
    return false;
  if (lhs.all_accepted_credentials < rhs.all_accepted_credentials)
    return true;
  if (rhs.all_accepted_credentials < lhs.all_accepted_credentials)
    return false;
  if (lhs.current_user_details < rhs.current_user_details)
    return true;
  if (rhs.current_user_details < lhs.current_user_details)
    return false;
  return false;
}
template <typename StructPtrType>
AllAcceptedCredentialsOptionsPtr AllAcceptedCredentialsOptions::Clone() const {
  return New(
      mojo::Clone(user_id),
      mojo::Clone(all_accepted_credentials_ids)
  );
}

template <typename T, AllAcceptedCredentialsOptions::EnableIfSame<T>*>
bool AllAcceptedCredentialsOptions::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->user_id, other_struct.user_id))
    return false;
  if (!mojo::Equals(this->all_accepted_credentials_ids, other_struct.all_accepted_credentials_ids))
    return false;
  return true;
}

template <typename T, AllAcceptedCredentialsOptions::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.user_id < rhs.user_id)
    return true;
  if (rhs.user_id < lhs.user_id)
    return false;
  if (lhs.all_accepted_credentials_ids < rhs.all_accepted_credentials_ids)
    return true;
  if (rhs.all_accepted_credentials_ids < lhs.all_accepted_credentials_ids)
    return false;
  return false;
}
template <typename StructPtrType>
CurrentUserDetailsOptionsPtr CurrentUserDetailsOptions::Clone() const {
  return New(
      mojo::Clone(user_id),
      mojo::Clone(name),
      mojo::Clone(display_name)
  );
}

template <typename T, CurrentUserDetailsOptions::EnableIfSame<T>*>
bool CurrentUserDetailsOptions::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->user_id, other_struct.user_id))
    return false;
  if (!mojo::Equals(this->name, other_struct.name))
    return false;
  if (!mojo::Equals(this->display_name, other_struct.display_name))
    return false;
  return true;
}

template <typename T, CurrentUserDetailsOptions::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.user_id < rhs.user_id)
    return true;
  if (rhs.user_id < lhs.user_id)
    return false;
  if (lhs.name < rhs.name)
    return true;
  if (rhs.name < lhs.name)
    return false;
  if (lhs.display_name < rhs.display_name)
    return true;
  if (rhs.display_name < lhs.display_name)
    return false;
  return false;
}
template <typename StructPtrType>
WebAuthnClientCapabilityPtr WebAuthnClientCapability::Clone() const {
  return New(
      mojo::Clone(name),
      mojo::Clone(supported)
  );
}

template <typename T, WebAuthnClientCapability::EnableIfSame<T>*>
bool WebAuthnClientCapability::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->name, other_struct.name))
    return false;
  if (!mojo::Equals(this->supported, other_struct.supported))
    return false;
  return true;
}

template <typename T, WebAuthnClientCapability::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.name < rhs.name)
    return true;
  if (rhs.name < lhs.name)
    return false;
  if (lhs.supported < rhs.supported)
    return true;
  if (rhs.supported < lhs.supported)
    return false;
  return false;
}
template <typename StructPtrType>
GetAssertionResponsePtr GetAssertionResponse::Clone() const {
  return New(
      mojo::Clone(status),
      mojo::Clone(credential),
      mojo::Clone(dom_exception_details)
  );
}

template <typename T, GetAssertionResponse::EnableIfSame<T>*>
bool GetAssertionResponse::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->status, other_struct.status))
    return false;
  if (!mojo::Equals(this->credential, other_struct.credential))
    return false;
  if (!mojo::Equals(this->dom_exception_details, other_struct.dom_exception_details))
    return false;
  return true;
}

template <typename T, GetAssertionResponse::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.status < rhs.status)
    return true;
  if (rhs.status < lhs.status)
    return false;
  if (lhs.credential < rhs.credential)
    return true;
  if (rhs.credential < lhs.credential)
    return false;
  if (lhs.dom_exception_details < rhs.dom_exception_details)
    return true;
  if (rhs.dom_exception_details < lhs.dom_exception_details)
    return false;
  return false;
}


}  // blink::mojom

namespace mojo {


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::CommonCredentialInfo::DataView,
                                         ::blink::mojom::CommonCredentialInfoPtr> {
  static bool IsNull(const ::blink::mojom::CommonCredentialInfoPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::CommonCredentialInfoPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::CommonCredentialInfo::id)& id(
      const ::blink::mojom::CommonCredentialInfoPtr& input) {
    return input->id;
  }

  static const decltype(::blink::mojom::CommonCredentialInfo::raw_id)& raw_id(
      const ::blink::mojom::CommonCredentialInfoPtr& input) {
    return input->raw_id;
  }

  static const decltype(::blink::mojom::CommonCredentialInfo::client_data_json)& client_data_json(
      const ::blink::mojom::CommonCredentialInfoPtr& input) {
    return input->client_data_json;
  }

  static const decltype(::blink::mojom::CommonCredentialInfo::authenticator_data)& authenticator_data(
      const ::blink::mojom::CommonCredentialInfoPtr& input) {
    return input->authenticator_data;
  }

  static bool Read(::blink::mojom::CommonCredentialInfo::DataView input, ::blink::mojom::CommonCredentialInfoPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::SupplementalPubKeysResponse::DataView,
                                         ::blink::mojom::SupplementalPubKeysResponsePtr> {
  static bool IsNull(const ::blink::mojom::SupplementalPubKeysResponsePtr& input) { return !input; }
  static void SetToNull(::blink::mojom::SupplementalPubKeysResponsePtr* output) { output->reset(); }

  static const decltype(::blink::mojom::SupplementalPubKeysResponse::signatures)& signatures(
      const ::blink::mojom::SupplementalPubKeysResponsePtr& input) {
    return input->signatures;
  }

  static bool Read(::blink::mojom::SupplementalPubKeysResponse::DataView input, ::blink::mojom::SupplementalPubKeysResponsePtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::AuthenticationExtensionsPaymentResponse::DataView,
                                         ::blink::mojom::AuthenticationExtensionsPaymentResponsePtr> {
  static bool IsNull(const ::blink::mojom::AuthenticationExtensionsPaymentResponsePtr& input) { return !input; }
  static void SetToNull(::blink::mojom::AuthenticationExtensionsPaymentResponsePtr* output) { output->reset(); }

  static const decltype(::blink::mojom::AuthenticationExtensionsPaymentResponse::browser_bound_signature)& browser_bound_signature(
      const ::blink::mojom::AuthenticationExtensionsPaymentResponsePtr& input) {
    return input->browser_bound_signature;
  }

  static bool Read(::blink::mojom::AuthenticationExtensionsPaymentResponse::DataView input, ::blink::mojom::AuthenticationExtensionsPaymentResponsePtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::MakeCredentialAuthenticatorResponse::DataView,
                                         ::blink::mojom::MakeCredentialAuthenticatorResponsePtr> {
  static bool IsNull(const ::blink::mojom::MakeCredentialAuthenticatorResponsePtr& input) { return !input; }
  static void SetToNull(::blink::mojom::MakeCredentialAuthenticatorResponsePtr* output) { output->reset(); }

  static const decltype(::blink::mojom::MakeCredentialAuthenticatorResponse::info)& info(
      const ::blink::mojom::MakeCredentialAuthenticatorResponsePtr& input) {
    return input->info;
  }

  static decltype(::blink::mojom::MakeCredentialAuthenticatorResponse::authenticator_attachment) authenticator_attachment(
      const ::blink::mojom::MakeCredentialAuthenticatorResponsePtr& input) {
    return input->authenticator_attachment;
  }

  static const decltype(::blink::mojom::MakeCredentialAuthenticatorResponse::attestation_object)& attestation_object(
      const ::blink::mojom::MakeCredentialAuthenticatorResponsePtr& input) {
    return input->attestation_object;
  }

  static const decltype(::blink::mojom::MakeCredentialAuthenticatorResponse::transports)& transports(
      const ::blink::mojom::MakeCredentialAuthenticatorResponsePtr& input) {
    return input->transports;
  }

  static decltype(::blink::mojom::MakeCredentialAuthenticatorResponse::echo_hmac_create_secret) echo_hmac_create_secret(
      const ::blink::mojom::MakeCredentialAuthenticatorResponsePtr& input) {
    return input->echo_hmac_create_secret;
  }

  static decltype(::blink::mojom::MakeCredentialAuthenticatorResponse::hmac_create_secret) hmac_create_secret(
      const ::blink::mojom::MakeCredentialAuthenticatorResponsePtr& input) {
    return input->hmac_create_secret;
  }

  static decltype(::blink::mojom::MakeCredentialAuthenticatorResponse::echo_prf) echo_prf(
      const ::blink::mojom::MakeCredentialAuthenticatorResponsePtr& input) {
    return input->echo_prf;
  }

  static decltype(::blink::mojom::MakeCredentialAuthenticatorResponse::prf) prf(
      const ::blink::mojom::MakeCredentialAuthenticatorResponsePtr& input) {
    return input->prf;
  }

  static const decltype(::blink::mojom::MakeCredentialAuthenticatorResponse::prf_results)& prf_results(
      const ::blink::mojom::MakeCredentialAuthenticatorResponsePtr& input) {
    return input->prf_results;
  }

  static decltype(::blink::mojom::MakeCredentialAuthenticatorResponse::echo_cred_blob) echo_cred_blob(
      const ::blink::mojom::MakeCredentialAuthenticatorResponsePtr& input) {
    return input->echo_cred_blob;
  }

  static decltype(::blink::mojom::MakeCredentialAuthenticatorResponse::cred_blob) cred_blob(
      const ::blink::mojom::MakeCredentialAuthenticatorResponsePtr& input) {
    return input->cred_blob;
  }

  static const decltype(::blink::mojom::MakeCredentialAuthenticatorResponse::public_key_der)& public_key_der(
      const ::blink::mojom::MakeCredentialAuthenticatorResponsePtr& input) {
    return input->public_key_der;
  }

  static decltype(::blink::mojom::MakeCredentialAuthenticatorResponse::public_key_algo) public_key_algo(
      const ::blink::mojom::MakeCredentialAuthenticatorResponsePtr& input) {
    return input->public_key_algo;
  }

  static decltype(::blink::mojom::MakeCredentialAuthenticatorResponse::echo_cred_props) echo_cred_props(
      const ::blink::mojom::MakeCredentialAuthenticatorResponsePtr& input) {
    return input->echo_cred_props;
  }

  static decltype(::blink::mojom::MakeCredentialAuthenticatorResponse::has_cred_props_rk) has_cred_props_rk(
      const ::blink::mojom::MakeCredentialAuthenticatorResponsePtr& input) {
    return input->has_cred_props_rk;
  }

  static decltype(::blink::mojom::MakeCredentialAuthenticatorResponse::cred_props_rk) cred_props_rk(
      const ::blink::mojom::MakeCredentialAuthenticatorResponsePtr& input) {
    return input->cred_props_rk;
  }

  static decltype(::blink::mojom::MakeCredentialAuthenticatorResponse::echo_large_blob) echo_large_blob(
      const ::blink::mojom::MakeCredentialAuthenticatorResponsePtr& input) {
    return input->echo_large_blob;
  }

  static decltype(::blink::mojom::MakeCredentialAuthenticatorResponse::supports_large_blob) supports_large_blob(
      const ::blink::mojom::MakeCredentialAuthenticatorResponsePtr& input) {
    return input->supports_large_blob;
  }

  static const decltype(::blink::mojom::MakeCredentialAuthenticatorResponse::supplemental_pub_keys)& supplemental_pub_keys(
      const ::blink::mojom::MakeCredentialAuthenticatorResponsePtr& input) {
    return input->supplemental_pub_keys;
  }

  static const decltype(::blink::mojom::MakeCredentialAuthenticatorResponse::payment)& payment(
      const ::blink::mojom::MakeCredentialAuthenticatorResponsePtr& input) {
    return input->payment;
  }

  static bool Read(::blink::mojom::MakeCredentialAuthenticatorResponse::DataView input, ::blink::mojom::MakeCredentialAuthenticatorResponsePtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::GetAssertionAuthenticatorResponse::DataView,
                                         ::blink::mojom::GetAssertionAuthenticatorResponsePtr> {
  static bool IsNull(const ::blink::mojom::GetAssertionAuthenticatorResponsePtr& input) { return !input; }
  static void SetToNull(::blink::mojom::GetAssertionAuthenticatorResponsePtr* output) { output->reset(); }

  static const decltype(::blink::mojom::GetAssertionAuthenticatorResponse::info)& info(
      const ::blink::mojom::GetAssertionAuthenticatorResponsePtr& input) {
    return input->info;
  }

  static decltype(::blink::mojom::GetAssertionAuthenticatorResponse::authenticator_attachment) authenticator_attachment(
      const ::blink::mojom::GetAssertionAuthenticatorResponsePtr& input) {
    return input->authenticator_attachment;
  }

  static const decltype(::blink::mojom::GetAssertionAuthenticatorResponse::signature)& signature(
      const ::blink::mojom::GetAssertionAuthenticatorResponsePtr& input) {
    return input->signature;
  }

  static const decltype(::blink::mojom::GetAssertionAuthenticatorResponse::user_handle)& user_handle(
      const ::blink::mojom::GetAssertionAuthenticatorResponsePtr& input) {
    return input->user_handle;
  }

  static const decltype(::blink::mojom::GetAssertionAuthenticatorResponse::extensions)& extensions(
      const ::blink::mojom::GetAssertionAuthenticatorResponsePtr& input) {
    return input->extensions;
  }

  static bool Read(::blink::mojom::GetAssertionAuthenticatorResponse::DataView input, ::blink::mojom::GetAssertionAuthenticatorResponsePtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::AuthenticationExtensionsClientOutputs::DataView,
                                         ::blink::mojom::AuthenticationExtensionsClientOutputsPtr> {
  static bool IsNull(const ::blink::mojom::AuthenticationExtensionsClientOutputsPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::AuthenticationExtensionsClientOutputsPtr* output) { output->reset(); }

  static decltype(::blink::mojom::AuthenticationExtensionsClientOutputs::echo_appid_extension) echo_appid_extension(
      const ::blink::mojom::AuthenticationExtensionsClientOutputsPtr& input) {
    return input->echo_appid_extension;
  }

  static decltype(::blink::mojom::AuthenticationExtensionsClientOutputs::appid_extension) appid_extension(
      const ::blink::mojom::AuthenticationExtensionsClientOutputsPtr& input) {
    return input->appid_extension;
  }

  static decltype(::blink::mojom::AuthenticationExtensionsClientOutputs::echo_prf) echo_prf(
      const ::blink::mojom::AuthenticationExtensionsClientOutputsPtr& input) {
    return input->echo_prf;
  }

  static const decltype(::blink::mojom::AuthenticationExtensionsClientOutputs::prf_results)& prf_results(
      const ::blink::mojom::AuthenticationExtensionsClientOutputsPtr& input) {
    return input->prf_results;
  }

  static decltype(::blink::mojom::AuthenticationExtensionsClientOutputs::prf_not_evaluated) prf_not_evaluated(
      const ::blink::mojom::AuthenticationExtensionsClientOutputsPtr& input) {
    return input->prf_not_evaluated;
  }

  static decltype(::blink::mojom::AuthenticationExtensionsClientOutputs::echo_large_blob) echo_large_blob(
      const ::blink::mojom::AuthenticationExtensionsClientOutputsPtr& input) {
    return input->echo_large_blob;
  }

  static const decltype(::blink::mojom::AuthenticationExtensionsClientOutputs::large_blob)& large_blob(
      const ::blink::mojom::AuthenticationExtensionsClientOutputsPtr& input) {
    return input->large_blob;
  }

  static decltype(::blink::mojom::AuthenticationExtensionsClientOutputs::echo_large_blob_written) echo_large_blob_written(
      const ::blink::mojom::AuthenticationExtensionsClientOutputsPtr& input) {
    return input->echo_large_blob_written;
  }

  static decltype(::blink::mojom::AuthenticationExtensionsClientOutputs::large_blob_written) large_blob_written(
      const ::blink::mojom::AuthenticationExtensionsClientOutputsPtr& input) {
    return input->large_blob_written;
  }

  static const decltype(::blink::mojom::AuthenticationExtensionsClientOutputs::get_cred_blob)& get_cred_blob(
      const ::blink::mojom::AuthenticationExtensionsClientOutputsPtr& input) {
    return input->get_cred_blob;
  }

  static const decltype(::blink::mojom::AuthenticationExtensionsClientOutputs::supplemental_pub_keys)& supplemental_pub_keys(
      const ::blink::mojom::AuthenticationExtensionsClientOutputsPtr& input) {
    return input->supplemental_pub_keys;
  }

  static const decltype(::blink::mojom::AuthenticationExtensionsClientOutputs::payment)& payment(
      const ::blink::mojom::AuthenticationExtensionsClientOutputsPtr& input) {
    return input->payment;
  }

  static bool Read(::blink::mojom::AuthenticationExtensionsClientOutputs::DataView input, ::blink::mojom::AuthenticationExtensionsClientOutputsPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::PublicKeyCredentialRpEntity::DataView,
                                         ::blink::mojom::PublicKeyCredentialRpEntityPtr> {
  static bool IsNull(const ::blink::mojom::PublicKeyCredentialRpEntityPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::PublicKeyCredentialRpEntityPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::PublicKeyCredentialRpEntity::id)& id(
      const ::blink::mojom::PublicKeyCredentialRpEntityPtr& input) {
    return input->id;
  }

  static const decltype(::blink::mojom::PublicKeyCredentialRpEntity::name)& name(
      const ::blink::mojom::PublicKeyCredentialRpEntityPtr& input) {
    return input->name;
  }

  static bool Read(::blink::mojom::PublicKeyCredentialRpEntity::DataView input, ::blink::mojom::PublicKeyCredentialRpEntityPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::PublicKeyCredentialUserEntity::DataView,
                                         ::blink::mojom::PublicKeyCredentialUserEntityPtr> {
  static bool IsNull(const ::blink::mojom::PublicKeyCredentialUserEntityPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::PublicKeyCredentialUserEntityPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::PublicKeyCredentialUserEntity::id)& id(
      const ::blink::mojom::PublicKeyCredentialUserEntityPtr& input) {
    return input->id;
  }

  static const decltype(::blink::mojom::PublicKeyCredentialUserEntity::name)& name(
      const ::blink::mojom::PublicKeyCredentialUserEntityPtr& input) {
    return input->name;
  }

  static const decltype(::blink::mojom::PublicKeyCredentialUserEntity::display_name)& display_name(
      const ::blink::mojom::PublicKeyCredentialUserEntityPtr& input) {
    return input->display_name;
  }

  static bool Read(::blink::mojom::PublicKeyCredentialUserEntity::DataView input, ::blink::mojom::PublicKeyCredentialUserEntityPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::PublicKeyCredentialParameters::DataView,
                                         ::blink::mojom::PublicKeyCredentialParametersPtr> {
  static bool IsNull(const ::blink::mojom::PublicKeyCredentialParametersPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::PublicKeyCredentialParametersPtr* output) { output->reset(); }

  static decltype(::blink::mojom::PublicKeyCredentialParameters::type) type(
      const ::blink::mojom::PublicKeyCredentialParametersPtr& input) {
    return input->type;
  }

  static decltype(::blink::mojom::PublicKeyCredentialParameters::algorithm_identifier) algorithm_identifier(
      const ::blink::mojom::PublicKeyCredentialParametersPtr& input) {
    return input->algorithm_identifier;
  }

  static bool Read(::blink::mojom::PublicKeyCredentialParameters::DataView input, ::blink::mojom::PublicKeyCredentialParametersPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::CableAuthentication::DataView,
                                         ::blink::mojom::CableAuthenticationPtr> {
  static bool IsNull(const ::blink::mojom::CableAuthenticationPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::CableAuthenticationPtr* output) { output->reset(); }

  static decltype(::blink::mojom::CableAuthentication::version) version(
      const ::blink::mojom::CableAuthenticationPtr& input) {
    return input->version;
  }

  static const decltype(::blink::mojom::CableAuthentication::client_eid)& client_eid(
      const ::blink::mojom::CableAuthenticationPtr& input) {
    return input->client_eid;
  }

  static const decltype(::blink::mojom::CableAuthentication::authenticator_eid)& authenticator_eid(
      const ::blink::mojom::CableAuthenticationPtr& input) {
    return input->authenticator_eid;
  }

  static const decltype(::blink::mojom::CableAuthentication::session_pre_key)& session_pre_key(
      const ::blink::mojom::CableAuthenticationPtr& input) {
    return input->session_pre_key;
  }

  static const decltype(::blink::mojom::CableAuthentication::server_link_data)& server_link_data(
      const ::blink::mojom::CableAuthenticationPtr& input) {
    return input->server_link_data;
  }

  static const decltype(::blink::mojom::CableAuthentication::experiments)& experiments(
      const ::blink::mojom::CableAuthenticationPtr& input) {
    return input->experiments;
  }

  static bool Read(::blink::mojom::CableAuthentication::DataView input, ::blink::mojom::CableAuthenticationPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::PRFValues::DataView,
                                         ::blink::mojom::PRFValuesPtr> {
  static bool IsNull(const ::blink::mojom::PRFValuesPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::PRFValuesPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::PRFValues::id)& id(
      const ::blink::mojom::PRFValuesPtr& input) {
    return input->id;
  }

  static const decltype(::blink::mojom::PRFValues::first)& first(
      const ::blink::mojom::PRFValuesPtr& input) {
    return input->first;
  }

  static const decltype(::blink::mojom::PRFValues::second)& second(
      const ::blink::mojom::PRFValuesPtr& input) {
    return input->second;
  }

  static bool Read(::blink::mojom::PRFValues::DataView input, ::blink::mojom::PRFValuesPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::PaymentOptions::DataView,
                                         ::blink::mojom::PaymentOptionsPtr> {
  static bool IsNull(const ::blink::mojom::PaymentOptionsPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::PaymentOptionsPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::PaymentOptions::total)& total(
      const ::blink::mojom::PaymentOptionsPtr& input) {
    return input->total;
  }

  static const decltype(::blink::mojom::PaymentOptions::instrument)& instrument(
      const ::blink::mojom::PaymentOptionsPtr& input) {
    return input->instrument;
  }

  static const decltype(::blink::mojom::PaymentOptions::payee_name)& payee_name(
      const ::blink::mojom::PaymentOptionsPtr& input) {
    return input->payee_name;
  }

  static const decltype(::blink::mojom::PaymentOptions::payee_origin)& payee_origin(
      const ::blink::mojom::PaymentOptionsPtr& input) {
    return input->payee_origin;
  }

  static const decltype(::blink::mojom::PaymentOptions::payment_entities_logos)& payment_entities_logos(
      const ::blink::mojom::PaymentOptionsPtr& input) {
    return input->payment_entities_logos;
  }

  static const decltype(::blink::mojom::PaymentOptions::browser_bound_public_key)& browser_bound_public_key(
      const ::blink::mojom::PaymentOptionsPtr& input) {
    return input->browser_bound_public_key;
  }

  static bool Read(::blink::mojom::PaymentOptions::DataView input, ::blink::mojom::PaymentOptionsPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::PaymentCredentialInstrument::DataView,
                                         ::blink::mojom::PaymentCredentialInstrumentPtr> {
  static bool IsNull(const ::blink::mojom::PaymentCredentialInstrumentPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::PaymentCredentialInstrumentPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::PaymentCredentialInstrument::display_name)& display_name(
      const ::blink::mojom::PaymentCredentialInstrumentPtr& input) {
    return input->display_name;
  }

  static const decltype(::blink::mojom::PaymentCredentialInstrument::icon)& icon(
      const ::blink::mojom::PaymentCredentialInstrumentPtr& input) {
    return input->icon;
  }

  static decltype(::blink::mojom::PaymentCredentialInstrument::iconMustBeShown) iconMustBeShown(
      const ::blink::mojom::PaymentCredentialInstrumentPtr& input) {
    return input->iconMustBeShown;
  }

  static const decltype(::blink::mojom::PaymentCredentialInstrument::details)& details(
      const ::blink::mojom::PaymentCredentialInstrumentPtr& input) {
    return input->details;
  }

  static bool Read(::blink::mojom::PaymentCredentialInstrument::DataView input, ::blink::mojom::PaymentCredentialInstrumentPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::ShownPaymentEntityLogo::DataView,
                                         ::blink::mojom::ShownPaymentEntityLogoPtr> {
  static bool IsNull(const ::blink::mojom::ShownPaymentEntityLogoPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::ShownPaymentEntityLogoPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::ShownPaymentEntityLogo::url)& url(
      const ::blink::mojom::ShownPaymentEntityLogoPtr& input) {
    return input->url;
  }

  static const decltype(::blink::mojom::ShownPaymentEntityLogo::label)& label(
      const ::blink::mojom::ShownPaymentEntityLogoPtr& input) {
    return input->label;
  }

  static bool Read(::blink::mojom::ShownPaymentEntityLogo::DataView input, ::blink::mojom::ShownPaymentEntityLogoPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::RemoteDesktopClientOverride::DataView,
                                         ::blink::mojom::RemoteDesktopClientOverridePtr> {
  static bool IsNull(const ::blink::mojom::RemoteDesktopClientOverridePtr& input) { return !input; }
  static void SetToNull(::blink::mojom::RemoteDesktopClientOverridePtr* output) { output->reset(); }

  static const decltype(::blink::mojom::RemoteDesktopClientOverride::origin)& origin(
      const ::blink::mojom::RemoteDesktopClientOverridePtr& input) {
    return input->origin;
  }

  static decltype(::blink::mojom::RemoteDesktopClientOverride::same_origin_with_ancestors) same_origin_with_ancestors(
      const ::blink::mojom::RemoteDesktopClientOverridePtr& input) {
    return input->same_origin_with_ancestors;
  }

  static bool Read(::blink::mojom::RemoteDesktopClientOverride::DataView input, ::blink::mojom::RemoteDesktopClientOverridePtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::SupplementalPubKeysRequest::DataView,
                                         ::blink::mojom::SupplementalPubKeysRequestPtr> {
  static bool IsNull(const ::blink::mojom::SupplementalPubKeysRequestPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::SupplementalPubKeysRequestPtr* output) { output->reset(); }

  static decltype(::blink::mojom::SupplementalPubKeysRequest::device_scope_requested) device_scope_requested(
      const ::blink::mojom::SupplementalPubKeysRequestPtr& input) {
    return input->device_scope_requested;
  }

  static decltype(::blink::mojom::SupplementalPubKeysRequest::provider_scope_requested) provider_scope_requested(
      const ::blink::mojom::SupplementalPubKeysRequestPtr& input) {
    return input->provider_scope_requested;
  }

  static decltype(::blink::mojom::SupplementalPubKeysRequest::attestation) attestation(
      const ::blink::mojom::SupplementalPubKeysRequestPtr& input) {
    return input->attestation;
  }

  static const decltype(::blink::mojom::SupplementalPubKeysRequest::attestation_formats)& attestation_formats(
      const ::blink::mojom::SupplementalPubKeysRequestPtr& input) {
    return input->attestation_formats;
  }

  static bool Read(::blink::mojom::SupplementalPubKeysRequest::DataView input, ::blink::mojom::SupplementalPubKeysRequestPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::PublicKeyCredentialRequestOptions::DataView,
                                         ::blink::mojom::PublicKeyCredentialRequestOptionsPtr> {
  static bool IsNull(const ::blink::mojom::PublicKeyCredentialRequestOptionsPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::PublicKeyCredentialRequestOptionsPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::PublicKeyCredentialRequestOptions::challenge)& challenge(
      const ::blink::mojom::PublicKeyCredentialRequestOptionsPtr& input) {
    return input->challenge;
  }

  static const decltype(::blink::mojom::PublicKeyCredentialRequestOptions::challenge_url)& challenge_url(
      const ::blink::mojom::PublicKeyCredentialRequestOptionsPtr& input) {
    return input->challenge_url;
  }

  static const decltype(::blink::mojom::PublicKeyCredentialRequestOptions::timeout)& timeout(
      const ::blink::mojom::PublicKeyCredentialRequestOptionsPtr& input) {
    return input->timeout;
  }

  static const decltype(::blink::mojom::PublicKeyCredentialRequestOptions::relying_party_id)& relying_party_id(
      const ::blink::mojom::PublicKeyCredentialRequestOptionsPtr& input) {
    return input->relying_party_id;
  }

  static const decltype(::blink::mojom::PublicKeyCredentialRequestOptions::allow_credentials)& allow_credentials(
      const ::blink::mojom::PublicKeyCredentialRequestOptionsPtr& input) {
    return input->allow_credentials;
  }

  static const decltype(::blink::mojom::PublicKeyCredentialRequestOptions::hints)& hints(
      const ::blink::mojom::PublicKeyCredentialRequestOptionsPtr& input) {
    return input->hints;
  }

  static decltype(::blink::mojom::PublicKeyCredentialRequestOptions::user_verification) user_verification(
      const ::blink::mojom::PublicKeyCredentialRequestOptionsPtr& input) {
    return input->user_verification;
  }

  static const decltype(::blink::mojom::PublicKeyCredentialRequestOptions::extensions)& extensions(
      const ::blink::mojom::PublicKeyCredentialRequestOptionsPtr& input) {
    return input->extensions;
  }

  static bool Read(::blink::mojom::PublicKeyCredentialRequestOptions::DataView input, ::blink::mojom::PublicKeyCredentialRequestOptionsPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::AuthenticationExtensionsClientInputs::DataView,
                                         ::blink::mojom::AuthenticationExtensionsClientInputsPtr> {
  static bool IsNull(const ::blink::mojom::AuthenticationExtensionsClientInputsPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::AuthenticationExtensionsClientInputsPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::AuthenticationExtensionsClientInputs::appid)& appid(
      const ::blink::mojom::AuthenticationExtensionsClientInputsPtr& input) {
    return input->appid;
  }

  static const decltype(::blink::mojom::AuthenticationExtensionsClientInputs::cable_authentication_data)& cable_authentication_data(
      const ::blink::mojom::AuthenticationExtensionsClientInputsPtr& input) {
    return input->cable_authentication_data;
  }

  static decltype(::blink::mojom::AuthenticationExtensionsClientInputs::prf) prf(
      const ::blink::mojom::AuthenticationExtensionsClientInputsPtr& input) {
    return input->prf;
  }

  static const decltype(::blink::mojom::AuthenticationExtensionsClientInputs::prf_inputs)& prf_inputs(
      const ::blink::mojom::AuthenticationExtensionsClientInputsPtr& input) {
    return input->prf_inputs;
  }

  static decltype(::blink::mojom::AuthenticationExtensionsClientInputs::large_blob_read) large_blob_read(
      const ::blink::mojom::AuthenticationExtensionsClientInputsPtr& input) {
    return input->large_blob_read;
  }

  static const decltype(::blink::mojom::AuthenticationExtensionsClientInputs::large_blob_write)& large_blob_write(
      const ::blink::mojom::AuthenticationExtensionsClientInputsPtr& input) {
    return input->large_blob_write;
  }

  static decltype(::blink::mojom::AuthenticationExtensionsClientInputs::get_cred_blob) get_cred_blob(
      const ::blink::mojom::AuthenticationExtensionsClientInputsPtr& input) {
    return input->get_cred_blob;
  }

  static const decltype(::blink::mojom::AuthenticationExtensionsClientInputs::remote_desktop_client_override)& remote_desktop_client_override(
      const ::blink::mojom::AuthenticationExtensionsClientInputsPtr& input) {
    return input->remote_desktop_client_override;
  }

  static const decltype(::blink::mojom::AuthenticationExtensionsClientInputs::supplemental_pub_keys)& supplemental_pub_keys(
      const ::blink::mojom::AuthenticationExtensionsClientInputsPtr& input) {
    return input->supplemental_pub_keys;
  }

  static const decltype(::blink::mojom::AuthenticationExtensionsClientInputs::payment_browser_bound_key_parameters)& payment_browser_bound_key_parameters(
      const ::blink::mojom::AuthenticationExtensionsClientInputsPtr& input) {
    return input->payment_browser_bound_key_parameters;
  }

  static bool Read(::blink::mojom::AuthenticationExtensionsClientInputs::DataView input, ::blink::mojom::AuthenticationExtensionsClientInputsPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::GetCredentialOptions::DataView,
                                         ::blink::mojom::GetCredentialOptionsPtr> {
  static bool IsNull(const ::blink::mojom::GetCredentialOptionsPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::GetCredentialOptionsPtr* output) { output->reset(); }

  static decltype(::blink::mojom::GetCredentialOptions::mediation) mediation(
      const ::blink::mojom::GetCredentialOptionsPtr& input) {
    return input->mediation;
  }

  static const decltype(::blink::mojom::GetCredentialOptions::public_key)& public_key(
      const ::blink::mojom::GetCredentialOptionsPtr& input) {
    return input->public_key;
  }

  static decltype(::blink::mojom::GetCredentialOptions::password) password(
      const ::blink::mojom::GetCredentialOptionsPtr& input) {
    return input->password;
  }

  static bool Read(::blink::mojom::GetCredentialOptions::DataView input, ::blink::mojom::GetCredentialOptionsPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::AuthenticatorSelectionCriteria::DataView,
                                         ::blink::mojom::AuthenticatorSelectionCriteriaPtr> {
  static bool IsNull(const ::blink::mojom::AuthenticatorSelectionCriteriaPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::AuthenticatorSelectionCriteriaPtr* output) { output->reset(); }

  static decltype(::blink::mojom::AuthenticatorSelectionCriteria::authenticator_attachment) authenticator_attachment(
      const ::blink::mojom::AuthenticatorSelectionCriteriaPtr& input) {
    return input->authenticator_attachment;
  }

  static decltype(::blink::mojom::AuthenticatorSelectionCriteria::resident_key) resident_key(
      const ::blink::mojom::AuthenticatorSelectionCriteriaPtr& input) {
    return input->resident_key;
  }

  static decltype(::blink::mojom::AuthenticatorSelectionCriteria::user_verification) user_verification(
      const ::blink::mojom::AuthenticatorSelectionCriteriaPtr& input) {
    return input->user_verification;
  }

  static bool Read(::blink::mojom::AuthenticatorSelectionCriteria::DataView input, ::blink::mojom::AuthenticatorSelectionCriteriaPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::PublicKeyCredentialCreationOptions::DataView,
                                         ::blink::mojom::PublicKeyCredentialCreationOptionsPtr> {
  static bool IsNull(const ::blink::mojom::PublicKeyCredentialCreationOptionsPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::PublicKeyCredentialCreationOptionsPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::PublicKeyCredentialCreationOptions::relying_party)& relying_party(
      const ::blink::mojom::PublicKeyCredentialCreationOptionsPtr& input) {
    return input->relying_party;
  }

  static const decltype(::blink::mojom::PublicKeyCredentialCreationOptions::user)& user(
      const ::blink::mojom::PublicKeyCredentialCreationOptionsPtr& input) {
    return input->user;
  }

  static const decltype(::blink::mojom::PublicKeyCredentialCreationOptions::challenge)& challenge(
      const ::blink::mojom::PublicKeyCredentialCreationOptionsPtr& input) {
    return input->challenge;
  }

  static const decltype(::blink::mojom::PublicKeyCredentialCreationOptions::public_key_parameters)& public_key_parameters(
      const ::blink::mojom::PublicKeyCredentialCreationOptionsPtr& input) {
    return input->public_key_parameters;
  }

  static const decltype(::blink::mojom::PublicKeyCredentialCreationOptions::timeout)& timeout(
      const ::blink::mojom::PublicKeyCredentialCreationOptionsPtr& input) {
    return input->timeout;
  }

  static const decltype(::blink::mojom::PublicKeyCredentialCreationOptions::exclude_credentials)& exclude_credentials(
      const ::blink::mojom::PublicKeyCredentialCreationOptionsPtr& input) {
    return input->exclude_credentials;
  }

  static const decltype(::blink::mojom::PublicKeyCredentialCreationOptions::authenticator_selection)& authenticator_selection(
      const ::blink::mojom::PublicKeyCredentialCreationOptionsPtr& input) {
    return input->authenticator_selection;
  }

  static const decltype(::blink::mojom::PublicKeyCredentialCreationOptions::hints)& hints(
      const ::blink::mojom::PublicKeyCredentialCreationOptionsPtr& input) {
    return input->hints;
  }

  static decltype(::blink::mojom::PublicKeyCredentialCreationOptions::attestation) attestation(
      const ::blink::mojom::PublicKeyCredentialCreationOptionsPtr& input) {
    return input->attestation;
  }

  static decltype(::blink::mojom::PublicKeyCredentialCreationOptions::hmac_create_secret) hmac_create_secret(
      const ::blink::mojom::PublicKeyCredentialCreationOptionsPtr& input) {
    return input->hmac_create_secret;
  }

  static decltype(::blink::mojom::PublicKeyCredentialCreationOptions::prf_enable) prf_enable(
      const ::blink::mojom::PublicKeyCredentialCreationOptionsPtr& input) {
    return input->prf_enable;
  }

  static const decltype(::blink::mojom::PublicKeyCredentialCreationOptions::prf_input)& prf_input(
      const ::blink::mojom::PublicKeyCredentialCreationOptionsPtr& input) {
    return input->prf_input;
  }

  static decltype(::blink::mojom::PublicKeyCredentialCreationOptions::protection_policy) protection_policy(
      const ::blink::mojom::PublicKeyCredentialCreationOptionsPtr& input) {
    return input->protection_policy;
  }

  static decltype(::blink::mojom::PublicKeyCredentialCreationOptions::enforce_protection_policy) enforce_protection_policy(
      const ::blink::mojom::PublicKeyCredentialCreationOptionsPtr& input) {
    return input->enforce_protection_policy;
  }

  static const decltype(::blink::mojom::PublicKeyCredentialCreationOptions::appid_exclude)& appid_exclude(
      const ::blink::mojom::PublicKeyCredentialCreationOptionsPtr& input) {
    return input->appid_exclude;
  }

  static decltype(::blink::mojom::PublicKeyCredentialCreationOptions::cred_props) cred_props(
      const ::blink::mojom::PublicKeyCredentialCreationOptionsPtr& input) {
    return input->cred_props;
  }

  static decltype(::blink::mojom::PublicKeyCredentialCreationOptions::large_blob_enable) large_blob_enable(
      const ::blink::mojom::PublicKeyCredentialCreationOptionsPtr& input) {
    return input->large_blob_enable;
  }

  static decltype(::blink::mojom::PublicKeyCredentialCreationOptions::is_payment_credential_creation) is_payment_credential_creation(
      const ::blink::mojom::PublicKeyCredentialCreationOptionsPtr& input) {
    return input->is_payment_credential_creation;
  }

  static const decltype(::blink::mojom::PublicKeyCredentialCreationOptions::cred_blob)& cred_blob(
      const ::blink::mojom::PublicKeyCredentialCreationOptionsPtr& input) {
    return input->cred_blob;
  }

  static decltype(::blink::mojom::PublicKeyCredentialCreationOptions::min_pin_length_requested) min_pin_length_requested(
      const ::blink::mojom::PublicKeyCredentialCreationOptionsPtr& input) {
    return input->min_pin_length_requested;
  }

  static const decltype(::blink::mojom::PublicKeyCredentialCreationOptions::remote_desktop_client_override)& remote_desktop_client_override(
      const ::blink::mojom::PublicKeyCredentialCreationOptionsPtr& input) {
    return input->remote_desktop_client_override;
  }

  static const decltype(::blink::mojom::PublicKeyCredentialCreationOptions::supplemental_pub_keys)& supplemental_pub_keys(
      const ::blink::mojom::PublicKeyCredentialCreationOptionsPtr& input) {
    return input->supplemental_pub_keys;
  }

  static const decltype(::blink::mojom::PublicKeyCredentialCreationOptions::payment_browser_bound_key_parameters)& payment_browser_bound_key_parameters(
      const ::blink::mojom::PublicKeyCredentialCreationOptionsPtr& input) {
    return input->payment_browser_bound_key_parameters;
  }

  static const decltype(::blink::mojom::PublicKeyCredentialCreationOptions::attestation_formats)& attestation_formats(
      const ::blink::mojom::PublicKeyCredentialCreationOptionsPtr& input) {
    return input->attestation_formats;
  }

  static decltype(::blink::mojom::PublicKeyCredentialCreationOptions::is_conditional) is_conditional(
      const ::blink::mojom::PublicKeyCredentialCreationOptionsPtr& input) {
    return input->is_conditional;
  }

  static bool Read(::blink::mojom::PublicKeyCredentialCreationOptions::DataView input, ::blink::mojom::PublicKeyCredentialCreationOptionsPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::PublicKeyCredentialDescriptor::DataView,
                                         ::blink::mojom::PublicKeyCredentialDescriptorPtr> {
  static bool IsNull(const ::blink::mojom::PublicKeyCredentialDescriptorPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::PublicKeyCredentialDescriptorPtr* output) { output->reset(); }

  static decltype(::blink::mojom::PublicKeyCredentialDescriptor::type) type(
      const ::blink::mojom::PublicKeyCredentialDescriptorPtr& input) {
    return input->type;
  }

  static const decltype(::blink::mojom::PublicKeyCredentialDescriptor::id)& id(
      const ::blink::mojom::PublicKeyCredentialDescriptorPtr& input) {
    return input->id;
  }

  static const decltype(::blink::mojom::PublicKeyCredentialDescriptor::transports)& transports(
      const ::blink::mojom::PublicKeyCredentialDescriptorPtr& input) {
    return input->transports;
  }

  static bool Read(::blink::mojom::PublicKeyCredentialDescriptor::DataView input, ::blink::mojom::PublicKeyCredentialDescriptorPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::WebAuthnDOMExceptionDetails::DataView,
                                         ::blink::mojom::WebAuthnDOMExceptionDetailsPtr> {
  static bool IsNull(const ::blink::mojom::WebAuthnDOMExceptionDetailsPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::WebAuthnDOMExceptionDetailsPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::WebAuthnDOMExceptionDetails::name)& name(
      const ::blink::mojom::WebAuthnDOMExceptionDetailsPtr& input) {
    return input->name;
  }

  static const decltype(::blink::mojom::WebAuthnDOMExceptionDetails::message)& message(
      const ::blink::mojom::WebAuthnDOMExceptionDetailsPtr& input) {
    return input->message;
  }

  static bool Read(::blink::mojom::WebAuthnDOMExceptionDetails::DataView input, ::blink::mojom::WebAuthnDOMExceptionDetailsPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::PublicKeyCredentialReportOptions::DataView,
                                         ::blink::mojom::PublicKeyCredentialReportOptionsPtr> {
  static bool IsNull(const ::blink::mojom::PublicKeyCredentialReportOptionsPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::PublicKeyCredentialReportOptionsPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::PublicKeyCredentialReportOptions::relying_party_id)& relying_party_id(
      const ::blink::mojom::PublicKeyCredentialReportOptionsPtr& input) {
    return input->relying_party_id;
  }

  static const decltype(::blink::mojom::PublicKeyCredentialReportOptions::unknown_credential_id)& unknown_credential_id(
      const ::blink::mojom::PublicKeyCredentialReportOptionsPtr& input) {
    return input->unknown_credential_id;
  }

  static const decltype(::blink::mojom::PublicKeyCredentialReportOptions::all_accepted_credentials)& all_accepted_credentials(
      const ::blink::mojom::PublicKeyCredentialReportOptionsPtr& input) {
    return input->all_accepted_credentials;
  }

  static const decltype(::blink::mojom::PublicKeyCredentialReportOptions::current_user_details)& current_user_details(
      const ::blink::mojom::PublicKeyCredentialReportOptionsPtr& input) {
    return input->current_user_details;
  }

  static bool Read(::blink::mojom::PublicKeyCredentialReportOptions::DataView input, ::blink::mojom::PublicKeyCredentialReportOptionsPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::AllAcceptedCredentialsOptions::DataView,
                                         ::blink::mojom::AllAcceptedCredentialsOptionsPtr> {
  static bool IsNull(const ::blink::mojom::AllAcceptedCredentialsOptionsPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::AllAcceptedCredentialsOptionsPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::AllAcceptedCredentialsOptions::user_id)& user_id(
      const ::blink::mojom::AllAcceptedCredentialsOptionsPtr& input) {
    return input->user_id;
  }

  static const decltype(::blink::mojom::AllAcceptedCredentialsOptions::all_accepted_credentials_ids)& all_accepted_credentials_ids(
      const ::blink::mojom::AllAcceptedCredentialsOptionsPtr& input) {
    return input->all_accepted_credentials_ids;
  }

  static bool Read(::blink::mojom::AllAcceptedCredentialsOptions::DataView input, ::blink::mojom::AllAcceptedCredentialsOptionsPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::CurrentUserDetailsOptions::DataView,
                                         ::blink::mojom::CurrentUserDetailsOptionsPtr> {
  static bool IsNull(const ::blink::mojom::CurrentUserDetailsOptionsPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::CurrentUserDetailsOptionsPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::CurrentUserDetailsOptions::user_id)& user_id(
      const ::blink::mojom::CurrentUserDetailsOptionsPtr& input) {
    return input->user_id;
  }

  static const decltype(::blink::mojom::CurrentUserDetailsOptions::name)& name(
      const ::blink::mojom::CurrentUserDetailsOptionsPtr& input) {
    return input->name;
  }

  static const decltype(::blink::mojom::CurrentUserDetailsOptions::display_name)& display_name(
      const ::blink::mojom::CurrentUserDetailsOptionsPtr& input) {
    return input->display_name;
  }

  static bool Read(::blink::mojom::CurrentUserDetailsOptions::DataView input, ::blink::mojom::CurrentUserDetailsOptionsPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::WebAuthnClientCapability::DataView,
                                         ::blink::mojom::WebAuthnClientCapabilityPtr> {
  static bool IsNull(const ::blink::mojom::WebAuthnClientCapabilityPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::WebAuthnClientCapabilityPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::WebAuthnClientCapability::name)& name(
      const ::blink::mojom::WebAuthnClientCapabilityPtr& input) {
    return input->name;
  }

  static decltype(::blink::mojom::WebAuthnClientCapability::supported) supported(
      const ::blink::mojom::WebAuthnClientCapabilityPtr& input) {
    return input->supported;
  }

  static bool Read(::blink::mojom::WebAuthnClientCapability::DataView input, ::blink::mojom::WebAuthnClientCapabilityPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::GetAssertionResponse::DataView,
                                         ::blink::mojom::GetAssertionResponsePtr> {
  static bool IsNull(const ::blink::mojom::GetAssertionResponsePtr& input) { return !input; }
  static void SetToNull(::blink::mojom::GetAssertionResponsePtr* output) { output->reset(); }

  static decltype(::blink::mojom::GetAssertionResponse::status) status(
      const ::blink::mojom::GetAssertionResponsePtr& input) {
    return input->status;
  }

  static const decltype(::blink::mojom::GetAssertionResponse::credential)& credential(
      const ::blink::mojom::GetAssertionResponsePtr& input) {
    return input->credential;
  }

  static const decltype(::blink::mojom::GetAssertionResponse::dom_exception_details)& dom_exception_details(
      const ::blink::mojom::GetAssertionResponsePtr& input) {
    return input->dom_exception_details;
  }

  static bool Read(::blink::mojom::GetAssertionResponse::DataView input, ::blink::mojom::GetAssertionResponsePtr* output);
};


template <>
struct BLINK_COMMON_EXPORT UnionTraits<::blink::mojom::GetCredentialResponse::DataView,
                                        ::blink::mojom::GetCredentialResponsePtr> {
  static bool IsNull(const ::blink::mojom::GetCredentialResponsePtr& input) { return !input; }
  static void SetToNull(::blink::mojom::GetCredentialResponsePtr* output) { output->reset(); }

  static ::blink::mojom::GetCredentialResponse::Tag GetTag(const ::blink::mojom::GetCredentialResponsePtr& input) {
    return input->which();
  }

  static const ::blink::mojom::GetAssertionResponsePtr& get_assertion_response(const ::blink::mojom::GetCredentialResponsePtr& input) {
    return input->get_get_assertion_response();
  }

  static const ::password_manager::CredentialInfo& password_response(const ::blink::mojom::GetCredentialResponsePtr& input) {
    return input->get_password_response();
  }

  static bool Read(::blink::mojom::GetCredentialResponse::DataView input, ::blink::mojom::GetCredentialResponsePtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_WEBAUTHN_AUTHENTICATOR_MOJOM_H_