// third_party/blink/public/mojom/webauthn/authenticator.mojom-test-utils.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_WEBAUTHN_AUTHENTICATOR_MOJOM_TEST_UTILS_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_WEBAUTHN_AUTHENTICATOR_MOJOM_TEST_UTILS_H_

#include "third_party/blink/public/mojom/webauthn/authenticator.mojom.h"
#include "third_party/blink/public/common/common_export.h"


namespace blink::mojom {


class BLINK_COMMON_EXPORT AuthenticatorInterceptorForTesting : public Authenticator {
  virtual Authenticator* GetForwardingInterface() = 0;
  void MakeCredential(PublicKeyCredentialCreationOptionsPtr options, MakeCredentialCallback callback) override;
  void GetCredential(GetCredentialOptionsPtr options, GetCredentialCallback callback) override;
  void IsUserVerifyingPlatformAuthenticatorAvailable(IsUserVerifyingPlatformAuthenticatorAvailableCallback callback) override;
  void IsConditionalMediationAvailable(IsConditionalMediationAvailableCallback callback) override;
  void Report(PublicKeyCredentialReportOptionsPtr options, ReportCallback callback) override;
  void GetClientCapabilities(GetClientCapabilitiesCallback callback) override;
  void Cancel() override;
};
class BLINK_COMMON_EXPORT AuthenticatorAsyncWaiter {
 public:
  explicit AuthenticatorAsyncWaiter(Authenticator* proxy);

  AuthenticatorAsyncWaiter(const AuthenticatorAsyncWaiter&) = delete;
  AuthenticatorAsyncWaiter& operator=(const AuthenticatorAsyncWaiter&) = delete;

  ~AuthenticatorAsyncWaiter();
  void MakeCredential(
      PublicKeyCredentialCreationOptionsPtr options, AuthenticatorStatus* out_status, MakeCredentialAuthenticatorResponsePtr* out_credential, WebAuthnDOMExceptionDetailsPtr* out_dom_exception_details);
  
  void GetCredential(
      GetCredentialOptionsPtr options, GetCredentialResponsePtr* out_response);
  GetCredentialResponsePtr GetCredential(GetCredentialOptionsPtr options);
  void IsUserVerifyingPlatformAuthenticatorAvailable(
      bool* out_available);
  bool IsUserVerifyingPlatformAuthenticatorAvailable();
  void IsConditionalMediationAvailable(
      bool* out_available);
  bool IsConditionalMediationAvailable();
  void Report(
      PublicKeyCredentialReportOptionsPtr options, AuthenticatorStatus* out_status, WebAuthnDOMExceptionDetailsPtr* out_dom_exception_details);
  
  void GetClientCapabilities(
      std::vector<WebAuthnClientCapabilityPtr>* out_capabilities);
  std::vector<WebAuthnClientCapabilityPtr> GetClientCapabilities();

 private:
  Authenticator* const proxy_;
};




}  // blink::mojom

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_WEBAUTHN_AUTHENTICATOR_MOJOM_TEST_UTILS_H_