// third_party/blink/public/mojom/webauthn/authenticator.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_WEBAUTHN_AUTHENTICATOR_MOJOM_DATA_VIEW_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_WEBAUTHN_AUTHENTICATOR_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/blink/public/mojom/webauthn/authenticator.mojom-shared-internal.h"
#include "components/payments/mojom/payment_request_data.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "third_party/blink/public/mojom/credentialmanagement/credential_manager.mojom-shared.h"
#include "url/mojom/origin.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"


namespace blink::mojom {
class CommonCredentialInfoDataView;

class SupplementalPubKeysResponseDataView;

class AuthenticationExtensionsPaymentResponseDataView;

class MakeCredentialAuthenticatorResponseDataView;

class GetAssertionAuthenticatorResponseDataView;

class AuthenticationExtensionsClientOutputsDataView;

class PublicKeyCredentialRpEntityDataView;

class PublicKeyCredentialUserEntityDataView;

class PublicKeyCredentialParametersDataView;

class CableAuthenticationDataView;

class PRFValuesDataView;

class PaymentOptionsDataView;

class PaymentCredentialInstrumentDataView;

class ShownPaymentEntityLogoDataView;

class RemoteDesktopClientOverrideDataView;

class SupplementalPubKeysRequestDataView;

class PublicKeyCredentialRequestOptionsDataView;

class AuthenticationExtensionsClientInputsDataView;

class GetCredentialOptionsDataView;

class AuthenticatorSelectionCriteriaDataView;

class PublicKeyCredentialCreationOptionsDataView;

class PublicKeyCredentialDescriptorDataView;

class WebAuthnDOMExceptionDetailsDataView;

class PublicKeyCredentialReportOptionsDataView;

class AllAcceptedCredentialsOptionsDataView;

class CurrentUserDetailsOptionsDataView;

class WebAuthnClientCapabilityDataView;

class GetAssertionResponseDataView;

class GetCredentialResponseDataView;


}  // blink::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::CommonCredentialInfoDataView> {
  using Data = ::blink::mojom::internal::CommonCredentialInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::SupplementalPubKeysResponseDataView> {
  using Data = ::blink::mojom::internal::SupplementalPubKeysResponse_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::AuthenticationExtensionsPaymentResponseDataView> {
  using Data = ::blink::mojom::internal::AuthenticationExtensionsPaymentResponse_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::MakeCredentialAuthenticatorResponseDataView> {
  using Data = ::blink::mojom::internal::MakeCredentialAuthenticatorResponse_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::GetAssertionAuthenticatorResponseDataView> {
  using Data = ::blink::mojom::internal::GetAssertionAuthenticatorResponse_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::AuthenticationExtensionsClientOutputsDataView> {
  using Data = ::blink::mojom::internal::AuthenticationExtensionsClientOutputs_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::PublicKeyCredentialRpEntityDataView> {
  using Data = ::blink::mojom::internal::PublicKeyCredentialRpEntity_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::PublicKeyCredentialUserEntityDataView> {
  using Data = ::blink::mojom::internal::PublicKeyCredentialUserEntity_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::PublicKeyCredentialParametersDataView> {
  using Data = ::blink::mojom::internal::PublicKeyCredentialParameters_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::CableAuthenticationDataView> {
  using Data = ::blink::mojom::internal::CableAuthentication_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::PRFValuesDataView> {
  using Data = ::blink::mojom::internal::PRFValues_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::PaymentOptionsDataView> {
  using Data = ::blink::mojom::internal::PaymentOptions_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::PaymentCredentialInstrumentDataView> {
  using Data = ::blink::mojom::internal::PaymentCredentialInstrument_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::ShownPaymentEntityLogoDataView> {
  using Data = ::blink::mojom::internal::ShownPaymentEntityLogo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::RemoteDesktopClientOverrideDataView> {
  using Data = ::blink::mojom::internal::RemoteDesktopClientOverride_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::SupplementalPubKeysRequestDataView> {
  using Data = ::blink::mojom::internal::SupplementalPubKeysRequest_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::PublicKeyCredentialRequestOptionsDataView> {
  using Data = ::blink::mojom::internal::PublicKeyCredentialRequestOptions_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::AuthenticationExtensionsClientInputsDataView> {
  using Data = ::blink::mojom::internal::AuthenticationExtensionsClientInputs_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::GetCredentialOptionsDataView> {
  using Data = ::blink::mojom::internal::GetCredentialOptions_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::AuthenticatorSelectionCriteriaDataView> {
  using Data = ::blink::mojom::internal::AuthenticatorSelectionCriteria_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::PublicKeyCredentialCreationOptionsDataView> {
  using Data = ::blink::mojom::internal::PublicKeyCredentialCreationOptions_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::PublicKeyCredentialDescriptorDataView> {
  using Data = ::blink::mojom::internal::PublicKeyCredentialDescriptor_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::WebAuthnDOMExceptionDetailsDataView> {
  using Data = ::blink::mojom::internal::WebAuthnDOMExceptionDetails_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::PublicKeyCredentialReportOptionsDataView> {
  using Data = ::blink::mojom::internal::PublicKeyCredentialReportOptions_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::AllAcceptedCredentialsOptionsDataView> {
  using Data = ::blink::mojom::internal::AllAcceptedCredentialsOptions_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::CurrentUserDetailsOptionsDataView> {
  using Data = ::blink::mojom::internal::CurrentUserDetailsOptions_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::WebAuthnClientCapabilityDataView> {
  using Data = ::blink::mojom::internal::WebAuthnClientCapability_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::GetAssertionResponseDataView> {
  using Data = ::blink::mojom::internal::GetAssertionResponse_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::GetCredentialResponseDataView> {
  using Data = ::blink::mojom::internal::GetCredentialResponse_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace blink::mojom {


enum class AuthenticatorStatus : int32_t {
  
  SUCCESS = 0,
  
  PENDING_REQUEST = 1,
  
  NOT_ALLOWED_ERROR = 2,
  
  INVALID_DOMAIN = 3,
  
  CREDENTIAL_EXCLUDED = 4,
  
  NOT_IMPLEMENTED = 5,
  
  NOT_FOCUSED = 6,
  
  RESIDENT_CREDENTIALS_UNSUPPORTED = 7,
  
  USER_VERIFICATION_UNSUPPORTED = 8,
  
  ALGORITHM_UNSUPPORTED = 9,
  
  EMPTY_ALLOW_CREDENTIALS = 10,
  
  ANDROID_NOT_SUPPORTED_ERROR = 11,
  
  PROTECTION_POLICY_INCONSISTENT = 12,
  
  ABORT_ERROR = 13,
  
  OPAQUE_DOMAIN = 14,
  
  INVALID_PROTOCOL = 15,
  
  BAD_RELYING_PARTY_ID = 16,
  
  BAD_RELYING_PARTY_ID_ATTEMPTED_FETCH = 17,
  
  BAD_RELYING_PARTY_ID_WRONG_CONTENT_TYPE = 18,
  
  BAD_RELYING_PARTY_ID_JSON_PARSE_ERROR = 19,
  
  BAD_RELYING_PARTY_ID_NO_JSON_MATCH = 20,
  
  BAD_RELYING_PARTY_ID_NO_JSON_MATCH_HIT_LIMITS = 21,
  
  CANNOT_READ_AND_WRITE_LARGE_BLOB = 22,
  
  INVALID_ALLOW_CREDENTIALS_FOR_LARGE_BLOB = 23,
  
  FAILED_TO_SAVE_CREDENTIAL_ID_FOR_PAYMENT_EXTENSION = 24,
  
  REMOTE_DESKTOP_CLIENT_OVERRIDE_NOT_AUTHORIZED = 25,
  
  DEVICE_PUBLIC_KEY_ATTESTATION_REJECTED = 26,
  
  CERTIFICATE_ERROR = 27,
  
  ERROR_WITH_DOM_EXCEPTION_DETAILS = 28,
  
  IMMEDIATE_NOT_FOUND = 29,
  
  UNKNOWN_ERROR = 30,
  kMinValue = 0,
  kMaxValue = 30,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, AuthenticatorStatus value);
inline bool IsKnownEnumValue(AuthenticatorStatus value) {
  return internal::AuthenticatorStatus_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class AuthenticatorTransport : int32_t {
  
  USB = 0,
  
  NFC = 1,
  
  BLE = 2,
  
  HYBRID = 3,
  
  INTERNAL = 4,
  kMinValue = 0,
  kMaxValue = 4,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, AuthenticatorTransport value);
inline bool IsKnownEnumValue(AuthenticatorTransport value) {
  return internal::AuthenticatorTransport_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class Hint : int32_t {
  
  SECURITY_KEY = 0,
  
  CLIENT_DEVICE = 1,
  
  HYBRID = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, Hint value);
inline bool IsKnownEnumValue(Hint value) {
  return internal::Hint_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class UserVerificationRequirement : int32_t {
  
  REQUIRED = 0,
  
  PREFERRED = 1,
  
  DISCOURAGED = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, UserVerificationRequirement value);
inline bool IsKnownEnumValue(UserVerificationRequirement value) {
  return internal::UserVerificationRequirement_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class Mediation : int32_t {
  
  MODAL = 0,
  
  CONDITIONAL = 1,
  
  IMMEDIATE = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, Mediation value);
inline bool IsKnownEnumValue(Mediation value) {
  return internal::Mediation_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class ResidentKeyRequirement : int32_t {
  
  DISCOURAGED = 0,
  
  PREFERRED = 1,
  
  REQUIRED = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, ResidentKeyRequirement value);
inline bool IsKnownEnumValue(ResidentKeyRequirement value) {
  return internal::ResidentKeyRequirement_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class AuthenticatorAttachment : int32_t {
  
  NO_PREFERENCE = 0,
  
  PLATFORM = 1,
  
  CROSS_PLATFORM = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, AuthenticatorAttachment value);
inline bool IsKnownEnumValue(AuthenticatorAttachment value) {
  return internal::AuthenticatorAttachment_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class ProtectionPolicy : int32_t {
  
  UNSPECIFIED = 0,
  
  NONE = 1,
  
  UV_OR_CRED_ID_REQUIRED = 2,
  
  UV_REQUIRED = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, ProtectionPolicy value);
inline bool IsKnownEnumValue(ProtectionPolicy value) {
  return internal::ProtectionPolicy_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class LargeBlobSupport : int32_t {
  
  NOT_REQUESTED = 0,
  
  REQUIRED = 1,
  
  PREFERRED = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, LargeBlobSupport value);
inline bool IsKnownEnumValue(LargeBlobSupport value) {
  return internal::LargeBlobSupport_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class AttestationConveyancePreference : int32_t {
  
  NONE = 0,
  
  INDIRECT = 1,
  
  DIRECT = 2,
  
  ENTERPRISE = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, AttestationConveyancePreference value);
inline bool IsKnownEnumValue(AttestationConveyancePreference value) {
  return internal::AttestationConveyancePreference_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class PublicKeyCredentialType : int32_t {
  
  PUBLIC_KEY = 0,
  kMinValue = 0,
  kMaxValue = 0,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, PublicKeyCredentialType value);
inline bool IsKnownEnumValue(PublicKeyCredentialType value) {
  return internal::PublicKeyCredentialType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class AuthenticatorInterfaceBase {};

using AuthenticatorPtrDataView =
    mojo::InterfacePtrDataView<AuthenticatorInterfaceBase>;
using AuthenticatorRequestDataView =
    mojo::InterfaceRequestDataView<AuthenticatorInterfaceBase>;
using AuthenticatorAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<AuthenticatorInterfaceBase>;
using AuthenticatorAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<AuthenticatorInterfaceBase>;


class CommonCredentialInfoDataView {
 public:
  CommonCredentialInfoDataView() = default;

  CommonCredentialInfoDataView(
      internal::CommonCredentialInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadId(UserType* output) {
    
    auto* pointer = data_->id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetRawIdDataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRawId(UserType* output) {
    
    auto* pointer = data_->raw_id.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, message_);
  }
  inline void GetClientDataJsonDataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadClientDataJson(UserType* output) {
    
    auto* pointer = data_->client_data_json.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, message_);
  }
  inline void GetAuthenticatorDataDataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAuthenticatorData(UserType* output) {
    
    auto* pointer = data_->authenticator_data.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, message_);
  }
 private:
  internal::CommonCredentialInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class SupplementalPubKeysResponseDataView {
 public:
  SupplementalPubKeysResponseDataView() = default;

  SupplementalPubKeysResponseDataView(
      internal::SupplementalPubKeysResponse_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetSignaturesDataView(
      mojo::ArrayDataView<mojo::ArrayDataView<uint8_t>>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSignatures(UserType* output) {
    
    auto* pointer = data_->signatures.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::ArrayDataView<uint8_t>>>(
        pointer, output, message_);
  }
 private:
  internal::SupplementalPubKeysResponse_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class AuthenticationExtensionsPaymentResponseDataView {
 public:
  AuthenticationExtensionsPaymentResponseDataView() = default;

  AuthenticationExtensionsPaymentResponseDataView(
      internal::AuthenticationExtensionsPaymentResponse_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetBrowserBoundSignatureDataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBrowserBoundSignature(UserType* output) {
    
    auto* pointer = data_->browser_bound_signature.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, message_);
  }
 private:
  internal::AuthenticationExtensionsPaymentResponse_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class MakeCredentialAuthenticatorResponseDataView {
 public:
  MakeCredentialAuthenticatorResponseDataView() = default;

  MakeCredentialAuthenticatorResponseDataView(
      internal::MakeCredentialAuthenticatorResponse_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetInfoDataView(
      CommonCredentialInfoDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInfo(UserType* output) {
    
    auto* pointer = data_->info.Get();
    return mojo::internal::Deserialize<::blink::mojom::CommonCredentialInfoDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadAuthenticatorAttachment(UserType* output) const {
    auto data_value = data_->authenticator_attachment;
    return mojo::internal::Deserialize<::blink::mojom::AuthenticatorAttachment>(
        data_value, output);
  }
  AuthenticatorAttachment authenticator_attachment() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::AuthenticatorAttachment>(data_->authenticator_attachment));
  }
  inline void GetAttestationObjectDataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAttestationObject(UserType* output) {
    
    auto* pointer = data_->attestation_object.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, message_);
  }
  inline void GetTransportsDataView(
      mojo::ArrayDataView<AuthenticatorTransport>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTransports(UserType* output) {
    
    auto* pointer = data_->transports.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::AuthenticatorTransport>>(
        pointer, output, message_);
  }
  bool echo_hmac_create_secret() const {
    return data_->echo_hmac_create_secret;
  }
  bool hmac_create_secret() const {
    return data_->hmac_create_secret;
  }
  bool echo_prf() const {
    return data_->echo_prf;
  }
  bool prf() const {
    return data_->prf;
  }
  inline void GetPrfResultsDataView(
      PRFValuesDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPrfResults(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::PRFValuesDataView, UserType>(),
    "Attempting to read the optional `prf_results` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadPrfResults` instead "
    "of `ReadPrfResults if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->prf_results.Get();
    return mojo::internal::Deserialize<::blink::mojom::PRFValuesDataView>(
        pointer, output, message_);
  }
  bool echo_cred_blob() const {
    return data_->echo_cred_blob;
  }
  bool cred_blob() const {
    return data_->cred_blob;
  }
  inline void GetPublicKeyDerDataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPublicKeyDer(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<uint8_t>, UserType>(),
    "Attempting to read the optional `public_key_der` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadPublicKeyDer` instead "
    "of `ReadPublicKeyDer if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->public_key_der.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, message_);
  }
  int32_t public_key_algo() const {
    return data_->public_key_algo;
  }
  bool echo_cred_props() const {
    return data_->echo_cred_props;
  }
  bool has_cred_props_rk() const {
    return data_->has_cred_props_rk;
  }
  bool cred_props_rk() const {
    return data_->cred_props_rk;
  }
  bool echo_large_blob() const {
    return data_->echo_large_blob;
  }
  bool supports_large_blob() const {
    return data_->supports_large_blob;
  }
  inline void GetSupplementalPubKeysDataView(
      SupplementalPubKeysResponseDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSupplementalPubKeys(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::SupplementalPubKeysResponseDataView, UserType>(),
    "Attempting to read the optional `supplemental_pub_keys` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadSupplementalPubKeys` instead "
    "of `ReadSupplementalPubKeys if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->supplemental_pub_keys.Get();
    return mojo::internal::Deserialize<::blink::mojom::SupplementalPubKeysResponseDataView>(
        pointer, output, message_);
  }
  inline void GetPaymentDataView(
      AuthenticationExtensionsPaymentResponseDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPayment(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::AuthenticationExtensionsPaymentResponseDataView, UserType>(),
    "Attempting to read the optional `payment` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadPayment` instead "
    "of `ReadPayment if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->payment.Get();
    return mojo::internal::Deserialize<::blink::mojom::AuthenticationExtensionsPaymentResponseDataView>(
        pointer, output, message_);
  }
 private:
  internal::MakeCredentialAuthenticatorResponse_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class GetAssertionAuthenticatorResponseDataView {
 public:
  GetAssertionAuthenticatorResponseDataView() = default;

  GetAssertionAuthenticatorResponseDataView(
      internal::GetAssertionAuthenticatorResponse_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetInfoDataView(
      CommonCredentialInfoDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInfo(UserType* output) {
    
    auto* pointer = data_->info.Get();
    return mojo::internal::Deserialize<::blink::mojom::CommonCredentialInfoDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadAuthenticatorAttachment(UserType* output) const {
    auto data_value = data_->authenticator_attachment;
    return mojo::internal::Deserialize<::blink::mojom::AuthenticatorAttachment>(
        data_value, output);
  }
  AuthenticatorAttachment authenticator_attachment() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::AuthenticatorAttachment>(data_->authenticator_attachment));
  }
  inline void GetSignatureDataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSignature(UserType* output) {
    
    auto* pointer = data_->signature.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, message_);
  }
  inline void GetUserHandleDataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUserHandle(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<uint8_t>, UserType>(),
    "Attempting to read the optional `user_handle` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadUserHandle` instead "
    "of `ReadUserHandle if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->user_handle.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, message_);
  }
  inline void GetExtensionsDataView(
      AuthenticationExtensionsClientOutputsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadExtensions(UserType* output) {
    
    auto* pointer = data_->extensions.Get();
    return mojo::internal::Deserialize<::blink::mojom::AuthenticationExtensionsClientOutputsDataView>(
        pointer, output, message_);
  }
 private:
  internal::GetAssertionAuthenticatorResponse_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class AuthenticationExtensionsClientOutputsDataView {
 public:
  AuthenticationExtensionsClientOutputsDataView() = default;

  AuthenticationExtensionsClientOutputsDataView(
      internal::AuthenticationExtensionsClientOutputs_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  bool echo_appid_extension() const {
    return data_->echo_appid_extension;
  }
  bool appid_extension() const {
    return data_->appid_extension;
  }
  bool echo_prf() const {
    return data_->echo_prf;
  }
  inline void GetPrfResultsDataView(
      PRFValuesDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPrfResults(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::PRFValuesDataView, UserType>(),
    "Attempting to read the optional `prf_results` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadPrfResults` instead "
    "of `ReadPrfResults if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->prf_results.Get();
    return mojo::internal::Deserialize<::blink::mojom::PRFValuesDataView>(
        pointer, output, message_);
  }
  bool prf_not_evaluated() const {
    return data_->prf_not_evaluated;
  }
  bool echo_large_blob() const {
    return data_->echo_large_blob;
  }
  inline void GetLargeBlobDataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLargeBlob(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<uint8_t>, UserType>(),
    "Attempting to read the optional `large_blob` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadLargeBlob` instead "
    "of `ReadLargeBlob if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->large_blob.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, message_);
  }
  bool echo_large_blob_written() const {
    return data_->echo_large_blob_written;
  }
  bool large_blob_written() const {
    return data_->large_blob_written;
  }
  inline void GetGetCredBlobDataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadGetCredBlob(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<uint8_t>, UserType>(),
    "Attempting to read the optional `get_cred_blob` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadGetCredBlob` instead "
    "of `ReadGetCredBlob if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->get_cred_blob.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, message_);
  }
  inline void GetSupplementalPubKeysDataView(
      SupplementalPubKeysResponseDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSupplementalPubKeys(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::SupplementalPubKeysResponseDataView, UserType>(),
    "Attempting to read the optional `supplemental_pub_keys` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadSupplementalPubKeys` instead "
    "of `ReadSupplementalPubKeys if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->supplemental_pub_keys.Get();
    return mojo::internal::Deserialize<::blink::mojom::SupplementalPubKeysResponseDataView>(
        pointer, output, message_);
  }
  inline void GetPaymentDataView(
      AuthenticationExtensionsPaymentResponseDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPayment(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::AuthenticationExtensionsPaymentResponseDataView, UserType>(),
    "Attempting to read the optional `payment` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadPayment` instead "
    "of `ReadPayment if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->payment.Get();
    return mojo::internal::Deserialize<::blink::mojom::AuthenticationExtensionsPaymentResponseDataView>(
        pointer, output, message_);
  }
 private:
  internal::AuthenticationExtensionsClientOutputs_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PublicKeyCredentialRpEntityDataView {
 public:
  PublicKeyCredentialRpEntityDataView() = default;

  PublicKeyCredentialRpEntityDataView(
      internal::PublicKeyCredentialRpEntity_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadId(UserType* output) {
    
    auto* pointer = data_->id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadName(UserType* output) {
    
    auto* pointer = data_->name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::PublicKeyCredentialRpEntity_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PublicKeyCredentialUserEntityDataView {
 public:
  PublicKeyCredentialUserEntityDataView() = default;

  PublicKeyCredentialUserEntityDataView(
      internal::PublicKeyCredentialUserEntity_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetIdDataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadId(UserType* output) {
    
    auto* pointer = data_->id.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, message_);
  }
  inline void GetNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadName(UserType* output) {
    
    auto* pointer = data_->name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetDisplayNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDisplayName(UserType* output) {
    
    auto* pointer = data_->display_name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::PublicKeyCredentialUserEntity_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PublicKeyCredentialParametersDataView {
 public:
  PublicKeyCredentialParametersDataView() = default;

  PublicKeyCredentialParametersDataView(
      internal::PublicKeyCredentialParameters_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadType(UserType* output) const {
    auto data_value = data_->type;
    return mojo::internal::Deserialize<::blink::mojom::PublicKeyCredentialType>(
        data_value, output);
  }
  PublicKeyCredentialType type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::PublicKeyCredentialType>(data_->type));
  }
  int32_t algorithm_identifier() const {
    return data_->algorithm_identifier;
  }
 private:
  internal::PublicKeyCredentialParameters_Data* data_ = nullptr;
};


class CableAuthenticationDataView {
 public:
  CableAuthenticationDataView() = default;

  CableAuthenticationDataView(
      internal::CableAuthentication_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  uint8_t version() const {
    return data_->version;
  }
  inline void GetClientEidDataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadClientEid(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<uint8_t>, UserType>(),
    "Attempting to read the optional `client_eid` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadClientEid` instead "
    "of `ReadClientEid if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->client_eid.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, message_);
  }
  inline void GetAuthenticatorEidDataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAuthenticatorEid(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<uint8_t>, UserType>(),
    "Attempting to read the optional `authenticator_eid` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadAuthenticatorEid` instead "
    "of `ReadAuthenticatorEid if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->authenticator_eid.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, message_);
  }
  inline void GetSessionPreKeyDataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSessionPreKey(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<uint8_t>, UserType>(),
    "Attempting to read the optional `session_pre_key` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadSessionPreKey` instead "
    "of `ReadSessionPreKey if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->session_pre_key.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, message_);
  }
  inline void GetServerLinkDataDataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadServerLinkData(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<uint8_t>, UserType>(),
    "Attempting to read the optional `server_link_data` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadServerLinkData` instead "
    "of `ReadServerLinkData if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->server_link_data.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, message_);
  }
  inline void GetExperimentsDataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadExperiments(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<uint8_t>, UserType>(),
    "Attempting to read the optional `experiments` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadExperiments` instead "
    "of `ReadExperiments if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->experiments.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, message_);
  }
 private:
  internal::CableAuthentication_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PRFValuesDataView {
 public:
  PRFValuesDataView() = default;

  PRFValuesDataView(
      internal::PRFValues_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetIdDataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadId(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<uint8_t>, UserType>(),
    "Attempting to read the optional `id` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadId` instead "
    "of `ReadId if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->id.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, message_);
  }
  inline void GetFirstDataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFirst(UserType* output) {
    
    auto* pointer = data_->first.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, message_);
  }
  inline void GetSecondDataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSecond(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<uint8_t>, UserType>(),
    "Attempting to read the optional `second` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadSecond` instead "
    "of `ReadSecond if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->second.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, message_);
  }
 private:
  internal::PRFValues_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PaymentOptionsDataView {
 public:
  PaymentOptionsDataView() = default;

  PaymentOptionsDataView(
      internal::PaymentOptions_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetTotalDataView(
      ::payments::mojom::PaymentCurrencyAmountDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTotal(UserType* output) {
    
    auto* pointer = data_->total.Get();
    return mojo::internal::Deserialize<::payments::mojom::PaymentCurrencyAmountDataView>(
        pointer, output, message_);
  }
  inline void GetInstrumentDataView(
      PaymentCredentialInstrumentDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInstrument(UserType* output) {
    
    auto* pointer = data_->instrument.Get();
    return mojo::internal::Deserialize<::blink::mojom::PaymentCredentialInstrumentDataView>(
        pointer, output, message_);
  }
  inline void GetPayeeNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPayeeName(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `payee_name` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadPayeeName` instead "
    "of `ReadPayeeName if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->payee_name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetPayeeOriginDataView(
      ::url::mojom::OriginDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPayeeOrigin(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::url::mojom::OriginDataView, UserType>(),
    "Attempting to read the optional `payee_origin` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadPayeeOrigin` instead "
    "of `ReadPayeeOrigin if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->payee_origin.Get();
    return mojo::internal::Deserialize<::url::mojom::OriginDataView>(
        pointer, output, message_);
  }
  inline void GetPaymentEntitiesLogosDataView(
      mojo::ArrayDataView<ShownPaymentEntityLogoDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPaymentEntitiesLogos(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<::blink::mojom::ShownPaymentEntityLogoDataView>, UserType>(),
    "Attempting to read the optional `payment_entities_logos` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadPaymentEntitiesLogos` instead "
    "of `ReadPaymentEntitiesLogos if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->payment_entities_logos.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::ShownPaymentEntityLogoDataView>>(
        pointer, output, message_);
  }
  inline void GetBrowserBoundPublicKeyDataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBrowserBoundPublicKey(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<uint8_t>, UserType>(),
    "Attempting to read the optional `browser_bound_public_key` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadBrowserBoundPublicKey` instead "
    "of `ReadBrowserBoundPublicKey if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->browser_bound_public_key.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, message_);
  }
 private:
  internal::PaymentOptions_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PaymentCredentialInstrumentDataView {
 public:
  PaymentCredentialInstrumentDataView() = default;

  PaymentCredentialInstrumentDataView(
      internal::PaymentCredentialInstrument_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetDisplayNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDisplayName(UserType* output) {
    
    auto* pointer = data_->display_name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetIconDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadIcon(UserType* output) {
    
    auto* pointer = data_->icon.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  bool iconMustBeShown() const {
    return data_->iconMustBeShown;
  }
  inline void GetDetailsDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDetails(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `details` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadDetails` instead "
    "of `ReadDetails if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->details.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::PaymentCredentialInstrument_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ShownPaymentEntityLogoDataView {
 public:
  ShownPaymentEntityLogoDataView() = default;

  ShownPaymentEntityLogoDataView(
      internal::ShownPaymentEntityLogo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrl(UserType* output) {
    
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetLabelDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLabel(UserType* output) {
    
    auto* pointer = data_->label.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::ShownPaymentEntityLogo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class RemoteDesktopClientOverrideDataView {
 public:
  RemoteDesktopClientOverrideDataView() = default;

  RemoteDesktopClientOverrideDataView(
      internal::RemoteDesktopClientOverride_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetOriginDataView(
      ::url::mojom::OriginDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOrigin(UserType* output) {
    
    auto* pointer = data_->origin.Get();
    return mojo::internal::Deserialize<::url::mojom::OriginDataView>(
        pointer, output, message_);
  }
  bool same_origin_with_ancestors() const {
    return data_->same_origin_with_ancestors;
  }
 private:
  internal::RemoteDesktopClientOverride_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class SupplementalPubKeysRequestDataView {
 public:
  SupplementalPubKeysRequestDataView() = default;

  SupplementalPubKeysRequestDataView(
      internal::SupplementalPubKeysRequest_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  bool device_scope_requested() const {
    return data_->device_scope_requested;
  }
  bool provider_scope_requested() const {
    return data_->provider_scope_requested;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadAttestation(UserType* output) const {
    auto data_value = data_->attestation;
    return mojo::internal::Deserialize<::blink::mojom::AttestationConveyancePreference>(
        data_value, output);
  }
  AttestationConveyancePreference attestation() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::AttestationConveyancePreference>(data_->attestation));
  }
  inline void GetAttestationFormatsDataView(
      mojo::ArrayDataView<mojo::StringDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAttestationFormats(UserType* output) {
    
    auto* pointer = data_->attestation_formats.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::StringDataView>>(
        pointer, output, message_);
  }
 private:
  internal::SupplementalPubKeysRequest_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PublicKeyCredentialRequestOptionsDataView {
 public:
  PublicKeyCredentialRequestOptionsDataView() = default;

  PublicKeyCredentialRequestOptionsDataView(
      internal::PublicKeyCredentialRequestOptions_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetChallengeDataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadChallenge(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<uint8_t>, UserType>(),
    "Attempting to read the optional `challenge` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadChallenge` instead "
    "of `ReadChallenge if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->challenge.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, message_);
  }
  inline void GetChallengeUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadChallengeUrl(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::url::mojom::UrlDataView, UserType>(),
    "Attempting to read the optional `challenge_url` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadChallengeUrl` instead "
    "of `ReadChallengeUrl if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->challenge_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetTimeoutDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTimeout(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::TimeDeltaDataView, UserType>(),
    "Attempting to read the optional `timeout` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadTimeout` instead "
    "of `ReadTimeout if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->timeout.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  inline void GetRelyingPartyIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRelyingPartyId(UserType* output) {
    
    auto* pointer = data_->relying_party_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetAllowCredentialsDataView(
      mojo::ArrayDataView<PublicKeyCredentialDescriptorDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAllowCredentials(UserType* output) {
    
    auto* pointer = data_->allow_credentials.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::PublicKeyCredentialDescriptorDataView>>(
        pointer, output, message_);
  }
  inline void GetHintsDataView(
      mojo::ArrayDataView<Hint>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHints(UserType* output) {
    
    auto* pointer = data_->hints.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::Hint>>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadUserVerification(UserType* output) const {
    auto data_value = data_->user_verification;
    return mojo::internal::Deserialize<::blink::mojom::UserVerificationRequirement>(
        data_value, output);
  }
  UserVerificationRequirement user_verification() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::UserVerificationRequirement>(data_->user_verification));
  }
  inline void GetExtensionsDataView(
      AuthenticationExtensionsClientInputsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadExtensions(UserType* output) {
    
    auto* pointer = data_->extensions.Get();
    return mojo::internal::Deserialize<::blink::mojom::AuthenticationExtensionsClientInputsDataView>(
        pointer, output, message_);
  }
 private:
  internal::PublicKeyCredentialRequestOptions_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class AuthenticationExtensionsClientInputsDataView {
 public:
  AuthenticationExtensionsClientInputsDataView() = default;

  AuthenticationExtensionsClientInputsDataView(
      internal::AuthenticationExtensionsClientInputs_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetAppidDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAppid(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `appid` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadAppid` instead "
    "of `ReadAppid if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->appid.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetCableAuthenticationDataDataView(
      mojo::ArrayDataView<CableAuthenticationDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCableAuthenticationData(UserType* output) {
    
    auto* pointer = data_->cable_authentication_data.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::CableAuthenticationDataView>>(
        pointer, output, message_);
  }
  bool prf() const {
    return data_->prf;
  }
  inline void GetPrfInputsDataView(
      mojo::ArrayDataView<PRFValuesDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPrfInputs(UserType* output) {
    
    auto* pointer = data_->prf_inputs.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::PRFValuesDataView>>(
        pointer, output, message_);
  }
  bool large_blob_read() const {
    return data_->large_blob_read;
  }
  inline void GetLargeBlobWriteDataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLargeBlobWrite(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<uint8_t>, UserType>(),
    "Attempting to read the optional `large_blob_write` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadLargeBlobWrite` instead "
    "of `ReadLargeBlobWrite if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->large_blob_write.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, message_);
  }
  bool get_cred_blob() const {
    return data_->get_cred_blob;
  }
  inline void GetRemoteDesktopClientOverrideDataView(
      RemoteDesktopClientOverrideDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRemoteDesktopClientOverride(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::RemoteDesktopClientOverrideDataView, UserType>(),
    "Attempting to read the optional `remote_desktop_client_override` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadRemoteDesktopClientOverride` instead "
    "of `ReadRemoteDesktopClientOverride if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->remote_desktop_client_override.Get();
    return mojo::internal::Deserialize<::blink::mojom::RemoteDesktopClientOverrideDataView>(
        pointer, output, message_);
  }
  inline void GetSupplementalPubKeysDataView(
      SupplementalPubKeysRequestDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSupplementalPubKeys(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::SupplementalPubKeysRequestDataView, UserType>(),
    "Attempting to read the optional `supplemental_pub_keys` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadSupplementalPubKeys` instead "
    "of `ReadSupplementalPubKeys if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->supplemental_pub_keys.Get();
    return mojo::internal::Deserialize<::blink::mojom::SupplementalPubKeysRequestDataView>(
        pointer, output, message_);
  }
  inline void GetPaymentBrowserBoundKeyParametersDataView(
      mojo::ArrayDataView<PublicKeyCredentialParametersDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPaymentBrowserBoundKeyParameters(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<::blink::mojom::PublicKeyCredentialParametersDataView>, UserType>(),
    "Attempting to read the optional `payment_browser_bound_key_parameters` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadPaymentBrowserBoundKeyParameters` instead "
    "of `ReadPaymentBrowserBoundKeyParameters if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->payment_browser_bound_key_parameters.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::PublicKeyCredentialParametersDataView>>(
        pointer, output, message_);
  }
 private:
  internal::AuthenticationExtensionsClientInputs_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class GetCredentialOptionsDataView {
 public:
  GetCredentialOptionsDataView() = default;

  GetCredentialOptionsDataView(
      internal::GetCredentialOptions_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadMediation(UserType* output) const {
    auto data_value = data_->mediation;
    return mojo::internal::Deserialize<::blink::mojom::Mediation>(
        data_value, output);
  }
  Mediation mediation() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::Mediation>(data_->mediation));
  }
  inline void GetPublicKeyDataView(
      PublicKeyCredentialRequestOptionsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPublicKey(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::PublicKeyCredentialRequestOptionsDataView, UserType>(),
    "Attempting to read the optional `public_key` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadPublicKey` instead "
    "of `ReadPublicKey if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->public_key.Get();
    return mojo::internal::Deserialize<::blink::mojom::PublicKeyCredentialRequestOptionsDataView>(
        pointer, output, message_);
  }
  bool password() const {
    return data_->password;
  }
 private:
  internal::GetCredentialOptions_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class AuthenticatorSelectionCriteriaDataView {
 public:
  AuthenticatorSelectionCriteriaDataView() = default;

  AuthenticatorSelectionCriteriaDataView(
      internal::AuthenticatorSelectionCriteria_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadAuthenticatorAttachment(UserType* output) const {
    auto data_value = data_->authenticator_attachment;
    return mojo::internal::Deserialize<::blink::mojom::AuthenticatorAttachment>(
        data_value, output);
  }
  AuthenticatorAttachment authenticator_attachment() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::AuthenticatorAttachment>(data_->authenticator_attachment));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadResidentKey(UserType* output) const {
    auto data_value = data_->resident_key;
    return mojo::internal::Deserialize<::blink::mojom::ResidentKeyRequirement>(
        data_value, output);
  }
  ResidentKeyRequirement resident_key() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::ResidentKeyRequirement>(data_->resident_key));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadUserVerification(UserType* output) const {
    auto data_value = data_->user_verification;
    return mojo::internal::Deserialize<::blink::mojom::UserVerificationRequirement>(
        data_value, output);
  }
  UserVerificationRequirement user_verification() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::UserVerificationRequirement>(data_->user_verification));
  }
 private:
  internal::AuthenticatorSelectionCriteria_Data* data_ = nullptr;
};


class PublicKeyCredentialCreationOptionsDataView {
 public:
  PublicKeyCredentialCreationOptionsDataView() = default;

  PublicKeyCredentialCreationOptionsDataView(
      internal::PublicKeyCredentialCreationOptions_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetRelyingPartyDataView(
      PublicKeyCredentialRpEntityDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRelyingParty(UserType* output) {
    
    auto* pointer = data_->relying_party.Get();
    return mojo::internal::Deserialize<::blink::mojom::PublicKeyCredentialRpEntityDataView>(
        pointer, output, message_);
  }
  inline void GetUserDataView(
      PublicKeyCredentialUserEntityDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUser(UserType* output) {
    
    auto* pointer = data_->user.Get();
    return mojo::internal::Deserialize<::blink::mojom::PublicKeyCredentialUserEntityDataView>(
        pointer, output, message_);
  }
  inline void GetChallengeDataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadChallenge(UserType* output) {
    
    auto* pointer = data_->challenge.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, message_);
  }
  inline void GetPublicKeyParametersDataView(
      mojo::ArrayDataView<PublicKeyCredentialParametersDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPublicKeyParameters(UserType* output) {
    
    auto* pointer = data_->public_key_parameters.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::PublicKeyCredentialParametersDataView>>(
        pointer, output, message_);
  }
  inline void GetTimeoutDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTimeout(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::TimeDeltaDataView, UserType>(),
    "Attempting to read the optional `timeout` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadTimeout` instead "
    "of `ReadTimeout if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->timeout.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  inline void GetExcludeCredentialsDataView(
      mojo::ArrayDataView<PublicKeyCredentialDescriptorDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadExcludeCredentials(UserType* output) {
    
    auto* pointer = data_->exclude_credentials.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::PublicKeyCredentialDescriptorDataView>>(
        pointer, output, message_);
  }
  inline void GetAuthenticatorSelectionDataView(
      AuthenticatorSelectionCriteriaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAuthenticatorSelection(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::AuthenticatorSelectionCriteriaDataView, UserType>(),
    "Attempting to read the optional `authenticator_selection` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadAuthenticatorSelection` instead "
    "of `ReadAuthenticatorSelection if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->authenticator_selection.Get();
    return mojo::internal::Deserialize<::blink::mojom::AuthenticatorSelectionCriteriaDataView>(
        pointer, output, message_);
  }
  inline void GetHintsDataView(
      mojo::ArrayDataView<Hint>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHints(UserType* output) {
    
    auto* pointer = data_->hints.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::Hint>>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadAttestation(UserType* output) const {
    auto data_value = data_->attestation;
    return mojo::internal::Deserialize<::blink::mojom::AttestationConveyancePreference>(
        data_value, output);
  }
  AttestationConveyancePreference attestation() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::AttestationConveyancePreference>(data_->attestation));
  }
  bool hmac_create_secret() const {
    return data_->hmac_create_secret;
  }
  bool prf_enable() const {
    return data_->prf_enable;
  }
  inline void GetPrfInputDataView(
      PRFValuesDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPrfInput(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::PRFValuesDataView, UserType>(),
    "Attempting to read the optional `prf_input` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadPrfInput` instead "
    "of `ReadPrfInput if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->prf_input.Get();
    return mojo::internal::Deserialize<::blink::mojom::PRFValuesDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadProtectionPolicy(UserType* output) const {
    auto data_value = data_->protection_policy;
    return mojo::internal::Deserialize<::blink::mojom::ProtectionPolicy>(
        data_value, output);
  }
  ProtectionPolicy protection_policy() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::ProtectionPolicy>(data_->protection_policy));
  }
  bool enforce_protection_policy() const {
    return data_->enforce_protection_policy;
  }
  inline void GetAppidExcludeDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAppidExclude(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `appid_exclude` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadAppidExclude` instead "
    "of `ReadAppidExclude if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->appid_exclude.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  bool cred_props() const {
    return data_->cred_props;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadLargeBlobEnable(UserType* output) const {
    auto data_value = data_->large_blob_enable;
    return mojo::internal::Deserialize<::blink::mojom::LargeBlobSupport>(
        data_value, output);
  }
  LargeBlobSupport large_blob_enable() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::LargeBlobSupport>(data_->large_blob_enable));
  }
  bool is_payment_credential_creation() const {
    return data_->is_payment_credential_creation;
  }
  inline void GetCredBlobDataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCredBlob(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<uint8_t>, UserType>(),
    "Attempting to read the optional `cred_blob` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadCredBlob` instead "
    "of `ReadCredBlob if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->cred_blob.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, message_);
  }
  bool min_pin_length_requested() const {
    return data_->min_pin_length_requested;
  }
  inline void GetRemoteDesktopClientOverrideDataView(
      RemoteDesktopClientOverrideDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRemoteDesktopClientOverride(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::RemoteDesktopClientOverrideDataView, UserType>(),
    "Attempting to read the optional `remote_desktop_client_override` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadRemoteDesktopClientOverride` instead "
    "of `ReadRemoteDesktopClientOverride if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->remote_desktop_client_override.Get();
    return mojo::internal::Deserialize<::blink::mojom::RemoteDesktopClientOverrideDataView>(
        pointer, output, message_);
  }
  inline void GetSupplementalPubKeysDataView(
      SupplementalPubKeysRequestDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSupplementalPubKeys(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::SupplementalPubKeysRequestDataView, UserType>(),
    "Attempting to read the optional `supplemental_pub_keys` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadSupplementalPubKeys` instead "
    "of `ReadSupplementalPubKeys if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->supplemental_pub_keys.Get();
    return mojo::internal::Deserialize<::blink::mojom::SupplementalPubKeysRequestDataView>(
        pointer, output, message_);
  }
  inline void GetPaymentBrowserBoundKeyParametersDataView(
      mojo::ArrayDataView<PublicKeyCredentialParametersDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPaymentBrowserBoundKeyParameters(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<::blink::mojom::PublicKeyCredentialParametersDataView>, UserType>(),
    "Attempting to read the optional `payment_browser_bound_key_parameters` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadPaymentBrowserBoundKeyParameters` instead "
    "of `ReadPaymentBrowserBoundKeyParameters if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->payment_browser_bound_key_parameters.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::PublicKeyCredentialParametersDataView>>(
        pointer, output, message_);
  }
  inline void GetAttestationFormatsDataView(
      mojo::ArrayDataView<mojo::StringDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAttestationFormats(UserType* output) {
    
    auto* pointer = data_->attestation_formats.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::StringDataView>>(
        pointer, output, message_);
  }
  bool is_conditional() const {
    return data_->is_conditional;
  }
 private:
  internal::PublicKeyCredentialCreationOptions_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PublicKeyCredentialDescriptorDataView {
 public:
  PublicKeyCredentialDescriptorDataView() = default;

  PublicKeyCredentialDescriptorDataView(
      internal::PublicKeyCredentialDescriptor_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadType(UserType* output) const {
    auto data_value = data_->type;
    return mojo::internal::Deserialize<::blink::mojom::PublicKeyCredentialType>(
        data_value, output);
  }
  PublicKeyCredentialType type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::PublicKeyCredentialType>(data_->type));
  }
  inline void GetIdDataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadId(UserType* output) {
    
    auto* pointer = data_->id.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, message_);
  }
  inline void GetTransportsDataView(
      mojo::ArrayDataView<AuthenticatorTransport>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTransports(UserType* output) {
    
    auto* pointer = data_->transports.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::AuthenticatorTransport>>(
        pointer, output, message_);
  }
 private:
  internal::PublicKeyCredentialDescriptor_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class WebAuthnDOMExceptionDetailsDataView {
 public:
  WebAuthnDOMExceptionDetailsDataView() = default;

  WebAuthnDOMExceptionDetailsDataView(
      internal::WebAuthnDOMExceptionDetails_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadName(UserType* output) {
    
    auto* pointer = data_->name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetMessageDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMessage(UserType* output) {
    
    auto* pointer = data_->message.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::WebAuthnDOMExceptionDetails_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PublicKeyCredentialReportOptionsDataView {
 public:
  PublicKeyCredentialReportOptionsDataView() = default;

  PublicKeyCredentialReportOptionsDataView(
      internal::PublicKeyCredentialReportOptions_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetRelyingPartyIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRelyingPartyId(UserType* output) {
    
    auto* pointer = data_->relying_party_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetUnknownCredentialIdDataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUnknownCredentialId(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<uint8_t>, UserType>(),
    "Attempting to read the optional `unknown_credential_id` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadUnknownCredentialId` instead "
    "of `ReadUnknownCredentialId if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->unknown_credential_id.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, message_);
  }
  inline void GetAllAcceptedCredentialsDataView(
      AllAcceptedCredentialsOptionsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAllAcceptedCredentials(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::AllAcceptedCredentialsOptionsDataView, UserType>(),
    "Attempting to read the optional `all_accepted_credentials` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadAllAcceptedCredentials` instead "
    "of `ReadAllAcceptedCredentials if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->all_accepted_credentials.Get();
    return mojo::internal::Deserialize<::blink::mojom::AllAcceptedCredentialsOptionsDataView>(
        pointer, output, message_);
  }
  inline void GetCurrentUserDetailsDataView(
      CurrentUserDetailsOptionsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCurrentUserDetails(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::CurrentUserDetailsOptionsDataView, UserType>(),
    "Attempting to read the optional `current_user_details` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadCurrentUserDetails` instead "
    "of `ReadCurrentUserDetails if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->current_user_details.Get();
    return mojo::internal::Deserialize<::blink::mojom::CurrentUserDetailsOptionsDataView>(
        pointer, output, message_);
  }
 private:
  internal::PublicKeyCredentialReportOptions_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class AllAcceptedCredentialsOptionsDataView {
 public:
  AllAcceptedCredentialsOptionsDataView() = default;

  AllAcceptedCredentialsOptionsDataView(
      internal::AllAcceptedCredentialsOptions_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetUserIdDataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUserId(UserType* output) {
    
    auto* pointer = data_->user_id.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, message_);
  }
  inline void GetAllAcceptedCredentialsIdsDataView(
      mojo::ArrayDataView<mojo::ArrayDataView<uint8_t>>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAllAcceptedCredentialsIds(UserType* output) {
    
    auto* pointer = data_->all_accepted_credentials_ids.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::ArrayDataView<uint8_t>>>(
        pointer, output, message_);
  }
 private:
  internal::AllAcceptedCredentialsOptions_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class CurrentUserDetailsOptionsDataView {
 public:
  CurrentUserDetailsOptionsDataView() = default;

  CurrentUserDetailsOptionsDataView(
      internal::CurrentUserDetailsOptions_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetUserIdDataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUserId(UserType* output) {
    
    auto* pointer = data_->user_id.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, message_);
  }
  inline void GetNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadName(UserType* output) {
    
    auto* pointer = data_->name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetDisplayNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDisplayName(UserType* output) {
    
    auto* pointer = data_->display_name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::CurrentUserDetailsOptions_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class WebAuthnClientCapabilityDataView {
 public:
  WebAuthnClientCapabilityDataView() = default;

  WebAuthnClientCapabilityDataView(
      internal::WebAuthnClientCapability_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadName(UserType* output) {
    
    auto* pointer = data_->name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  bool supported() const {
    return data_->supported;
  }
 private:
  internal::WebAuthnClientCapability_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class GetAssertionResponseDataView {
 public:
  GetAssertionResponseDataView() = default;

  GetAssertionResponseDataView(
      internal::GetAssertionResponse_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadStatus(UserType* output) const {
    auto data_value = data_->status;
    return mojo::internal::Deserialize<::blink::mojom::AuthenticatorStatus>(
        data_value, output);
  }
  AuthenticatorStatus status() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::AuthenticatorStatus>(data_->status));
  }
  inline void GetCredentialDataView(
      GetAssertionAuthenticatorResponseDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCredential(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::GetAssertionAuthenticatorResponseDataView, UserType>(),
    "Attempting to read the optional `credential` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadCredential` instead "
    "of `ReadCredential if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->credential.Get();
    return mojo::internal::Deserialize<::blink::mojom::GetAssertionAuthenticatorResponseDataView>(
        pointer, output, message_);
  }
  inline void GetDomExceptionDetailsDataView(
      WebAuthnDOMExceptionDetailsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDomExceptionDetails(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::WebAuthnDOMExceptionDetailsDataView, UserType>(),
    "Attempting to read the optional `dom_exception_details` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadDomExceptionDetails` instead "
    "of `ReadDomExceptionDetails if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->dom_exception_details.Get();
    return mojo::internal::Deserialize<::blink::mojom::WebAuthnDOMExceptionDetailsDataView>(
        pointer, output, message_);
  }
 private:
  internal::GetAssertionResponse_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class GetCredentialResponseDataView {
 public:
  using Tag = internal::GetCredentialResponse_Data::GetCredentialResponse_Tag;

  GetCredentialResponseDataView() = default;

  GetCredentialResponseDataView(
      internal::GetCredentialResponse_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_get_assertion_response() const { return data_->tag == Tag::kGetAssertionResponse; }
  inline void GetGetAssertionResponseDataView(
      GetAssertionResponseDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadGetAssertionResponse(UserType* output) const {
    
    CHECK(is_get_assertion_response());
    return mojo::internal::Deserialize<::blink::mojom::GetAssertionResponseDataView>(
        data_->data.f_get_assertion_response.Get(), output, message_);
  }
  bool is_password_response() const { return data_->tag == Tag::kPasswordResponse; }
  inline void GetPasswordResponseDataView(
      ::blink::mojom::CredentialInfoDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadPasswordResponse(UserType* output) const {
    
    CHECK(is_password_response());
    return mojo::internal::Deserialize<::blink::mojom::CredentialInfoDataView>(
        data_->data.f_password_response.Get(), output, message_);
  }

 private:
  internal::GetCredentialResponse_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



}  // blink::mojom

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_WEBAUTHN_AUTHENTICATOR_MOJOM_DATA_VIEW_H_