// third_party/blink/public/mojom/web_install/web_install.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_WEB_INSTALL_WEB_INSTALL_MOJOM_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_WEB_INSTALL_WEB_INSTALL_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/web_install/web_install.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/web_install/web_install.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/web_install/web_install.mojom-forward.h"  // IWYU pragma: export
#include "url/mojom/url.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "third_party/blink/public/common/common_export.h"




namespace blink::mojom {

class WebInstallServiceProxy;

template <typename ImplRefTraits>
class WebInstallServiceStub;

class WebInstallServiceRequestValidator;
class WebInstallServiceResponseValidator;


class BLINK_COMMON_EXPORT WebInstallService
    : public WebInstallServiceInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "blink.mojom.WebInstallService";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = WebInstallServiceInterfaceBase;
  using Proxy_ = WebInstallServiceProxy;

  template <typename ImplRefTraits>
  using Stub_ = WebInstallServiceStub<ImplRefTraits>;

  using RequestValidator_ = WebInstallServiceRequestValidator;
  using ResponseValidator_ = WebInstallServiceResponseValidator;
  enum MethodMinVersions : uint32_t {
    kInstallMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct Install_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~WebInstallService() = default;

  using InstallCallback = base::OnceCallback<void(WebInstallServiceResult, const ::GURL&)>;
  using InstallMojoCallback = base::OnceCallback<void(WebInstallServiceResult, const ::GURL&)>;

  virtual void Install(InstallOptionsPtr options, InstallCallback callback) = 0;
};



class BLINK_COMMON_EXPORT WebInstallServiceProxy
    : public WebInstallService {
 public:
  using InterfaceType = WebInstallService;

  explicit WebInstallServiceProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void Install(InstallOptionsPtr options, InstallCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class BLINK_COMMON_EXPORT WebInstallServiceStubDispatch {
 public:
  static bool Accept(WebInstallService* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      WebInstallService* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<WebInstallService>>
class WebInstallServiceStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  WebInstallServiceStub() = default;
  ~WebInstallServiceStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return WebInstallServiceStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return WebInstallServiceStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_COMMON_EXPORT WebInstallServiceRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_COMMON_EXPORT WebInstallServiceResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};








class BLINK_COMMON_EXPORT InstallOptions {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<InstallOptions, T>::value>;
  using DataView = InstallOptionsDataView;
  using Data_ = internal::InstallOptions_Data;

  template <typename... Args>
  static InstallOptionsPtr New(Args&&... args) {
    return InstallOptionsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static InstallOptionsPtr From(const U& u) {
    return mojo::TypeConverter<InstallOptionsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, InstallOptions>::Convert(*this);
  }


  InstallOptions();

  InstallOptions(
      const ::GURL& install_url,
      const std::optional<::GURL>& manifest_id);


  ~InstallOptions();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = InstallOptionsPtr>
  InstallOptionsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, InstallOptions::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, InstallOptions::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, InstallOptions::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        InstallOptions::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        InstallOptions::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        InstallOptions::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::InstallOptions_UnserializedMessageContext<
            UserType, InstallOptions::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<InstallOptions::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return InstallOptions::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::InstallOptions_UnserializedMessageContext<
            UserType, InstallOptions::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<InstallOptions::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::GURL install_url;
  
  std::optional<::GURL> manifest_id;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, InstallOptions::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, InstallOptions::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, InstallOptions::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, InstallOptions::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
InstallOptionsPtr InstallOptions::Clone() const {
  return New(
      mojo::Clone(install_url),
      mojo::Clone(manifest_id)
  );
}

template <typename T, InstallOptions::EnableIfSame<T>*>
bool InstallOptions::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->install_url, other_struct.install_url))
    return false;
  if (!mojo::Equals(this->manifest_id, other_struct.manifest_id))
    return false;
  return true;
}

template <typename T, InstallOptions::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.install_url < rhs.install_url)
    return true;
  if (rhs.install_url < lhs.install_url)
    return false;
  if (lhs.manifest_id < rhs.manifest_id)
    return true;
  if (rhs.manifest_id < lhs.manifest_id)
    return false;
  return false;
}


}  // blink::mojom

namespace mojo {


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::InstallOptions::DataView,
                                         ::blink::mojom::InstallOptionsPtr> {
  static bool IsNull(const ::blink::mojom::InstallOptionsPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::InstallOptionsPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::InstallOptions::install_url)& install_url(
      const ::blink::mojom::InstallOptionsPtr& input) {
    return input->install_url;
  }

  static const decltype(::blink::mojom::InstallOptions::manifest_id)& manifest_id(
      const ::blink::mojom::InstallOptionsPtr& input) {
    return input->manifest_id;
  }

  static bool Read(::blink::mojom::InstallOptions::DataView input, ::blink::mojom::InstallOptionsPtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_WEB_INSTALL_WEB_INSTALL_MOJOM_H_