// third_party/blink/public/mojom/web_install/web_install.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_WEB_INSTALL_WEB_INSTALL_MOJOM_DATA_VIEW_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_WEB_INSTALL_WEB_INSTALL_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/blink/public/mojom/web_install/web_install.mojom-shared-internal.h"
#include "url/mojom/url.mojom-shared.h"


namespace blink::mojom {
class InstallOptionsDataView;



}  // blink::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::InstallOptionsDataView> {
  using Data = ::blink::mojom::internal::InstallOptions_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace blink::mojom {


enum class WebInstallServiceResult : int32_t {
  
  kSuccess = 0,
  
  kAbortError = 1,
  
  kDataError = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, WebInstallServiceResult value);
inline bool IsKnownEnumValue(WebInstallServiceResult value) {
  return internal::WebInstallServiceResult_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class WebInstallServiceInterfaceBase {};

using WebInstallServicePtrDataView =
    mojo::InterfacePtrDataView<WebInstallServiceInterfaceBase>;
using WebInstallServiceRequestDataView =
    mojo::InterfaceRequestDataView<WebInstallServiceInterfaceBase>;
using WebInstallServiceAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<WebInstallServiceInterfaceBase>;
using WebInstallServiceAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<WebInstallServiceInterfaceBase>;


class InstallOptionsDataView {
 public:
  InstallOptionsDataView() = default;

  InstallOptionsDataView(
      internal::InstallOptions_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetInstallUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInstallUrl(UserType* output) {
    
    auto* pointer = data_->install_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetManifestIdDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadManifestId(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::url::mojom::UrlDataView, UserType>(),
    "Attempting to read the optional `manifest_id` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadManifestId` instead "
    "of `ReadManifestId if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->manifest_id.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
 private:
  internal::InstallOptions_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // blink::mojom

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_WEB_INSTALL_WEB_INSTALL_MOJOM_DATA_VIEW_H_