// third_party/blink/public/mojom/user_agent/user_agent_metadata.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_USER_AGENT_USER_AGENT_METADATA_MOJOM_SHARED_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_USER_AGENT_USER_AGENT_METADATA_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/user_agent/user_agent_metadata.mojom-shared-internal.h"




#include "third_party/blink/public/mojom/user_agent/user_agent_metadata.mojom-data-view.h"
#include "base/component_export.h"




namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::UserAgentBrandVersionDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::UserAgentBrandVersionDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::UserAgentBrandVersion_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::brand(input)) in_brand = Traits::brand(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->brand)::BaseType> brand_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_brand,
      brand_fragment);

    fragment->brand.Set(
        brand_fragment.is_null() ? nullptr : brand_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->brand.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null brand in UserAgentBrandVersion struct");

    decltype(Traits::version(input)) in_version = Traits::version(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->version)::BaseType> version_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_version,
      version_fragment);

    fragment->version.Set(
        version_fragment.is_null() ? nullptr : version_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->version.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null version in UserAgentBrandVersion struct");
  }

  static bool Deserialize(::blink::mojom::internal::UserAgentBrandVersion_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::UserAgentBrandVersionDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::UserAgentMetadataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::UserAgentMetadataDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::UserAgentMetadata_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::brand_version_list(input)) in_brand_version_list = Traits::brand_version_list(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->brand_version_list)::BaseType>
        brand_version_list_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& brand_version_list_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::UserAgentBrandVersionDataView>>(
      in_brand_version_list,
      brand_version_list_fragment,
      &brand_version_list_validate_params);

    fragment->brand_version_list.Set(
        brand_version_list_fragment.is_null() ? nullptr : brand_version_list_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->brand_version_list.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null brand_version_list in UserAgentMetadata struct");

    decltype(Traits::brand_full_version_list(input)) in_brand_full_version_list = Traits::brand_full_version_list(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->brand_full_version_list)::BaseType>
        brand_full_version_list_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& brand_full_version_list_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::UserAgentBrandVersionDataView>>(
      in_brand_full_version_list,
      brand_full_version_list_fragment,
      &brand_full_version_list_validate_params);

    fragment->brand_full_version_list.Set(
        brand_full_version_list_fragment.is_null() ? nullptr : brand_full_version_list_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->brand_full_version_list.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null brand_full_version_list in UserAgentMetadata struct");

    decltype(Traits::full_version(input)) in_full_version = Traits::full_version(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->full_version)::BaseType> full_version_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_full_version,
      full_version_fragment);

    fragment->full_version.Set(
        full_version_fragment.is_null() ? nullptr : full_version_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->full_version.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null full_version in UserAgentMetadata struct");

    decltype(Traits::platform(input)) in_platform = Traits::platform(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->platform)::BaseType> platform_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_platform,
      platform_fragment);

    fragment->platform.Set(
        platform_fragment.is_null() ? nullptr : platform_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->platform.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null platform in UserAgentMetadata struct");

    decltype(Traits::platform_version(input)) in_platform_version = Traits::platform_version(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->platform_version)::BaseType> platform_version_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_platform_version,
      platform_version_fragment);

    fragment->platform_version.Set(
        platform_version_fragment.is_null() ? nullptr : platform_version_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->platform_version.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null platform_version in UserAgentMetadata struct");

    decltype(Traits::architecture(input)) in_architecture = Traits::architecture(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->architecture)::BaseType> architecture_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_architecture,
      architecture_fragment);

    fragment->architecture.Set(
        architecture_fragment.is_null() ? nullptr : architecture_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->architecture.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null architecture in UserAgentMetadata struct");

    decltype(Traits::model(input)) in_model = Traits::model(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->model)::BaseType> model_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_model,
      model_fragment);

    fragment->model.Set(
        model_fragment.is_null() ? nullptr : model_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->model.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null model in UserAgentMetadata struct");

    fragment->mobile = Traits::mobile(input);

    decltype(Traits::bitness(input)) in_bitness = Traits::bitness(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->bitness)::BaseType> bitness_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_bitness,
      bitness_fragment);

    fragment->bitness.Set(
        bitness_fragment.is_null() ? nullptr : bitness_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->bitness.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null bitness in UserAgentMetadata struct");

    fragment->wow64 = Traits::wow64(input);

    decltype(Traits::form_factors(input)) in_form_factors = Traits::form_factors(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->form_factors)::BaseType>
        form_factors_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& form_factors_validate_params =
        mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
      in_form_factors,
      form_factors_fragment,
      &form_factors_validate_params);

    fragment->form_factors.Set(
        form_factors_fragment.is_null() ? nullptr : form_factors_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->form_factors.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null form_factors in UserAgentMetadata struct");
  }

  static bool Deserialize(::blink::mojom::internal::UserAgentMetadata_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::UserAgentMetadataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::UserAgentOverrideDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::UserAgentOverrideDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::UserAgentOverride_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::ua_string_override(input)) in_ua_string_override = Traits::ua_string_override(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->ua_string_override)::BaseType> ua_string_override_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_ua_string_override,
      ua_string_override_fragment);

    fragment->ua_string_override.Set(
        ua_string_override_fragment.is_null() ? nullptr : ua_string_override_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->ua_string_override.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null ua_string_override in UserAgentOverride struct");

    decltype(Traits::ua_metadata_override(input)) in_ua_metadata_override = Traits::ua_metadata_override(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->ua_metadata_override)::BaseType> ua_metadata_override_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::UserAgentMetadataDataView>(
      in_ua_metadata_override,
      ua_metadata_override_fragment);

    fragment->ua_metadata_override.Set(
        ua_metadata_override_fragment.is_null() ? nullptr : ua_metadata_override_fragment.data());
  }

  static bool Deserialize(::blink::mojom::internal::UserAgentOverride_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::UserAgentOverrideDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace blink::mojom {

inline void UserAgentBrandVersionDataView::GetBrandDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->brand.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void UserAgentBrandVersionDataView::GetVersionDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->version.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void UserAgentMetadataDataView::GetBrandVersionListDataView(
    mojo::ArrayDataView<UserAgentBrandVersionDataView>* output) {
  auto pointer = data_->brand_version_list.Get();
  *output = mojo::ArrayDataView<UserAgentBrandVersionDataView>(pointer, message_);
}
inline void UserAgentMetadataDataView::GetBrandFullVersionListDataView(
    mojo::ArrayDataView<UserAgentBrandVersionDataView>* output) {
  auto pointer = data_->brand_full_version_list.Get();
  *output = mojo::ArrayDataView<UserAgentBrandVersionDataView>(pointer, message_);
}
inline void UserAgentMetadataDataView::GetFullVersionDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->full_version.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void UserAgentMetadataDataView::GetPlatformDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->platform.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void UserAgentMetadataDataView::GetPlatformVersionDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->platform_version.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void UserAgentMetadataDataView::GetArchitectureDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->architecture.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void UserAgentMetadataDataView::GetModelDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->model.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void UserAgentMetadataDataView::GetBitnessDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->bitness.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void UserAgentMetadataDataView::GetFormFactorsDataView(
    mojo::ArrayDataView<mojo::StringDataView>* output) {
  auto pointer = data_->form_factors.Get();
  *output = mojo::ArrayDataView<mojo::StringDataView>(pointer, message_);
}


inline void UserAgentOverrideDataView::GetUaStringOverrideDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->ua_string_override.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void UserAgentOverrideDataView::GetUaMetadataOverrideDataView(
    UserAgentMetadataDataView* output) {
  auto pointer = data_->ua_metadata_override.Get();
  *output = UserAgentMetadataDataView(pointer, message_);
}



}  // blink::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_USER_AGENT_USER_AGENT_METADATA_MOJOM_SHARED_H_