// third_party/blink/public/mojom/usb/web_usb_service.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/usb/web_usb_service.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/usb/web_usb_service.mojom-params-data.h"
#include "third_party/blink/public/mojom/usb/web_usb_service.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/usb/web_usb_service.mojom-blink-import-headers.h"
#include "third_party/blink/public/mojom/usb/web_usb_service.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace blink::mojom::blink {
WebUsbRequestDeviceOptions::WebUsbRequestDeviceOptions()
    : filters(),
      exclusion_filters() {}

WebUsbRequestDeviceOptions::WebUsbRequestDeviceOptions(
    ::blink::Vector<::device::mojom::blink::UsbDeviceFilterPtr> filters_in,
    ::blink::Vector<::device::mojom::blink::UsbDeviceFilterPtr> exclusion_filters_in)
    : filters(std::move(filters_in)),
      exclusion_filters(std::move(exclusion_filters_in)) {}

WebUsbRequestDeviceOptions::~WebUsbRequestDeviceOptions() = default;

void WebUsbRequestDeviceOptions::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "filters"), this->filters,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::Vector<::device::mojom::blink::UsbDeviceFilterPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "exclusion_filters"), this->exclusion_filters,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::Vector<::device::mojom::blink::UsbDeviceFilterPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool WebUsbRequestDeviceOptions::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

WebUsbService::IPCStableHashFunction WebUsbService::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::WebUsbService>(message.name())) {
    case messages::WebUsbService::kGetDevices: {
      return &WebUsbService::GetDevices_Sym::IPCStableHash;
    }
    case messages::WebUsbService::kGetDevice: {
      return &WebUsbService::GetDevice_Sym::IPCStableHash;
    }
    case messages::WebUsbService::kGetPermission: {
      return &WebUsbService::GetPermission_Sym::IPCStableHash;
    }
    case messages::WebUsbService::kForgetDevice: {
      return &WebUsbService::ForgetDevice_Sym::IPCStableHash;
    }
    case messages::WebUsbService::kSetClient: {
      return &WebUsbService::SetClient_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* WebUsbService::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::WebUsbService>(message.name())) {
      case messages::WebUsbService::kGetDevices:
            return "Receive blink::mojom::WebUsbService::GetDevices";
      case messages::WebUsbService::kGetDevice:
            return "Receive blink::mojom::WebUsbService::GetDevice";
      case messages::WebUsbService::kGetPermission:
            return "Receive blink::mojom::WebUsbService::GetPermission";
      case messages::WebUsbService::kForgetDevice:
            return "Receive blink::mojom::WebUsbService::ForgetDevice";
      case messages::WebUsbService::kSetClient:
            return "Receive blink::mojom::WebUsbService::SetClient";
    }
  } else {
    switch (static_cast<messages::WebUsbService>(message.name())) {
      case messages::WebUsbService::kGetDevices:
            return "Receive reply blink::mojom::WebUsbService::GetDevices";
      case messages::WebUsbService::kGetDevice:
            return "Receive reply blink::mojom::WebUsbService::GetDevice";
      case messages::WebUsbService::kGetPermission:
            return "Receive reply blink::mojom::WebUsbService::GetPermission";
      case messages::WebUsbService::kForgetDevice:
            return "Receive reply blink::mojom::WebUsbService::ForgetDevice";
      case messages::WebUsbService::kSetClient:
            return "Receive reply blink::mojom::WebUsbService::SetClient";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t WebUsbService::GetDevices_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x6eeb5ec3;  // IPCStableHash for blink::mojom::WebUsbService::GetDevices
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebUsbService::GetDevice_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x54d7de23;  // IPCStableHash for blink::mojom::WebUsbService::GetDevice
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebUsbService::GetPermission_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x0d2f4685;  // IPCStableHash for blink::mojom::WebUsbService::GetPermission
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebUsbService::ForgetDevice_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa118ff16;  // IPCStableHash for blink::mojom::WebUsbService::ForgetDevice
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebUsbService::SetClient_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x6b7bc0dc;  // IPCStableHash for blink::mojom::WebUsbService::SetClient
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class WebUsbService_GetDevices_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  WebUsbService_GetDevices_ForwardToCallback(
      WebUsbService::GetDevicesCallback callback
      ) : callback_(std::move(callback)) {
  }

  WebUsbService_GetDevices_ForwardToCallback(const WebUsbService_GetDevices_ForwardToCallback&) = delete;
  WebUsbService_GetDevices_ForwardToCallback& operator=(const WebUsbService_GetDevices_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  WebUsbService::GetDevicesCallback callback_;
};

class WebUsbService_GetPermission_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  WebUsbService_GetPermission_ForwardToCallback(
      WebUsbService::GetPermissionCallback callback
      ) : callback_(std::move(callback)) {
  }

  WebUsbService_GetPermission_ForwardToCallback(const WebUsbService_GetPermission_ForwardToCallback&) = delete;
  WebUsbService_GetPermission_ForwardToCallback& operator=(const WebUsbService_GetPermission_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  WebUsbService::GetPermissionCallback callback_;
};

class WebUsbService_ForgetDevice_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  WebUsbService_ForgetDevice_ForwardToCallback(
      WebUsbService::ForgetDeviceCallback callback
      ) : callback_(std::move(callback)) {
  }

  WebUsbService_ForgetDevice_ForwardToCallback(const WebUsbService_ForgetDevice_ForwardToCallback&) = delete;
  WebUsbService_ForgetDevice_ForwardToCallback& operator=(const WebUsbService_ForgetDevice_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  WebUsbService::ForgetDeviceCallback callback_;
};

WebUsbServiceProxy::WebUsbServiceProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void WebUsbServiceProxy::GetDevices(
    GetDevicesCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::WebUsbService::GetDevices");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebUsbService::kGetDevices), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::WebUsbService_GetDevices_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebUsbService::Name_);
  message.set_method_name("GetDevices");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WebUsbService_GetDevices_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void WebUsbServiceProxy::GetDevice(
    const ::blink::String& in_guid, ::mojo::PendingReceiver<::device::mojom::blink::UsbDevice> in_device_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::WebUsbService::GetDevice", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("guid"), in_guid,
                        "<value of type const ::blink::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("device_receiver"), in_device_receiver,
                        "<value of type ::mojo::PendingReceiver<::device::mojom::blink::UsbDevice>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebUsbService::kGetDevice), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::WebUsbService_GetDevice_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->guid)::BaseType> guid_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_guid,
    guid_fragment);

  params->guid.Set(
      guid_fragment.is_null() ? nullptr : guid_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->guid.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null guid in WebUsbService.GetDevice request");

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::device::mojom::UsbDeviceInterfaceBase>>(
    in_device_receiver,
    &params->device_receiver,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->device_receiver)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid device_receiver in WebUsbService.GetDevice request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebUsbService::Name_);
  message.set_method_name("GetDevice");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebUsbServiceProxy::GetPermission(
    WebUsbRequestDeviceOptionsPtr in_options, GetPermissionCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::WebUsbService::GetPermission", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("options"), in_options,
                        "<value of type WebUsbRequestDeviceOptionsPtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebUsbService::kGetPermission), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::WebUsbService_GetPermission_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->options)::BaseType> options_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::WebUsbRequestDeviceOptionsDataView>(
    in_options,
    options_fragment);

  params->options.Set(
      options_fragment.is_null() ? nullptr : options_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->options.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null options in WebUsbService.GetPermission request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebUsbService::Name_);
  message.set_method_name("GetPermission");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WebUsbService_GetPermission_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void WebUsbServiceProxy::ForgetDevice(
    const ::blink::String& in_guid, ForgetDeviceCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::WebUsbService::ForgetDevice", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("guid"), in_guid,
                        "<value of type const ::blink::String&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebUsbService::kForgetDevice), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::WebUsbService_ForgetDevice_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->guid)::BaseType> guid_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_guid,
    guid_fragment);

  params->guid.Set(
      guid_fragment.is_null() ? nullptr : guid_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->guid.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null guid in WebUsbService.ForgetDevice request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebUsbService::Name_);
  message.set_method_name("ForgetDevice");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WebUsbService_ForgetDevice_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void WebUsbServiceProxy::SetClient(
    ::mojo::PendingAssociatedRemote<::device::mojom::blink::UsbDeviceManagerClient> in_client) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::WebUsbService::SetClient", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client,
                        "<value of type ::mojo::PendingAssociatedRemote<::device::mojom::blink::UsbDeviceManagerClient>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebUsbService::kSetClient), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::WebUsbService_SetClient_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::device::mojom::UsbDeviceManagerClientAssociatedPtrInfoDataView>(
    in_client,
    &params->client,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->client)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
    "invalid client in WebUsbService.SetClient request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebUsbService::Name_);
  message.set_method_name("SetClient");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class WebUsbService_GetDevices_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static WebUsbService::GetDevicesCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<WebUsbService_GetDevices_ProxyToResponder> proxy(
        new WebUsbService_GetDevices_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&WebUsbService_GetDevices_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~WebUsbService_GetDevices_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  WebUsbService_GetDevices_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "WebUsbService::GetDevicesCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::Vector<::device::mojom::blink::UsbDeviceInfoPtr> in_results);
};

bool WebUsbService_GetDevices_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::WebUsbService_GetDevices_ResponseParams_Data* params =
      reinterpret_cast<
          internal::WebUsbService_GetDevices_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for WebUsbService.0
  bool success = true;
  ::blink::Vector<::device::mojom::blink::UsbDeviceInfoPtr> p_results{};
  WebUsbService_GetDevices_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResults(&p_results))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WebUsbService::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_results));
  }
  return true;
}

void WebUsbService_GetDevices_ProxyToResponder::Run(
    ::blink::Vector<::device::mojom::blink::UsbDeviceInfoPtr> in_results) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::WebUsbService::GetDevices", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("results"), in_results,
                        "<value of type ::blink::Vector<::device::mojom::blink::UsbDeviceInfoPtr>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebUsbService::kGetDevices), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::WebUsbService_GetDevices_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->results)::BaseType>
      results_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& results_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::device::mojom::UsbDeviceInfoDataView>>(
    in_results,
    results_fragment,
    &results_validate_params);

  params->results.Set(
      results_fragment.is_null() ? nullptr : results_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->results.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null results in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebUsbService::Name_);
  message.set_method_name("GetDevices");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class WebUsbService_GetPermission_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static WebUsbService::GetPermissionCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<WebUsbService_GetPermission_ProxyToResponder> proxy(
        new WebUsbService_GetPermission_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&WebUsbService_GetPermission_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~WebUsbService_GetPermission_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  WebUsbService_GetPermission_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "WebUsbService::GetPermissionCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::device::mojom::blink::UsbDeviceInfoPtr in_result);
};

bool WebUsbService_GetPermission_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::WebUsbService_GetPermission_ResponseParams_Data* params =
      reinterpret_cast<
          internal::WebUsbService_GetPermission_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for WebUsbService.2
  bool success = true;
  ::device::mojom::blink::UsbDeviceInfoPtr p_result{};
  WebUsbService_GetPermission_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WebUsbService::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void WebUsbService_GetPermission_ProxyToResponder::Run(
    ::device::mojom::blink::UsbDeviceInfoPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::WebUsbService::GetPermission", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type ::device::mojom::blink::UsbDeviceInfoPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebUsbService::kGetPermission), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::WebUsbService_GetPermission_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->result)::BaseType> result_fragment(
          params.message());
  
  mojo::internal::Serialize<::device::mojom::UsbDeviceInfoDataView>(
    in_result,
    result_fragment);

  params->result.Set(
      result_fragment.is_null() ? nullptr : result_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebUsbService::Name_);
  message.set_method_name("GetPermission");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class WebUsbService_ForgetDevice_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static WebUsbService::ForgetDeviceCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<WebUsbService_ForgetDevice_ProxyToResponder> proxy(
        new WebUsbService_ForgetDevice_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&WebUsbService_ForgetDevice_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~WebUsbService_ForgetDevice_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  WebUsbService_ForgetDevice_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "WebUsbService::ForgetDeviceCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool WebUsbService_ForgetDevice_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::WebUsbService_ForgetDevice_ResponseParams_Data* params =
      reinterpret_cast<
          internal::WebUsbService_ForgetDevice_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for WebUsbService.3
  bool success = true;
  WebUsbService_ForgetDevice_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WebUsbService::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void WebUsbService_ForgetDevice_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply blink::mojom::WebUsbService::ForgetDevice");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebUsbService::kForgetDevice), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::WebUsbService_ForgetDevice_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebUsbService::Name_);
  message.set_method_name("ForgetDevice");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool WebUsbServiceStubDispatch::Accept(
    WebUsbService* impl,
    mojo::Message* message) {
  switch (static_cast<messages::WebUsbService>(message->header()->name)) {
    case messages::WebUsbService::kGetDevices: {
      break;
    }
    case messages::WebUsbService::kGetDevice: {
      DCHECK(message->is_serialized());
      internal::WebUsbService_GetDevice_Params_Data* params =
          reinterpret_cast<internal::WebUsbService_GetDevice_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebUsbService.1
      bool success = true;
      ::blink::String p_guid{};
      ::mojo::PendingReceiver<::device::mojom::blink::UsbDevice> p_device_receiver{};
      WebUsbService_GetDevice_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadGuid(&p_guid))
        success = false;
      if (success) {
        p_device_receiver =
            input_data_view.TakeDeviceReceiver<decltype(p_device_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebUsbService::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetDevice(        
        std::move(p_guid), 
        std::move(p_device_receiver));
      return true;
    }
    case messages::WebUsbService::kGetPermission: {
      break;
    }
    case messages::WebUsbService::kForgetDevice: {
      break;
    }
    case messages::WebUsbService::kSetClient: {
      DCHECK(message->is_serialized());
      internal::WebUsbService_SetClient_Params_Data* params =
          reinterpret_cast<internal::WebUsbService_SetClient_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebUsbService.4
      bool success = true;
      ::mojo::PendingAssociatedRemote<::device::mojom::blink::UsbDeviceManagerClient> p_client{};
      WebUsbService_SetClient_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebUsbService::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetClient(        
        std::move(p_client));
      return true;
    }
  }
  return false;
}

// static
bool WebUsbServiceStubDispatch::AcceptWithResponder(
    WebUsbService* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::WebUsbService>(message->header()->name)) {
    case messages::WebUsbService::kGetDevices: {
      internal::WebUsbService_GetDevices_Params_Data* params =
          reinterpret_cast<
              internal::WebUsbService_GetDevices_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for WebUsbService.0
      bool success = true;
      WebUsbService_GetDevices_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebUsbService::Name_, 0, false);
        return false;
      }
      auto callback =
          WebUsbService_GetDevices_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetDevices(std::move(callback));
      return true;
    }
    case messages::WebUsbService::kGetDevice: {
      break;
    }
    case messages::WebUsbService::kGetPermission: {
      internal::WebUsbService_GetPermission_Params_Data* params =
          reinterpret_cast<
              internal::WebUsbService_GetPermission_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for WebUsbService.2
      bool success = true;
      WebUsbRequestDeviceOptionsPtr p_options{};
      WebUsbService_GetPermission_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadOptions(&p_options))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebUsbService::Name_, 2, false);
        return false;
      }
      auto callback =
          WebUsbService_GetPermission_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetPermission(        
        std::move(p_options), std::move(callback));
      return true;
    }
    case messages::WebUsbService::kForgetDevice: {
      internal::WebUsbService_ForgetDevice_Params_Data* params =
          reinterpret_cast<
              internal::WebUsbService_ForgetDevice_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for WebUsbService.3
      bool success = true;
      ::blink::String p_guid{};
      WebUsbService_ForgetDevice_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadGuid(&p_guid))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebUsbService::Name_, 3, false);
        return false;
      }
      auto callback =
          WebUsbService_ForgetDevice_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ForgetDevice(        
        std::move(p_guid), std::move(callback));
      return true;
    }
    case messages::WebUsbService::kSetClient: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kWebUsbServiceValidationInfo[] = {
    { &internal::WebUsbService_GetDevices_Params_Data::Validate,
     &internal::WebUsbService_GetDevices_ResponseParams_Data::Validate},
    { &internal::WebUsbService_GetDevice_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebUsbService_GetPermission_Params_Data::Validate,
     &internal::WebUsbService_GetPermission_ResponseParams_Data::Validate},
    { &internal::WebUsbService_ForgetDevice_Params_Data::Validate,
     &internal::WebUsbService_ForgetDevice_ResponseParams_Data::Validate},
    { &internal::WebUsbService_SetClient_Params_Data::Validate,
     nullptr /* no response */},
};

bool WebUsbServiceRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::blink::WebUsbService::Name_,
    kWebUsbServiceValidationInfo);
}

bool WebUsbServiceResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::blink::mojom::blink::WebUsbService::Name_,
    kWebUsbServiceValidationInfo);
}


}  // blink::mojom::blink


namespace mojo {


// static
bool StructTraits<::blink::mojom::blink::WebUsbRequestDeviceOptions::DataView, ::blink::mojom::blink::WebUsbRequestDeviceOptionsPtr>::Read(
    ::blink::mojom::blink::WebUsbRequestDeviceOptions::DataView input,
    ::blink::mojom::blink::WebUsbRequestDeviceOptionsPtr* output) {
  bool success = true;
  ::blink::mojom::blink::WebUsbRequestDeviceOptionsPtr result(::blink::mojom::blink::WebUsbRequestDeviceOptions::New());
  
      if (success && !input.ReadFilters(&result->filters))
        success = false;
      if (success && !input.ReadExclusionFilters(&result->exclusion_filters))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace blink::mojom::blink {


void WebUsbServiceInterceptorForTesting::GetDevices(GetDevicesCallback callback) {
  GetForwardingInterface()->GetDevices(std::move(callback));
}
void WebUsbServiceInterceptorForTesting::GetDevice(const ::blink::String& guid, ::mojo::PendingReceiver<::device::mojom::blink::UsbDevice> device_receiver) {
  GetForwardingInterface()->GetDevice(
    std::move(guid)
    , 
    std::move(device_receiver)
    );
}
void WebUsbServiceInterceptorForTesting::GetPermission(WebUsbRequestDeviceOptionsPtr options, GetPermissionCallback callback) {
  GetForwardingInterface()->GetPermission(
    std::move(options)
    , std::move(callback));
}
void WebUsbServiceInterceptorForTesting::ForgetDevice(const ::blink::String& guid, ForgetDeviceCallback callback) {
  GetForwardingInterface()->ForgetDevice(
    std::move(guid)
    , std::move(callback));
}
void WebUsbServiceInterceptorForTesting::SetClient(::mojo::PendingAssociatedRemote<::device::mojom::blink::UsbDeviceManagerClient> client) {
  GetForwardingInterface()->SetClient(
    std::move(client)
    );
}
WebUsbServiceAsyncWaiter::WebUsbServiceAsyncWaiter(
    WebUsbService* proxy) : proxy_(proxy) {}

WebUsbServiceAsyncWaiter::~WebUsbServiceAsyncWaiter() = default;


void WebUsbServiceAsyncWaiter::GetDevices(
    ::blink::Vector<::device::mojom::blink::UsbDeviceInfoPtr>* out_results) {
  base::RunLoop loop;
  proxy_->GetDevices(
      base::BindOnce(
          [](base::RunLoop* loop,
             ::blink::Vector<::device::mojom::blink::UsbDeviceInfoPtr>* out_results
,
             ::blink::Vector<::device::mojom::blink::UsbDeviceInfoPtr> results) {*out_results = std::move(results);
            loop->Quit();
          },
          &loop,
          out_results));
  loop.Run();
}

::blink::Vector<::device::mojom::blink::UsbDeviceInfoPtr> WebUsbServiceAsyncWaiter::GetDevices(
    ) {
  ::blink::Vector<::device::mojom::blink::UsbDeviceInfoPtr> async_wait_result;
  GetDevices(&async_wait_result);
  return async_wait_result;
}

void WebUsbServiceAsyncWaiter::GetPermission(
    WebUsbRequestDeviceOptionsPtr options, ::device::mojom::blink::UsbDeviceInfoPtr* out_result) {
  base::RunLoop loop;
  proxy_->GetPermission(
      std::move(options),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::device::mojom::blink::UsbDeviceInfoPtr* out_result
,
             ::device::mojom::blink::UsbDeviceInfoPtr result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

::device::mojom::blink::UsbDeviceInfoPtr WebUsbServiceAsyncWaiter::GetPermission(
    WebUsbRequestDeviceOptionsPtr options) {
  ::device::mojom::blink::UsbDeviceInfoPtr async_wait_result;
  GetPermission(std::move(options),&async_wait_result);
  return async_wait_result;
}

void WebUsbServiceAsyncWaiter::ForgetDevice(
    const ::blink::String& guid) {
  base::RunLoop loop;
  proxy_->ForgetDevice(
      std::move(guid),
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}








}  // blink::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif