// third_party/blink/public/mojom/timing/resource_timing.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_TIMING_RESOURCE_TIMING_MOJOM_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_TIMING_RESOURCE_TIMING_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/timing/resource_timing.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/timing/resource_timing.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/timing/resource_timing.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/time.mojom.h"
#include "services/network/public/mojom/fetch_api.mojom-forward.h"
#include "services/network/public/mojom/load_timing_info.mojom.h"
#include "services/network/public/mojom/service_worker_router_info.mojom.h"
#include "third_party/blink/public/mojom/fetch/fetch_api_request.mojom-forward.h"
#include "url/mojom/url.mojom.h"
#include <string>
#include <vector>




#include "third_party/blink/public/common/common_export.h"




namespace blink::mojom {





class BLINK_COMMON_EXPORT ServerTimingInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ServerTimingInfo, T>::value>;
  using DataView = ServerTimingInfoDataView;
  using Data_ = internal::ServerTimingInfo_Data;

  template <typename... Args>
  static ServerTimingInfoPtr New(Args&&... args) {
    return ServerTimingInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ServerTimingInfoPtr From(const U& u) {
    return mojo::TypeConverter<ServerTimingInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ServerTimingInfo>::Convert(*this);
  }


  ServerTimingInfo();

  ServerTimingInfo(
      const std::string& name,
      double duration,
      const std::string& description);


  ~ServerTimingInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ServerTimingInfoPtr>
  ServerTimingInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ServerTimingInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ServerTimingInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ServerTimingInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ServerTimingInfo::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ServerTimingInfo::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ServerTimingInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ServerTimingInfo_UnserializedMessageContext<
            UserType, ServerTimingInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ServerTimingInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ServerTimingInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ServerTimingInfo_UnserializedMessageContext<
            UserType, ServerTimingInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ServerTimingInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string name;
  
  double duration;
  
  std::string description;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ServerTimingInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ServerTimingInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ServerTimingInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ServerTimingInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}









class BLINK_COMMON_EXPORT ResourceTimingInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ResourceTimingInfo, T>::value>;
  using DataView = ResourceTimingInfoDataView;
  using Data_ = internal::ResourceTimingInfo_Data;

  template <typename... Args>
  static ResourceTimingInfoPtr New(Args&&... args) {
    return ResourceTimingInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ResourceTimingInfoPtr From(const U& u) {
    return mojo::TypeConverter<ResourceTimingInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ResourceTimingInfo>::Convert(*this);
  }


  ResourceTimingInfo();

  ResourceTimingInfo(
      const std::string& name,
      ::base::TimeTicks start_time,
      const std::string& alpn_negotiated_protocol,
      const std::string& connection_info,
      const std::optional<::net::LoadTimingInfo>& timing,
      ::base::TimeTicks last_redirect_end_time,
      ::base::TimeTicks response_end,
      CacheState cache_state,
      uint64_t encoded_body_size,
      uint64_t decoded_body_size,
      bool did_reuse_connection,
      bool is_secure_transport,
      bool allow_timing_details,
      bool allow_negative_values,
      std::vector<ServerTimingInfoPtr> server_timing,
      bool render_blocking_status,
      uint16_t response_status,
      const std::string& content_type,
      const std::string& content_encoding,
      const ::GURL& initiator_url,
      ::network::mojom::ServiceWorkerRouterInfoPtr service_worker_router_info,
      ::network::mojom::FetchResponseSource service_worker_response_source);

ResourceTimingInfo(const ResourceTimingInfo&) = delete;
ResourceTimingInfo& operator=(const ResourceTimingInfo&) = delete;

  ~ResourceTimingInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ResourceTimingInfoPtr>
  ResourceTimingInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ResourceTimingInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ResourceTimingInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ResourceTimingInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ResourceTimingInfo::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ResourceTimingInfo::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ResourceTimingInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ResourceTimingInfo_UnserializedMessageContext<
            UserType, ResourceTimingInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ResourceTimingInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ResourceTimingInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ResourceTimingInfo_UnserializedMessageContext<
            UserType, ResourceTimingInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ResourceTimingInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string name;
  
  ::base::TimeTicks start_time;
  
  std::string alpn_negotiated_protocol;
  
  std::string connection_info;
  
  std::optional<::net::LoadTimingInfo> timing;
  
  ::base::TimeTicks last_redirect_end_time;
  
  ::base::TimeTicks response_end;
  
  CacheState cache_state;
  
  uint64_t encoded_body_size;
  
  uint64_t decoded_body_size;
  
  bool did_reuse_connection;
  
  bool is_secure_transport;
  
  bool allow_timing_details;
  
  bool allow_negative_values;
  
  std::vector<ServerTimingInfoPtr> server_timing;
  
  bool render_blocking_status;
  
  uint16_t response_status;
  
  std::string content_type;
  
  std::string content_encoding;
  
  ::GURL initiator_url;
  
  ::network::mojom::ServiceWorkerRouterInfoPtr service_worker_router_info;
  
  ::network::mojom::FetchResponseSource service_worker_response_source;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ResourceTimingInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ResourceTimingInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ResourceTimingInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ResourceTimingInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
ServerTimingInfoPtr ServerTimingInfo::Clone() const {
  return New(
      mojo::Clone(name),
      mojo::Clone(duration),
      mojo::Clone(description)
  );
}

template <typename T, ServerTimingInfo::EnableIfSame<T>*>
bool ServerTimingInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->name, other_struct.name))
    return false;
  if (!mojo::Equals(this->duration, other_struct.duration))
    return false;
  if (!mojo::Equals(this->description, other_struct.description))
    return false;
  return true;
}

template <typename T, ServerTimingInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.name < rhs.name)
    return true;
  if (rhs.name < lhs.name)
    return false;
  if (lhs.duration < rhs.duration)
    return true;
  if (rhs.duration < lhs.duration)
    return false;
  if (lhs.description < rhs.description)
    return true;
  if (rhs.description < lhs.description)
    return false;
  return false;
}
template <typename StructPtrType>
ResourceTimingInfoPtr ResourceTimingInfo::Clone() const {
  return New(
      mojo::Clone(name),
      mojo::Clone(start_time),
      mojo::Clone(alpn_negotiated_protocol),
      mojo::Clone(connection_info),
      mojo::Clone(timing),
      mojo::Clone(last_redirect_end_time),
      mojo::Clone(response_end),
      mojo::Clone(cache_state),
      mojo::Clone(encoded_body_size),
      mojo::Clone(decoded_body_size),
      mojo::Clone(did_reuse_connection),
      mojo::Clone(is_secure_transport),
      mojo::Clone(allow_timing_details),
      mojo::Clone(allow_negative_values),
      mojo::Clone(server_timing),
      mojo::Clone(render_blocking_status),
      mojo::Clone(response_status),
      mojo::Clone(content_type),
      mojo::Clone(content_encoding),
      mojo::Clone(initiator_url),
      mojo::Clone(service_worker_router_info),
      mojo::Clone(service_worker_response_source)
  );
}

template <typename T, ResourceTimingInfo::EnableIfSame<T>*>
bool ResourceTimingInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->name, other_struct.name))
    return false;
  if (!mojo::Equals(this->start_time, other_struct.start_time))
    return false;
  if (!mojo::Equals(this->alpn_negotiated_protocol, other_struct.alpn_negotiated_protocol))
    return false;
  if (!mojo::Equals(this->connection_info, other_struct.connection_info))
    return false;
  if (!mojo::Equals(this->timing, other_struct.timing))
    return false;
  if (!mojo::Equals(this->last_redirect_end_time, other_struct.last_redirect_end_time))
    return false;
  if (!mojo::Equals(this->response_end, other_struct.response_end))
    return false;
  if (!mojo::Equals(this->cache_state, other_struct.cache_state))
    return false;
  if (!mojo::Equals(this->encoded_body_size, other_struct.encoded_body_size))
    return false;
  if (!mojo::Equals(this->decoded_body_size, other_struct.decoded_body_size))
    return false;
  if (!mojo::Equals(this->did_reuse_connection, other_struct.did_reuse_connection))
    return false;
  if (!mojo::Equals(this->is_secure_transport, other_struct.is_secure_transport))
    return false;
  if (!mojo::Equals(this->allow_timing_details, other_struct.allow_timing_details))
    return false;
  if (!mojo::Equals(this->allow_negative_values, other_struct.allow_negative_values))
    return false;
  if (!mojo::Equals(this->server_timing, other_struct.server_timing))
    return false;
  if (!mojo::Equals(this->render_blocking_status, other_struct.render_blocking_status))
    return false;
  if (!mojo::Equals(this->response_status, other_struct.response_status))
    return false;
  if (!mojo::Equals(this->content_type, other_struct.content_type))
    return false;
  if (!mojo::Equals(this->content_encoding, other_struct.content_encoding))
    return false;
  if (!mojo::Equals(this->initiator_url, other_struct.initiator_url))
    return false;
  if (!mojo::Equals(this->service_worker_router_info, other_struct.service_worker_router_info))
    return false;
  if (!mojo::Equals(this->service_worker_response_source, other_struct.service_worker_response_source))
    return false;
  return true;
}

template <typename T, ResourceTimingInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.name < rhs.name)
    return true;
  if (rhs.name < lhs.name)
    return false;
  if (lhs.start_time < rhs.start_time)
    return true;
  if (rhs.start_time < lhs.start_time)
    return false;
  if (lhs.alpn_negotiated_protocol < rhs.alpn_negotiated_protocol)
    return true;
  if (rhs.alpn_negotiated_protocol < lhs.alpn_negotiated_protocol)
    return false;
  if (lhs.connection_info < rhs.connection_info)
    return true;
  if (rhs.connection_info < lhs.connection_info)
    return false;
  if (lhs.timing < rhs.timing)
    return true;
  if (rhs.timing < lhs.timing)
    return false;
  if (lhs.last_redirect_end_time < rhs.last_redirect_end_time)
    return true;
  if (rhs.last_redirect_end_time < lhs.last_redirect_end_time)
    return false;
  if (lhs.response_end < rhs.response_end)
    return true;
  if (rhs.response_end < lhs.response_end)
    return false;
  if (lhs.cache_state < rhs.cache_state)
    return true;
  if (rhs.cache_state < lhs.cache_state)
    return false;
  if (lhs.encoded_body_size < rhs.encoded_body_size)
    return true;
  if (rhs.encoded_body_size < lhs.encoded_body_size)
    return false;
  if (lhs.decoded_body_size < rhs.decoded_body_size)
    return true;
  if (rhs.decoded_body_size < lhs.decoded_body_size)
    return false;
  if (lhs.did_reuse_connection < rhs.did_reuse_connection)
    return true;
  if (rhs.did_reuse_connection < lhs.did_reuse_connection)
    return false;
  if (lhs.is_secure_transport < rhs.is_secure_transport)
    return true;
  if (rhs.is_secure_transport < lhs.is_secure_transport)
    return false;
  if (lhs.allow_timing_details < rhs.allow_timing_details)
    return true;
  if (rhs.allow_timing_details < lhs.allow_timing_details)
    return false;
  if (lhs.allow_negative_values < rhs.allow_negative_values)
    return true;
  if (rhs.allow_negative_values < lhs.allow_negative_values)
    return false;
  if (lhs.server_timing < rhs.server_timing)
    return true;
  if (rhs.server_timing < lhs.server_timing)
    return false;
  if (lhs.render_blocking_status < rhs.render_blocking_status)
    return true;
  if (rhs.render_blocking_status < lhs.render_blocking_status)
    return false;
  if (lhs.response_status < rhs.response_status)
    return true;
  if (rhs.response_status < lhs.response_status)
    return false;
  if (lhs.content_type < rhs.content_type)
    return true;
  if (rhs.content_type < lhs.content_type)
    return false;
  if (lhs.content_encoding < rhs.content_encoding)
    return true;
  if (rhs.content_encoding < lhs.content_encoding)
    return false;
  if (lhs.initiator_url < rhs.initiator_url)
    return true;
  if (rhs.initiator_url < lhs.initiator_url)
    return false;
  if (lhs.service_worker_router_info < rhs.service_worker_router_info)
    return true;
  if (rhs.service_worker_router_info < lhs.service_worker_router_info)
    return false;
  if (lhs.service_worker_response_source < rhs.service_worker_response_source)
    return true;
  if (rhs.service_worker_response_source < lhs.service_worker_response_source)
    return false;
  return false;
}


}  // blink::mojom

namespace mojo {


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::ServerTimingInfo::DataView,
                                         ::blink::mojom::ServerTimingInfoPtr> {
  static bool IsNull(const ::blink::mojom::ServerTimingInfoPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::ServerTimingInfoPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::ServerTimingInfo::name)& name(
      const ::blink::mojom::ServerTimingInfoPtr& input) {
    return input->name;
  }

  static decltype(::blink::mojom::ServerTimingInfo::duration) duration(
      const ::blink::mojom::ServerTimingInfoPtr& input) {
    return input->duration;
  }

  static const decltype(::blink::mojom::ServerTimingInfo::description)& description(
      const ::blink::mojom::ServerTimingInfoPtr& input) {
    return input->description;
  }

  static bool Read(::blink::mojom::ServerTimingInfo::DataView input, ::blink::mojom::ServerTimingInfoPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::ResourceTimingInfo::DataView,
                                         ::blink::mojom::ResourceTimingInfoPtr> {
  static bool IsNull(const ::blink::mojom::ResourceTimingInfoPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::ResourceTimingInfoPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::ResourceTimingInfo::name)& name(
      const ::blink::mojom::ResourceTimingInfoPtr& input) {
    return input->name;
  }

  static const decltype(::blink::mojom::ResourceTimingInfo::start_time)& start_time(
      const ::blink::mojom::ResourceTimingInfoPtr& input) {
    return input->start_time;
  }

  static const decltype(::blink::mojom::ResourceTimingInfo::alpn_negotiated_protocol)& alpn_negotiated_protocol(
      const ::blink::mojom::ResourceTimingInfoPtr& input) {
    return input->alpn_negotiated_protocol;
  }

  static const decltype(::blink::mojom::ResourceTimingInfo::connection_info)& connection_info(
      const ::blink::mojom::ResourceTimingInfoPtr& input) {
    return input->connection_info;
  }

  static const decltype(::blink::mojom::ResourceTimingInfo::timing)& timing(
      const ::blink::mojom::ResourceTimingInfoPtr& input) {
    return input->timing;
  }

  static const decltype(::blink::mojom::ResourceTimingInfo::last_redirect_end_time)& last_redirect_end_time(
      const ::blink::mojom::ResourceTimingInfoPtr& input) {
    return input->last_redirect_end_time;
  }

  static const decltype(::blink::mojom::ResourceTimingInfo::response_end)& response_end(
      const ::blink::mojom::ResourceTimingInfoPtr& input) {
    return input->response_end;
  }

  static decltype(::blink::mojom::ResourceTimingInfo::cache_state) cache_state(
      const ::blink::mojom::ResourceTimingInfoPtr& input) {
    return input->cache_state;
  }

  static decltype(::blink::mojom::ResourceTimingInfo::encoded_body_size) encoded_body_size(
      const ::blink::mojom::ResourceTimingInfoPtr& input) {
    return input->encoded_body_size;
  }

  static decltype(::blink::mojom::ResourceTimingInfo::decoded_body_size) decoded_body_size(
      const ::blink::mojom::ResourceTimingInfoPtr& input) {
    return input->decoded_body_size;
  }

  static decltype(::blink::mojom::ResourceTimingInfo::did_reuse_connection) did_reuse_connection(
      const ::blink::mojom::ResourceTimingInfoPtr& input) {
    return input->did_reuse_connection;
  }

  static decltype(::blink::mojom::ResourceTimingInfo::is_secure_transport) is_secure_transport(
      const ::blink::mojom::ResourceTimingInfoPtr& input) {
    return input->is_secure_transport;
  }

  static decltype(::blink::mojom::ResourceTimingInfo::allow_timing_details) allow_timing_details(
      const ::blink::mojom::ResourceTimingInfoPtr& input) {
    return input->allow_timing_details;
  }

  static decltype(::blink::mojom::ResourceTimingInfo::allow_negative_values) allow_negative_values(
      const ::blink::mojom::ResourceTimingInfoPtr& input) {
    return input->allow_negative_values;
  }

  static const decltype(::blink::mojom::ResourceTimingInfo::server_timing)& server_timing(
      const ::blink::mojom::ResourceTimingInfoPtr& input) {
    return input->server_timing;
  }

  static decltype(::blink::mojom::ResourceTimingInfo::render_blocking_status) render_blocking_status(
      const ::blink::mojom::ResourceTimingInfoPtr& input) {
    return input->render_blocking_status;
  }

  static decltype(::blink::mojom::ResourceTimingInfo::response_status) response_status(
      const ::blink::mojom::ResourceTimingInfoPtr& input) {
    return input->response_status;
  }

  static const decltype(::blink::mojom::ResourceTimingInfo::content_type)& content_type(
      const ::blink::mojom::ResourceTimingInfoPtr& input) {
    return input->content_type;
  }

  static const decltype(::blink::mojom::ResourceTimingInfo::content_encoding)& content_encoding(
      const ::blink::mojom::ResourceTimingInfoPtr& input) {
    return input->content_encoding;
  }

  static const decltype(::blink::mojom::ResourceTimingInfo::initiator_url)& initiator_url(
      const ::blink::mojom::ResourceTimingInfoPtr& input) {
    return input->initiator_url;
  }

  static const decltype(::blink::mojom::ResourceTimingInfo::service_worker_router_info)& service_worker_router_info(
      const ::blink::mojom::ResourceTimingInfoPtr& input) {
    return input->service_worker_router_info;
  }

  static decltype(::blink::mojom::ResourceTimingInfo::service_worker_response_source) service_worker_response_source(
      const ::blink::mojom::ResourceTimingInfoPtr& input) {
    return input->service_worker_response_source;
  }

  static bool Read(::blink::mojom::ResourceTimingInfo::DataView input, ::blink::mojom::ResourceTimingInfoPtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_TIMING_RESOURCE_TIMING_MOJOM_H_