// third_party/blink/public/mojom/storage_key/storage_key.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'third_party/blink/public/mojom/storage_key/storage_key.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('blink.mojom');
  var unguessable_token$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/unguessable_token.mojom', '../../../../../mojo/public/mojom/base/unguessable_token.mojom.js');
  }
  var schemeful_site$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/schemeful_site.mojom', '../../../../../services/network/public/mojom/schemeful_site.mojom.js');
  }
  var ancestor_chain_bit$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/storage_key/ancestor_chain_bit.mojom', 'ancestor_chain_bit.mojom.js');
  }
  var origin$ =
      mojo.internal.exposeNamespace('url.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'url/mojom/origin.mojom', '../../../../../url/mojom/origin.mojom.js');
  }



  function StorageKey(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  StorageKey.prototype.initDefaults_ = function() {
    this.origin = null;
    this.topLevelSite = null;
    this.nonce = null;
    this.ancestorChainBit = 0;
    this.ancestorChainBitIfThirdPartyEnabled = 0;
    this.topLevelSiteIfThirdPartyEnabled = null;
  };
  StorageKey.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  StorageKey.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 48}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate StorageKey.origin
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, origin$.Origin, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate StorageKey.topLevelSite
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, schemeful_site$.SchemefulSite, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate StorageKey.nonce
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, unguessable_token$.UnguessableToken, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate StorageKey.ancestorChainBit
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 24, ancestor_chain_bit$.AncestorChainBit);
    if (err !== validator.validationError.NONE)
        return err;


    // validate StorageKey.topLevelSiteIfThirdPartyEnabled
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 32, schemeful_site$.SchemefulSite, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate StorageKey.ancestorChainBitIfThirdPartyEnabled
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 28, ancestor_chain_bit$.AncestorChainBit);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  StorageKey.encodedSize = codec.kStructHeaderSize + 40;

  StorageKey.decode = function(decoder) {
    var packed;
    var val = new StorageKey();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.origin =
        decoder.decodeStructPointer(origin$.Origin);
    val.topLevelSite =
        decoder.decodeStructPointer(schemeful_site$.SchemefulSite);
    val.nonce =
        decoder.decodeStructPointer(unguessable_token$.UnguessableToken);
    val.ancestorChainBit =
        decoder.decodeStruct(new codec.Enum(ancestor_chain_bit$.AncestorChainBit));
    val.ancestorChainBitIfThirdPartyEnabled =
        decoder.decodeStruct(new codec.Enum(ancestor_chain_bit$.AncestorChainBit));
    val.topLevelSiteIfThirdPartyEnabled =
        decoder.decodeStructPointer(schemeful_site$.SchemefulSite);
    return val;
  };

  StorageKey.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(StorageKey.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(origin$.Origin, val.origin);
    encoder.encodeStructPointer(schemeful_site$.SchemefulSite, val.topLevelSite);
    encoder.encodeStructPointer(unguessable_token$.UnguessableToken, val.nonce);
    encoder.encodeStruct(codec.Int32, val.ancestorChainBit);
    encoder.encodeStruct(codec.Int32, val.ancestorChainBitIfThirdPartyEnabled);
    encoder.encodeStructPointer(schemeful_site$.SchemefulSite, val.topLevelSiteIfThirdPartyEnabled);
  };
  exports.StorageKey = StorageKey;
})();