// third_party/blink/public/mojom/storage_key/storage_key.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_STORAGE_KEY_STORAGE_KEY_MOJOM_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_STORAGE_KEY_STORAGE_KEY_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/storage_key/storage_key.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/storage_key/storage_key.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/storage_key/storage_key.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/unguessable_token.mojom.h"
#include "services/network/public/mojom/schemeful_site.mojom.h"
#include "third_party/blink/public/mojom/storage_key/ancestor_chain_bit.mojom-forward.h"
#include "url/mojom/origin.mojom.h"
#include <string>
#include <vector>




#include "third_party/blink/public/common/storage_key/storage_key_mojom_traits.h"
#include "third_party/blink/public/common/common_export.h"




namespace blink::mojom {








class BLINK_COMMON_EXPORT StorageKey {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<StorageKey, T>::value>;
  using DataView = StorageKeyDataView;
  using Data_ = internal::StorageKey_Data;

  template <typename... Args>
  static StorageKeyPtr New(Args&&... args) {
    return StorageKeyPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static StorageKeyPtr From(const U& u) {
    return mojo::TypeConverter<StorageKeyPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, StorageKey>::Convert(*this);
  }


  StorageKey();

  StorageKey(
      const ::url::Origin& origin,
      const ::net::SchemefulSite& top_level_site,
      const std::optional<::base::UnguessableToken>& nonce,
      ::blink::mojom::AncestorChainBit ancestor_chain_bit,
      const ::net::SchemefulSite& top_level_site_if_third_party_enabled,
      ::blink::mojom::AncestorChainBit ancestor_chain_bit_if_third_party_enabled);


  ~StorageKey();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = StorageKeyPtr>
  StorageKeyPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, StorageKey::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, StorageKey::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, StorageKey::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        StorageKey::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        StorageKey::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        StorageKey::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::StorageKey_UnserializedMessageContext<
            UserType, StorageKey::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<StorageKey::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return StorageKey::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::StorageKey_UnserializedMessageContext<
            UserType, StorageKey::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<StorageKey::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::url::Origin origin;
  
  ::net::SchemefulSite top_level_site;
  
  std::optional<::base::UnguessableToken> nonce;
  
  ::blink::mojom::AncestorChainBit ancestor_chain_bit;
  
  ::net::SchemefulSite top_level_site_if_third_party_enabled;
  
  ::blink::mojom::AncestorChainBit ancestor_chain_bit_if_third_party_enabled;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, StorageKey::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, StorageKey::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, StorageKey::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, StorageKey::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
StorageKeyPtr StorageKey::Clone() const {
  return New(
      mojo::Clone(origin),
      mojo::Clone(top_level_site),
      mojo::Clone(nonce),
      mojo::Clone(ancestor_chain_bit),
      mojo::Clone(top_level_site_if_third_party_enabled),
      mojo::Clone(ancestor_chain_bit_if_third_party_enabled)
  );
}

template <typename T, StorageKey::EnableIfSame<T>*>
bool StorageKey::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->origin, other_struct.origin))
    return false;
  if (!mojo::Equals(this->top_level_site, other_struct.top_level_site))
    return false;
  if (!mojo::Equals(this->nonce, other_struct.nonce))
    return false;
  if (!mojo::Equals(this->ancestor_chain_bit, other_struct.ancestor_chain_bit))
    return false;
  if (!mojo::Equals(this->top_level_site_if_third_party_enabled, other_struct.top_level_site_if_third_party_enabled))
    return false;
  if (!mojo::Equals(this->ancestor_chain_bit_if_third_party_enabled, other_struct.ancestor_chain_bit_if_third_party_enabled))
    return false;
  return true;
}

template <typename T, StorageKey::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.origin < rhs.origin)
    return true;
  if (rhs.origin < lhs.origin)
    return false;
  if (lhs.top_level_site < rhs.top_level_site)
    return true;
  if (rhs.top_level_site < lhs.top_level_site)
    return false;
  if (lhs.nonce < rhs.nonce)
    return true;
  if (rhs.nonce < lhs.nonce)
    return false;
  if (lhs.ancestor_chain_bit < rhs.ancestor_chain_bit)
    return true;
  if (rhs.ancestor_chain_bit < lhs.ancestor_chain_bit)
    return false;
  if (lhs.top_level_site_if_third_party_enabled < rhs.top_level_site_if_third_party_enabled)
    return true;
  if (rhs.top_level_site_if_third_party_enabled < lhs.top_level_site_if_third_party_enabled)
    return false;
  if (lhs.ancestor_chain_bit_if_third_party_enabled < rhs.ancestor_chain_bit_if_third_party_enabled)
    return true;
  if (rhs.ancestor_chain_bit_if_third_party_enabled < lhs.ancestor_chain_bit_if_third_party_enabled)
    return false;
  return false;
}


}  // blink::mojom

namespace mojo {


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::StorageKey::DataView,
                                         ::blink::mojom::StorageKeyPtr> {
  static bool IsNull(const ::blink::mojom::StorageKeyPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::StorageKeyPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::StorageKey::origin)& origin(
      const ::blink::mojom::StorageKeyPtr& input) {
    return input->origin;
  }

  static const decltype(::blink::mojom::StorageKey::top_level_site)& top_level_site(
      const ::blink::mojom::StorageKeyPtr& input) {
    return input->top_level_site;
  }

  static const decltype(::blink::mojom::StorageKey::nonce)& nonce(
      const ::blink::mojom::StorageKeyPtr& input) {
    return input->nonce;
  }

  static decltype(::blink::mojom::StorageKey::ancestor_chain_bit) ancestor_chain_bit(
      const ::blink::mojom::StorageKeyPtr& input) {
    return input->ancestor_chain_bit;
  }

  static const decltype(::blink::mojom::StorageKey::top_level_site_if_third_party_enabled)& top_level_site_if_third_party_enabled(
      const ::blink::mojom::StorageKeyPtr& input) {
    return input->top_level_site_if_third_party_enabled;
  }

  static decltype(::blink::mojom::StorageKey::ancestor_chain_bit_if_third_party_enabled) ancestor_chain_bit_if_third_party_enabled(
      const ::blink::mojom::StorageKeyPtr& input) {
    return input->ancestor_chain_bit_if_third_party_enabled;
  }

  static bool Read(::blink::mojom::StorageKey::DataView input, ::blink::mojom::StorageKeyPtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_STORAGE_KEY_STORAGE_KEY_MOJOM_H_