// third_party/blink/public/mojom/storage_key/storage_key.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_STORAGE_KEY_STORAGE_KEY_MOJOM_DATA_VIEW_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_STORAGE_KEY_STORAGE_KEY_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/blink/public/mojom/storage_key/storage_key.mojom-shared-internal.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared.h"
#include "services/network/public/mojom/schemeful_site.mojom-shared.h"
#include "third_party/blink/public/mojom/storage_key/ancestor_chain_bit.mojom-shared.h"
#include "url/mojom/origin.mojom-shared.h"


namespace blink::mojom {
class StorageKeyDataView;



}  // blink::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::StorageKeyDataView> {
  using Data = ::blink::mojom::internal::StorageKey_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace blink::mojom {


class StorageKeyDataView {
 public:
  StorageKeyDataView() = default;

  StorageKeyDataView(
      internal::StorageKey_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetOriginDataView(
      ::url::mojom::OriginDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOrigin(UserType* output) {
    
    auto* pointer = data_->origin.Get();
    return mojo::internal::Deserialize<::url::mojom::OriginDataView>(
        pointer, output, message_);
  }
  inline void GetTopLevelSiteDataView(
      ::network::mojom::SchemefulSiteDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTopLevelSite(UserType* output) {
    
    auto* pointer = data_->top_level_site.Get();
    return mojo::internal::Deserialize<::network::mojom::SchemefulSiteDataView>(
        pointer, output, message_);
  }
  inline void GetNonceDataView(
      ::mojo_base::mojom::UnguessableTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadNonce(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::UnguessableTokenDataView, UserType>(),
    "Attempting to read the optional `nonce` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadNonce` instead "
    "of `ReadNonce if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->nonce.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UnguessableTokenDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadAncestorChainBit(UserType* output) const {
    auto data_value = data_->ancestor_chain_bit;
    return mojo::internal::Deserialize<::blink::mojom::AncestorChainBit>(
        data_value, output);
  }
  ::blink::mojom::AncestorChainBit ancestor_chain_bit() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::AncestorChainBit>(data_->ancestor_chain_bit));
  }
  inline void GetTopLevelSiteIfThirdPartyEnabledDataView(
      ::network::mojom::SchemefulSiteDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTopLevelSiteIfThirdPartyEnabled(UserType* output) {
    
    auto* pointer = data_->top_level_site_if_third_party_enabled.Get();
    return mojo::internal::Deserialize<::network::mojom::SchemefulSiteDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadAncestorChainBitIfThirdPartyEnabled(UserType* output) const {
    auto data_value = data_->ancestor_chain_bit_if_third_party_enabled;
    return mojo::internal::Deserialize<::blink::mojom::AncestorChainBit>(
        data_value, output);
  }
  ::blink::mojom::AncestorChainBit ancestor_chain_bit_if_third_party_enabled() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::AncestorChainBit>(data_->ancestor_chain_bit_if_third_party_enabled));
  }
 private:
  internal::StorageKey_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // blink::mojom

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_STORAGE_KEY_STORAGE_KEY_MOJOM_DATA_VIEW_H_