// third_party/blink/public/mojom/speech/speech_synthesis.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_SPEECH_SPEECH_SYNTHESIS_MOJOM_DATA_VIEW_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_SPEECH_SPEECH_SYNTHESIS_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/blink/public/mojom/speech/speech_synthesis.mojom-shared-internal.h"


namespace blink::mojom {
class SpeechSynthesisUtteranceDataView;

class SpeechSynthesisVoiceDataView;



}  // blink::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::SpeechSynthesisUtteranceDataView> {
  using Data = ::blink::mojom::internal::SpeechSynthesisUtterance_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::SpeechSynthesisVoiceDataView> {
  using Data = ::blink::mojom::internal::SpeechSynthesisVoice_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace blink::mojom {


enum class SpeechSynthesisErrorCode : int32_t {
  
  kCancelled = 0,
  
  kInterrupted = 1,
  
  kErrorOccurred = 2,
  
  kNoError = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, SpeechSynthesisErrorCode value);
inline bool IsKnownEnumValue(SpeechSynthesisErrorCode value) {
  return internal::SpeechSynthesisErrorCode_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class SpeechSynthesisVoiceListObserverInterfaceBase {};

using SpeechSynthesisVoiceListObserverPtrDataView =
    mojo::InterfacePtrDataView<SpeechSynthesisVoiceListObserverInterfaceBase>;
using SpeechSynthesisVoiceListObserverRequestDataView =
    mojo::InterfaceRequestDataView<SpeechSynthesisVoiceListObserverInterfaceBase>;
using SpeechSynthesisVoiceListObserverAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<SpeechSynthesisVoiceListObserverInterfaceBase>;
using SpeechSynthesisVoiceListObserverAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<SpeechSynthesisVoiceListObserverInterfaceBase>;
class SpeechSynthesisClientInterfaceBase {};

using SpeechSynthesisClientPtrDataView =
    mojo::InterfacePtrDataView<SpeechSynthesisClientInterfaceBase>;
using SpeechSynthesisClientRequestDataView =
    mojo::InterfaceRequestDataView<SpeechSynthesisClientInterfaceBase>;
using SpeechSynthesisClientAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<SpeechSynthesisClientInterfaceBase>;
using SpeechSynthesisClientAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<SpeechSynthesisClientInterfaceBase>;
class SpeechSynthesisInterfaceBase {};

using SpeechSynthesisPtrDataView =
    mojo::InterfacePtrDataView<SpeechSynthesisInterfaceBase>;
using SpeechSynthesisRequestDataView =
    mojo::InterfaceRequestDataView<SpeechSynthesisInterfaceBase>;
using SpeechSynthesisAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<SpeechSynthesisInterfaceBase>;
using SpeechSynthesisAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<SpeechSynthesisInterfaceBase>;


class SpeechSynthesisUtteranceDataView {
 public:
  SpeechSynthesisUtteranceDataView() = default;

  SpeechSynthesisUtteranceDataView(
      internal::SpeechSynthesisUtterance_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetTextDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadText(UserType* output) {
    
    auto* pointer = data_->text.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetLangDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLang(UserType* output) {
    
    auto* pointer = data_->lang.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetVoiceDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadVoice(UserType* output) {
    
    auto* pointer = data_->voice.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  double volume() const {
    return data_->volume;
  }
  double rate() const {
    return data_->rate;
  }
  double pitch() const {
    return data_->pitch;
  }
 private:
  internal::SpeechSynthesisUtterance_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class SpeechSynthesisVoiceDataView {
 public:
  SpeechSynthesisVoiceDataView() = default;

  SpeechSynthesisVoiceDataView(
      internal::SpeechSynthesisVoice_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetVoiceUriDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadVoiceUri(UserType* output) {
    
    auto* pointer = data_->voice_uri.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadName(UserType* output) {
    
    auto* pointer = data_->name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetLangDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLang(UserType* output) {
    
    auto* pointer = data_->lang.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  bool is_local_service() const {
    return data_->is_local_service;
  }
  bool is_default() const {
    return data_->is_default;
  }
 private:
  internal::SpeechSynthesisVoice_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // blink::mojom

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_SPEECH_SPEECH_SYNTHESIS_MOJOM_DATA_VIEW_H_