// third_party/blink/public/mojom/speculation_rules/speculation_rules.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_SPECULATION_RULES_SPECULATION_RULES_MOJOM_SEND_VALIDATION_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_SPECULATION_RULES_SPECULATION_RULES_MOJOM_SEND_VALIDATION_H_

#include "third_party/blink/public/mojom/speculation_rules/speculation_rules.mojom-shared-internal.h"
#include "services/network/public/mojom/no_vary_search.mojom-shared.h"
#include "third_party/blink/public/mojom/loader/referrer.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"

#include "third_party/blink/public/mojom/speculation_rules/speculation_rules.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization_send_validation.h"
#include "mojo/public/cpp/bindings/lib/has_send_validation_helper.h"

namespace mojo::internal {
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::blink::mojom::SpeculationAction, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::blink::mojom::SpeculationTargetHint, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::blink::mojom::SpeculationEagerness, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::blink::mojom::SpeculationInjectionType, MaybeConstUserType>
    : std::false_type {};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::blink::mojom::SpeculationCandidateDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::SpeculationCandidateDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::SpeculationCandidate_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::url(input)) in_url = Traits::url(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->url)::BaseType> url_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::url::mojom::UrlDataView, send_validation>(
        in_url,
        url_fragment);

      fragment->url.Set(
          url_fragment.is_null() ? nullptr : url_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->url.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null url in SpeculationCandidate struct");

      
      mojo::internal::Serialize<::blink::mojom::SpeculationAction>(
        Traits::action(input),
        &fragment->action);

      decltype(Traits::referrer(input)) in_referrer = Traits::referrer(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->referrer)::BaseType> referrer_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::blink::mojom::ReferrerDataView, send_validation>(
        in_referrer,
        referrer_fragment);

      fragment->referrer.Set(
          referrer_fragment.is_null() ? nullptr : referrer_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->referrer.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null referrer in SpeculationCandidate struct");

      fragment->requires_anonymous_client_ip_when_cross_origin = Traits::requires_anonymous_client_ip_when_cross_origin(input);

      
      mojo::internal::Serialize<::blink::mojom::SpeculationTargetHint>(
        Traits::target_browsing_context_name_hint(input),
        &fragment->target_browsing_context_name_hint);

      
      mojo::internal::Serialize<::blink::mojom::SpeculationEagerness>(
        Traits::eagerness(input),
        &fragment->eagerness);

      decltype(Traits::no_vary_search_hint(input)) in_no_vary_search_hint = Traits::no_vary_search_hint(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->no_vary_search_hint)::BaseType> no_vary_search_hint_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::network::mojom::NoVarySearchDataView, send_validation>(
        in_no_vary_search_hint,
        no_vary_search_hint_fragment);

      fragment->no_vary_search_hint.Set(
          no_vary_search_hint_fragment.is_null() ? nullptr : no_vary_search_hint_fragment.data());

      
      mojo::internal::Serialize<::blink::mojom::SpeculationInjectionType>(
        Traits::injection_type(input),
        &fragment->injection_type);

      decltype(Traits::tags(input)) in_tags = Traits::tags(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->tags)::BaseType>
          tags_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& tags_validate_params =
          mojo::internal::GetArrayValidator<0, true, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>, send_validation>(
        in_tags,
        tags_fragment,
        &tags_validate_params);

      fragment->tags.Set(
          tags_fragment.is_null() ? nullptr : tags_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->tags.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null tags in SpeculationCandidate struct");

      fragment->form_submission = Traits::form_submission(input);
  }
};

}  // namespace mojo::internal

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_SPECULATION_RULES_SPECULATION_RULES_MOJOM_SEND_VALIDATION_H_