// third_party/blink/public/mojom/speculation_rules/speculation_rules.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_SPECULATION_RULES_SPECULATION_RULES_MOJOM_DATA_VIEW_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_SPECULATION_RULES_SPECULATION_RULES_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/blink/public/mojom/speculation_rules/speculation_rules.mojom-shared-internal.h"
#include "services/network/public/mojom/no_vary_search.mojom-shared.h"
#include "third_party/blink/public/mojom/loader/referrer.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"


namespace blink::mojom {
class SpeculationCandidateDataView;



}  // blink::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::SpeculationCandidateDataView> {
  using Data = ::blink::mojom::internal::SpeculationCandidate_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace blink::mojom {


enum class SpeculationAction : int32_t {
  
  kPrefetch = 0,
  
  kPrefetchWithSubresources = 1,
  
  kPrerender = 2,
  
  kPrerenderUntilScript = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, SpeculationAction value);
inline bool IsKnownEnumValue(SpeculationAction value) {
  return internal::SpeculationAction_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class SpeculationTargetHint : int32_t {
  
  kNoHint = 0,
  
  kBlank = 1,
  
  kSelf = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, SpeculationTargetHint value);
inline bool IsKnownEnumValue(SpeculationTargetHint value) {
  return internal::SpeculationTargetHint_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class SpeculationEagerness : int32_t {
  
  kConservative = 0,
  
  kModerate = 1,
  
  kImmediate = 2,
  
  kEager = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, SpeculationEagerness value);
inline bool IsKnownEnumValue(SpeculationEagerness value) {
  return internal::SpeculationEagerness_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class SpeculationInjectionType : int32_t {
  
  kNone = 0,
  
  kMainWorldScript = 1,
  
  kIsolatedWorldScript = 2,
  
  kAutoSpeculationRules = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, SpeculationInjectionType value);
inline bool IsKnownEnumValue(SpeculationInjectionType value) {
  return internal::SpeculationInjectionType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class SpeculationHostInterfaceBase {};

using SpeculationHostPtrDataView =
    mojo::InterfacePtrDataView<SpeculationHostInterfaceBase>;
using SpeculationHostRequestDataView =
    mojo::InterfaceRequestDataView<SpeculationHostInterfaceBase>;
using SpeculationHostAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<SpeculationHostInterfaceBase>;
using SpeculationHostAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<SpeculationHostInterfaceBase>;


class SpeculationCandidateDataView {
 public:
  SpeculationCandidateDataView() = default;

  SpeculationCandidateDataView(
      internal::SpeculationCandidate_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrl(UserType* output) {
    
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadAction(UserType* output) const {
    auto data_value = data_->action;
    return mojo::internal::Deserialize<::blink::mojom::SpeculationAction>(
        data_value, output);
  }
  SpeculationAction action() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::SpeculationAction>(data_->action));
  }
  inline void GetReferrerDataView(
      ::blink::mojom::ReferrerDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadReferrer(UserType* output) {
    
    auto* pointer = data_->referrer.Get();
    return mojo::internal::Deserialize<::blink::mojom::ReferrerDataView>(
        pointer, output, message_);
  }
  bool requires_anonymous_client_ip_when_cross_origin() const {
    return data_->requires_anonymous_client_ip_when_cross_origin;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadTargetBrowsingContextNameHint(UserType* output) const {
    auto data_value = data_->target_browsing_context_name_hint;
    return mojo::internal::Deserialize<::blink::mojom::SpeculationTargetHint>(
        data_value, output);
  }
  SpeculationTargetHint target_browsing_context_name_hint() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::SpeculationTargetHint>(data_->target_browsing_context_name_hint));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadEagerness(UserType* output) const {
    auto data_value = data_->eagerness;
    return mojo::internal::Deserialize<::blink::mojom::SpeculationEagerness>(
        data_value, output);
  }
  SpeculationEagerness eagerness() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::SpeculationEagerness>(data_->eagerness));
  }
  inline void GetNoVarySearchHintDataView(
      ::network::mojom::NoVarySearchDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadNoVarySearchHint(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::network::mojom::NoVarySearchDataView, UserType>(),
    "Attempting to read the optional `no_vary_search_hint` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadNoVarySearchHint` instead "
    "of `ReadNoVarySearchHint if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->no_vary_search_hint.Get();
    return mojo::internal::Deserialize<::network::mojom::NoVarySearchDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadInjectionType(UserType* output) const {
    auto data_value = data_->injection_type;
    return mojo::internal::Deserialize<::blink::mojom::SpeculationInjectionType>(
        data_value, output);
  }
  SpeculationInjectionType injection_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::SpeculationInjectionType>(data_->injection_type));
  }
  inline void GetTagsDataView(
      mojo::ArrayDataView<mojo::StringDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTags(UserType* output) {
    
    auto* pointer = data_->tags.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::StringDataView>>(
        pointer, output, message_);
  }
  bool form_submission() const {
    return data_->form_submission;
  }
 private:
  internal::SpeculationCandidate_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // blink::mojom

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_SPECULATION_RULES_SPECULATION_RULES_MOJOM_DATA_VIEW_H_