// third_party/blink/public/mojom/service_worker/service_worker_worker_client_registry.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';

import {
  ServiceWorkerWorkerClientRemote as blink_mojom_ServiceWorkerWorkerClientRemote,
  ServiceWorkerWorkerClientPendingReceiver as blink_mojom_ServiceWorkerWorkerClientPendingReceiver
} from './service_worker_worker_client.mojom.m.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class ServiceWorkerWorkerClientRegistryPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.ServiceWorkerWorkerClientRegistry', scope);
  }
}

/** @interface */
export class ServiceWorkerWorkerClientRegistryInterface {
  
  /**
   * @param { !blink_mojom_ServiceWorkerWorkerClientRemote } client
   */

  registerWorkerClient(client) {}
  
  /**
   * @param { !ServiceWorkerWorkerClientRegistryPendingReceiver } host
   */

  cloneWorkerClientRegistry(host) {}
}

/**
 * @implements { ServiceWorkerWorkerClientRegistryInterface }
 */
export class ServiceWorkerWorkerClientRegistryRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!ServiceWorkerWorkerClientRegistryPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          ServiceWorkerWorkerClientRegistryPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!ServiceWorkerWorkerClientRegistryPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !blink_mojom_ServiceWorkerWorkerClientRemote } client
   */

  registerWorkerClient(
      client) {
    this.proxy.sendMessage(
        0,
        ServiceWorkerWorkerClientRegistry_RegisterWorkerClient_ParamsSpec.$,
        null,
        [
          client
        ],
        false);
  }

  
  /**
   * @param { !ServiceWorkerWorkerClientRegistryPendingReceiver } host
   */

  cloneWorkerClientRegistry(
      host) {
    this.proxy.sendMessage(
        1,
        ServiceWorkerWorkerClientRegistry_CloneWorkerClientRegistry_ParamsSpec.$,
        null,
        [
          host
        ],
        false);
  }
}

/**
 * An object which receives request messages for the ServiceWorkerWorkerClientRegistry
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class ServiceWorkerWorkerClientRegistryReceiver {
  /**
   * @param {!ServiceWorkerWorkerClientRegistryInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!ServiceWorkerWorkerClientRegistryRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        ServiceWorkerWorkerClientRegistryRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ServiceWorkerWorkerClientRegistryRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        ServiceWorkerWorkerClientRegistry_RegisterWorkerClient_ParamsSpec.$,
        null,
        impl.registerWorkerClient.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        ServiceWorkerWorkerClientRegistry_CloneWorkerClientRegistry_ParamsSpec.$,
        null,
        impl.cloneWorkerClientRegistry.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class ServiceWorkerWorkerClientRegistry {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.ServiceWorkerWorkerClientRegistry";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!ServiceWorkerWorkerClientRegistryRemote}
   */
  static getRemote() {
    let remote = new ServiceWorkerWorkerClientRegistryRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the ServiceWorkerWorkerClientRegistry
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class ServiceWorkerWorkerClientRegistryCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      ServiceWorkerWorkerClientRegistryRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ServiceWorkerWorkerClientRegistryRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.registerWorkerClient =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        ServiceWorkerWorkerClientRegistry_RegisterWorkerClient_ParamsSpec.$,
        null,
        this.registerWorkerClient.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.cloneWorkerClientRegistry =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        ServiceWorkerWorkerClientRegistry_CloneWorkerClientRegistry_ParamsSpec.$,
        null,
        this.cloneWorkerClientRegistry.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ServiceWorkerWorkerClientRegistry_RegisterWorkerClient_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ServiceWorkerWorkerClientRegistry_CloneWorkerClientRegistry_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    ServiceWorkerWorkerClientRegistry_RegisterWorkerClient_ParamsSpec.$,
    'ServiceWorkerWorkerClientRegistry_RegisterWorkerClient_Params',
    [
      mojo.internal.StructField(
        'client', 0,
        0,
        mojo.internal.InterfaceProxy(blink_mojom_ServiceWorkerWorkerClientRemote),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class ServiceWorkerWorkerClientRegistry_RegisterWorkerClient_Params {
  constructor() {
    /** @type { !blink_mojom_ServiceWorkerWorkerClientRemote } */
    this.client;
  }
}



mojo.internal.Struct(
    ServiceWorkerWorkerClientRegistry_CloneWorkerClientRegistry_ParamsSpec.$,
    'ServiceWorkerWorkerClientRegistry_CloneWorkerClientRegistry_Params',
    [
      mojo.internal.StructField(
        'host', 0,
        0,
        mojo.internal.InterfaceRequest(ServiceWorkerWorkerClientRegistryPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class ServiceWorkerWorkerClientRegistry_CloneWorkerClientRegistry_Params {
  constructor() {
    /** @type { !ServiceWorkerWorkerClientRegistryPendingReceiver } */
    this.host;
  }
}

