// third_party/blink/public/mojom/service_worker/service_worker_running_status_callback.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'third_party/blink/public/mojom/service_worker/service_worker_running_status_callback.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('blink.mojom');
  var service_worker_embedded_worker_status$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/service_worker/service_worker_embedded_worker_status.mojom', 'service_worker_embedded_worker_status.mojom.js');
  }



  function ServiceWorkerRunningStatusCallback_OnStatusChanged_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ServiceWorkerRunningStatusCallback_OnStatusChanged_Params.prototype.initDefaults_ = function() {
    this.status = 0;
  };
  ServiceWorkerRunningStatusCallback_OnStatusChanged_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ServiceWorkerRunningStatusCallback_OnStatusChanged_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ServiceWorkerRunningStatusCallback_OnStatusChanged_Params.status
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, service_worker_embedded_worker_status$.ServiceWorkerEmbeddedWorkerStatus);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ServiceWorkerRunningStatusCallback_OnStatusChanged_Params.encodedSize = codec.kStructHeaderSize + 8;

  ServiceWorkerRunningStatusCallback_OnStatusChanged_Params.decode = function(decoder) {
    var packed;
    var val = new ServiceWorkerRunningStatusCallback_OnStatusChanged_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.status =
        decoder.decodeStruct(new codec.Enum(service_worker_embedded_worker_status$.ServiceWorkerEmbeddedWorkerStatus));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  ServiceWorkerRunningStatusCallback_OnStatusChanged_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ServiceWorkerRunningStatusCallback_OnStatusChanged_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.status);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  var kServiceWorkerRunningStatusCallback_OnStatusChanged_Name = 0;

  function ServiceWorkerRunningStatusCallbackPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(ServiceWorkerRunningStatusCallback,
                                                   handleOrPtrInfo);
  }

  function ServiceWorkerRunningStatusCallbackAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        ServiceWorkerRunningStatusCallback, associatedInterfacePtrInfo);
  }

  ServiceWorkerRunningStatusCallbackAssociatedPtr.prototype =
      Object.create(ServiceWorkerRunningStatusCallbackPtr.prototype);
  ServiceWorkerRunningStatusCallbackAssociatedPtr.prototype.constructor =
      ServiceWorkerRunningStatusCallbackAssociatedPtr;

  function ServiceWorkerRunningStatusCallbackProxy(receiver) {
    this.receiver_ = receiver;
  }
  ServiceWorkerRunningStatusCallbackPtr.prototype.onStatusChanged = function() {
    return ServiceWorkerRunningStatusCallbackProxy.prototype.onStatusChanged
        .apply(this.ptr.getProxy(), arguments);
  };

  ServiceWorkerRunningStatusCallbackProxy.prototype.onStatusChanged = function(status) {
    var params_ = new ServiceWorkerRunningStatusCallback_OnStatusChanged_Params();
    params_.status = status;
    var builder = new codec.MessageV0Builder(
        kServiceWorkerRunningStatusCallback_OnStatusChanged_Name,
        codec.align(ServiceWorkerRunningStatusCallback_OnStatusChanged_Params.encodedSize));
    builder.encodeStruct(ServiceWorkerRunningStatusCallback_OnStatusChanged_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function ServiceWorkerRunningStatusCallbackStub(delegate) {
    this.delegate_ = delegate;
  }
  ServiceWorkerRunningStatusCallbackStub.prototype.onStatusChanged = function(status) {
    return this.delegate_ && this.delegate_.onStatusChanged && this.delegate_.onStatusChanged(status);
  }

  ServiceWorkerRunningStatusCallbackStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kServiceWorkerRunningStatusCallback_OnStatusChanged_Name:
      var params = reader.decodeStruct(ServiceWorkerRunningStatusCallback_OnStatusChanged_Params);
      this.onStatusChanged(params.status);
      return true;
    default:
      return false;
    }
  };

  ServiceWorkerRunningStatusCallbackStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateServiceWorkerRunningStatusCallbackRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kServiceWorkerRunningStatusCallback_OnStatusChanged_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = ServiceWorkerRunningStatusCallback_OnStatusChanged_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateServiceWorkerRunningStatusCallbackResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var ServiceWorkerRunningStatusCallback = {
    name: 'blink.mojom.ServiceWorkerRunningStatusCallback',
    kVersion: 0,
    ptrClass: ServiceWorkerRunningStatusCallbackPtr,
    proxyClass: ServiceWorkerRunningStatusCallbackProxy,
    stubClass: ServiceWorkerRunningStatusCallbackStub,
    validateRequest: validateServiceWorkerRunningStatusCallbackRequest,
    validateResponse: null,
  };
  ServiceWorkerRunningStatusCallbackStub.prototype.validator = validateServiceWorkerRunningStatusCallbackRequest;
  ServiceWorkerRunningStatusCallbackProxy.prototype.validator = null;
  exports.ServiceWorkerRunningStatusCallback = ServiceWorkerRunningStatusCallback;
  exports.ServiceWorkerRunningStatusCallbackPtr = ServiceWorkerRunningStatusCallbackPtr;
  exports.ServiceWorkerRunningStatusCallbackAssociatedPtr = ServiceWorkerRunningStatusCallbackAssociatedPtr;
})();