// third_party/blink/public/mojom/service_worker/service_worker_object.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';

import {
  Url as url_mojom_Url,
  UrlSpec as url_mojom_UrlSpec
} from '../../../../../url/mojom/url.mojom.m.js';

import {
  TransferableMessage as blink_mojom_TransferableMessage,
  TransferableMessageSpec as blink_mojom_TransferableMessageSpec
} from '../messaging/transferable_message.mojom.m.js';

import {
  ServiceWorkerState as blink_mojom_ServiceWorkerState,
  ServiceWorkerStateSpec as blink_mojom_ServiceWorkerStateSpec
} from './service_worker_state.mojom.m.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class ServiceWorkerObjectHostPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.ServiceWorkerObjectHost', scope);
  }
}

/** @interface */
export class ServiceWorkerObjectHostInterface {
  
  /**
   * @param { !blink_mojom_TransferableMessage } message
   */

  postMessageToServiceWorker(message) {}
  
  /**
   * @return {!Promise}
   */

  terminateForTesting() {}
}

/**
 * @implements { ServiceWorkerObjectHostInterface }
 */
export class ServiceWorkerObjectHostRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!ServiceWorkerObjectHostPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          ServiceWorkerObjectHostPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!ServiceWorkerObjectHostPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !blink_mojom_TransferableMessage } message
   */

  postMessageToServiceWorker(
      message) {
    this.proxy.sendMessage(
        0,
        ServiceWorkerObjectHost_PostMessageToServiceWorker_ParamsSpec.$,
        null,
        [
          message
        ],
        false);
  }

  
  /**
   * @return {!Promise}
   */

  terminateForTesting() {
    return this.proxy.sendMessage(
        1,
        ServiceWorkerObjectHost_TerminateForTesting_ParamsSpec.$,
        ServiceWorkerObjectHost_TerminateForTesting_ResponseParamsSpec.$,
        [
        ],
        false);
  }
}

/**
 * An object which receives request messages for the ServiceWorkerObjectHost
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class ServiceWorkerObjectHostReceiver {
  /**
   * @param {!ServiceWorkerObjectHostInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!ServiceWorkerObjectHostRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        ServiceWorkerObjectHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ServiceWorkerObjectHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        ServiceWorkerObjectHost_PostMessageToServiceWorker_ParamsSpec.$,
        null,
        impl.postMessageToServiceWorker.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        ServiceWorkerObjectHost_TerminateForTesting_ParamsSpec.$,
        ServiceWorkerObjectHost_TerminateForTesting_ResponseParamsSpec.$,
        impl.terminateForTesting.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class ServiceWorkerObjectHost {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.ServiceWorkerObjectHost";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!ServiceWorkerObjectHostRemote}
   */
  static getRemote() {
    let remote = new ServiceWorkerObjectHostRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the ServiceWorkerObjectHost
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class ServiceWorkerObjectHostCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      ServiceWorkerObjectHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ServiceWorkerObjectHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.postMessageToServiceWorker =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        ServiceWorkerObjectHost_PostMessageToServiceWorker_ParamsSpec.$,
        null,
        this.postMessageToServiceWorker.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.terminateForTesting =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        ServiceWorkerObjectHost_TerminateForTesting_ParamsSpec.$,
        ServiceWorkerObjectHost_TerminateForTesting_ResponseParamsSpec.$,
        this.terminateForTesting.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class ServiceWorkerObjectPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.ServiceWorkerObject', scope);
  }
}

/** @interface */
export class ServiceWorkerObjectInterface {
  
  /**
   * @param { !blink_mojom_ServiceWorkerState } state
   */

  stateChanged(state) {}
}

/**
 * @implements { ServiceWorkerObjectInterface }
 */
export class ServiceWorkerObjectRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!ServiceWorkerObjectPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          ServiceWorkerObjectPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!ServiceWorkerObjectPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !blink_mojom_ServiceWorkerState } state
   */

  stateChanged(
      state) {
    this.proxy.sendMessage(
        0,
        ServiceWorkerObject_StateChanged_ParamsSpec.$,
        null,
        [
          state
        ],
        false);
  }
}

/**
 * An object which receives request messages for the ServiceWorkerObject
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class ServiceWorkerObjectReceiver {
  /**
   * @param {!ServiceWorkerObjectInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!ServiceWorkerObjectRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        ServiceWorkerObjectRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ServiceWorkerObjectRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        ServiceWorkerObject_StateChanged_ParamsSpec.$,
        null,
        impl.stateChanged.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class ServiceWorkerObject {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.ServiceWorkerObject";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!ServiceWorkerObjectRemote}
   */
  static getRemote() {
    let remote = new ServiceWorkerObjectRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the ServiceWorkerObject
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class ServiceWorkerObjectCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      ServiceWorkerObjectRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ServiceWorkerObjectRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.stateChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        ServiceWorkerObject_StateChanged_ParamsSpec.$,
        null,
        this.stateChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ServiceWorkerObjectInfoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ServiceWorkerObjectHost_PostMessageToServiceWorker_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ServiceWorkerObjectHost_TerminateForTesting_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ServiceWorkerObjectHost_TerminateForTesting_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ServiceWorkerObject_StateChanged_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    ServiceWorkerObjectInfoSpec.$,
    'ServiceWorkerObjectInfo',
    [
      mojo.internal.StructField(
        'versionId', 0,
        0,
        mojo.internal.Int64,
        blink_mojom_INVALID_SERVICE_WORKER_VERSION_ID,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'state', 8,
        0,
        blink_mojom_ServiceWorkerStateSpec.$,
        blink_mojom_ServiceWorkerState.kParsed,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'url', 16,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'hostRemote', 24,
        0,
        mojo.internal.AssociatedInterfaceProxy(ServiceWorkerObjectHostRemote),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'receiver', 12,
        0,
        mojo.internal.AssociatedInterfaceRequest(ServiceWorkerObjectPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class ServiceWorkerObjectInfo {
  constructor() {
    /** @type { !bigint } */
    this.versionId;
    /** @type { !blink_mojom_ServiceWorkerState } */
    this.state;
    /** @type { !url_mojom_Url } */
    this.url;
    /** @type { !Object } */
    this.hostRemote;
    /** @type { !Object } */
    this.receiver;
  }
}



mojo.internal.Struct(
    ServiceWorkerObjectHost_PostMessageToServiceWorker_ParamsSpec.$,
    'ServiceWorkerObjectHost_PostMessageToServiceWorker_Params',
    [
      mojo.internal.StructField(
        'message', 0,
        0,
        blink_mojom_TransferableMessageSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class ServiceWorkerObjectHost_PostMessageToServiceWorker_Params {
  constructor() {
    /** @type { !blink_mojom_TransferableMessage } */
    this.message;
  }
}



mojo.internal.Struct(
    ServiceWorkerObjectHost_TerminateForTesting_ParamsSpec.$,
    'ServiceWorkerObjectHost_TerminateForTesting_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class ServiceWorkerObjectHost_TerminateForTesting_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    ServiceWorkerObjectHost_TerminateForTesting_ResponseParamsSpec.$,
    'ServiceWorkerObjectHost_TerminateForTesting_ResponseParams',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class ServiceWorkerObjectHost_TerminateForTesting_ResponseParams {
  constructor() {
  }
}



mojo.internal.Struct(
    ServiceWorkerObject_StateChanged_ParamsSpec.$,
    'ServiceWorkerObject_StateChanged_Params',
    [
      mojo.internal.StructField(
        'state', 0,
        0,
        blink_mojom_ServiceWorkerStateSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class ServiceWorkerObject_StateChanged_Params {
  constructor() {
    /** @type { !blink_mojom_ServiceWorkerState } */
    this.state;
  }
}

