// third_party/blink/public/mojom/service_worker/service_worker_installed_scripts_manager.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';

import {
  Url as url_mojom_Url,
  UrlSpec as url_mojom_UrlSpec
} from '../../../../../url/mojom/url.mojom.m.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class ServiceWorkerInstalledScriptsManagerHostPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.ServiceWorkerInstalledScriptsManagerHost', scope);
  }
}

/** @interface */
export class ServiceWorkerInstalledScriptsManagerHostInterface {
  
  /**
   * @param { !url_mojom_Url } scriptUrl
   */

  requestInstalledScript(scriptUrl) {}
}

/**
 * @implements { ServiceWorkerInstalledScriptsManagerHostInterface }
 */
export class ServiceWorkerInstalledScriptsManagerHostRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!ServiceWorkerInstalledScriptsManagerHostPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          ServiceWorkerInstalledScriptsManagerHostPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!ServiceWorkerInstalledScriptsManagerHostPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !url_mojom_Url } scriptUrl
   */

  requestInstalledScript(
      scriptUrl) {
    this.proxy.sendMessage(
        0,
        ServiceWorkerInstalledScriptsManagerHost_RequestInstalledScript_ParamsSpec.$,
        null,
        [
          scriptUrl
        ],
        false);
  }
}

/**
 * An object which receives request messages for the ServiceWorkerInstalledScriptsManagerHost
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class ServiceWorkerInstalledScriptsManagerHostReceiver {
  /**
   * @param {!ServiceWorkerInstalledScriptsManagerHostInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!ServiceWorkerInstalledScriptsManagerHostRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        ServiceWorkerInstalledScriptsManagerHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ServiceWorkerInstalledScriptsManagerHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        ServiceWorkerInstalledScriptsManagerHost_RequestInstalledScript_ParamsSpec.$,
        null,
        impl.requestInstalledScript.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class ServiceWorkerInstalledScriptsManagerHost {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.ServiceWorkerInstalledScriptsManagerHost";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!ServiceWorkerInstalledScriptsManagerHostRemote}
   */
  static getRemote() {
    let remote = new ServiceWorkerInstalledScriptsManagerHostRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the ServiceWorkerInstalledScriptsManagerHost
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class ServiceWorkerInstalledScriptsManagerHostCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      ServiceWorkerInstalledScriptsManagerHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ServiceWorkerInstalledScriptsManagerHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.requestInstalledScript =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        ServiceWorkerInstalledScriptsManagerHost_RequestInstalledScript_ParamsSpec.$,
        null,
        this.requestInstalledScript.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class ServiceWorkerInstalledScriptsManagerPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.ServiceWorkerInstalledScriptsManager', scope);
  }
}

/** @interface */
export class ServiceWorkerInstalledScriptsManagerInterface {
  
  /**
   * @param { !ServiceWorkerScriptInfo } scriptInfo
   */

  transferInstalledScript(scriptInfo) {}
}

/**
 * @implements { ServiceWorkerInstalledScriptsManagerInterface }
 */
export class ServiceWorkerInstalledScriptsManagerRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!ServiceWorkerInstalledScriptsManagerPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          ServiceWorkerInstalledScriptsManagerPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!ServiceWorkerInstalledScriptsManagerPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !ServiceWorkerScriptInfo } scriptInfo
   */

  transferInstalledScript(
      scriptInfo) {
    this.proxy.sendMessage(
        0,
        ServiceWorkerInstalledScriptsManager_TransferInstalledScript_ParamsSpec.$,
        null,
        [
          scriptInfo
        ],
        false);
  }
}

/**
 * An object which receives request messages for the ServiceWorkerInstalledScriptsManager
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class ServiceWorkerInstalledScriptsManagerReceiver {
  /**
   * @param {!ServiceWorkerInstalledScriptsManagerInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!ServiceWorkerInstalledScriptsManagerRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        ServiceWorkerInstalledScriptsManagerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ServiceWorkerInstalledScriptsManagerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        ServiceWorkerInstalledScriptsManager_TransferInstalledScript_ParamsSpec.$,
        null,
        impl.transferInstalledScript.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class ServiceWorkerInstalledScriptsManager {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.ServiceWorkerInstalledScriptsManager";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!ServiceWorkerInstalledScriptsManagerRemote}
   */
  static getRemote() {
    let remote = new ServiceWorkerInstalledScriptsManagerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the ServiceWorkerInstalledScriptsManager
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class ServiceWorkerInstalledScriptsManagerCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      ServiceWorkerInstalledScriptsManagerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ServiceWorkerInstalledScriptsManagerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.transferInstalledScript =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        ServiceWorkerInstalledScriptsManager_TransferInstalledScript_ParamsSpec.$,
        null,
        this.transferInstalledScript.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ServiceWorkerInstalledScriptsInfoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ServiceWorkerScriptInfoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ServiceWorkerInstalledScriptsManagerHost_RequestInstalledScript_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ServiceWorkerInstalledScriptsManager_TransferInstalledScript_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    ServiceWorkerInstalledScriptsInfoSpec.$,
    'ServiceWorkerInstalledScriptsInfo',
    [
      mojo.internal.StructField(
        'managerReceiver', 0,
        0,
        mojo.internal.InterfaceRequest(ServiceWorkerInstalledScriptsManagerPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'managerHostRemote', 4,
        0,
        mojo.internal.InterfaceProxy(ServiceWorkerInstalledScriptsManagerHostRemote),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'installedUrls', 16,
        0,
        mojo.internal.Array(url_mojom_UrlSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class ServiceWorkerInstalledScriptsInfo {
  constructor() {
    /** @type { !ServiceWorkerInstalledScriptsManagerPendingReceiver } */
    this.managerReceiver;
    /** @type { !ServiceWorkerInstalledScriptsManagerHostRemote } */
    this.managerHostRemote;
    /** @type { !Array<!url_mojom_Url> } */
    this.installedUrls;
  }
}



mojo.internal.Struct(
    ServiceWorkerScriptInfoSpec.$,
    'ServiceWorkerScriptInfo',
    [
      mojo.internal.StructField(
        'scriptUrl', 0,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'encoding', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'headers', 16,
        0,
        mojo.internal.Map(mojo.internal.String, mojo.internal.String, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'body', 24,
        0,
        mojo.internal.Handle,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'bodySize', 32,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'metaData', 28,
        0,
        mojo.internal.Handle,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'metaDataSize', 40,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
    ],
    [[0, 56],]);



/**
 * @record
 */
export class ServiceWorkerScriptInfo {
  constructor() {
    /** @type { !url_mojom_Url } */
    this.scriptUrl;
    /** @type { !string } */
    this.encoding;
    /** @type { !Object<!string, !string> } */
    this.headers;
    /** @type { !MojoHandle } */
    this.body;
    /** @type { !bigint } */
    this.bodySize;
    /** @type { (MojoHandle|undefined) } */
    this.metaData;
    /** @type { !bigint } */
    this.metaDataSize;
  }
}



mojo.internal.Struct(
    ServiceWorkerInstalledScriptsManagerHost_RequestInstalledScript_ParamsSpec.$,
    'ServiceWorkerInstalledScriptsManagerHost_RequestInstalledScript_Params',
    [
      mojo.internal.StructField(
        'scriptUrl', 0,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class ServiceWorkerInstalledScriptsManagerHost_RequestInstalledScript_Params {
  constructor() {
    /** @type { !url_mojom_Url } */
    this.scriptUrl;
  }
}



mojo.internal.Struct(
    ServiceWorkerInstalledScriptsManager_TransferInstalledScript_ParamsSpec.$,
    'ServiceWorkerInstalledScriptsManager_TransferInstalledScript_Params',
    [
      mojo.internal.StructField(
        'scriptInfo', 0,
        0,
        ServiceWorkerScriptInfoSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class ServiceWorkerInstalledScriptsManager_TransferInstalledScript_Params {
  constructor() {
    /** @type { !ServiceWorkerScriptInfo } */
    this.scriptInfo;
  }
}

