// third_party/blink/public/mojom/service_worker/service_worker_container.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';

import {
  FilePath as mojoBase_mojom_FilePath,
  FilePathSpec as mojoBase_mojom_FilePathSpec
} from '../../../../../mojo/public/mojom/base/file_path.mojom.m.js';

import {
  Url as url_mojom_Url,
  UrlSpec as url_mojom_UrlSpec
} from '../../../../../url/mojom/url.mojom.m.js';

import {
  FetchClientSettingsObject as blink_mojom_FetchClientSettingsObject,
  FetchClientSettingsObjectSpec as blink_mojom_FetchClientSettingsObjectSpec
} from '../loader/fetch_client_settings_object.mojom.m.js';

import {
  TransferableMessage as blink_mojom_TransferableMessage,
  TransferableMessageSpec as blink_mojom_TransferableMessageSpec
} from '../messaging/transferable_message.mojom.m.js';

import {
  WebFeature as blink_mojom_WebFeature,
  WebFeatureSpec as blink_mojom_WebFeatureSpec
} from '../use_counter/metrics/web_feature.mojom.m.js';

import {
  ControllerServiceWorkerRemote as blink_mojom_ControllerServiceWorkerRemote,
  ControllerServiceWorkerPendingReceiver as blink_mojom_ControllerServiceWorkerPendingReceiver,
  ControllerServiceWorkerInfo as blink_mojom_ControllerServiceWorkerInfo,
  ControllerServiceWorkerInfoSpec as blink_mojom_ControllerServiceWorkerInfoSpec
} from './controller_service_worker.mojom.m.js';

import {
  ServiceWorkerErrorType as blink_mojom_ServiceWorkerErrorType,
  ServiceWorkerErrorTypeSpec as blink_mojom_ServiceWorkerErrorTypeSpec
} from './service_worker_error_type.mojom.m.js';

import {
  ServiceWorkerObjectInfo as blink_mojom_ServiceWorkerObjectInfo,
  ServiceWorkerObjectInfoSpec as blink_mojom_ServiceWorkerObjectInfoSpec
} from './service_worker_object.mojom.m.js';

import {
  ServiceWorkerRegistrationObjectInfo as blink_mojom_ServiceWorkerRegistrationObjectInfo,
  ServiceWorkerRegistrationObjectInfoSpec as blink_mojom_ServiceWorkerRegistrationObjectInfoSpec
} from './service_worker_registration.mojom.m.js';

import {
  ServiceWorkerRegistrationOptions as blink_mojom_ServiceWorkerRegistrationOptions,
  ServiceWorkerRegistrationOptionsSpec as blink_mojom_ServiceWorkerRegistrationOptionsSpec
} from './service_worker_registration_options.mojom.m.js';


/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const ControllerServiceWorkerPurposeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const ControllerServiceWorkerPurpose = {
  
  FETCH_SUB_RESOURCE: 0,
  MIN_VALUE: 0,
  MAX_VALUE: 0,
};



/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class ServiceWorkerContainerHostPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.ServiceWorkerContainerHost', scope);
  }
}

/** @interface */
export class ServiceWorkerContainerHostInterface {
  
  /**
   * @param { !url_mojom_Url } scriptUrl
   * @param { !blink_mojom_ServiceWorkerRegistrationOptions } options
   * @param { !blink_mojom_FetchClientSettingsObject } outsideFetchClientSettingsObject
   * @return {!Promise<{
        error: !blink_mojom_ServiceWorkerErrorType,
        errorMsg: ?string,
        registration: ?blink_mojom_ServiceWorkerRegistrationObjectInfo,
   *  }>}
   */

  register(scriptUrl, options, outsideFetchClientSettingsObject) {}
  
  /**
   * @param { !url_mojom_Url } clientUrl
   * @return {!Promise<{
        error: !blink_mojom_ServiceWorkerErrorType,
        errorMsg: ?string,
        registration: ?blink_mojom_ServiceWorkerRegistrationObjectInfo,
   *  }>}
   */

  getRegistration(clientUrl) {}
  
  /**
   * @return {!Promise<{
        error: !blink_mojom_ServiceWorkerErrorType,
        errorMsg: ?string,
        infos: ?Array<!blink_mojom_ServiceWorkerRegistrationObjectInfo>,
   *  }>}
   */

  getRegistrations() {}
  
  /**
   * @return {!Promise<{
        registration: ?blink_mojom_ServiceWorkerRegistrationObjectInfo,
   *  }>}
   */

  getRegistrationForReady() {}
  
  /**
   * @param { !blink_mojom_ControllerServiceWorkerPendingReceiver } receiver
   * @param { !ControllerServiceWorkerPurpose } purpose
   */

  ensureControllerServiceWorker(receiver, purpose) {}
  
  /**
   * @param { !ServiceWorkerContainerHostPendingReceiver } containerHost
   */

  cloneContainerHost(containerHost) {}
  
  /**
   */

  hintToUpdateServiceWorker() {}
  
  /**
   * @param { !Array<!mojoBase_mojom_FilePath> } files
   * @return {!Promise}
   */

  ensureFileAccess(files) {}
  
  /**
   */

  onExecutionReady() {}
}

/**
 * @implements { ServiceWorkerContainerHostInterface }
 */
export class ServiceWorkerContainerHostRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!ServiceWorkerContainerHostPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          ServiceWorkerContainerHostPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!ServiceWorkerContainerHostPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !url_mojom_Url } scriptUrl
   * @param { !blink_mojom_ServiceWorkerRegistrationOptions } options
   * @param { !blink_mojom_FetchClientSettingsObject } outsideFetchClientSettingsObject
   * @return {!Promise<{
        error: !blink_mojom_ServiceWorkerErrorType,
        errorMsg: ?string,
        registration: ?blink_mojom_ServiceWorkerRegistrationObjectInfo,
   *  }>}
   */

  register(
      scriptUrl,
      options,
      outsideFetchClientSettingsObject) {
    return this.proxy.sendMessage(
        0,
        ServiceWorkerContainerHost_Register_ParamsSpec.$,
        ServiceWorkerContainerHost_Register_ResponseParamsSpec.$,
        [
          scriptUrl,
          options,
          outsideFetchClientSettingsObject
        ],
        false);
  }

  
  /**
   * @param { !url_mojom_Url } clientUrl
   * @return {!Promise<{
        error: !blink_mojom_ServiceWorkerErrorType,
        errorMsg: ?string,
        registration: ?blink_mojom_ServiceWorkerRegistrationObjectInfo,
   *  }>}
   */

  getRegistration(
      clientUrl) {
    return this.proxy.sendMessage(
        1,
        ServiceWorkerContainerHost_GetRegistration_ParamsSpec.$,
        ServiceWorkerContainerHost_GetRegistration_ResponseParamsSpec.$,
        [
          clientUrl
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        error: !blink_mojom_ServiceWorkerErrorType,
        errorMsg: ?string,
        infos: ?Array<!blink_mojom_ServiceWorkerRegistrationObjectInfo>,
   *  }>}
   */

  getRegistrations() {
    return this.proxy.sendMessage(
        2,
        ServiceWorkerContainerHost_GetRegistrations_ParamsSpec.$,
        ServiceWorkerContainerHost_GetRegistrations_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        registration: ?blink_mojom_ServiceWorkerRegistrationObjectInfo,
   *  }>}
   */

  getRegistrationForReady() {
    return this.proxy.sendMessage(
        3,
        ServiceWorkerContainerHost_GetRegistrationForReady_ParamsSpec.$,
        ServiceWorkerContainerHost_GetRegistrationForReady_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !blink_mojom_ControllerServiceWorkerPendingReceiver } receiver
   * @param { !ControllerServiceWorkerPurpose } purpose
   */

  ensureControllerServiceWorker(
      receiver,
      purpose) {
    this.proxy.sendMessage(
        4,
        ServiceWorkerContainerHost_EnsureControllerServiceWorker_ParamsSpec.$,
        null,
        [
          receiver,
          purpose
        ],
        false);
  }

  
  /**
   * @param { !ServiceWorkerContainerHostPendingReceiver } containerHost
   */

  cloneContainerHost(
      containerHost) {
    this.proxy.sendMessage(
        5,
        ServiceWorkerContainerHost_CloneContainerHost_ParamsSpec.$,
        null,
        [
          containerHost
        ],
        false);
  }

  
  /**
   */

  hintToUpdateServiceWorker() {
    this.proxy.sendMessage(
        6,
        ServiceWorkerContainerHost_HintToUpdateServiceWorker_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !Array<!mojoBase_mojom_FilePath> } files
   * @return {!Promise}
   */

  ensureFileAccess(
      files) {
    return this.proxy.sendMessage(
        7,
        ServiceWorkerContainerHost_EnsureFileAccess_ParamsSpec.$,
        ServiceWorkerContainerHost_EnsureFileAccess_ResponseParamsSpec.$,
        [
          files
        ],
        false);
  }

  
  /**
   */

  onExecutionReady() {
    this.proxy.sendMessage(
        8,
        ServiceWorkerContainerHost_OnExecutionReady_ParamsSpec.$,
        null,
        [
        ],
        false);
  }
}

/**
 * An object which receives request messages for the ServiceWorkerContainerHost
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class ServiceWorkerContainerHostReceiver {
  /**
   * @param {!ServiceWorkerContainerHostInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!ServiceWorkerContainerHostRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        ServiceWorkerContainerHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ServiceWorkerContainerHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        ServiceWorkerContainerHost_Register_ParamsSpec.$,
        ServiceWorkerContainerHost_Register_ResponseParamsSpec.$,
        impl.register.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        ServiceWorkerContainerHost_GetRegistration_ParamsSpec.$,
        ServiceWorkerContainerHost_GetRegistration_ResponseParamsSpec.$,
        impl.getRegistration.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        ServiceWorkerContainerHost_GetRegistrations_ParamsSpec.$,
        ServiceWorkerContainerHost_GetRegistrations_ResponseParamsSpec.$,
        impl.getRegistrations.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        ServiceWorkerContainerHost_GetRegistrationForReady_ParamsSpec.$,
        ServiceWorkerContainerHost_GetRegistrationForReady_ResponseParamsSpec.$,
        impl.getRegistrationForReady.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        ServiceWorkerContainerHost_EnsureControllerServiceWorker_ParamsSpec.$,
        null,
        impl.ensureControllerServiceWorker.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        ServiceWorkerContainerHost_CloneContainerHost_ParamsSpec.$,
        null,
        impl.cloneContainerHost.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        ServiceWorkerContainerHost_HintToUpdateServiceWorker_ParamsSpec.$,
        null,
        impl.hintToUpdateServiceWorker.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        ServiceWorkerContainerHost_EnsureFileAccess_ParamsSpec.$,
        ServiceWorkerContainerHost_EnsureFileAccess_ResponseParamsSpec.$,
        impl.ensureFileAccess.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        ServiceWorkerContainerHost_OnExecutionReady_ParamsSpec.$,
        null,
        impl.onExecutionReady.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class ServiceWorkerContainerHost {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.ServiceWorkerContainerHost";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!ServiceWorkerContainerHostRemote}
   */
  static getRemote() {
    let remote = new ServiceWorkerContainerHostRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the ServiceWorkerContainerHost
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class ServiceWorkerContainerHostCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      ServiceWorkerContainerHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ServiceWorkerContainerHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.register =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        ServiceWorkerContainerHost_Register_ParamsSpec.$,
        ServiceWorkerContainerHost_Register_ResponseParamsSpec.$,
        this.register.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getRegistration =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        ServiceWorkerContainerHost_GetRegistration_ParamsSpec.$,
        ServiceWorkerContainerHost_GetRegistration_ResponseParamsSpec.$,
        this.getRegistration.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getRegistrations =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        ServiceWorkerContainerHost_GetRegistrations_ParamsSpec.$,
        ServiceWorkerContainerHost_GetRegistrations_ResponseParamsSpec.$,
        this.getRegistrations.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getRegistrationForReady =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        ServiceWorkerContainerHost_GetRegistrationForReady_ParamsSpec.$,
        ServiceWorkerContainerHost_GetRegistrationForReady_ResponseParamsSpec.$,
        this.getRegistrationForReady.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.ensureControllerServiceWorker =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        ServiceWorkerContainerHost_EnsureControllerServiceWorker_ParamsSpec.$,
        null,
        this.ensureControllerServiceWorker.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.cloneContainerHost =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        ServiceWorkerContainerHost_CloneContainerHost_ParamsSpec.$,
        null,
        this.cloneContainerHost.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.hintToUpdateServiceWorker =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        ServiceWorkerContainerHost_HintToUpdateServiceWorker_ParamsSpec.$,
        null,
        this.hintToUpdateServiceWorker.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.ensureFileAccess =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        ServiceWorkerContainerHost_EnsureFileAccess_ParamsSpec.$,
        ServiceWorkerContainerHost_EnsureFileAccess_ResponseParamsSpec.$,
        this.ensureFileAccess.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onExecutionReady =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        ServiceWorkerContainerHost_OnExecutionReady_ParamsSpec.$,
        null,
        this.onExecutionReady.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class ServiceWorkerContainerPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.ServiceWorkerContainer', scope);
  }
}

/** @interface */
export class ServiceWorkerContainerInterface {
  
  /**
   * @param { !blink_mojom_ControllerServiceWorkerInfo } controllerInfo
   * @param { !boolean } shouldNotifyControllerchange
   */

  setController(controllerInfo, shouldNotifyControllerchange) {}
  
  /**
   * @param { !blink_mojom_ServiceWorkerObjectInfo } source
   * @param { !blink_mojom_TransferableMessage } message
   */

  postMessageToClient(source, message) {}
  
  /**
   * @param { !blink_mojom_WebFeature } feature
   */

  countFeature(feature) {}
}

/**
 * @implements { ServiceWorkerContainerInterface }
 */
export class ServiceWorkerContainerRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!ServiceWorkerContainerPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          ServiceWorkerContainerPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!ServiceWorkerContainerPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !blink_mojom_ControllerServiceWorkerInfo } controllerInfo
   * @param { !boolean } shouldNotifyControllerchange
   */

  setController(
      controllerInfo,
      shouldNotifyControllerchange) {
    this.proxy.sendMessage(
        0,
        ServiceWorkerContainer_SetController_ParamsSpec.$,
        null,
        [
          controllerInfo,
          shouldNotifyControllerchange
        ],
        false);
  }

  
  /**
   * @param { !blink_mojom_ServiceWorkerObjectInfo } source
   * @param { !blink_mojom_TransferableMessage } message
   */

  postMessageToClient(
      source,
      message) {
    this.proxy.sendMessage(
        1,
        ServiceWorkerContainer_PostMessageToClient_ParamsSpec.$,
        null,
        [
          source,
          message
        ],
        false);
  }

  
  /**
   * @param { !blink_mojom_WebFeature } feature
   */

  countFeature(
      feature) {
    this.proxy.sendMessage(
        2,
        ServiceWorkerContainer_CountFeature_ParamsSpec.$,
        null,
        [
          feature
        ],
        false);
  }
}

/**
 * An object which receives request messages for the ServiceWorkerContainer
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class ServiceWorkerContainerReceiver {
  /**
   * @param {!ServiceWorkerContainerInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!ServiceWorkerContainerRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        ServiceWorkerContainerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ServiceWorkerContainerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        ServiceWorkerContainer_SetController_ParamsSpec.$,
        null,
        impl.setController.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        ServiceWorkerContainer_PostMessageToClient_ParamsSpec.$,
        null,
        impl.postMessageToClient.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        ServiceWorkerContainer_CountFeature_ParamsSpec.$,
        null,
        impl.countFeature.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class ServiceWorkerContainer {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.ServiceWorkerContainer";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!ServiceWorkerContainerRemote}
   */
  static getRemote() {
    let remote = new ServiceWorkerContainerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the ServiceWorkerContainer
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class ServiceWorkerContainerCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      ServiceWorkerContainerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ServiceWorkerContainerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setController =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        ServiceWorkerContainer_SetController_ParamsSpec.$,
        null,
        this.setController.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.postMessageToClient =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        ServiceWorkerContainer_PostMessageToClient_ParamsSpec.$,
        null,
        this.postMessageToClient.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.countFeature =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        ServiceWorkerContainer_CountFeature_ParamsSpec.$,
        null,
        this.countFeature.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ServiceWorkerContainerInfoForClientSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ServiceWorkerContainerHost_Register_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ServiceWorkerContainerHost_Register_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ServiceWorkerContainerHost_GetRegistration_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ServiceWorkerContainerHost_GetRegistration_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ServiceWorkerContainerHost_GetRegistrations_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ServiceWorkerContainerHost_GetRegistrations_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ServiceWorkerContainerHost_GetRegistrationForReady_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ServiceWorkerContainerHost_GetRegistrationForReady_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ServiceWorkerContainerHost_EnsureControllerServiceWorker_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ServiceWorkerContainerHost_CloneContainerHost_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ServiceWorkerContainerHost_HintToUpdateServiceWorker_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ServiceWorkerContainerHost_EnsureFileAccess_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ServiceWorkerContainerHost_EnsureFileAccess_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ServiceWorkerContainerHost_OnExecutionReady_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ServiceWorkerContainer_SetController_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ServiceWorkerContainer_PostMessageToClient_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ServiceWorkerContainer_CountFeature_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    ServiceWorkerContainerInfoForClientSpec.$,
    'ServiceWorkerContainerInfoForClient',
    [
      mojo.internal.StructField(
        'hostRemote', 0,
        0,
        mojo.internal.AssociatedInterfaceProxy(ServiceWorkerContainerHostRemote),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'clientReceiver', 8,
        0,
        mojo.internal.AssociatedInterfaceRequest(ServiceWorkerContainerPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class ServiceWorkerContainerInfoForClient {
  constructor() {
    /** @type { !Object } */
    this.hostRemote;
    /** @type { !Object } */
    this.clientReceiver;
  }
}



mojo.internal.Struct(
    ServiceWorkerContainerHost_Register_ParamsSpec.$,
    'ServiceWorkerContainerHost_Register_Params',
    [
      mojo.internal.StructField(
        'scriptUrl', 0,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'options', 8,
        0,
        blink_mojom_ServiceWorkerRegistrationOptionsSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'outsideFetchClientSettingsObject', 16,
        0,
        blink_mojom_FetchClientSettingsObjectSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class ServiceWorkerContainerHost_Register_Params {
  constructor() {
    /** @type { !url_mojom_Url } */
    this.scriptUrl;
    /** @type { !blink_mojom_ServiceWorkerRegistrationOptions } */
    this.options;
    /** @type { !blink_mojom_FetchClientSettingsObject } */
    this.outsideFetchClientSettingsObject;
  }
}



mojo.internal.Struct(
    ServiceWorkerContainerHost_Register_ResponseParamsSpec.$,
    'ServiceWorkerContainerHost_Register_ResponseParams',
    [
      mojo.internal.StructField(
        'error', 0,
        0,
        blink_mojom_ServiceWorkerErrorTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'errorMsg', 8,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'registration', 16,
        0,
        blink_mojom_ServiceWorkerRegistrationObjectInfoSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class ServiceWorkerContainerHost_Register_ResponseParams {
  constructor() {
    /** @type { !blink_mojom_ServiceWorkerErrorType } */
    this.error;
    /** @type { (string|undefined) } */
    this.errorMsg;
    /** @type { (blink_mojom_ServiceWorkerRegistrationObjectInfo|undefined) } */
    this.registration;
  }
}



mojo.internal.Struct(
    ServiceWorkerContainerHost_GetRegistration_ParamsSpec.$,
    'ServiceWorkerContainerHost_GetRegistration_Params',
    [
      mojo.internal.StructField(
        'clientUrl', 0,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class ServiceWorkerContainerHost_GetRegistration_Params {
  constructor() {
    /** @type { !url_mojom_Url } */
    this.clientUrl;
  }
}



mojo.internal.Struct(
    ServiceWorkerContainerHost_GetRegistration_ResponseParamsSpec.$,
    'ServiceWorkerContainerHost_GetRegistration_ResponseParams',
    [
      mojo.internal.StructField(
        'error', 0,
        0,
        blink_mojom_ServiceWorkerErrorTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'errorMsg', 8,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'registration', 16,
        0,
        blink_mojom_ServiceWorkerRegistrationObjectInfoSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class ServiceWorkerContainerHost_GetRegistration_ResponseParams {
  constructor() {
    /** @type { !blink_mojom_ServiceWorkerErrorType } */
    this.error;
    /** @type { (string|undefined) } */
    this.errorMsg;
    /** @type { (blink_mojom_ServiceWorkerRegistrationObjectInfo|undefined) } */
    this.registration;
  }
}



mojo.internal.Struct(
    ServiceWorkerContainerHost_GetRegistrations_ParamsSpec.$,
    'ServiceWorkerContainerHost_GetRegistrations_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class ServiceWorkerContainerHost_GetRegistrations_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    ServiceWorkerContainerHost_GetRegistrations_ResponseParamsSpec.$,
    'ServiceWorkerContainerHost_GetRegistrations_ResponseParams',
    [
      mojo.internal.StructField(
        'error', 0,
        0,
        blink_mojom_ServiceWorkerErrorTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'errorMsg', 8,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'infos', 16,
        0,
        mojo.internal.Array(blink_mojom_ServiceWorkerRegistrationObjectInfoSpec.$, false),
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class ServiceWorkerContainerHost_GetRegistrations_ResponseParams {
  constructor() {
    /** @type { !blink_mojom_ServiceWorkerErrorType } */
    this.error;
    /** @type { (string|undefined) } */
    this.errorMsg;
    /** @type { (Array<!blink_mojom_ServiceWorkerRegistrationObjectInfo>|undefined) } */
    this.infos;
  }
}



mojo.internal.Struct(
    ServiceWorkerContainerHost_GetRegistrationForReady_ParamsSpec.$,
    'ServiceWorkerContainerHost_GetRegistrationForReady_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class ServiceWorkerContainerHost_GetRegistrationForReady_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    ServiceWorkerContainerHost_GetRegistrationForReady_ResponseParamsSpec.$,
    'ServiceWorkerContainerHost_GetRegistrationForReady_ResponseParams',
    [
      mojo.internal.StructField(
        'registration', 0,
        0,
        blink_mojom_ServiceWorkerRegistrationObjectInfoSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class ServiceWorkerContainerHost_GetRegistrationForReady_ResponseParams {
  constructor() {
    /** @type { (blink_mojom_ServiceWorkerRegistrationObjectInfo|undefined) } */
    this.registration;
  }
}



mojo.internal.Struct(
    ServiceWorkerContainerHost_EnsureControllerServiceWorker_ParamsSpec.$,
    'ServiceWorkerContainerHost_EnsureControllerServiceWorker_Params',
    [
      mojo.internal.StructField(
        'receiver', 0,
        0,
        mojo.internal.InterfaceRequest(blink_mojom_ControllerServiceWorkerPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'purpose', 4,
        0,
        ControllerServiceWorkerPurposeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class ServiceWorkerContainerHost_EnsureControllerServiceWorker_Params {
  constructor() {
    /** @type { !blink_mojom_ControllerServiceWorkerPendingReceiver } */
    this.receiver;
    /** @type { !ControllerServiceWorkerPurpose } */
    this.purpose;
  }
}



mojo.internal.Struct(
    ServiceWorkerContainerHost_CloneContainerHost_ParamsSpec.$,
    'ServiceWorkerContainerHost_CloneContainerHost_Params',
    [
      mojo.internal.StructField(
        'containerHost', 0,
        0,
        mojo.internal.InterfaceRequest(ServiceWorkerContainerHostPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class ServiceWorkerContainerHost_CloneContainerHost_Params {
  constructor() {
    /** @type { !ServiceWorkerContainerHostPendingReceiver } */
    this.containerHost;
  }
}



mojo.internal.Struct(
    ServiceWorkerContainerHost_HintToUpdateServiceWorker_ParamsSpec.$,
    'ServiceWorkerContainerHost_HintToUpdateServiceWorker_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class ServiceWorkerContainerHost_HintToUpdateServiceWorker_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    ServiceWorkerContainerHost_EnsureFileAccess_ParamsSpec.$,
    'ServiceWorkerContainerHost_EnsureFileAccess_Params',
    [
      mojo.internal.StructField(
        'files', 0,
        0,
        mojo.internal.Array(mojoBase_mojom_FilePathSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class ServiceWorkerContainerHost_EnsureFileAccess_Params {
  constructor() {
    /** @type { !Array<!mojoBase_mojom_FilePath> } */
    this.files;
  }
}



mojo.internal.Struct(
    ServiceWorkerContainerHost_EnsureFileAccess_ResponseParamsSpec.$,
    'ServiceWorkerContainerHost_EnsureFileAccess_ResponseParams',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class ServiceWorkerContainerHost_EnsureFileAccess_ResponseParams {
  constructor() {
  }
}



mojo.internal.Struct(
    ServiceWorkerContainerHost_OnExecutionReady_ParamsSpec.$,
    'ServiceWorkerContainerHost_OnExecutionReady_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class ServiceWorkerContainerHost_OnExecutionReady_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    ServiceWorkerContainer_SetController_ParamsSpec.$,
    'ServiceWorkerContainer_SetController_Params',
    [
      mojo.internal.StructField(
        'controllerInfo', 0,
        0,
        blink_mojom_ControllerServiceWorkerInfoSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'shouldNotifyControllerchange', 8,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class ServiceWorkerContainer_SetController_Params {
  constructor() {
    /** @type { !blink_mojom_ControllerServiceWorkerInfo } */
    this.controllerInfo;
    /** @type { !boolean } */
    this.shouldNotifyControllerchange;
  }
}



mojo.internal.Struct(
    ServiceWorkerContainer_PostMessageToClient_ParamsSpec.$,
    'ServiceWorkerContainer_PostMessageToClient_Params',
    [
      mojo.internal.StructField(
        'source', 0,
        0,
        blink_mojom_ServiceWorkerObjectInfoSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'message', 8,
        0,
        blink_mojom_TransferableMessageSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class ServiceWorkerContainer_PostMessageToClient_Params {
  constructor() {
    /** @type { !blink_mojom_ServiceWorkerObjectInfo } */
    this.source;
    /** @type { !blink_mojom_TransferableMessage } */
    this.message;
  }
}



mojo.internal.Struct(
    ServiceWorkerContainer_CountFeature_ParamsSpec.$,
    'ServiceWorkerContainer_CountFeature_Params',
    [
      mojo.internal.StructField(
        'feature', 0,
        0,
        blink_mojom_WebFeatureSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class ServiceWorkerContainer_CountFeature_Params {
  constructor() {
    /** @type { !blink_mojom_WebFeature } */
    this.feature;
  }
}

