// third_party/blink/public/mojom/service_worker/service_worker.mojom-test-utils.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_SERVICE_WORKER_SERVICE_WORKER_MOJOM_TEST_UTILS_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_SERVICE_WORKER_SERVICE_WORKER_MOJOM_TEST_UTILS_H_

#include "third_party/blink/public/mojom/service_worker/service_worker.mojom.h"
#include "third_party/blink/public/common/common_export.h"


namespace blink::mojom {


class BLINK_COMMON_EXPORT ServiceWorkerHostInterceptorForTesting : public ServiceWorkerHost {
  virtual ServiceWorkerHost* GetForwardingInterface() = 0;
  void SetCachedMetadata(const ::GURL& url, ::base::span<const ::uint8_t> data) override;
  void ClearCachedMetadata(const ::GURL& url) override;
  void GetClients(::blink::mojom::ServiceWorkerClientQueryOptionsPtr options, GetClientsCallback callback) override;
  void GetClient(const std::string& client_uuid, GetClientCallback callback) override;
  void OpenNewTab(const ::GURL& url, OpenNewTabCallback callback) override;
  void OpenPaymentHandlerWindow(const ::GURL& url, OpenPaymentHandlerWindowCallback callback) override;
  void PostMessageToClient(const std::string& client_uuid, ::blink::TransferableMessage message) override;
  void FocusClient(const std::string& client_uuid, FocusClientCallback callback) override;
  void NavigateClient(const std::string& client_uuid, const ::GURL& url, NavigateClientCallback callback) override;
  void SkipWaiting(SkipWaitingCallback callback) override;
  void ClaimClients(ClaimClientsCallback callback) override;
  void AddRoutes(const ::blink::ServiceWorkerRouterRules& rules, AddRoutesCallback callback) override;
};
class BLINK_COMMON_EXPORT ServiceWorkerHostAsyncWaiter {
 public:
  explicit ServiceWorkerHostAsyncWaiter(ServiceWorkerHost* proxy);

  ServiceWorkerHostAsyncWaiter(const ServiceWorkerHostAsyncWaiter&) = delete;
  ServiceWorkerHostAsyncWaiter& operator=(const ServiceWorkerHostAsyncWaiter&) = delete;

  ~ServiceWorkerHostAsyncWaiter();
  void GetClients(
      ::blink::mojom::ServiceWorkerClientQueryOptionsPtr options, std::vector<::blink::mojom::ServiceWorkerClientInfoPtr>* out_clients);
  std::vector<::blink::mojom::ServiceWorkerClientInfoPtr> GetClients(::blink::mojom::ServiceWorkerClientQueryOptionsPtr options);
  void GetClient(
      const std::string& client_uuid, ::blink::mojom::ServiceWorkerClientInfoPtr* out_client);
  ::blink::mojom::ServiceWorkerClientInfoPtr GetClient(const std::string& client_uuid);
  void OpenNewTab(
      const ::GURL& url, bool* out_success, ::blink::mojom::ServiceWorkerClientInfoPtr* out_client, std::optional<std::string>* out_error_msg);
  
  void OpenPaymentHandlerWindow(
      const ::GURL& url, bool* out_success, ::blink::mojom::ServiceWorkerClientInfoPtr* out_client, std::optional<std::string>* out_error_msg);
  
  void FocusClient(
      const std::string& client_uuid, FocusResultPtr* out_result);
  FocusResultPtr FocusClient(const std::string& client_uuid);
  void NavigateClient(
      const std::string& client_uuid, const ::GURL& url, bool* out_success, ::blink::mojom::ServiceWorkerClientInfoPtr* out_client, std::optional<std::string>* out_error_msg);
  
  void SkipWaiting(
      bool* out_success);
  bool SkipWaiting();
  void ClaimClients(
      ::blink::mojom::ServiceWorkerErrorType* out_error, std::optional<std::string>* out_error_msg);
  
  void AddRoutes(
      const ::blink::ServiceWorkerRouterRules& rules, bool* out_is_parse_error);
  bool AddRoutes(const ::blink::ServiceWorkerRouterRules& rules);

 private:
  ServiceWorkerHost* const proxy_;
};


class BLINK_COMMON_EXPORT ServiceWorkerInterceptorForTesting : public ServiceWorker {
  virtual ServiceWorker* GetForwardingInterface() = 0;
  void InitializeGlobalScope(::mojo::PendingAssociatedRemote<ServiceWorkerHost> service_worker_host, ::mojo::PendingAssociatedRemote<::blink::mojom::AssociatedInterfaceProvider> associated_interfaces_to_browser, ::mojo::PendingAssociatedReceiver<::blink::mojom::AssociatedInterfaceProvider> associated_interfaces_from_browser, ::blink::mojom::ServiceWorkerRegistrationObjectInfoPtr registration_info, ::blink::mojom::ServiceWorkerObjectInfoPtr service_worker_info, FetchHandlerExistence fetch_handler_existence, ::blink::mojom::AncestorFrameType ancestor_frame_type, const ::blink::StorageKey& storage_key) override;
  void DispatchInstallEvent(DispatchInstallEventCallback callback) override;
  void DispatchActivateEvent(DispatchActivateEventCallback callback) override;
  void DispatchBackgroundFetchAbortEvent(::blink::mojom::BackgroundFetchRegistrationPtr registration, DispatchBackgroundFetchAbortEventCallback callback) override;
  void DispatchBackgroundFetchClickEvent(::blink::mojom::BackgroundFetchRegistrationPtr registration, DispatchBackgroundFetchClickEventCallback callback) override;
  void DispatchBackgroundFetchFailEvent(::blink::mojom::BackgroundFetchRegistrationPtr registration, DispatchBackgroundFetchFailEventCallback callback) override;
  void DispatchBackgroundFetchSuccessEvent(::blink::mojom::BackgroundFetchRegistrationPtr registration, DispatchBackgroundFetchSuccessEventCallback callback) override;
  void DispatchCookieChangeEvent(const ::net::CookieChangeInfo& change, DispatchCookieChangeEventCallback callback) override;
  void DispatchFetchEventForMainResource(::blink::mojom::DispatchFetchEventParamsPtr params, ::mojo::PendingRemote<::blink::mojom::ServiceWorkerFetchResponseCallback> response_callback, DispatchFetchEventForMainResourceCallback callback) override;
  void DispatchNotificationClickEvent(const std::string& notification_id, const ::blink::PlatformNotificationData& notification_data, int32_t action_index, const std::optional<::std::u16string>& reply, DispatchNotificationClickEventCallback callback) override;
  void DispatchNotificationCloseEvent(const std::string& notification_id, const ::blink::PlatformNotificationData& notification_data, DispatchNotificationCloseEventCallback callback) override;
  void DispatchPushEvent(const std::optional<std::string>& payload, DispatchPushEventCallback callback) override;
  void DispatchPushEventRecordingNetworkRequests(const std::optional<std::string>& payload, DispatchPushEventRecordingNetworkRequestsCallback callback) override;
  void DispatchPushSubscriptionChangeEvent(::blink::mojom::PushSubscriptionPtr old_subscription, ::blink::mojom::PushSubscriptionPtr new_subscription, DispatchPushSubscriptionChangeEventCallback callback) override;
  void DispatchSyncEvent(const std::string& tag, bool last_chance, ::base::TimeDelta timeout, DispatchSyncEventCallback callback) override;
  void DispatchPeriodicSyncEvent(const std::string& tag, ::base::TimeDelta timeout, DispatchPeriodicSyncEventCallback callback) override;
  void DispatchAbortPaymentEvent(::mojo::PendingRemote<::payments::mojom::PaymentHandlerResponseCallback> result_of_abort_payment, DispatchAbortPaymentEventCallback callback) override;
  void DispatchCanMakePaymentEvent(::payments::mojom::CanMakePaymentEventDataPtr event_data, ::mojo::PendingRemote<::payments::mojom::PaymentHandlerResponseCallback> result_of_can_make_payment, DispatchCanMakePaymentEventCallback callback) override;
  void DispatchPaymentRequestEvent(::payments::mojom::PaymentRequestEventDataPtr request_data, ::mojo::PendingRemote<::payments::mojom::PaymentHandlerResponseCallback> response_callback, DispatchPaymentRequestEventCallback callback) override;
  void DispatchExtendableMessageEvent(ExtendableMessageEventPtr event, DispatchExtendableMessageEventCallback callback) override;
  void DispatchContentDeleteEvent(const std::string& id, DispatchContentDeleteEventCallback callback) override;
  void Ping(PingCallback callback) override;
  void SetIdleDelay(::base::TimeDelta delay) override;
  void AddKeepAlive() override;
  void ClearKeepAlive() override;
  void AddMessageToConsole(::blink::mojom::ConsoleMessageLevel level, const std::string& message) override;
  void ExecuteScriptForTest(const ::std::u16string& javascript, bool wants_result, ExecuteScriptForTestCallback callback) override;
};
class BLINK_COMMON_EXPORT ServiceWorkerAsyncWaiter {
 public:
  explicit ServiceWorkerAsyncWaiter(ServiceWorker* proxy);

  ServiceWorkerAsyncWaiter(const ServiceWorkerAsyncWaiter&) = delete;
  ServiceWorkerAsyncWaiter& operator=(const ServiceWorkerAsyncWaiter&) = delete;

  ~ServiceWorkerAsyncWaiter();
  void DispatchInstallEvent(
      ::blink::mojom::ServiceWorkerEventStatus* out_status, uint32_t* out_fetch_count);
  
  void DispatchActivateEvent(
      ::blink::mojom::ServiceWorkerEventStatus* out_status);
  ::blink::mojom::ServiceWorkerEventStatus DispatchActivateEvent();
  void DispatchBackgroundFetchAbortEvent(
      ::blink::mojom::BackgroundFetchRegistrationPtr registration, ::blink::mojom::ServiceWorkerEventStatus* out_status);
  ::blink::mojom::ServiceWorkerEventStatus DispatchBackgroundFetchAbortEvent(::blink::mojom::BackgroundFetchRegistrationPtr registration);
  void DispatchBackgroundFetchClickEvent(
      ::blink::mojom::BackgroundFetchRegistrationPtr registration, ::blink::mojom::ServiceWorkerEventStatus* out_status);
  ::blink::mojom::ServiceWorkerEventStatus DispatchBackgroundFetchClickEvent(::blink::mojom::BackgroundFetchRegistrationPtr registration);
  void DispatchBackgroundFetchFailEvent(
      ::blink::mojom::BackgroundFetchRegistrationPtr registration, ::blink::mojom::ServiceWorkerEventStatus* out_status);
  ::blink::mojom::ServiceWorkerEventStatus DispatchBackgroundFetchFailEvent(::blink::mojom::BackgroundFetchRegistrationPtr registration);
  void DispatchBackgroundFetchSuccessEvent(
      ::blink::mojom::BackgroundFetchRegistrationPtr registration, ::blink::mojom::ServiceWorkerEventStatus* out_status);
  ::blink::mojom::ServiceWorkerEventStatus DispatchBackgroundFetchSuccessEvent(::blink::mojom::BackgroundFetchRegistrationPtr registration);
  void DispatchCookieChangeEvent(
      const ::net::CookieChangeInfo& change, ::blink::mojom::ServiceWorkerEventStatus* out_status);
  ::blink::mojom::ServiceWorkerEventStatus DispatchCookieChangeEvent(const ::net::CookieChangeInfo& change);
  void DispatchFetchEventForMainResource(
      ::blink::mojom::DispatchFetchEventParamsPtr params, ::mojo::PendingRemote<::blink::mojom::ServiceWorkerFetchResponseCallback> response_callback, ::blink::mojom::ServiceWorkerEventStatus* out_status);
  ::blink::mojom::ServiceWorkerEventStatus DispatchFetchEventForMainResource(::blink::mojom::DispatchFetchEventParamsPtr params, ::mojo::PendingRemote<::blink::mojom::ServiceWorkerFetchResponseCallback> response_callback);
  void DispatchNotificationClickEvent(
      const std::string& notification_id, const ::blink::PlatformNotificationData& notification_data, int32_t action_index, const std::optional<::std::u16string>& reply, ::blink::mojom::ServiceWorkerEventStatus* out_status);
  ::blink::mojom::ServiceWorkerEventStatus DispatchNotificationClickEvent(const std::string& notification_id, const ::blink::PlatformNotificationData& notification_data, int32_t action_index, const std::optional<::std::u16string>& reply);
  void DispatchNotificationCloseEvent(
      const std::string& notification_id, const ::blink::PlatformNotificationData& notification_data, ::blink::mojom::ServiceWorkerEventStatus* out_status);
  ::blink::mojom::ServiceWorkerEventStatus DispatchNotificationCloseEvent(const std::string& notification_id, const ::blink::PlatformNotificationData& notification_data);
  void DispatchPushEvent(
      const std::optional<std::string>& payload, ::blink::mojom::ServiceWorkerEventStatus* out_status);
  ::blink::mojom::ServiceWorkerEventStatus DispatchPushEvent(const std::optional<std::string>& payload);
  void DispatchPushEventRecordingNetworkRequests(
      const std::optional<std::string>& payload, ::blink::mojom::ServiceWorkerEventStatus* out_status, std::optional<std::vector<::GURL>>* out_requested_urls);
  
  void DispatchPushSubscriptionChangeEvent(
      ::blink::mojom::PushSubscriptionPtr old_subscription, ::blink::mojom::PushSubscriptionPtr new_subscription, ::blink::mojom::ServiceWorkerEventStatus* out_status);
  ::blink::mojom::ServiceWorkerEventStatus DispatchPushSubscriptionChangeEvent(::blink::mojom::PushSubscriptionPtr old_subscription, ::blink::mojom::PushSubscriptionPtr new_subscription);
  void DispatchSyncEvent(
      const std::string& tag, bool last_chance, ::base::TimeDelta timeout, ::blink::mojom::ServiceWorkerEventStatus* out_status);
  ::blink::mojom::ServiceWorkerEventStatus DispatchSyncEvent(const std::string& tag, bool last_chance, ::base::TimeDelta timeout);
  void DispatchPeriodicSyncEvent(
      const std::string& tag, ::base::TimeDelta timeout, ::blink::mojom::ServiceWorkerEventStatus* out_status);
  ::blink::mojom::ServiceWorkerEventStatus DispatchPeriodicSyncEvent(const std::string& tag, ::base::TimeDelta timeout);
  void DispatchAbortPaymentEvent(
      ::mojo::PendingRemote<::payments::mojom::PaymentHandlerResponseCallback> result_of_abort_payment, ::blink::mojom::ServiceWorkerEventStatus* out_status);
  ::blink::mojom::ServiceWorkerEventStatus DispatchAbortPaymentEvent(::mojo::PendingRemote<::payments::mojom::PaymentHandlerResponseCallback> result_of_abort_payment);
  void DispatchCanMakePaymentEvent(
      ::payments::mojom::CanMakePaymentEventDataPtr event_data, ::mojo::PendingRemote<::payments::mojom::PaymentHandlerResponseCallback> result_of_can_make_payment, ::blink::mojom::ServiceWorkerEventStatus* out_status);
  ::blink::mojom::ServiceWorkerEventStatus DispatchCanMakePaymentEvent(::payments::mojom::CanMakePaymentEventDataPtr event_data, ::mojo::PendingRemote<::payments::mojom::PaymentHandlerResponseCallback> result_of_can_make_payment);
  void DispatchPaymentRequestEvent(
      ::payments::mojom::PaymentRequestEventDataPtr request_data, ::mojo::PendingRemote<::payments::mojom::PaymentHandlerResponseCallback> response_callback, ::blink::mojom::ServiceWorkerEventStatus* out_status);
  ::blink::mojom::ServiceWorkerEventStatus DispatchPaymentRequestEvent(::payments::mojom::PaymentRequestEventDataPtr request_data, ::mojo::PendingRemote<::payments::mojom::PaymentHandlerResponseCallback> response_callback);
  void DispatchExtendableMessageEvent(
      ExtendableMessageEventPtr event, ::blink::mojom::ServiceWorkerEventStatus* out_status);
  ::blink::mojom::ServiceWorkerEventStatus DispatchExtendableMessageEvent(ExtendableMessageEventPtr event);
  void DispatchContentDeleteEvent(
      const std::string& id, ::blink::mojom::ServiceWorkerEventStatus* out_status);
  ::blink::mojom::ServiceWorkerEventStatus DispatchContentDeleteEvent(const std::string& id);
  void Ping(
      );
  
  void ExecuteScriptForTest(
      const ::std::u16string& javascript, bool wants_result, ::base::Value* out_result, std::optional<std::string>* out_error);
  

 private:
  ServiceWorker* const proxy_;
};




}  // blink::mojom

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_SERVICE_WORKER_SERVICE_WORKER_MOJOM_TEST_UTILS_H_