// third_party/blink/public/mojom/service_worker/service_worker.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_SERVICE_WORKER_SERVICE_WORKER_MOJOM_DATA_VIEW_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_SERVICE_WORKER_SERVICE_WORKER_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/blink/public/mojom/service_worker/service_worker.mojom-shared-internal.h"
#include "mojo/public/mojom/base/read_only_buffer.mojom-shared.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "mojo/public/mojom/base/values.mojom-shared.h"
#include "services/network/public/mojom/cookie_manager.mojom-shared.h"
#include "services/network/public/mojom/url_loader_factory.mojom-shared.h"
#include "third_party/blink/public/mojom/associated_interfaces/associated_interfaces.mojom-shared.h"
#include "third_party/blink/public/mojom/background_fetch/background_fetch.mojom-shared.h"
#include "third_party/blink/public/mojom/devtools/console_message.mojom-shared.h"
#include "third_party/blink/public/mojom/fetch/fetch_api_response.mojom-shared.h"
#include "third_party/blink/public/mojom/loader/url_loader_factory_bundle.mojom-shared.h"
#include "third_party/blink/public/mojom/messaging/transferable_message.mojom-shared.h"
#include "third_party/blink/public/mojom/notifications/notification.mojom-shared.h"
#include "third_party/blink/public/mojom/payments/payment_app.mojom-shared.h"
#include "third_party/blink/public/mojom/push_messaging/push_messaging.mojom-shared.h"
#include "third_party/blink/public/mojom/service_worker/dispatch_fetch_event_params.mojom-shared.h"
#include "third_party/blink/public/mojom/service_worker/service_worker_ancestor_frame_type.mojom-shared.h"
#include "third_party/blink/public/mojom/service_worker/service_worker_client.mojom-shared.h"
#include "third_party/blink/public/mojom/service_worker/service_worker_error_type.mojom-shared.h"
#include "third_party/blink/public/mojom/service_worker/service_worker_event_status.mojom-shared.h"
#include "third_party/blink/public/mojom/service_worker/service_worker_fetch_response_callback.mojom-shared.h"
#include "third_party/blink/public/mojom/service_worker/service_worker_object.mojom-shared.h"
#include "third_party/blink/public/mojom/service_worker/service_worker_registration.mojom-shared.h"
#include "third_party/blink/public/mojom/service_worker/service_worker_router_rule.mojom-shared.h"
#include "third_party/blink/public/mojom/storage_key/storage_key.mojom-shared.h"
#include "url/mojom/origin.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"


namespace blink::mojom {
class ExtendableMessageEventDataView;

class FocusResultDataView;


}  // blink::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::ExtendableMessageEventDataView> {
  using Data = ::blink::mojom::internal::ExtendableMessageEvent_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::FocusResultDataView> {
  using Data = ::blink::mojom::internal::FocusResult_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace blink::mojom {


enum class FocusError : int32_t {
  
  CLIENT_NOT_FOUND = 0,
  
  CLIENT_INACTIVE = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, FocusError value);
inline bool IsKnownEnumValue(FocusError value) {
  return internal::FocusError_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class FetchHandlerExistence : int32_t {
  
  UNKNOWN = 0,
  
  EXISTS = 1,
  
  DOES_NOT_EXIST = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, FetchHandlerExistence value);
inline bool IsKnownEnumValue(FetchHandlerExistence value) {
  return internal::FetchHandlerExistence_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class ServiceWorkerHostInterfaceBase {};

using ServiceWorkerHostPtrDataView =
    mojo::InterfacePtrDataView<ServiceWorkerHostInterfaceBase>;
using ServiceWorkerHostRequestDataView =
    mojo::InterfaceRequestDataView<ServiceWorkerHostInterfaceBase>;
using ServiceWorkerHostAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<ServiceWorkerHostInterfaceBase>;
using ServiceWorkerHostAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<ServiceWorkerHostInterfaceBase>;
class ServiceWorkerInterfaceBase {};

using ServiceWorkerPtrDataView =
    mojo::InterfacePtrDataView<ServiceWorkerInterfaceBase>;
using ServiceWorkerRequestDataView =
    mojo::InterfaceRequestDataView<ServiceWorkerInterfaceBase>;
using ServiceWorkerAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<ServiceWorkerInterfaceBase>;
using ServiceWorkerAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<ServiceWorkerInterfaceBase>;


class ExtendableMessageEventDataView {
 public:
  ExtendableMessageEventDataView() = default;

  ExtendableMessageEventDataView(
      internal::ExtendableMessageEvent_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetMessageDataView(
      ::blink::mojom::TransferableMessageDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMessage(UserType* output) {
    
    auto* pointer = data_->message.Get();
    return mojo::internal::Deserialize<::blink::mojom::TransferableMessageDataView>(
        pointer, output, message_);
  }
  inline void GetSourceOriginDataView(
      ::url::mojom::OriginDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSourceOrigin(UserType* output) {
    
    auto* pointer = data_->source_origin.Get();
    return mojo::internal::Deserialize<::url::mojom::OriginDataView>(
        pointer, output, message_);
  }
  inline void GetSourceInfoForClientDataView(
      ::blink::mojom::ServiceWorkerClientInfoDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSourceInfoForClient(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::ServiceWorkerClientInfoDataView, UserType>(),
    "Attempting to read the optional `source_info_for_client` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadSourceInfoForClient` instead "
    "of `ReadSourceInfoForClient if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->source_info_for_client.Get();
    return mojo::internal::Deserialize<::blink::mojom::ServiceWorkerClientInfoDataView>(
        pointer, output, message_);
  }
  inline void GetSourceInfoForServiceWorkerDataView(
      ::blink::mojom::ServiceWorkerObjectInfoDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSourceInfoForServiceWorker(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::ServiceWorkerObjectInfoDataView, UserType>(),
    "Attempting to read the optional `source_info_for_service_worker` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadSourceInfoForServiceWorker` instead "
    "of `ReadSourceInfoForServiceWorker if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->source_info_for_service_worker.Get();
    return mojo::internal::Deserialize<::blink::mojom::ServiceWorkerObjectInfoDataView>(
        pointer, output, message_);
  }
 private:
  internal::ExtendableMessageEvent_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class FocusResultDataView {
 public:
  using Tag = internal::FocusResult_Data::FocusResult_Tag;

  FocusResultDataView() = default;

  FocusResultDataView(
      internal::FocusResult_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_client() const { return data_->tag == Tag::kClient; }
  inline void GetClientDataView(
      ::blink::mojom::ServiceWorkerClientInfoDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadClient(UserType* output) const {
    
    CHECK(is_client());
    return mojo::internal::Deserialize<::blink::mojom::ServiceWorkerClientInfoDataView>(
        data_->data.f_client.Get(), output, message_);
  }
  bool is_error_code() const { return data_->tag == Tag::kErrorCode; }
  template <typename UserType>
  [[nodiscard]] bool ReadErrorCode(UserType* output) const {
    CHECK(is_error_code());
    return mojo::internal::Deserialize<::blink::mojom::FocusError>(
        data_->data.f_error_code, output);
  }
  FocusError error_code() const {
    CHECK(is_error_code());
    // TODO(dcheng): This seems incorrect, as it bypasses enum traits.
    return ::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::FocusError>(data_->data.f_error_code));
  }

 private:
  internal::FocusResult_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



}  // blink::mojom

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_SERVICE_WORKER_SERVICE_WORKER_MOJOM_DATA_VIEW_H_