// third_party/blink/public/mojom/service_worker/embedded_worker.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';

import {
  String16 as mojoBase_mojom_String16,
  String16Spec as mojoBase_mojom_String16Spec
} from '../../../../../mojo/public/mojom/base/string16.mojom.m.js';

import {
  TimeTicks as mojoBase_mojom_TimeTicks,
  TimeTicksSpec as mojoBase_mojom_TimeTicksSpec
} from '../../../../../mojo/public/mojom/base/time.mojom.m.js';

import {
  UnguessableToken as mojoBase_mojom_UnguessableToken,
  UnguessableTokenSpec as mojoBase_mojom_UnguessableTokenSpec
} from '../../../../../mojo/public/mojom/base/unguessable_token.mojom.m.js';

import {
  InterfaceProviderRemote as serviceManager_mojom_InterfaceProviderRemote,
  InterfaceProviderPendingReceiver as serviceManager_mojom_InterfaceProviderPendingReceiver
} from '../../../../../services/service_manager/public/mojom/interface_provider.mojom.m.js';

import {
  Url as url_mojom_Url,
  UrlSpec as url_mojom_UrlSpec
} from '../../../../../url/mojom/url.mojom.m.js';

import {
  ConsoleMessageLevel as blink_mojom_ConsoleMessageLevel,
  ConsoleMessageLevelSpec as blink_mojom_ConsoleMessageLevelSpec,
  ConsoleMessageSource as blink_mojom_ConsoleMessageSource,
  ConsoleMessageSourceSpec as blink_mojom_ConsoleMessageSourceSpec
} from '../devtools/console_message.mojom.m.js';

import {
  DevToolsAgentRemote as blink_mojom_DevToolsAgentRemote,
  DevToolsAgentPendingReceiver as blink_mojom_DevToolsAgentPendingReceiver,
  DevToolsAgentHostRemote as blink_mojom_DevToolsAgentHostRemote,
  DevToolsAgentHostPendingReceiver as blink_mojom_DevToolsAgentHostPendingReceiver
} from '../devtools/devtools_agent.mojom.m.js';

import {
  PolicyContainer as blink_mojom_PolicyContainer,
  PolicyContainerSpec as blink_mojom_PolicyContainerSpec
} from '../frame/policy_container.mojom.m.js';

import {
  ReportingObserverRemote as blink_mojom_ReportingObserverRemote,
  ReportingObserverPendingReceiver as blink_mojom_ReportingObserverPendingReceiver
} from '../frame/reporting_observer.mojom.m.js';

import {
  FetchClientSettingsObject as blink_mojom_FetchClientSettingsObject,
  FetchClientSettingsObjectSpec as blink_mojom_FetchClientSettingsObjectSpec
} from '../loader/fetch_client_settings_object.mojom.m.js';

import {
  URLLoaderFactoryBundle as blink_mojom_URLLoaderFactoryBundle,
  URLLoaderFactoryBundleSpec as blink_mojom_URLLoaderFactoryBundleSpec
} from '../loader/url_loader_factory_bundle.mojom.m.js';

import {
  RendererPreferenceWatcherRemote as blink_mojom_RendererPreferenceWatcherRemote,
  RendererPreferenceWatcherPendingReceiver as blink_mojom_RendererPreferenceWatcherPendingReceiver
} from '../renderer_preference_watcher.mojom.m.js';

import {
  RendererPreferences as blink_mojom_RendererPreferences,
  RendererPreferencesSpec as blink_mojom_RendererPreferencesSpec
} from '../renderer_preferences.mojom.m.js';

import {
  ScriptType as blink_mojom_ScriptType,
  ScriptTypeSpec as blink_mojom_ScriptTypeSpec
} from '../script/script_type.mojom.m.js';

import {
  StorageKey as blink_mojom_StorageKey,
  StorageKeySpec as blink_mojom_StorageKeySpec
} from '../storage_key/storage_key.mojom.m.js';

import {
  ServiceWorkerToken as blink_mojom_ServiceWorkerToken,
  ServiceWorkerTokenSpec as blink_mojom_ServiceWorkerTokenSpec
} from '../tokens/tokens.mojom.m.js';

import {
  WebFeature as blink_mojom_WebFeature,
  WebFeatureSpec as blink_mojom_WebFeatureSpec
} from '../use_counter/metrics/web_feature.mojom.m.js';

import {
  UserAgentMetadata as blink_mojom_UserAgentMetadata,
  UserAgentMetadataSpec as blink_mojom_UserAgentMetadataSpec
} from '../user_agent/user_agent_metadata.mojom.m.js';

import {
  SubresourceLoaderUpdaterRemote as blink_mojom_SubresourceLoaderUpdaterRemote,
  SubresourceLoaderUpdaterPendingReceiver as blink_mojom_SubresourceLoaderUpdaterPendingReceiver
} from '../worker/subresource_loader_updater.mojom.m.js';

import {
  WorkerContentSettingsProxyRemote as blink_mojom_WorkerContentSettingsProxyRemote,
  WorkerContentSettingsProxyPendingReceiver as blink_mojom_WorkerContentSettingsProxyPendingReceiver
} from '../worker/worker_content_settings_proxy.mojom.m.js';

import {
  WorkerMainScriptLoadParams as blink_mojom_WorkerMainScriptLoadParams,
  WorkerMainScriptLoadParamsSpec as blink_mojom_WorkerMainScriptLoadParamsSpec
} from '../worker/worker_main_script_load_params.mojom.m.js';

import {
  ControllerServiceWorkerRemote as blink_mojom_ControllerServiceWorkerRemote,
  ControllerServiceWorkerPendingReceiver as blink_mojom_ControllerServiceWorkerPendingReceiver
} from './controller_service_worker.mojom.m.js';

import {
  ServiceWorkerRemote as blink_mojom_ServiceWorkerRemote,
  ServiceWorkerPendingReceiver as blink_mojom_ServiceWorkerPendingReceiver
} from './service_worker.mojom.m.js';

import {
  ServiceWorkerStartStatus as blink_mojom_ServiceWorkerStartStatus,
  ServiceWorkerStartStatusSpec as blink_mojom_ServiceWorkerStartStatusSpec
} from './service_worker_event_status.mojom.m.js';

import {
  ServiceWorkerFetchHandlerType as blink_mojom_ServiceWorkerFetchHandlerType,
  ServiceWorkerFetchHandlerTypeSpec as blink_mojom_ServiceWorkerFetchHandlerTypeSpec
} from './service_worker_fetch_handler_type.mojom.m.js';

import {
  ServiceWorkerInstalledScriptsInfo as blink_mojom_ServiceWorkerInstalledScriptsInfo,
  ServiceWorkerInstalledScriptsInfoSpec as blink_mojom_ServiceWorkerInstalledScriptsInfoSpec
} from './service_worker_installed_scripts_manager.mojom.m.js';

import {
  ServiceWorkerProviderInfoForStartWorker as blink_mojom_ServiceWorkerProviderInfoForStartWorker,
  ServiceWorkerProviderInfoForStartWorkerSpec as blink_mojom_ServiceWorkerProviderInfoForStartWorkerSpec
} from './service_worker_provider.mojom.m.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class EmbeddedWorkerInstanceClientPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.EmbeddedWorkerInstanceClient', scope);
  }
}

/** @interface */
export class EmbeddedWorkerInstanceClientInterface {
  
  /**
   * @param { !EmbeddedWorkerStartParams } params
   */

  startWorker(params) {}
  
  /**
   */

  stopWorker() {}
}

/**
 * @implements { EmbeddedWorkerInstanceClientInterface }
 */
export class EmbeddedWorkerInstanceClientRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!EmbeddedWorkerInstanceClientPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          EmbeddedWorkerInstanceClientPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!EmbeddedWorkerInstanceClientPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !EmbeddedWorkerStartParams } params
   */

  startWorker(
      params) {
    this.proxy.sendMessage(
        0,
        EmbeddedWorkerInstanceClient_StartWorker_ParamsSpec.$,
        null,
        [
          params
        ],
        false);
  }

  
  /**
   */

  stopWorker() {
    this.proxy.sendMessage(
        1,
        EmbeddedWorkerInstanceClient_StopWorker_ParamsSpec.$,
        null,
        [
        ],
        false);
  }
}

/**
 * An object which receives request messages for the EmbeddedWorkerInstanceClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class EmbeddedWorkerInstanceClientReceiver {
  /**
   * @param {!EmbeddedWorkerInstanceClientInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!EmbeddedWorkerInstanceClientRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        EmbeddedWorkerInstanceClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!EmbeddedWorkerInstanceClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        EmbeddedWorkerInstanceClient_StartWorker_ParamsSpec.$,
        null,
        impl.startWorker.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        EmbeddedWorkerInstanceClient_StopWorker_ParamsSpec.$,
        null,
        impl.stopWorker.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class EmbeddedWorkerInstanceClient {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.EmbeddedWorkerInstanceClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!EmbeddedWorkerInstanceClientRemote}
   */
  static getRemote() {
    let remote = new EmbeddedWorkerInstanceClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the EmbeddedWorkerInstanceClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class EmbeddedWorkerInstanceClientCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      EmbeddedWorkerInstanceClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!EmbeddedWorkerInstanceClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.startWorker =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        EmbeddedWorkerInstanceClient_StartWorker_ParamsSpec.$,
        null,
        this.startWorker.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.stopWorker =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        EmbeddedWorkerInstanceClient_StopWorker_ParamsSpec.$,
        null,
        this.stopWorker.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class EmbeddedWorkerInstanceHostPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.EmbeddedWorkerInstanceHost', scope);
  }
}

/** @interface */
export class EmbeddedWorkerInstanceHostInterface {
  
  /**
   * @return {!Promise<{
        willBeTerminated: !boolean,
   *  }>}
   */

  requestTermination() {}
  
  /**
   * @param { !blink_mojom_WebFeature } feature
   */

  countFeature(feature) {}
  
  /**
   * @param { !blink_mojom_DevToolsAgentRemote } agent
   * @param { !blink_mojom_DevToolsAgentHostPendingReceiver } agentHost
   */

  onReadyForInspection(agent, agentHost) {}
  
  /**
   */

  onScriptLoaded() {}
  
  /**
   */

  onScriptEvaluationStart() {}
  
  /**
   * @param { !blink_mojom_ServiceWorkerStartStatus } status
   * @param { !blink_mojom_ServiceWorkerFetchHandlerType } fetchHandlerType
   * @param { !boolean } hasHidEventHandlers
   * @param { !boolean } hasUsbEventHandlers
   * @param { !number } threadId
   * @param { !EmbeddedWorkerStartTiming } startTiming
   */

  onStarted(status, fetchHandlerType, hasHidEventHandlers, hasUsbEventHandlers, threadId, startTiming) {}
  
  /**
   * @param { !mojoBase_mojom_String16 } errorMessage
   * @param { !number } lineNumber
   * @param { !number } columnNumber
   * @param { !url_mojom_Url } sourceUrl
   */

  onReportException(errorMessage, lineNumber, columnNumber, sourceUrl) {}
  
  /**
   * @param { !blink_mojom_ConsoleMessageSource } source
   * @param { !blink_mojom_ConsoleMessageLevel } messageLevel
   * @param { !mojoBase_mojom_String16 } message
   * @param { !number } lineNumber
   * @param { !url_mojom_Url } sourceUrl
   */

  onReportConsoleMessage(source, messageLevel, message, lineNumber, sourceUrl) {}
  
  /**
   */

  onStopped() {}
}

/**
 * @implements { EmbeddedWorkerInstanceHostInterface }
 */
export class EmbeddedWorkerInstanceHostRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!EmbeddedWorkerInstanceHostPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          EmbeddedWorkerInstanceHostPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!EmbeddedWorkerInstanceHostPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @return {!Promise<{
        willBeTerminated: !boolean,
   *  }>}
   */

  requestTermination() {
    return this.proxy.sendMessage(
        0,
        EmbeddedWorkerInstanceHost_RequestTermination_ParamsSpec.$,
        EmbeddedWorkerInstanceHost_RequestTermination_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !blink_mojom_WebFeature } feature
   */

  countFeature(
      feature) {
    this.proxy.sendMessage(
        1,
        EmbeddedWorkerInstanceHost_CountFeature_ParamsSpec.$,
        null,
        [
          feature
        ],
        false);
  }

  
  /**
   * @param { !blink_mojom_DevToolsAgentRemote } agent
   * @param { !blink_mojom_DevToolsAgentHostPendingReceiver } agentHost
   */

  onReadyForInspection(
      agent,
      agentHost) {
    this.proxy.sendMessage(
        2,
        EmbeddedWorkerInstanceHost_OnReadyForInspection_ParamsSpec.$,
        null,
        [
          agent,
          agentHost
        ],
        false);
  }

  
  /**
   */

  onScriptLoaded() {
    this.proxy.sendMessage(
        3,
        EmbeddedWorkerInstanceHost_OnScriptLoaded_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  onScriptEvaluationStart() {
    this.proxy.sendMessage(
        4,
        EmbeddedWorkerInstanceHost_OnScriptEvaluationStart_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !blink_mojom_ServiceWorkerStartStatus } status
   * @param { !blink_mojom_ServiceWorkerFetchHandlerType } fetchHandlerType
   * @param { !boolean } hasHidEventHandlers
   * @param { !boolean } hasUsbEventHandlers
   * @param { !number } threadId
   * @param { !EmbeddedWorkerStartTiming } startTiming
   */

  onStarted(
      status,
      fetchHandlerType,
      hasHidEventHandlers,
      hasUsbEventHandlers,
      threadId,
      startTiming) {
    this.proxy.sendMessage(
        5,
        EmbeddedWorkerInstanceHost_OnStarted_ParamsSpec.$,
        null,
        [
          status,
          fetchHandlerType,
          hasHidEventHandlers,
          hasUsbEventHandlers,
          threadId,
          startTiming
        ],
        false);
  }

  
  /**
   * @param { !mojoBase_mojom_String16 } errorMessage
   * @param { !number } lineNumber
   * @param { !number } columnNumber
   * @param { !url_mojom_Url } sourceUrl
   */

  onReportException(
      errorMessage,
      lineNumber,
      columnNumber,
      sourceUrl) {
    this.proxy.sendMessage(
        6,
        EmbeddedWorkerInstanceHost_OnReportException_ParamsSpec.$,
        null,
        [
          errorMessage,
          lineNumber,
          columnNumber,
          sourceUrl
        ],
        false);
  }

  
  /**
   * @param { !blink_mojom_ConsoleMessageSource } source
   * @param { !blink_mojom_ConsoleMessageLevel } messageLevel
   * @param { !mojoBase_mojom_String16 } message
   * @param { !number } lineNumber
   * @param { !url_mojom_Url } sourceUrl
   */

  onReportConsoleMessage(
      source,
      messageLevel,
      message,
      lineNumber,
      sourceUrl) {
    this.proxy.sendMessage(
        7,
        EmbeddedWorkerInstanceHost_OnReportConsoleMessage_ParamsSpec.$,
        null,
        [
          source,
          messageLevel,
          message,
          lineNumber,
          sourceUrl
        ],
        false);
  }

  
  /**
   */

  onStopped() {
    this.proxy.sendMessage(
        8,
        EmbeddedWorkerInstanceHost_OnStopped_ParamsSpec.$,
        null,
        [
        ],
        false);
  }
}

/**
 * An object which receives request messages for the EmbeddedWorkerInstanceHost
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class EmbeddedWorkerInstanceHostReceiver {
  /**
   * @param {!EmbeddedWorkerInstanceHostInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!EmbeddedWorkerInstanceHostRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        EmbeddedWorkerInstanceHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!EmbeddedWorkerInstanceHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        EmbeddedWorkerInstanceHost_RequestTermination_ParamsSpec.$,
        EmbeddedWorkerInstanceHost_RequestTermination_ResponseParamsSpec.$,
        impl.requestTermination.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        EmbeddedWorkerInstanceHost_CountFeature_ParamsSpec.$,
        null,
        impl.countFeature.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        EmbeddedWorkerInstanceHost_OnReadyForInspection_ParamsSpec.$,
        null,
        impl.onReadyForInspection.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        EmbeddedWorkerInstanceHost_OnScriptLoaded_ParamsSpec.$,
        null,
        impl.onScriptLoaded.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        EmbeddedWorkerInstanceHost_OnScriptEvaluationStart_ParamsSpec.$,
        null,
        impl.onScriptEvaluationStart.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        EmbeddedWorkerInstanceHost_OnStarted_ParamsSpec.$,
        null,
        impl.onStarted.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        EmbeddedWorkerInstanceHost_OnReportException_ParamsSpec.$,
        null,
        impl.onReportException.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        EmbeddedWorkerInstanceHost_OnReportConsoleMessage_ParamsSpec.$,
        null,
        impl.onReportConsoleMessage.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        EmbeddedWorkerInstanceHost_OnStopped_ParamsSpec.$,
        null,
        impl.onStopped.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class EmbeddedWorkerInstanceHost {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.EmbeddedWorkerInstanceHost";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!EmbeddedWorkerInstanceHostRemote}
   */
  static getRemote() {
    let remote = new EmbeddedWorkerInstanceHostRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the EmbeddedWorkerInstanceHost
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class EmbeddedWorkerInstanceHostCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      EmbeddedWorkerInstanceHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!EmbeddedWorkerInstanceHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.requestTermination =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        EmbeddedWorkerInstanceHost_RequestTermination_ParamsSpec.$,
        EmbeddedWorkerInstanceHost_RequestTermination_ResponseParamsSpec.$,
        this.requestTermination.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.countFeature =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        EmbeddedWorkerInstanceHost_CountFeature_ParamsSpec.$,
        null,
        this.countFeature.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onReadyForInspection =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        EmbeddedWorkerInstanceHost_OnReadyForInspection_ParamsSpec.$,
        null,
        this.onReadyForInspection.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onScriptLoaded =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        EmbeddedWorkerInstanceHost_OnScriptLoaded_ParamsSpec.$,
        null,
        this.onScriptLoaded.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onScriptEvaluationStart =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        EmbeddedWorkerInstanceHost_OnScriptEvaluationStart_ParamsSpec.$,
        null,
        this.onScriptEvaluationStart.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onStarted =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        EmbeddedWorkerInstanceHost_OnStarted_ParamsSpec.$,
        null,
        this.onStarted.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onReportException =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        EmbeddedWorkerInstanceHost_OnReportException_ParamsSpec.$,
        null,
        this.onReportException.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onReportConsoleMessage =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        EmbeddedWorkerInstanceHost_OnReportConsoleMessage_ParamsSpec.$,
        null,
        this.onReportConsoleMessage.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onStopped =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        EmbeddedWorkerInstanceHost_OnStopped_ParamsSpec.$,
        null,
        this.onStopped.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const EmbeddedWorkerStartParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const EmbeddedWorkerStartTimingSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const EmbeddedWorkerInstanceClient_StartWorker_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const EmbeddedWorkerInstanceClient_StopWorker_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const EmbeddedWorkerInstanceHost_RequestTermination_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const EmbeddedWorkerInstanceHost_RequestTermination_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const EmbeddedWorkerInstanceHost_CountFeature_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const EmbeddedWorkerInstanceHost_OnReadyForInspection_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const EmbeddedWorkerInstanceHost_OnScriptLoaded_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const EmbeddedWorkerInstanceHost_OnScriptEvaluationStart_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const EmbeddedWorkerInstanceHost_OnStarted_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const EmbeddedWorkerInstanceHost_OnReportException_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const EmbeddedWorkerInstanceHost_OnReportConsoleMessage_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const EmbeddedWorkerInstanceHost_OnStopped_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    EmbeddedWorkerStartParamsSpec.$,
    'EmbeddedWorkerStartParams',
    [
      mojo.internal.StructField(
        'serviceWorkerVersionId', 0,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'scope', 8,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'scriptUrl', 16,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'scriptType', 24,
        0,
        blink_mojom_ScriptTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'outsideFetchClientSettingsObject', 32,
        0,
        blink_mojom_FetchClientSettingsObjectSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'userAgent', 40,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'uaMetadata', 48,
        0,
        blink_mojom_UserAgentMetadataSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'serviceWorkerRouteId', 28,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'devtoolsWorkerToken', 56,
        0,
        mojoBase_mojom_UnguessableTokenSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'scriptUrlToSkipThrottling', 64,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'waitForDebugger', 72,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'isInstalled', 72,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'rendererPreferences', 80,
        0,
        blink_mojom_RendererPreferencesSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'forcedEnabledRuntimeFeatures', 88,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'serviceWorkerReceiver', 76,
        0,
        mojo.internal.InterfaceRequest(blink_mojom_ServiceWorkerPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'interfaceProvider', 96,
        0,
        mojo.internal.InterfaceRequest(serviceManager_mojom_InterfaceProviderPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'controllerReceiver', 100,
        0,
        mojo.internal.InterfaceRequest(blink_mojom_ControllerServiceWorkerPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'installedScriptsInfo', 104,
        0,
        blink_mojom_ServiceWorkerInstalledScriptsInfoSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'instanceHost', 112,
        0,
        mojo.internal.AssociatedInterfaceProxy(EmbeddedWorkerInstanceHostRemote),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'providerInfo', 120,
        0,
        blink_mojom_ServiceWorkerProviderInfoForStartWorkerSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'contentSettingsProxy', 128,
        0,
        mojo.internal.InterfaceProxy(blink_mojom_WorkerContentSettingsProxyRemote),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'preferenceWatcherReceiver', 136,
        0,
        mojo.internal.InterfaceRequest(blink_mojom_RendererPreferenceWatcherPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'subresourceLoaderFactories', 144,
        0,
        blink_mojom_URLLoaderFactoryBundleSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'subresourceLoaderUpdater', 140,
        0,
        mojo.internal.InterfaceRequest(blink_mojom_SubresourceLoaderUpdaterPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'serviceWorkerToken', 152,
        0,
        blink_mojom_ServiceWorkerTokenSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'ukmSourceId', 160,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'mainScriptLoadParams', 168,
        0,
        blink_mojom_WorkerMainScriptLoadParamsSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'policyContainer', 176,
        0,
        blink_mojom_PolicyContainerSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'storageKey', 184,
        0,
        blink_mojom_StorageKeySpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'corsExemptHeaderList', 192,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'coepReportingObserver', 200,
        0,
        mojo.internal.InterfaceRequest(blink_mojom_ReportingObserverPendingReceiver),
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'dipReportingObserver', 204,
        0,
        mojo.internal.InterfaceRequest(blink_mojom_ReportingObserverPendingReceiver),
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 216],]);



/**
 * @record
 */
export class EmbeddedWorkerStartParams {
  constructor() {
    /** @type { !bigint } */
    this.serviceWorkerVersionId;
    /** @type { !url_mojom_Url } */
    this.scope;
    /** @type { !url_mojom_Url } */
    this.scriptUrl;
    /** @type { !blink_mojom_ScriptType } */
    this.scriptType;
    /** @type { !blink_mojom_FetchClientSettingsObject } */
    this.outsideFetchClientSettingsObject;
    /** @type { !string } */
    this.userAgent;
    /** @type { !blink_mojom_UserAgentMetadata } */
    this.uaMetadata;
    /** @type { !number } */
    this.serviceWorkerRouteId;
    /** @type { !mojoBase_mojom_UnguessableToken } */
    this.devtoolsWorkerToken;
    /** @type { !url_mojom_Url } */
    this.scriptUrlToSkipThrottling;
    /** @type { !boolean } */
    this.waitForDebugger;
    /** @type { !boolean } */
    this.isInstalled;
    /** @type { !blink_mojom_RendererPreferences } */
    this.rendererPreferences;
    /** @type { !Array<!string> } */
    this.forcedEnabledRuntimeFeatures;
    /** @type { !blink_mojom_ServiceWorkerPendingReceiver } */
    this.serviceWorkerReceiver;
    /** @type { !serviceManager_mojom_InterfaceProviderPendingReceiver } */
    this.interfaceProvider;
    /** @type { !blink_mojom_ControllerServiceWorkerPendingReceiver } */
    this.controllerReceiver;
    /** @type { (blink_mojom_ServiceWorkerInstalledScriptsInfo|undefined) } */
    this.installedScriptsInfo;
    /** @type { !Object } */
    this.instanceHost;
    /** @type { !blink_mojom_ServiceWorkerProviderInfoForStartWorker } */
    this.providerInfo;
    /** @type { !blink_mojom_WorkerContentSettingsProxyRemote } */
    this.contentSettingsProxy;
    /** @type { !blink_mojom_RendererPreferenceWatcherPendingReceiver } */
    this.preferenceWatcherReceiver;
    /** @type { !blink_mojom_URLLoaderFactoryBundle } */
    this.subresourceLoaderFactories;
    /** @type { !blink_mojom_SubresourceLoaderUpdaterPendingReceiver } */
    this.subresourceLoaderUpdater;
    /** @type { !blink_mojom_ServiceWorkerToken } */
    this.serviceWorkerToken;
    /** @type { !bigint } */
    this.ukmSourceId;
    /** @type { (blink_mojom_WorkerMainScriptLoadParams|undefined) } */
    this.mainScriptLoadParams;
    /** @type { (blink_mojom_PolicyContainer|undefined) } */
    this.policyContainer;
    /** @type { !blink_mojom_StorageKey } */
    this.storageKey;
    /** @type { !Array<!string> } */
    this.corsExemptHeaderList;
    /** @type { (blink_mojom_ReportingObserverPendingReceiver|undefined) } */
    this.coepReportingObserver;
    /** @type { (blink_mojom_ReportingObserverPendingReceiver|undefined) } */
    this.dipReportingObserver;
  }
}



mojo.internal.Struct(
    EmbeddedWorkerStartTimingSpec.$,
    'EmbeddedWorkerStartTiming',
    [
      mojo.internal.StructField(
        'startWorkerReceivedTime', 0,
        0,
        mojoBase_mojom_TimeTicksSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'scriptEvaluationStartTime', 8,
        0,
        mojoBase_mojom_TimeTicksSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'scriptEvaluationEndTime', 16,
        0,
        mojoBase_mojom_TimeTicksSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class EmbeddedWorkerStartTiming {
  constructor() {
    /** @type { !mojoBase_mojom_TimeTicks } */
    this.startWorkerReceivedTime;
    /** @type { !mojoBase_mojom_TimeTicks } */
    this.scriptEvaluationStartTime;
    /** @type { !mojoBase_mojom_TimeTicks } */
    this.scriptEvaluationEndTime;
  }
}



mojo.internal.Struct(
    EmbeddedWorkerInstanceClient_StartWorker_ParamsSpec.$,
    'EmbeddedWorkerInstanceClient_StartWorker_Params',
    [
      mojo.internal.StructField(
        'params', 0,
        0,
        EmbeddedWorkerStartParamsSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class EmbeddedWorkerInstanceClient_StartWorker_Params {
  constructor() {
    /** @type { !EmbeddedWorkerStartParams } */
    this.params;
  }
}



mojo.internal.Struct(
    EmbeddedWorkerInstanceClient_StopWorker_ParamsSpec.$,
    'EmbeddedWorkerInstanceClient_StopWorker_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class EmbeddedWorkerInstanceClient_StopWorker_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    EmbeddedWorkerInstanceHost_RequestTermination_ParamsSpec.$,
    'EmbeddedWorkerInstanceHost_RequestTermination_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class EmbeddedWorkerInstanceHost_RequestTermination_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    EmbeddedWorkerInstanceHost_RequestTermination_ResponseParamsSpec.$,
    'EmbeddedWorkerInstanceHost_RequestTermination_ResponseParams',
    [
      mojo.internal.StructField(
        'willBeTerminated', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class EmbeddedWorkerInstanceHost_RequestTermination_ResponseParams {
  constructor() {
    /** @type { !boolean } */
    this.willBeTerminated;
  }
}



mojo.internal.Struct(
    EmbeddedWorkerInstanceHost_CountFeature_ParamsSpec.$,
    'EmbeddedWorkerInstanceHost_CountFeature_Params',
    [
      mojo.internal.StructField(
        'feature', 0,
        0,
        blink_mojom_WebFeatureSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class EmbeddedWorkerInstanceHost_CountFeature_Params {
  constructor() {
    /** @type { !blink_mojom_WebFeature } */
    this.feature;
  }
}



mojo.internal.Struct(
    EmbeddedWorkerInstanceHost_OnReadyForInspection_ParamsSpec.$,
    'EmbeddedWorkerInstanceHost_OnReadyForInspection_Params',
    [
      mojo.internal.StructField(
        'agent', 0,
        0,
        mojo.internal.InterfaceProxy(blink_mojom_DevToolsAgentRemote),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'agentHost', 8,
        0,
        mojo.internal.InterfaceRequest(blink_mojom_DevToolsAgentHostPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class EmbeddedWorkerInstanceHost_OnReadyForInspection_Params {
  constructor() {
    /** @type { !blink_mojom_DevToolsAgentRemote } */
    this.agent;
    /** @type { !blink_mojom_DevToolsAgentHostPendingReceiver } */
    this.agentHost;
  }
}



mojo.internal.Struct(
    EmbeddedWorkerInstanceHost_OnScriptLoaded_ParamsSpec.$,
    'EmbeddedWorkerInstanceHost_OnScriptLoaded_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class EmbeddedWorkerInstanceHost_OnScriptLoaded_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    EmbeddedWorkerInstanceHost_OnScriptEvaluationStart_ParamsSpec.$,
    'EmbeddedWorkerInstanceHost_OnScriptEvaluationStart_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class EmbeddedWorkerInstanceHost_OnScriptEvaluationStart_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    EmbeddedWorkerInstanceHost_OnStarted_ParamsSpec.$,
    'EmbeddedWorkerInstanceHost_OnStarted_Params',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        blink_mojom_ServiceWorkerStartStatusSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'fetchHandlerType', 4,
        0,
        blink_mojom_ServiceWorkerFetchHandlerTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'hasHidEventHandlers', 8,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'hasUsbEventHandlers', 8,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'threadId', 12,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'startTiming', 16,
        0,
        EmbeddedWorkerStartTimingSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class EmbeddedWorkerInstanceHost_OnStarted_Params {
  constructor() {
    /** @type { !blink_mojom_ServiceWorkerStartStatus } */
    this.status;
    /** @type { !blink_mojom_ServiceWorkerFetchHandlerType } */
    this.fetchHandlerType;
    /** @type { !boolean } */
    this.hasHidEventHandlers;
    /** @type { !boolean } */
    this.hasUsbEventHandlers;
    /** @type { !number } */
    this.threadId;
    /** @type { !EmbeddedWorkerStartTiming } */
    this.startTiming;
  }
}



mojo.internal.Struct(
    EmbeddedWorkerInstanceHost_OnReportException_ParamsSpec.$,
    'EmbeddedWorkerInstanceHost_OnReportException_Params',
    [
      mojo.internal.StructField(
        'errorMessage', 0,
        0,
        mojoBase_mojom_String16Spec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'lineNumber', 8,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'columnNumber', 12,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'sourceUrl', 16,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class EmbeddedWorkerInstanceHost_OnReportException_Params {
  constructor() {
    /** @type { !mojoBase_mojom_String16 } */
    this.errorMessage;
    /** @type { !number } */
    this.lineNumber;
    /** @type { !number } */
    this.columnNumber;
    /** @type { !url_mojom_Url } */
    this.sourceUrl;
  }
}



mojo.internal.Struct(
    EmbeddedWorkerInstanceHost_OnReportConsoleMessage_ParamsSpec.$,
    'EmbeddedWorkerInstanceHost_OnReportConsoleMessage_Params',
    [
      mojo.internal.StructField(
        'source', 0,
        0,
        blink_mojom_ConsoleMessageSourceSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'messageLevel', 4,
        0,
        blink_mojom_ConsoleMessageLevelSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'message', 8,
        0,
        mojoBase_mojom_String16Spec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'lineNumber', 16,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'sourceUrl', 24,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class EmbeddedWorkerInstanceHost_OnReportConsoleMessage_Params {
  constructor() {
    /** @type { !blink_mojom_ConsoleMessageSource } */
    this.source;
    /** @type { !blink_mojom_ConsoleMessageLevel } */
    this.messageLevel;
    /** @type { !mojoBase_mojom_String16 } */
    this.message;
    /** @type { !number } */
    this.lineNumber;
    /** @type { !url_mojom_Url } */
    this.sourceUrl;
  }
}



mojo.internal.Struct(
    EmbeddedWorkerInstanceHost_OnStopped_ParamsSpec.$,
    'EmbeddedWorkerInstanceHost_OnStopped_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class EmbeddedWorkerInstanceHost_OnStopped_Params {
  constructor() {
  }
}

