// third_party/blink/public/mojom/service_worker/embedded_worker.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/service_worker/embedded_worker.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/service_worker/embedded_worker.mojom-params-data.h"
#include "third_party/blink/public/mojom/service_worker/embedded_worker.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/service_worker/embedded_worker.mojom-import-headers.h"
#include "third_party/blink/public/mojom/service_worker/embedded_worker.mojom-test-utils.h"
#include "components/content_settings/core/common/content_settings_param_traits.h"
#include "net/cert/cert_verify_result.h"


namespace blink::mojom {
EmbeddedWorkerStartParams::EmbeddedWorkerStartParams()
    : service_worker_version_id(),
      scope(),
      script_url(),
      script_type(),
      outside_fetch_client_settings_object(),
      user_agent(),
      ua_metadata(),
      service_worker_route_id(),
      devtools_worker_token(),
      script_url_to_skip_throttling(),
      wait_for_debugger(),
      is_installed(),
      renderer_preferences(),
      forced_enabled_runtime_features(),
      service_worker_receiver(),
      interface_provider(),
      controller_receiver(),
      installed_scripts_info(),
      instance_host(),
      provider_info(),
      content_settings_proxy(),
      preference_watcher_receiver(),
      subresource_loader_factories(),
      subresource_loader_updater(),
      service_worker_token(),
      ukm_source_id(),
      main_script_load_params(),
      policy_container(),
      storage_key(),
      cors_exempt_header_list(),
      coep_reporting_observer(),
      dip_reporting_observer() {}

EmbeddedWorkerStartParams::EmbeddedWorkerStartParams(
    int64_t service_worker_version_id_in,
    const ::GURL& scope_in,
    const ::GURL& script_url_in,
    ::blink::mojom::ScriptType script_type_in,
    ::blink::mojom::FetchClientSettingsObjectPtr outside_fetch_client_settings_object_in,
    const std::string& user_agent_in,
    const ::blink::UserAgentMetadata& ua_metadata_in,
    int32_t service_worker_route_id_in,
    const ::base::UnguessableToken& devtools_worker_token_in,
    const ::GURL& script_url_to_skip_throttling_in,
    bool wait_for_debugger_in,
    bool is_installed_in,
    const ::blink::RendererPreferences& renderer_preferences_in,
    std::vector<std::string> forced_enabled_runtime_features_in,
    ::mojo::PendingReceiver<::blink::mojom::ServiceWorker> service_worker_receiver_in,
    ::mojo::PendingReceiver<::service_manager::mojom::InterfaceProvider> interface_provider_in,
    ::mojo::PendingReceiver<::blink::mojom::ControllerServiceWorker> controller_receiver_in,
    ::blink::mojom::ServiceWorkerInstalledScriptsInfoPtr installed_scripts_info_in,
    ::mojo::PendingAssociatedRemote<EmbeddedWorkerInstanceHost> instance_host_in,
    ::blink::mojom::ServiceWorkerProviderInfoForStartWorkerPtr provider_info_in,
    ::mojo::PendingRemote<::blink::mojom::WorkerContentSettingsProxy> content_settings_proxy_in,
    ::mojo::PendingReceiver<::blink::mojom::RendererPreferenceWatcher> preference_watcher_receiver_in,
    ::std::unique_ptr<::blink::PendingURLLoaderFactoryBundle> subresource_loader_factories_in,
    ::mojo::PendingReceiver<::blink::mojom::SubresourceLoaderUpdater> subresource_loader_updater_in,
    const ::blink::ServiceWorkerToken& service_worker_token_in,
    int64_t ukm_source_id_in,
    ::blink::mojom::WorkerMainScriptLoadParamsPtr main_script_load_params_in,
    ::blink::mojom::PolicyContainerPtr policy_container_in,
    const ::blink::StorageKey& storage_key_in,
    std::vector<std::string> cors_exempt_header_list_in,
    ::mojo::PendingReceiver<::blink::mojom::ReportingObserver> coep_reporting_observer_in,
    ::mojo::PendingReceiver<::blink::mojom::ReportingObserver> dip_reporting_observer_in)
    : service_worker_version_id(std::move(service_worker_version_id_in)),
      scope(std::move(scope_in)),
      script_url(std::move(script_url_in)),
      script_type(std::move(script_type_in)),
      outside_fetch_client_settings_object(std::move(outside_fetch_client_settings_object_in)),
      user_agent(std::move(user_agent_in)),
      ua_metadata(std::move(ua_metadata_in)),
      service_worker_route_id(std::move(service_worker_route_id_in)),
      devtools_worker_token(std::move(devtools_worker_token_in)),
      script_url_to_skip_throttling(std::move(script_url_to_skip_throttling_in)),
      wait_for_debugger(std::move(wait_for_debugger_in)),
      is_installed(std::move(is_installed_in)),
      renderer_preferences(std::move(renderer_preferences_in)),
      forced_enabled_runtime_features(std::move(forced_enabled_runtime_features_in)),
      service_worker_receiver(std::move(service_worker_receiver_in)),
      interface_provider(std::move(interface_provider_in)),
      controller_receiver(std::move(controller_receiver_in)),
      installed_scripts_info(std::move(installed_scripts_info_in)),
      instance_host(std::move(instance_host_in)),
      provider_info(std::move(provider_info_in)),
      content_settings_proxy(std::move(content_settings_proxy_in)),
      preference_watcher_receiver(std::move(preference_watcher_receiver_in)),
      subresource_loader_factories(std::move(subresource_loader_factories_in)),
      subresource_loader_updater(std::move(subresource_loader_updater_in)),
      service_worker_token(std::move(service_worker_token_in)),
      ukm_source_id(std::move(ukm_source_id_in)),
      main_script_load_params(std::move(main_script_load_params_in)),
      policy_container(std::move(policy_container_in)),
      storage_key(std::move(storage_key_in)),
      cors_exempt_header_list(std::move(cors_exempt_header_list_in)),
      coep_reporting_observer(std::move(coep_reporting_observer_in)),
      dip_reporting_observer(std::move(dip_reporting_observer_in)) {}

EmbeddedWorkerStartParams::~EmbeddedWorkerStartParams() = default;

void EmbeddedWorkerStartParams::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "service_worker_version_id"), this->service_worker_version_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "scope"), this->scope,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "script_url"), this->script_url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "script_type"), this->script_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::mojom::ScriptType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "outside_fetch_client_settings_object"), this->outside_fetch_client_settings_object,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::mojom::FetchClientSettingsObjectPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "user_agent"), this->user_agent,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "ua_metadata"), this->ua_metadata,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::UserAgentMetadata&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "service_worker_route_id"), this->service_worker_route_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "devtools_worker_token"), this->devtools_worker_token,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::base::UnguessableToken&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "script_url_to_skip_throttling"), this->script_url_to_skip_throttling,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "wait_for_debugger"), this->wait_for_debugger,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_installed"), this->is_installed,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "renderer_preferences"), this->renderer_preferences,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::RendererPreferences&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "forced_enabled_runtime_features"), this->forced_enabled_runtime_features,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "service_worker_receiver"), this->service_worker_receiver,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingReceiver<::blink::mojom::ServiceWorker>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "interface_provider"), this->interface_provider,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingReceiver<::service_manager::mojom::InterfaceProvider>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "controller_receiver"), this->controller_receiver,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingReceiver<::blink::mojom::ControllerServiceWorker>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "installed_scripts_info"), this->installed_scripts_info,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::mojom::ServiceWorkerInstalledScriptsInfoPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "instance_host"), this->instance_host,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingAssociatedRemote<EmbeddedWorkerInstanceHost>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "provider_info"), this->provider_info,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::mojom::ServiceWorkerProviderInfoForStartWorkerPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "content_settings_proxy"), this->content_settings_proxy,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingRemote<::blink::mojom::WorkerContentSettingsProxy>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "preference_watcher_receiver"), this->preference_watcher_receiver,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingReceiver<::blink::mojom::RendererPreferenceWatcher>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "subresource_loader_factories"), this->subresource_loader_factories,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::std::unique_ptr<::blink::PendingURLLoaderFactoryBundle>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "subresource_loader_updater"), this->subresource_loader_updater,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingReceiver<::blink::mojom::SubresourceLoaderUpdater>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "service_worker_token"), this->service_worker_token,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::ServiceWorkerToken&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "ukm_source_id"), this->ukm_source_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "main_script_load_params"), this->main_script_load_params,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::mojom::WorkerMainScriptLoadParamsPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "policy_container"), this->policy_container,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::mojom::PolicyContainerPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "storage_key"), this->storage_key,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::StorageKey&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "cors_exempt_header_list"), this->cors_exempt_header_list,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "coep_reporting_observer"), this->coep_reporting_observer,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingReceiver<::blink::mojom::ReportingObserver>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "dip_reporting_observer"), this->dip_reporting_observer,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingReceiver<::blink::mojom::ReportingObserver>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool EmbeddedWorkerStartParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
EmbeddedWorkerStartTiming::EmbeddedWorkerStartTiming()
    : start_worker_received_time(),
      script_evaluation_start_time(),
      script_evaluation_end_time() {}

EmbeddedWorkerStartTiming::EmbeddedWorkerStartTiming(
    ::base::TimeTicks start_worker_received_time_in,
    ::base::TimeTicks script_evaluation_start_time_in,
    ::base::TimeTicks script_evaluation_end_time_in)
    : start_worker_received_time(std::move(start_worker_received_time_in)),
      script_evaluation_start_time(std::move(script_evaluation_start_time_in)),
      script_evaluation_end_time(std::move(script_evaluation_end_time_in)) {}

EmbeddedWorkerStartTiming::~EmbeddedWorkerStartTiming() = default;

void EmbeddedWorkerStartTiming::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "start_worker_received_time"), this->start_worker_received_time,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeTicks>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "script_evaluation_start_time"), this->script_evaluation_start_time,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeTicks>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "script_evaluation_end_time"), this->script_evaluation_end_time,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeTicks>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool EmbeddedWorkerStartTiming::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

EmbeddedWorkerInstanceClient::IPCStableHashFunction EmbeddedWorkerInstanceClient::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::EmbeddedWorkerInstanceClient>(message.name())) {
    case messages::EmbeddedWorkerInstanceClient::kStartWorker: {
      return &EmbeddedWorkerInstanceClient::StartWorker_Sym::IPCStableHash;
    }
    case messages::EmbeddedWorkerInstanceClient::kStopWorker: {
      return &EmbeddedWorkerInstanceClient::StopWorker_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* EmbeddedWorkerInstanceClient::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::EmbeddedWorkerInstanceClient>(message.name())) {
      case messages::EmbeddedWorkerInstanceClient::kStartWorker:
            return "Receive blink::mojom::EmbeddedWorkerInstanceClient::StartWorker";
      case messages::EmbeddedWorkerInstanceClient::kStopWorker:
            return "Receive blink::mojom::EmbeddedWorkerInstanceClient::StopWorker";
    }
  } else {
    switch (static_cast<messages::EmbeddedWorkerInstanceClient>(message.name())) {
      case messages::EmbeddedWorkerInstanceClient::kStartWorker:
            return "Receive reply blink::mojom::EmbeddedWorkerInstanceClient::StartWorker";
      case messages::EmbeddedWorkerInstanceClient::kStopWorker:
            return "Receive reply blink::mojom::EmbeddedWorkerInstanceClient::StopWorker";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t EmbeddedWorkerInstanceClient::StartWorker_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa0d21f75;  // IPCStableHash for blink::mojom::EmbeddedWorkerInstanceClient::StartWorker
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t EmbeddedWorkerInstanceClient::StopWorker_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x503758a0;  // IPCStableHash for blink::mojom::EmbeddedWorkerInstanceClient::StopWorker
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

EmbeddedWorkerInstanceClientProxy::EmbeddedWorkerInstanceClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void EmbeddedWorkerInstanceClientProxy::StartWorker(
    EmbeddedWorkerStartParamsPtr in_params) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::EmbeddedWorkerInstanceClient::StartWorker", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("params"), in_params,
                        "<value of type EmbeddedWorkerStartParamsPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::EmbeddedWorkerInstanceClient::kStartWorker), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::EmbeddedWorkerInstanceClient_StartWorker_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->params)::BaseType> params_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::EmbeddedWorkerStartParamsDataView>(
    in_params,
    params_fragment);

  params->params.Set(
      params_fragment.is_null() ? nullptr : params_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->params.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null params in EmbeddedWorkerInstanceClient.StartWorker request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(EmbeddedWorkerInstanceClient::Name_);
  message.set_method_name("StartWorker");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void EmbeddedWorkerInstanceClientProxy::StopWorker(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::EmbeddedWorkerInstanceClient::StopWorker");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::EmbeddedWorkerInstanceClient::kStopWorker), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::EmbeddedWorkerInstanceClient_StopWorker_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(EmbeddedWorkerInstanceClient::Name_);
  message.set_method_name("StopWorker");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool EmbeddedWorkerInstanceClientStubDispatch::Accept(
    EmbeddedWorkerInstanceClient* impl,
    mojo::Message* message) {
  switch (static_cast<messages::EmbeddedWorkerInstanceClient>(message->header()->name)) {
    case messages::EmbeddedWorkerInstanceClient::kStartWorker: {
      DCHECK(message->is_serialized());
      internal::EmbeddedWorkerInstanceClient_StartWorker_Params_Data* params =
          reinterpret_cast<internal::EmbeddedWorkerInstanceClient_StartWorker_Params_Data*>(
              message->mutable_payload());
      

      // Validation for EmbeddedWorkerInstanceClient.0
      bool success = true;
      EmbeddedWorkerStartParamsPtr p_params{};
      EmbeddedWorkerInstanceClient_StartWorker_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadParams(&p_params))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            EmbeddedWorkerInstanceClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->StartWorker(        
        std::move(p_params));
      return true;
    }
    case messages::EmbeddedWorkerInstanceClient::kStopWorker: {
      DCHECK(message->is_serialized());
      internal::EmbeddedWorkerInstanceClient_StopWorker_Params_Data* params =
          reinterpret_cast<internal::EmbeddedWorkerInstanceClient_StopWorker_Params_Data*>(
              message->mutable_payload());
      

      // Validation for EmbeddedWorkerInstanceClient.1
      bool success = true;
      EmbeddedWorkerInstanceClient_StopWorker_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            EmbeddedWorkerInstanceClient::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->StopWorker(        );
      return true;
    }
  }
  return false;
}

// static
bool EmbeddedWorkerInstanceClientStubDispatch::AcceptWithResponder(
    EmbeddedWorkerInstanceClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::EmbeddedWorkerInstanceClient>(message->header()->name)) {
    case messages::EmbeddedWorkerInstanceClient::kStartWorker: {
      break;
    }
    case messages::EmbeddedWorkerInstanceClient::kStopWorker: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kEmbeddedWorkerInstanceClientValidationInfo[] = {
    { &internal::EmbeddedWorkerInstanceClient_StartWorker_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::EmbeddedWorkerInstanceClient_StopWorker_Params_Data::Validate,
     nullptr /* no response */},
};

bool EmbeddedWorkerInstanceClientRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::EmbeddedWorkerInstanceClient::Name_,
    kEmbeddedWorkerInstanceClientValidationInfo);
}

// The declaration includes the definition on other builds.

EmbeddedWorkerInstanceHost::IPCStableHashFunction EmbeddedWorkerInstanceHost::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::EmbeddedWorkerInstanceHost>(message.name())) {
    case messages::EmbeddedWorkerInstanceHost::kRequestTermination: {
      return &EmbeddedWorkerInstanceHost::RequestTermination_Sym::IPCStableHash;
    }
    case messages::EmbeddedWorkerInstanceHost::kCountFeature: {
      return &EmbeddedWorkerInstanceHost::CountFeature_Sym::IPCStableHash;
    }
    case messages::EmbeddedWorkerInstanceHost::kOnReadyForInspection: {
      return &EmbeddedWorkerInstanceHost::OnReadyForInspection_Sym::IPCStableHash;
    }
    case messages::EmbeddedWorkerInstanceHost::kOnScriptLoaded: {
      return &EmbeddedWorkerInstanceHost::OnScriptLoaded_Sym::IPCStableHash;
    }
    case messages::EmbeddedWorkerInstanceHost::kOnScriptEvaluationStart: {
      return &EmbeddedWorkerInstanceHost::OnScriptEvaluationStart_Sym::IPCStableHash;
    }
    case messages::EmbeddedWorkerInstanceHost::kOnStarted: {
      return &EmbeddedWorkerInstanceHost::OnStarted_Sym::IPCStableHash;
    }
    case messages::EmbeddedWorkerInstanceHost::kOnReportException: {
      return &EmbeddedWorkerInstanceHost::OnReportException_Sym::IPCStableHash;
    }
    case messages::EmbeddedWorkerInstanceHost::kOnReportConsoleMessage: {
      return &EmbeddedWorkerInstanceHost::OnReportConsoleMessage_Sym::IPCStableHash;
    }
    case messages::EmbeddedWorkerInstanceHost::kOnStopped: {
      return &EmbeddedWorkerInstanceHost::OnStopped_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* EmbeddedWorkerInstanceHost::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::EmbeddedWorkerInstanceHost>(message.name())) {
      case messages::EmbeddedWorkerInstanceHost::kRequestTermination:
            return "Receive blink::mojom::EmbeddedWorkerInstanceHost::RequestTermination";
      case messages::EmbeddedWorkerInstanceHost::kCountFeature:
            return "Receive blink::mojom::EmbeddedWorkerInstanceHost::CountFeature";
      case messages::EmbeddedWorkerInstanceHost::kOnReadyForInspection:
            return "Receive blink::mojom::EmbeddedWorkerInstanceHost::OnReadyForInspection";
      case messages::EmbeddedWorkerInstanceHost::kOnScriptLoaded:
            return "Receive blink::mojom::EmbeddedWorkerInstanceHost::OnScriptLoaded";
      case messages::EmbeddedWorkerInstanceHost::kOnScriptEvaluationStart:
            return "Receive blink::mojom::EmbeddedWorkerInstanceHost::OnScriptEvaluationStart";
      case messages::EmbeddedWorkerInstanceHost::kOnStarted:
            return "Receive blink::mojom::EmbeddedWorkerInstanceHost::OnStarted";
      case messages::EmbeddedWorkerInstanceHost::kOnReportException:
            return "Receive blink::mojom::EmbeddedWorkerInstanceHost::OnReportException";
      case messages::EmbeddedWorkerInstanceHost::kOnReportConsoleMessage:
            return "Receive blink::mojom::EmbeddedWorkerInstanceHost::OnReportConsoleMessage";
      case messages::EmbeddedWorkerInstanceHost::kOnStopped:
            return "Receive blink::mojom::EmbeddedWorkerInstanceHost::OnStopped";
    }
  } else {
    switch (static_cast<messages::EmbeddedWorkerInstanceHost>(message.name())) {
      case messages::EmbeddedWorkerInstanceHost::kRequestTermination:
            return "Receive reply blink::mojom::EmbeddedWorkerInstanceHost::RequestTermination";
      case messages::EmbeddedWorkerInstanceHost::kCountFeature:
            return "Receive reply blink::mojom::EmbeddedWorkerInstanceHost::CountFeature";
      case messages::EmbeddedWorkerInstanceHost::kOnReadyForInspection:
            return "Receive reply blink::mojom::EmbeddedWorkerInstanceHost::OnReadyForInspection";
      case messages::EmbeddedWorkerInstanceHost::kOnScriptLoaded:
            return "Receive reply blink::mojom::EmbeddedWorkerInstanceHost::OnScriptLoaded";
      case messages::EmbeddedWorkerInstanceHost::kOnScriptEvaluationStart:
            return "Receive reply blink::mojom::EmbeddedWorkerInstanceHost::OnScriptEvaluationStart";
      case messages::EmbeddedWorkerInstanceHost::kOnStarted:
            return "Receive reply blink::mojom::EmbeddedWorkerInstanceHost::OnStarted";
      case messages::EmbeddedWorkerInstanceHost::kOnReportException:
            return "Receive reply blink::mojom::EmbeddedWorkerInstanceHost::OnReportException";
      case messages::EmbeddedWorkerInstanceHost::kOnReportConsoleMessage:
            return "Receive reply blink::mojom::EmbeddedWorkerInstanceHost::OnReportConsoleMessage";
      case messages::EmbeddedWorkerInstanceHost::kOnStopped:
            return "Receive reply blink::mojom::EmbeddedWorkerInstanceHost::OnStopped";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t EmbeddedWorkerInstanceHost::RequestTermination_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa9ee6374;  // IPCStableHash for blink::mojom::EmbeddedWorkerInstanceHost::RequestTermination
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t EmbeddedWorkerInstanceHost::CountFeature_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x44291724;  // IPCStableHash for blink::mojom::EmbeddedWorkerInstanceHost::CountFeature
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t EmbeddedWorkerInstanceHost::OnReadyForInspection_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xede789ad;  // IPCStableHash for blink::mojom::EmbeddedWorkerInstanceHost::OnReadyForInspection
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t EmbeddedWorkerInstanceHost::OnScriptLoaded_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa7c943b6;  // IPCStableHash for blink::mojom::EmbeddedWorkerInstanceHost::OnScriptLoaded
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t EmbeddedWorkerInstanceHost::OnScriptEvaluationStart_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x39e34e56;  // IPCStableHash for blink::mojom::EmbeddedWorkerInstanceHost::OnScriptEvaluationStart
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t EmbeddedWorkerInstanceHost::OnStarted_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xaed3fe7e;  // IPCStableHash for blink::mojom::EmbeddedWorkerInstanceHost::OnStarted
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t EmbeddedWorkerInstanceHost::OnReportException_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc2d20023;  // IPCStableHash for blink::mojom::EmbeddedWorkerInstanceHost::OnReportException
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t EmbeddedWorkerInstanceHost::OnReportConsoleMessage_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x42b0e1fe;  // IPCStableHash for blink::mojom::EmbeddedWorkerInstanceHost::OnReportConsoleMessage
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t EmbeddedWorkerInstanceHost::OnStopped_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc4c6e3e2;  // IPCStableHash for blink::mojom::EmbeddedWorkerInstanceHost::OnStopped
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class EmbeddedWorkerInstanceHost_RequestTermination_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  EmbeddedWorkerInstanceHost_RequestTermination_ForwardToCallback(
      EmbeddedWorkerInstanceHost::RequestTerminationCallback callback
      ) : callback_(std::move(callback)) {
  }

  EmbeddedWorkerInstanceHost_RequestTermination_ForwardToCallback(const EmbeddedWorkerInstanceHost_RequestTermination_ForwardToCallback&) = delete;
  EmbeddedWorkerInstanceHost_RequestTermination_ForwardToCallback& operator=(const EmbeddedWorkerInstanceHost_RequestTermination_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  EmbeddedWorkerInstanceHost::RequestTerminationCallback callback_;
};

EmbeddedWorkerInstanceHostProxy::EmbeddedWorkerInstanceHostProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void EmbeddedWorkerInstanceHostProxy::RequestTermination(
    RequestTerminationCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::EmbeddedWorkerInstanceHost::RequestTermination");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::EmbeddedWorkerInstanceHost::kRequestTermination), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::EmbeddedWorkerInstanceHost_RequestTermination_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(EmbeddedWorkerInstanceHost::Name_);
  message.set_method_name("RequestTermination");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new EmbeddedWorkerInstanceHost_RequestTermination_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void EmbeddedWorkerInstanceHostProxy::CountFeature(
    ::blink::mojom::WebFeature in_feature) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::EmbeddedWorkerInstanceHost::CountFeature", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("feature"), in_feature,
                        "<value of type ::blink::mojom::WebFeature>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::EmbeddedWorkerInstanceHost::kCountFeature), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::EmbeddedWorkerInstanceHost_CountFeature_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::WebFeature>(
    in_feature,
    &params->feature);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(EmbeddedWorkerInstanceHost::Name_);
  message.set_method_name("CountFeature");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void EmbeddedWorkerInstanceHostProxy::OnReadyForInspection(
    ::mojo::PendingRemote<::blink::mojom::DevToolsAgent> in_agent, ::mojo::PendingReceiver<::blink::mojom::DevToolsAgentHost> in_agent_host) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::EmbeddedWorkerInstanceHost::OnReadyForInspection", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("agent"), in_agent,
                        "<value of type ::mojo::PendingRemote<::blink::mojom::DevToolsAgent>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("agent_host"), in_agent_host,
                        "<value of type ::mojo::PendingReceiver<::blink::mojom::DevToolsAgentHost>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::EmbeddedWorkerInstanceHost::kOnReadyForInspection), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::EmbeddedWorkerInstanceHost_OnReadyForInspection_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::DevToolsAgentInterfaceBase>>(
    in_agent,
    &params->agent,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->agent)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid agent in EmbeddedWorkerInstanceHost.OnReadyForInspection request");

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::blink::mojom::DevToolsAgentHostInterfaceBase>>(
    in_agent_host,
    &params->agent_host,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->agent_host)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid agent_host in EmbeddedWorkerInstanceHost.OnReadyForInspection request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(EmbeddedWorkerInstanceHost::Name_);
  message.set_method_name("OnReadyForInspection");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void EmbeddedWorkerInstanceHostProxy::OnScriptLoaded(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::EmbeddedWorkerInstanceHost::OnScriptLoaded");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::EmbeddedWorkerInstanceHost::kOnScriptLoaded), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::EmbeddedWorkerInstanceHost_OnScriptLoaded_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(EmbeddedWorkerInstanceHost::Name_);
  message.set_method_name("OnScriptLoaded");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void EmbeddedWorkerInstanceHostProxy::OnScriptEvaluationStart(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::EmbeddedWorkerInstanceHost::OnScriptEvaluationStart");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::EmbeddedWorkerInstanceHost::kOnScriptEvaluationStart), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::EmbeddedWorkerInstanceHost_OnScriptEvaluationStart_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(EmbeddedWorkerInstanceHost::Name_);
  message.set_method_name("OnScriptEvaluationStart");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void EmbeddedWorkerInstanceHostProxy::OnStarted(
    ::blink::mojom::ServiceWorkerStartStatus in_status, ::blink::mojom::ServiceWorkerFetchHandlerType in_fetch_handler_type, bool in_has_hid_event_handlers, bool in_has_usb_event_handlers, int32_t in_thread_id, EmbeddedWorkerStartTimingPtr in_start_timing) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::EmbeddedWorkerInstanceHost::OnStarted", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type ::blink::mojom::ServiceWorkerStartStatus>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("fetch_handler_type"), in_fetch_handler_type,
                        "<value of type ::blink::mojom::ServiceWorkerFetchHandlerType>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("has_hid_event_handlers"), in_has_hid_event_handlers,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("has_usb_event_handlers"), in_has_usb_event_handlers,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("thread_id"), in_thread_id,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("start_timing"), in_start_timing,
                        "<value of type EmbeddedWorkerStartTimingPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::EmbeddedWorkerInstanceHost::kOnStarted), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::EmbeddedWorkerInstanceHost_OnStarted_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::ServiceWorkerStartStatus>(
    in_status,
    &params->status);

  
  mojo::internal::Serialize<::blink::mojom::ServiceWorkerFetchHandlerType>(
    in_fetch_handler_type,
    &params->fetch_handler_type);

  params->has_hid_event_handlers = in_has_hid_event_handlers;

  params->has_usb_event_handlers = in_has_usb_event_handlers;

  params->thread_id = in_thread_id;
  mojo::internal::MessageFragment<
      typename decltype(params->start_timing)::BaseType> start_timing_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::EmbeddedWorkerStartTimingDataView>(
    in_start_timing,
    start_timing_fragment);

  params->start_timing.Set(
      start_timing_fragment.is_null() ? nullptr : start_timing_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->start_timing.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null start_timing in EmbeddedWorkerInstanceHost.OnStarted request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(EmbeddedWorkerInstanceHost::Name_);
  message.set_method_name("OnStarted");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void EmbeddedWorkerInstanceHostProxy::OnReportException(
    const ::std::u16string& in_error_message, int32_t in_line_number, int32_t in_column_number, const ::GURL& in_source_url) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::EmbeddedWorkerInstanceHost::OnReportException", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error_message"), in_error_message,
                        "<value of type const ::std::u16string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("line_number"), in_line_number,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("column_number"), in_column_number,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("source_url"), in_source_url,
                        "<value of type const ::GURL&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::EmbeddedWorkerInstanceHost::kOnReportException), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::EmbeddedWorkerInstanceHost_OnReportException_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->error_message)::BaseType> error_message_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
    in_error_message,
    error_message_fragment);

  params->error_message.Set(
      error_message_fragment.is_null() ? nullptr : error_message_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->error_message.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null error_message in EmbeddedWorkerInstanceHost.OnReportException request");

  params->line_number = in_line_number;

  params->column_number = in_column_number;
  mojo::internal::MessageFragment<
      typename decltype(params->source_url)::BaseType> source_url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_source_url,
    source_url_fragment);

  params->source_url.Set(
      source_url_fragment.is_null() ? nullptr : source_url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->source_url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null source_url in EmbeddedWorkerInstanceHost.OnReportException request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(EmbeddedWorkerInstanceHost::Name_);
  message.set_method_name("OnReportException");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void EmbeddedWorkerInstanceHostProxy::OnReportConsoleMessage(
    ::blink::mojom::ConsoleMessageSource in_source, ::blink::mojom::ConsoleMessageLevel in_message_level, const ::std::u16string& in_message, int32_t in_line_number, const ::GURL& in_source_url) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::EmbeddedWorkerInstanceHost::OnReportConsoleMessage", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("source"), in_source,
                        "<value of type ::blink::mojom::ConsoleMessageSource>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("message_level"), in_message_level,
                        "<value of type ::blink::mojom::ConsoleMessageLevel>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("message"), in_message,
                        "<value of type const ::std::u16string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("line_number"), in_line_number,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("source_url"), in_source_url,
                        "<value of type const ::GURL&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::EmbeddedWorkerInstanceHost::kOnReportConsoleMessage), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::EmbeddedWorkerInstanceHost_OnReportConsoleMessage_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::ConsoleMessageSource>(
    in_source,
    &params->source);

  
  mojo::internal::Serialize<::blink::mojom::ConsoleMessageLevel>(
    in_message_level,
    &params->message_level);
  mojo::internal::MessageFragment<
      typename decltype(params->message)::BaseType> message_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
    in_message,
    message_fragment);

  params->message.Set(
      message_fragment.is_null() ? nullptr : message_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->message.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null message in EmbeddedWorkerInstanceHost.OnReportConsoleMessage request");

  params->line_number = in_line_number;
  mojo::internal::MessageFragment<
      typename decltype(params->source_url)::BaseType> source_url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_source_url,
    source_url_fragment);

  params->source_url.Set(
      source_url_fragment.is_null() ? nullptr : source_url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->source_url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null source_url in EmbeddedWorkerInstanceHost.OnReportConsoleMessage request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(EmbeddedWorkerInstanceHost::Name_);
  message.set_method_name("OnReportConsoleMessage");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void EmbeddedWorkerInstanceHostProxy::OnStopped(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::EmbeddedWorkerInstanceHost::OnStopped");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::EmbeddedWorkerInstanceHost::kOnStopped), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::EmbeddedWorkerInstanceHost_OnStopped_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(EmbeddedWorkerInstanceHost::Name_);
  message.set_method_name("OnStopped");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class EmbeddedWorkerInstanceHost_RequestTermination_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static EmbeddedWorkerInstanceHost::RequestTerminationCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<EmbeddedWorkerInstanceHost_RequestTermination_ProxyToResponder> proxy(
        new EmbeddedWorkerInstanceHost_RequestTermination_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&EmbeddedWorkerInstanceHost_RequestTermination_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~EmbeddedWorkerInstanceHost_RequestTermination_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  EmbeddedWorkerInstanceHost_RequestTermination_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "EmbeddedWorkerInstanceHost::RequestTerminationCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_will_be_terminated);
};

bool EmbeddedWorkerInstanceHost_RequestTermination_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::EmbeddedWorkerInstanceHost_RequestTermination_ResponseParams_Data* params =
      reinterpret_cast<
          internal::EmbeddedWorkerInstanceHost_RequestTermination_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for EmbeddedWorkerInstanceHost.0
  bool success = true;
  bool p_will_be_terminated{};
  EmbeddedWorkerInstanceHost_RequestTermination_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_will_be_terminated = input_data_view.will_be_terminated();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        EmbeddedWorkerInstanceHost::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_will_be_terminated));
  }
  return true;
}

void EmbeddedWorkerInstanceHost_RequestTermination_ProxyToResponder::Run(
    bool in_will_be_terminated) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::EmbeddedWorkerInstanceHost::RequestTermination", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("will_be_terminated"), in_will_be_terminated,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::EmbeddedWorkerInstanceHost::kRequestTermination), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::EmbeddedWorkerInstanceHost_RequestTermination_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->will_be_terminated = in_will_be_terminated;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(EmbeddedWorkerInstanceHost::Name_);
  message.set_method_name("RequestTermination");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool EmbeddedWorkerInstanceHostStubDispatch::Accept(
    EmbeddedWorkerInstanceHost* impl,
    mojo::Message* message) {
  switch (static_cast<messages::EmbeddedWorkerInstanceHost>(message->header()->name)) {
    case messages::EmbeddedWorkerInstanceHost::kRequestTermination: {
      break;
    }
    case messages::EmbeddedWorkerInstanceHost::kCountFeature: {
      DCHECK(message->is_serialized());
      internal::EmbeddedWorkerInstanceHost_CountFeature_Params_Data* params =
          reinterpret_cast<internal::EmbeddedWorkerInstanceHost_CountFeature_Params_Data*>(
              message->mutable_payload());
      

      // Validation for EmbeddedWorkerInstanceHost.1
      bool success = true;
      ::blink::mojom::WebFeature p_feature{};
      EmbeddedWorkerInstanceHost_CountFeature_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFeature(&p_feature))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            EmbeddedWorkerInstanceHost::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CountFeature(        
        std::move(p_feature));
      return true;
    }
    case messages::EmbeddedWorkerInstanceHost::kOnReadyForInspection: {
      DCHECK(message->is_serialized());
      internal::EmbeddedWorkerInstanceHost_OnReadyForInspection_Params_Data* params =
          reinterpret_cast<internal::EmbeddedWorkerInstanceHost_OnReadyForInspection_Params_Data*>(
              message->mutable_payload());
      

      // Validation for EmbeddedWorkerInstanceHost.2
      bool success = true;
      ::mojo::PendingRemote<::blink::mojom::DevToolsAgent> p_agent{};
      ::mojo::PendingReceiver<::blink::mojom::DevToolsAgentHost> p_agent_host{};
      EmbeddedWorkerInstanceHost_OnReadyForInspection_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_agent =
            input_data_view.TakeAgent<decltype(p_agent)>();
      }
      if (success) {
        p_agent_host =
            input_data_view.TakeAgentHost<decltype(p_agent_host)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            EmbeddedWorkerInstanceHost::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnReadyForInspection(        
        std::move(p_agent), 
        std::move(p_agent_host));
      return true;
    }
    case messages::EmbeddedWorkerInstanceHost::kOnScriptLoaded: {
      DCHECK(message->is_serialized());
      internal::EmbeddedWorkerInstanceHost_OnScriptLoaded_Params_Data* params =
          reinterpret_cast<internal::EmbeddedWorkerInstanceHost_OnScriptLoaded_Params_Data*>(
              message->mutable_payload());
      

      // Validation for EmbeddedWorkerInstanceHost.3
      bool success = true;
      EmbeddedWorkerInstanceHost_OnScriptLoaded_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            EmbeddedWorkerInstanceHost::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnScriptLoaded(        );
      return true;
    }
    case messages::EmbeddedWorkerInstanceHost::kOnScriptEvaluationStart: {
      DCHECK(message->is_serialized());
      internal::EmbeddedWorkerInstanceHost_OnScriptEvaluationStart_Params_Data* params =
          reinterpret_cast<internal::EmbeddedWorkerInstanceHost_OnScriptEvaluationStart_Params_Data*>(
              message->mutable_payload());
      

      // Validation for EmbeddedWorkerInstanceHost.4
      bool success = true;
      EmbeddedWorkerInstanceHost_OnScriptEvaluationStart_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            EmbeddedWorkerInstanceHost::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnScriptEvaluationStart(        );
      return true;
    }
    case messages::EmbeddedWorkerInstanceHost::kOnStarted: {
      DCHECK(message->is_serialized());
      internal::EmbeddedWorkerInstanceHost_OnStarted_Params_Data* params =
          reinterpret_cast<internal::EmbeddedWorkerInstanceHost_OnStarted_Params_Data*>(
              message->mutable_payload());
      

      // Validation for EmbeddedWorkerInstanceHost.5
      bool success = true;
      ::blink::mojom::ServiceWorkerStartStatus p_status{};
      ::blink::mojom::ServiceWorkerFetchHandlerType p_fetch_handler_type{};
      bool p_has_hid_event_handlers{};
      bool p_has_usb_event_handlers{};
      int32_t p_thread_id{};
      EmbeddedWorkerStartTimingPtr p_start_timing{};
      EmbeddedWorkerInstanceHost_OnStarted_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadStatus(&p_status))
        success = false;
      if (success && !input_data_view.ReadFetchHandlerType(&p_fetch_handler_type))
        success = false;
      if (success)
        p_has_hid_event_handlers = input_data_view.has_hid_event_handlers();
      if (success)
        p_has_usb_event_handlers = input_data_view.has_usb_event_handlers();
      if (success)
        p_thread_id = input_data_view.thread_id();
      if (success && !input_data_view.ReadStartTiming(&p_start_timing))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            EmbeddedWorkerInstanceHost::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnStarted(        
        std::move(p_status), 
        std::move(p_fetch_handler_type), 
        std::move(p_has_hid_event_handlers), 
        std::move(p_has_usb_event_handlers), 
        std::move(p_thread_id), 
        std::move(p_start_timing));
      return true;
    }
    case messages::EmbeddedWorkerInstanceHost::kOnReportException: {
      DCHECK(message->is_serialized());
      internal::EmbeddedWorkerInstanceHost_OnReportException_Params_Data* params =
          reinterpret_cast<internal::EmbeddedWorkerInstanceHost_OnReportException_Params_Data*>(
              message->mutable_payload());
      

      // Validation for EmbeddedWorkerInstanceHost.6
      bool success = true;
      ::std::u16string p_error_message{};
      int32_t p_line_number{};
      int32_t p_column_number{};
      ::GURL p_source_url{};
      EmbeddedWorkerInstanceHost_OnReportException_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadErrorMessage(&p_error_message))
        success = false;
      if (success)
        p_line_number = input_data_view.line_number();
      if (success)
        p_column_number = input_data_view.column_number();
      if (success && !input_data_view.ReadSourceUrl(&p_source_url))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            EmbeddedWorkerInstanceHost::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnReportException(        
        std::move(p_error_message), 
        std::move(p_line_number), 
        std::move(p_column_number), 
        std::move(p_source_url));
      return true;
    }
    case messages::EmbeddedWorkerInstanceHost::kOnReportConsoleMessage: {
      DCHECK(message->is_serialized());
      internal::EmbeddedWorkerInstanceHost_OnReportConsoleMessage_Params_Data* params =
          reinterpret_cast<internal::EmbeddedWorkerInstanceHost_OnReportConsoleMessage_Params_Data*>(
              message->mutable_payload());
      

      // Validation for EmbeddedWorkerInstanceHost.7
      bool success = true;
      ::blink::mojom::ConsoleMessageSource p_source{};
      ::blink::mojom::ConsoleMessageLevel p_message_level{};
      ::std::u16string p_message{};
      int32_t p_line_number{};
      ::GURL p_source_url{};
      EmbeddedWorkerInstanceHost_OnReportConsoleMessage_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSource(&p_source))
        success = false;
      if (success && !input_data_view.ReadMessageLevel(&p_message_level))
        success = false;
      if (success && !input_data_view.ReadMessage(&p_message))
        success = false;
      if (success)
        p_line_number = input_data_view.line_number();
      if (success && !input_data_view.ReadSourceUrl(&p_source_url))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            EmbeddedWorkerInstanceHost::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnReportConsoleMessage(        
        std::move(p_source), 
        std::move(p_message_level), 
        std::move(p_message), 
        std::move(p_line_number), 
        std::move(p_source_url));
      return true;
    }
    case messages::EmbeddedWorkerInstanceHost::kOnStopped: {
      DCHECK(message->is_serialized());
      internal::EmbeddedWorkerInstanceHost_OnStopped_Params_Data* params =
          reinterpret_cast<internal::EmbeddedWorkerInstanceHost_OnStopped_Params_Data*>(
              message->mutable_payload());
      

      // Validation for EmbeddedWorkerInstanceHost.8
      bool success = true;
      EmbeddedWorkerInstanceHost_OnStopped_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            EmbeddedWorkerInstanceHost::Name_, 8, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnStopped(        );
      return true;
    }
  }
  return false;
}

// static
bool EmbeddedWorkerInstanceHostStubDispatch::AcceptWithResponder(
    EmbeddedWorkerInstanceHost* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::EmbeddedWorkerInstanceHost>(message->header()->name)) {
    case messages::EmbeddedWorkerInstanceHost::kRequestTermination: {
      internal::EmbeddedWorkerInstanceHost_RequestTermination_Params_Data* params =
          reinterpret_cast<
              internal::EmbeddedWorkerInstanceHost_RequestTermination_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for EmbeddedWorkerInstanceHost.0
      bool success = true;
      EmbeddedWorkerInstanceHost_RequestTermination_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            EmbeddedWorkerInstanceHost::Name_, 0, false);
        return false;
      }
      auto callback =
          EmbeddedWorkerInstanceHost_RequestTermination_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RequestTermination(std::move(callback));
      return true;
    }
    case messages::EmbeddedWorkerInstanceHost::kCountFeature: {
      break;
    }
    case messages::EmbeddedWorkerInstanceHost::kOnReadyForInspection: {
      break;
    }
    case messages::EmbeddedWorkerInstanceHost::kOnScriptLoaded: {
      break;
    }
    case messages::EmbeddedWorkerInstanceHost::kOnScriptEvaluationStart: {
      break;
    }
    case messages::EmbeddedWorkerInstanceHost::kOnStarted: {
      break;
    }
    case messages::EmbeddedWorkerInstanceHost::kOnReportException: {
      break;
    }
    case messages::EmbeddedWorkerInstanceHost::kOnReportConsoleMessage: {
      break;
    }
    case messages::EmbeddedWorkerInstanceHost::kOnStopped: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kEmbeddedWorkerInstanceHostValidationInfo[] = {
    { &internal::EmbeddedWorkerInstanceHost_RequestTermination_Params_Data::Validate,
     &internal::EmbeddedWorkerInstanceHost_RequestTermination_ResponseParams_Data::Validate},
    { &internal::EmbeddedWorkerInstanceHost_CountFeature_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::EmbeddedWorkerInstanceHost_OnReadyForInspection_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::EmbeddedWorkerInstanceHost_OnScriptLoaded_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::EmbeddedWorkerInstanceHost_OnScriptEvaluationStart_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::EmbeddedWorkerInstanceHost_OnStarted_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::EmbeddedWorkerInstanceHost_OnReportException_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::EmbeddedWorkerInstanceHost_OnReportConsoleMessage_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::EmbeddedWorkerInstanceHost_OnStopped_Params_Data::Validate,
     nullptr /* no response */},
};

bool EmbeddedWorkerInstanceHostRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::EmbeddedWorkerInstanceHost::Name_,
    kEmbeddedWorkerInstanceHostValidationInfo);
}

bool EmbeddedWorkerInstanceHostResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::blink::mojom::EmbeddedWorkerInstanceHost::Name_,
    kEmbeddedWorkerInstanceHostValidationInfo);
}


}  // blink::mojom


namespace mojo {


// static
bool StructTraits<::blink::mojom::EmbeddedWorkerStartParams::DataView, ::blink::mojom::EmbeddedWorkerStartParamsPtr>::Read(
    ::blink::mojom::EmbeddedWorkerStartParams::DataView input,
    ::blink::mojom::EmbeddedWorkerStartParamsPtr* output) {
  bool success = true;
  ::blink::mojom::EmbeddedWorkerStartParamsPtr result(::blink::mojom::EmbeddedWorkerStartParams::New());
  
      if (success)
        result->service_worker_version_id = input.service_worker_version_id();
      if (success && !input.ReadScope(&result->scope))
        success = false;
      if (success && !input.ReadScriptUrl(&result->script_url))
        success = false;
      if (success && !input.ReadScriptType(&result->script_type))
        success = false;
      if (success && !input.ReadOutsideFetchClientSettingsObject(&result->outside_fetch_client_settings_object))
        success = false;
      if (success && !input.ReadUserAgent(&result->user_agent))
        success = false;
      if (success && !input.ReadUaMetadata(&result->ua_metadata))
        success = false;
      if (success)
        result->service_worker_route_id = input.service_worker_route_id();
      if (success && !input.ReadDevtoolsWorkerToken(&result->devtools_worker_token))
        success = false;
      if (success && !input.ReadScriptUrlToSkipThrottling(&result->script_url_to_skip_throttling))
        success = false;
      if (success)
        result->wait_for_debugger = input.wait_for_debugger();
      if (success)
        result->is_installed = input.is_installed();
      if (success && !input.ReadRendererPreferences(&result->renderer_preferences))
        success = false;
      if (success && !input.ReadForcedEnabledRuntimeFeatures(&result->forced_enabled_runtime_features))
        success = false;
      if (success) {
        result->service_worker_receiver =
            input.TakeServiceWorkerReceiver<decltype(result->service_worker_receiver)>();
      }
      if (success) {
        result->interface_provider =
            input.TakeInterfaceProvider<decltype(result->interface_provider)>();
      }
      if (success) {
        result->controller_receiver =
            input.TakeControllerReceiver<decltype(result->controller_receiver)>();
      }
      if (success && !input.ReadInstalledScriptsInfo(&result->installed_scripts_info))
        success = false;
      if (success) {
        result->instance_host =
            input.TakeInstanceHost<decltype(result->instance_host)>();
      }
      if (success && !input.ReadProviderInfo(&result->provider_info))
        success = false;
      if (success) {
        result->content_settings_proxy =
            input.TakeContentSettingsProxy<decltype(result->content_settings_proxy)>();
      }
      if (success) {
        result->preference_watcher_receiver =
            input.TakePreferenceWatcherReceiver<decltype(result->preference_watcher_receiver)>();
      }
      if (success && !input.ReadSubresourceLoaderFactories(&result->subresource_loader_factories))
        success = false;
      if (success) {
        result->subresource_loader_updater =
            input.TakeSubresourceLoaderUpdater<decltype(result->subresource_loader_updater)>();
      }
      if (success && !input.ReadServiceWorkerToken(&result->service_worker_token))
        success = false;
      if (success)
        result->ukm_source_id = input.ukm_source_id();
      if (success && !input.ReadMainScriptLoadParams(&result->main_script_load_params))
        success = false;
      if (success && !input.ReadPolicyContainer(&result->policy_container))
        success = false;
      if (success && !input.ReadStorageKey(&result->storage_key))
        success = false;
      if (success && !input.ReadCorsExemptHeaderList(&result->cors_exempt_header_list))
        success = false;
      if (success) {
        result->coep_reporting_observer =
            input.TakeCoepReportingObserver<decltype(result->coep_reporting_observer)>();
      }
      if (success) {
        result->dip_reporting_observer =
            input.TakeDipReportingObserver<decltype(result->dip_reporting_observer)>();
      }
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::EmbeddedWorkerStartTiming::DataView, ::blink::mojom::EmbeddedWorkerStartTimingPtr>::Read(
    ::blink::mojom::EmbeddedWorkerStartTiming::DataView input,
    ::blink::mojom::EmbeddedWorkerStartTimingPtr* output) {
  bool success = true;
  ::blink::mojom::EmbeddedWorkerStartTimingPtr result(::blink::mojom::EmbeddedWorkerStartTiming::New());
  
      if (success && !input.ReadStartWorkerReceivedTime(&result->start_worker_received_time))
        success = false;
      if (success && !input.ReadScriptEvaluationStartTime(&result->script_evaluation_start_time))
        success = false;
      if (success && !input.ReadScriptEvaluationEndTime(&result->script_evaluation_end_time))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace blink::mojom {


void EmbeddedWorkerInstanceClientInterceptorForTesting::StartWorker(EmbeddedWorkerStartParamsPtr params) {
  GetForwardingInterface()->StartWorker(
    std::move(params)
    );
}
void EmbeddedWorkerInstanceClientInterceptorForTesting::StopWorker() {
  GetForwardingInterface()->StopWorker();
}
EmbeddedWorkerInstanceClientAsyncWaiter::EmbeddedWorkerInstanceClientAsyncWaiter(
    EmbeddedWorkerInstanceClient* proxy) : proxy_(proxy) {}

EmbeddedWorkerInstanceClientAsyncWaiter::~EmbeddedWorkerInstanceClientAsyncWaiter() = default;





void EmbeddedWorkerInstanceHostInterceptorForTesting::RequestTermination(RequestTerminationCallback callback) {
  GetForwardingInterface()->RequestTermination(std::move(callback));
}
void EmbeddedWorkerInstanceHostInterceptorForTesting::CountFeature(::blink::mojom::WebFeature feature) {
  GetForwardingInterface()->CountFeature(
    std::move(feature)
    );
}
void EmbeddedWorkerInstanceHostInterceptorForTesting::OnReadyForInspection(::mojo::PendingRemote<::blink::mojom::DevToolsAgent> agent, ::mojo::PendingReceiver<::blink::mojom::DevToolsAgentHost> agent_host) {
  GetForwardingInterface()->OnReadyForInspection(
    std::move(agent)
    , 
    std::move(agent_host)
    );
}
void EmbeddedWorkerInstanceHostInterceptorForTesting::OnScriptLoaded() {
  GetForwardingInterface()->OnScriptLoaded();
}
void EmbeddedWorkerInstanceHostInterceptorForTesting::OnScriptEvaluationStart() {
  GetForwardingInterface()->OnScriptEvaluationStart();
}
void EmbeddedWorkerInstanceHostInterceptorForTesting::OnStarted(::blink::mojom::ServiceWorkerStartStatus status, ::blink::mojom::ServiceWorkerFetchHandlerType fetch_handler_type, bool has_hid_event_handlers, bool has_usb_event_handlers, int32_t thread_id, EmbeddedWorkerStartTimingPtr start_timing) {
  GetForwardingInterface()->OnStarted(
    std::move(status)
    , 
    std::move(fetch_handler_type)
    , 
    std::move(has_hid_event_handlers)
    , 
    std::move(has_usb_event_handlers)
    , 
    std::move(thread_id)
    , 
    std::move(start_timing)
    );
}
void EmbeddedWorkerInstanceHostInterceptorForTesting::OnReportException(const ::std::u16string& error_message, int32_t line_number, int32_t column_number, const ::GURL& source_url) {
  GetForwardingInterface()->OnReportException(
    std::move(error_message)
    , 
    std::move(line_number)
    , 
    std::move(column_number)
    , 
    std::move(source_url)
    );
}
void EmbeddedWorkerInstanceHostInterceptorForTesting::OnReportConsoleMessage(::blink::mojom::ConsoleMessageSource source, ::blink::mojom::ConsoleMessageLevel message_level, const ::std::u16string& message, int32_t line_number, const ::GURL& source_url) {
  GetForwardingInterface()->OnReportConsoleMessage(
    std::move(source)
    , 
    std::move(message_level)
    , 
    std::move(message)
    , 
    std::move(line_number)
    , 
    std::move(source_url)
    );
}
void EmbeddedWorkerInstanceHostInterceptorForTesting::OnStopped() {
  GetForwardingInterface()->OnStopped();
}
EmbeddedWorkerInstanceHostAsyncWaiter::EmbeddedWorkerInstanceHostAsyncWaiter(
    EmbeddedWorkerInstanceHost* proxy) : proxy_(proxy) {}

EmbeddedWorkerInstanceHostAsyncWaiter::~EmbeddedWorkerInstanceHostAsyncWaiter() = default;


void EmbeddedWorkerInstanceHostAsyncWaiter::RequestTermination(
    bool* out_will_be_terminated) {
  base::RunLoop loop;
  proxy_->RequestTermination(
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_will_be_terminated
,
             bool will_be_terminated) {*out_will_be_terminated = std::move(will_be_terminated);
            loop->Quit();
          },
          &loop,
          out_will_be_terminated));
  loop.Run();
}

bool EmbeddedWorkerInstanceHostAsyncWaiter::RequestTermination(
    ) {
  bool async_wait_result;
  RequestTermination(&async_wait_result);
  return async_wait_result;
}






}  // blink::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif