// third_party/blink/public/mojom/service_worker/controller_service_worker.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_SERVICE_WORKER_CONTROLLER_SERVICE_WORKER_MOJOM_SHARED_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_SERVICE_WORKER_CONTROLLER_SERVICE_WORKER_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/service_worker/controller_service_worker.mojom-shared-internal.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared.h"
#include "services/network/public/mojom/cross_origin_embedder_policy.mojom-shared.h"
#include "services/network/public/mojom/document_isolation_policy.mojom-shared.h"
#include "third_party/blink/public/mojom/cache_storage/cache_storage.mojom-shared.h"
#include "third_party/blink/public/mojom/service_worker/controller_service_worker_mode.mojom-shared.h"
#include "third_party/blink/public/mojom/service_worker/dispatch_fetch_event_params.mojom-shared.h"
#include "third_party/blink/public/mojom/service_worker/service_worker_embedded_worker_status.mojom-shared.h"
#include "third_party/blink/public/mojom/service_worker/service_worker_event_status.mojom-shared.h"
#include "third_party/blink/public/mojom/service_worker/service_worker_fetch_handler_bypass_option.mojom-shared.h"
#include "third_party/blink/public/mojom/service_worker/service_worker_fetch_handler_type.mojom-shared.h"
#include "third_party/blink/public/mojom/service_worker/service_worker_fetch_response_callback.mojom-shared.h"
#include "third_party/blink/public/mojom/service_worker/service_worker_object.mojom-shared.h"
#include "third_party/blink/public/mojom/service_worker/service_worker_router_rule.mojom-shared.h"
#include "third_party/blink/public/mojom/use_counter/metrics/web_feature.mojom-shared.h"
#include "third_party/blink/public/mojom/service_worker/service_worker_running_status_callback.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "third_party/blink/public/mojom/service_worker/controller_service_worker.mojom-data-view.h"
#include "base/component_export.h"




namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::ServiceWorkerRouterDataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::ServiceWorkerRouterDataDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::ServiceWorkerRouterData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::router_rules(input)) in_router_rules = Traits::router_rules(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->router_rules)::BaseType> router_rules_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::ServiceWorkerRouterRulesDataView>(
      in_router_rules,
      router_rules_fragment);

    fragment->router_rules.Set(
        router_rules_fragment.is_null() ? nullptr : router_rules_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->router_rules.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null router_rules in ServiceWorkerRouterData struct");
    fragment->initial_running_status_$flag = Traits::initial_running_status(input).has_value();
    if (Traits::initial_running_status(input).has_value()) {
      
      mojo::internal::Serialize<::blink::mojom::ServiceWorkerEmbeddedWorkerStatus>(
        Traits::initial_running_status(input).value(),
        &fragment->initial_running_status_$value);
    } else {
      fragment->initial_running_status_$value =
          static_cast<int32_t>(::blink::mojom::ServiceWorkerEmbeddedWorkerStatus::kMinValue);
    }

    decltype(Traits::running_status_receiver(input)) in_running_status_receiver = Traits::running_status_receiver(input);

    
    mojo::internal::Serialize<mojo::InterfaceRequestDataView<::blink::mojom::ServiceWorkerRunningStatusCallbackInterfaceBase>>(
      in_running_status_receiver,
      &fragment->running_status_receiver,
      &fragment.message());

    decltype(Traits::remote_cache_storage(input)) in_remote_cache_storage = Traits::remote_cache_storage(input);

    
    mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::CacheStorageInterfaceBase>>(
      in_remote_cache_storage,
      &fragment->remote_cache_storage,
      &fragment.message());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(!mojo::internal::IsHandleOrInterfaceValid(fragment->remote_cache_storage)),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid remote_cache_storage in ServiceWorkerRouterData struct");
  }

  static bool Deserialize(::blink::mojom::internal::ServiceWorkerRouterData_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::ServiceWorkerRouterDataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::ControllerServiceWorkerInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::ControllerServiceWorkerInfoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::ControllerServiceWorkerInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    
    mojo::internal::Serialize<::blink::mojom::ControllerServiceWorkerMode>(
      Traits::mode(input),
      &fragment->mode);

    
    mojo::internal::Serialize<::blink::mojom::ServiceWorkerFetchHandlerType>(
      Traits::fetch_handler_type(input),
      &fragment->fetch_handler_type);

    
    mojo::internal::Serialize<::blink::mojom::ServiceWorkerFetchHandlerBypassOption>(
      Traits::fetch_handler_bypass_option(input),
      &fragment->fetch_handler_bypass_option);

    decltype(Traits::sha256_script_checksum(input)) in_sha256_script_checksum = Traits::sha256_script_checksum(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->sha256_script_checksum)::BaseType> sha256_script_checksum_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_sha256_script_checksum,
      sha256_script_checksum_fragment);

    fragment->sha256_script_checksum.Set(
        sha256_script_checksum_fragment.is_null() ? nullptr : sha256_script_checksum_fragment.data());

    fragment->need_router_evaluate = Traits::need_router_evaluate(input);

    decltype(Traits::router_data(input)) in_router_data = Traits::router_data(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->router_data)::BaseType> router_data_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::ServiceWorkerRouterDataDataView>(
      in_router_data,
      router_data_fragment);

    fragment->router_data.Set(
        router_data_fragment.is_null() ? nullptr : router_data_fragment.data());

    decltype(Traits::remote_controller(input)) in_remote_controller = Traits::remote_controller(input);

    
    mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::ControllerServiceWorkerInterfaceBase>>(
      in_remote_controller,
      &fragment->remote_controller,
      &fragment.message());

    decltype(Traits::client_id(input)) in_client_id = Traits::client_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->client_id)::BaseType> client_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_client_id,
      client_id_fragment);

    fragment->client_id.Set(
        client_id_fragment.is_null() ? nullptr : client_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->client_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null client_id in ControllerServiceWorkerInfo struct");

    decltype(Traits::fetch_request_window_id(input)) in_fetch_request_window_id = Traits::fetch_request_window_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->fetch_request_window_id)::BaseType> fetch_request_window_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
      in_fetch_request_window_id,
      fetch_request_window_id_fragment);

    fragment->fetch_request_window_id.Set(
        fetch_request_window_id_fragment.is_null() ? nullptr : fetch_request_window_id_fragment.data());

    decltype(Traits::object_info(input)) in_object_info = Traits::object_info(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->object_info)::BaseType> object_info_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::ServiceWorkerObjectInfoDataView>(
      in_object_info,
      object_info_fragment);

    fragment->object_info.Set(
        object_info_fragment.is_null() ? nullptr : object_info_fragment.data());

    decltype(Traits::used_features(input)) in_used_features = Traits::used_features(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->used_features)::BaseType>
        used_features_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& used_features_validate_params =
        mojo::internal::GetArrayOfEnumsValidator<0, false, ::blink::mojom::internal::WebFeature_Data::Validate>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::WebFeature>>(
      in_used_features,
      used_features_fragment,
      &used_features_validate_params);

    fragment->used_features.Set(
        used_features_fragment.is_null() ? nullptr : used_features_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->used_features.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null used_features in ControllerServiceWorkerInfo struct");
  }

  static bool Deserialize(::blink::mojom::internal::ControllerServiceWorkerInfo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::ControllerServiceWorkerInfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace blink::mojom {

inline void ServiceWorkerRouterDataDataView::GetRouterRulesDataView(
    ::blink::mojom::ServiceWorkerRouterRulesDataView* output) {
  auto pointer = data_->router_rules.Get();
  *output = ::blink::mojom::ServiceWorkerRouterRulesDataView(pointer, message_);
}


inline void ControllerServiceWorkerInfoDataView::GetSha256ScriptChecksumDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->sha256_script_checksum.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void ControllerServiceWorkerInfoDataView::GetRouterDataDataView(
    ServiceWorkerRouterDataDataView* output) {
  auto pointer = data_->router_data.Get();
  *output = ServiceWorkerRouterDataDataView(pointer, message_);
}
inline void ControllerServiceWorkerInfoDataView::GetClientIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->client_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void ControllerServiceWorkerInfoDataView::GetFetchRequestWindowIdDataView(
    ::mojo_base::mojom::UnguessableTokenDataView* output) {
  auto pointer = data_->fetch_request_window_id.Get();
  *output = ::mojo_base::mojom::UnguessableTokenDataView(pointer, message_);
}
inline void ControllerServiceWorkerInfoDataView::GetObjectInfoDataView(
    ::blink::mojom::ServiceWorkerObjectInfoDataView* output) {
  auto pointer = data_->object_info.Get();
  *output = ::blink::mojom::ServiceWorkerObjectInfoDataView(pointer, message_);
}
inline void ControllerServiceWorkerInfoDataView::GetUsedFeaturesDataView(
    mojo::ArrayDataView<::blink::mojom::WebFeature>* output) {
  auto pointer = data_->used_features.Get();
  *output = mojo::ArrayDataView<::blink::mojom::WebFeature>(pointer, message_);
}



}  // blink::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_SERVICE_WORKER_CONTROLLER_SERVICE_WORKER_MOJOM_SHARED_H_