// third_party/blink/public/mojom/serial/serial.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'third_party/blink/public/mojom/serial/serial.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('blink.mojom');
  var uuid$ =
      mojo.internal.exposeNamespace('bluetooth.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'device/bluetooth/public/mojom/uuid.mojom', '../../../../../device/bluetooth/public/mojom/uuid.mojom.js');
  }
  var unguessable_token$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/unguessable_token.mojom', '../../../../../mojo/public/mojom/base/unguessable_token.mojom.js');
  }
  var serial$ =
      mojo.internal.exposeNamespace('device.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/device/public/mojom/serial.mojom', '../../../../../services/device/public/mojom/serial.mojom.js');
  }



  function SerialPortInfo(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SerialPortInfo.prototype.initDefaults_ = function() {
    this.token = null;
    this.usbVendorId = 0;
    this.hasUsbVendorId = false;
    this.hasUsbProductId = false;
    this.connected = false;
    this.usbProductId = 0;
    this.bluetoothServiceClassId = null;
  };
  SerialPortInfo.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SerialPortInfo.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SerialPortInfo.token
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, unguessable_token$.UnguessableToken, false);
    if (err !== validator.validationError.NONE)
        return err;






    // validate SerialPortInfo.bluetoothServiceClassId
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, uuid$.UUID, true);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  SerialPortInfo.encodedSize = codec.kStructHeaderSize + 24;

  SerialPortInfo.decode = function(decoder) {
    var packed;
    var val = new SerialPortInfo();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.token =
        decoder.decodeStructPointer(unguessable_token$.UnguessableToken);
    val.usbVendorId =
        decoder.decodeStruct(codec.Uint16);
    packed = decoder.readUint8();
    val.hasUsbVendorId = (packed >> 0) & 1 ? true : false;
    val.hasUsbProductId = (packed >> 1) & 1 ? true : false;
    val.connected = (packed >> 2) & 1 ? true : false;
    decoder.skip(1);
    val.usbProductId =
        decoder.decodeStruct(codec.Uint16);
    decoder.skip(1);
    decoder.skip(1);
    val.bluetoothServiceClassId =
        decoder.decodeStructPointer(uuid$.UUID);
    return val;
  };

  SerialPortInfo.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SerialPortInfo.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(unguessable_token$.UnguessableToken, val.token);
    encoder.encodeStruct(codec.Uint16, val.usbVendorId);
    packed = 0;
    packed |= (val.hasUsbVendorId & 1) << 0
    packed |= (val.hasUsbProductId & 1) << 1
    packed |= (val.connected & 1) << 2
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.encodeStruct(codec.Uint16, val.usbProductId);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(uuid$.UUID, val.bluetoothServiceClassId);
  };
  function SerialPortFilter(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SerialPortFilter.prototype.initDefaults_ = function() {
    this.vendorId = 0;
    this.hasVendorId = false;
    this.hasProductId = false;
    this.productId = 0;
    this.bluetoothServiceClassId = null;
  };
  SerialPortFilter.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SerialPortFilter.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;






    // validate SerialPortFilter.bluetoothServiceClassId
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, uuid$.UUID, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SerialPortFilter.encodedSize = codec.kStructHeaderSize + 16;

  SerialPortFilter.decode = function(decoder) {
    var packed;
    var val = new SerialPortFilter();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.vendorId =
        decoder.decodeStruct(codec.Uint32);
    packed = decoder.readUint8();
    val.hasVendorId = (packed >> 0) & 1 ? true : false;
    val.hasProductId = (packed >> 1) & 1 ? true : false;
    decoder.skip(1);
    val.productId =
        decoder.decodeStruct(codec.Uint16);
    val.bluetoothServiceClassId =
        decoder.decodeStructPointer(uuid$.UUID);
    return val;
  };

  SerialPortFilter.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SerialPortFilter.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Uint32, val.vendorId);
    packed = 0;
    packed |= (val.hasVendorId & 1) << 0
    packed |= (val.hasProductId & 1) << 1
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.encodeStruct(codec.Uint16, val.productId);
    encoder.encodeStructPointer(uuid$.UUID, val.bluetoothServiceClassId);
  };
  function SerialService_SetClient_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SerialService_SetClient_Params.prototype.initDefaults_ = function() {
    this.client = new SerialServiceClientPtr();
  };
  SerialService_SetClient_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SerialService_SetClient_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SerialService_SetClient_Params.client
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 0, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SerialService_SetClient_Params.encodedSize = codec.kStructHeaderSize + 8;

  SerialService_SetClient_Params.decode = function(decoder) {
    var packed;
    var val = new SerialService_SetClient_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.client =
        decoder.decodeStruct(new codec.Interface(SerialServiceClientPtr));
    return val;
  };

  SerialService_SetClient_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SerialService_SetClient_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(new codec.Interface(SerialServiceClientPtr), val.client);
  };
  function SerialService_GetPorts_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SerialService_GetPorts_Params.prototype.initDefaults_ = function() {
  };
  SerialService_GetPorts_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SerialService_GetPorts_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SerialService_GetPorts_Params.encodedSize = codec.kStructHeaderSize + 0;

  SerialService_GetPorts_Params.decode = function(decoder) {
    var packed;
    var val = new SerialService_GetPorts_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  SerialService_GetPorts_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SerialService_GetPorts_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function SerialService_GetPorts_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SerialService_GetPorts_ResponseParams.prototype.initDefaults_ = function() {
    this.ports = null;
  };
  SerialService_GetPorts_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SerialService_GetPorts_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SerialService_GetPorts_ResponseParams.ports
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, new codec.PointerTo(SerialPortInfo), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SerialService_GetPorts_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  SerialService_GetPorts_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new SerialService_GetPorts_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.ports =
        decoder.decodeArrayPointer(new codec.PointerTo(SerialPortInfo));
    return val;
  };

  SerialService_GetPorts_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SerialService_GetPorts_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(new codec.PointerTo(SerialPortInfo), val.ports);
  };
  function SerialService_RequestPort_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SerialService_RequestPort_Params.prototype.initDefaults_ = function() {
    this.filters = null;
    this.allowedBluetoothServiceClassIds = null;
  };
  SerialService_RequestPort_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SerialService_RequestPort_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SerialService_RequestPort_Params.filters
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, new codec.PointerTo(SerialPortFilter), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SerialService_RequestPort_Params.allowedBluetoothServiceClassIds
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 8, 8, new codec.PointerTo(uuid$.UUID), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SerialService_RequestPort_Params.encodedSize = codec.kStructHeaderSize + 16;

  SerialService_RequestPort_Params.decode = function(decoder) {
    var packed;
    var val = new SerialService_RequestPort_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.filters =
        decoder.decodeArrayPointer(new codec.PointerTo(SerialPortFilter));
    val.allowedBluetoothServiceClassIds =
        decoder.decodeArrayPointer(new codec.PointerTo(uuid$.UUID));
    return val;
  };

  SerialService_RequestPort_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SerialService_RequestPort_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(new codec.PointerTo(SerialPortFilter), val.filters);
    encoder.encodeArrayPointer(new codec.PointerTo(uuid$.UUID), val.allowedBluetoothServiceClassIds);
  };
  function SerialService_RequestPort_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SerialService_RequestPort_ResponseParams.prototype.initDefaults_ = function() {
    this.port = null;
  };
  SerialService_RequestPort_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SerialService_RequestPort_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SerialService_RequestPort_ResponseParams.port
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, SerialPortInfo, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SerialService_RequestPort_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  SerialService_RequestPort_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new SerialService_RequestPort_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.port =
        decoder.decodeStructPointer(SerialPortInfo);
    return val;
  };

  SerialService_RequestPort_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SerialService_RequestPort_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(SerialPortInfo, val.port);
  };
  function SerialService_OpenPort_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SerialService_OpenPort_Params.prototype.initDefaults_ = function() {
    this.token = null;
    this.options = null;
    this.client = new serial$.SerialPortClientPtr();
  };
  SerialService_OpenPort_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SerialService_OpenPort_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SerialService_OpenPort_Params.token
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, unguessable_token$.UnguessableToken, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SerialService_OpenPort_Params.options
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, serial$.SerialConnectionOptions, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SerialService_OpenPort_Params.client
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 16, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SerialService_OpenPort_Params.encodedSize = codec.kStructHeaderSize + 24;

  SerialService_OpenPort_Params.decode = function(decoder) {
    var packed;
    var val = new SerialService_OpenPort_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.token =
        decoder.decodeStructPointer(unguessable_token$.UnguessableToken);
    val.options =
        decoder.decodeStructPointer(serial$.SerialConnectionOptions);
    val.client =
        decoder.decodeStruct(new codec.Interface(serial$.SerialPortClientPtr));
    return val;
  };

  SerialService_OpenPort_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SerialService_OpenPort_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(unguessable_token$.UnguessableToken, val.token);
    encoder.encodeStructPointer(serial$.SerialConnectionOptions, val.options);
    encoder.encodeStruct(new codec.Interface(serial$.SerialPortClientPtr), val.client);
  };
  function SerialService_OpenPort_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SerialService_OpenPort_ResponseParams.prototype.initDefaults_ = function() {
    this.port = new serial$.SerialPortPtr();
  };
  SerialService_OpenPort_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SerialService_OpenPort_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SerialService_OpenPort_ResponseParams.port
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 0, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SerialService_OpenPort_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  SerialService_OpenPort_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new SerialService_OpenPort_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.port =
        decoder.decodeStruct(new codec.NullableInterface(serial$.SerialPortPtr));
    return val;
  };

  SerialService_OpenPort_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SerialService_OpenPort_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(new codec.NullableInterface(serial$.SerialPortPtr), val.port);
  };
  function SerialService_ForgetPort_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SerialService_ForgetPort_Params.prototype.initDefaults_ = function() {
    this.token = null;
  };
  SerialService_ForgetPort_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SerialService_ForgetPort_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SerialService_ForgetPort_Params.token
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, unguessable_token$.UnguessableToken, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SerialService_ForgetPort_Params.encodedSize = codec.kStructHeaderSize + 8;

  SerialService_ForgetPort_Params.decode = function(decoder) {
    var packed;
    var val = new SerialService_ForgetPort_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.token =
        decoder.decodeStructPointer(unguessable_token$.UnguessableToken);
    return val;
  };

  SerialService_ForgetPort_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SerialService_ForgetPort_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(unguessable_token$.UnguessableToken, val.token);
  };
  function SerialService_ForgetPort_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SerialService_ForgetPort_ResponseParams.prototype.initDefaults_ = function() {
  };
  SerialService_ForgetPort_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SerialService_ForgetPort_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SerialService_ForgetPort_ResponseParams.encodedSize = codec.kStructHeaderSize + 0;

  SerialService_ForgetPort_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new SerialService_ForgetPort_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  SerialService_ForgetPort_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SerialService_ForgetPort_ResponseParams.encodedSize);
    encoder.writeUint32(0);
  };
  function SerialServiceClient_OnPortConnectedStateChanged_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SerialServiceClient_OnPortConnectedStateChanged_Params.prototype.initDefaults_ = function() {
    this.portInfo = null;
  };
  SerialServiceClient_OnPortConnectedStateChanged_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SerialServiceClient_OnPortConnectedStateChanged_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SerialServiceClient_OnPortConnectedStateChanged_Params.portInfo
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, SerialPortInfo, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SerialServiceClient_OnPortConnectedStateChanged_Params.encodedSize = codec.kStructHeaderSize + 8;

  SerialServiceClient_OnPortConnectedStateChanged_Params.decode = function(decoder) {
    var packed;
    var val = new SerialServiceClient_OnPortConnectedStateChanged_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.portInfo =
        decoder.decodeStructPointer(SerialPortInfo);
    return val;
  };

  SerialServiceClient_OnPortConnectedStateChanged_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SerialServiceClient_OnPortConnectedStateChanged_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(SerialPortInfo, val.portInfo);
  };
  var kSerialService_SetClient_Name = 0;
  var kSerialService_GetPorts_Name = 1;
  var kSerialService_RequestPort_Name = 2;
  var kSerialService_OpenPort_Name = 3;
  var kSerialService_ForgetPort_Name = 4;

  function SerialServicePtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(SerialService,
                                                   handleOrPtrInfo);
  }

  function SerialServiceAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        SerialService, associatedInterfacePtrInfo);
  }

  SerialServiceAssociatedPtr.prototype =
      Object.create(SerialServicePtr.prototype);
  SerialServiceAssociatedPtr.prototype.constructor =
      SerialServiceAssociatedPtr;

  function SerialServiceProxy(receiver) {
    this.receiver_ = receiver;
  }
  SerialServicePtr.prototype.setClient = function() {
    return SerialServiceProxy.prototype.setClient
        .apply(this.ptr.getProxy(), arguments);
  };

  SerialServiceProxy.prototype.setClient = function(client) {
    var params_ = new SerialService_SetClient_Params();
    params_.client = client;
    var builder = new codec.MessageV0Builder(
        kSerialService_SetClient_Name,
        codec.align(SerialService_SetClient_Params.encodedSize));
    builder.encodeStruct(SerialService_SetClient_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  SerialServicePtr.prototype.getPorts = function() {
    return SerialServiceProxy.prototype.getPorts
        .apply(this.ptr.getProxy(), arguments);
  };

  SerialServiceProxy.prototype.getPorts = function() {
    var params_ = new SerialService_GetPorts_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kSerialService_GetPorts_Name,
          codec.align(SerialService_GetPorts_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(SerialService_GetPorts_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(SerialService_GetPorts_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  SerialServicePtr.prototype.requestPort = function() {
    return SerialServiceProxy.prototype.requestPort
        .apply(this.ptr.getProxy(), arguments);
  };

  SerialServiceProxy.prototype.requestPort = function(filters, allowedBluetoothServiceClassIds) {
    var params_ = new SerialService_RequestPort_Params();
    params_.filters = filters;
    params_.allowedBluetoothServiceClassIds = allowedBluetoothServiceClassIds;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kSerialService_RequestPort_Name,
          codec.align(SerialService_RequestPort_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(SerialService_RequestPort_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(SerialService_RequestPort_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  SerialServicePtr.prototype.openPort = function() {
    return SerialServiceProxy.prototype.openPort
        .apply(this.ptr.getProxy(), arguments);
  };

  SerialServiceProxy.prototype.openPort = function(token, options, client) {
    var params_ = new SerialService_OpenPort_Params();
    params_.token = token;
    params_.options = options;
    params_.client = client;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kSerialService_OpenPort_Name,
          codec.align(SerialService_OpenPort_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(SerialService_OpenPort_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(SerialService_OpenPort_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  SerialServicePtr.prototype.forgetPort = function() {
    return SerialServiceProxy.prototype.forgetPort
        .apply(this.ptr.getProxy(), arguments);
  };

  SerialServiceProxy.prototype.forgetPort = function(token) {
    var params_ = new SerialService_ForgetPort_Params();
    params_.token = token;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kSerialService_ForgetPort_Name,
          codec.align(SerialService_ForgetPort_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(SerialService_ForgetPort_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(SerialService_ForgetPort_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };

  function SerialServiceStub(delegate) {
    this.delegate_ = delegate;
  }
  SerialServiceStub.prototype.setClient = function(client) {
    return this.delegate_ && this.delegate_.setClient && this.delegate_.setClient(client);
  }
  SerialServiceStub.prototype.getPorts = function() {
    return this.delegate_ && this.delegate_.getPorts && this.delegate_.getPorts();
  }
  SerialServiceStub.prototype.requestPort = function(filters, allowedBluetoothServiceClassIds) {
    return this.delegate_ && this.delegate_.requestPort && this.delegate_.requestPort(filters, allowedBluetoothServiceClassIds);
  }
  SerialServiceStub.prototype.openPort = function(token, options, client) {
    return this.delegate_ && this.delegate_.openPort && this.delegate_.openPort(token, options, client);
  }
  SerialServiceStub.prototype.forgetPort = function(token) {
    return this.delegate_ && this.delegate_.forgetPort && this.delegate_.forgetPort(token);
  }

  SerialServiceStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kSerialService_SetClient_Name:
      var params = reader.decodeStruct(SerialService_SetClient_Params);
      this.setClient(params.client);
      return true;
    default:
      return false;
    }
  };

  SerialServiceStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kSerialService_GetPorts_Name:
      var params = reader.decodeStruct(SerialService_GetPorts_Params);
      this.getPorts().then(function(response) {
        var responseParams =
            new SerialService_GetPorts_ResponseParams();
        responseParams.ports = response.ports;
        var builder = new codec.MessageV1Builder(
            kSerialService_GetPorts_Name,
            codec.align(SerialService_GetPorts_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(SerialService_GetPorts_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kSerialService_RequestPort_Name:
      var params = reader.decodeStruct(SerialService_RequestPort_Params);
      this.requestPort(params.filters, params.allowedBluetoothServiceClassIds).then(function(response) {
        var responseParams =
            new SerialService_RequestPort_ResponseParams();
        responseParams.port = response.port;
        var builder = new codec.MessageV1Builder(
            kSerialService_RequestPort_Name,
            codec.align(SerialService_RequestPort_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(SerialService_RequestPort_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kSerialService_OpenPort_Name:
      var params = reader.decodeStruct(SerialService_OpenPort_Params);
      this.openPort(params.token, params.options, params.client).then(function(response) {
        var responseParams =
            new SerialService_OpenPort_ResponseParams();
        responseParams.port = response.port;
        var builder = new codec.MessageV1Builder(
            kSerialService_OpenPort_Name,
            codec.align(SerialService_OpenPort_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(SerialService_OpenPort_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kSerialService_ForgetPort_Name:
      var params = reader.decodeStruct(SerialService_ForgetPort_Params);
      this.forgetPort(params.token).then(function(response) {
        var responseParams =
            new SerialService_ForgetPort_ResponseParams();
        var builder = new codec.MessageV1Builder(
            kSerialService_ForgetPort_Name,
            codec.align(SerialService_ForgetPort_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(SerialService_ForgetPort_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateSerialServiceRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kSerialService_SetClient_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = SerialService_SetClient_Params;
      break;
      case kSerialService_GetPorts_Name:
        if (message.expectsResponse())
          paramsClass = SerialService_GetPorts_Params;
      break;
      case kSerialService_RequestPort_Name:
        if (message.expectsResponse())
          paramsClass = SerialService_RequestPort_Params;
      break;
      case kSerialService_OpenPort_Name:
        if (message.expectsResponse())
          paramsClass = SerialService_OpenPort_Params;
      break;
      case kSerialService_ForgetPort_Name:
        if (message.expectsResponse())
          paramsClass = SerialService_ForgetPort_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateSerialServiceResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kSerialService_GetPorts_Name:
        if (message.isResponse())
          paramsClass = SerialService_GetPorts_ResponseParams;
        break;
      case kSerialService_RequestPort_Name:
        if (message.isResponse())
          paramsClass = SerialService_RequestPort_ResponseParams;
        break;
      case kSerialService_OpenPort_Name:
        if (message.isResponse())
          paramsClass = SerialService_OpenPort_ResponseParams;
        break;
      case kSerialService_ForgetPort_Name:
        if (message.isResponse())
          paramsClass = SerialService_ForgetPort_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var SerialService = {
    name: 'blink.mojom.SerialService',
    kVersion: 0,
    ptrClass: SerialServicePtr,
    proxyClass: SerialServiceProxy,
    stubClass: SerialServiceStub,
    validateRequest: validateSerialServiceRequest,
    validateResponse: validateSerialServiceResponse,
  };
  SerialServiceStub.prototype.validator = validateSerialServiceRequest;
  SerialServiceProxy.prototype.validator = validateSerialServiceResponse;
  var kSerialServiceClient_OnPortConnectedStateChanged_Name = 0;

  function SerialServiceClientPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(SerialServiceClient,
                                                   handleOrPtrInfo);
  }

  function SerialServiceClientAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        SerialServiceClient, associatedInterfacePtrInfo);
  }

  SerialServiceClientAssociatedPtr.prototype =
      Object.create(SerialServiceClientPtr.prototype);
  SerialServiceClientAssociatedPtr.prototype.constructor =
      SerialServiceClientAssociatedPtr;

  function SerialServiceClientProxy(receiver) {
    this.receiver_ = receiver;
  }
  SerialServiceClientPtr.prototype.onPortConnectedStateChanged = function() {
    return SerialServiceClientProxy.prototype.onPortConnectedStateChanged
        .apply(this.ptr.getProxy(), arguments);
  };

  SerialServiceClientProxy.prototype.onPortConnectedStateChanged = function(portInfo) {
    var params_ = new SerialServiceClient_OnPortConnectedStateChanged_Params();
    params_.portInfo = portInfo;
    var builder = new codec.MessageV0Builder(
        kSerialServiceClient_OnPortConnectedStateChanged_Name,
        codec.align(SerialServiceClient_OnPortConnectedStateChanged_Params.encodedSize));
    builder.encodeStruct(SerialServiceClient_OnPortConnectedStateChanged_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function SerialServiceClientStub(delegate) {
    this.delegate_ = delegate;
  }
  SerialServiceClientStub.prototype.onPortConnectedStateChanged = function(portInfo) {
    return this.delegate_ && this.delegate_.onPortConnectedStateChanged && this.delegate_.onPortConnectedStateChanged(portInfo);
  }

  SerialServiceClientStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kSerialServiceClient_OnPortConnectedStateChanged_Name:
      var params = reader.decodeStruct(SerialServiceClient_OnPortConnectedStateChanged_Params);
      this.onPortConnectedStateChanged(params.portInfo);
      return true;
    default:
      return false;
    }
  };

  SerialServiceClientStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateSerialServiceClientRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kSerialServiceClient_OnPortConnectedStateChanged_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = SerialServiceClient_OnPortConnectedStateChanged_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateSerialServiceClientResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var SerialServiceClient = {
    name: 'blink.mojom.SerialServiceClient',
    kVersion: 0,
    ptrClass: SerialServiceClientPtr,
    proxyClass: SerialServiceClientProxy,
    stubClass: SerialServiceClientStub,
    validateRequest: validateSerialServiceClientRequest,
    validateResponse: null,
  };
  SerialServiceClientStub.prototype.validator = validateSerialServiceClientRequest;
  SerialServiceClientProxy.prototype.validator = null;
  exports.SerialPortInfo = SerialPortInfo;
  exports.SerialPortFilter = SerialPortFilter;
  exports.SerialService = SerialService;
  exports.SerialServicePtr = SerialServicePtr;
  exports.SerialServiceAssociatedPtr = SerialServiceAssociatedPtr;
  exports.SerialServiceClient = SerialServiceClient;
  exports.SerialServiceClientPtr = SerialServiceClientPtr;
  exports.SerialServiceClientAssociatedPtr = SerialServiceClientAssociatedPtr;
})();