// third_party/blink/public/mojom/serial/serial.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_SERIAL_SERIAL_MOJOM_SHARED_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_SERIAL_SERIAL_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/serial/serial.mojom-shared-internal.h"
#include "device/bluetooth/public/mojom/uuid.mojom-shared.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared.h"
#include "services/device/public/mojom/serial.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "third_party/blink/public/mojom/serial/serial.mojom-data-view.h"
#include "base/component_export.h"




namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::SerialPortInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::SerialPortInfoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::SerialPortInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::token(input)) in_token = Traits::token(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->token)::BaseType> token_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
      in_token,
      token_fragment);

    fragment->token.Set(
        token_fragment.is_null() ? nullptr : token_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->token.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null token in SerialPortInfo struct");

    fragment->usb_vendor_id = Traits::usb_vendor_id(input);

    fragment->has_usb_vendor_id = Traits::has_usb_vendor_id(input);

    fragment->usb_product_id = Traits::usb_product_id(input);

    fragment->has_usb_product_id = Traits::has_usb_product_id(input);

    decltype(Traits::bluetooth_service_class_id(input)) in_bluetooth_service_class_id = Traits::bluetooth_service_class_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->bluetooth_service_class_id)::BaseType> bluetooth_service_class_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::bluetooth::mojom::UUIDDataView>(
      in_bluetooth_service_class_id,
      bluetooth_service_class_id_fragment);

    fragment->bluetooth_service_class_id.Set(
        bluetooth_service_class_id_fragment.is_null() ? nullptr : bluetooth_service_class_id_fragment.data());

    fragment->connected = Traits::connected(input);
  }

  static bool Deserialize(::blink::mojom::internal::SerialPortInfo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::SerialPortInfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::SerialPortFilterDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::SerialPortFilterDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::SerialPortFilter_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->vendor_id = Traits::vendor_id(input);

    fragment->has_vendor_id = Traits::has_vendor_id(input);

    fragment->product_id = Traits::product_id(input);

    fragment->has_product_id = Traits::has_product_id(input);

    decltype(Traits::bluetooth_service_class_id(input)) in_bluetooth_service_class_id = Traits::bluetooth_service_class_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->bluetooth_service_class_id)::BaseType> bluetooth_service_class_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::bluetooth::mojom::UUIDDataView>(
      in_bluetooth_service_class_id,
      bluetooth_service_class_id_fragment);

    fragment->bluetooth_service_class_id.Set(
        bluetooth_service_class_id_fragment.is_null() ? nullptr : bluetooth_service_class_id_fragment.data());
  }

  static bool Deserialize(::blink::mojom::internal::SerialPortFilter_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::SerialPortFilterDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace blink::mojom {

inline void SerialPortInfoDataView::GetTokenDataView(
    ::mojo_base::mojom::UnguessableTokenDataView* output) {
  auto pointer = data_->token.Get();
  *output = ::mojo_base::mojom::UnguessableTokenDataView(pointer, message_);
}
inline void SerialPortInfoDataView::GetBluetoothServiceClassIdDataView(
    ::bluetooth::mojom::UUIDDataView* output) {
  auto pointer = data_->bluetooth_service_class_id.Get();
  *output = ::bluetooth::mojom::UUIDDataView(pointer, message_);
}


inline void SerialPortFilterDataView::GetBluetoothServiceClassIdDataView(
    ::bluetooth::mojom::UUIDDataView* output) {
  auto pointer = data_->bluetooth_service_class_id.Get();
  *output = ::bluetooth::mojom::UUIDDataView(pointer, message_);
}



}  // blink::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_SERIAL_SERIAL_MOJOM_SHARED_H_