// third_party/blink/public/mojom/sensor/web_sensor_provider.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';

import {
  SensorType as device_mojom_SensorType,
  SensorTypeSpec as device_mojom_SensorTypeSpec
} from '../../../../../services/device/public/mojom/sensor.mojom.m.js';

import {
  SensorCreationResult as device_mojom_SensorCreationResult,
  SensorCreationResultSpec as device_mojom_SensorCreationResultSpec,
  SensorInitParams as device_mojom_SensorInitParams,
  SensorInitParamsSpec as device_mojom_SensorInitParamsSpec
} from '../../../../../services/device/public/mojom/sensor_provider.mojom.m.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class WebSensorProviderPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.WebSensorProvider', scope);
  }
}

/** @interface */
export class WebSensorProviderInterface {
  
  /**
   * @param { !device_mojom_SensorType } type
   * @return {!Promise<{
        result: !device_mojom_SensorCreationResult,
        initParams: ?device_mojom_SensorInitParams,
   *  }>}
   */

  getSensor(type) {}
}

/**
 * @implements { WebSensorProviderInterface }
 */
export class WebSensorProviderRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!WebSensorProviderPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          WebSensorProviderPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!WebSensorProviderPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !device_mojom_SensorType } type
   * @return {!Promise<{
        result: !device_mojom_SensorCreationResult,
        initParams: ?device_mojom_SensorInitParams,
   *  }>}
   */

  getSensor(
      type) {
    return this.proxy.sendMessage(
        0,
        WebSensorProvider_GetSensor_ParamsSpec.$,
        WebSensorProvider_GetSensor_ResponseParamsSpec.$,
        [
          type
        ],
        false);
  }
}

/**
 * An object which receives request messages for the WebSensorProvider
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class WebSensorProviderReceiver {
  /**
   * @param {!WebSensorProviderInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!WebSensorProviderRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        WebSensorProviderRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!WebSensorProviderRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        WebSensorProvider_GetSensor_ParamsSpec.$,
        WebSensorProvider_GetSensor_ResponseParamsSpec.$,
        impl.getSensor.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class WebSensorProvider {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.WebSensorProvider";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!WebSensorProviderRemote}
   */
  static getRemote() {
    let remote = new WebSensorProviderRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the WebSensorProvider
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class WebSensorProviderCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      WebSensorProviderRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!WebSensorProviderRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getSensor =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        WebSensorProvider_GetSensor_ParamsSpec.$,
        WebSensorProvider_GetSensor_ResponseParamsSpec.$,
        this.getSensor.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WebSensorProvider_GetSensor_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WebSensorProvider_GetSensor_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    WebSensorProvider_GetSensor_ParamsSpec.$,
    'WebSensorProvider_GetSensor_Params',
    [
      mojo.internal.StructField(
        'type', 0,
        0,
        device_mojom_SensorTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class WebSensorProvider_GetSensor_Params {
  constructor() {
    /** @type { !device_mojom_SensorType } */
    this.type;
  }
}



mojo.internal.Struct(
    WebSensorProvider_GetSensor_ResponseParamsSpec.$,
    'WebSensorProvider_GetSensor_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        device_mojom_SensorCreationResultSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'initParams', 8,
        0,
        device_mojom_SensorInitParamsSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class WebSensorProvider_GetSensor_ResponseParams {
  constructor() {
    /** @type { !device_mojom_SensorCreationResult } */
    this.result;
    /** @type { (device_mojom_SensorInitParams|undefined) } */
    this.initParams;
  }
}

