// third_party/blink/public/mojom/scroll/scroll_into_view_params.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_SCROLL_SCROLL_INTO_VIEW_PARAMS_MOJOM_SHARED_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_SCROLL_SCROLL_INTO_VIEW_PARAMS_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/scroll/scroll_into_view_params.mojom-shared-internal.h"
#include "third_party/blink/public/mojom/scroll/scroll_enums.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"




#include "third_party/blink/public/mojom/scroll/scroll_into_view_params.mojom-data-view.h"
#include "base/component_export.h"




namespace std {

template <>
struct hash<::blink::mojom::ScrollAlignment_Behavior>
    : public mojo::internal::EnumHashImpl<::blink::mojom::ScrollAlignment_Behavior> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::ScrollAlignment_Behavior, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::ScrollAlignment_Behavior, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::ScrollAlignment_Behavior>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::ScrollAlignmentDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::ScrollAlignmentDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::ScrollAlignment_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    
    mojo::internal::Serialize<::blink::mojom::ScrollAlignment_Behavior>(
      Traits::rect_visible(input),
      &fragment->rect_visible);

    
    mojo::internal::Serialize<::blink::mojom::ScrollAlignment_Behavior>(
      Traits::rect_hidden(input),
      &fragment->rect_hidden);

    
    mojo::internal::Serialize<::blink::mojom::ScrollAlignment_Behavior>(
      Traits::rect_partial(input),
      &fragment->rect_partial);
  }

  static bool Deserialize(::blink::mojom::internal::ScrollAlignment_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::ScrollAlignmentDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::FocusedEditableParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::FocusedEditableParamsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::FocusedEditableParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::relative_location(input)) in_relative_location = Traits::relative_location(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->relative_location)::BaseType> relative_location_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::Vector2dFDataView>(
      in_relative_location,
      relative_location_fragment);

    fragment->relative_location.Set(
        relative_location_fragment.is_null() ? nullptr : relative_location_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->relative_location.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null relative_location in FocusedEditableParams struct");

    decltype(Traits::size(input)) in_size = Traits::size(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->size)::BaseType> size_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::SizeFDataView>(
      in_size,
      size_fragment);

    fragment->size.Set(
        size_fragment.is_null() ? nullptr : size_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->size.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null size in FocusedEditableParams struct");

    fragment->can_zoom = Traits::can_zoom(input);
  }

  static bool Deserialize(::blink::mojom::internal::FocusedEditableParams_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::FocusedEditableParamsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::ScrollIntoViewParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::ScrollIntoViewParamsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::ScrollIntoViewParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::align_x(input)) in_align_x = Traits::align_x(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->align_x)::BaseType> align_x_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::ScrollAlignmentDataView>(
      in_align_x,
      align_x_fragment);

    fragment->align_x.Set(
        align_x_fragment.is_null() ? nullptr : align_x_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->align_x.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null align_x in ScrollIntoViewParams struct");

    decltype(Traits::align_y(input)) in_align_y = Traits::align_y(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->align_y)::BaseType> align_y_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::ScrollAlignmentDataView>(
      in_align_y,
      align_y_fragment);

    fragment->align_y.Set(
        align_y_fragment.is_null() ? nullptr : align_y_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->align_y.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null align_y in ScrollIntoViewParams struct");

    
    mojo::internal::Serialize<::blink::mojom::ScrollType>(
      Traits::type(input),
      &fragment->type);

    fragment->make_visible_in_visual_viewport = Traits::make_visible_in_visual_viewport(input);

    
    mojo::internal::Serialize<::blink::mojom::ScrollBehavior>(
      Traits::behavior(input),
      &fragment->behavior);

    fragment->is_for_scroll_sequence = Traits::is_for_scroll_sequence(input);

    decltype(Traits::for_focused_editable(input)) in_for_focused_editable = Traits::for_focused_editable(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->for_focused_editable)::BaseType> for_focused_editable_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::FocusedEditableParamsDataView>(
      in_for_focused_editable,
      for_focused_editable_fragment);

    fragment->for_focused_editable.Set(
        for_focused_editable_fragment.is_null() ? nullptr : for_focused_editable_fragment.data());

    fragment->cross_origin_boundaries = Traits::cross_origin_boundaries(input);
  }

  static bool Deserialize(::blink::mojom::internal::ScrollIntoViewParams_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::ScrollIntoViewParamsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace blink::mojom {



inline void FocusedEditableParamsDataView::GetRelativeLocationDataView(
    ::gfx::mojom::Vector2dFDataView* output) {
  auto pointer = data_->relative_location.Get();
  *output = ::gfx::mojom::Vector2dFDataView(pointer, message_);
}
inline void FocusedEditableParamsDataView::GetSizeDataView(
    ::gfx::mojom::SizeFDataView* output) {
  auto pointer = data_->size.Get();
  *output = ::gfx::mojom::SizeFDataView(pointer, message_);
}


inline void ScrollIntoViewParamsDataView::GetAlignXDataView(
    ScrollAlignmentDataView* output) {
  auto pointer = data_->align_x.Get();
  *output = ScrollAlignmentDataView(pointer, message_);
}
inline void ScrollIntoViewParamsDataView::GetAlignYDataView(
    ScrollAlignmentDataView* output) {
  auto pointer = data_->align_y.Get();
  *output = ScrollAlignmentDataView(pointer, message_);
}
inline void ScrollIntoViewParamsDataView::GetForFocusedEditableDataView(
    FocusedEditableParamsDataView* output) {
  auto pointer = data_->for_focused_editable.Get();
  *output = FocusedEditableParamsDataView(pointer, message_);
}



}  // blink::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::ScrollAlignment_Behavior> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::ScrollAlignment_Behavior value);
};

} // namespace perfetto

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_SCROLL_SCROLL_INTO_VIEW_PARAMS_MOJOM_SHARED_H_