// third_party/blink/public/mojom/scroll/scroll_into_view_params.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_SCROLL_SCROLL_INTO_VIEW_PARAMS_MOJOM_DATA_VIEW_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_SCROLL_SCROLL_INTO_VIEW_PARAMS_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/blink/public/mojom/scroll/scroll_into_view_params.mojom-shared-internal.h"
#include "third_party/blink/public/mojom/scroll/scroll_enums.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"


namespace blink::mojom {
class ScrollAlignmentDataView;

class FocusedEditableParamsDataView;

class ScrollIntoViewParamsDataView;



}  // blink::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::ScrollAlignmentDataView> {
  using Data = ::blink::mojom::internal::ScrollAlignment_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::FocusedEditableParamsDataView> {
  using Data = ::blink::mojom::internal::FocusedEditableParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::ScrollIntoViewParamsDataView> {
  using Data = ::blink::mojom::internal::ScrollIntoViewParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace blink::mojom {


enum class ScrollAlignment_Behavior : int32_t {
  
  kNoScroll = 0,
  
  kCenter = 1,
  
  kTop = 2,
  
  kBottom = 3,
  
  kLeft = 4,
  
  kRight = 5,
  
  kClosestEdge = 6,
  kMinValue = 0,
  kMaxValue = 6,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, ScrollAlignment_Behavior value);
inline bool IsKnownEnumValue(ScrollAlignment_Behavior value) {
  return internal::ScrollAlignment_Behavior_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class ScrollAlignmentDataView {
 public:
  ScrollAlignmentDataView() = default;

  ScrollAlignmentDataView(
      internal::ScrollAlignment_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadRectVisible(UserType* output) const {
    auto data_value = data_->rect_visible;
    return mojo::internal::Deserialize<::blink::mojom::ScrollAlignment_Behavior>(
        data_value, output);
  }
  ScrollAlignment_Behavior rect_visible() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::ScrollAlignment_Behavior>(data_->rect_visible));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadRectHidden(UserType* output) const {
    auto data_value = data_->rect_hidden;
    return mojo::internal::Deserialize<::blink::mojom::ScrollAlignment_Behavior>(
        data_value, output);
  }
  ScrollAlignment_Behavior rect_hidden() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::ScrollAlignment_Behavior>(data_->rect_hidden));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadRectPartial(UserType* output) const {
    auto data_value = data_->rect_partial;
    return mojo::internal::Deserialize<::blink::mojom::ScrollAlignment_Behavior>(
        data_value, output);
  }
  ScrollAlignment_Behavior rect_partial() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::ScrollAlignment_Behavior>(data_->rect_partial));
  }
 private:
  internal::ScrollAlignment_Data* data_ = nullptr;
};


class FocusedEditableParamsDataView {
 public:
  FocusedEditableParamsDataView() = default;

  FocusedEditableParamsDataView(
      internal::FocusedEditableParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetRelativeLocationDataView(
      ::gfx::mojom::Vector2dFDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRelativeLocation(UserType* output) {
    
    auto* pointer = data_->relative_location.Get();
    return mojo::internal::Deserialize<::gfx::mojom::Vector2dFDataView>(
        pointer, output, message_);
  }
  inline void GetSizeDataView(
      ::gfx::mojom::SizeFDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSize(UserType* output) {
    
    auto* pointer = data_->size.Get();
    return mojo::internal::Deserialize<::gfx::mojom::SizeFDataView>(
        pointer, output, message_);
  }
  bool can_zoom() const {
    return data_->can_zoom;
  }
 private:
  internal::FocusedEditableParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ScrollIntoViewParamsDataView {
 public:
  ScrollIntoViewParamsDataView() = default;

  ScrollIntoViewParamsDataView(
      internal::ScrollIntoViewParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetAlignXDataView(
      ScrollAlignmentDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAlignX(UserType* output) {
    
    auto* pointer = data_->align_x.Get();
    return mojo::internal::Deserialize<::blink::mojom::ScrollAlignmentDataView>(
        pointer, output, message_);
  }
  inline void GetAlignYDataView(
      ScrollAlignmentDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAlignY(UserType* output) {
    
    auto* pointer = data_->align_y.Get();
    return mojo::internal::Deserialize<::blink::mojom::ScrollAlignmentDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadType(UserType* output) const {
    auto data_value = data_->type;
    return mojo::internal::Deserialize<::blink::mojom::ScrollType>(
        data_value, output);
  }
  ::blink::mojom::ScrollType type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::ScrollType>(data_->type));
  }
  bool make_visible_in_visual_viewport() const {
    return data_->make_visible_in_visual_viewport;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadBehavior(UserType* output) const {
    auto data_value = data_->behavior;
    return mojo::internal::Deserialize<::blink::mojom::ScrollBehavior>(
        data_value, output);
  }
  ::blink::mojom::ScrollBehavior behavior() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::ScrollBehavior>(data_->behavior));
  }
  bool is_for_scroll_sequence() const {
    return data_->is_for_scroll_sequence;
  }
  inline void GetForFocusedEditableDataView(
      FocusedEditableParamsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadForFocusedEditable(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::FocusedEditableParamsDataView, UserType>(),
    "Attempting to read the optional `for_focused_editable` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadForFocusedEditable` instead "
    "of `ReadForFocusedEditable if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->for_focused_editable.Get();
    return mojo::internal::Deserialize<::blink::mojom::FocusedEditableParamsDataView>(
        pointer, output, message_);
  }
  bool cross_origin_boundaries() const {
    return data_->cross_origin_boundaries;
  }
 private:
  internal::ScrollIntoViewParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // blink::mojom

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_SCROLL_SCROLL_INTO_VIEW_PARAMS_MOJOM_DATA_VIEW_H_