// third_party/blink/public/mojom/safe_url_pattern.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'third_party/blink/public/mojom/safe_url_pattern.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('blink.mojom');


  var Modifier = {};
  Modifier.kZeroOrMore = 0;
  Modifier.kOptional = 1;
  Modifier.kOneOrMore = 2;
  Modifier.kNone = 3;
  Modifier.MIN_VALUE = 0;
  Modifier.MAX_VALUE = 3;

  Modifier.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
      return true;
    }
    return false;
  };

  Modifier.toKnownEnumValue = function(value) {
    return value;
  };

  Modifier.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  function SafeUrlPattern(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SafeUrlPattern.prototype.initDefaults_ = function() {
    this.protocol = null;
    this.username = null;
    this.password = null;
    this.hostname = null;
    this.port = null;
    this.pathname = null;
    this.search = null;
    this.hash = null;
    this.options = null;
  };
  SafeUrlPattern.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SafeUrlPattern.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 80}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SafeUrlPattern.protocol
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, new codec.PointerTo(SafeUrlPatternPart), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SafeUrlPattern.username
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 8, 8, new codec.PointerTo(SafeUrlPatternPart), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SafeUrlPattern.password
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 16, 8, new codec.PointerTo(SafeUrlPatternPart), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SafeUrlPattern.hostname
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 24, 8, new codec.PointerTo(SafeUrlPatternPart), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SafeUrlPattern.port
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 32, 8, new codec.PointerTo(SafeUrlPatternPart), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SafeUrlPattern.pathname
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 40, 8, new codec.PointerTo(SafeUrlPatternPart), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SafeUrlPattern.search
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 48, 8, new codec.PointerTo(SafeUrlPatternPart), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SafeUrlPattern.hash
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 56, 8, new codec.PointerTo(SafeUrlPatternPart), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SafeUrlPattern.options
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 64, SafeUrlPatternOptions, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SafeUrlPattern.encodedSize = codec.kStructHeaderSize + 72;

  SafeUrlPattern.decode = function(decoder) {
    var packed;
    var val = new SafeUrlPattern();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.protocol =
        decoder.decodeArrayPointer(new codec.PointerTo(SafeUrlPatternPart));
    val.username =
        decoder.decodeArrayPointer(new codec.PointerTo(SafeUrlPatternPart));
    val.password =
        decoder.decodeArrayPointer(new codec.PointerTo(SafeUrlPatternPart));
    val.hostname =
        decoder.decodeArrayPointer(new codec.PointerTo(SafeUrlPatternPart));
    val.port =
        decoder.decodeArrayPointer(new codec.PointerTo(SafeUrlPatternPart));
    val.pathname =
        decoder.decodeArrayPointer(new codec.PointerTo(SafeUrlPatternPart));
    val.search =
        decoder.decodeArrayPointer(new codec.PointerTo(SafeUrlPatternPart));
    val.hash =
        decoder.decodeArrayPointer(new codec.PointerTo(SafeUrlPatternPart));
    val.options =
        decoder.decodeStructPointer(SafeUrlPatternOptions);
    return val;
  };

  SafeUrlPattern.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SafeUrlPattern.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(new codec.PointerTo(SafeUrlPatternPart), val.protocol);
    encoder.encodeArrayPointer(new codec.PointerTo(SafeUrlPatternPart), val.username);
    encoder.encodeArrayPointer(new codec.PointerTo(SafeUrlPatternPart), val.password);
    encoder.encodeArrayPointer(new codec.PointerTo(SafeUrlPatternPart), val.hostname);
    encoder.encodeArrayPointer(new codec.PointerTo(SafeUrlPatternPart), val.port);
    encoder.encodeArrayPointer(new codec.PointerTo(SafeUrlPatternPart), val.pathname);
    encoder.encodeArrayPointer(new codec.PointerTo(SafeUrlPatternPart), val.search);
    encoder.encodeArrayPointer(new codec.PointerTo(SafeUrlPatternPart), val.hash);
    encoder.encodeStructPointer(SafeUrlPatternOptions, val.options);
  };
  function FixedPattern(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FixedPattern.prototype.initDefaults_ = function() {
    this.value = null;
  };
  FixedPattern.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FixedPattern.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FixedPattern.value
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FixedPattern.encodedSize = codec.kStructHeaderSize + 8;

  FixedPattern.decode = function(decoder) {
    var packed;
    var val = new FixedPattern();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.value =
        decoder.decodeStruct(codec.String);
    return val;
  };

  FixedPattern.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FixedPattern.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.value);
  };
  function WildcardPattern(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WildcardPattern.prototype.initDefaults_ = function() {
    this.name = null;
    this.prefix = null;
    this.value = null;
    this.suffix = null;
  };
  WildcardPattern.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WildcardPattern.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 40}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WildcardPattern.name
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate WildcardPattern.prefix
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate WildcardPattern.value
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 16, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate WildcardPattern.suffix
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 24, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  WildcardPattern.encodedSize = codec.kStructHeaderSize + 32;

  WildcardPattern.decode = function(decoder) {
    var packed;
    var val = new WildcardPattern();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.name =
        decoder.decodeStruct(codec.String);
    val.prefix =
        decoder.decodeStruct(codec.String);
    val.value =
        decoder.decodeStruct(codec.String);
    val.suffix =
        decoder.decodeStruct(codec.String);
    return val;
  };

  WildcardPattern.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WildcardPattern.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.name);
    encoder.encodeStruct(codec.String, val.prefix);
    encoder.encodeStruct(codec.String, val.value);
    encoder.encodeStruct(codec.String, val.suffix);
  };
  function SafeUrlPatternPart(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SafeUrlPatternPart.prototype.initDefaults_ = function() {
    this.pattern = null;
    this.modifier = 0;
  };
  SafeUrlPatternPart.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SafeUrlPatternPart.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SafeUrlPatternPart.pattern
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 0, PatternTemplate, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SafeUrlPatternPart.modifier
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 16, Modifier);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SafeUrlPatternPart.encodedSize = codec.kStructHeaderSize + 24;

  SafeUrlPatternPart.decode = function(decoder) {
    var packed;
    var val = new SafeUrlPatternPart();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.pattern =
        decoder.decodeStruct(PatternTemplate);
    val.modifier =
        decoder.decodeStruct(new codec.Enum(Modifier));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  SafeUrlPatternPart.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SafeUrlPatternPart.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(PatternTemplate, val.pattern);
    encoder.encodeStruct(codec.Int32, val.modifier);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function SafeUrlPatternOptions(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SafeUrlPatternOptions.prototype.initDefaults_ = function() {
    this.ignoreCase = false;
  };
  SafeUrlPatternOptions.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SafeUrlPatternOptions.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  SafeUrlPatternOptions.encodedSize = codec.kStructHeaderSize + 8;

  SafeUrlPatternOptions.decode = function(decoder) {
    var packed;
    var val = new SafeUrlPatternOptions();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.ignoreCase = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  SafeUrlPatternOptions.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SafeUrlPatternOptions.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.ignoreCase & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };

  function PatternTemplate(value) {
    this.initDefault_();
    this.initValue_(value);
  }


  PatternTemplate.Tags = {
    fixed: 0,
    fullWildcard: 1,
    segmentWildcard: 2,
  };

  PatternTemplate.prototype.initDefault_ = function() {
    this.$data = null;
    this.$tag = undefined;
  }

  PatternTemplate.prototype.initValue_ = function(value) {
    if (value == undefined) {
      return;
    }

    var keys = Object.keys(value);
    if (keys.length == 0) {
      return;
    }

    if (keys.length > 1) {
      throw new TypeError("You may set only one member on a union.");
    }

    var fields = [
        "fixed",
        "fullWildcard",
        "segmentWildcard",
    ];

    if (fields.indexOf(keys[0]) < 0) {
      throw new ReferenceError(keys[0] + " is not a PatternTemplate member.");

    }

    this[keys[0]] = value[keys[0]];
  }
  Object.defineProperty(PatternTemplate.prototype, "fixed", {
    get: function() {
      if (this.$tag != PatternTemplate.Tags.fixed) {
        throw new ReferenceError(
            "PatternTemplate.fixed is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = PatternTemplate.Tags.fixed;
      this.$data = value;
    }
  });
  Object.defineProperty(PatternTemplate.prototype, "fullWildcard", {
    get: function() {
      if (this.$tag != PatternTemplate.Tags.fullWildcard) {
        throw new ReferenceError(
            "PatternTemplate.fullWildcard is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = PatternTemplate.Tags.fullWildcard;
      this.$data = value;
    }
  });
  Object.defineProperty(PatternTemplate.prototype, "segmentWildcard", {
    get: function() {
      if (this.$tag != PatternTemplate.Tags.segmentWildcard) {
        throw new ReferenceError(
            "PatternTemplate.segmentWildcard is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = PatternTemplate.Tags.segmentWildcard;
      this.$data = value;
    }
  });


    PatternTemplate.encode = function(encoder, val) {
      if (val == null) {
        encoder.writeUint64(0);
        encoder.writeUint64(0);
        return;
      }
      if (val.$tag == undefined) {
        throw new TypeError("Cannot encode unions with an unknown member set.");
      }

      encoder.writeUint32(16);
      encoder.writeUint32(val.$tag);
      switch (val.$tag) {
        case PatternTemplate.Tags.fixed:
          encoder.encodeStructPointer(FixedPattern, val.fixed);
          break;
        case PatternTemplate.Tags.fullWildcard:
          encoder.encodeStructPointer(WildcardPattern, val.fullWildcard);
          break;
        case PatternTemplate.Tags.segmentWildcard:
          encoder.encodeStructPointer(WildcardPattern, val.segmentWildcard);
          break;
      }
      encoder.align();
    };


    PatternTemplate.decode = function(decoder) {
      var size = decoder.readUint32();
      if (size == 0) {
        decoder.readUint32();
        decoder.readUint64();
        return null;
      }

      var result = new PatternTemplate();
      var tag = decoder.readUint32();
      switch (tag) {
        case PatternTemplate.Tags.fixed:
          result.fixed = decoder.decodeStructPointer(FixedPattern);
          break;
        case PatternTemplate.Tags.fullWildcard:
          result.fullWildcard = decoder.decodeStructPointer(WildcardPattern);
          break;
        case PatternTemplate.Tags.segmentWildcard:
          result.segmentWildcard = decoder.decodeStructPointer(WildcardPattern);
          break;
      }
      decoder.align();

      return result;
    };


    PatternTemplate.validate = function(messageValidator, offset) {
      var size = messageValidator.decodeUnionSize(offset);
      if (size != 16) {
        return validator.validationError.INVALID_UNION_SIZE;
      }

      var tag = messageValidator.decodeUnionTag(offset);
      var data_offset = offset + 8;
      var err;
      switch (tag) {
        case PatternTemplate.Tags.fixed:
          

    // validate PatternTemplate.fixed
    err = messageValidator.validateStructPointer(data_offset, FixedPattern, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case PatternTemplate.Tags.fullWildcard:
          

    // validate PatternTemplate.fullWildcard
    err = messageValidator.validateStructPointer(data_offset, WildcardPattern, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case PatternTemplate.Tags.segmentWildcard:
          

    // validate PatternTemplate.segmentWildcard
    err = messageValidator.validateStructPointer(data_offset, WildcardPattern, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
      }

      return validator.validationError.NONE;
    };

  PatternTemplate.encodedSize = 16;
  exports.Modifier = Modifier;
  exports.SafeUrlPattern = SafeUrlPattern;
  exports.FixedPattern = FixedPattern;
  exports.WildcardPattern = WildcardPattern;
  exports.SafeUrlPatternPart = SafeUrlPatternPart;
  exports.SafeUrlPatternOptions = SafeUrlPatternOptions;
  exports.PatternTemplate = PatternTemplate;
})();