// third_party/blink/public/mojom/safe_url_pattern.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_SAFE_URL_PATTERN_MOJOM_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_SAFE_URL_PATTERN_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/safe_url_pattern.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/safe_url_pattern.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/safe_url_pattern.mojom-forward.h"  // IWYU pragma: export
#include <string>
#include <vector>




#include "third_party/blink/public/common/safe_url_pattern_mojom_traits.h"
#include "third_party/blink/public/common/common_export.h"




namespace blink::mojom {






class BLINK_COMMON_EXPORT FixedPattern {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<FixedPattern, T>::value>;
  using DataView = FixedPatternDataView;
  using Data_ = internal::FixedPattern_Data;

  template <typename... Args>
  static FixedPatternPtr New(Args&&... args) {
    return FixedPatternPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static FixedPatternPtr From(const U& u) {
    return mojo::TypeConverter<FixedPatternPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, FixedPattern>::Convert(*this);
  }


  FixedPattern();

  explicit FixedPattern(
      const std::string& value);


  ~FixedPattern();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = FixedPatternPtr>
  FixedPatternPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, FixedPattern::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, FixedPattern::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, FixedPattern::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FixedPattern::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FixedPattern::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        FixedPattern::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::FixedPattern_UnserializedMessageContext<
            UserType, FixedPattern::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<FixedPattern::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return FixedPattern::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::FixedPattern_UnserializedMessageContext<
            UserType, FixedPattern::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<FixedPattern::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string value;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, FixedPattern::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, FixedPattern::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, FixedPattern::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, FixedPattern::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_COMMON_EXPORT WildcardPattern {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<WildcardPattern, T>::value>;
  using DataView = WildcardPatternDataView;
  using Data_ = internal::WildcardPattern_Data;

  template <typename... Args>
  static WildcardPatternPtr New(Args&&... args) {
    return WildcardPatternPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static WildcardPatternPtr From(const U& u) {
    return mojo::TypeConverter<WildcardPatternPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, WildcardPattern>::Convert(*this);
  }


  WildcardPattern();

  WildcardPattern(
      const std::string& name,
      const std::string& prefix,
      const std::string& value,
      const std::string& suffix);


  ~WildcardPattern();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = WildcardPatternPtr>
  WildcardPatternPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, WildcardPattern::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, WildcardPattern::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, WildcardPattern::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        WildcardPattern::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        WildcardPattern::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        WildcardPattern::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::WildcardPattern_UnserializedMessageContext<
            UserType, WildcardPattern::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<WildcardPattern::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return WildcardPattern::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::WildcardPattern_UnserializedMessageContext<
            UserType, WildcardPattern::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<WildcardPattern::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string name;
  
  std::string prefix;
  
  std::string value;
  
  std::string suffix;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, WildcardPattern::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, WildcardPattern::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, WildcardPattern::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, WildcardPattern::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class BLINK_COMMON_EXPORT SafeUrlPatternOptions {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SafeUrlPatternOptions, T>::value>;
  using DataView = SafeUrlPatternOptionsDataView;
  using Data_ = internal::SafeUrlPatternOptions_Data;

  template <typename... Args>
  static SafeUrlPatternOptionsPtr New(Args&&... args) {
    return SafeUrlPatternOptionsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SafeUrlPatternOptionsPtr From(const U& u) {
    return mojo::TypeConverter<SafeUrlPatternOptionsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SafeUrlPatternOptions>::Convert(*this);
  }


  SafeUrlPatternOptions();

  explicit SafeUrlPatternOptions(
      bool ignore_case);


  ~SafeUrlPatternOptions();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SafeUrlPatternOptionsPtr>
  SafeUrlPatternOptionsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SafeUrlPatternOptions::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SafeUrlPatternOptions::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SafeUrlPatternOptions::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SafeUrlPatternOptions::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SafeUrlPatternOptions::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SafeUrlPatternOptions::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SafeUrlPatternOptions_UnserializedMessageContext<
            UserType, SafeUrlPatternOptions::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SafeUrlPatternOptions::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SafeUrlPatternOptions::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SafeUrlPatternOptions_UnserializedMessageContext<
            UserType, SafeUrlPatternOptions::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SafeUrlPatternOptions::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  bool ignore_case;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SafeUrlPatternOptions::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SafeUrlPatternOptions::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SafeUrlPatternOptions::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SafeUrlPatternOptions::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_COMMON_EXPORT PatternTemplate {
 public:
  using DataView = PatternTemplateDataView;
  using Data_ = internal::PatternTemplate_Data;
  using Tag = Data_::PatternTemplate_Tag;

  template <typename... Args>
  static PatternTemplatePtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |fixed|.
  static PatternTemplatePtr NewFixed(
      const ::liburlpattern::Part& value);
  // Construct an instance holding |full_wildcard|.
  static PatternTemplatePtr NewFullWildcard(
      const ::liburlpattern::Part& value);
  // Construct an instance holding |segment_wildcard|.
  static PatternTemplatePtr NewSegmentWildcard(
      const ::liburlpattern::Part& value);

  template <typename U>
  static PatternTemplatePtr From(const U& u) {
    return mojo::TypeConverter<PatternTemplatePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PatternTemplate>::Convert(*this);
  }
  ~PatternTemplate();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  PatternTemplate(const PatternTemplate& other) = delete;
  PatternTemplate& operator=(const PatternTemplate& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = PatternTemplatePtr>
  PatternTemplatePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, PatternTemplate>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, PatternTemplate>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }

  bool is_fixed() const { return tag_ == Tag::kFixed; }
  const ::liburlpattern::Part& get_fixed() const {
    CHECK(tag_ == Tag::kFixed);
    return data_.fixed;
  }
  ::liburlpattern::Part& get_fixed() {
    CHECK(tag_ == Tag::kFixed);
    return data_.fixed;
  }
  void set_fixed(const ::liburlpattern::Part& fixed);

  bool is_full_wildcard() const { return tag_ == Tag::kFullWildcard; }
  const ::liburlpattern::Part& get_full_wildcard() const {
    CHECK(tag_ == Tag::kFullWildcard);
    return data_.full_wildcard;
  }
  ::liburlpattern::Part& get_full_wildcard() {
    CHECK(tag_ == Tag::kFullWildcard);
    return data_.full_wildcard;
  }
  void set_full_wildcard(const ::liburlpattern::Part& full_wildcard);

  bool is_segment_wildcard() const { return tag_ == Tag::kSegmentWildcard; }
  const ::liburlpattern::Part& get_segment_wildcard() const {
    CHECK(tag_ == Tag::kSegmentWildcard);
    return data_.segment_wildcard;
  }
  ::liburlpattern::Part& get_segment_wildcard() {
    CHECK(tag_ == Tag::kSegmentWildcard);
    return data_.segment_wildcard;
  }
  void set_segment_wildcard(const ::liburlpattern::Part& segment_wildcard);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PatternTemplate::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<PatternTemplate::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kFixed)>,
        const ::liburlpattern::Part& value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kFullWildcard)>,
        const ::liburlpattern::Part& value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kSegmentWildcard)>,
        const ::liburlpattern::Part& value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    ::liburlpattern::Part fixed;
    ::liburlpattern::Part full_wildcard;
    ::liburlpattern::Part segment_wildcard;
  };

  PatternTemplate(
      std::in_place_index_t<static_cast<size_t>(Tag::kFixed)>,
      const ::liburlpattern::Part& value);
  PatternTemplate(
      std::in_place_index_t<static_cast<size_t>(Tag::kFullWildcard)>,
      const ::liburlpattern::Part& value);
  PatternTemplate(
      std::in_place_index_t<static_cast<size_t>(Tag::kSegmentWildcard)>,
      const ::liburlpattern::Part& value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};





class BLINK_COMMON_EXPORT SafeUrlPattern {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SafeUrlPattern, T>::value>;
  using DataView = SafeUrlPatternDataView;
  using Data_ = internal::SafeUrlPattern_Data;

  template <typename... Args>
  static SafeUrlPatternPtr New(Args&&... args) {
    return SafeUrlPatternPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SafeUrlPatternPtr From(const U& u) {
    return mojo::TypeConverter<SafeUrlPatternPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SafeUrlPattern>::Convert(*this);
  }


  SafeUrlPattern();

  SafeUrlPattern(
      std::vector<SafeUrlPatternPartPtr> protocol,
      std::vector<SafeUrlPatternPartPtr> username,
      std::vector<SafeUrlPatternPartPtr> password,
      std::vector<SafeUrlPatternPartPtr> hostname,
      std::vector<SafeUrlPatternPartPtr> port,
      std::vector<SafeUrlPatternPartPtr> pathname,
      std::vector<SafeUrlPatternPartPtr> search,
      std::vector<SafeUrlPatternPartPtr> hash,
      SafeUrlPatternOptionsPtr options);

SafeUrlPattern(const SafeUrlPattern&) = delete;
SafeUrlPattern& operator=(const SafeUrlPattern&) = delete;

  ~SafeUrlPattern();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SafeUrlPatternPtr>
  SafeUrlPatternPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SafeUrlPattern::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SafeUrlPattern::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SafeUrlPattern::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SafeUrlPattern::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SafeUrlPattern::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SafeUrlPattern::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SafeUrlPattern_UnserializedMessageContext<
            UserType, SafeUrlPattern::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SafeUrlPattern::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SafeUrlPattern::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SafeUrlPattern_UnserializedMessageContext<
            UserType, SafeUrlPattern::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SafeUrlPattern::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::vector<SafeUrlPatternPartPtr> protocol;
  
  std::vector<SafeUrlPatternPartPtr> username;
  
  std::vector<SafeUrlPatternPartPtr> password;
  
  std::vector<SafeUrlPatternPartPtr> hostname;
  
  std::vector<SafeUrlPatternPartPtr> port;
  
  std::vector<SafeUrlPatternPartPtr> pathname;
  
  std::vector<SafeUrlPatternPartPtr> search;
  
  std::vector<SafeUrlPatternPartPtr> hash;
  
  SafeUrlPatternOptionsPtr options;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SafeUrlPattern::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SafeUrlPattern::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SafeUrlPattern::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SafeUrlPattern::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}







class BLINK_COMMON_EXPORT SafeUrlPatternPart {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SafeUrlPatternPart, T>::value>;
  using DataView = SafeUrlPatternPartDataView;
  using Data_ = internal::SafeUrlPatternPart_Data;

  template <typename... Args>
  static SafeUrlPatternPartPtr New(Args&&... args) {
    return SafeUrlPatternPartPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SafeUrlPatternPartPtr From(const U& u) {
    return mojo::TypeConverter<SafeUrlPatternPartPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SafeUrlPatternPart>::Convert(*this);
  }


  SafeUrlPatternPart();

  SafeUrlPatternPart(
      const ::liburlpattern::Part& pattern,
      ::liburlpattern::Modifier modifier);


  ~SafeUrlPatternPart();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SafeUrlPatternPartPtr>
  SafeUrlPatternPartPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SafeUrlPatternPart::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SafeUrlPatternPart::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SafeUrlPatternPart::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SafeUrlPatternPart::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SafeUrlPatternPart::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SafeUrlPatternPart::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SafeUrlPatternPart_UnserializedMessageContext<
            UserType, SafeUrlPatternPart::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SafeUrlPatternPart::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SafeUrlPatternPart::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SafeUrlPatternPart_UnserializedMessageContext<
            UserType, SafeUrlPatternPart::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SafeUrlPatternPart::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::liburlpattern::Part pattern;
  
  ::liburlpattern::Modifier modifier;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SafeUrlPatternPart::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SafeUrlPatternPart::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SafeUrlPatternPart::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SafeUrlPatternPart::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}


template <typename UnionPtrType>
PatternTemplatePtr PatternTemplate::Clone() const {
  switch (tag_) {
    case Tag::kFixed:
      return NewFixed(
          mojo::Clone(data_.fixed));
    case Tag::kFullWildcard:
      return NewFullWildcard(
          mojo::Clone(data_.full_wildcard));
    case Tag::kSegmentWildcard:
      return NewSegmentWildcard(
          mojo::Clone(data_.segment_wildcard));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, PatternTemplate>::value>::type*>
bool PatternTemplate::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kFixed:
      return mojo::Equals(data_.fixed, other.data_.fixed);
    case Tag::kFullWildcard:
      return mojo::Equals(data_.full_wildcard, other.data_.full_wildcard);
    case Tag::kSegmentWildcard:
      return mojo::Equals(data_.segment_wildcard, other.data_.segment_wildcard);
  }

  return false;
}
template <typename StructPtrType>
SafeUrlPatternPtr SafeUrlPattern::Clone() const {
  return New(
      mojo::Clone(protocol),
      mojo::Clone(username),
      mojo::Clone(password),
      mojo::Clone(hostname),
      mojo::Clone(port),
      mojo::Clone(pathname),
      mojo::Clone(search),
      mojo::Clone(hash),
      mojo::Clone(options)
  );
}

template <typename T, SafeUrlPattern::EnableIfSame<T>*>
bool SafeUrlPattern::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->protocol, other_struct.protocol))
    return false;
  if (!mojo::Equals(this->username, other_struct.username))
    return false;
  if (!mojo::Equals(this->password, other_struct.password))
    return false;
  if (!mojo::Equals(this->hostname, other_struct.hostname))
    return false;
  if (!mojo::Equals(this->port, other_struct.port))
    return false;
  if (!mojo::Equals(this->pathname, other_struct.pathname))
    return false;
  if (!mojo::Equals(this->search, other_struct.search))
    return false;
  if (!mojo::Equals(this->hash, other_struct.hash))
    return false;
  if (!mojo::Equals(this->options, other_struct.options))
    return false;
  return true;
}

template <typename T, SafeUrlPattern::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.protocol < rhs.protocol)
    return true;
  if (rhs.protocol < lhs.protocol)
    return false;
  if (lhs.username < rhs.username)
    return true;
  if (rhs.username < lhs.username)
    return false;
  if (lhs.password < rhs.password)
    return true;
  if (rhs.password < lhs.password)
    return false;
  if (lhs.hostname < rhs.hostname)
    return true;
  if (rhs.hostname < lhs.hostname)
    return false;
  if (lhs.port < rhs.port)
    return true;
  if (rhs.port < lhs.port)
    return false;
  if (lhs.pathname < rhs.pathname)
    return true;
  if (rhs.pathname < lhs.pathname)
    return false;
  if (lhs.search < rhs.search)
    return true;
  if (rhs.search < lhs.search)
    return false;
  if (lhs.hash < rhs.hash)
    return true;
  if (rhs.hash < lhs.hash)
    return false;
  if (lhs.options < rhs.options)
    return true;
  if (rhs.options < lhs.options)
    return false;
  return false;
}
template <typename StructPtrType>
FixedPatternPtr FixedPattern::Clone() const {
  return New(
      mojo::Clone(value)
  );
}

template <typename T, FixedPattern::EnableIfSame<T>*>
bool FixedPattern::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->value, other_struct.value))
    return false;
  return true;
}

template <typename T, FixedPattern::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.value < rhs.value)
    return true;
  if (rhs.value < lhs.value)
    return false;
  return false;
}
template <typename StructPtrType>
WildcardPatternPtr WildcardPattern::Clone() const {
  return New(
      mojo::Clone(name),
      mojo::Clone(prefix),
      mojo::Clone(value),
      mojo::Clone(suffix)
  );
}

template <typename T, WildcardPattern::EnableIfSame<T>*>
bool WildcardPattern::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->name, other_struct.name))
    return false;
  if (!mojo::Equals(this->prefix, other_struct.prefix))
    return false;
  if (!mojo::Equals(this->value, other_struct.value))
    return false;
  if (!mojo::Equals(this->suffix, other_struct.suffix))
    return false;
  return true;
}

template <typename T, WildcardPattern::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.name < rhs.name)
    return true;
  if (rhs.name < lhs.name)
    return false;
  if (lhs.prefix < rhs.prefix)
    return true;
  if (rhs.prefix < lhs.prefix)
    return false;
  if (lhs.value < rhs.value)
    return true;
  if (rhs.value < lhs.value)
    return false;
  if (lhs.suffix < rhs.suffix)
    return true;
  if (rhs.suffix < lhs.suffix)
    return false;
  return false;
}
template <typename StructPtrType>
SafeUrlPatternPartPtr SafeUrlPatternPart::Clone() const {
  return New(
      mojo::Clone(pattern),
      mojo::Clone(modifier)
  );
}

template <typename T, SafeUrlPatternPart::EnableIfSame<T>*>
bool SafeUrlPatternPart::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->pattern, other_struct.pattern))
    return false;
  if (!mojo::Equals(this->modifier, other_struct.modifier))
    return false;
  return true;
}

template <typename T, SafeUrlPatternPart::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.pattern < rhs.pattern)
    return true;
  if (rhs.pattern < lhs.pattern)
    return false;
  if (lhs.modifier < rhs.modifier)
    return true;
  if (rhs.modifier < lhs.modifier)
    return false;
  return false;
}
template <typename StructPtrType>
SafeUrlPatternOptionsPtr SafeUrlPatternOptions::Clone() const {
  return New(
      mojo::Clone(ignore_case)
  );
}

template <typename T, SafeUrlPatternOptions::EnableIfSame<T>*>
bool SafeUrlPatternOptions::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->ignore_case, other_struct.ignore_case))
    return false;
  return true;
}

template <typename T, SafeUrlPatternOptions::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.ignore_case < rhs.ignore_case)
    return true;
  if (rhs.ignore_case < lhs.ignore_case)
    return false;
  return false;
}


}  // blink::mojom

namespace mojo {


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::SafeUrlPattern::DataView,
                                         ::blink::mojom::SafeUrlPatternPtr> {
  static bool IsNull(const ::blink::mojom::SafeUrlPatternPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::SafeUrlPatternPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::SafeUrlPattern::protocol)& protocol(
      const ::blink::mojom::SafeUrlPatternPtr& input) {
    return input->protocol;
  }

  static const decltype(::blink::mojom::SafeUrlPattern::username)& username(
      const ::blink::mojom::SafeUrlPatternPtr& input) {
    return input->username;
  }

  static const decltype(::blink::mojom::SafeUrlPattern::password)& password(
      const ::blink::mojom::SafeUrlPatternPtr& input) {
    return input->password;
  }

  static const decltype(::blink::mojom::SafeUrlPattern::hostname)& hostname(
      const ::blink::mojom::SafeUrlPatternPtr& input) {
    return input->hostname;
  }

  static const decltype(::blink::mojom::SafeUrlPattern::port)& port(
      const ::blink::mojom::SafeUrlPatternPtr& input) {
    return input->port;
  }

  static const decltype(::blink::mojom::SafeUrlPattern::pathname)& pathname(
      const ::blink::mojom::SafeUrlPatternPtr& input) {
    return input->pathname;
  }

  static const decltype(::blink::mojom::SafeUrlPattern::search)& search(
      const ::blink::mojom::SafeUrlPatternPtr& input) {
    return input->search;
  }

  static const decltype(::blink::mojom::SafeUrlPattern::hash)& hash(
      const ::blink::mojom::SafeUrlPatternPtr& input) {
    return input->hash;
  }

  static const decltype(::blink::mojom::SafeUrlPattern::options)& options(
      const ::blink::mojom::SafeUrlPatternPtr& input) {
    return input->options;
  }

  static bool Read(::blink::mojom::SafeUrlPattern::DataView input, ::blink::mojom::SafeUrlPatternPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::FixedPattern::DataView,
                                         ::blink::mojom::FixedPatternPtr> {
  static bool IsNull(const ::blink::mojom::FixedPatternPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::FixedPatternPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::FixedPattern::value)& value(
      const ::blink::mojom::FixedPatternPtr& input) {
    return input->value;
  }

  static bool Read(::blink::mojom::FixedPattern::DataView input, ::blink::mojom::FixedPatternPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::WildcardPattern::DataView,
                                         ::blink::mojom::WildcardPatternPtr> {
  static bool IsNull(const ::blink::mojom::WildcardPatternPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::WildcardPatternPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::WildcardPattern::name)& name(
      const ::blink::mojom::WildcardPatternPtr& input) {
    return input->name;
  }

  static const decltype(::blink::mojom::WildcardPattern::prefix)& prefix(
      const ::blink::mojom::WildcardPatternPtr& input) {
    return input->prefix;
  }

  static const decltype(::blink::mojom::WildcardPattern::value)& value(
      const ::blink::mojom::WildcardPatternPtr& input) {
    return input->value;
  }

  static const decltype(::blink::mojom::WildcardPattern::suffix)& suffix(
      const ::blink::mojom::WildcardPatternPtr& input) {
    return input->suffix;
  }

  static bool Read(::blink::mojom::WildcardPattern::DataView input, ::blink::mojom::WildcardPatternPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::SafeUrlPatternPart::DataView,
                                         ::blink::mojom::SafeUrlPatternPartPtr> {
  static bool IsNull(const ::blink::mojom::SafeUrlPatternPartPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::SafeUrlPatternPartPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::SafeUrlPatternPart::pattern)& pattern(
      const ::blink::mojom::SafeUrlPatternPartPtr& input) {
    return input->pattern;
  }

  static decltype(::blink::mojom::SafeUrlPatternPart::modifier) modifier(
      const ::blink::mojom::SafeUrlPatternPartPtr& input) {
    return input->modifier;
  }

  static bool Read(::blink::mojom::SafeUrlPatternPart::DataView input, ::blink::mojom::SafeUrlPatternPartPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::SafeUrlPatternOptions::DataView,
                                         ::blink::mojom::SafeUrlPatternOptionsPtr> {
  static bool IsNull(const ::blink::mojom::SafeUrlPatternOptionsPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::SafeUrlPatternOptionsPtr* output) { output->reset(); }

  static decltype(::blink::mojom::SafeUrlPatternOptions::ignore_case) ignore_case(
      const ::blink::mojom::SafeUrlPatternOptionsPtr& input) {
    return input->ignore_case;
  }

  static bool Read(::blink::mojom::SafeUrlPatternOptions::DataView input, ::blink::mojom::SafeUrlPatternOptionsPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT UnionTraits<::blink::mojom::PatternTemplate::DataView,
                                        ::blink::mojom::PatternTemplatePtr> {
  static bool IsNull(const ::blink::mojom::PatternTemplatePtr& input) { return !input; }
  static void SetToNull(::blink::mojom::PatternTemplatePtr* output) { output->reset(); }

  static ::blink::mojom::PatternTemplate::Tag GetTag(const ::blink::mojom::PatternTemplatePtr& input) {
    return input->which();
  }

  static const ::liburlpattern::Part& fixed(const ::blink::mojom::PatternTemplatePtr& input) {
    return input->get_fixed();
  }

  static const ::liburlpattern::Part& full_wildcard(const ::blink::mojom::PatternTemplatePtr& input) {
    return input->get_full_wildcard();
  }

  static const ::liburlpattern::Part& segment_wildcard(const ::blink::mojom::PatternTemplatePtr& input) {
    return input->get_segment_wildcard();
  }

  static bool Read(::blink::mojom::PatternTemplate::DataView input, ::blink::mojom::PatternTemplatePtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_SAFE_URL_PATTERN_MOJOM_H_