// third_party/blink/public/mojom/safe_url_pattern.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_SAFE_URL_PATTERN_MOJOM_DATA_VIEW_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_SAFE_URL_PATTERN_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/blink/public/mojom/safe_url_pattern.mojom-shared-internal.h"


namespace blink::mojom {
class SafeUrlPatternDataView;

class FixedPatternDataView;

class WildcardPatternDataView;

class SafeUrlPatternPartDataView;

class SafeUrlPatternOptionsDataView;

class PatternTemplateDataView;


}  // blink::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::SafeUrlPatternDataView> {
  using Data = ::blink::mojom::internal::SafeUrlPattern_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::FixedPatternDataView> {
  using Data = ::blink::mojom::internal::FixedPattern_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::WildcardPatternDataView> {
  using Data = ::blink::mojom::internal::WildcardPattern_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::SafeUrlPatternPartDataView> {
  using Data = ::blink::mojom::internal::SafeUrlPatternPart_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::SafeUrlPatternOptionsDataView> {
  using Data = ::blink::mojom::internal::SafeUrlPatternOptions_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::PatternTemplateDataView> {
  using Data = ::blink::mojom::internal::PatternTemplate_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace blink::mojom {


enum class Modifier : int32_t {
  
  kZeroOrMore = 0,
  
  kOptional = 1,
  
  kOneOrMore = 2,
  
  kNone = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, Modifier value);
inline bool IsKnownEnumValue(Modifier value) {
  return internal::Modifier_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class SafeUrlPatternDataView {
 public:
  SafeUrlPatternDataView() = default;

  SafeUrlPatternDataView(
      internal::SafeUrlPattern_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetProtocolDataView(
      mojo::ArrayDataView<SafeUrlPatternPartDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadProtocol(UserType* output) {
    
    auto* pointer = data_->protocol.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::SafeUrlPatternPartDataView>>(
        pointer, output, message_);
  }
  inline void GetUsernameDataView(
      mojo::ArrayDataView<SafeUrlPatternPartDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUsername(UserType* output) {
    
    auto* pointer = data_->username.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::SafeUrlPatternPartDataView>>(
        pointer, output, message_);
  }
  inline void GetPasswordDataView(
      mojo::ArrayDataView<SafeUrlPatternPartDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPassword(UserType* output) {
    
    auto* pointer = data_->password.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::SafeUrlPatternPartDataView>>(
        pointer, output, message_);
  }
  inline void GetHostnameDataView(
      mojo::ArrayDataView<SafeUrlPatternPartDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHostname(UserType* output) {
    
    auto* pointer = data_->hostname.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::SafeUrlPatternPartDataView>>(
        pointer, output, message_);
  }
  inline void GetPortDataView(
      mojo::ArrayDataView<SafeUrlPatternPartDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPort(UserType* output) {
    
    auto* pointer = data_->port.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::SafeUrlPatternPartDataView>>(
        pointer, output, message_);
  }
  inline void GetPathnameDataView(
      mojo::ArrayDataView<SafeUrlPatternPartDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPathname(UserType* output) {
    
    auto* pointer = data_->pathname.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::SafeUrlPatternPartDataView>>(
        pointer, output, message_);
  }
  inline void GetSearchDataView(
      mojo::ArrayDataView<SafeUrlPatternPartDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSearch(UserType* output) {
    
    auto* pointer = data_->search.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::SafeUrlPatternPartDataView>>(
        pointer, output, message_);
  }
  inline void GetHashDataView(
      mojo::ArrayDataView<SafeUrlPatternPartDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHash(UserType* output) {
    
    auto* pointer = data_->hash.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::SafeUrlPatternPartDataView>>(
        pointer, output, message_);
  }
  inline void GetOptionsDataView(
      SafeUrlPatternOptionsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOptions(UserType* output) {
    
    auto* pointer = data_->options.Get();
    return mojo::internal::Deserialize<::blink::mojom::SafeUrlPatternOptionsDataView>(
        pointer, output, message_);
  }
 private:
  internal::SafeUrlPattern_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class FixedPatternDataView {
 public:
  FixedPatternDataView() = default;

  FixedPatternDataView(
      internal::FixedPattern_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetValueDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadValue(UserType* output) {
    
    auto* pointer = data_->value.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::FixedPattern_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class WildcardPatternDataView {
 public:
  WildcardPatternDataView() = default;

  WildcardPatternDataView(
      internal::WildcardPattern_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadName(UserType* output) {
    
    auto* pointer = data_->name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetPrefixDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPrefix(UserType* output) {
    
    auto* pointer = data_->prefix.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetValueDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadValue(UserType* output) {
    
    auto* pointer = data_->value.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetSuffixDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSuffix(UserType* output) {
    
    auto* pointer = data_->suffix.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::WildcardPattern_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class SafeUrlPatternPartDataView {
 public:
  SafeUrlPatternPartDataView() = default;

  SafeUrlPatternPartDataView(
      internal::SafeUrlPatternPart_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetPatternDataView(
      PatternTemplateDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPattern(UserType* output) {
    
    auto* pointer = !data_->pattern.is_null() ? &data_->pattern : nullptr;
    return mojo::internal::Deserialize<::blink::mojom::PatternTemplateDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadModifier(UserType* output) const {
    auto data_value = data_->modifier;
    return mojo::internal::Deserialize<::blink::mojom::Modifier>(
        data_value, output);
  }
  Modifier modifier() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::Modifier>(data_->modifier));
  }
 private:
  internal::SafeUrlPatternPart_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class SafeUrlPatternOptionsDataView {
 public:
  SafeUrlPatternOptionsDataView() = default;

  SafeUrlPatternOptionsDataView(
      internal::SafeUrlPatternOptions_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool ignore_case() const {
    return data_->ignore_case;
  }
 private:
  internal::SafeUrlPatternOptions_Data* data_ = nullptr;
};


class PatternTemplateDataView {
 public:
  using Tag = internal::PatternTemplate_Data::PatternTemplate_Tag;

  PatternTemplateDataView() = default;

  PatternTemplateDataView(
      internal::PatternTemplate_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_fixed() const { return data_->tag == Tag::kFixed; }
  inline void GetFixedDataView(
      FixedPatternDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadFixed(UserType* output) const {
    
    CHECK(is_fixed());
    return mojo::internal::Deserialize<::blink::mojom::FixedPatternDataView>(
        data_->data.f_fixed.Get(), output, message_);
  }
  bool is_full_wildcard() const { return data_->tag == Tag::kFullWildcard; }
  inline void GetFullWildcardDataView(
      WildcardPatternDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadFullWildcard(UserType* output) const {
    
    CHECK(is_full_wildcard());
    return mojo::internal::Deserialize<::blink::mojom::WildcardPatternDataView>(
        data_->data.f_full_wildcard.Get(), output, message_);
  }
  bool is_segment_wildcard() const { return data_->tag == Tag::kSegmentWildcard; }
  inline void GetSegmentWildcardDataView(
      WildcardPatternDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadSegmentWildcard(UserType* output) const {
    
    CHECK(is_segment_wildcard());
    return mojo::internal::Deserialize<::blink::mojom::WildcardPatternDataView>(
        data_->data.f_segment_wildcard.Get(), output, message_);
  }

 private:
  internal::PatternTemplate_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



}  // blink::mojom

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_SAFE_URL_PATTERN_MOJOM_DATA_VIEW_H_