// third_party/blink/public/mojom/safe_url_pattern.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/safe_url_pattern.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/safe_url_pattern.mojom-params-data.h"
#include "third_party/blink/public/mojom/safe_url_pattern.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/safe_url_pattern.mojom-blink-import-headers.h"
#include "third_party/blink/public/mojom/safe_url_pattern.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace blink::mojom::blink {
SafeUrlPattern::SafeUrlPattern()
    : protocol(),
      username(),
      password(),
      hostname(),
      port(),
      pathname(),
      search(),
      hash(),
      options() {}

SafeUrlPattern::SafeUrlPattern(
    ::blink::Vector<SafeUrlPatternPartPtr> protocol_in,
    ::blink::Vector<SafeUrlPatternPartPtr> username_in,
    ::blink::Vector<SafeUrlPatternPartPtr> password_in,
    ::blink::Vector<SafeUrlPatternPartPtr> hostname_in,
    ::blink::Vector<SafeUrlPatternPartPtr> port_in,
    ::blink::Vector<SafeUrlPatternPartPtr> pathname_in,
    ::blink::Vector<SafeUrlPatternPartPtr> search_in,
    ::blink::Vector<SafeUrlPatternPartPtr> hash_in,
    SafeUrlPatternOptionsPtr options_in)
    : protocol(std::move(protocol_in)),
      username(std::move(username_in)),
      password(std::move(password_in)),
      hostname(std::move(hostname_in)),
      port(std::move(port_in)),
      pathname(std::move(pathname_in)),
      search(std::move(search_in)),
      hash(std::move(hash_in)),
      options(std::move(options_in)) {}

SafeUrlPattern::~SafeUrlPattern() = default;

void SafeUrlPattern::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "protocol"), this->protocol,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::Vector<SafeUrlPatternPartPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "username"), this->username,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::Vector<SafeUrlPatternPartPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "password"), this->password,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::Vector<SafeUrlPatternPartPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "hostname"), this->hostname,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::Vector<SafeUrlPatternPartPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "port"), this->port,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::Vector<SafeUrlPatternPartPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "pathname"), this->pathname,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::Vector<SafeUrlPatternPartPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "search"), this->search,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::Vector<SafeUrlPatternPartPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "hash"), this->hash,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::Vector<SafeUrlPatternPartPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "options"), this->options,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type SafeUrlPatternOptionsPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SafeUrlPattern::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
FixedPattern::FixedPattern()
    : value() {}

FixedPattern::FixedPattern(
    const ::blink::String& value_in)
    : value(std::move(value_in)) {}

FixedPattern::~FixedPattern() = default;

void FixedPattern::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "value"), this->value,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool FixedPattern::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
WildcardPattern::WildcardPattern()
    : name(),
      prefix(),
      value(),
      suffix() {}

WildcardPattern::WildcardPattern(
    const ::blink::String& name_in,
    const ::blink::String& prefix_in,
    const ::blink::String& value_in,
    const ::blink::String& suffix_in)
    : name(std::move(name_in)),
      prefix(std::move(prefix_in)),
      value(std::move(value_in)),
      suffix(std::move(suffix_in)) {}

WildcardPattern::~WildcardPattern() = default;

void WildcardPattern::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "name"), this->name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "prefix"), this->prefix,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "value"), this->value,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "suffix"), this->suffix,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool WildcardPattern::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
SafeUrlPatternPart::SafeUrlPatternPart()
    : pattern(),
      modifier() {}

SafeUrlPatternPart::SafeUrlPatternPart(
    const ::liburlpattern::Part& pattern_in,
    ::liburlpattern::Modifier modifier_in)
    : pattern(std::move(pattern_in)),
      modifier(std::move(modifier_in)) {}

SafeUrlPatternPart::~SafeUrlPatternPart() = default;

void SafeUrlPatternPart::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "pattern"), this->pattern,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::liburlpattern::Part&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "modifier"), this->modifier,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::liburlpattern::Modifier>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SafeUrlPatternPart::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
SafeUrlPatternOptions::SafeUrlPatternOptions()
    : ignore_case(false) {}

SafeUrlPatternOptions::SafeUrlPatternOptions(
    bool ignore_case_in)
    : ignore_case(std::move(ignore_case_in)) {}

SafeUrlPatternOptions::~SafeUrlPatternOptions() = default;
size_t SafeUrlPatternOptions::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->ignore_case);
  return seed;
}

void SafeUrlPatternOptions::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "ignore_case"), this->ignore_case,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SafeUrlPatternOptions::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PatternTemplatePtr
PatternTemplate::NewFixed(
    const ::liburlpattern::Part& value) {
  return PatternTemplatePtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kFixed)>,
      std::move(value));
}

PatternTemplatePtr
PatternTemplate::NewFullWildcard(
    const ::liburlpattern::Part& value) {
  return PatternTemplatePtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kFullWildcard)>,
      std::move(value));
}

PatternTemplatePtr
PatternTemplate::NewSegmentWildcard(
    const ::liburlpattern::Part& value) {
  return PatternTemplatePtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kSegmentWildcard)>,
      std::move(value));
}

PatternTemplate::PatternTemplate(
    std::in_place_index_t<static_cast<size_t>(Tag::kFixed)>,
    const ::liburlpattern::Part& value)
    : tag_(Tag::kFixed),
      data_(std::in_place_index<static_cast<size_t>(Tag::kFixed)>,
            std::move(value)) {}

PatternTemplate::PatternTemplate(
    std::in_place_index_t<static_cast<size_t>(Tag::kFullWildcard)>,
    const ::liburlpattern::Part& value)
    : tag_(Tag::kFullWildcard),
      data_(std::in_place_index<static_cast<size_t>(Tag::kFullWildcard)>,
            std::move(value)) {}

PatternTemplate::PatternTemplate(
    std::in_place_index_t<static_cast<size_t>(Tag::kSegmentWildcard)>,
    const ::liburlpattern::Part& value)
    : tag_(Tag::kSegmentWildcard),
      data_(std::in_place_index<static_cast<size_t>(Tag::kSegmentWildcard)>,
            std::move(value)) {}
PatternTemplate::~PatternTemplate() {
  DestroyActive();
}

void PatternTemplate::set_fixed(const ::liburlpattern::Part& fixed) {
  if (tag_ == Tag::kFixed) {
    data_.fixed = std::move(fixed);
  } else {
    DestroyActive();
    tag_ = Tag::kFixed;
    new (&data_.fixed) ::liburlpattern::Part(
        std::move(fixed));
  }
}

void PatternTemplate::set_full_wildcard(const ::liburlpattern::Part& full_wildcard) {
  if (tag_ == Tag::kFullWildcard) {
    data_.full_wildcard = std::move(full_wildcard);
  } else {
    DestroyActive();
    tag_ = Tag::kFullWildcard;
    new (&data_.full_wildcard) ::liburlpattern::Part(
        std::move(full_wildcard));
  }
}

void PatternTemplate::set_segment_wildcard(const ::liburlpattern::Part& segment_wildcard) {
  if (tag_ == Tag::kSegmentWildcard) {
    data_.segment_wildcard = std::move(segment_wildcard);
  } else {
    DestroyActive();
    tag_ = Tag::kSegmentWildcard;
    new (&data_.segment_wildcard) ::liburlpattern::Part(
        std::move(segment_wildcard));
  }
}


PatternTemplate::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kFixed)>,
    const ::liburlpattern::Part& value)
    : fixed(std::move(value)) {}

PatternTemplate::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kFullWildcard)>,
    const ::liburlpattern::Part& value)
    : full_wildcard(std::move(value)) {}

PatternTemplate::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kSegmentWildcard)>,
    const ::liburlpattern::Part& value)
    : segment_wildcard(std::move(value)) {}

void PatternTemplate::DestroyActive() {
  switch (tag_) {

    case Tag::kFixed:
      std::destroy_at(&data_.fixed);
      break;
    case Tag::kFullWildcard:
      std::destroy_at(&data_.full_wildcard);
      break;
    case Tag::kSegmentWildcard:
      std::destroy_at(&data_.segment_wildcard);
      break;
  }
}

bool PatternTemplate::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}


}  // blink::mojom::blink


namespace mojo {


// static
bool StructTraits<::blink::mojom::blink::SafeUrlPattern::DataView, ::blink::mojom::blink::SafeUrlPatternPtr>::Read(
    ::blink::mojom::blink::SafeUrlPattern::DataView input,
    ::blink::mojom::blink::SafeUrlPatternPtr* output) {
  bool success = true;
  ::blink::mojom::blink::SafeUrlPatternPtr result(::blink::mojom::blink::SafeUrlPattern::New());
  
      if (success && !input.ReadProtocol(&result->protocol))
        success = false;
      if (success && !input.ReadUsername(&result->username))
        success = false;
      if (success && !input.ReadPassword(&result->password))
        success = false;
      if (success && !input.ReadHostname(&result->hostname))
        success = false;
      if (success && !input.ReadPort(&result->port))
        success = false;
      if (success && !input.ReadPathname(&result->pathname))
        success = false;
      if (success && !input.ReadSearch(&result->search))
        success = false;
      if (success && !input.ReadHash(&result->hash))
        success = false;
      if (success && !input.ReadOptions(&result->options))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::FixedPattern::DataView, ::blink::mojom::blink::FixedPatternPtr>::Read(
    ::blink::mojom::blink::FixedPattern::DataView input,
    ::blink::mojom::blink::FixedPatternPtr* output) {
  bool success = true;
  ::blink::mojom::blink::FixedPatternPtr result(::blink::mojom::blink::FixedPattern::New());
  
      if (success && !input.ReadValue(&result->value))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::WildcardPattern::DataView, ::blink::mojom::blink::WildcardPatternPtr>::Read(
    ::blink::mojom::blink::WildcardPattern::DataView input,
    ::blink::mojom::blink::WildcardPatternPtr* output) {
  bool success = true;
  ::blink::mojom::blink::WildcardPatternPtr result(::blink::mojom::blink::WildcardPattern::New());
  
      if (success && !input.ReadName(&result->name))
        success = false;
      if (success && !input.ReadPrefix(&result->prefix))
        success = false;
      if (success && !input.ReadValue(&result->value))
        success = false;
      if (success && !input.ReadSuffix(&result->suffix))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::SafeUrlPatternPart::DataView, ::blink::mojom::blink::SafeUrlPatternPartPtr>::Read(
    ::blink::mojom::blink::SafeUrlPatternPart::DataView input,
    ::blink::mojom::blink::SafeUrlPatternPartPtr* output) {
  bool success = true;
  ::blink::mojom::blink::SafeUrlPatternPartPtr result(::blink::mojom::blink::SafeUrlPatternPart::New());
  
      if (success && !input.ReadPattern(&result->pattern))
        success = false;
      if (success && !input.ReadModifier(&result->modifier))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::SafeUrlPatternOptions::DataView, ::blink::mojom::blink::SafeUrlPatternOptionsPtr>::Read(
    ::blink::mojom::blink::SafeUrlPatternOptions::DataView input,
    ::blink::mojom::blink::SafeUrlPatternOptionsPtr* output) {
  bool success = true;
  ::blink::mojom::blink::SafeUrlPatternOptionsPtr result(::blink::mojom::blink::SafeUrlPatternOptions::New());
  
      if (success)
        result->ignore_case = input.ignore_case();
  *output = std::move(result);
  return success;
}

// static
bool UnionTraits<::blink::mojom::blink::PatternTemplate::DataView, ::blink::mojom::blink::PatternTemplatePtr>::Read(
    ::blink::mojom::blink::PatternTemplate::DataView input,
    ::blink::mojom::blink::PatternTemplatePtr* output) {
  using UnionType = ::blink::mojom::blink::PatternTemplate;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kFixed: {
      ::liburlpattern::Part result_fixed{};
      if (!input.ReadFixed(&result_fixed))
        return false;

      *output = UnionType::NewFixed(
          std::move(result_fixed));
      break;
    }
    case Tag::kFullWildcard: {
      ::liburlpattern::Part result_full_wildcard{};
      if (!input.ReadFullWildcard(&result_full_wildcard))
        return false;

      *output = UnionType::NewFullWildcard(
          std::move(result_full_wildcard));
      break;
    }
    case Tag::kSegmentWildcard: {
      ::liburlpattern::Part result_segment_wildcard{};
      if (!input.ReadSegmentWildcard(&result_segment_wildcard))
        return false;

      *output = UnionType::NewSegmentWildcard(
          std::move(result_segment_wildcard));
      break;
    }
    default:

      return false;
  }
  return true;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace blink::mojom::blink {




}  // blink::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif