// third_party/blink/public/mojom/renderer_preferences.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_RENDERER_PREFERENCES_MOJOM_SEND_VALIDATION_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_RENDERER_PREFERENCES_MOJOM_SEND_VALIDATION_H_

#include "third_party/blink/public/mojom/renderer_preferences.mojom-shared-internal.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "third_party/blink/public/mojom/peerconnection/webrtc_ip_handling_policy.mojom-shared.h"
#include "third_party/blink/public/mojom/user_agent/user_agent_metadata.mojom-shared.h"
#include "ui/gfx/mojom/font_render_params.mojom-shared.h"
#include "third_party/blink/public/mojom/peerconnection/webrtc_ip_handling_url_entry.mojom-shared.h"

#include "third_party/blink/public/mojom/renderer_preferences.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"

namespace mojo::internal {

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::blink::mojom::RendererPreferencesDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::RendererPreferencesDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::RendererPreferences_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->can_accept_load_drops = Traits::can_accept_load_drops(input);

      fragment->should_antialias_text = Traits::should_antialias_text(input);

      
      mojo::internal::Serialize<::gfx::mojom::Hinting>(
        Traits::hinting(input),
        &fragment->hinting);

      fragment->use_autohinter = Traits::use_autohinter(input);

      fragment->use_bitmaps = Traits::use_bitmaps(input);

      
      mojo::internal::Serialize<::gfx::mojom::SubpixelRendering>(
        Traits::subpixel_rendering(input),
        &fragment->subpixel_rendering);

      fragment->use_subpixel_positioning = Traits::use_subpixel_positioning(input);

      fragment->focus_ring_color = Traits::focus_ring_color(input);

      fragment->active_selection_bg_color = Traits::active_selection_bg_color(input);

      fragment->active_selection_fg_color = Traits::active_selection_fg_color(input);

      fragment->inactive_selection_bg_color = Traits::inactive_selection_bg_color(input);

      fragment->inactive_selection_fg_color = Traits::inactive_selection_fg_color(input);

      fragment->browser_handles_all_top_level_requests = Traits::browser_handles_all_top_level_requests(input);

      decltype(Traits::caret_blink_interval(input)) in_caret_blink_interval = Traits::caret_blink_interval(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->caret_blink_interval)::BaseType> caret_blink_interval_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView, send_validation>(
        in_caret_blink_interval,
        caret_blink_interval_fragment);

      fragment->caret_blink_interval.Set(
          caret_blink_interval_fragment.is_null() ? nullptr : caret_blink_interval_fragment.data());

      fragment->use_custom_colors = Traits::use_custom_colors(input);

      fragment->enable_referrers = Traits::enable_referrers(input);

      fragment->allow_cross_origin_auth_prompt = Traits::allow_cross_origin_auth_prompt(input);

      fragment->enable_do_not_track = Traits::enable_do_not_track(input);

      fragment->enable_encrypted_media = Traits::enable_encrypted_media(input);

      
      mojo::internal::Serialize<::blink::mojom::WebRtcIpHandlingPolicy>(
        Traits::webrtc_ip_handling_policy(input),
        &fragment->webrtc_ip_handling_policy);

      decltype(Traits::webrtc_ip_handling_urls(input)) in_webrtc_ip_handling_urls = Traits::webrtc_ip_handling_urls(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->webrtc_ip_handling_urls)::BaseType>
          webrtc_ip_handling_urls_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& webrtc_ip_handling_urls_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::WebRtcIpHandlingUrlEntryDataView>, send_validation>(
        in_webrtc_ip_handling_urls,
        webrtc_ip_handling_urls_fragment,
        &webrtc_ip_handling_urls_validate_params);

      fragment->webrtc_ip_handling_urls.Set(
          webrtc_ip_handling_urls_fragment.is_null() ? nullptr : webrtc_ip_handling_urls_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->webrtc_ip_handling_urls.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null webrtc_ip_handling_urls in RendererPreferences struct");
      fragment->webrtc_post_quantum_key_agreement_$flag = Traits::webrtc_post_quantum_key_agreement(input).has_value();
      if (Traits::webrtc_post_quantum_key_agreement(input).has_value()) {
        fragment->webrtc_post_quantum_key_agreement_$value = Traits::webrtc_post_quantum_key_agreement(input).value();
      }

      fragment->webrtc_udp_min_port = Traits::webrtc_udp_min_port(input);

      fragment->webrtc_udp_max_port = Traits::webrtc_udp_max_port(input);

      decltype(Traits::webrtc_local_ips_allowed_urls(input)) in_webrtc_local_ips_allowed_urls = Traits::webrtc_local_ips_allowed_urls(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->webrtc_local_ips_allowed_urls)::BaseType>
          webrtc_local_ips_allowed_urls_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& webrtc_local_ips_allowed_urls_validate_params =
          mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>, send_validation>(
        in_webrtc_local_ips_allowed_urls,
        webrtc_local_ips_allowed_urls_fragment,
        &webrtc_local_ips_allowed_urls_validate_params);

      fragment->webrtc_local_ips_allowed_urls.Set(
          webrtc_local_ips_allowed_urls_fragment.is_null() ? nullptr : webrtc_local_ips_allowed_urls_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->webrtc_local_ips_allowed_urls.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null webrtc_local_ips_allowed_urls in RendererPreferences struct");

      decltype(Traits::user_agent_override(input)) in_user_agent_override = Traits::user_agent_override(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->user_agent_override)::BaseType> user_agent_override_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::blink::mojom::UserAgentOverrideDataView, send_validation>(
        in_user_agent_override,
        user_agent_override_fragment);

      fragment->user_agent_override.Set(
          user_agent_override_fragment.is_null() ? nullptr : user_agent_override_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->user_agent_override.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null user_agent_override in RendererPreferences struct");

      decltype(Traits::accept_languages(input)) in_accept_languages = Traits::accept_languages(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->accept_languages)::BaseType> accept_languages_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_accept_languages,
        accept_languages_fragment);

      fragment->accept_languages.Set(
          accept_languages_fragment.is_null() ? nullptr : accept_languages_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->accept_languages.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null accept_languages in RendererPreferences struct");

      fragment->send_subresource_notification = Traits::send_subresource_notification(input);

      fragment->plugin_fullscreen_allowed = Traits::plugin_fullscreen_allowed(input);

      fragment->caret_browsing_enabled = Traits::caret_browsing_enabled(input);

      decltype(Traits::explicitly_allowed_network_ports(input)) in_explicitly_allowed_network_ports = Traits::explicitly_allowed_network_ports(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->explicitly_allowed_network_ports)::BaseType>
          explicitly_allowed_network_ports_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& explicitly_allowed_network_ports_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<uint16_t>, send_validation>(
        in_explicitly_allowed_network_ports,
        explicitly_allowed_network_ports_fragment,
        &explicitly_allowed_network_ports_validate_params);

      fragment->explicitly_allowed_network_ports.Set(
          explicitly_allowed_network_ports_fragment.is_null() ? nullptr : explicitly_allowed_network_ports_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->explicitly_allowed_network_ports.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null explicitly_allowed_network_ports in RendererPreferences struct");

      fragment->view_source_line_wrap_enabled = Traits::view_source_line_wrap_enabled(input);
  }
};

}  // namespace mojo::internal

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_RENDERER_PREFERENCES_MOJOM_SEND_VALIDATION_H_