// third_party/blink/public/mojom/renderer_preference_watcher.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../mojo/public/js/bindings.js';

import {
  RendererPreferences as blink_mojom_RendererPreferences,
  RendererPreferencesSpec as blink_mojom_RendererPreferencesSpec
} from './renderer_preferences.mojom.m.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class RendererPreferenceWatcherPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.RendererPreferenceWatcher', scope);
  }
}

/** @interface */
export class RendererPreferenceWatcherInterface {
  
  /**
   * @param { !blink_mojom_RendererPreferences } newPrefs
   */

  notifyUpdate(newPrefs) {}
}

/**
 * @implements { RendererPreferenceWatcherInterface }
 */
export class RendererPreferenceWatcherRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!RendererPreferenceWatcherPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          RendererPreferenceWatcherPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!RendererPreferenceWatcherPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !blink_mojom_RendererPreferences } newPrefs
   */

  notifyUpdate(
      newPrefs) {
    this.proxy.sendMessage(
        0,
        RendererPreferenceWatcher_NotifyUpdate_ParamsSpec.$,
        null,
        [
          newPrefs
        ],
        false);
  }
}

/**
 * An object which receives request messages for the RendererPreferenceWatcher
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class RendererPreferenceWatcherReceiver {
  /**
   * @param {!RendererPreferenceWatcherInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!RendererPreferenceWatcherRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        RendererPreferenceWatcherRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!RendererPreferenceWatcherRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        RendererPreferenceWatcher_NotifyUpdate_ParamsSpec.$,
        null,
        impl.notifyUpdate.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class RendererPreferenceWatcher {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.RendererPreferenceWatcher";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!RendererPreferenceWatcherRemote}
   */
  static getRemote() {
    let remote = new RendererPreferenceWatcherRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the RendererPreferenceWatcher
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class RendererPreferenceWatcherCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      RendererPreferenceWatcherRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!RendererPreferenceWatcherRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.notifyUpdate =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        RendererPreferenceWatcher_NotifyUpdate_ParamsSpec.$,
        null,
        this.notifyUpdate.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const RendererPreferenceWatcher_NotifyUpdate_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    RendererPreferenceWatcher_NotifyUpdate_ParamsSpec.$,
    'RendererPreferenceWatcher_NotifyUpdate_Params',
    [
      mojo.internal.StructField(
        'newPrefs', 0,
        0,
        blink_mojom_RendererPreferencesSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class RendererPreferenceWatcher_NotifyUpdate_Params {
  constructor() {
    /** @type { !blink_mojom_RendererPreferences } */
    this.newPrefs;
  }
}

