// third_party/blink/public/mojom/render_accessibility.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_RENDER_ACCESSIBILITY_MOJOM_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_RENDER_ACCESSIBILITY_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/render_accessibility.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/render_accessibility.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/render_accessibility.mojom-forward.h"  // IWYU pragma: export
#include "ui/accessibility/ax_enums.mojom-forward.h"
#include "ui/accessibility/mojom/ax_action_data.mojom.h"
#include "ui/accessibility/mojom/ax_event.mojom-forward.h"
#include "ui/accessibility/mojom/ax_mode.mojom.h"
#include "ui/accessibility/mojom/ax_relative_bounds.mojom-forward.h"
#include "ui/accessibility/mojom/ax_tree_id.mojom.h"
#include "ui/accessibility/mojom/ax_tree_update.mojom-forward.h"
#include "ui/accessibility/mojom/ax_updates_and_events.mojom.h"
#include "ui/accessibility/mojom/ax_location_and_scroll_updates.mojom.h"
#include "ui/gfx/geometry/mojom/geometry.mojom.h"
#include "third_party/blink/public/mojom/tokens/tokens.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "third_party/blink/public/common/common_export.h"




namespace blink::mojom {

class RenderAccessibilityHostProxy;

template <typename ImplRefTraits>
class RenderAccessibilityHostStub;

class RenderAccessibilityHostRequestValidator;
class RenderAccessibilityHostResponseValidator;


class BLINK_COMMON_EXPORT RenderAccessibilityHost
    : public RenderAccessibilityHostInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "blink.mojom.RenderAccessibilityHost";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = RenderAccessibilityHostInterfaceBase;
  using Proxy_ = RenderAccessibilityHostProxy;

  template <typename ImplRefTraits>
  using Stub_ = RenderAccessibilityHostStub<ImplRefTraits>;

  using RequestValidator_ = RenderAccessibilityHostRequestValidator;
  using ResponseValidator_ = RenderAccessibilityHostResponseValidator;
  enum MethodMinVersions : uint32_t {
    kHandleAXEventsMinVersion = 0,
    kHandleAXLocationChangesMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct HandleAXEvents_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct HandleAXLocationChanges_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~RenderAccessibilityHost() = default;

  using HandleAXEventsCallback = base::OnceCallback<void()>;
  using HandleAXEventsMojoCallback = base::OnceCallback<void()>;

  virtual void HandleAXEvents(const ::ui::AXUpdatesAndEvents& events_and_updates, const ::ui::AXLocationAndScrollUpdates& location_and_scroll_updates, uint32_t reset_token, HandleAXEventsCallback callback) = 0;
  // Default implementation for non-const ref params. This method can be
  // implemented as a performance optimization for non-const ref types.
  virtual void HandleAXEvents(::ui::AXUpdatesAndEvents& events_and_updates, ::ui::AXLocationAndScrollUpdates& location_and_scroll_updates, uint32_t reset_token, HandleAXEventsCallback callback) {
    HandleAXEvents(const_cast<const ::ui::AXUpdatesAndEvents&>(events_and_updates), const_cast<const ::ui::AXLocationAndScrollUpdates&>(location_and_scroll_updates), std::move(reset_token), std::move(callback));
  }

  virtual void HandleAXLocationChanges(const ::ui::AXLocationAndScrollUpdates& changes, uint32_t reset_token) = 0;
  // Default implementation for non-const ref params. This method can be
  // implemented as a performance optimization for non-const ref types.
  virtual void HandleAXLocationChanges(::ui::AXLocationAndScrollUpdates& changes, uint32_t reset_token) {
    HandleAXLocationChanges(const_cast<const ::ui::AXLocationAndScrollUpdates&>(changes), std::move(reset_token));
  }
};

class RenderAccessibilityProxy;

template <typename ImplRefTraits>
class RenderAccessibilityStub;

class RenderAccessibilityRequestValidator;
class RenderAccessibilityResponseValidator;


class BLINK_COMMON_EXPORT RenderAccessibility
    : public RenderAccessibilityInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "blink.mojom.RenderAccessibility";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = RenderAccessibilityInterfaceBase;
  using Proxy_ = RenderAccessibilityProxy;

  template <typename ImplRefTraits>
  using Stub_ = RenderAccessibilityStub<ImplRefTraits>;

  using RequestValidator_ = RenderAccessibilityRequestValidator;
  using ResponseValidator_ = RenderAccessibilityResponseValidator;
  enum MethodMinVersions : uint32_t {
    kSetModeMinVersion = 0,
    kFatalErrorMinVersion = 0,
    kHitTestMinVersion = 0,
    kPerformActionMinVersion = 0,
    kResetMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct SetMode_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct FatalError_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct HitTest_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct PerformAction_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Reset_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~RenderAccessibility() = default;

  virtual void SetMode(const ::ui::AXMode& ax_mode, uint32_t reset_token) = 0;

  virtual void FatalError() = 0;

  using HitTestCallback = base::OnceCallback<void(HitTestResponsePtr)>;
  using HitTestMojoCallback = base::OnceCallback<void(HitTestResponsePtr)>;

  virtual void HitTest(const ::gfx::Point& point, ::ax::mojom::Event event_to_fire, int32_t request_id, HitTestCallback callback) = 0;

  virtual void PerformAction(const ::ui::AXActionData& action_data) = 0;

  virtual void Reset(uint32_t reset_token) = 0;
};



class BLINK_COMMON_EXPORT RenderAccessibilityHostProxy
    : public RenderAccessibilityHost {
 public:
  using InterfaceType = RenderAccessibilityHost;

  explicit RenderAccessibilityHostProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void HandleAXEvents(const ::ui::AXUpdatesAndEvents& events_and_updates, const ::ui::AXLocationAndScrollUpdates& location_and_scroll_updates, uint32_t reset_token, HandleAXEventsCallback callback) final;
  
  void HandleAXLocationChanges(const ::ui::AXLocationAndScrollUpdates& changes, uint32_t reset_token) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class BLINK_COMMON_EXPORT RenderAccessibilityProxy
    : public RenderAccessibility {
 public:
  using InterfaceType = RenderAccessibility;

  explicit RenderAccessibilityProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void SetMode(const ::ui::AXMode& ax_mode, uint32_t reset_token) final;
  
  void FatalError() final;
  
  void HitTest(const ::gfx::Point& point, ::ax::mojom::Event event_to_fire, int32_t request_id, HitTestCallback callback) final;
  
  void PerformAction(const ::ui::AXActionData& action_data) final;
  
  void Reset(uint32_t reset_token) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class BLINK_COMMON_EXPORT RenderAccessibilityHostStubDispatch {
 public:
  static bool Accept(RenderAccessibilityHost* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      RenderAccessibilityHost* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<RenderAccessibilityHost>>
class RenderAccessibilityHostStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  RenderAccessibilityHostStub() = default;
  ~RenderAccessibilityHostStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return RenderAccessibilityHostStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return RenderAccessibilityHostStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_COMMON_EXPORT RenderAccessibilityStubDispatch {
 public:
  static bool Accept(RenderAccessibility* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      RenderAccessibility* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<RenderAccessibility>>
class RenderAccessibilityStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  RenderAccessibilityStub() = default;
  ~RenderAccessibilityStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return RenderAccessibilityStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return RenderAccessibilityStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_COMMON_EXPORT RenderAccessibilityHostRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_COMMON_EXPORT RenderAccessibilityRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_COMMON_EXPORT RenderAccessibilityHostResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_COMMON_EXPORT RenderAccessibilityResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};








class BLINK_COMMON_EXPORT HitTestResponse {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<HitTestResponse, T>::value>;
  using DataView = HitTestResponseDataView;
  using Data_ = internal::HitTestResponse_Data;

  template <typename... Args>
  static HitTestResponsePtr New(Args&&... args) {
    return HitTestResponsePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static HitTestResponsePtr From(const U& u) {
    return mojo::TypeConverter<HitTestResponsePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, HitTestResponse>::Convert(*this);
  }


  HitTestResponse();

  HitTestResponse(
      const ::ui::AXTreeID& stitched_child_tree_id,
      const ::blink::FrameToken& hit_frame_token,
      const ::gfx::Point& hit_frame_transformed_point,
      int32_t hit_node_id);


  ~HitTestResponse();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = HitTestResponsePtr>
  HitTestResponsePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, HitTestResponse::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, HitTestResponse::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, HitTestResponse::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        HitTestResponse::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        HitTestResponse::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        HitTestResponse::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::HitTestResponse_UnserializedMessageContext<
            UserType, HitTestResponse::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<HitTestResponse::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return HitTestResponse::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::HitTestResponse_UnserializedMessageContext<
            UserType, HitTestResponse::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<HitTestResponse::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::ui::AXTreeID stitched_child_tree_id;
  
  ::blink::FrameToken hit_frame_token;
  
  ::gfx::Point hit_frame_transformed_point;
  
  int32_t hit_node_id;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, HitTestResponse::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, HitTestResponse::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, HitTestResponse::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, HitTestResponse::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
HitTestResponsePtr HitTestResponse::Clone() const {
  return New(
      mojo::Clone(stitched_child_tree_id),
      mojo::Clone(hit_frame_token),
      mojo::Clone(hit_frame_transformed_point),
      mojo::Clone(hit_node_id)
  );
}

template <typename T, HitTestResponse::EnableIfSame<T>*>
bool HitTestResponse::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->stitched_child_tree_id, other_struct.stitched_child_tree_id))
    return false;
  if (!mojo::Equals(this->hit_frame_token, other_struct.hit_frame_token))
    return false;
  if (!mojo::Equals(this->hit_frame_transformed_point, other_struct.hit_frame_transformed_point))
    return false;
  if (!mojo::Equals(this->hit_node_id, other_struct.hit_node_id))
    return false;
  return true;
}

template <typename T, HitTestResponse::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.stitched_child_tree_id < rhs.stitched_child_tree_id)
    return true;
  if (rhs.stitched_child_tree_id < lhs.stitched_child_tree_id)
    return false;
  if (lhs.hit_frame_token < rhs.hit_frame_token)
    return true;
  if (rhs.hit_frame_token < lhs.hit_frame_token)
    return false;
  if (lhs.hit_frame_transformed_point < rhs.hit_frame_transformed_point)
    return true;
  if (rhs.hit_frame_transformed_point < lhs.hit_frame_transformed_point)
    return false;
  if (lhs.hit_node_id < rhs.hit_node_id)
    return true;
  if (rhs.hit_node_id < lhs.hit_node_id)
    return false;
  return false;
}


}  // blink::mojom

namespace mojo {


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::HitTestResponse::DataView,
                                         ::blink::mojom::HitTestResponsePtr> {
  static bool IsNull(const ::blink::mojom::HitTestResponsePtr& input) { return !input; }
  static void SetToNull(::blink::mojom::HitTestResponsePtr* output) { output->reset(); }

  static const decltype(::blink::mojom::HitTestResponse::stitched_child_tree_id)& stitched_child_tree_id(
      const ::blink::mojom::HitTestResponsePtr& input) {
    return input->stitched_child_tree_id;
  }

  static const decltype(::blink::mojom::HitTestResponse::hit_frame_token)& hit_frame_token(
      const ::blink::mojom::HitTestResponsePtr& input) {
    return input->hit_frame_token;
  }

  static const decltype(::blink::mojom::HitTestResponse::hit_frame_transformed_point)& hit_frame_transformed_point(
      const ::blink::mojom::HitTestResponsePtr& input) {
    return input->hit_frame_transformed_point;
  }

  static decltype(::blink::mojom::HitTestResponse::hit_node_id) hit_node_id(
      const ::blink::mojom::HitTestResponsePtr& input) {
    return input->hit_node_id;
  }

  static bool Read(::blink::mojom::HitTestResponse::DataView input, ::blink::mojom::HitTestResponsePtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_RENDER_ACCESSIBILITY_MOJOM_H_